/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc2.tds;

import com.sybase.jdbc2.utils.Debug;
import com.sybase.jdbc2.utils.JavaVersion;

public class Iana {
    protected static final String UNSUPPORTED_CHARSET = "UnsupportedCharset";
    private static String[][] _IANA_MAP = new String[][]{{"iso_1", "8859_1"}, {"ascii_7", "8859_1"}, {"cp1252", "Cp1252"}, {"cp850", "Cp850"}, {"cp437", "Cp437"}, {"mac", "Macroman"}, {"roman8", "hp-roman8"}, {"unknown", null}, {"cp037", "Cp037"}, {"big5", "Big5"}, {"iso88592", "8859_2"}, {"iso88595", "8859_5"}, {"iso88596", "8859_6"}, {"iso88597", "8859_7"}, {"iso88598", "8859_8"}, {"iso88599", "8859_9"}, {"iso15", "ISO8859_15_FDIS"}, {"cp852", "Cp852"}, {"ibm420", "Cp420"}, {"cp500", "Cp500"}, {"cp855", "Cp855"}, {"cp857", "Cp857"}, {"cp860", "Cp860"}, {"cp863", "Cp863"}, {"cp864", "Cp864"}, {"cp869", "Cp869"}, {"ibm918", "Cp918"}, {"koi8", "KOI8_R"}, {"cp866", "Cp866"}, {"cp1250", "Cp1250"}, {"cp1251", "Cp1251"}, {"cp1253", "Cp1253"}, {"cp1254", "Cp1254"}, {"cp1255", "Cp1255"}, {"cp1256", "Cp1256"}, {"cp1257", "Cp1257"}, {"cp1258", "Cp1258"}, {"cp874", "Cp874"}, {"tis620", "MS874"}, {"mac_cyr", "MacCyrillic"}, {"mac_ee", "MacCentralEurope"}, {"macgreek", "MacGreek"}, {"macturk", "MacTurkish"}, {"sjis", "SJIS"}, {"eucjis", "EUCJIS"}, {"deckanji", "EUCJIS"}, {"utf8", "UTF8"}, {"cp932", "MS932"}, {"cp936", "GBK"}, {"eucgb", "GB2312"}, {"eucksc", "KSC5601"}, {"cp950", "Cp950"}, {"cp949", "Cp949"}, {"euccns", "CNS11643"}, {"ucs2", "Unicode"}};

    static {
        if (JavaVersion.atOrAboveVersion("1.1.8")) {
            int i = 0;
            while (i < _IANA_MAP.length) {
                if (_IANA_MAP[i][0].equals("cp932")) {
                    Iana._IANA_MAP[i][1] = "MS932";
                    break;
                }
                ++i;
            }
        }
    }

    public static String lookupIana(String sybcharset) {
        return Iana.lookupIana("syb", sybcharset);
    }

    public static String lookupIana(String type, String sybcharset) {
        int checkcol = type.equals("java") ? 1 : 0;
        int row = 0;
        while (row < _IANA_MAP.length) {
            if (sybcharset.equals(_IANA_MAP[row][checkcol])) {
                String ianaMapName = _IANA_MAP[row][checkcol == 0 ? checkcol + 1 : checkcol - 1];
                Debug.println(null, String.valueOf(type) + " charset " + sybcharset + " mapped to " + (type.equals("java") ? "syb" : "IANA ") + "charset name " + ianaMapName);
                return ianaMapName;
            }
            ++row;
        }
        return UNSUPPORTED_CHARSET;
    }

    public static boolean truncationConversionOK(String sybcharset) {
        int row = 0;
        while (row < _IANA_MAP.length) {
            if (sybcharset.equals(_IANA_MAP[row][0])) {
                return true;
            }
            if ("cp037".equals(_IANA_MAP[row][0])) break;
            ++row;
        }
        return false;
    }
}

