/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc2.jdbc;

import com.sybase.jdbc2.jdbc.Capture;
import com.sybase.jdbc2.utils.Debug;
import java.io.IOException;
import java.io.InputStream;

public class TraceInputStream
extends InputStream {
    private InputStream _in;
    private Capture _cap;
    private int _state;

    TraceInputStream(Capture cap, InputStream in, int initialState) {
        Debug.println(this, "Constructor TraceInputStream()");
        this._cap = cap;
        this._in = in;
        Debug.assert(this, initialState == 2 || initialState == 1);
        this._state = initialState;
    }

    public int read() throws IOException {
        Debug.assert(this, false);
        byte[] b = new byte[1];
        int x = this.read(b, 0, 1);
        return x == -1 ? x : b[0];
    }

    public int read(byte[] b) throws IOException {
        Debug.println(this, "TraceInputStream.read(b)");
        return this.read(b, 0, b.length);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        Debug.println(this, "TraceInputStream.read(b, " + off + ", " + len + ")");
        int x = this._in.read(b, off, len);
        if (x != -1 && this._state == 2) {
            this._cap.writeBuffer(2, b, off, x);
        }
        return x;
    }

    protected void setState(int newState) {
        Debug.println(this, "TraceInputStream.setState(" + newState + ")");
        this._state = newState;
    }
}

