/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc2.jdbc;

import com.sybase.jdbc2.utils.Debug;
import com.sybase.jdbc2.utils.HexConverts;
import javax.transaction.xa.Xid;

public class SybXid
implements Xid {
    private final int _formatID;
    private final byte[] _gtrid;
    private final byte[] _bqual;

    public SybXid(int format, byte[] gtrid, byte[] bqual) {
        this._formatID = format;
        Debug.assert(this, gtrid.length <= 64, "gtrid is larger than 64 bytes; it's " + gtrid.length);
        this._gtrid = new byte[Math.min(gtrid.length, 64)];
        System.arraycopy(gtrid, 0, this._gtrid, 0, this._gtrid.length);
        Debug.assert(null, bqual.length <= 64, "bqual is larger than 64 bytes; it's " + bqual.length);
        this._bqual = new byte[Math.min(bqual.length, 64)];
        System.arraycopy(bqual, 0, this._bqual, 0, this._bqual.length);
        Debug.println(this, "SybXid() completed");
    }

    public boolean equals(Object obj) {
        Debug.println(this, "equals(" + obj + ")");
        if (!(obj instanceof Xid)) {
            return false;
        }
        Xid xid = (Xid)obj;
        if (xid.getFormatId() != this._formatID) {
            Debug.println(this, "format id's aren't equal.");
            return false;
        }
        byte[] gtrid = xid.getGlobalTransactionId();
        if (gtrid.length != this._gtrid.length) {
            Debug.println(this, "gtrid lengths aren't equal.");
            return false;
        }
        byte[] bqual = xid.getBranchQualifier();
        if (bqual.length != this._bqual.length) {
            Debug.println(this, "bqual lengths aren't equal.");
            return false;
        }
        int i = 0;
        while (i < this._gtrid.length) {
            if (gtrid[i] != this._gtrid[i]) {
                Debug.println(this, "gtrids differ at byte " + i);
                return false;
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < this._bqual.length) {
            if (bqual[i2] != this._bqual[i2]) {
                Debug.println(this, "bquals differ at byte " + i2);
                return false;
            }
            ++i2;
        }
        return true;
    }

    public byte[] getBranchQualifier() {
        Debug.println(this, "getBranchQualifier() returning 0x" + HexConverts.hexConvert(this._bqual));
        byte[] returnValue = new byte[this._bqual.length];
        System.arraycopy(this._bqual, 0, returnValue, 0, this._bqual.length);
        return returnValue;
    }

    public int getFormatId() {
        Debug.println(this, "getFormatId() returns " + this._formatID);
        return this._formatID;
    }

    public byte[] getGlobalTransactionId() {
        Debug.println(this, "getGlobalTransactionId() returning 0x" + HexConverts.hexConvert(this._gtrid));
        byte[] returnValue = new byte[this._gtrid.length];
        System.arraycopy(this._gtrid, 0, returnValue, 0, this._gtrid.length);
        return returnValue;
    }
}

