/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc2.jdbc;

import com.sybase.jdbc2.jdbc.ErrorMessage;
import com.sybase.jdbc2.jdbc.MdaManager;
import com.sybase.jdbc2.jdbc.SybConnection;
import com.sybase.jdbc2.utils.Debug;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;

public class SybDatabaseMetaData
implements DatabaseMetaData {
    private SybConnection _conn;
    private MdaManager _mda;
    private int _outerJoinEscapeSupport;
    private int _isCaseSensitive;
    protected static final int UNKNOWN = -1;
    protected static final int NO = 0;
    protected static final int YES = 1;
    private static final String JAVA_OBJECT_NAME = "JAVA_OBJECT";
    private static final String STRUCT_NAME = "STRUCT";
    private static final String DISTINCT_NAME = "DISTINCT";
    private static final String TABLES = "TABLES";
    private static final String COLUMNS = "COLUMNS";
    private static final String ALLPROCSCALLABLE = "ALLPROCSCALLABLE";
    private static final String ALLTABLESSELECTABLE = "ALLTABLESSELECTABLE";
    private static final String ISREADONLY = "ISREADONLY";
    private static final String NULLSORTING = "NULLSORTING";
    private static final String USERNAME = "USERNAME";
    private static final String PRODUCTNAME = "PRODUCTNAME";
    private static final String PRODUCTVERSION = "PRODUCTVERSION";
    private static final String FILEUSAGE = "FILEUSAGE";
    private static final String IDENTIFIERCASES = "IDENTIFIERCASES";
    private static final String IDENTIFIERQUOTE = "IDENTIFIERQUOTE";
    private static final String SQLKEYWORDS = "SQLKEYWORDS";
    private static final String NUMERICFUNCTIONLIST = "NUMERICFUNCTIONLIST";
    private static final String STRINGFUNCTIONLIST = "STRINGFUNCTIONLIST";
    private static final String SYSTEMFUNCTIONLIST = "SYSTEMFUNCTIONLIST";
    private static final String TIMEDATEFUNCTIONLIST = "TIMEDATEFUNCTIONLIST";
    private static final String SEARCHSTRING = "SEARCHSTRING";
    private static final String EXTRANAMECHARS = "EXTRANAMECHARS";
    private static final String ALTERTABLESUPPORT = "ALTERTABLESUPPORT";
    private static final String COLUMNALIASING = "COLUMNALIASING";
    private static final String NULLPLUSNONNULL = "NULLPLUSNONNULL";
    private static final String CONVERTSUPPORT = "CONVERTSUPPORT";
    private static final String CONVERTMAP = "CONVERTMAP";
    private static final String CORRELATIONNAMES = "CORRELATIONNAMES";
    private static final String ORDERBYSUPPORT = "ORDERBYSUPPORT";
    private static final String GROUPBYSUPPORT = "GROUPBYSUPPORT";
    private static final String LIKEESCAPECLAUSE = "LIKEESCAPECLAUSE";
    private static final String MULTIPLERESULTSETS = "MULTIPLERESULTSETS";
    private static final String MULTIPLETRANSACTIONS = "MULTIPLETRANSACTIONS";
    private static final String NONNULLABLECOLUMNS = "NONNULLABLECOLUMNS";
    private static final String SQLGRAMMAR = "SQLGRAMMAR";
    private static final String ANSI92LEVEL = "ANSI92LEVEL";
    private static final String INTEGRITYENHANCEMENT = "INTEGRITYENHANCEMENT";
    private static final String OUTERJOINS = "OUTERJOINS";
    private static final String SCHEMATERM = "SCHEMATERM";
    private static final String PROCEDURETERM = "PROCEDURETERM";
    private static final String CATALOGTERM = "CATALOGTERM";
    private static final String CATALOGSEPARATOR = "CATALOGSEPARATOR";
    private static final String CATALOGATSTART = "CATALOGATSTART";
    private static final String SCHEMASUPPORT = "SCHEMASUPPORT";
    private static final String CATALOGSUPPORT = "CATALOGSUPPORT";
    private static final String POSITIONEDDELETE = "POSITIONEDDELETE";
    private static final String POSITIONEDUPDATE = "POSITIONEDUPDATE";
    private static final String SELECTFORUPDATE = "SELECTFORUPDATE";
    private static final String STOREDPROCEDURES = "STOREDPROCEDURES";
    private static final String SUBQUERIES = "SUBQUERIES";
    private static final String UNIONSUPPORT = "UNIONSUPPORT";
    private static final String CURSORTRANSACTIONS = "CURSORTRANSACTIONS";
    private static final String STATEMENTTRANSACTIONS = "STATEMENTTRANSACTIONS";
    private static final String MAXBINARYLITERALLENGTH = "MAXBINARYLITERALLENGTH";
    private static final String MAXCHARLITERALLENGTH = "MAXCHARLITERALLENGTH";
    private static final String COLUMNINFO = "COLUMNINFO";
    private static final String MAXCONNECTIONS = "MAXCONNECTIONS";
    private static final String MAXINDEXLENGTH = "MAXINDEXLENGTH";
    private static final String MAXNAMELENGTHS = "MAXNAMELENGTHS";
    private static final String ROWINFO = "ROWINFO";
    private static final String STATEMENTINFO = "STATEMENTINFO";
    private static final String TABLEINFO = "TABLEINFO";
    private static final String TRANSACTIONSUPPORT = "TRANSACTIONSUPPORT";
    private static final String TRANSACTIONLEVELDEFAULT = "TRANSACTIONLEVELDEFAULT";
    private static final String TRANSACTIONLEVELS = "TRANSACTIONLEVELS";
    private static final String TRANSACTIONDATADEFINFO = "TRANSACTIONDATADEFINFO";
    private static final String PROCEDURES = "PROCEDURES";
    private static final String PROCEDURECOLUMNS = "PROCEDURECOLUMNS";
    private static final String SCHEMAS = "SCHEMAS";
    private static final String CATALOGS = "CATALOGS";
    private static final String TABLETYPES = "TABLETYPES";
    private static final String COLUMNPRIVILEGES = "COLUMNPRIVILEGES";
    private static final String TABLEPRIVILEGES = "TABLEPRIVILEGES";
    private static final String ROWIDENTIFIERS = "ROWIDENTIFIERS";
    private static final String VERSIONCOLUMNS = "VERSIONCOLUMNS";
    private static final String PRIMARYKEYS = "PRIMARYKEYS";
    private static final String IMPORTEDKEYS = "IMPORTEDKEYS";
    private static final String EXPORTEDKEYS = "EXPORTEDKEYS";
    private static final String KEYCROSSREFERENCE = "KEYCROSSREFERENCE";
    private static final String TYPEINFO = "TYPEINFO";
    private static final String INDEXINFO = "INDEXINFO";
    private static final String OWNUPDATESAREVISIBLE = "OWNUPDATESAREVISIBLE";
    private static final String OWNDELETESAREVISIBLE = "OWNDELETESAREVISIBLE";
    private static final String OWNINSERTSAREVISIBLE = "OWNINSERTSAREVISIBLE";
    private static final String OTHERSUPDATESAREVISIBLE = "OTHERSUPDATESAREVISIBLE";
    private static final String OTHERSDELETESAREVISIBLE = "OTHERSDELETESAREVISIBLE";
    private static final String OTHERSINSERTSAREVISIBLE = "OTHERSINSERTSAREVISIBLE";
    private static final String UPDATESAREDETECTED = "UPDATESAREDETECTED";
    private static final String DELETESAREDETECTED = "DELETESAREDETECTED";
    private static final String INSERTSAREDETECTED = "INSERTSAREDETECTED";
    private static final String SUPPORTSBATCHUPDATES = "SUPPORTSBATCHUPDATES";
    private static final String SUPPORTSRESULTSETTYPE = "SUPPORTSRESULTSETTYPE";
    private static final String READONLYCONCURRENCY = "READONLYCONCURRENCY";
    private static final String UPDATABLECONCURRENCY = "UPDATABLECONCURRENCY";
    private static final String UDTS = "UDTS";
    private static final String EXECBATCHUPDATESINLOOP = "EXECBATCHUPDATESINLOOP";
    private static final String ISCASESENSITIVE = "ISCASESENSITIVE";
    private static final String CLASSFORNAME = "CLASSFORNAME";
    private static final String JARFORCLASS = "JARFORCLASS";
    private static final String JARBYNAME = "JARBYNAME";
    private static final String CLASSESINJAR = "CLASSESINJAR";
    private static final String CANRETURNJARS = "CANRETURNJARS";
    private static final String XACOORDINATORTYPE = "XACOORDINATORTYPE";
    protected int _execBatchInLoop = -1;
    protected int _batchSupport = -1;

    SybDatabaseMetaData(SybConnection conn) throws SQLException {
        this._conn = conn;
        this._mda = conn.getMDA(null);
        this._outerJoinEscapeSupport = -1;
        this._isCaseSensitive = -1;
    }

    public boolean allProceduresAreCallable() throws SQLException {
        Debug.println(this, "allProceduresAreCallable");
        PreparedStatement ps = this.getMetaDataAccessor(ALLPROCSCALLABLE);
        return this.returnBoolean(ps, 1);
    }

    public boolean allTablesAreSelectable() throws SQLException {
        Debug.println(this, "allTablesAreSelectable");
        PreparedStatement ps = this.getMetaDataAccessor(ALLTABLESSELECTABLE);
        return this.returnBoolean(ps, 1);
    }

    public boolean canReturnJars() throws SQLException {
        PreparedStatement ps = this.getMetaDataAccessor(CANRETURNJARS);
        return this.returnBoolean(ps, 1);
    }

    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        Debug.println(this, "dataDefinitionCausesTransactionCommit");
        PreparedStatement ps = this.getMetaDataAccessor(TRANSACTIONDATADEFINFO);
        return this.returnBoolean(ps, 3);
    }

    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        Debug.println(this, "dataDefinitionIgnoredInTransactions");
        PreparedStatement ps = this.getMetaDataAccessor(TRANSACTIONDATADEFINFO);
        return this.returnBoolean(ps, 4);
    }

    public boolean deletesAreDetected(int type) throws SQLException {
        Debug.println(this, "deletesAreDetected");
        return this.supportForResultSetType(DELETESAREDETECTED, type);
    }

    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        Debug.println(this, "doesMaxRowSizeIncludeBlobs");
        PreparedStatement ps = this.getMetaDataAccessor(ROWINFO);
        return this.returnBoolean(ps, 2);
    }

    public boolean execBatchUpdatesInLoop() throws SQLException {
        Debug.println(this, "execBatchUpdatesInLoop");
        PreparedStatement ps = this.getMetaDataAccessor(EXECBATCHUPDATESINLOOP);
        return this.returnBoolean(ps, 1);
    }

    public ResultSet getBestRowIdentifier(String catalog, String schema, String table, int scope, boolean nullable) throws SQLException {
        Debug.println(this, "getBestRowIdentifier");
        PreparedStatement ps = this.getMetaDataAccessor(ROWIDENTIFIERS, catalog);
        this.setStringParam(ps, catalog, 1);
        this.setStringParam(ps, schema, 2);
        this.setStringParam(ps, table, 3);
        ps.setInt(4, scope);
        ps.setBoolean(5, nullable);
        return this.returnResults(ps);
    }

    public String getCatalogSeparator() throws SQLException {
        Debug.println(this, "getCatalogSeparator");
        PreparedStatement ps = this.getMetaDataAccessor(CATALOGSEPARATOR);
        return this.returnString(ps);
    }

    public String getCatalogTerm() throws SQLException {
        Debug.println(this, "getCatalogTerm");
        PreparedStatement ps = this.getMetaDataAccessor(CATALOGTERM);
        return this.returnString(ps);
    }

    public ResultSet getCatalogs() throws SQLException {
        Debug.println(this, "getCatalogs");
        PreparedStatement ps = this.getMetaDataAccessor(CATALOGS);
        return this.returnResults(ps);
    }

    public ResultSet getClassForName(String className) throws SQLException {
        PreparedStatement ps = this.getMetaDataAccessor(CLASSFORNAME);
        this.setStringParam(ps, className, 1);
        return this.returnResults(ps);
    }

    public ResultSet getClassesInJar(String jarName) throws SQLException {
        PreparedStatement ps = this.getMetaDataAccessor(CLASSESINJAR);
        this.setStringParam(ps, jarName, 1);
        return this.returnResults(ps);
    }

    public ResultSet getColumnPrivileges(String catalog, String schema, String table, String columnNamePattern) throws SQLException {
        Debug.println(this, "getColumnPrivileges");
        PreparedStatement ps = this.getMetaDataAccessor(COLUMNPRIVILEGES, catalog);
        this.setStringParam(ps, catalog, 1);
        this.setStringParam(ps, schema, 2);
        this.setStringParam(ps, table, 3);
        this.setStringParam(ps, columnNamePattern, 4);
        return this.returnResults(ps);
    }

    public ResultSet getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        PreparedStatement ps = this.getMetaDataAccessor(COLUMNS, catalog);
        this.setStringParam(ps, tableNamePattern, 1);
        this.setStringParam(ps, schemaPattern, 2);
        this.setStringParam(ps, catalog, 3);
        this.setStringParam(ps, columnNamePattern, 4);
        return this.returnResults(ps);
    }

    public Connection getConnection() throws SQLException {
        Debug.println(this, "getConnection");
        return this._conn;
    }

    public ResultSet getCrossReference(String primaryCatalog, String primarySchema, String primaryTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
        Debug.println(this, "getCrossReference");
        PreparedStatement ps = this.getMetaDataAccessor(KEYCROSSREFERENCE, primaryCatalog);
        this.setStringParam(ps, primaryCatalog, 1);
        this.setStringParam(ps, primarySchema, 2);
        this.setStringParam(ps, primaryTable, 3);
        this.setStringParam(ps, foreignCatalog, 4);
        this.setStringParam(ps, foreignSchema, 5);
        this.setStringParam(ps, foreignTable, 6);
        return this.returnResults(ps);
    }

    public String getDatabaseProductName() throws SQLException {
        Debug.println(this, "getDatabaseProductName()");
        PreparedStatement ps = this.getMetaDataAccessor(PRODUCTNAME);
        return this.returnString(ps);
    }

    public String getDatabaseProductVersion() throws SQLException {
        Debug.println(this, "getDatebaseProductVersion");
        PreparedStatement ps = this.getMetaDataAccessor(PRODUCTVERSION);
        return this.returnString(ps);
    }

    public int getDefaultTransactionIsolation() throws SQLException {
        Debug.println(this, "getDefaultTransactionIsolation");
        PreparedStatement ps = this.getMetaDataAccessor(TRANSACTIONLEVELDEFAULT);
        return this.returnInt(ps, 1);
    }

    public int getDriverMajorVersion() {
        return 5;
    }

    public int getDriverMinorVersion() {
        return 5;
    }

    public String getDriverName() throws SQLException {
        return "jConnect (TM) for JDBC (TM)";
    }

    public String getDriverVersion() throws SQLException {
        return "jConnect (TM) for JDBC(TM)/5.5(Build 25008)/P/DEBUG/JDK12/Tue May 29 14:29:40 2001";
    }

    public ResultSet getExportedKeys(String catalog, String schema, String table) throws SQLException {
        Debug.println(this, "getExportedKeys");
        PreparedStatement ps = this.getMetaDataAccessor(EXPORTEDKEYS, catalog);
        this.setStringParam(ps, catalog, 1);
        this.setStringParam(ps, schema, 2);
        this.setStringParam(ps, table, 3);
        return this.returnResults(ps);
    }

    public String getExtraNameCharacters() throws SQLException {
        Debug.println(this, "getExtraNameCharacters");
        PreparedStatement ps = this.getMetaDataAccessor(EXTRANAMECHARS);
        return this.returnString(ps);
    }

    public String getIdentifierQuoteString() throws SQLException {
        Debug.println(this, "getIdentifierQuoteString");
        PreparedStatement ps = this.getMetaDataAccessor(IDENTIFIERQUOTE);
        return this.returnString(ps);
    }

    public ResultSet getImportedKeys(String catalog, String schema, String table) throws SQLException {
        Debug.println(this, "getImportedKeys");
        PreparedStatement ps = this.getMetaDataAccessor(IMPORTEDKEYS, catalog);
        this.setStringParam(ps, catalog, 1);
        this.setStringParam(ps, schema, 2);
        this.setStringParam(ps, table, 3);
        return this.returnResults(ps);
    }

    public ResultSet getIndexInfo(String catalog, String schema, String table, boolean unique, boolean approximate) throws SQLException {
        Debug.println(this, "getIndexInfo");
        PreparedStatement ps = this.getMetaDataAccessor(INDEXINFO, catalog);
        this.setStringParam(ps, catalog, 1);
        this.setStringParam(ps, schema, 2);
        this.setStringParam(ps, table, 3);
        ps.setBoolean(4, unique);
        ps.setBoolean(5, approximate);
        return this.returnResults(ps);
    }

    public ResultSet getJarByName(String jarName) throws SQLException {
        PreparedStatement ps = this.getMetaDataAccessor(JARBYNAME);
        this.setStringParam(ps, jarName, 1);
        return this.returnResults(ps);
    }

    public ResultSet getJarForClass(String className) throws SQLException {
        PreparedStatement ps = this.getMetaDataAccessor(JARFORCLASS);
        this.setStringParam(ps, className, 1);
        return this.returnResults(ps);
    }

    public int getMaxBinaryLiteralLength() throws SQLException {
        Debug.println(this, "getMaxBinaryLiteralLength");
        PreparedStatement ps = this.getMetaDataAccessor(MAXBINARYLITERALLENGTH);
        return this.returnInt(ps, 1);
    }

    public int getMaxCatalogNameLength() throws SQLException {
        Debug.println(this, "getMaxCatalogNameLength");
        PreparedStatement ps = this.getMetaDataAccessor(MAXNAMELENGTHS);
        return this.returnInt(ps, 5);
    }

    public int getMaxCharLiteralLength() throws SQLException {
        Debug.println(this, "getMaxBinaryLiteralLength");
        PreparedStatement ps = this.getMetaDataAccessor(MAXCHARLITERALLENGTH);
        return this.returnInt(ps, 1);
    }

    public int getMaxColumnNameLength() throws SQLException {
        Debug.println(this, "getMaxColumnNameLength");
        PreparedStatement ps = this.getMetaDataAccessor(COLUMNINFO);
        return this.returnInt(ps, 1);
    }

    public int getMaxColumnsInGroupBy() throws SQLException {
        Debug.println(this, "getMaxColumnsInGroupBy");
        PreparedStatement ps = this.getMetaDataAccessor(COLUMNINFO);
        return this.returnInt(ps, 2);
    }

    public int getMaxColumnsInIndex() throws SQLException {
        Debug.println(this, "getMaxColumnsInIndex");
        PreparedStatement ps = this.getMetaDataAccessor(COLUMNINFO);
        return this.returnInt(ps, 3);
    }

    public int getMaxColumnsInOrderBy() throws SQLException {
        Debug.println(this, "getMaxColumnsInOrderBy");
        PreparedStatement ps = this.getMetaDataAccessor(COLUMNINFO);
        return this.returnInt(ps, 4);
    }

    public int getMaxColumnsInSelect() throws SQLException {
        Debug.println(this, "getMaxColumnsInSelect");
        PreparedStatement ps = this.getMetaDataAccessor(COLUMNINFO);
        return this.returnInt(ps, 5);
    }

    public int getMaxColumnsInTable() throws SQLException {
        Debug.println(this, "getMaxColumnsInTable");
        PreparedStatement ps = this.getMetaDataAccessor(COLUMNINFO);
        return this.returnInt(ps, 6);
    }

    public int getMaxConnections() throws SQLException {
        Debug.println(this, "getMaxConnections");
        PreparedStatement ps = this.getMetaDataAccessor(MAXCONNECTIONS);
        return this.returnInt(ps, 1);
    }

    public int getMaxCursorNameLength() throws SQLException {
        Debug.println(this, "getMaxCursorNameLength");
        PreparedStatement ps = this.getMetaDataAccessor(MAXNAMELENGTHS);
        return this.returnInt(ps, 1);
    }

    public int getMaxIndexLength() throws SQLException {
        Debug.println(this, "getMaxIndexLength");
        PreparedStatement ps = this.getMetaDataAccessor(MAXINDEXLENGTH);
        return this.returnInt(ps, 1);
    }

    public int getMaxProcedureNameLength() throws SQLException {
        Debug.println(this, "getMaxProcedureNameLength");
        PreparedStatement ps = this.getMetaDataAccessor(MAXNAMELENGTHS);
        return this.returnInt(ps, 4);
    }

    public int getMaxRowSize() throws SQLException {
        Debug.println(this, "getMaxRowSize");
        PreparedStatement ps = this.getMetaDataAccessor(ROWINFO);
        return this.returnInt(ps, 1);
    }

    public int getMaxSchemaNameLength() throws SQLException {
        Debug.println(this, "getMaxSchemaNameLength");
        PreparedStatement ps = this.getMetaDataAccessor(MAXNAMELENGTHS);
        return this.returnInt(ps, 3);
    }

    public int getMaxStatementLength() throws SQLException {
        Debug.println(this, "getMaxStatementLength");
        PreparedStatement ps = this.getMetaDataAccessor(STATEMENTINFO);
        return this.returnInt(ps, 1);
    }

    public int getMaxStatements() throws SQLException {
        Debug.println(this, "getMaxStatements");
        PreparedStatement ps = this.getMetaDataAccessor(STATEMENTINFO);
        return this.returnInt(ps, 2);
    }

    public int getMaxTableNameLength() throws SQLException {
        Debug.println(this, "getMaxTableNameLength");
        PreparedStatement ps = this.getMetaDataAccessor(TABLEINFO);
        return this.returnInt(ps, 1);
    }

    public int getMaxTablesInSelect() throws SQLException {
        Debug.println(this, "getMaxTablesInSelect");
        PreparedStatement ps = this.getMetaDataAccessor(TABLEINFO);
        return this.returnInt(ps, 2);
    }

    public int getMaxUserNameLength() throws SQLException {
        Debug.println(this, "getMaxUserNameLength");
        PreparedStatement ps = this.getMetaDataAccessor(MAXNAMELENGTHS);
        return this.returnInt(ps, 2);
    }

    public PreparedStatement getMetaDataAccessor(String mdInfo) throws SQLException {
        return this.getMetaDataAccessor(mdInfo, "", null);
    }

    public PreparedStatement getMetaDataAccessor(String mdInfo, String catalog) throws SQLException {
        return this.getMetaDataAccessor(mdInfo, "", catalog);
    }

    public PreparedStatement getMetaDataAccessor(String mdInfo, String pad, String catalog) throws SQLException {
        return this._mda.getMetaDataAccessor(mdInfo, pad, catalog, null);
    }

    public String getNumericFunctions() throws SQLException {
        Debug.println(this, "getNumericFunctions");
        PreparedStatement ps = this.getMetaDataAccessor(NUMERICFUNCTIONLIST);
        return this.returnString(ps);
    }

    public ResultSet getPrimaryKeys(String catalog, String schema, String table) throws SQLException {
        Debug.println(this, "getPrimaryKeys");
        PreparedStatement ps = this.getMetaDataAccessor(PRIMARYKEYS, catalog);
        this.setStringParam(ps, catalog, 1);
        this.setStringParam(ps, schema, 2);
        this.setStringParam(ps, table, 3);
        return this.returnResults(ps);
    }

    public ResultSet getProcedureColumns(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) throws SQLException {
        Debug.println(this, "getProcedureColumns");
        PreparedStatement ps = this.getMetaDataAccessor(PROCEDURECOLUMNS, catalog);
        this.setStringParam(ps, catalog, 1);
        this.setStringParam(ps, schemaPattern, 2);
        this.setStringParam(ps, procedureNamePattern, 3);
        this.setStringParam(ps, columnNamePattern, 4);
        return this.returnResults(ps);
    }

    public String getProcedureTerm() throws SQLException {
        Debug.println(this, "getProcedureTerm");
        PreparedStatement ps = this.getMetaDataAccessor(PROCEDURETERM);
        return this.returnString(ps);
    }

    public ResultSet getProcedures(String catalog, String schemaPattern, String procedureNamePattern) throws SQLException {
        Debug.println(this, "getProcedures");
        PreparedStatement ps = this.getMetaDataAccessor(PROCEDURES, catalog);
        this.setStringParam(ps, catalog, 1);
        this.setStringParam(ps, schemaPattern, 2);
        this.setStringParam(ps, procedureNamePattern, 3);
        return this.returnResults(ps);
    }

    public String getSQLKeywords() throws SQLException {
        Debug.println(this, "getSQLKeywords");
        PreparedStatement ps = this.getMetaDataAccessor(SQLKEYWORDS);
        return this.returnString(ps);
    }

    public String getSchemaTerm() throws SQLException {
        Debug.println(this, "getSchemaTerm");
        PreparedStatement ps = this.getMetaDataAccessor(SCHEMATERM);
        return this.returnString(ps);
    }

    public ResultSet getSchemas() throws SQLException {
        Debug.println(this, "getSchemas");
        PreparedStatement ps = this.getMetaDataAccessor(SCHEMAS);
        return this.returnResults(ps);
    }

    public String getSearchStringEscape() throws SQLException {
        Debug.println(this, "getSearchStringEscape");
        PreparedStatement ps = this.getMetaDataAccessor(SEARCHSTRING);
        return this.returnString(ps);
    }

    public String getStringFunctions() throws SQLException {
        Debug.println(this, "getStringFunctions");
        PreparedStatement ps = this.getMetaDataAccessor(STRINGFUNCTIONLIST);
        return this.returnString(ps);
    }

    public String getSystemFunctions() throws SQLException {
        Debug.println(this, "getSystemFunctions");
        PreparedStatement ps = this.getMetaDataAccessor(SYSTEMFUNCTIONLIST);
        return this.returnString(ps);
    }

    public ResultSet getTablePrivileges(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        Debug.println(this, "getTablePrivileges");
        PreparedStatement ps = this.getMetaDataAccessor(TABLEPRIVILEGES, catalog);
        this.setStringParam(ps, catalog, 1);
        this.setStringParam(ps, schemaPattern, 2);
        this.setStringParam(ps, tableNamePattern, 3);
        return this.returnResults(ps);
    }

    public ResultSet getTableTypes() throws SQLException {
        Debug.println(this, "getTableTypes");
        PreparedStatement ps = this.getMetaDataAccessor(TABLETYPES);
        return this.returnResults(ps);
    }

    public ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        StringBuffer allTypes;
        Debug.println(this, " Now entering getTables");
        Debug.println(this, "dealing with types");
        if (types == null) {
            allTypes = null;
        } else {
            allTypes = new StringBuffer("\"");
            int i = 0;
            while (i < types.length) {
                if (types[i] == null || types[i].equals("null")) break;
                allTypes.append("'" + types[i] + "'");
                ++i;
            }
            allTypes = allTypes.append("\"");
        }
        Debug.println(this, "Catalog: " + catalog);
        PreparedStatement ps = this.getMetaDataAccessor(TABLES, catalog);
        this.setStringParam(ps, tableNamePattern, 1);
        this.setStringParam(ps, schemaPattern, 2);
        this.setStringParam(ps, catalog, 3);
        this.setStringParam(ps, allTypes == null ? null : allTypes.toString(), 4);
        return this.returnResults(ps);
    }

    public String getTimeDateFunctions() throws SQLException {
        Debug.println(this, "getTimeDateFunctions");
        PreparedStatement ps = this.getMetaDataAccessor(TIMEDATEFUNCTIONLIST);
        return this.returnString(ps);
    }

    public ResultSet getTypeInfo() throws SQLException {
        Debug.println(this, "getTypeInfo");
        PreparedStatement ps = this.getMetaDataAccessor(TYPEINFO);
        return this.returnResults(ps);
    }

    public ResultSet getUDTs(String catalog, String schemaPattern, String typeNamePattern, int[] types) throws SQLException {
        Debug.println(this, "getUDTs");
        String udtTypes = null;
        if (types != null) {
            udtTypes = "";
            int index = 0;
            while (index < types.length) {
                if (index > 0) {
                    udtTypes = String.valueOf(udtTypes) + ",";
                }
                switch (types[index]) {
                    case 2000: {
                        udtTypes = String.valueOf(udtTypes) + JAVA_OBJECT_NAME;
                        break;
                    }
                    case 2002: {
                        udtTypes = String.valueOf(udtTypes) + STRUCT_NAME;
                        break;
                    }
                    case 2001: {
                        udtTypes = String.valueOf(udtTypes) + DISTINCT_NAME;
                        break;
                    }
                    default: {
                        ErrorMessage.raiseError("JZ0SQ", String.valueOf(types[index]));
                    }
                }
                ++index;
            }
        }
        PreparedStatement ps = this.getMetaDataAccessor(UDTS, catalog);
        this.setStringParam(ps, catalog, 1);
        this.setStringParam(ps, schemaPattern, 2);
        this.setStringParam(ps, typeNamePattern, 3);
        this.setStringParam(ps, udtTypes, 4);
        return this.returnResults(ps);
    }

    public String getURL() throws SQLException {
        Debug.println(this, "getURL");
        return this._conn._url;
    }

    public String getUserName() throws SQLException {
        Debug.println(this, "getUserName");
        PreparedStatement ps = this.getMetaDataAccessor(USERNAME);
        return this.returnString(ps);
    }

    public ResultSet getVersionColumns(String catalog, String schema, String table) throws SQLException {
        Debug.println(this, "getVersionColumns");
        PreparedStatement ps = this.getMetaDataAccessor(VERSIONCOLUMNS, catalog);
        this.setStringParam(ps, catalog, 1);
        this.setStringParam(ps, schema, 2);
        this.setStringParam(ps, table, 3);
        return this.returnResults(ps);
    }

    public ResultSet getXACoordinatorType() throws SQLException {
        Debug.println(this, "getXACoordinatorType");
        PreparedStatement ps = this.getMetaDataAccessor(XACOORDINATORTYPE);
        return this.returnResults(ps);
    }

    public boolean insertsAreDetected(int type) throws SQLException {
        Debug.println(this, "insertsAreDetected");
        return this.supportForResultSetType(INSERTSAREDETECTED, type);
    }

    public boolean isCaseSensitive() throws SQLException {
        Debug.println(this, "isCaseSensitive");
        if (this._isCaseSensitive == -1) {
            PreparedStatement ps = this.getMetaDataAccessor(ISCASESENSITIVE);
            this._isCaseSensitive = this.returnBoolean(ps, 1) ? 1 : 0;
        }
        return this._isCaseSensitive == 1;
    }

    public boolean isCatalogAtStart() throws SQLException {
        Debug.println(this, "isCatalogAtStart");
        PreparedStatement ps = this.getMetaDataAccessor(CATALOGATSTART);
        return this.returnBoolean(ps, 1);
    }

    public boolean isReadOnly() throws SQLException {
        Debug.println(this, "isReadOnly");
        PreparedStatement ps = this.getMetaDataAccessor(ISREADONLY);
        return this.returnBoolean(ps, 1);
    }

    public boolean nullPlusNonNullIsNull() throws SQLException {
        Debug.println(this, "nullPlusNonNullIsNull");
        PreparedStatement ps = this.getMetaDataAccessor(NULLPLUSNONNULL);
        return this.returnBoolean(ps, 1);
    }

    public boolean nullsAreSortedAtEnd() throws SQLException {
        Debug.println(this, "nullsAreSortedAtEnd");
        PreparedStatement ps = this.getMetaDataAccessor(NULLSORTING);
        return this.returnBoolean(ps, 4);
    }

    public boolean nullsAreSortedAtStart() throws SQLException {
        Debug.println(this, "nullsAreSortedAtStart");
        PreparedStatement ps = this.getMetaDataAccessor(NULLSORTING);
        return this.returnBoolean(ps, 3);
    }

    public boolean nullsAreSortedHigh() throws SQLException {
        Debug.println(this, "nullsAreSortedHigh");
        PreparedStatement ps = this.getMetaDataAccessor(NULLSORTING);
        return this.returnBoolean(ps, 1);
    }

    public boolean nullsAreSortedLow() throws SQLException {
        Debug.println(this, "nullsAreSortedLow");
        PreparedStatement ps = this.getMetaDataAccessor(NULLSORTING);
        return this.returnBoolean(ps, 2);
    }

    public boolean othersDeletesAreVisible(int type) throws SQLException {
        Debug.println(this, "othersDeletesAreVisible");
        return this.supportForResultSetType(OTHERSDELETESAREVISIBLE, type);
    }

    public boolean othersInsertsAreVisible(int type) throws SQLException {
        Debug.println(this, "othersInsertsAreVisible");
        return this.supportForResultSetType(OTHERSINSERTSAREVISIBLE, type);
    }

    public boolean othersUpdatesAreVisible(int type) throws SQLException {
        Debug.println(this, "othersUpdatesAreVisible");
        return this.supportForResultSetType(OTHERSUPDATESAREVISIBLE, type);
    }

    public boolean ownDeletesAreVisible(int type) throws SQLException {
        Debug.println(this, "ownDeletesAreVisible");
        return this.supportForResultSetType(OWNDELETESAREVISIBLE, type);
    }

    public boolean ownInsertsAreVisible(int type) throws SQLException {
        Debug.println(this, "ownInsertsAreVisible");
        return this.supportForResultSetType(OWNINSERTSAREVISIBLE, type);
    }

    public boolean ownUpdatesAreVisible(int type) throws SQLException {
        Debug.println(this, "ownUpdatesAreVisible");
        return this.supportForResultSetType(OWNUPDATESAREVISIBLE, type);
    }

    private boolean returnBoolean(PreparedStatement ps, int column) throws SQLException {
        ResultSet rs = null;
        boolean retValue = false;
        SQLException sqe = null;
        try {
            try {
                rs = ps.executeQuery();
                rs.next();
                retValue = rs.getBoolean(column);
                rs.close();
            }
            catch (SQLException e) {
                sqe = e;
            }
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            ps.close();
            if (sqe != null) {
                throw sqe;
            }
            throw throwable;
        }
        ps.close();
        if (sqe != null) {
            throw sqe;
        }
        return retValue;
    }

    private int returnInt(PreparedStatement ps, int column) throws SQLException {
        ResultSet rs = null;
        int retValue = -1;
        SQLException sqe = null;
        try {
            try {
                rs = ps.executeQuery();
                rs.next();
                retValue = rs.getInt(column);
                rs.close();
            }
            catch (SQLException e) {
                sqe = e;
            }
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            ps.close();
            if (sqe != null) {
                throw sqe;
            }
            throw throwable;
        }
        ps.close();
        if (sqe != null) {
            throw sqe;
        }
        return retValue;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ResultSet returnResults(PreparedStatement ps) throws SQLException {
        ResultSet rs = null;
        SQLException sqe = null;
        SQLWarning sqw = null;
        try {
            try {
                rs = ps.executeQuery();
            }
            catch (SQLException e) {
                sqe = e;
                sqw = ps.getWarnings();
                if (sqw != null) {
                    Debug.println(this, "Rescued warning from statement: " + sqw);
                    this._conn.handleSQLE(sqw);
                }
                ps.close();
            }
            Object var6_6 = null;
            if (sqe == null) return rs;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (sqe == null) throw throwable;
            throw sqe;
        }
        throw sqe;
    }

    private String returnString(PreparedStatement ps) throws SQLException {
        ResultSet rs = null;
        String retValue = null;
        SQLException sqe = null;
        try {
            try {
                rs = ps.executeQuery();
                rs.next();
                retValue = rs.getString(1);
                rs.close();
            }
            catch (SQLException e) {
                sqe = e;
            }
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            ps.close();
            if (sqe != null) {
                throw sqe;
            }
            throw throwable;
        }
        ps.close();
        if (sqe != null) {
            throw sqe;
        }
        return retValue;
    }

    private void setStringParam(PreparedStatement ps, String value, int column) throws SQLException {
        if (value == null) {
            ps.setNull(column, 12);
        } else {
            ps.setString(column, value);
        }
    }

    public boolean storesLowerCaseIdentifiers() throws SQLException {
        Debug.println(this, "storesLowerCaseIdentifiers");
        PreparedStatement ps = this.getMetaDataAccessor(IDENTIFIERCASES);
        return this.returnBoolean(ps, 3);
    }

    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        Debug.println(this, "storesLowerCaseQuotedIdentifiers");
        PreparedStatement ps = this.getMetaDataAccessor(IDENTIFIERCASES);
        return this.returnBoolean(ps, 7);
    }

    public boolean storesMixedCaseIdentifiers() throws SQLException {
        Debug.println(this, "storesMixedCaseIdentifiers");
        PreparedStatement ps = this.getMetaDataAccessor(IDENTIFIERCASES);
        return this.returnBoolean(ps, 4);
    }

    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        Debug.println(this, "storesMixedCaseQuotedIdentiers");
        PreparedStatement ps = this.getMetaDataAccessor(IDENTIFIERCASES);
        return this.returnBoolean(ps, 8);
    }

    public boolean storesUpperCaseIdentifiers() throws SQLException {
        Debug.println(this, "storesUpperCaseIdentifiers");
        PreparedStatement ps = this.getMetaDataAccessor(IDENTIFIERCASES);
        return this.returnBoolean(ps, 2);
    }

    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        Debug.println(this, "storesUpperCaseQuotedIdentifiers");
        PreparedStatement ps = this.getMetaDataAccessor(IDENTIFIERCASES);
        return this.returnBoolean(ps, 6);
    }

    private boolean supportForResultSetType(String mdInfo, int type) throws SQLException {
        Debug.println(this, "supportForResultSetType");
        boolean isSupported = false;
        PreparedStatement ps = this.getMetaDataAccessor(mdInfo);
        switch (type) {
            case 1003: {
                isSupported = this.returnBoolean(ps, 1);
                break;
            }
            case 1004: {
                isSupported = this.returnBoolean(ps, 2);
                break;
            }
            case 1005: {
                isSupported = this.returnBoolean(ps, 3);
                break;
            }
            default: {
                ErrorMessage.raiseError("JZ0SP", String.valueOf(type));
            }
        }
        return isSupported;
    }

    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        Debug.println(this, "supportsANSI92EntryLevelSQL");
        PreparedStatement ps = this.getMetaDataAccessor(ANSI92LEVEL);
        return this.returnBoolean(ps, 1);
    }

    public boolean supportsANSI92FullSQL() throws SQLException {
        Debug.println(this, "supportsANSI92FullSQL");
        PreparedStatement ps = this.getMetaDataAccessor(ANSI92LEVEL);
        return this.returnBoolean(ps, 3);
    }

    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        Debug.println(this, "supportsANSI92IntermediateSQL");
        PreparedStatement ps = this.getMetaDataAccessor(ANSI92LEVEL);
        return this.returnBoolean(ps, 2);
    }

    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        Debug.println(this, "supportsAlterTableWithAddColumn");
        PreparedStatement ps = this.getMetaDataAccessor(ALTERTABLESUPPORT);
        return this.returnBoolean(ps, 1);
    }

    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        Debug.println(this, "supportsAlterTableWithDropColumn");
        PreparedStatement ps = this.getMetaDataAccessor(ALTERTABLESUPPORT);
        return this.returnBoolean(ps, 2);
    }

    public boolean supportsBatchUpdates() throws SQLException {
        Debug.println(this, "supportsBatchUpdates");
        PreparedStatement ps = this.getMetaDataAccessor(SUPPORTSBATCHUPDATES);
        return this.returnBoolean(ps, 1);
    }

    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        Debug.println(this, "supportsCatalogsInDataManipulation");
        PreparedStatement ps = this.getMetaDataAccessor(CATALOGSUPPORT);
        return this.returnBoolean(ps, 1);
    }

    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        Debug.println(this, "supportsCatalogsInIndexDefinitions");
        PreparedStatement ps = this.getMetaDataAccessor(CATALOGSUPPORT);
        return this.returnBoolean(ps, 4);
    }

    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        Debug.println(this, "supportsCatalogsInPrivilegeDefinitions");
        PreparedStatement ps = this.getMetaDataAccessor(CATALOGSUPPORT);
        return this.returnBoolean(ps, 5);
    }

    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        Debug.println(this, "supportsCatalogsInProcedureCalls");
        PreparedStatement ps = this.getMetaDataAccessor(CATALOGSUPPORT);
        return this.returnBoolean(ps, 2);
    }

    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        Debug.println(this, "supportsCatalogsInTableDefinitions");
        PreparedStatement ps = this.getMetaDataAccessor(CATALOGSUPPORT);
        return this.returnBoolean(ps, 3);
    }

    public boolean supportsColumnAliasing() throws SQLException {
        Debug.println(this, "supportsColumnAliasing");
        PreparedStatement ps = this.getMetaDataAccessor(COLUMNALIASING);
        return this.returnBoolean(ps, 1);
    }

    public boolean supportsConvert() throws SQLException {
        Debug.println(this, "supportsConvert");
        PreparedStatement ps = this.getMetaDataAccessor(CONVERTSUPPORT);
        return this.returnBoolean(ps, 1);
    }

    public boolean supportsConvert(int fromType, int toType) throws SQLException {
        Debug.println(this, "supportsConvert(int,int)");
        PreparedStatement ps = this.getMetaDataAccessor(CONVERTMAP);
        ps.setInt(1, fromType);
        ps.setInt(2, toType);
        ResultSet rs = ps.executeQuery();
        return this.returnBoolean(ps, 1);
    }

    public boolean supportsCoreSQLGrammar() throws SQLException {
        Debug.println(this, "supportsCoreSQLGrammar");
        PreparedStatement ps = this.getMetaDataAccessor(SQLGRAMMAR);
        return this.returnBoolean(ps, 2);
    }

    public boolean supportsCorrelatedSubqueries() throws SQLException {
        Debug.println(this, "supportsCorrelatedSubqueries");
        PreparedStatement ps = this.getMetaDataAccessor(SUBQUERIES);
        return this.returnBoolean(ps, 5);
    }

    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        Debug.println(this, "supportsDataDefinitionAndDataManipulationTransactions");
        PreparedStatement ps = this.getMetaDataAccessor(TRANSACTIONDATADEFINFO);
        return this.returnBoolean(ps, 1);
    }

    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        Debug.println(this, "supportsDataManipulationTransactionsOnly");
        PreparedStatement ps = this.getMetaDataAccessor(TRANSACTIONDATADEFINFO);
        return this.returnBoolean(ps, 2);
    }

    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        Debug.println(this, "supportsDifferentTableCorrelationNames");
        PreparedStatement ps = this.getMetaDataAccessor(CORRELATIONNAMES);
        return this.returnBoolean(ps, 2);
    }

    public boolean supportsExpressionsInOrderBy() throws SQLException {
        Debug.println(this, "supportsExpressionsInOrderBy");
        PreparedStatement ps = this.getMetaDataAccessor(ORDERBYSUPPORT);
        return this.returnBoolean(ps, 1);
    }

    public boolean supportsExtendedSQLGrammar() throws SQLException {
        Debug.println(this, "supportsExtendedSQLGrammar");
        PreparedStatement ps = this.getMetaDataAccessor(SQLGRAMMAR);
        return this.returnBoolean(ps, 3);
    }

    public boolean supportsFullOuterJoins() throws SQLException {
        Debug.println(this, "supportsFullOuterJoins");
        PreparedStatement ps = this.getMetaDataAccessor(OUTERJOINS);
        return this.returnBoolean(ps, 2);
    }

    public boolean supportsGroupBy() throws SQLException {
        Debug.println(this, "supportsGroupBy");
        PreparedStatement ps = this.getMetaDataAccessor(GROUPBYSUPPORT);
        return this.returnBoolean(ps, 1);
    }

    public boolean supportsGroupByBeyondSelect() throws SQLException {
        Debug.println(this, "supportsGroupByBeyondSelect");
        PreparedStatement ps = this.getMetaDataAccessor(GROUPBYSUPPORT);
        return this.returnBoolean(ps, 3);
    }

    public boolean supportsGroupByUnrelated() throws SQLException {
        Debug.println(this, "supportsGroupByUnrelated");
        PreparedStatement ps = this.getMetaDataAccessor(GROUPBYSUPPORT);
        return this.returnBoolean(ps, 2);
    }

    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        Debug.println(this, "supportsIntegrityEnhancementFacility");
        PreparedStatement ps = this.getMetaDataAccessor(INTEGRITYENHANCEMENT);
        return this.returnBoolean(ps, 1);
    }

    public boolean supportsLikeEscapeClause() throws SQLException {
        Debug.println(this, "supportsLikeEscapeClause");
        PreparedStatement ps = this.getMetaDataAccessor(LIKEESCAPECLAUSE);
        return this.returnBoolean(ps, 1);
    }

    public boolean supportsLimitedOuterJoins() throws SQLException {
        Debug.println(this, "supportsLimitedOuterJoins");
        PreparedStatement ps = this.getMetaDataAccessor(OUTERJOINS);
        return this.returnBoolean(ps, 3);
    }

    public boolean supportsMinimumSQLGrammar() throws SQLException {
        Debug.println(this, "supportsMinimumSQLGrammar");
        PreparedStatement ps = this.getMetaDataAccessor(SQLGRAMMAR);
        return this.returnBoolean(ps, 1);
    }

    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        Debug.println(this, "supportsMixedCaseIdentifiers");
        PreparedStatement ps = this.getMetaDataAccessor(IDENTIFIERCASES);
        return this.returnBoolean(ps, 1);
    }

    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        Debug.println(this, "supportsMixedCaseQuotedIdentifiers");
        PreparedStatement ps = this.getMetaDataAccessor(IDENTIFIERCASES);
        return this.returnBoolean(ps, 5);
    }

    public boolean supportsMultipleResultSets() throws SQLException {
        Debug.println(this, "supportsMultipleResultSets");
        PreparedStatement ps = this.getMetaDataAccessor(MULTIPLERESULTSETS);
        return this.returnBoolean(ps, 1);
    }

    public boolean supportsMultipleTransactions() throws SQLException {
        Debug.println(this, "supportsMultipleTransactions");
        PreparedStatement ps = this.getMetaDataAccessor(MULTIPLETRANSACTIONS);
        return this.returnBoolean(ps, 1);
    }

    public boolean supportsNonNullableColumns() throws SQLException {
        Debug.println(this, "supportsNonNullableColumns");
        PreparedStatement ps = this.getMetaDataAccessor(NONNULLABLECOLUMNS);
        return this.returnBoolean(ps, 1);
    }

    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        Debug.println(this, "supportsOpenCursorsAcrossCommit");
        PreparedStatement ps = this.getMetaDataAccessor(CURSORTRANSACTIONS);
        return this.returnBoolean(ps, 1);
    }

    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        Debug.println(this, "supportsOpenCursorsAcrossRollback");
        PreparedStatement ps = this.getMetaDataAccessor(CURSORTRANSACTIONS);
        return this.returnBoolean(ps, 2);
    }

    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        Debug.println(this, "supportsOpenStatementsAcrossCommit");
        PreparedStatement ps = this.getMetaDataAccessor(STATEMENTTRANSACTIONS);
        return this.returnBoolean(ps, 1);
    }

    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        Debug.println(this, "supportsOpenStatementsAcrossRollback");
        PreparedStatement ps = this.getMetaDataAccessor(STATEMENTTRANSACTIONS);
        return this.returnBoolean(ps, 2);
    }

    public boolean supportsOrderByUnrelated() throws SQLException {
        Debug.println(this, "supportsOrderByUnrelated");
        PreparedStatement ps = this.getMetaDataAccessor(ORDERBYSUPPORT);
        return this.returnBoolean(ps, 2);
    }

    protected boolean supportsOuterJoinEscapeSyntax() throws SQLException {
        Debug.println(this, "supportsOuterJoinEscapeSyntax");
        if (this._mda._version < 1) {
            return this.getDatabaseProductName().equals("Sybase SQL Anywhere");
        }
        PreparedStatement ps = this.getMetaDataAccessor(OUTERJOINS);
        return this.returnBoolean(ps, 4);
    }

    public boolean supportsOuterJoins() throws SQLException {
        Debug.println(this, "supportsOuterJoins");
        if (this._outerJoinEscapeSupport == -1) {
            PreparedStatement ps = this.getMetaDataAccessor(OUTERJOINS);
            this._outerJoinEscapeSupport = this.returnBoolean(ps, 1) ? 1 : 0;
        }
        return this._outerJoinEscapeSupport == 1;
    }

    public boolean supportsPositionedDelete() throws SQLException {
        Debug.println(this, "supportsPositionedDelete");
        PreparedStatement ps = this.getMetaDataAccessor(POSITIONEDDELETE);
        return this.returnBoolean(ps, 1);
    }

    public boolean supportsPositionedUpdate() throws SQLException {
        Debug.println(this, "supportsPositionedUpdate");
        PreparedStatement ps = this.getMetaDataAccessor(POSITIONEDUPDATE);
        return this.returnBoolean(ps, 1);
    }

    public boolean supportsResultSetConcurrency(int type, int concurrency) throws SQLException {
        Debug.println(this, "supportsResultSetConcurrency");
        switch (concurrency) {
            case 1007: {
                return this.supportForResultSetType(READONLYCONCURRENCY, type);
            }
            case 1008: {
                return this.supportForResultSetType(UPDATABLECONCURRENCY, type);
            }
        }
        ErrorMessage.raiseError("JZ0SO", String.valueOf(concurrency));
        return false;
    }

    public boolean supportsResultSetType(int type) throws SQLException {
        Debug.println(this, "supportsResultSetType");
        return this.supportForResultSetType(SUPPORTSRESULTSETTYPE, type);
    }

    public boolean supportsSchemasInDataManipulation() throws SQLException {
        Debug.println(this, "supportsSchemasInDataManipulation");
        PreparedStatement ps = this.getMetaDataAccessor(SCHEMASUPPORT);
        return this.returnBoolean(ps, 1);
    }

    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        Debug.println(this, "supportsSchemasInIndexDefinitions");
        PreparedStatement ps = this.getMetaDataAccessor(SCHEMASUPPORT);
        return this.returnBoolean(ps, 4);
    }

    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        Debug.println(this, "supportsSchemasInPrivilegeDefinitions");
        PreparedStatement ps = this.getMetaDataAccessor(SCHEMASUPPORT);
        return this.returnBoolean(ps, 5);
    }

    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        Debug.println(this, "supportsSchemasInProcedureCalls");
        PreparedStatement ps = this.getMetaDataAccessor(SCHEMASUPPORT);
        return this.returnBoolean(ps, 2);
    }

    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        Debug.println(this, "supportsSchemasInTableDefinitions");
        PreparedStatement ps = this.getMetaDataAccessor(SCHEMASUPPORT);
        return this.returnBoolean(ps, 3);
    }

    public boolean supportsSelectForUpdate() throws SQLException {
        Debug.println(this, "supportsSelectForUpdate");
        PreparedStatement ps = this.getMetaDataAccessor(SELECTFORUPDATE);
        return this.returnBoolean(ps, 1);
    }

    public boolean supportsStoredProcedures() throws SQLException {
        Debug.println(this, "supportsStoredProcedures");
        PreparedStatement ps = this.getMetaDataAccessor(STOREDPROCEDURES);
        return this.returnBoolean(ps, 1);
    }

    public boolean supportsSubqueriesInComparisons() throws SQLException {
        Debug.println(this, "supportsSubqueriesInComparisons");
        PreparedStatement ps = this.getMetaDataAccessor(SUBQUERIES);
        return this.returnBoolean(ps, 1);
    }

    public boolean supportsSubqueriesInExists() throws SQLException {
        Debug.println(this, "supportsSubqueriesInExists");
        PreparedStatement ps = this.getMetaDataAccessor(SUBQUERIES);
        return this.returnBoolean(ps, 2);
    }

    public boolean supportsSubqueriesInIns() throws SQLException {
        Debug.println(this, "supportsSubqueriesInIns");
        PreparedStatement ps = this.getMetaDataAccessor(SUBQUERIES);
        return this.returnBoolean(ps, 3);
    }

    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        Debug.println(this, "supportsSubqueriesInQuantifieds");
        PreparedStatement ps = this.getMetaDataAccessor(SUBQUERIES);
        return this.returnBoolean(ps, 4);
    }

    public boolean supportsTableCorrelationNames() throws SQLException {
        Debug.println(this, "supportsTableCorrelationNames");
        PreparedStatement ps = this.getMetaDataAccessor(CORRELATIONNAMES);
        return this.returnBoolean(ps, 1);
    }

    public boolean supportsTransactionIsolationLevel(int level) throws SQLException {
        Debug.println(this, "supportsTransactionIsolationLevel");
        PreparedStatement ps = this.getMetaDataAccessor(TRANSACTIONLEVELS);
        ResultSet rs = ps.executeQuery();
        boolean retValue = false;
        SQLException sqe = null;
        try {
            try {
                if (rs.next()) {
                    int numColumns = rs.getMetaData().getColumnCount();
                    int i = 1;
                    while (i <= numColumns) {
                        if (rs.getInt(i) == level) {
                            retValue = true;
                        }
                        ++i;
                    }
                }
            }
            catch (SQLException e) {
                sqe = e;
            }
            Object var7_9 = null;
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            rs.close();
            ps.close();
            throw throwable;
        }
        rs.close();
        ps.close();
        return retValue;
    }

    public boolean supportsTransactions() throws SQLException {
        Debug.println(this, "supportsTransactions");
        PreparedStatement ps = this.getMetaDataAccessor(TRANSACTIONSUPPORT);
        return this.returnBoolean(ps, 1);
    }

    public boolean supportsUnion() throws SQLException {
        Debug.println(this, "supportsUnion");
        PreparedStatement ps = this.getMetaDataAccessor(UNIONSUPPORT);
        return this.returnBoolean(ps, 1);
    }

    public boolean supportsUnionAll() throws SQLException {
        Debug.println(this, "supportsUnionAll");
        PreparedStatement ps = this.getMetaDataAccessor(UNIONSUPPORT);
        return this.returnBoolean(ps, 2);
    }

    public boolean updatesAreDetected(int type) throws SQLException {
        Debug.println(this, "updatesAreDetected");
        return this.supportForResultSetType(UPDATESAREDETECTED, type);
    }

    public boolean usesLocalFilePerTable() throws SQLException {
        Debug.println(this, "usesLocalFilePerTable");
        PreparedStatement ps = this.getMetaDataAccessor(FILEUSAGE);
        return this.returnBoolean(ps, 2);
    }

    public boolean usesLocalFiles() throws SQLException {
        Debug.println(this, "usesLocalFiles");
        PreparedStatement ps = this.getMetaDataAccessor(FILEUSAGE);
        return this.returnBoolean(ps, 1);
    }
}

