/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc2.jdbc;

import com.sybase.jdbc2.jdbc.ErrorMessage;
import com.sybase.jdbc2.jdbc.Protocol;
import com.sybase.jdbc2.utils.Debug;
import java.sql.SQLException;
import java.util.Hashtable;

public class ProtocolManager {
    private static Hashtable _protocols = new Hashtable();

    private ProtocolManager() {
    }

    protected static synchronized Protocol getProtocol(String protocol) throws SQLException {
        Debug.println(null, "ProtocolManager.getProtocol(\"" + protocol + "\")");
        Protocol p = (Protocol)_protocols.get(protocol);
        if (p == null) {
            Debug.println(null, "ProtocolManager.getProtocol -- loading " + protocol);
            try {
                Class<?> c = Class.forName(protocol);
                p = (Protocol)_protocols.get(protocol);
                if (p == null) {
                    p = (Protocol)c.newInstance();
                    ProtocolManager.registerProtocol(p);
                }
            }
            catch (Exception exception) {
                Debug.println(null, "getProtocol -- unable to load " + protocol);
                ErrorMessage.raiseError("JZ0D5", protocol);
            }
            Debug.assert(null, p != null, "Null protocol returned");
        }
        return p.getProtocol();
    }

    public static synchronized void registerProtocol(Protocol protocol) {
        Debug.println(null, "ProtocolManager.registerProtocol(" + protocol.getClass().getName() + ")");
        _protocols.put(protocol.getClass().getName(), protocol);
    }
}

