/*
 * Decompiled with CFR 0.152.
 */
package eGTTIntegration;

import com.eg.EgDateInfo;
import com.eg.EgInstallInfo;
import com.eg.IniFile;
import eGTTIntegration.TTIntegrationWrapper;
import java.io.File;
import java.io.IOException;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TimeZone;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.Holder;
import net.atos.esb.schemas.common.AuthenticationType;
import net.atos.esb.schemas.common.HeaderBaseType;
import net.atos.esb.schemas.common.HeaderOptionalDestinationType;
import net.atos.esb.schemas.common.ReturnType;
import net.atos.esb.schemas.event.AdditionalEventAttributeType;
import net.atos.esb.schemas.event.AdditionalEventAttributesType;
import net.atos.esb.schemas.event.ConfigItemIDType;
import net.atos.esb.schemas.event.ConfigItemIDTypeEnumType;
import net.atos.esb.schemas.event.EventClassType;
import net.atos.esb.schemas.event.EventKeyType;
import net.atos.esb.schemas.event.EventResolveType;
import net.atos.esb.schemas.event.EventTimeType;
import net.atos.esb.schemas.event.EventType;
import net.atos.esb.schemas.event.EventTypeEnumType;
import net.atos.esb.schemas.event.StatusNotificationSubscriptionEnumType;
import net.atos.esb.schemas.event.TroubleTicketPriorityEnumType;
import net.atos.esb.schemas.event.TroubleTicketType;
import net.atos.esb.wsdl.esbeventservice.CreateEventFault;
import net.atos.esb.wsdl.esbeventservice.ResolveEventFault;
import net.atos.esb.wsdl.esbeventservice.ServiceEventManagemen;
import net.atos.esb.wsdl.esbeventservice.ServiceEventManagemen_Service;

public class ATFIntegrator
extends TTIntegrationWrapper {
    private String alarmDateFormat;
    SimpleDateFormat df;
    private EgDateInfo date;
    private HashSet testAndMeasure_hs;
    private String DefaultDescFormat;
    private String WS_EndpointURLLocation;
    private String WS_ServiceName;
    private String functionalOrganization;
    private String availabilityMeasureStr;
    private String heartbeatEventConfigItemID;
    private String heartbeatWorkGroup;
    private String heartbeatCategory;
    private String heartbeatEventConfigItemIDType;
    private String managerIP;
    private String heartbeatMessage;
    String tempAlarmID;
    private String category;
    private String descriptionFormat;
    private String eventSender;
    private String eventSenderType;
    private String password;
    private String priorityForCritical;
    private String priorityForMajor;
    private String priorityForMinor;
    private String statusForAbnormal;
    private String statusForNormal;
    private String statusNotificationSubscription;
    private String strAuthKey;
    private String summaryFormat;
    private String targetNamespace;
    private String userName;
    private String workGroup;
    private String timeoutStr;
    private String isProxy;
    private String proxyHostName;
    private String proxyPort;
    private String proxyUserName;
    private String proxyPassword;
    private boolean isProxyEnabled;
    private String isProxyAuthenticated;
    private boolean isProxyAuth;
    private int MAX_DESC_SIZE;
    private int MAX_TITLE_SIZE;
    private int timeout;
    private static QName qName = null;
    private static String ENDPOINT_URL = "";
    private static String WSDL_URL = "";
    private String fileSeparator;

    public ATFIntegrator(Hashtable hashtable) {
        block2: {
            this.alarmDateFormat = "MMM dd, yyyy HH:mm:ss";
            this.df = new SimpleDateFormat(this.alarmDateFormat);
            this.date = new EgDateInfo();
            this.testAndMeasure_hs = null;
            this.DefaultDescFormat = " Priority :$prior  Component : $cname  Component  Type : $ctype  Layer : $layer  Problem  Description : $pdesc";
            this.WS_EndpointURLLocation = null;
            this.WS_ServiceName = "";
            this.functionalOrganization = "";
            this.availabilityMeasureStr = "";
            this.heartbeatEventConfigItemID = "";
            this.heartbeatWorkGroup = "";
            this.heartbeatCategory = "";
            this.heartbeatEventConfigItemIDType = "";
            this.managerIP = "";
            this.heartbeatMessage = "";
            this.tempAlarmID = "";
            this.category = "";
            this.descriptionFormat = "";
            this.eventSender = "";
            this.eventSenderType = "";
            this.password = "";
            this.priorityForCritical = "";
            this.priorityForMajor = "";
            this.priorityForMinor = "";
            this.statusForAbnormal = "Active";
            this.statusForNormal = "Resolved";
            this.statusNotificationSubscription = "";
            this.strAuthKey = "";
            this.summaryFormat = "$prior - $ctype / $cname  - $pdesc";
            this.targetNamespace = "";
            this.userName = "";
            this.workGroup = "";
            this.timeoutStr = "";
            this.isProxy = "";
            this.proxyHostName = "";
            this.proxyPort = "";
            this.proxyUserName = "";
            this.proxyPassword = "";
            this.isProxyEnabled = false;
            this.isProxyAuthenticated = "";
            this.isProxyAuth = false;
            this.MAX_DESC_SIZE = 1024;
            this.MAX_TITLE_SIZE = 255;
            this.timeout = 60000;
            this.fileSeparator = System.getProperty("file.separator");
            try {
                this.setGlobalValues(hashtable);
            }
            catch (Throwable throwable) {
                if (!this.logEnabled) break block2;
                this.sop("ERROR: Got an exception, while setting Global Values in ATF Integrator" + throwable.getMessage());
            }
        }
    }

    public void updateInitParams(Hashtable hashtable) {
        this.setGlobalValues(hashtable);
    }

    public void setGlobalValues(Hashtable hashtable) {
        WSDL_URL = (String)hashtable.get("wsdl_url");
        this.userName = (String)hashtable.get("user");
        this.password = (String)hashtable.get("password");
        this.eventSender = (String)hashtable.get("eventSender");
        this.eventSenderType = (String)hashtable.get("eventSenderType");
        this.workGroup = (String)hashtable.get("workGroup");
        this.category = (String)hashtable.get("category");
        this.heartbeatEventConfigItemID = (String)hashtable.get("heartbeatCIID");
        this.heartbeatEventConfigItemIDType = (String)hashtable.get("heartbeatEventCIIDType");
        this.heartbeatWorkGroup = (String)hashtable.get("heartbeatWorkGroup");
        this.heartbeatCategory = (String)hashtable.get("heartbeatCategory");
        this.managerIP = (String)hashtable.get("managerIP");
        this.heartbeatMessage = (String)hashtable.get("heartbeatMessage");
        this.summaryFormat = (String)hashtable.get("ticketTitleFormat");
        this.descriptionFormat = (String)hashtable.get("DescriptionFormat");
        this.targetNamespace = (String)hashtable.get("WSDL_targetNamespace");
        this.WS_ServiceName = (String)hashtable.get("WSDL_ServiceName");
        this.WS_EndpointURLLocation = (String)hashtable.get("WSDL_EndpointURLLocation");
        this.availabilityMeasureStr = (String)hashtable.get("AvailabilityMeasureList");
        this.statusNotificationSubscription = (String)hashtable.get("statusNotificationSubscription");
        this.functionalOrganization = (String)hashtable.get("FunctionalOrganization");
        this.timeoutStr = this.timeoutVal;
        if (this.timeoutStr == null || this.timeoutStr.equals("") || this.timeoutStr.equalsIgnoreCase("null")) {
            this.timeoutStr = "60";
        }
        if (this.timeoutStr != null && !this.timeoutStr.equals("")) {
            try {
                this.timeout = Integer.parseInt(this.timeoutStr);
                this.timeout *= 1000;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.isProxy = (String)hashtable.get("isProxyEnabled");
        if (this.isProxy != null && this.isProxy.trim().equalsIgnoreCase("yes")) {
            this.isProxyEnabled = true;
            this.proxyHostName = (String)hashtable.get("proxyHostName");
            this.proxyPort = (String)hashtable.get("proxyPort");
            System.getProperties().put("proxySet", "true");
            System.getProperties().put("https.proxyHost", this.proxyHostName);
            System.getProperties().put("https.proxyPort", this.proxyPort);
            System.setProperty("jdk.http.auth.tunneling.disabledSchemes", "");
            System.setProperty("jdk.http.auth.proxying.disabledSchemes", "");
            this.isProxyAuthenticated = (String)hashtable.get("isProxyAuthenticated");
            if (this.isProxyAuthenticated != null && this.isProxyAuthenticated.trim().equalsIgnoreCase("yes")) {
                this.isProxyAuth = true;
                this.proxyUserName = (String)hashtable.get("proxyUserName");
                this.proxyPassword = (String)hashtable.get("proxyPassword");
            } else {
                this.isProxyAuth = false;
            }
        } else {
            this.isProxyEnabled = false;
        }
        if (this.statusNotificationSubscription == null || this.statusNotificationSubscription.trim().length() == 0) {
            this.statusNotificationSubscription = "NEVER";
        }
        String string = (String)hashtable.get("titleLength");
        String string2 = (String)hashtable.get("descriptionLength");
        if (string == null || string.length() == 0) {
            string = "255";
        }
        if (string2 == null || string2.length() == 0) {
            string2 = "4000";
        }
        try {
            this.MAX_TITLE_SIZE = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            this.MAX_TITLE_SIZE = 255;
        }
        try {
            this.MAX_DESC_SIZE = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            this.MAX_DESC_SIZE = 4000;
        }
        this.setGlobalValuesForPriority(hashtable);
        if (this.targetNamespace == null || this.targetNamespace.length() == 0) {
            this.targetNamespace = "http://esb.atos.net/wsdl/ESBEventService";
        }
        if (this.WS_ServiceName == null || this.WS_ServiceName.length() == 0) {
            this.WS_ServiceName = "ServiceEventManagemen";
        }
        qName = new QName(this.targetNamespace, this.WS_ServiceName);
        if (this.availabilityMeasureStr != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(this.availabilityMeasureStr, ",");
            this.testAndMeasure_hs = new HashSet();
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                if (string3 == null) continue;
                string3 = string3.trim();
                this.testAndMeasure_hs.add(string3);
            }
        }
    }

    public void setGlobalValuesForPriority(Hashtable hashtable) {
        if (hashtable != null) {
            this.priorityForCritical = (String)hashtable.get("priorityForCritical");
            this.priorityForMajor = (String)hashtable.get("priorityForMajor");
            this.priorityForMinor = (String)hashtable.get("priorityForMinor");
        }
        this.priorityForCritical = this.priorityForCritical != null && this.priorityForCritical.trim().length() > 0 ? this.priorityForCritical : "High";
        this.priorityForMajor = this.priorityForMajor != null && this.priorityForMajor.trim().length() > 0 ? this.priorityForMajor : "Medium";
        this.priorityForMinor = this.priorityForMinor != null && this.priorityForMinor.trim().length() > 0 ? this.priorityForMinor : "Medium";
    }

    public void setGlobalValuesForStatus(Hashtable hashtable) {
        if (hashtable != null) {
            this.statusForAbnormal = (String)hashtable.get("statusForAbnormal");
            this.statusForNormal = (String)hashtable.get("statusForNormal");
        }
        this.statusForAbnormal = this.statusForAbnormal != null && this.statusForAbnormal.trim().length() > 0 ? this.statusForAbnormal : "Active";
        this.statusForNormal = this.statusForNormal != null && this.statusForNormal.trim().length() > 0 ? this.statusForNormal : "Resolved";
    }

    public EventType prepareHeartBeatData() {
        Date date;
        String string = "yyyy-MM-dd'T'HH:mm:ssZ";
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string);
        XMLGregorianCalendar xMLGregorianCalendar = null;
        String string2 = "";
        try {
            if (this.date != null) {
                date = this.date.egetRealDate();
                if (simpleDateFormat != null) {
                    ATFIntegrator aTFIntegrator = this;
                    simpleDateFormat.setTimeZone(aTFIntegrator.date.getTimeZone());
                    string2 = simpleDateFormat.format(date);
                    date = simpleDateFormat.parse(string2);
                    xMLGregorianCalendar = ATFIntegrator.dateToXMLGregorianCalendar(date, true);
                }
                if ((simpleDateFormat = new SimpleDateFormat("YYYYMMddHHmmss")) != null) {
                    date = this.date.egetRealDate();
                    ATFIntegrator aTFIntegrator = this;
                    simpleDateFormat.setTimeZone(aTFIntegrator.date.getTimeZone());
                    string2 = simpleDateFormat.format(date);
                }
            }
        }
        catch (ParseException parseException) {
            this.sop("[ATFIntegrator class]:: Got an ParseException while date parsing. Date:  Error msg: " + parseException.getMessage());
        }
        catch (Exception exception) {
            this.sop("[ATFIntegrator class] Got an Exception :  Error msg: " + exception.getMessage());
        }
        this.tempAlarmID = this.managerIP + "_" + string2;
        date = new EventKeyType();
        date.setEventID(this.tempAlarmID);
        date.setEventSender(this.eventSender);
        EventClassType eventClassType = new EventClassType();
        eventClassType.setEventSenderType(this.eventSenderType);
        eventClassType.setEventMessageText(this.heartbeatMessage);
        eventClassType.setEventType(EventTypeEnumType.HEARTBEAT);
        ConfigItemIDType configItemIDType = new ConfigItemIDType();
        configItemIDType.setIdType(ConfigItemIDTypeEnumType.valueOf((String)this.heartbeatEventConfigItemIDType));
        configItemIDType.setId(this.heartbeatEventConfigItemID);
        EventTimeType eventTimeType = new EventTimeType();
        eventTimeType.setTimeOccured(xMLGregorianCalendar);
        eventTimeType.setTimeSent(xMLGregorianCalendar);
        TroubleTicketType troubleTicketType = new TroubleTicketType();
        if (!(this.heartbeatCategory == null || this.heartbeatCategory.trim().equalsIgnoreCase("$unconfigured") || this.heartbeatCategory.trim().equalsIgnoreCase("none") || this.heartbeatCategory.trim().equals(""))) {
            troubleTicketType.setCategory(this.heartbeatCategory);
        } else {
            this.sop("[ATFIntegrator class] INFO: Heartbeat category is not provided.");
        }
        if (!(this.heartbeatWorkGroup == null || this.heartbeatWorkGroup.trim().equalsIgnoreCase("$unconfigured") || this.heartbeatWorkGroup.trim().equalsIgnoreCase("none") || this.heartbeatWorkGroup.trim().equals(""))) {
            troubleTicketType.setWorkgroup(this.heartbeatWorkGroup);
        } else {
            this.sop("[ATFIntegrator class] INFO: Heartbeat Work Group is not provided.");
        }
        EventType eventType = new EventType();
        eventType.setEventClass(eventClassType);
        eventType.setEventKey((EventKeyType)date);
        eventType.setEventTime(eventTimeType);
        eventType.setConfigItemID(configItemIDType);
        eventType.setTroubleTicket(troubleTicketType);
        return eventType;
    }

    public void sendHeartBeatEvent() {
        try {
            if (this.isProxyAuth && this.proxyUserName != null && !this.proxyUserName.equals("") && this.proxyPassword != null && !this.proxyPassword.equals("")) {
                Authenticator.setDefault(new Authenticator(){

                    protected PasswordAuthentication getPasswordAuthentication() {
                        if (this.getRequestorType() == Authenticator.RequestorType.PROXY && ATFIntegrator.this.proxyUserName != null && ATFIntegrator.this.proxyPassword != null) {
                            return new PasswordAuthentication(ATFIntegrator.this.proxyUserName, ATFIntegrator.this.proxyPassword.toCharArray());
                        }
                        return new PasswordAuthentication(ATFIntegrator.this.userName, ATFIntegrator.this.password.toCharArray());
                    }
                });
            } else {
                Authenticator.setDefault(new Authenticator(){

                    protected PasswordAuthentication getPasswordAuthentication() {
                        return new PasswordAuthentication(ATFIntegrator.this.userName, ATFIntegrator.this.password.toCharArray());
                    }
                });
            }
            if (this.WS_EndpointURLLocation != null && this.WS_EndpointURLLocation.startsWith("https:")) {
                this.disableCertificateValidation();
            }
            File file = new File(EgInstallInfo.getInstallDir() + this.fileSeparator + "manager" + this.fileSeparator + "tomcat" + this.fileSeparator + "webapps" + this.fileSeparator + "final" + this.fileSeparator + "event.wsdl");
            URL uRL = file.toURI().toURL();
            ServiceEventManagemen_Service serviceEventManagemen_Service = new ServiceEventManagemen_Service(uRL, qName);
            ServiceEventManagemen serviceEventManagemen = serviceEventManagemen_Service.getEndpointSOAP11();
            Map map = ((BindingProvider)serviceEventManagemen).getRequestContext();
            map.put("javax.xml.ws.service.endpoint.address", this.WS_EndpointURLLocation);
            map.put("com.sun.xml.ws.developer.JAXWSProperties.CONNECT_TIMEOUT", new Integer(this.timeout));
            map.put("com.sun.xml.ws.connect.timeout", new Integer(this.timeout));
            map.put("com.sun.xml.ws.internal.connect.timeout", new Integer(this.timeout));
            map.put("com.sun.xml.ws.request.timeout", new Integer(this.timeout));
            map.put("com.sun.xml.internal.ws.request.timeout", new Integer(this.timeout));
            AuthenticationType authenticationType = new AuthenticationType();
            authenticationType.setUserName(this.userName);
            authenticationType.setPassword(this.password);
            HeaderBaseType headerBaseType = new HeaderBaseType();
            headerBaseType.setAuthentication(authenticationType);
            HeaderOptionalDestinationType headerOptionalDestinationType = new HeaderOptionalDestinationType();
            headerOptionalDestinationType.setAuthentication(authenticationType);
            Holder holder = new Holder();
            holder.value = headerOptionalDestinationType;
            EventType eventType = this.prepareHeartBeatData();
            String string = "NEVER";
            ReturnType returnType = serviceEventManagemen.createEvent(holder, StatusNotificationSubscriptionEnumType.fromValue((String)string.trim()), eventType);
            if (returnType != null) {
                String string2 = returnType.getReturnCode();
                if (string2 != null && (string2.equalsIgnoreCase("SIA-0000") || string2.equalsIgnoreCase("SIA-0004") || string2.equalsIgnoreCase("SIA-0006"))) {
                    this.sop("INFO: Heart beat created successfully...  Ticket Details-> Ticket Number: " + returnType.getDetail() + " Event ID: " + this.tempAlarmID);
                } else {
                    this.sop("Error: Heartbeat creation got failed with following ReturnCode :: " + string2 + " Details: " + returnType.getDetail());
                }
            }
        }
        catch (CreateEventFault createEventFault) {
            ReturnType returnType = createEventFault.getFaultInfo();
            this.sop("Error: Heartbeat creation got failed with following error message :: ReturnCode: " + returnType.getReturnCode() + " Details: " + returnType.getDetail());
        }
        catch (Throwable throwable) {
            this.sop("Error: Heartbeat creation got failed with following error message :: " + throwable.getMessage());
            throwable.printStackTrace();
        }
    }

    public String createTicket(Object[] objectArray) throws IOException {
        String string = "";
        String string2 = "";
        XMLGregorianCalendar xMLGregorianCalendar = null;
        try {
            ReturnType returnType;
            String string3;
            Object object;
            ConfigItemIDType configItemIDType;
            String string4;
            Comparable<StringBuffer> comparable;
            String string5 = "";
            String string6 = "";
            Hashtable hashtable = null;
            String string7 = "";
            String string8 = (String)objectArray[0];
            String string9 = (String)objectArray[2];
            String string10 = (String)objectArray[3];
            String string11 = (String)objectArray[4];
            String string12 = (String)objectArray[5];
            String string13 = (String)objectArray[6];
            String string14 = (String)objectArray[7];
            String string15 = (String)objectArray[8];
            String string16 = (String)objectArray[9];
            String string17 = (String)objectArray[11];
            String string18 = (String)objectArray[12];
            String string19 = (String)objectArray[13];
            String string20 = (String)objectArray[14];
            try {
                if (this.date != null && this.df != null) {
                    ATFIntegrator aTFIntegrator = this;
                    this.df.setTimeZone(aTFIntegrator.date.getTimeZone());
                    comparable = this.df.parse(string20);
                    xMLGregorianCalendar = ATFIntegrator.dateToXMLGregorianCalendar((Date)comparable, false);
                }
            }
            catch (ParseException parseException) {
                System.out.println("[ATFIntegrator class] Got an ParseException while date parsing. Date:  Error msg: " + parseException.getMessage());
            }
            catch (Exception exception) {
                System.out.println("[ATFIntegrator class] Got an Exception while date parsing. Date:  Error msg: " + exception.getMessage());
            }
            if (string11 != null && string11.indexOf(":") > -1) {
                string7 = string11.substring(0, string11.indexOf(":"));
            } else if (string11 != null) {
                string7 = string11;
            }
            if (this.WS_EndpointURLLocation != null && this.WS_EndpointURLLocation.startsWith("https:")) {
                this.disableCertificateValidation();
            }
            comparable = new StringBuffer();
            ((StringBuffer)comparable).append(" Priority: ");
            ((StringBuffer)comparable).append(string8);
            ((StringBuffer)comparable).append(" Component Type: ");
            ((StringBuffer)comparable).append(string10);
            ((StringBuffer)comparable).append(" Component Name: ");
            ((StringBuffer)comparable).append(string11);
            ((StringBuffer)comparable).append(" Layer: ");
            ((StringBuffer)comparable).append(string12);
            ((StringBuffer)comparable).append(" Problem Description: ");
            ((StringBuffer)comparable).append(string13);
            string2 = ((StringBuffer)comparable).toString();
            hashtable = this.getFormattedData(objectArray);
            if (hashtable != null && !hashtable.isEmpty()) {
                string6 = (String)hashtable.get("summary");
                string5 = (String)hashtable.get("description");
            }
            HashMap hashMap = this.searchForCIInfo(string7);
            String string21 = "";
            String string22 = "CIID";
            String string23 = "";
            if (hashMap != null) {
                string21 = (String)hashMap.get("id");
                string22 = (String)hashMap.get("idType");
                string23 = (String)hashMap.get("configItemSource");
                string4 = (String)hashMap.get("category");
                if (string4 != null && !string4.equals("")) {
                    this.category = string4;
                }
            }
            string4 = this.getMappedPriority(string8);
            if (this.isProxyAuth && this.proxyUserName != null && !this.proxyUserName.equals("") && this.proxyPassword != null && !this.proxyPassword.equals("")) {
                Authenticator.setDefault(new Authenticator(){

                    protected PasswordAuthentication getPasswordAuthentication() {
                        if (this.getRequestorType() == Authenticator.RequestorType.PROXY && ATFIntegrator.this.proxyUserName != null && ATFIntegrator.this.proxyPassword != null) {
                            return new PasswordAuthentication(ATFIntegrator.this.proxyUserName, ATFIntegrator.this.proxyPassword.toCharArray());
                        }
                        return new PasswordAuthentication(ATFIntegrator.this.userName, ATFIntegrator.this.password.toCharArray());
                    }
                });
            } else {
                Authenticator.setDefault(new Authenticator(){

                    protected PasswordAuthentication getPasswordAuthentication() {
                        return new PasswordAuthentication(ATFIntegrator.this.userName, ATFIntegrator.this.password.toCharArray());
                    }
                });
            }
            File file = new File(EgInstallInfo.getInstallDir() + this.fileSeparator + "manager" + this.fileSeparator + "tomcat" + this.fileSeparator + "webapps" + this.fileSeparator + "final" + this.fileSeparator + "event.wsdl");
            URL uRL = file.toURI().toURL();
            ServiceEventManagemen_Service serviceEventManagemen_Service = new ServiceEventManagemen_Service(uRL, qName);
            ServiceEventManagemen serviceEventManagemen = serviceEventManagemen_Service.getEndpointSOAP11();
            Map map = ((BindingProvider)serviceEventManagemen).getRequestContext();
            map.put("javax.xml.ws.service.endpoint.address", this.WS_EndpointURLLocation);
            map.put("com.sun.xml.ws.developer.JAXWSProperties.CONNECT_TIMEOUT", new Integer(this.timeout));
            map.put("com.sun.xml.ws.connect.timeout", new Integer(this.timeout));
            map.put("com.sun.xml.ws.internal.connect.timeout", new Integer(this.timeout));
            map.put("com.sun.xml.ws.request.timeout", new Integer(this.timeout));
            map.put("com.sun.xml.internal.ws.request.timeout", new Integer(this.timeout));
            AuthenticationType authenticationType = new AuthenticationType();
            authenticationType.setUserName(this.userName);
            authenticationType.setPassword(this.password);
            HeaderBaseType headerBaseType = new HeaderBaseType();
            headerBaseType.setAuthentication(authenticationType);
            EventKeyType eventKeyType = new EventKeyType();
            eventKeyType.setEventID(string16);
            eventKeyType.setEventSender(this.eventSender);
            HeaderOptionalDestinationType headerOptionalDestinationType = new HeaderOptionalDestinationType();
            headerOptionalDestinationType.setAuthentication(authenticationType);
            String string24 = string16 + "#" + string8 + "#" + string11;
            EventClassType eventClassType = new EventClassType();
            eventClassType.setEventClass(string24);
            eventClassType.setEventSenderType(this.eventSenderType);
            eventClassType.setEventHostname(string11);
            eventClassType.setEventMessageText(string5);
            if (this.isEventRelatedtoAvailabilityMeasure(string17)) {
                eventClassType.setEventType(EventTypeEnumType.AVAILABILITY);
            } else {
                eventClassType.setEventType(EventTypeEnumType.PERFORMANCE);
            }
            eventClassType.setEventSeverity(string8);
            AdditionalEventAttributesType additionalEventAttributesType = null;
            if (!(this.functionalOrganization == null || this.functionalOrganization.length() <= 0 || this.functionalOrganization.equalsIgnoreCase("null") || this.functionalOrganization.equalsIgnoreCase("none") || this.functionalOrganization.equalsIgnoreCase("$unconfigured"))) {
                configItemIDType = new AdditionalEventAttributeType();
                configItemIDType.setName("FunctionalOrganization");
                configItemIDType.setValue(this.functionalOrganization);
                additionalEventAttributesType = new AdditionalEventAttributesType();
                object = additionalEventAttributesType.getAttribute();
                object.add(configItemIDType);
            }
            configItemIDType = new ConfigItemIDType();
            configItemIDType.setIdType(ConfigItemIDTypeEnumType.valueOf((String)string22));
            configItemIDType.setConfigItemSource(string23);
            configItemIDType.setId(string21);
            object = ATFIntegrator.dateToXMLGregorianCalendar(new Date(), false);
            EventTimeType eventTimeType = new EventTimeType();
            eventTimeType.setTimeOccured(xMLGregorianCalendar);
            eventTimeType.setTimeSent((XMLGregorianCalendar)object);
            TroubleTicketType troubleTicketType = new TroubleTicketType();
            if (!(this.category == null || this.category.trim().equalsIgnoreCase("$unconfigured") || this.category.trim().equalsIgnoreCase("none") || this.category.trim().equals(""))) {
                troubleTicketType.setCategory(this.category);
            }
            if (!(this.workGroup == null || this.workGroup.trim().equalsIgnoreCase("$unconfigured") || this.workGroup.trim().equalsIgnoreCase("none") || this.workGroup.trim().equals(""))) {
                troubleTicketType.setWorkgroup(this.workGroup);
            }
            if ((string3 = this.getMappedPriority(string8)) != null && (string3.trim().equalsIgnoreCase("High") || string3.trim().equalsIgnoreCase("Medium"))) {
                troubleTicketType.setPriority(TroubleTicketPriorityEnumType.fromValue((String)string3.trim()));
            }
            EventType eventType = new EventType();
            eventType.setEventClass(eventClassType);
            eventType.setEventKey(eventKeyType);
            eventType.setEventTime(eventTimeType);
            eventType.setConfigItemID(configItemIDType);
            eventType.setTroubleTicket(troubleTicketType);
            if (additionalEventAttributesType != null) {
                eventType.setAdditionalEventAttributes(additionalEventAttributesType);
            }
            Holder holder = new Holder();
            holder.value = headerOptionalDestinationType;
            if (!(this.statusNotificationSubscription == null || this.statusNotificationSubscription.trim().equals("ALWAYS") || this.statusNotificationSubscription.trim().equals("RESOLVE") || this.statusNotificationSubscription.trim().equals("NEVER"))) {
                this.statusNotificationSubscription = "NEVER";
            }
            if ((returnType = serviceEventManagemen.createEvent(holder, StatusNotificationSubscriptionEnumType.fromValue((String)this.statusNotificationSubscription.trim()), eventType)) != null) {
                String string25 = returnType.getReturnCode();
                if (string25 != null && (string25.equalsIgnoreCase("SIA-0000") || string25.equalsIgnoreCase("SIA-0004") || string25.equalsIgnoreCase("SIA-0006"))) {
                    if (this.logEnabled) {
                        this.sop("INFO: Ticket has been created successfully...  Ticket Details-> Ticket Number: " + returnType.getDetail() + " Event ID: " + string16 + " " + string2);
                    }
                    string = string16;
                } else if (this.logEnabled) {
                    this.sop("Error: Ticket creation got failed with following ReturnCode :: " + string25 + " Details: " + returnType.getDetail() + " Ticket Details->  " + string2);
                }
            }
        }
        catch (CreateEventFault createEventFault) {
            ReturnType returnType = createEventFault.getFaultInfo();
            if (this.logEnabled) {
                this.sop("Error: Ticket creation got failed with following error message :: ReturnCode: " + returnType.getReturnCode() + " Details: " + returnType.getDetail());
            }
        }
        catch (Throwable throwable) {
            if (this.logEnabled) {
                this.sop("Error: Ticket creation got failed with following error message :: " + throwable.getMessage());
            }
            throwable.printStackTrace();
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateTicket(String string, Object[] objectArray) throws IOException {
        Comparable<Date> comparable;
        Object var3_3 = null;
        String string2 = "update";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        String string6 = "";
        XMLGregorianCalendar xMLGregorianCalendar = null;
        boolean bl = false;
        boolean bl2 = false;
        String string7 = (String)objectArray[0];
        Object object = (String)objectArray[2];
        String string8 = (String)objectArray[3];
        String string9 = (String)objectArray[4];
        String string10 = (String)objectArray[5];
        String string11 = (String)objectArray[6];
        String string12 = (String)objectArray[7];
        String string13 = (String)objectArray[8];
        String string14 = (String)objectArray[9];
        String string15 = (String)objectArray[14];
        if (this.WS_EndpointURLLocation != null && this.WS_EndpointURLLocation.startsWith("https:")) {
            this.disableCertificateValidation();
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" Priority: ");
        stringBuffer.append(string7);
        stringBuffer.append(" Component Type: ");
        stringBuffer.append(string8);
        stringBuffer.append(" Component Name: ");
        stringBuffer.append(string9);
        stringBuffer.append(" Layer: ");
        stringBuffer.append(string10);
        stringBuffer.append(" Problem Description: ");
        stringBuffer.append(string11);
        string6 = stringBuffer.toString();
        try {
            if (this.date != null && this.df != null) {
                ATFIntegrator aTFIntegrator = this;
                this.df.setTimeZone(aTFIntegrator.date.getTimeZone());
                comparable = this.df.parse(string15);
                xMLGregorianCalendar = ATFIntegrator.dateToXMLGregorianCalendar((Date)comparable, false);
            }
        }
        catch (ParseException parseException) {
            System.out.println("[ATFIntegrator class] Got an ParseException while date parsing. Date:  Error msg: " + parseException.getMessage());
        }
        catch (Exception exception) {
            System.out.println("[ATFIntegrator class] Got an Exception while date parsing. Date:  Error msg: " + exception.getMessage());
        }
        if (string7 == null || !string7.equalsIgnoreCase("Normal")) {
            if (this.logEnabled) {
                this.sop("INFO: Ticket updation got skipped(since ATF REST API is not supporting update action). Details-> Event ID: " + string + " " + string6);
            }
            boolean bl3 = false;
            return bl3;
        }
        bl = true;
        string2 = "resolve";
        try {
            if (this.isProxyAuth && this.proxyUserName != null && !this.proxyUserName.equals("") && this.proxyPassword != null && !this.proxyPassword.equals("")) {
                Authenticator.setDefault(new Authenticator(){

                    protected PasswordAuthentication getPasswordAuthentication() {
                        if (this.getRequestorType() == Authenticator.RequestorType.PROXY && ATFIntegrator.this.proxyUserName != null && ATFIntegrator.this.proxyPassword != null) {
                            return new PasswordAuthentication(ATFIntegrator.this.proxyUserName, ATFIntegrator.this.proxyPassword.toCharArray());
                        }
                        return new PasswordAuthentication(ATFIntegrator.this.userName, ATFIntegrator.this.password.toCharArray());
                    }
                });
            } else {
                Authenticator.setDefault(new Authenticator(){

                    protected PasswordAuthentication getPasswordAuthentication() {
                        return new PasswordAuthentication(ATFIntegrator.this.userName, ATFIntegrator.this.password.toCharArray());
                    }
                });
            }
            comparable = new File(EgInstallInfo.getInstallDir() + this.fileSeparator + "manager" + this.fileSeparator + "tomcat" + this.fileSeparator + "webapps" + this.fileSeparator + "final" + this.fileSeparator + "event.wsdl");
            URL uRL = ((File)comparable).toURI().toURL();
            ServiceEventManagemen_Service serviceEventManagemen_Service = new ServiceEventManagemen_Service(uRL, qName);
            ServiceEventManagemen serviceEventManagemen = serviceEventManagemen_Service.getEndpointSOAP11();
            Map map = ((BindingProvider)serviceEventManagemen).getRequestContext();
            map.put("javax.xml.ws.service.endpoint.address", this.WS_EndpointURLLocation);
            map.put("com.sun.xml.ws.developer.JAXWSProperties.CONNECT_TIMEOUT", new Integer(this.timeout));
            map.put("com.sun.xml.ws.connect.timeout", new Integer(this.timeout));
            map.put("com.sun.xml.ws.internal.connect.timeout", new Integer(this.timeout));
            map.put("com.sun.xml.ws.request.timeout", new Integer(this.timeout));
            map.put("com.sun.xml.internal.ws.request.timeout", new Integer(this.timeout));
            AuthenticationType authenticationType = new AuthenticationType();
            authenticationType.setUserName(this.userName);
            authenticationType.setPassword(this.password);
            HeaderBaseType headerBaseType = new HeaderBaseType();
            headerBaseType.setAuthentication(authenticationType);
            EventKeyType eventKeyType = new EventKeyType();
            eventKeyType.setEventID(string);
            eventKeyType.setEventSender(this.eventSender);
            HeaderOptionalDestinationType headerOptionalDestinationType = new HeaderOptionalDestinationType();
            headerOptionalDestinationType.setAuthentication(authenticationType);
            XMLGregorianCalendar xMLGregorianCalendar2 = ATFIntegrator.dateToXMLGregorianCalendar(new Date(), false);
            EventTimeType eventTimeType = new EventTimeType();
            eventTimeType.setTimeOccured(xMLGregorianCalendar);
            eventTimeType.setTimeSent(xMLGregorianCalendar2);
            EventResolveType eventResolveType = new EventResolveType();
            eventResolveType.setEventKey(eventKeyType);
            eventResolveType.setEventTime(eventTimeType);
            Holder holder = new Holder();
            holder.value = headerOptionalDestinationType;
            ReturnType returnType = serviceEventManagemen.resolveEvent(holder, eventResolveType);
            if (returnType != null) {
                if (returnType.getReturnCode().equalsIgnoreCase("SIA-0000")) {
                    if (this.logEnabled) {
                        this.sop("INFO: Ticket has been resolved successfully...  Ticket Details-> Ticket Number: " + returnType.getDetail() + " Event ID: " + string + " " + string6);
                    }
                    bl2 = true;
                } else if (this.logEnabled) {
                    this.sop("Error: Failed to resolve the Ticket with following ReturnCode :: " + returnType.getReturnCode() + " Detail: " + returnType.getDetail() + " Ticket Details->  " + string6);
                }
            }
        }
        catch (ResolveEventFault resolveEventFault) {
            object = resolveEventFault.getFaultInfo();
            if (this.logEnabled) {
                this.sop("Error: Failed to resolve ticket. with following error message :: ReturnCode: " + object.getReturnCode() + " Event ID: " + string + " Details: " + object.getDetail());
            }
        }
        catch (Throwable throwable) {
            if (this.logEnabled) {
                this.sop("ERROR: Failed to resolve ticket. with following error message :: " + throwable.getMessage() + " Ticket Details->  Event ID: " + string + " " + string6);
            }
            throwable.printStackTrace();
        }
        return bl2;
    }

    private String getMappedPriority(String string) {
        if (string != null) {
            if (string.equalsIgnoreCase("Critical")) {
                string = this.priorityForCritical;
            } else if (string.equalsIgnoreCase("Major")) {
                string = this.priorityForMajor;
            } else if (string.equalsIgnoreCase("Minor")) {
                string = this.priorityForMinor;
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Hashtable getFormattedData(Object[] objectArray) {
        String string = "";
        Hashtable<String, String> hashtable = null;
        String string2 = (String)objectArray[0];
        String string3 = (String)objectArray[2];
        String string4 = (String)objectArray[3];
        String string5 = (String)objectArray[4];
        String string6 = (String)objectArray[5];
        String string7 = (String)objectArray[6];
        String string8 = (String)objectArray[7];
        String string9 = (String)objectArray[8];
        try {
            hashtable = new Hashtable<String, String>();
            if (this.descriptionFormat != null && !this.descriptionFormat.equals("")) {
                hashtable.put("description", this.descriptionFormat);
            } else {
                hashtable.put("description", this.DefaultDescFormat);
            }
            if (this.descriptionFormat != null && !this.descriptionFormat.equals("")) {
                hashtable.put("summary", this.summaryFormat);
            } else {
                hashtable.put("summary", string7);
            }
            if (hashtable != null && !hashtable.isEmpty()) {
                Set set = hashtable.keySet();
                for (String string10 : set) {
                    string = (String)hashtable.get(string10);
                    if (string10 == null || string == null) continue;
                    if (string.indexOf("$cname") > -1) {
                        string = this.replace(string, "$cname", string5);
                    }
                    if (string.indexOf("$ctype") > -1) {
                        string = this.replace(string, "$ctype", string4);
                    }
                    if (string.indexOf("$prior") > -1) {
                        string = this.replace(string, "$prior", string2);
                    }
                    if (string.indexOf("$pdesc") > -1) {
                        string = this.replace(string, "$pdesc", string7);
                    }
                    if (string.indexOf("$layer") > -1) {
                        string = this.replace(string, "$layer", string6);
                    }
                    if (string.indexOf("$starttime") > -1) {
                        string = this.replace(string, "$starttime", string8);
                    }
                    if (string.indexOf("$Service") > -1) {
                        string = this.replace(string, "$Service", string3);
                    }
                    if (string.indexOf("$user") > -1) {
                        string = this.replace(string, "$user", string9);
                    }
                    if (string10.equalsIgnoreCase("summary")) {
                        if (string.length() > this.MAX_TITLE_SIZE) {
                            string = string.substring(0, this.MAX_TITLE_SIZE - 4);
                            string = string + "...";
                        }
                    } else if (string10.equalsIgnoreCase("description") && string.length() > this.MAX_DESC_SIZE) {
                        string = string.substring(0, this.MAX_DESC_SIZE - 4);
                        string = string + "...";
                    }
                    hashtable.put(string10, string);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            try {
                return hashtable;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return hashtable;
    }

    protected boolean isEventRelatedtoAvailabilityMeasure(String string) {
        boolean bl = false;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        Hashtable hashtable = new Hashtable();
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            StringTokenizer stringTokenizer2 = new StringTokenizer(string2, "|");
            if (stringTokenizer2.countTokens() < 4) continue;
            String string3 = stringTokenizer2.nextToken();
            String string4 = stringTokenizer2.nextToken();
            String string5 = stringTokenizer2.nextToken();
            String string6 = stringTokenizer2.nextToken();
            String string7 = string5 + ":" + string6;
            if (this.testAndMeasure_hs == null || !this.testAndMeasure_hs.contains(string7)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public HashMap searchForCIInfo(String string) {
        HashMap<String, String> hashMap = null;
        String string2 = "#";
        String string3 = "ATF_CI_MAPPING";
        String string4 = EgInstallInfo.getInstallDir() + this.fileSeparator + "manager" + this.fileSeparator + "config" + this.fileSeparator + "eg_tt_ci_mapping.ini";
        File file = new File(string4);
        IniFile iniFile = new IniFile(string4);
        String string5 = iniFile.getValue(string3, string);
        hashMap = new HashMap<String, String>();
        String string6 = "";
        String string7 = "";
        if (string5 != null && !string5.trim().equals("")) {
            if (string5.indexOf(string2) > -1) {
                String string8 = string5.substring(0, string5.indexOf(string2));
                String string9 = string5.substring(string5.indexOf(string2) + 1);
                hashMap.put("id", string8);
                if (string9 != null && string9.indexOf(string2) > -1) {
                    String string10 = string9.substring(0, string9.indexOf(string2));
                    string6 = string9.substring(string9.indexOf(string2) + 1);
                    if (string6 != null && string6.indexOf(string2) > -1) {
                        string7 = string6.substring(string6.indexOf(string2) + 1);
                        string6 = string6.substring(0, string6.indexOf(string2));
                    }
                    string9 = string10;
                }
                hashMap.put("idType", string9);
                hashMap.put("configItemSource", string6);
                hashMap.put("category", string7);
            } else {
                hashMap.put("id", "");
                hashMap.put("idType", "CIID");
                hashMap.put("configItemSource", "");
                hashMap.put("category", "");
            }
        } else {
            System.out.println("[ATFIntegrator class] INFO: CI entry is not found for component name [" + string + "] in eg_tt_ci_mapping.ini ");
            hashMap.put("id", "");
            hashMap.put("idType", "CIID");
            hashMap.put("configItemSource", "");
            hashMap.put("category", "");
        }
        return hashMap;
    }

    public static XMLGregorianCalendar dateToXMLGregorianCalendar(Date date, boolean bl) {
        Object object;
        TimeZone timeZone = null;
        if (bl) {
            new EgDateInfo();
            timeZone = EgDateInfo.getTimeZone();
        } else {
            object = "UTC";
            timeZone = TimeZone.getTimeZone((String)object);
        }
        object = null;
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(date);
        gregorianCalendar.setTimeZone(timeZone);
        try {
            DatatypeFactory datatypeFactory = DatatypeFactory.newInstance();
            object = datatypeFactory.newXMLGregorianCalendar(gregorianCalendar);
        }
        catch (Exception exception) {
            System.out.println("[ATFIntegrator class]Exception in conversion of Date to XMLGregorianCalendar" + exception.getMessage());
        }
        return object;
    }

    public void disableCertificateValidation() {
        TrustManager[] trustManagerArray = new TrustManager[]{new X509TrustManager(){

            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }

            public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) {
            }

            public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) {
            }
        }};
        HostnameVerifier hostnameVerifier = new HostnameVerifier(){

            public boolean verify(String string, SSLSession sSLSession) {
                return true;
            }
        };
        try {
            SSLContext sSLContext = SSLContext.getInstance("SSL");
            sSLContext.init(null, trustManagerArray, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sSLContext.getSocketFactory());
            HttpsURLConnection.setDefaultHostnameVerifier(hostnameVerifier);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

