/*
 * Decompiled with CFR 0.152.
 */
package com.eg;

import com.eg.EgCrypt;
import com.eg.EgDbServlet;
import com.eg.EgInstallInfo;
import com.eg.EgLoggerLite;
import com.eg.IniFile;
import com.eg.KerberosCallbackHandler;
import com.eg.KerberosCredentialsProvider;
import com.eg.Lookup;
import com.eg.UserSearch;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.login.LoginContext;

public class KerberosAuthentication
implements KerberosCredentialsProvider {
    String Err = "";
    private String realm;
    private String kdc;
    private String krbFile;
    private String s_iniFile_dir;
    public ArrayList errorList = new ArrayList();
    private IniFile iniFile = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_authenticate.ini");
    private IniFile mgrMiscFile = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_mgrmisc.ini");
    String domain = "";
    private EgLoggerLite adUserTrackerLog = null;
    private boolean logEnabled = false;

    public KerberosAuthentication(String string) {
        this.krbFile = string;
        System.setProperty("java.security.krb5.conf", this.krbFile);
        this.s_iniFile_dir = EgInstallInfo.getInstallDir() + "/manager/config/KerberosAuth.config";
        System.setProperty("java.security.auth.login.config", this.s_iniFile_dir);
        this.adUserTrackerLog = new EgLoggerLite(EgInstallInfo.getInstallDir() + "/manager/logs/ADLogons.log", 10, 5);
        String string2 = this.mgrMiscFile.getValue("MISC_ARGS", "TraceADLogons");
        if (string2 != null && (string2.equalsIgnoreCase("yes") || string2.equalsIgnoreCase("true"))) {
            this.logEnabled = true;
        }
    }

    public KerberosAuthentication(String string, String string2) {
        this.krbFile = string;
        this.domain = string2;
        System.setProperty("java.security.krb5.conf", this.krbFile);
        this.s_iniFile_dir = EgInstallInfo.getInstallDir() + "/manager/config/KerberosAuth.config";
        System.setProperty("java.security.auth.login.config", this.s_iniFile_dir);
        this.adUserTrackerLog = new EgLoggerLite(EgInstallInfo.getInstallDir() + "/manager/logs/ADLogons.log", 10, 5);
        String string3 = this.mgrMiscFile.getValue("MISC_ARGS", "TraceADLogons");
        if (string3 != null && (string3.equalsIgnoreCase("yes") || string3.equalsIgnoreCase("true"))) {
            this.logEnabled = true;
        }
    }

    public KerberosAuthentication() {
        this.adUserTrackerLog = new EgLoggerLite(EgInstallInfo.getInstallDir() + "/manager/logs/ADLogons.log", 10, 5);
        String string = this.mgrMiscFile.getValue("MISC_ARGS", "TraceADLogons");
        if (string != null && (string.equalsIgnoreCase("yes") || string.equalsIgnoreCase("true"))) {
            this.logEnabled = true;
        }
    }

    @Override
    public int login(String string, String string2, String string3) {
        LoginContext loginContext = null;
        String string4 = "";
        if (string == null || "".equals(string)) {
            this.setErrorMessage("Domain is empty or null");
            return -1;
        }
        if (string2 == null || "".equals(string2)) {
            this.setErrorMessage("User name is empty or null");
            return -1;
        }
        try {
            System.setProperty("java.security.auth.login.config", this.s_iniFile_dir);
            System.setProperty("java.security.krb5.conf", this.krbFile);
            loginContext = new LoginContext("KerberosAuth", new KerberosCallbackHandler(string2, string3));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.setErrorMessage("Exception occured - " + exception.getMessage());
            StringWriter stringWriter = new StringWriter();
            exception.printStackTrace(new PrintWriter(stringWriter));
            System.out.println("##Start");
            System.out.println("##krbErrors=" + stringWriter.toString() + "##End");
            if (this.logEnabled) {
                this.adUserTrackerLog.error("[KerberosAuthentication][login] Exception :" + stringWriter.toString());
            }
            EgDbServlet.logToErrorFile((String)"ERROR", (String)"Domain Authentication failed", (String)stringWriter.toString());
            String string5 = exception.getMessage();
            if (string5.indexOf("Clock skew too great") > -1) {
                this.errorList.add("KERBEROS");
                this.errorList.add("Clock skew too great");
                this.errorList.add(exception);
                return -9;
            }
            if (string5.indexOf("Identifier doesn't match expected value") > -1) {
                this.errorList.add("KERBEROS");
                this.errorList.add("Identifier");
                this.errorList.add(exception);
                return -11;
            }
            if (string5.indexOf("Receive timed out") > -1) {
                this.errorList.add("KERBEROS");
                this.errorList.add("Receive timed out");
                this.errorList.add(exception);
                return -1;
            }
            if (string5.indexOf("Clients credentials have been revoked") > -1) {
                this.errorList.add("KERBEROS");
                this.errorList.add("Clients credentials have been revoked");
                this.errorList.add(exception);
                return -1;
            }
            if (string5.indexOf("Server not found in Kerberos database") > -1) {
                this.errorList.add("KERBEROS");
                this.errorList.add("Server not found in Kerberos database");
                this.errorList.add(exception);
                return -1;
            }
            if (string5.indexOf("KDC has no support for encryption type") > -1) {
                this.errorList.add("KERBEROS");
                this.errorList.add("KDC has no support for encryption type");
                this.errorList.add(exception);
                return -1;
            }
            if (string5.indexOf("Password has expired - change password to reset") > -1) {
                this.errorList.add("KERBEROS");
                this.errorList.add("Password has expired - change password to reset");
                this.errorList.add(exception);
                return -1;
            }
            if (string5.indexOf("Cannot get kdc for realm") > -1) {
                this.errorList.add("KERBEROS");
                String string6 = string5;
                string6 = string6.substring(string6.indexOf(":") + 1);
                string6 = string6.trim();
                this.errorList.add(string6);
                this.errorList.add(exception);
                return -1;
            }
            this.errorList.add("KERBEROS");
            this.errorList.add("Error in Connecting with AD sever");
            this.errorList.add(exception);
            return -1;
        }
        try {
            loginContext.login();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            loginContext = null;
            this.setErrorMessage("Exception occured - " + exception.getMessage());
            StringWriter stringWriter = new StringWriter();
            exception.printStackTrace(new PrintWriter(stringWriter));
            System.out.println("##Start");
            System.out.println("##krbErrors=" + stringWriter.toString() + "##End");
            if (this.logEnabled) {
                this.adUserTrackerLog.error("[KerberosAuthentication][login] Exception :" + stringWriter.toString());
            }
            EgDbServlet.logToErrorFile((String)"ERROR", (String)"Domain Authentication failed ", (String)stringWriter.toString());
            String string7 = exception.getMessage();
            if (string7.indexOf("Pre-authentication information was invalid") > -1) {
                this.errorList.add("KERBEROS");
                this.errorList.add("Pre-authentication");
                this.errorList.add(exception);
                return -2;
            }
            if (string7.indexOf("Clock skew too great") > -1) {
                this.errorList.add("KERBEROS");
                this.errorList.add("Clock skew too great");
                this.errorList.add(exception);
                return -9;
            }
            if (string7.indexOf("Identifier doesn't match expected value") > -1) {
                this.errorList.add("KERBEROS");
                this.errorList.add("Identifier");
                this.errorList.add(exception);
                return -11;
            }
            if (string7.indexOf("Client not found in Kerberos database") > -1) {
                this.errorList.add("KERBEROS");
                this.errorList.add("Client not found in Kerberos database");
                this.errorList.add(exception);
                return -2;
            }
            if (string7.indexOf("Receive timed out") > -1) {
                this.errorList.add("KERBEROS");
                this.errorList.add("Receive timed out");
                this.errorList.add(exception);
                return -1;
            }
            if (string7.indexOf("Clients credentials have been revoked") > -1) {
                this.errorList.add("KERBEROS");
                this.errorList.add("Clients credentials have been revoked");
                this.errorList.add(exception);
                return -1;
            }
            if (string7.indexOf("Server not found in Kerberos database") > -1) {
                this.errorList.add("KERBEROS");
                this.errorList.add("Server not found in Kerberos database");
                this.errorList.add(exception);
                return -1;
            }
            if (string7.indexOf("KDC has no support for encryption type") > -1) {
                this.errorList.add("KERBEROS");
                this.errorList.add("KDC has no support for encryption type");
                this.errorList.add(exception);
                return -1;
            }
            if (string7.indexOf("Password has expired - change password to reset") > -1) {
                this.errorList.add("KERBEROS");
                this.errorList.add("Password has expired - change password to reset");
                this.errorList.add(exception);
                return -1;
            }
            if (string7.indexOf("Cannot get kdc for realm") > -1) {
                this.errorList.add("KERBEROS");
                String string8 = string7;
                string8 = string8.substring(string8.indexOf(":") + 1);
                string8 = string8.trim();
                this.errorList.add(string8);
                this.errorList.add(exception);
                return -1;
            }
            this.errorList.add("KERBEROS");
            this.errorList.add("Error in Connecting with AD sever");
            this.errorList.add(exception);
            return -1;
        }
        Subject subject = loginContext.getSubject();
        Set<Principal> set = subject.getPrincipals();
        Object[] objectArray = subject.getPrincipals().toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            if (!(objectArray[i] instanceof KerberosPrincipal)) continue;
            KerberosPrincipal kerberosPrincipal = (KerberosPrincipal)objectArray[i];
            string4 = kerberosPrincipal.getName();
            break;
        }
        if (this.logEnabled) {
            this.adUserTrackerLog.log("[KerberosAuthentication][login] The logged in user is " + string4);
        }
        try {
            if (loginContext != null) {
                loginContext.logout();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0;
    }

    @Override
    public String getErrorMessage() {
        return this.Err;
    }

    @Override
    public void setErrorMessage(String string) {
        this.Err = string;
    }

    @Override
    public boolean isUserAvailable(String string, String string2, String string3, String string4, String string5) {
        Object object;
        LoginContext loginContext = null;
        String string6 = "";
        if (string == null || "".equals(string)) {
            this.setErrorMessage("Domain is empty or null");
            return false;
        }
        if (string2 == null || "".equals(string2)) {
            this.setErrorMessage("Connect user name is empty or null");
            return false;
        }
        try {
            System.setProperty("java.security.auth.login.config", this.s_iniFile_dir);
            System.setProperty("java.security.krb5.conf", this.krbFile);
            loginContext = new LoginContext("KerberosAuth", new KerberosCallbackHandler(string2, string3));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.setErrorMessage("Exception occured - " + exception.getMessage());
            if (this.logEnabled) {
                StringWriter stringWriter = new StringWriter();
                exception.printStackTrace(new PrintWriter(stringWriter));
                this.adUserTrackerLog.error("[KerberosAuthentication][isUserAvailable] Exception " + stringWriter.toString());
            }
            return false;
        }
        try {
            loginContext.login();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            loginContext = null;
            this.setErrorMessage("Exception occured - " + exception.getMessage());
            if (this.logEnabled) {
                StringWriter stringWriter = new StringWriter();
                exception.printStackTrace(new PrintWriter(stringWriter));
                this.adUserTrackerLog.error("[KerberosAuthentication][isUserAvailable] Exception " + stringWriter.toString());
            }
            return false;
        }
        Subject subject = loginContext.getSubject();
        Object[] objectArray = subject.getPrincipals().toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            if (!(objectArray[i] instanceof KerberosPrincipal)) continue;
            object = (KerberosPrincipal)objectArray[i];
            string6 = ((KerberosPrincipal)object).getName();
            break;
        }
        if (this.logEnabled) {
            this.adUserTrackerLog.log("[KerberosAuthentication][isUserAvailable] The logged in user is " + string6);
        }
        Lookup lookup = new Lookup();
        object = lookup.getSubject(this.domain);
        String string7 = lookup.getAliasNameForDomain(this.domain);
        String string8 = this.iniFile.getValue((String)object, "isSSL");
        String string9 = string;
        if (string7 != null && string7.length() > 0) {
            string9 = string7;
        }
        Boolean bl = (Boolean)Subject.doAs(loginContext.getSubject(), new UserSearch(string9, string4, string5, string8));
        try {
            if (loginContext != null) {
                loginContext.logout();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    public int CheckUserAvailable(String string, String string2, String string3, String string4, String string5) {
        Object object;
        LoginContext loginContext = null;
        String string6 = "";
        if (string == null || "".equals(string)) {
            this.setErrorMessage("Domain is empty or null");
            return 2;
        }
        if (string2 == null || "".equals(string2)) {
            this.setErrorMessage("Connect user name is empty or null");
            return 2;
        }
        try {
            System.setProperty("java.security.auth.login.config", this.s_iniFile_dir);
            System.setProperty("java.security.krb5.conf", this.krbFile);
            loginContext = new LoginContext("KerberosAuth", new KerberosCallbackHandler(string2, string3));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.setErrorMessage("Exception occured - " + exception.getMessage());
            StringWriter stringWriter = new StringWriter();
            exception.printStackTrace(new PrintWriter(stringWriter));
            System.out.println("##Start");
            System.out.println("##krbErrors=" + stringWriter.toString() + "##End");
            if (this.logEnabled) {
                this.adUserTrackerLog.error("[KerberosAuthentication][CheckUserAvailable] Exception " + stringWriter.toString());
            }
            EgDbServlet.logToErrorFile((String)"ERROR", (String)"Auto Discovery of domain failed", (String)stringWriter.toString());
            String string7 = exception.getMessage();
            System.out.println("msg====" + string7);
            if (string7.indexOf("Clock skew too great") > -1) {
                this.errorList.add("KERBEROS");
                this.errorList.add("Clock skew too great");
                this.errorList.add(exception);
                return -9;
            }
            if (string7.indexOf("Identifier doesn't match expected value") > -1) {
                this.errorList.add("KERBEROS");
                this.errorList.add("Identifier");
                this.errorList.add(exception);
                return -11;
            }
            if (string7.indexOf("Client not found in Kerberos database") > -1) {
                this.errorList.add("KERBEROS");
                this.errorList.add("Client not found in Kerberos database");
                this.errorList.add(exception);
                return -2;
            }
            if (string7.indexOf("Pre-authentication information was invalid") > -1) {
                this.errorList.add("KERBEROS");
                this.errorList.add("Pre-authentication");
                this.errorList.add(exception);
                return -1;
            }
            if (string7.indexOf("Receive timed out") > -1) {
                this.errorList.add("KERBEROS");
                this.errorList.add("Receive timed out");
                this.errorList.add(exception);
                return -1;
            }
            if (string7.indexOf("Clients credentials have been revoked") > -1) {
                this.errorList.add("KERBEROS");
                this.errorList.add("Clients credentials have been revoked");
                this.errorList.add(exception);
                return -1;
            }
            if (string7.indexOf("Server not found in Kerberos database") > -1) {
                this.errorList.add("KERBEROS");
                this.errorList.add("Server not found in Kerberos database");
                this.errorList.add(exception);
                return -1;
            }
            if (string7.indexOf("KDC has no support for encryption type") > -1) {
                this.errorList.add("KERBEROS");
                this.errorList.add("KDC has no support for encryption type");
                this.errorList.add(exception);
                return -1;
            }
            if (string7.indexOf("Password has expired - change password to reset") > -1) {
                this.errorList.add("KERBEROS");
                this.errorList.add("Password has expired - change password to reset");
                this.errorList.add(exception);
                return -1;
            }
            if (string7.indexOf("Cannot get kdc for realm") > -1) {
                this.errorList.add("KERBEROS");
                String string8 = string7;
                string8 = string8.substring(string8.indexOf(":") + 1);
                string8 = string8.trim();
                this.errorList.add(string8);
                this.errorList.add(exception);
                return -1;
            }
            this.errorList.add("KERBEROS");
            this.errorList.add("Error in Connecting with AD sever");
            this.errorList.add(exception);
            return -1;
        }
        try {
            loginContext.login();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            loginContext = null;
            this.setErrorMessage("Exception occured - " + exception.getMessage());
            StringWriter stringWriter = new StringWriter();
            exception.printStackTrace(new PrintWriter(stringWriter));
            System.out.println("##Start");
            System.out.println("##krbErrors=" + stringWriter.toString() + "##End");
            if (this.logEnabled) {
                this.adUserTrackerLog.error("[KerberosAuthentication][CheckUserAvailable] Exception " + stringWriter.toString());
            }
            EgDbServlet.logToErrorFile((String)"ERROR", (String)"Auto Discovery of domain failed", (String)stringWriter.toString());
            String string9 = exception.getMessage();
            if (string9.indexOf("Clock skew too great") > -1) {
                this.errorList.add("KERBEROS");
                this.errorList.add("Clock skew too great");
                this.errorList.add(exception);
                return -9;
            }
            if (string9.indexOf("Identifier doesn't match expected value") > -1) {
                this.errorList.add("KERBEROS");
                this.errorList.add("Invalid Credentials");
                this.errorList.add(exception);
                return -11;
            }
            if (string9.indexOf("Client not found in Kerberos database") > -1) {
                this.errorList.add("KERBEROS");
                this.errorList.add("Client not found in Kerberos database");
                this.errorList.add(exception);
                return -2;
            }
            if (string9.indexOf("Pre-authentication information was invalid") > -1) {
                this.errorList.add("KERBEROS");
                this.errorList.add("Pre-authentication");
                this.errorList.add(exception);
                return -1;
            }
            if (string9.indexOf("Receive timed out") > -1) {
                this.errorList.add("KERBEROS");
                this.errorList.add("Receive timed out");
                this.errorList.add(exception);
                return -1;
            }
            if (string9.indexOf("Clients credentials have been revoked") > -1) {
                this.errorList.add("KERBEROS");
                this.errorList.add("Clients credentials have been revoked");
                this.errorList.add(exception);
                return -1;
            }
            if (string9.indexOf("Server not found in Kerberos database") > -1) {
                this.errorList.add("KERBEROS");
                this.errorList.add("Server not found in Kerberos database");
                this.errorList.add(exception);
                return -1;
            }
            if (string9.indexOf("KDC has no support for encryption type") > -1) {
                this.errorList.add("KERBEROS");
                this.errorList.add("KDC has no support for encryption type");
                this.errorList.add(exception);
                return -1;
            }
            if (string9.indexOf("Password has expired - change password to reset") > -1) {
                this.errorList.add("KERBEROS");
                this.errorList.add("Password has expired - change password to reset");
                this.errorList.add(exception);
                return -1;
            }
            if (string9.indexOf("Cannot get kdc for realm") > -1) {
                this.errorList.add("KERBEROS");
                String string10 = string9;
                string10 = string10.substring(string10.indexOf(":") + 1);
                string10 = string10.trim();
                this.errorList.add(string10);
                this.errorList.add(exception);
                return -1;
            }
            this.errorList.add("KERBEROS");
            this.errorList.add("Error in Connecting with AD sever");
            this.errorList.add(exception);
            return -1;
        }
        Subject subject = loginContext.getSubject();
        Object[] objectArray = subject.getPrincipals().toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            if (!(objectArray[i] instanceof KerberosPrincipal)) continue;
            object = (KerberosPrincipal)objectArray[i];
            string6 = ((KerberosPrincipal)object).getName();
            break;
        }
        if (this.logEnabled) {
            this.adUserTrackerLog.log("[KerberosAuthentication][CheckUserAvailable] The logged in user is " + string6);
        }
        Lookup lookup = new Lookup();
        object = lookup.getSubject(this.domain);
        String string11 = lookup.getAliasNameForDomain(this.domain);
        String string12 = this.iniFile.getValue((String)object, "isSSL");
        String string13 = string;
        if (string11 != null && string11.length() > 0) {
            string13 = string11;
        }
        UserSearch userSearch = new UserSearch(string13, string4, string5, string12);
        Boolean bl = (Boolean)Subject.doAs(loginContext.getSubject(), userSearch);
        try {
            if (loginContext != null) {
                loginContext.logout();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (bl.booleanValue()) {
            return 0;
        }
        this.errorList.add("KERBEROS");
        ArrayList arrayList = new ArrayList();
        arrayList = userSearch.errorList;
        if (this.logEnabled) {
            this.adUserTrackerLog.error("[KerberosAuthentication][CheckUserAvailable][UserSearch] Exception " + arrayList);
        }
        System.out.println("##domainErrors=" + arrayList);
        int n = arrayList.indexOf("EXCEPTION");
        if (n > -1) {
            Exception exception = (Exception)arrayList.get(n + 1);
            this.errorList.add("PRE_EXCEPTION");
            this.errorList.add(exception);
        } else {
            this.errorList.add("USER_EXCEPTION");
        }
        return -2;
    }

    public int CheckUserAvailableForDomainReg(String string, String string2, String string3, String string4, String string5, String string6) {
        Object object;
        LoginContext loginContext = null;
        String string7 = "";
        if (string == null || "".equals(string)) {
            this.setErrorMessage("Domain is empty or null");
            return 2;
        }
        if (string2 == null || "".equals(string2)) {
            this.setErrorMessage("Connect user name is empty or null");
            return 2;
        }
        try {
            System.setProperty("java.security.auth.login.config", this.s_iniFile_dir);
            System.setProperty("java.security.krb5.conf", this.krbFile);
            loginContext = new LoginContext("KerberosAuth", new KerberosCallbackHandler(string2, string3));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.setErrorMessage("Exception occured - " + exception.getMessage());
            StringWriter stringWriter = new StringWriter();
            exception.printStackTrace(new PrintWriter(stringWriter));
            System.out.println("##Start");
            System.out.println("##krbErrors=" + stringWriter.toString() + "##End");
            if (this.logEnabled) {
                this.adUserTrackerLog.error("[KerberosAuthentication][CheckUserAvailable] Exception " + stringWriter.toString());
            }
            EgDbServlet.logToErrorFile((String)"ERROR", (String)"Auto Discovery of domain failed", (String)stringWriter.toString());
            String string8 = exception.getMessage();
            System.out.println("msg====" + string8);
            if (string8.indexOf("Clock skew too great") > -1) {
                this.errorList.add("KERBEROS");
                this.errorList.add("Clock skew too great");
                this.errorList.add(exception);
                return -9;
            }
            if (string8.indexOf("Identifier doesn't match expected value") > -1) {
                this.errorList.add("KERBEROS");
                this.errorList.add("Identifier");
                this.errorList.add(exception);
                return -11;
            }
            if (string8.indexOf("Client not found in Kerberos database") > -1) {
                this.errorList.add("KERBEROS");
                this.errorList.add("Client not found in Kerberos database");
                this.errorList.add(exception);
                return -2;
            }
            if (string8.indexOf("Pre-authentication information was invalid") > -1) {
                this.errorList.add("KERBEROS");
                this.errorList.add("Pre-authentication");
                this.errorList.add(exception);
                return -1;
            }
            if (string8.indexOf("Receive timed out") > -1) {
                this.errorList.add("KERBEROS");
                this.errorList.add("Receive timed out");
                this.errorList.add(exception);
                return -1;
            }
            if (string8.indexOf("Clients credentials have been revoked") > -1) {
                this.errorList.add("KERBEROS");
                this.errorList.add("Clients credentials have been revoked");
                this.errorList.add(exception);
                return -1;
            }
            if (string8.indexOf("Server not found in Kerberos database") > -1) {
                this.errorList.add("KERBEROS");
                this.errorList.add("Server not found in Kerberos database");
                this.errorList.add(exception);
                return -1;
            }
            if (string8.indexOf("KDC has no support for encryption type") > -1) {
                this.errorList.add("KERBEROS");
                this.errorList.add("KDC has no support for encryption type");
                this.errorList.add(exception);
                return -1;
            }
            if (string8.indexOf("Password has expired - change password to reset") > -1) {
                this.errorList.add("KERBEROS");
                this.errorList.add("Password has expired - change password to reset");
                this.errorList.add(exception);
                return -1;
            }
            if (string8.indexOf("Cannot get kdc for realm") > -1) {
                this.errorList.add("KERBEROS");
                String string9 = string8;
                string9 = string9.substring(string9.indexOf(":") + 1);
                string9 = string9.trim();
                this.errorList.add(string9);
                this.errorList.add(exception);
                return -1;
            }
            this.errorList.add("KERBEROS");
            this.errorList.add("Error in Connecting with AD sever");
            this.errorList.add(exception);
            return -1;
        }
        try {
            loginContext.login();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            loginContext = null;
            this.setErrorMessage("Exception occured - " + exception.getMessage());
            StringWriter stringWriter = new StringWriter();
            exception.printStackTrace(new PrintWriter(stringWriter));
            System.out.println("##Start");
            System.out.println("##krbErrors=" + stringWriter.toString() + "##End");
            if (this.logEnabled) {
                this.adUserTrackerLog.error("[KerberosAuthentication][CheckUserAvailable] Exception " + stringWriter.toString());
            }
            EgDbServlet.logToErrorFile((String)"ERROR", (String)"Auto Discovery of domain failed", (String)stringWriter.toString());
            String string10 = exception.getMessage();
            if (string10.indexOf("Clock skew too great") > -1) {
                this.errorList.add("KERBEROS");
                this.errorList.add("Clock skew too great");
                this.errorList.add(exception);
                return -9;
            }
            if (string10.indexOf("Identifier doesn't match expected value") > -1) {
                this.errorList.add("KERBEROS");
                this.errorList.add("Invalid Credentials");
                this.errorList.add(exception);
                return -11;
            }
            if (string10.indexOf("Client not found in Kerberos database") > -1) {
                this.errorList.add("KERBEROS");
                this.errorList.add("Client not found in Kerberos database");
                this.errorList.add(exception);
                return -2;
            }
            if (string10.indexOf("Pre-authentication information was invalid") > -1) {
                this.errorList.add("KERBEROS");
                this.errorList.add("Pre-authentication");
                this.errorList.add(exception);
                return -1;
            }
            if (string10.indexOf("Receive timed out") > -1) {
                this.errorList.add("KERBEROS");
                this.errorList.add("Receive timed out");
                this.errorList.add(exception);
                return -1;
            }
            if (string10.indexOf("Clients credentials have been revoked") > -1) {
                this.errorList.add("KERBEROS");
                this.errorList.add("Clients credentials have been revoked");
                this.errorList.add(exception);
                return -1;
            }
            if (string10.indexOf("Server not found in Kerberos database") > -1) {
                this.errorList.add("KERBEROS");
                this.errorList.add("Server not found in Kerberos database");
                this.errorList.add(exception);
                return -1;
            }
            if (string10.indexOf("KDC has no support for encryption type") > -1) {
                this.errorList.add("KERBEROS");
                this.errorList.add("KDC has no support for encryption type");
                this.errorList.add(exception);
                return -1;
            }
            if (string10.indexOf("Password has expired - change password to reset") > -1) {
                this.errorList.add("KERBEROS");
                this.errorList.add("Password has expired - change password to reset");
                this.errorList.add(exception);
                return -1;
            }
            if (string10.indexOf("Cannot get kdc for realm") > -1) {
                this.errorList.add("KERBEROS");
                String string11 = string10;
                string11 = string11.substring(string11.indexOf(":") + 1);
                string11 = string11.trim();
                this.errorList.add(string11);
                this.errorList.add(exception);
                return -1;
            }
            this.errorList.add("KERBEROS");
            this.errorList.add("Error in Connecting with AD sever");
            this.errorList.add(exception);
            return -1;
        }
        Subject subject = loginContext.getSubject();
        Object[] objectArray = subject.getPrincipals().toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            if (!(objectArray[i] instanceof KerberosPrincipal)) continue;
            object = (KerberosPrincipal)objectArray[i];
            string7 = ((KerberosPrincipal)object).getName();
            break;
        }
        if (this.logEnabled) {
            this.adUserTrackerLog.log("[KerberosAuthentication][CheckUserAvailable] The logged in user is " + string7);
        }
        Lookup lookup = new Lookup();
        object = lookup.getSubject(this.domain);
        String string12 = lookup.getAliasNameForDomain(this.domain);
        String string13 = string;
        if (string12 != null && string12.length() > 0) {
            string13 = string12;
        }
        UserSearch userSearch = new UserSearch(string13, string4, string5, string6);
        Boolean bl = (Boolean)Subject.doAs(loginContext.getSubject(), userSearch);
        try {
            if (loginContext != null) {
                loginContext.logout();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (bl.booleanValue()) {
            return 0;
        }
        this.errorList.add("KERBEROS");
        ArrayList arrayList = new ArrayList();
        arrayList = userSearch.errorList;
        if (this.logEnabled) {
            this.adUserTrackerLog.error("[KerberosAuthentication][CheckUserAvailable][UserSearch] Exception " + arrayList);
        }
        System.out.println("##domainErrors=" + arrayList);
        int n = arrayList.indexOf("EXCEPTION");
        if (n > -1) {
            Exception exception = (Exception)arrayList.get(n + 1);
            this.errorList.add("PRE_EXCEPTION");
            this.errorList.add(exception);
        } else {
            this.errorList.add("USER_EXCEPTION");
        }
        return -2;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 4) {
            String string = "java kerberosAuthentication <EG_INSTALL_DIR>/egurkha/manager/config/domainname.ini <domainName> <userName> <passWord>";
            System.out.println(string);
            System.out.println("OR");
            string = "java kerberosAuthentication <EG_INSTALL_DIR>/egurkha/manager/config/domainname.ini <domainName> <domainip> <connectuser> <connectpassword> <usertosearch> <userBase>";
            System.out.println(string);
            return;
        }
        if (stringArray.length > 5 && stringArray.length < 7) {
            String string = "java kerberosAuthentication <EG_INSTALL_DIR>/egurkha/manager/config/domainname.ini <domainName> <domainip> <connectuser> <connectpassword> <usertosearch> <userBase>";
            System.out.println(string);
            return;
        }
        String string = null;
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        String string6 = "";
        String string7 = "";
        String string8 = "";
        if (stringArray.length <= 5) {
            string2 = stringArray[0];
            string3 = stringArray[1];
            string5 = stringArray[2];
            string6 = stringArray[3];
        } else if (stringArray.length <= 8) {
            string2 = stringArray[0];
            string3 = stringArray[1];
            string4 = stringArray[2];
            string5 = stringArray[3];
            string6 = stringArray[4];
            string7 = stringArray[5];
            string8 = stringArray[6];
        }
        if (stringArray.length == 4) {
            string = "login";
        }
        if (stringArray.length == 7) {
            string = "validate";
        }
        string6 = EgCrypt.decrypt(string6);
        System.out.println("The target Domain IP Address = " + string4);
        System.out.println("The connect username is = " + string5);
        System.out.println("The connect password is = xxxxxxxxxx");
        System.out.println("The search username is = " + string7);
        System.out.println("The userBase is = " + string8);
        KerberosAuthentication kerberosAuthentication = new KerberosAuthentication(string2, string3);
        System.out.println("fromUserVerification" + string);
        if (string == null || string.equalsIgnoreCase("login")) {
            System.out.println("##Login=" + kerberosAuthentication.login(string3, string5, string6));
        }
        if (stringArray.length >= 7 && (string == null || string.equalsIgnoreCase("validate"))) {
            System.out.println("##Validate=" + kerberosAuthentication.CheckUserAvailable(string3, string5, string6, string7, string8));
        }
    }
}

