/*
 * Decompiled with CFR 0.152.
 */
package com.eg;

import com.eg.EgInstallInfo;
import java.io.File;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class EgJarFileLoader {
    private static final Class[] parameters = new Class[]{URL.class};
    private ArrayList existingList = new ArrayList();
    private URLClassLoader sysLoader = null;
    private Class sysclass = null;
    private boolean java6 = this.isJava69();
    private static boolean java9 = false;

    public EgJarFileLoader(String string) {
        if (java9) {
            return;
        }
        String string2 = "";
        string2 = string != null && string.equals("agent") ? EgInstallInfo.getInstallDir() + "/agent/lib" : EgInstallInfo.getInstallDir() + "/manager/lib";
        try {
            this.sysLoader = (URLClassLoader)ClassLoader.getSystemClassLoader();
            this.sysclass = URLClassLoader.class;
            this.existingList = this.getCurrentFilesInClassPath();
            this.loadLibraryFile(string2);
        }
        catch (Exception exception) {
            System.err.println("Unable to load the library files in the classpath ...");
        }
    }

    private void loadLibraryFile(String string) {
        try {
            File file = new File(string);
            File[] fileArray = file.listFiles();
            if (fileArray != null && fileArray.length > 0) {
                for (int i = 0; i < fileArray.length; ++i) {
                    String string2;
                    String string3;
                    if (fileArray[i].isFile()) {
                        string3 = fileArray[i].getName();
                        string2 = fileArray[i].getAbsolutePath();
                        String string4 = string3.toLowerCase();
                        if (!string4.endsWith(".jar") && !string4.endsWith(".zip")) continue;
                        this.addFileToClasspath(string2);
                        continue;
                    }
                    if (!fileArray[i].isDirectory()) continue;
                    if (this.java6) {
                        string3 = fileArray[i].getAbsolutePath();
                        this.loadLibraryFile(string3);
                        continue;
                    }
                    string3 = fileArray[i].getName();
                    if (string3 != null && string3.equals("jboss")) continue;
                    string2 = fileArray[i].getAbsolutePath();
                    this.loadLibraryFile(string2);
                }
            } else {
                System.out.println("There no files in the directory " + string);
            }
        }
        catch (Exception exception) {
            System.err.println("Exception in [EgJarFileLoader][getJarsAndZips] : " + exception.getMessage());
        }
    }

    public void addFileToClasspath(String string) {
        if (this.existingList.contains(string)) {
            System.out.println(" " + string + " is already available in the system classpath");
        } else {
            boolean bl = false;
            File file = null;
            URL uRL = null;
            try {
                file = new File(string);
                uRL = file.toURL();
                Method method = this.sysclass.getDeclaredMethod("addURL", parameters);
                if (method != null) {
                    method.setAccessible(true);
                    method.invoke((Object)this.sysLoader, uRL);
                    bl = true;
                }
                if (bl) {
                    System.out.println(" File ==>" + string + " is successfully included in the classpath");
                    if (!this.existingList.contains(string)) {
                        this.existingList.add(string);
                    }
                }
            }
            catch (Exception exception) {
                System.err.println("Error, could not add URL " + uRL + " to system classloader ");
            }
        }
    }

    private ArrayList getCurrentFilesInClassPath() {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            URL[] uRLArray = this.sysLoader.getURLs();
            for (int i = 0; i < uRLArray.length; ++i) {
                String string = uRLArray[i].toString();
                if (!string.startsWith("file:")) continue;
                string = string.substring(6);
                arrayList.add(string);
            }
        }
        catch (Exception exception) {
            System.err.println("Cann't get Current System Classpath list");
        }
        return arrayList;
    }

    public void printClasspathDetails() {
        ArrayList arrayList = this.getCurrentFilesInClassPath();
        for (int i = 0; i < arrayList.size(); ++i) {
            System.out.println(i + " : " + arrayList.get(i));
        }
    }

    private boolean isJava69() {
        String string = System.getProperty("java.version");
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        int n = stringTokenizer.countTokens();
        boolean bl = false;
        if (n >= 2) {
            String string2 = stringTokenizer.nextToken();
            String string3 = "";
            string3 = string2.equals("1") ? stringTokenizer.nextToken() : string2;
            try {
                int n2 = Integer.parseInt(string3);
                if (n2 >= 6) {
                    bl = true;
                }
                if (n2 >= 9) {
                    java9 = true;
                }
            }
            catch (NumberFormatException numberFormatException) {
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return bl;
    }
}

