/*
 * Decompiled with CFR 0.152.
 */
package com.xensource.xenapi;

import com.xensource.xenapi.Connection;
import com.xensource.xenapi.Marshalling;
import com.xensource.xenapi.Task;
import com.xensource.xenapi.Types;
import com.xensource.xenapi.XenAPIObject;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.xmlrpc.XmlRpcException;

public class SDNController
extends XenAPIObject {
    protected final String ref;

    SDNController(String string) {
        this.ref = string;
    }

    @Override
    public String toWireString() {
        return this.ref;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof SDNController) {
            SDNController sDNController = (SDNController)object;
            return sDNController.ref.equals(this.ref);
        }
        return false;
    }

    public int hashCode() {
        return this.ref.hashCode();
    }

    public Record getRecord(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "SDN_controller.get_record";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toSDNControllerRecord(v);
    }

    public static SDNController getByUuid(Connection connection, String string) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string2 = "SDN_controller.get_by_uuid";
        String string3 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string3), Marshalling.toXMLRPC(string)};
        Map map = connection.dispatch(string2, objectArray);
        Object v = map.get("Value");
        return Types.toSDNController(v);
    }

    public String getUuid(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "SDN_controller.get_uuid";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toString(v);
    }

    public Types.SdnControllerProtocol getProtocol(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "SDN_controller.get_protocol";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toSdnControllerProtocol(v);
    }

    public String getAddress(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "SDN_controller.get_address";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toString(v);
    }

    public Long getPort(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "SDN_controller.get_port";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toLong(v);
    }

    public static Task introduceAsync(Connection connection, Types.SdnControllerProtocol sdnControllerProtocol, String string, Long l) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string2 = "Async.SDN_controller.introduce";
        String string3 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string3), Marshalling.toXMLRPC((Object)sdnControllerProtocol), Marshalling.toXMLRPC(string), Marshalling.toXMLRPC(l)};
        Map map = connection.dispatch(string2, objectArray);
        Object v = map.get("Value");
        return Types.toTask(v);
    }

    public static SDNController introduce(Connection connection, Types.SdnControllerProtocol sdnControllerProtocol, String string, Long l) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string2 = "SDN_controller.introduce";
        String string3 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string3), Marshalling.toXMLRPC((Object)sdnControllerProtocol), Marshalling.toXMLRPC(string), Marshalling.toXMLRPC(l)};
        Map map = connection.dispatch(string2, objectArray);
        Object v = map.get("Value");
        return Types.toSDNController(v);
    }

    public Task forgetAsync(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "Async.SDN_controller.forget";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toTask(v);
    }

    public void forget(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "SDN_controller.forget";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
    }

    public static Set<SDNController> getAll(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "SDN_controller.get_all";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toSetOfSDNController(v);
    }

    public static Map<SDNController, Record> getAllRecords(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "SDN_controller.get_all_records";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toMapOfSDNControllerSDNControllerRecord(v);
    }

    public static class Record
    implements Types.Record {
        public String uuid;
        public Types.SdnControllerProtocol protocol;
        public String address;
        public Long port;

        public String toString() {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            printWriter.printf("%1$20s: %2$s\n", "uuid", this.uuid);
            printWriter.printf("%1$20s: %2$s\n", new Object[]{"protocol", this.protocol});
            printWriter.printf("%1$20s: %2$s\n", "address", this.address);
            printWriter.printf("%1$20s: %2$s\n", "port", this.port);
            return stringWriter.toString();
        }

        @Override
        public Map<String, Object> toMap() {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("uuid", this.uuid == null ? "" : this.uuid);
            hashMap.put("protocol", (Object)(this.protocol == null ? Types.SdnControllerProtocol.UNRECOGNIZED : this.protocol));
            hashMap.put("address", this.address == null ? "" : this.address);
            hashMap.put("port", this.port == null ? 0L : this.port);
            return hashMap;
        }
    }
}

