/*     */ package com.egurkha.jsp.indexer;
/*     */ 
/*     */ import com.egurkha.jsp.indexer.parser.PagerTagExport;
/*     */ import com.egurkha.jsp.indexer.parser.ParseException;
/*     */ import com.egurkha.jsp.indexer.parser.TagExportParser;
/*     */ import java.net.URLEncoder;
/*     */ import jakarta.servlet.ServletRequest;
/*     */ import jakarta.servlet.http.HttpServletRequest;
/*     */ import jakarta.servlet.jsp.JspException;
/*     */ import jakarta.servlet.jsp.JspTagException;
/*     */ import jakarta.servlet.jsp.PageContext;
/*     */ import jakarta.servlet.jsp.tagext.TagSupport;
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ public final class PagerTag
/*     */   extends TagSupport
/*     */ {
/*     */   public static final String DEFAULT_ID = "indexer";
/*     */   private static final int DEFAULT_MAX_ITEMS = 2147483647;
/*     */   private static final int DEFAULT_MAX_PAGE_ITEMS = 10;
/*     */   private static final int DEFAULT_MAX_INDEX_PAGES = 10;
/*     */   public static final String OFFSET_PARAM = "offset";
/*     */   public static final String PAGE = "page";
/*     */   public static final String REQUEST = "request";
/*     */   public static final String CENTER = "center";
/*     */   public static final String FORWARD = "forward";
/*     */   public static final String HALF_FULL = "half-full";
/*  52 */   private String url = null;
/*  53 */   private String index = null;
/*  54 */   private int items = 0;
/*  55 */   private int maxItems = Integer.MAX_VALUE;
/*  56 */   private int maxPageItems = 10;
/*  57 */   private int maxIndexPages = 10;
/*     */   private boolean isOffset = false;
/*  59 */   private String export = null;
/*  60 */   private String scope = null;
/*     */ 
/*     */ 
/*     */ 
/*     */   
/*  65 */   private StringBuffer uri = null;
/*  66 */   private int params = 0;
/*  67 */   private int offset = 0;
/*  68 */   private int itemCount = 0;
/*  69 */   private int pageNumber = 0;
/*  70 */   private Integer pageNumberInteger = null;
/*     */   
/*  72 */   private String idOffsetParam = "indexeroffset";
/*  73 */   private PagerTagExport pagerTagExport = null;
/*  74 */   private Object oldPager = null;
/*  75 */   private Object oldOffset = null;
/*  76 */   private Object oldPageNumber = null;
/*     */ 
/*     */   
/*     */   public PagerTag() {
/*  80 */     this.id = "indexer";
/*     */   }
/*     */ 
/*     */   
/*     */   public final void setId(String sid) {
/*  85 */     super.setId(sid);
/*  86 */     this.idOffsetParam = String.valueOf(sid) + "offset";
/*     */   }
/*     */ 
/*     */   
/*     */   public final void setUrl(String value) {
/*  91 */     this.url = value;
/*     */   }
/*     */ 
/*     */   
/*     */   public final String getUrl() {
/*  96 */     return this.url;
/*     */   }
/*     */ 
/*     */   
/*     */   public final void setIndex(String val) throws JspException {
/* 101 */     if (val != null && 
/* 102 */       !"center".equals(val) && 
/* 103 */       !"forward".equals(val) && 
/* 104 */       !"half-full".equals(val))
/*     */     {
/* 106 */       throw new JspTagException(
/* 107 */           "value for attribute \"index\" must be either \"center\", \"forward\" or \"half-full\".");
/*     */     }
/* 109 */     this.index = val;
/*     */   }
/*     */ 
/*     */   
/*     */   public final String getIndex() {
/* 114 */     return this.index;
/*     */   }
/*     */ 
/*     */   
/*     */   public final void setItems(int value) {
/* 119 */     this.items = value;
/*     */   }
/*     */ 
/*     */   
/*     */   public final int getItems() {
/* 124 */     return this.items;
/*     */   }
/*     */ 
/*     */   
/*     */   public final void setMaxItems(int value) {
/* 129 */     this.maxItems = value;
/*     */   }
/*     */ 
/*     */   
/*     */   public final int getMaxItems() {
/* 134 */     return this.maxItems;
/*     */   }
/*     */ 
/*     */   
/*     */   public final void setMaxPageItems(int value) {
/* 139 */     this.maxPageItems = value;
/*     */   }
/*     */ 
/*     */   
/*     */   public final int getMaxPageItems() {
/* 144 */     return this.maxPageItems;
/*     */   }
/*     */ 
/*     */   
/*     */   public final void setMaxIndexPages(int value) {
/* 149 */     this.maxIndexPages = value;
/*     */   }
/*     */ 
/*     */   
/*     */   public final int getMaxIndexPages() {
/* 154 */     return this.maxIndexPages;
/*     */   }
/*     */ 
/*     */   
/*     */   public final void setIsOffset(boolean val) {
/* 159 */     this.isOffset = val;
/*     */   }
/*     */ 
/*     */   
/*     */   public final boolean getIsOffset() {
/* 164 */     return this.isOffset;
/*     */   }
/*     */ 
/*     */   
/*     */   public final void setExport(String value) throws JspException {
/* 169 */     if (this.export != value) {
/*     */       
/*     */       try {
/*     */         
/* 173 */         this.pagerTagExport = TagExportParser.parsePagerTagExport(value);
/*     */       }
/* 175 */       catch (ParseException ex) {
/*     */         
/* 177 */         throw new JspTagException(ex.getMessage());
/*     */       } 
/*     */     }
/* 180 */     this.export = value;
/*     */   }
/*     */ 
/*     */   
/*     */   public final String getExport() {
/* 185 */     return this.export;
/*     */   }
/*     */ 
/*     */   
/*     */   public final void setScope(String val) throws JspException {
/* 190 */     if (val != null && !"page".equals(val) && !"request".equals(val))
/*     */     {
/* 192 */       throw new JspTagException(
/* 193 */           "value for attribute \"scope\" must be either \"page\" or \"request\".");
/*     */     }
/* 195 */     this.scope = val;
/*     */   }
/*     */ 
/*     */   
/*     */   public final String getScope() {
/* 200 */     return this.scope;
/*     */   }
/*     */ 
/*     */   
/*     */   final void addParam(String name, String value) {
/* 205 */     if (value != null) {
/*     */       
/* 207 */       name = URLEncoder.encode(name);
/* 208 */       value = URLEncoder.encode(value);
/*     */       
/* 210 */       this.uri.append((this.params == 0) ? 63 : 38).append(name).append(
/* 211 */           '=').append(
/* 212 */           value);
/*     */       
/* 214 */       this.params++;
/*     */     
/*     */     }
/*     */     else {
/*     */       
/* 219 */       String[] values = this.pageContext.getRequest().getParameterValues(name);
/*     */       
/* 221 */       if (values != null) {
/*     */         
/* 223 */         name = URLEncoder.encode(name);
/* 224 */         for (int i = 0, l = values.length; i < l; i++) {
/*     */           
/* 226 */           value = URLEncoder.encode(values[i]);
/* 227 */           this.uri.append((this.params == 0) ? 63 : 38).append(name).append(
/* 228 */               '=').append(
/* 229 */               value);
/*     */           
/* 231 */           this.params++;
/*     */         } 
/*     */       } 
/*     */     } 
/*     */   }
/*     */ 
/*     */   
/*     */   final boolean nextItem() {
/* 239 */     boolean showItem = false;
/* 240 */     if (this.itemCount < this.maxItems) {
/*     */       
/* 242 */       showItem = 
/* 243 */         (this.itemCount >= this.offset && this.itemCount < this.offset + this.maxPageItems);
/* 244 */       this.itemCount++;
/*     */     } 
/* 246 */     return showItem;
/*     */   }
/*     */ 
/*     */   
/*     */   final int getOffset() {
/* 251 */     return this.offset;
/*     */   }
/*     */ 
/*     */   
/*     */   final boolean isIndexNeeded() {
/* 256 */     return (this.offset != 0 || getItemCount() > this.maxPageItems);
/*     */   }
/*     */ 
/*     */   
/*     */   final boolean hasPrevPage() {
/* 261 */     return (this.offset > 0);
/*     */   }
/*     */ 
/*     */   
/*     */   final boolean hasNextPage() {
/* 266 */     return (getItemCount() > getNextOffset());
/*     */   }
/*     */ 
/*     */   
/*     */   final boolean hasPage(int page) {
/* 271 */     return (page >= 0 && getItemCount() > page * this.maxPageItems);
/*     */   }
/*     */ 
/*     */   
/*     */   final int getPrevOffset() {
/* 276 */     return Math.max(0, this.offset - this.maxPageItems);
/*     */   }
/*     */ 
/*     */   
/*     */   final int getNextOffset() {
/* 281 */     return this.offset + this.maxPageItems;
/*     */   }
/*     */ 
/*     */   
/*     */   final String getOffsetUrl(int pageOffset) {
/* 286 */     int uriLen = this.uri.length();
/* 287 */     this.uri.append((this.params == 0) ? 63 : 38).append(this.idOffsetParam).append(
/* 288 */         '=').append(pageOffset);
/* 289 */     String offsetUrl = this.uri.toString();
/* 290 */     this.uri.setLength(uriLen);
/* 291 */     return offsetUrl;
/*     */   }
/*     */ 
/*     */   
/*     */   final String getPageUrl(int i) {
/* 296 */     return getOffsetUrl(this.maxPageItems * i);
/*     */   }
/*     */ 
/*     */   
/*     */   final Integer getOffsetPageNumber(int pageOffset) {
/* 301 */     return new Integer(1 + pageNumber(pageOffset));
/*     */   }
/*     */ 
/*     */   
/*     */   final Integer getPageNumber(int i) {
/* 306 */     if (i == this.pageNumber)
/* 307 */       return this.pageNumberInteger; 
/* 308 */     return new Integer(1 + i);
/*     */   }
/*     */ 
/*     */   
/*     */   final int getPageNumber() {
/* 313 */     return this.pageNumber;
/*     */   }
/*     */ 
/*     */   
/*     */   final int getPageCount() {
/* 318 */     return pageNumber(getItemCount());
/*     */   }
/*     */ 
/*     */   
/*     */   final int getFirstIndexPage() {
/* 323 */     int firstPage = 0;
/* 324 */     int halfIndexPages = this.maxIndexPages / 2;
/*     */     
/* 326 */     if ("forward".equals(this.index)) {
/*     */       
/* 328 */       firstPage = Math.min(this.pageNumber + 1, getPageCount());
/*     */     }
/* 330 */     else if (!"half-full".equals(this.index) || this.pageNumber >= halfIndexPages) {
/*     */       
/* 332 */       int pages = getPageCount();
/* 333 */       if (pages > this.maxIndexPages) {
/*     */ 
/*     */         
/* 336 */         firstPage = Math.max(0, this.pageNumber - halfIndexPages);
/*     */         
/* 338 */         int indexPages = pages - firstPage;
/* 339 */         if (indexPages < this.maxIndexPages) {
/* 340 */           firstPage -= this.maxIndexPages - indexPages;
/*     */         }
/*     */       } 
/*     */     } 
/* 344 */     return firstPage;
/*     */   }
/*     */ 
/*     */   
/*     */   final int getLastIndexPage(int firstPage) {
/* 349 */     int maxPages, pages = getPageCount();
/* 350 */     int halfIndexPages = this.maxIndexPages / 2;
/*     */     
/* 352 */     if ("half-full".equals(this.index) && this.pageNumber < halfIndexPages) {
/*     */       
/* 354 */       maxPages = this.pageNumber + halfIndexPages;
/*     */     }
/*     */     else {
/*     */       
/* 358 */       maxPages = firstPage + this.maxIndexPages;
/*     */     } 
/* 360 */     return ((pages <= maxPages) ? pages : maxPages) - 1;
/*     */   }
/*     */ 
/*     */   
/*     */   final int getItemCount() {
/* 365 */     return (this.items != 0) ? this.items : this.itemCount;
/*     */   }
/*     */ 
/*     */   
/*     */   private final int pageNumber(int offset) {
/* 370 */     return offset / this.maxPageItems + ((offset % this.maxPageItems == 0) ? 0 : 1);
/*     */   }
/*     */ 
/*     */   
/*     */   public int doStartTag() throws JspException {
/*     */     String baseUri;
/* 376 */     if (this.url != null) {
/*     */       
/* 378 */       baseUri = this.url;
/*     */     }
/*     */     else {
/*     */       
/* 382 */       baseUri = ((HttpServletRequest)this.pageContext.getRequest()).getRequestURI();
/* 383 */       int i = baseUri.indexOf('?');
/* 384 */       if (i != -1)
/* 385 */         baseUri = baseUri.substring(0, i); 
/*     */     } 
/* 387 */     if (this.uri == null) {
/* 388 */       this.uri = new StringBuffer(baseUri.length() + 32);
/*     */     } else {
/* 390 */       this.uri.setLength(0);
/* 391 */     }  this.uri.append(baseUri);
/*     */     
/* 393 */     this.params = 0;
/* 394 */     this.offset = 0;
/* 395 */     this.itemCount = 0;
/*     */     
/* 397 */     String offsetParam = this.pageContext.getRequest().getParameter(this.idOffsetParam);
/* 398 */     if (offsetParam != null) {
/*     */       
/*     */       try {
/*     */         
/* 402 */         this.offset = Math.max(0, Integer.parseInt(offsetParam));
/* 403 */         if (this.isOffset) {
/* 404 */           this.itemCount = this.offset;
/*     */         }
/* 406 */       } catch (NumberFormatException numberFormatException) {}
/*     */     }
/*     */ 
/*     */ 
/*     */     
/* 411 */     this.pageNumber = pageNumber(this.offset);
/* 412 */     this.pageNumberInteger = new Integer(1 + this.pageNumber);
/*     */     
/* 414 */     if ("request".equals(this.scope)) {
/*     */       
/* 416 */       ServletRequest request = this.pageContext.getRequest();
/*     */       
/* 418 */       this.oldPager = request.getAttribute(this.id);
/* 419 */       request.setAttribute(this.id, this);
/*     */       
/* 421 */       if (this.pagerTagExport != null) {
/*     */         String name;
/*     */         
/* 424 */         if ((name = this.pagerTagExport.getPageOffset()) != null) {
/*     */           
/* 426 */           this.oldOffset = request.getAttribute(name);
/* 427 */           request.setAttribute(name, new Integer(this.offset));
/*     */         } 
/* 429 */         if ((name = this.pagerTagExport.getPageNumber()) != null)
/*     */         {
/* 431 */           this.oldPageNumber = request.getAttribute(name);
/* 432 */           request.setAttribute(name, this.pageNumberInteger);
/*     */         }
/*     */       
/*     */       }
/*     */     
/*     */     }
/* 438 */     else if (this.pagerTagExport != null) {
/*     */       String name;
/*     */       
/* 441 */       if ((name = this.pagerTagExport.getPageOffset()) != null) {
/*     */         
/* 443 */         this.oldOffset = this.pageContext.getAttribute(name);
/* 444 */         this.pageContext.setAttribute(name, new Integer(this.offset));
/*     */       } 
/* 446 */       if ((name = this.pagerTagExport.getPageNumber()) != null) {
/*     */         
/* 448 */         this.oldPageNumber = this.pageContext.getAttribute(name);
/* 449 */         this.pageContext.setAttribute(name, this.pageNumberInteger);
/*     */       } 
/*     */     } 
/*     */ 
/*     */     
/* 454 */     return 1;
/*     */   }
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */   
/*     */   private static void restoreAttribute(ServletRequest request, String name, Object oldValue) {
/* 462 */     if (oldValue != null) {
/* 463 */       request.setAttribute(name, oldValue);
/*     */     } else {
/* 465 */       request.removeAttribute(name);
/*     */     } 
/*     */   }
/*     */ 
/*     */ 
/*     */ 
/*     */   
/*     */   private static void restoreAttribute(PageContext pageContext, String name, Object oldValue) {
/* 473 */     if (oldValue != null) {
/* 474 */       pageContext.setAttribute(name, oldValue);
/*     */     } else {
/* 476 */       pageContext.removeAttribute(name);
/*     */     } 
/*     */   }
/*     */   
/*     */   public int doEndTag() throws JspException {
/* 481 */     if ("request".equals(this.scope)) {
/*     */       
/* 483 */       ServletRequest request = this.pageContext.getRequest();
/*     */       
/* 485 */       restoreAttribute(request, this.id, this.oldPager);
/* 486 */       this.oldPager = null;
/*     */       
/* 488 */       if (this.pagerTagExport != null) {
/*     */         String name;
/*     */         
/* 491 */         if ((name = this.pagerTagExport.getPageOffset()) != null) {
/*     */           
/* 493 */           restoreAttribute(request, name, this.oldOffset);
/* 494 */           this.oldOffset = null;
/*     */         } 
/*     */         
/* 497 */         if ((name = this.pagerTagExport.getPageNumber()) != null)
/*     */         {
/* 499 */           restoreAttribute(request, name, this.oldPageNumber);
/* 500 */           this.oldPageNumber = null;
/*     */         }
/*     */       
/*     */       }
/*     */     
/*     */     }
/* 506 */     else if (this.pagerTagExport != null) {
/*     */       String name;
/*     */       
/* 509 */       if ((name = this.pagerTagExport.getPageOffset()) != null) {
/*     */         
/* 511 */         restoreAttribute(this.pageContext, name, this.oldOffset);
/* 512 */         this.oldOffset = null;
/*     */       } 
/*     */       
/* 515 */       if ((name = this.pagerTagExport.getPageNumber()) != null) {
/*     */         
/* 517 */         restoreAttribute(this.pageContext, name, this.oldPageNumber);
/* 518 */         this.oldPageNumber = null;
/*     */       } 
/*     */     } 
/*     */ 
/*     */ 
/*     */     
/* 524 */     if (this.uri.capacity() > 1024) {
/* 525 */       this.uri = null;
/*     */     }
/* 527 */     this.pageNumberInteger = null;
/*     */     
/* 529 */     return 6;
/*     */   }
/*     */ 
/*     */   
/*     */   public void release() {
/* 534 */     this.url = null;
/* 535 */     this.index = null;
/* 536 */     this.items = 0;
/* 537 */     this.maxItems = Integer.MAX_VALUE;
/* 538 */     this.maxPageItems = 10;
/* 539 */     this.maxIndexPages = 10;
/* 540 */     this.isOffset = false;
/* 541 */     this.export = null;
/* 542 */     this.scope = null;
/*     */     
/* 544 */     this.uri = null;
/* 545 */     this.params = 0;
/* 546 */     this.offset = 0;
/* 547 */     this.itemCount = 0;
/* 548 */     this.pageNumber = 0;
/* 549 */     this.pageNumberInteger = null;
/*     */     
/* 551 */     this.idOffsetParam = "indexeroffset";
/* 552 */     this.pagerTagExport = null;
/* 553 */     this.oldPager = null;
/* 554 */     this.oldOffset = null;
/* 555 */     this.oldPageNumber = null;
/*     */     
/* 557 */     super.release();
/*     */   }
/*     */ }


/* Location:              C:\Users\dhanabal\Desktop\Index\!\com\egurkha\jsp\indexer\PagerTag.class
 * Java compiler version: 1 (45.3)
 * JD-Core Version:       1.1.3
 */