/*    */ package com.egurkha.jsp.indexer;
/*    */ 
/*    */ import jakarta.servlet.jsp.JspException;
/*    */ import jakarta.servlet.jsp.JspTagException;
/*    */ 
/*    */ 
/*    */ 
/*    */ 
/*    */ 
/*    */ 
/*    */ 
/*    */ 
/*    */ 
/*    */ 
/*    */ 
/*    */ 
/*    */ 
/*    */ 
/*    */ 
/*    */ 
/*    */ 
/*    */ 
/*    */ 
/*    */ 
/*    */ 
/*    */ public abstract class JumpTagSupport
/*    */   extends PageTagSupport
/*    */ {
/*    */   public static final String CURRENT = "current";
/*    */   public static final String INDEXED = "indexed";
/* 31 */   private String unless = null;
/*    */ 
/*    */   
/*    */   public final void setUnless(String value) throws JspException {
/* 35 */     if (value != null && !"current".equals(value) && !"indexed".equals(value))
/*    */     {
/* 37 */       throw new JspTagException("value for attribute \"unless\" must be either \"current\" or \"indexed\".");
/*    */     }
/* 39 */     this.unless = value;
/*    */   }
/*    */ 
/*    */   
/*    */   public final String getUnless() {
/* 44 */     return this.unless;
/*    */   }
/*    */ 
/*    */   
/*    */   public int doStartTag() throws JspException {
/* 49 */     super.doStartTag();
/*    */     
/* 51 */     int jumpPage = getJumpPage();
/*    */     
/* 53 */     if ("current".equals(this.unless)) {
/*    */       
/* 55 */       if (jumpPage == this.pagerTag.getPageNumber()) {
/* 56 */         return 0;
/*    */       }
/* 58 */     } else if ("indexed".equals(this.unless)) {
/*    */       
/* 60 */       int firstPage = this.pagerTag.getFirstIndexPage();
/* 61 */       int lastPage = this.pagerTag.getLastIndexPage(firstPage);
/*    */       
/* 63 */       if (jumpPage >= firstPage && jumpPage <= lastPage) {
/* 64 */         return 0;
/*    */       }
/*    */     } 
/* 67 */     setPageAttributes(jumpPage);
/*    */     
/* 69 */     return 1;
/*    */   }
/*    */ 
/*    */   
/*    */   public void release() {
/* 74 */     this.unless = null;
/* 75 */     super.release();
/*    */   }
/*    */   
/*    */   protected abstract int getJumpPage();
/*    */ }


/* Location:              C:\Users\dhanabal\Desktop\Index\!\com\egurkha\jsp\indexer\JumpTagSupport.class
 * Java compiler version: 1 (45.3)
 * JD-Core Version:       1.1.3
 */