<!DOCTYPE html>

<%
	/************************************************************************************************
	 *	File			:	ErXenToolstReportPrint.jsp
	 *	Purpose			:	Displays the configured measures and its details for the XenTools installed in VMs
	 *	Version			:	Reporter v6.0
	 *	Author			:	B.Balamurugan 
	 *	Creation Date	:	05/02/15 
	 *
	 *************************************************************************************************/
%>
<%@ include file="ErTracker.jsp"%>
<%@ include file="ErRemoveUser.jsp"%>
<%@ page import="com.eg.EgConfigInfo"%>
<%@ page import="com.eg.EgDbInfo"%>
<%@ page import="com.eg.EgMappingInfo"%>
<%@ page import="com.eg.EgReportInfo"%>
<%@ page import="com.egurkha.util.DateUtil"%>
<%@ page import="java.util.Map"%>
<%@ page import="java.util.List"%>
<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld"%>
<%@ page language="java" contentType="text/html; charset=UTF-8"
	pageEncoding="UTF-8"%>

<%
	String pdfPrint = request.getParameter("pdfPrint");
	String fontStyleDblSingl = "";

	String strManagerURL = request.getScheme() + "://" + request.getServerName() + ":"
			+ request.getServerPort();
	EgDbInfo dbInfo = new EgDbInfo("manager");
	com.egurkha.ini.IniUI ui = (com.egurkha.ini.IniUI) com.egurkha.ini.IniUI.getInstance();
	EgReportInfo reportInfo = new EgReportInfo("manager");

	if ((dbInfo.doubleByteEnabled || !thisuser.getLanguage().equals("en_US"))
			&& !(pdfPrint != null && pdfPrint.equalsIgnoreCase("yes"))) {
		fontStyleDblSingl = "multi_font";
	} else {
		fontStyleDblSingl = "";
	}

	EgMappingInfo intlmp=new EgMappingInfo(thisuser.getLanguage());
	
	Map allData = null;
	if(request.getAttribute("allData")!=null)
		allData =  (Map)request.getAttribute("allData");
	else
		allData =  (Map)session.getAttribute("allData");
	
	String toolType = (String)allData.get("toolType");
	Map hmToolVersion =(Map)allData.get("hmToolVersion");
                
	Map hmToolVersionDetails   =  (Map)allData.get("hmToolVersionDetails");
                
	String updatedToolCnt      = (String)allData.get("updateToolCnt");
	String notUpdatedToolCnt   = (String)allData.get("notUptoDateToolCnt");
	String notToolInstalledCnt = (String)allData.get("notToolInstalledCnt");
	String toolInstallsVM      = (String)allData.get("toolInstallsVM");
	String totalNoOfVMs        = (String)allData.get("totalNoOfVMs");

	List uptoDateToolList      =   (List)allData.get("uptoDateToolList");
	List notUptoDateToolList   =   (List)allData.get("notUptoDateToolList");
	List notToolInstalledList  =   (List)allData.get("notToolInstalledList");
	String toolsUpToDateStr[]  =   null;
	String versionID           =   "";

	String erComptype          =   (String)allData.get("erComptype");
	String er_option           =   (String)allData.get("er_option");
	String er_site             =   (String)allData.get("er_site");

	String NotRunnings=(String)allData.get("NotRunnings");
	String Runnings=(String)allData.get("Runnings");
	String NotInstalleds=(String)allData.get("NotInstalleds");
	String OutofDates= (String)allData.get("OutofDates");
	String totalInstalled=(String)allData.get("totalInstalled");
	String totalNoOfVM=(String)allData.get("totalNoOfVM");
	String TargetHost  =   (String)allData.get("TargetHost");
		
	List NotRunning      =   (List)allData.get("NotRunning");
	List Running   =   (List)allData.get("Running");
	List Starting  =   (List)allData.get("Starting");
	List NotInstalled  =   (List)allData.get("NotInstalled");
	List OutofDate  =   (List)allData.get("OutofDate");


	
%>
<!Doctype html>
<head>
<%
	if (pdfPrint != null && pdfPrint.equalsIgnoreCase("yes")) {
%>
<title>&nbsp; <egui:intnl text="reporter.common.Reporter" />
	&nbsp; &nbsp; <egui:intnl text="reporter.common.Print" /> &nbsp;
</title>
<%
	} else {
%>
<title>&nbsp; <egui:intnl text="reporter.common.Reporter" />
	&nbsp; &nbsp;
</title>
<%
	}
%>

<meta name="Author" content="">
<meta charset="UTF-8">
<link rel="stylesheet" type="text/css" href="/final/styles/eGLightThemeIcons.css" />
<link rel="stylesheet" type="text/css" href="/final/reporter/styles/printpagestyle.css" />
<script language="JavaScript1.2" src="../reporter/scripts/er_imagesLite.js"></script>
<script src="/final/scripts/DD_roundies_0.0.2a-min.js"  type='text/javascript'></script>

<style type="text/css" media="print">
#printbt {
	display: none
}
</style>

</head>

<body style="padding: 10px; background-color: #ffffff">
<%
	String strLogCls = "printHeaderBoxLogo";
	if(pdfPrint !=null && pdfPrint.equalsIgnoreCase("yes"))
	{
		strLogCls = "printHeaderBoxLogo";
	}else
		strLogCls = "printPdfHeaderBoxLogo";

	if(pdfPrint !=null && pdfPrint.equalsIgnoreCase("yes"))
	{
%>
		<div class="<%=strLogCls%>" style="padding:10px"><img src="<%=imageName%>" border="0" /></div>
<%
	}
	else
	{
%>
		<div class="<%=strLogCls%>"><img src="<%=imageName%>" border="0" /></div>
<%
	}
%>
	<div class="printHeaderBox">
		<div class="printHeaderBoxTitle"><egui:intnl text="reporter.common.VM Tools Report" /></div><%
		if(pdfPrint !=null && pdfPrint.equalsIgnoreCase("yes"))
		{
	%>
			<div class="printHeaderBoxPrintIcon" style="float:left"><img class="iconPrinter mouse" src="data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw=="
			border="0" onClick="javascript:print()"
			alt='<egui:intnl text="reporter.common.PRINT"/>'
			title='<egui:intnl text="reporter.common.PRINT"/>' /></div>
	<%
		}
	%>
	</div>

	<div class="printOuterBoxNoBorder"> 
	<!-- 	<div class="printSelectionFields"><egui:intnl text="reporter.consolidated.Report for " /><%=er_option%></span></div>   -->
		<div class="printSelectionFields"><egui:intnl text="reporter.common.Report for" /> - <span class="bold"><%=intlmp.getTextDescription("reporter.common."+er_option)%></span></div>

	<!--	<div class="printSelectionFields"><egui:intnl text="reporter.common.Component Type " /><%=erComptype%></span></div> -->

		<div class="printSelectionFields"><egui:intnl text="reporter.common.Component Type" /> - <span class="bold"><%=erComptype%></span></div>

		 <%if(er_site!=null && !"".equals(er_site)){%>
	<!--	<div class="printSelectionFields"> <%=er_option%> &nbsp;<%=er_site%></span></div> -->
		<div class="printSelectionFields"><%=er_option%> - <span class="bold"><%=er_site%></span></div>

		<%}%>
	</div>

	<div class="printOuterBox" >
<%
	if(allData!=null && allData.size()>0)
	{
		if(erComptype!=null && (intlmp.getReverseComponentTypeDescription(erComptype).equalsIgnoreCase("Xen_virtual_server") || intlmp.getReverseComponentTypeDescription(erComptype).equalsIgnoreCase("Xen_desktop_server") || erComptype.equalsIgnoreCase("Xen_virtual_server") || erComptype.equalsIgnoreCase("Xen_desktop_server")))
		{
%>
<div class="printOuterBoxHeader"><%if("XenServer".equals(toolType)){%>
	   <egui:intnl text="reporter.common.XenServer Tools Details" />
	   <%}else{%>
	   <egui:intnl text="reporter.common.Tools Details" />
	   <%}%>
</div>

<table align="center" cellspacing="0" cellpadding="4" width="100%" border="0px">
	<tr>
		<td align="center" valign="middle" style="padding:10px">
			<div class="newTable">
				<table width="70%" cellpadding="4" cellspacing="0">
					<colgroup>
						<col width="80%">
						<col width="20%">
					</colgroup>
					<thead>
						<tr>
							<th align="left" ><%=intlmp.getTextDescription("reporter.common.Summary")%></th>
							<th align="center" ><%=intlmp.getTextDescription("reporter.common.Number of VMs")%></th>
						</tr>
					</thead>
					<tbody>
						<tr>
							<td><egui:intnl text="reporter.common.Total Number of VMs"/></td>
							<td align="center"><%=totalNoOfVMs%></td>
						</tr>
						<tr>
							<%if("XenServer".equals(toolType)){%>
							<td><egui:intnl text="reporter.common.VMs with XenServer tools installed"/></td>
							<%}else{%>
							<td><egui:intnl text="reporter.common.VMs with Tools installed"/></td>
							<%}%>
							<td align="center"><%=toolInstallsVM%></td>
						</tr>
						<tr>
							<%if("XenServer".equals(toolType)){%>
							<td><egui:intnl text="reporter.common.VMs with XenServer tools not installed"/></td>
							<%}else{%>
							<td><egui:intnl text="reporter.common.VMs with Tools not installed"/></td>
							<%}%>
							<td align="center"><%=notToolInstalledCnt%></td>
						</tr>
					</tbody>
				</table>
			</div>
			<div class="clearDiv" height="10px">&nbsp;</div>
			<div class="newTable">
				<table width="100%" cellpadding="0" cellspacing="0">
					<colgroup>
						<col width="80%">
						<col width="20%">
					</colgroup>
					<thead>
						<tr>
						<%if("XenServer".equals(toolType)){%>
							<th align="left" ><egui:intnl text="reporter.common.VMs XenServer Tools by Status"/></th>
							<%}else{%>
							<th align="left" ><egui:intnl text="reporter.common.VMs Tools by Status"/></th>
							<%}%>
							<th align="center" ><egui:intnl text="reporter.common.Number of VMs"/></th>
						</tr>
					</thead>
					<tbody>
						<tr>
						<%if("XenServer".equals(toolType)){%>
							<td><egui:intnl text="reporter.common.XenServer tools up to date"/></td>
							<%}else{%>
							<td><egui:intnl text="reporter.common.Tools up to date"/></td>
							<%}%>
							<td align="center"><%=uptoDateToolList.size()%></td>
						</tr>
						<%if(uptoDateToolList.size()>0){%>
						<tr>
							<td align="right" colspan="2" style="padding:10px 20px 10px 20px">
								<!-- <div id="userDiv_0" style="visibility:hidden;display:none;width:100%"> -->
								<div class="newTable">
									<table width="100%" cellpadding="0" cellspacing="0" class="newimg">
										<colgroup>
											<col width="70%">
											<col width="15%">
											<col width="15%">
										</colgroup>
										<thead>
											<tr>
												<th align="left" ><egui:intnl text="reporter.common.VM Name"/></th>
												<th align="left" nowrap><egui:intnl text="reporter.common.Hypervisor Name"/></th>
												<th align="left" ><egui:intnl text="reporter.common.Version"/></th>
											</tr>
										</thead>
										<tbody>
										<%for(int i=0;i<uptoDateToolList.size();i++){
											toolsUpToDateStr = uptoDateToolList.get(i).toString().split("@#");
											%>
											<tr>
												<td><%=toolsUpToDateStr[0]%></td>
												<td><%=toolsUpToDateStr[1]%></td>
												<td><%=toolsUpToDateStr[2]%></td>
											</tr>
										<%}%>
										</tbody>
									</table>
								</div>
							</td>
						</tr>
						<%}%>
						<tr>
							<td height="10" colspan="2">&nbsp;</td> 
						</tr>
						<tr>
							<%if("XenServer".equals(toolType)){%>
							<td><egui:intnl text="reporter.common.XenServer tools not up to date"/></td>
							<%}else{%>
							<td><egui:intnl text="reporter.common.Tools not up to date"/></td>
							<%}%>
							<td align="center"> <%=notUptoDateToolList.size()%></td>
						</tr>
						<%if(notUptoDateToolList.size()>0){%>
						<tr class="newimg">
							<td align="right" colspan="2" style="padding:10px 20px 10px 20px">
								<!-- <div id="userDiv_0" style="visibility:hidden;display:none;width:100%"> -->
								<div class = "newTable">
									<table width="100%" cellpadding="0" cellspacing="0" class="newimg">
										<colgroup>
											<col width="70%">
											<col width="15%">
											<col width="15%">
										</colgroup>
										<thead>
											<tr>
												<th align="left" ><egui:intnl text="reporter.common.VM Name"/></th>
												<th align="left" nowrap><egui:intnl text="reporter.common.Hypervisor Name"/></th>
												<th align="left" ><egui:intnl text="reporter.common.Version"/></th>
											</tr>
										</thead>
										<tbody>
									<%for(int i=0;i<notUptoDateToolList.size();i++){
										toolsUpToDateStr = notUptoDateToolList.get(i).toString().split("@#");
										%>
											<tr>
												<td><%=toolsUpToDateStr[0]%></td>
												<td><%=toolsUpToDateStr[1]%></td>
												<td><%=toolsUpToDateStr[2]%></td>
											</tr>
									<%}%>
										</tbody>
									</table>
								</div>
							</td>
						</tr>
						<%}%>
						<tr>
							<td height="10" colspan="2">&nbsp;</td></tr>
						<tr>
							<%if("XenServer".equals(toolType)){%>
							<td><%=intlmp.getTextDescription("reporter.common.XenServer tools not installed")%></td>  
							<%}else{%>
							<td>Tools not installed</td>
							<%}%>
							<td align="center"><%=notToolInstalledList.size()%></td>
						</tr>
						<%if(notToolInstalledList.size()>0){%>
						<tr class="newimg">
							<td align="right" colspan="2" style="padding:10px 20px 10px 20px">
								<!-- <div id="userDiv_0" style="visibility:hidden;display:none;width:100%"> -->
								<div class = "newTable">
									<table width="100%" cellpadding="0" cellspacing="0" >
										<colgroup>
											<col width="80%">
											<col width="20%">
										</colgroup>
										<thead>
											<tr>
												<th align="left" ><egui:intnl text="reporter.common.VM Name"/></th>
												<th align="left" nowrap><egui:intnl text="reporter.common.Hypervisor Name"/></th>
											</tr>
										</thead>
										<tbody>
										<%for(int i=0;i<notToolInstalledList.size();i++){
										toolsUpToDateStr = notToolInstalledList.get(i).toString().split("@#");
										%>
											<tr>
												<td><%=toolsUpToDateStr[0]%></td>
												<td><%=toolsUpToDateStr[1]%></td>
											</tr>
										<%}%>
										</tbody>
									</table>
								</div>
							</td>
						</tr>
						<%}%>
					</tbody>
				</table>
			</div>

			<div class="clearDiv" height="10px">&nbsp;</div>

			<div class ="newTable">
				<table width="100%" cellpadding="0" cellspacing="0" class="newimg">
					<colgroup>
						<col width="80%">
						<col width="20%">
					</colgroup>
					<thead>
						<tr>
						<%if("XenServer".equals(toolType)){%>
							<th align="left" ><egui:intnl text="reporter.common.VMs by XenServer tools by version"/></th>
							<%}else{%>
							<th align="left" ><egui:intnl text="reporter.common.VMs by Tools by version"/></th>
							<%}%>
							<th align="center" ><egui:intnl text="reporter.common.Number of VMs"/></th>
						</tr>
					
					</thead>
						<%
						 Set hmToolVersionSet      = hmToolVersion.keySet();
						 Iterator hmToolVersionItr = hmToolVersionSet.iterator();
						 
						 while(hmToolVersionItr.hasNext()){
							  versionID = (String) hmToolVersionItr.next();
						%>
						
					<tbody>
						<tr>
							<td ><%=versionID%></th>
							<td align="center"><%=hmToolVersion.get(versionID)%></th>
						</tr>
						<tr>
							<td align="right" colspan="2" style="padding:10px 20px 10px 20px">
								<!-- <div id="userDiv_0" style="visibility:hidden;display:none;width:100%"> -->
								<div class = "newTable">
									<table width="100%" cellpadding="0" cellspacing="0" class="newimg">
										<colgroup>
											<col width="70%">
											<col width="15%">
											<col width="15%">
										</colgroup>
										<thead>
											<tr>
												<th align="left" >  <egui:intnl text="reporter.common.VM Name"/>   </th>
												<th align="left" nowrap> <egui:intnl text="reporter.common.Hypervisor Name"/></th>
												<th align="left" nowrap><egui:intnl text="reporter.common.Is up to date?"/></th>
											</tr>
										</thead>
										<tbody>
										<%
										List verDel  = (List)hmToolVersionDetails.get(versionID);
										  for(int i=0;i<verDel.size();i++){
											  toolsUpToDateStr = verDel.get(i).toString().split("@#");
										%>
											<tr>
												<td><%=toolsUpToDateStr[0]%></td>
												<td><%=toolsUpToDateStr[1]%></td>
												<td><%=toolsUpToDateStr[3]%></td>
											</tr>
										<%}%>
										</tbody>
									</table>
								</div>
							</td>
						</tr>
						 <%}%>
					</tbody>
				</table>
			</div>
		</td>
	</tr>
</table>
<%
	}
	else if(erComptype!=null && (intlmp.getReverseComponentTypeDescription(erComptype).equalsIgnoreCase("VmEsx_i_server") || intlmp.getReverseComponentTypeDescription(erComptype).equalsIgnoreCase("VmVdi_i_server") || erComptype.equalsIgnoreCase("VmEsx_i_server") || erComptype.equalsIgnoreCase("VmVdi_i_server")))
	{
%>
<div class="printOuterBoxHeader">
	   <%if("VMware".equals(toolType)){%>
	   <egui:intnl text="reporter.common.VMware Tools Details" />
	   <%}else{%>
	   <egui:intnl text="reporter.common.Tools Details" />
	   <%}%>
</div>


<table align="center" cellspacing="0" cellpadding="4" width="100%" border="0px">
	<tr>
		<td align="center" valign="middle" style="padding:10px">
			<div class = "newTable">
				
				<table width="70%" cellpadding="4" cellspacing="0">
					<colgroup>
						<col width="80%">
						<col width="20%">
					</colgroup>
					<thead>
						<tr>
							<th align="center" ><%=intlmp.getTextDescription("reporter.common.Summary")%></th>
							<th align="center" ><%=intlmp.getTextDescription("reporter.common.Number of VMs")%></th>
						</tr>
					</thead>
					<tbody>
						<tr>
							<td><egui:intnl text="reporter.common.Total Number of VMs"/></td>
							<td><%=totalNoOfVM%></td>
						</tr>
						<tr>
						<%if("VMware".equals(toolType)){%>
							<td><egui:intnl text="reporter.common.VMs with VMware tools installed"/></td>
						<%}else{%>
							<td><egui:intnl text="reporter.common.VMs with Tools installed"/></td>
						<%}%>
							<td><%=totalInstalled%></td>
						</tr>
						<tr>
						<%if("VMware".equals(toolType)){%>
							<td><egui:intnl text="reporter.common.VMs with VMware tools not installed"/></td>
						<%}else{%>
							<td><egui:intnl text="reporter.common.VMs with Tools not installed"/></td>
						<%}%>
							<td><%=NotInstalleds%></td>
						</tr>
					</tbody>
				</table>
			</div>
			<div class="clearDiv" height="10px">&nbsp;</div>
			<div class = "newTable">
				<table width="100%" cellpadding="0" cellspacing="0">
					<colgroup>
						<col width="80%">
						<col width="20%">
					</colgroup>
					<thead>
						<tr>
							<%if("VMware".equals(toolType)){%>
							<th align="left" ><egui:intnl text="reporter.common.VMs VMware Tools by Status"/></th>
							<%}else{%>
							<th align="left" ><egui:intnl text="reporter.common.VMs Tools by Status"/></th>
							<%}%>
							<th align="left" ><egui:intnl text="reporter.common.Number of VMs"/></th>
						</tr>
					</thead>
					<tbody>
						<tr>
							<%if("VMware".equals(toolType)){%>
							<td><egui:intnl text="reporter.common.VMware tools Running"/></td>
							<%}else{%>
							<td><egui:intnl text="reporter.common.Tools Running"/></td>
							<%}%>
							<td><%=Running.size()%></td>
						</tr>
						<%if(Running.size()>0){%>
						<tr>
							<td align="right" colspan="2" style="padding:10px 20px 10px 20px">
								<div class = "newTable">
									<table width="100%" cellpadding="0" cellspacing="0" class="newimg">
										<colgroup>
											<col width="70%">
											<col width="15%">
											<col width="15%">
										</colgroup>
										<thead>
											<tr>
												<th align="left" ><egui:intnl text="reporter.common.VM Name"/></th>
												<th align="left" nowrap><egui:intnl text="reporter.common.Hypervisor Name"/></th>
											</tr>
										</thead>
										<tbody>
										<%
										String ToolRun="";
										String Hypv="";
										String Run="";
										for(int i=0;i<Running.size();i++){
											ToolRun =Running.get(i).toString();
											Run=ToolRun.substring(1,ToolRun.indexOf("="));
											Hypv=ToolRun.substring(ToolRun.indexOf("=")+1,ToolRun.indexOf("}"));
											%>
											<tr>
												<td><%=Run%></td>
												<td><%=Hypv%></td>
											</tr>
										<%}%>
										</tbody>
									</table>
								</div>
							</td>
						</tr>
							<%}
							%>
						<tr>
							<%if("VMware".equals(toolType)){%>
							<td><egui:intnl text="reporter.common.VMware tools Not Running"/></td>
							<%}else{%>
							<td><egui:intnl text="reporter.common.Tools Not Running"/></td>
							<%}%>
							<td><%=NotRunning.size()%></td>
						</tr>
							<%if(NotRunning.size()>0){%>
						<tr>
							<td align="right" colspan="2" style="padding:10px 20px 10px 20px">
								<div class = "newTable">
									<table width="100%" cellpadding="0" cellspacing="0" class="newimg">
										<colgroup>
											<col width="70%">
											<col width="15%">
											<col width="15%">
										</colgroup>
										<thead>
											<tr>
												<th align="left" ><egui:intnl text="reporter.common.VM Name"/></th>
												<th align="left" nowrap><egui:intnl text="reporter.common.Hypervisor Name"/></th>
											</tr>
										</thead>
										<tbody>
										<%
										String ToolRun="";
										String Hypv="";
										String Run="";
										for(int i=0;i<NotRunning.size();i++){
											ToolRun =NotRunning.get(i).toString();
											Run=ToolRun.substring(1,ToolRun.indexOf("="));
											Hypv=ToolRun.substring(ToolRun.indexOf("=")+1,ToolRun.indexOf("}"));
											%>
											<tr>
												<td><%=Run%></td>
												<td><%=Hypv%></td>
											</tr>
										<%}%>
										</tbody>
									</table>
								</div>
							</td>
						</tr>
							<%}%>
						<tr>
							<%if("VMware".equals(toolType)){%>
							<td><egui:intnl text="reporter.common.VMware tools Out of Date"/></td>
							<%}else{%>
							<td><egui:intnl text="reporter.common.Tools Out of Date"/></td>
							<%}%>
							<td><%=OutofDate.size()%></td>
						</tr>
							<%if(OutofDate.size()>0){%>
						<tr>
							<td align="right" colspan="2" style="padding:10px 20px 10px 20px">
								<div class = "newTable">
									<table width="100%" cellpadding="0" cellspacing="0" class="newimg">
										<colgroup>
											<col width="70%">
											<col width="15%">
											<col width="15%">
										</colgroup>
										<thead>
											<tr>
												<th align="left" ><egui:intnl text="reporter.common.VM Name"/></th>
												<th align="left" nowrap><egui:intnl text="reporter.common.Hypervisor Name"/></th>
											</tr>
										</thead>
										<tbody>
										<%
										String ToolRun="";
										String Hypv="";
										String Run="";
										for(int i=0;i<OutofDate.size();i++){
											ToolRun =OutofDate.get(i).toString();
											Run=ToolRun.substring(1,ToolRun.indexOf("="));
											Hypv=ToolRun.substring(ToolRun.indexOf("=")+1,ToolRun.indexOf("}"));
											%>
											<tr>
												<td><%=Run%></td>
												<td><%=Hypv%></td>
											</tr>
										<%}%>
										</tbody>
									</table>
								</div>
							</td>
						</tr>
							<%}%>
						<tr>
							<%if("VMware".equals(toolType)){%>
							<td><egui:intnl text="reporter.common.VMware tools Not Installed"/></td>
							<%}else{%>
							<td><egui:intnl text="reporter.common.Tools Not Installed"/></td>
							<%}%>
							<td><%=NotInstalled.size()%></td>
						</tr>
							<%if(NotInstalled.size()>0){%>
						<tr>
							<td align="right" colspan="2" style="padding:10px 20px 10px 20px">
								<div class = "newTable">
									<table width="100%" cellpadding="0" cellspacing="0" class="newimg">
										<colgroup>
											<col width="70%">
											<col width="15%">
											<col width="15%">
										</colgroup>
										<thead>
											<tr>
												<th align="left" ><egui:intnl text="reporter.common.VM Name"/></th>
												<th align="left" nowrap><egui:intnl text="reporter.common.Hypervisor Name"/></th>
											</tr>
										</thead>
										<tbody>
										<%
										String ToolRun="";
										String Hypv="";
										String Run="";
										for(int i=0;i<NotInstalled.size();i++){
											ToolRun =NotInstalled.get(i).toString();
											Run=ToolRun.substring(1,ToolRun.indexOf("="));
											Hypv=ToolRun.substring(ToolRun.indexOf("=")+1,ToolRun.indexOf("}"));
											%>
											<tr>
												<td><%=Run%></td>
												<td><%=Hypv%></td>
											</tr>
										<%}%>
										</tbody>
									</table>
								</div>
							</td>
						</tr>
							<%}%>
					</tbody>
				</table>
			</div>
		</td>
	</tr>
</table>
<%
	}
	}
	else
	{
%>
<table width='100%' height='100%'>
	<tr>
		<td align='center' valign='middle'><img src='/images/Light/nomeasures_custom.png' /></td>
	</tr>
</table>
<%
	}
%>
</div>
<%
if(pdfPrint !=null && pdfPrint.equalsIgnoreCase("yes"))
	{
%>

<div class="printFooterText"><%=strPrintFooterText%></div>
<%
	}
%>
</body>
</html>
