<!DOCTYPE html>

<%
/*****************************************************************************
*	File name		: ErLogonFailurePrint.jsp
*	Purpose			: This page Handles Print Application Logon Failure Report
*	Version			: Reporter 7.0
********************************************************************************/
%>
<%@ include file="ErTracker.jsp"%>
<%@ page import="egurkha.reporter.*"%>
<%@ page import="java.util.*"%>
<%@ page import = "net.sf.json.*" %>
<%@ page import="com.eg.*"%>
<%@ page import="com.eg.EgDbInfo"%>
<%@ page import="com.eg.IniFile"%>
<%@ page import="com.eg.EgDateInfo"%>
<%@ page import="java.text.Format.*"%>
<%@ page import="java.text.DateFormat.*"%>
<%@ page import="java.text.*"%>
<%@ page import="com.eg.EgReportInfo"%>
<%@ page import="com.eg.EgMappingInfo"%>
<%@ page import="com.eg.EgTablesInfo"%>
<%@ page import="com.egurkha.util.DateUtil"%>
<%@ page import="com.egurkha.util.*"%>
<%@ page import="com.egurkha.util.DateTimeTokenizer"%>
<%@ page import="com.eg.EgURLDecoder"%>
<%@ page import="com.eg.EgDbInfo"%>
<%@ page import="com.eg.EgConfigInfo"%>
<%@ page import="egurkha.reporter.LogonFailureBean"%>
<%@ page import="egurkha.reporter.EventLogBroken"%>
<%@ page import="java.io.*"%>
<%@ page import="com.egurkha.util.StringUtils"%>
<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>

<%
try
{
	String pdfPrint = request.getParameter("pdfPrint");
	

	EgReportInfo reportInfo = new EgReportInfo("manager");
	String strManagerURL = request.getScheme()+"://"+request.getServerName()+":"+ request.getServerPort();
	
	EgMappingInfo intlmp = new EgMappingInfo(thisuser.getLanguage());
	Map selectParams =  (Map)session.getAttribute("selectionDetail");
	System.out.println("selectParams--->"+selectParams);
	String analysisBy = (String)selectParams.get("analysisBy");
	String er_compType[] = (String[])selectParams.get("er_compType");
	String er_Component[] = (String[])selectParams.get("er_Component");
	String startDate = (String)selectParams.get("startdate");
	String endDate = (String)selectParams.get("enddate");
	String starthr = (String)selectParams.get("starthr");
	String endhr = (String)selectParams.get("endhr");
	String startmin = (String)selectParams.get("startmin");
	String endmin = (String)selectParams.get("endmin");
	String weekends = (String)selectParams.get("weekends");
	String timeFrom = (String)selectParams.get("timeFrom");
	String timeTo   = (String)selectParams.get("toTime");
	
	String uid = request.getParameter("uid");
	String currentDateFormat = strUserDateFormat;
	String Days="Saturday,Sunday";
	String comType = intlmp.getComponentTypeDescription(er_compType[0]);
	if("00:00:00".equals(timeFrom))
	{
		timeFrom  = timeFrom.substring(0,timeFrom.lastIndexOf(":"));
		timeTo    = timeTo.substring(0,timeTo.lastIndexOf(":"));
	}
	
	String reportType = (String)selectParams.get("reportType");
	String reportTypeStr=com.eg.EgURLEncoder.encode(reportType, "UTF-8");
	String controllerURL = strManagerURL+"/final/servlet/com.eg.ErLogonFailureReportC;jsessionid=" + session.getId() + "?&reportType="+reportTypeStr;
	String dispStart = (String)selectParams.get("dispStartDateTime");
	String dispEnd   = (String)selectParams.get("dispEndDateTime");	
	Map allData = (Map)session.getAttribute("allData");
	JSONObject userGraphObj = (JSONObject)allData.get("otheInfo");
	int dataPageNo = (Integer)userGraphObj.get("dataPageNo");	
	String titleToDisplay = "";
	if(reportType.equalsIgnoreCase("Logon Failure"))	
		titleToDisplay=reportInfo.getValue("Application_Logon_Failure_Report","reportTitle");
	else if(reportType.equalsIgnoreCase("VMUnregistered"))	
		titleToDisplay=reportInfo.getValue("Application_Event_Log_Report","reportTitle");
	String fileName=titleToDisplay;
	HashMap paramVal =new HashMap();
	paramVal.put("fileName",fileName);
	session.setAttribute("parameters", paramVal);
	%>
	<!Doctype html>
		<head>
		<%
			if(pdfPrint !=null && pdfPrint.equalsIgnoreCase("yes"))
			{
				%>

				<title>&nbsp; <egui:intnl text="reporter.common.Reporter" />
				&nbsp; &nbsp;-PDR- &nbsp;</title>
				<%
			}
			else
			{
				%>
					<title>eG Reporter</title>
				<%
			}
	%>
	<meta http-equiv="refresh">
	<link rel="stylesheet" type="text/css" href="/final/styles/eGLightThemeIcons.css" />
	<link rel="stylesheet" type="text/css" href="/final/reporter/styles/printpagestyle.css" />
	<style>
		@media print {body {-webkit-print-color-adjust: exact;}}
	.newTable table tbody tr td {border-bottom:1px solid #cdcdcd;padding:4px 10px 1px 10px;font-size:11px;
	line-height:14px !important;}

	</style>
	</head>
	<body marginwidth="20" marginheight="20" bgcolor="#FFFFFF">
	<%
	String strLogCls = "printHeaderBoxLogo";
	if(pdfPrint !=null && pdfPrint.equalsIgnoreCase("yes"))
	{
		strLogCls = "printHeaderBoxLogo";
	}else
		strLogCls = "printPdfHeaderBoxLogo";
	if(dataPageNo <= 1)
	{
		if(pdfPrint !=null && pdfPrint.equalsIgnoreCase("yes"))
		{
%>
			<div class="<%=strLogCls%>" style="padding:10px"><img src="<%=imageName%>" border="0" /></div>
<%
		}
		else
		{
%>
			<div class="<%=strLogCls%>"><img src="<%=imageName%>" border="0" /></div>
<%
		}
%>
		<div class="printHeaderBox">
		<%
	
		if (!StringUtils.isNull(titleToDisplay))
		{
			%>
			<div class="printHeaderBoxTitle"><%= titleToDisplay %></div>
			<%
		}
		else
		{
			%>
			<div class="printHeaderBoxTitle"><egui:intnl text="reporter.common.Application Logon Failure Report) " /></div>
			<%
		}
		if(pdfPrint !=null && pdfPrint.equalsIgnoreCase("yes"))
		{
%>
			<div class="printHeaderBoxPrintIcon"><img class="iconPrinter mouse"  id="pri ntbt" src="data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==" border="0" onClick="javascript:window.print()" alt='<egui:intnl text="reporter.common.PRINT"/>' title='<egui:intnl text="reporter.common.PRINT"/>'/></div>
<%
		}
%>
		</div>
		<div class="printOuterBoxNoBorder"> 
		<%
		if(analysisBy != null)
		{
			%>
			<div class="printSelectionFields"><egui:intnl text="reporter.common.Analyzed by"/>:<span class="bold"><%=analysisBy%></span></div>
			<%
		}
		if(comType!=null)
		{
			%>
			<div class="printSelectionFields"><egui:intnl text="reporter.common.Compenet Type"/>:<span class="bold"><%=comType%></span></div>
			<%
		}
		if(weekends != null)
		{
			%>
			<div class="printSelectionFields"><egui:intnl text="reporter.common.Exclude Weekends"/>:<span class="bold"><%=weekends%></span></div>
			<%
		}
		if(dispStart != null)
		{
			%>
			<div class="printSelectionFields"><egui:intnl text="reporter.common.Start Date" />: <span class="bold"><%=dispStart%></span></div>
			<%
		}
		if(dispEnd != null)
		{
			%>
			<div class="printSelectionFields"><egui:intnl text="reporter.common.End Date" />: <span class="bold"><%=dispEnd%></span></div>
			<%
		}
		if(timeFrom != null)
		{
			%>
			<div class="printSelectionFields"><egui:intnl text="reporter.common.Time Period"/>: <span class="bold"><%=timeFrom%>&nbsp;   <egui:intnl text="reporter.common.to "/>&nbsp; <%=timeTo%></span></div>
			<%
		}
	}
	%>	
	</div>
	<%
	String urlValue=null;
	boolean isData=false;
	String hideDesign = null;
	if(allData != null && allData.get("isData") != null)
	{
		isData=(Boolean)allData.get("isData");
	}
	if(allData.get("hideDesign") != null)
		hideDesign = (String)allData.get("hideDesign");
	System.out.println("isData-->"+isData+"  hideDesign-->"+hideDesign+"  reportType-->"+reportType);
	if(isData)
	{
		if(reportType.equalsIgnoreCase("Logon Failure"))
		{
			if(hideDesign!=null && hideDesign.equalsIgnoreCase("No"))
			{		
				JSONArray overViewJsonArray=(JSONArray)allData.get("overDataMap");
				JSONArray pieChartData = (JSONArray)allData.get("legendArray");
				%>
				<div class="clearDiv"></div>
				<div class="printOuterBox" style="margin-top:10px">
					<div class="printOuterBoxHeader">Overview</div>
					<table valign="middle" width="100%" cellpadding="0px" cellspacing="0px" >
						<tbody>
							<tr>
								<% 
									for(int i=0; i<overViewJsonArray.size(); i++)
									{
										JSONObject overView=(JSONObject)overViewJsonArray.get(i);
										int count=(Integer)overView.get("value");
										String displayName=(String)overView.get("displayName");
										String imageCls=(String)overView.get("imageCls");
									%>							
										<td align="center" width="22%">
											<table cellpadding="0px" cellspacing="0px">
												<tbody>
													<tr> 
														<td align="right"><div class="<%=imageCls%>"></div></td>
														<td style="padding:5px 5px 5px 10px"><span class="newFont_bold28"><%=count%></span></td>
													</tr>
													<tr>
														<!--<td>&nbsp;</td>-->
														<td align="center" style="padding:7px" colspan="2"><span class="newFont_normal13"><%=displayName%></span></td>
													</tr>
												</tbody>
											</table>
										</td>							
									<%
									}							
								%>	
							</tr>
						</tbody>
					</table>
				</div>


				<div class="clearDiv"></div>
				
				<table width="100%">
					<tr>
						<td width="50%" style="padding:10px 10px 10px 0px">
							<div class="printOuterBox">
								<div class="printOuterBoxHeader">Logon Failure</div>
								<table width="100%">
									<tbody>
										<tr>
											<td width="55%">
												<div style="width:100%;overflow:auto;padding:10px">
													<img src="<%=controllerURL+"&er_view=print&width=270&height=295&chartFor=donut"%>"/>
												</div>
											</td>
											<td width="45%" valign="middle">
												<table>
													<tbody>												
													<%
													for(int i=0;i<pieChartData.size(); i++)
													{
														JSONObject pieData=(JSONObject)pieChartData.get(i);
														String name = (String)pieData.get("name");
														String color = (String)pieData.get("color");
														double percent = (Double)pieData.get("percent");
														//String value = (String)pieData.get("value");
													%>
													<tr>
														<td >
															<svg xmlns="http://www.w3.org/2000/svg" height="10" width="10">
															  <circle cx="5" cy="5" r="4" fill="<%=color%>" />
															</svg>
														</td>
														<td style='padding:0px 5px;' class='newFont_normal11'><%=name%>&nbsp;(<%=percent%> %)</td>
													<tr>
													<%
														}
													%>												
													</tbody>
												</table>
											</td>
										</tr>
									</tbody>
								</table>
							</div>
						</td>
						<td width="50%" style="padding:0px 0px 0px 0px">
							<div class="printOuterBox">
								<div class="printOuterBoxHeader">Top 10 Users With Most Number Of Failures</div>
								<div style="width:100%;overflow:auto;padding:10px">
									<img src="<%=controllerURL+"&er_view=print&width=400&height=300&chartFor=topNUser"%>"/>
								</div>
							</div>
						</td>
					</tr>
				</table>
				
				<table width="100%">
					<tr>
						<td width="50%" style="padding:10px 10px 5px 0px">
							<div class="printOuterBox">
								<div class="printOuterBoxHeader">Top 10 Servers With Most Number Of Failures</div>
								<div style="width:100%;overflow:auto;padding:10px">
									<img src="<%=controllerURL+"&er_view=print&width=400&height=300&chartFor=topNTargetHost"%>"/>
								</div>
							</div>
						</td>
						<td width="50%" style="padding:0px 0px 0px 0px">
							<div class="printOuterBox">
								<div class="printOuterBoxHeader">Top 10 Client IP With Most Number Of Failures</div>
								<div style="width:100%;overflow:auto;padding:10px">
									<img src="<%=controllerURL+"&er_view=print&width=400&height=300&chartFor=topNClientIp"%>"/>
								</div>
							</div>
						</td>
					</tr>
				</table>
				<div class="clearDiv"></div>
				<table width="100%">
					<tr>
						<td width="100%" style="padding:10px 0px 5px 0px">
							<div class="printOuterBox">
								<div class="printOuterBoxHeader">Logon Failure Trend</div>
								<div style="width:100%;overflow:auto;">
									<img src="<%=controllerURL+"&er_view=print&width=900&height=265&chartFor=failTime"%>"/>
								</div>
							</div>
						</td>
					</tr>
				</table>
				<div class="clearDiv"></div>
					<div class="printOuterBox" style="margin-top:10px">
							<div class="printOuterBoxHeader" >Logon Failure Details</div>
							<div class="newTable">
							<%
								out.println("<table  align='center'  width='100%'>");
								out.println("<colgroup><col width='10%'><col width='10%'><col width='10%'><col width=10%'><col width='10%'><col width='10%'><col width='20%'><col width='10%'><col width='10%'></colgroup>");
								out.println("<thead>");
								out.println("<tr>");
								out.println("<th align='left'>DOMAIN</th>");
								out.println("<th align='left'>ACCOUNT NAME</th>");
								out.println("<th align='left'>SERVER</th>");
								out.println("<th align='left'>CLIENT IP</th>");
								out.println("<th align='left'>FAILURE DATE</th>");
								out.println("<th align='left'>FAILURE REASON</th>");
								out.println("<th align='left'>LOGON PROCESS</th>"); 
								out.println("<th align='left'>AUTHENTICATION PACKAGE</th>");
								out.println("<th align='left'>PROCESS NAME</th>");
								out.println("</tr>");
								out.println("</thead>");
								out.println("<tbody>");	
								List failList = (List)allData.get("allDataList");
								LogonFailureBean bean = null;
								StringBuffer detailData = new StringBuffer();
								for(int i=0;i<failList.size();i++)
								{
									bean = (LogonFailureBean)failList.get(i);
									detailData.append("<tr><td>"+bean.getAccountDomain()+"</td>");
									detailData.append("<td>"+bean.getAccountName()+"</td>");
									detailData.append("<td>"+bean.getTargetHost()+"</td>");
									detailData.append("<td>"+bean.getSourceNetworkAddress()+"</td>");							
									detailData.append("<td>"+bean.getEventDate()+"</td>");
									detailData.append("<td>"+bean.getFailureReason()+"</td>");
									detailData.append("<td>"+bean.getLogonProcess()+"</td>");
									detailData.append("<td>"+bean.getAuthenticationPackage()+"</td>");
									detailData.append("<td>"+bean.getCallerProcessName()+"</td></tr>");
								}					
								out.println(detailData);
								out.println("</tbody>");
								out.println("</table>");
							%>
							</div>
					</div>
				<%
			}
			else if(hideDesign!=null && hideDesign.equalsIgnoreCase("Yes"))
			{
				
				%>
				
				<div class="clearDiv"></div>
				<div class="newTable">
					<%
						out.println("<table  align='center'  width='100%'>");
						out.println("<colgroup><col width='10%'><col width='10%'><col width='10%'><col width=10%'><col width='10%'><col width='10%'><col width='20%'><col width='10%'><col width='10%'></colgroup>");
												
							out.println("<thead>");
							out.println("<tr>");
							out.println("<th align='left'>DOMAIN</th>");
							out.println("<th align='left'>ACCOUNT NAME</th>");
							out.println("<th align='left'>SERVER</th>");
							out.println("<th align='left'>CLIENT IP</th>");
							out.println("<th align='left'>FAILURE DATE</th>");
							out.println("<th align='left'>FAILURE REASON</th>");
							out.println("<th align='left'>LOGON PROCESS</th>"); 
							out.println("<th align='left'>AUTHENTICATION PACKAGE</th>");
							out.println("<th align='left'>PROCESS NAME</th>");
							out.println("</tr>");
							out.println("</thead>");						
						//}
						out.println("<tbody>");	
						List failList = (List)allData.get("allDataList");
						LogonFailureBean bean = null;
						StringBuffer detailData = new StringBuffer();
						for(int i=0;i<failList.size();i++)
						{
							bean = (LogonFailureBean)failList.get(i);
							String failureReason = bean.getFailureReason();
							detailData.append("<tr><td>"+bean.getAccountDomain()+"</td>");
							detailData.append("<td>"+bean.getAccountName()+"</td>");
							detailData.append("<td>"+bean.getTargetHost()+"</td>");
							detailData.append("<td>"+bean.getSourceNetworkAddress()+"</td>");							
							detailData.append("<td>"+bean.getEventDate()+"</td>");
							detailData.append("<td>"+failureReason+"</td>");
							detailData.append("<td>"+bean.getLogonProcess()+"</td>");
							detailData.append("<td>"+bean.getAuthenticationPackage()+"</td>");
							detailData.append("<td>"+bean.getCallerProcessName()+"</td></tr>");
						}					
						out.println(detailData);
						out.println("</tbody>");
						out.println("</table>");
					%>
				</div>
				<%
			}
		}
		else if(reportType.equalsIgnoreCase("VMUnregistered"))
		{
			int totalPoolCount = (Integer)allData.get("poolCount");
			int totalMachineCount = (Integer)allData.get("machineCount");
			%>	
				<div class="newTable" style="margin-top:10px">
					<table align="center" width="50%" cellspacing="0">	
						<thead>
							<tr>
								<th align='center' colspan ='2'>Summary</th>
							</tr>
						</thead>
						<tbody>
							<tr>
								<td width="60%">Total Unique Pools</td><!--Total Unique Pool -->
								<td align="center" width="40%"><%=totalPoolCount%></td>
							</tr>
							<tr>
								<td width="60%">Total Unregistered Machines</td><!--Total Unregister Machines -->
								<td align="center" width="40%"><%=totalMachineCount%></td>
							</tr>
						</tbody>					
					</table>
				</div>
			<%
			Map<String, List<EventLogBroken>> serverDetailMap = (Map)allData.get("gridDataMap");
			%>
			<div class="clearDiv"></div>
				<div class="newTable" style="margin-top:10px">
				<%
					out.println("<table  align='center'  width='100%'>");
					out.println("<thead>");
					out.println("<tr>");
					out.println("<th align='left'>Server</th>");
					out.println("<th align='left'>Unqiue Pools</th>"); // Unqiue Pool
					out.println("<th align='left'>Unregistered Machines</th>"); //Unique Machine
					out.println("</tr>");
					out.println("</thead>");
					out.println("<tbody>");				
					for(String server : serverDetailMap.keySet())
					{
						Map<String, Integer> poolMap = new HashMap<String, Integer>();
						Map<String, Integer> machineMap = new HashMap<String, Integer>();
						StringBuffer innerTblData = new StringBuffer();
						innerTblData.append("<div class='newTable'>");
						innerTblData.append("<table width='100%' style='margin:10px 0px 10px 0px;'>");
						innerTblData.append("<col width='13%'><col width='13%'><col width='13%'><col width=10%'><col width='10%'><col width='15%'><col width='13%'><col width='13%'>");
						innerTblData.append("<thead>");
						innerTblData.append("<tr><th>POOL</th><th>DESKTOP ID</th><th>EVENT DATE</th><th>USER</th><th>SESSION TYPE</th><th>AGENT ERROR CODE</th><th>NODE</th><th>SOURCE</th></tr>");
						innerTblData.append("</thead><tbody>");

						List<EventLogBroken> eventBeanList = serverDetailMap.get(server);
						for(int i=0; i<eventBeanList.size(); i++)
						{
							EventLogBroken bean = (EventLogBroken)eventBeanList.get(i);
							String pool = bean.getPool();
							String machineId = bean.getMachineId();
							String agentErrCode = bean.getaAentErrorCode();
							if(agentErrCode.equals("-"))
								agentErrCode = "<center>"+agentErrCode+"</center>";
							int count = 0;
							if(poolMap.containsKey(pool))
							{
								count = poolMap.get(pool) + 1;						
							}
							else
							{
								count++;
							}
							poolMap.put(pool,count);
							count = 0;
							if(machineMap.containsKey(machineId))
							{
								count = machineMap.get(machineId) + 1;
							}
							else
							{
								count++;
							}
							machineMap.put(machineId, count);
							innerTblData.append("<tr><td>"+pool+"</td>");
							innerTblData.append("<td>"+bean.getDesktopId()+"</td>");
							innerTblData.append("<td>"+bean.getEventDate()+"</td>");
							innerTblData.append("<td>"+bean.getUserDisplayName()+"</td>");
							innerTblData.append("<td>"+bean.getSessionType()+"</td>");
							innerTblData.append("<td>"+agentErrCode+"</td>");
							innerTblData.append("<td>"+bean.getNode()+"</td>");
							innerTblData.append("<td><div style='width: 80px; word-wrap: break-word; overflow-x:auto;'>"+bean.getSource()+"</div></td></tr>");
						}
						innerTblData.append("</tbody></table></div>");
						int poolCount =  poolMap.size();
						int machineCount = machineMap.size();
						out.println("<tr><td>"+server+"</td><td>"+poolCount+"</td><td>"+machineCount+"</td></tr>");
						out.println("<tr><td colspan ='3'>"+innerTblData+"</td></tr>");
					}
					out.println("</tbody>");
					out.println("</table>");
				%>
			</div>
			<%
		}
	}		
	else
	{
		%>
		<div class="printOuterBox">
			<div class="printOuterBoxHeader"><%=titleToDisplay%></div>
			<div style="width:100%;overflow:auto;padding:10px">
			<%
				out.println("<table width='100%' height='100%'><tbody><tr><td align='center' valign='middle' class='font_normal12'><div class='iconExclamation'></div>No failures occurred</td></tr></tbody></table>");
			%>
			</div>
		</div>
		<%
	}
	%>
	</body>
</html>
	<%
}
catch(Exception e)
{
	e.printStackTrace();
}
%>