<%@ include file = "EgMonitorTracker.jsp" %>
<%@ page errorPage="EgErrorSmall.jsp" %>
<%@ page import = "com.eg.EgURLEncoder"%>
<%@ page import = "com.egurkha.*" %>
<%@ page import = "com.egurkha.monitor.*" %>
<%@ page import = "java.util.*" %>
<%@ page import = "com.egurkha.ini.*" %>
<%@ page import = "com.eg.EgMappingInfo"%>
<%@ page import="net.sf.json.*"%>
<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld" %>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>

<%@ page import="com.fasterxml.jackson.databind.ObjectMapper"%>
<%@ page import="com.fasterxml.jackson.databind.node.ArrayNode"%>
<%@ page import="com.fasterxml.jackson.databind.node.ObjectNode"%>
<%@ page import="com.fasterxml.jackson.databind.JsonNode"%>

<%
response.setHeader("Cache-Control","no-store");
response.setHeader("Pragma","no-cache");
response.setDateHeader ("Expires", -1);
response.setContentType("application/json");
UserZonesResult r = (UserZonesResult) request.getAttribute("result");
UserZonesData d = (UserZonesData) request.getAttribute("data");
String treeFlag=request.getParameter("treeFlag");
long refreshFrequency = 60 * 1000L;
String refFreq = d.user.getRefreshFrequency();

if(refFreq!=null && refFreq.length()>0)
{
	refreshFrequency =  Long.valueOf(refFreq).longValue() * 1000L;	
}
%>

  <%
try
{
	UserRegistry registry = UserRegistry.getInstance();
	User users = registry.getUser(session.getId());
	String thisLanguage="";
	try
	{
		com.egurkha.ini.IniUI ui = (com.egurkha.ini.IniUI)com.egurkha.ini.IniUI.getInstance();
		thisLanguage = ui.getDefaultLanguage();
		if (users!=null)
		{
			String userLang = users.getLanguage();
			if (userLang!=null && !userLang.equalsIgnoreCase("NULL"))
			{
				thisLanguage=userLang;
			}
		}
	}
	catch(Exception e)
	{
		System.out.println(e);
	}
	//EgMappingInfo mappingInfo = new EgMappingInfo(thisLanguage);
	ObjectMapper mapper = new ObjectMapper();
	ObjectNode json  = mapper.createObjectNode();
	ArrayNode zoneData= mapper.createArrayNode(); 

	if (r.zoneList!=null)
	{
		int i = 0;
		ArrayList userList = null;
		EgZone zone = null;
		ArrayList none = new ArrayList();
		for(i = 0; i < r.zoneList.size(); i++)
		{
			ObjectNode zoneDataObject = mapper.createObjectNode();
			int IntCount=0;
			if(r.showImage)
				IntCount=4;//12;
			else
				IntCount=4;
			zone = (EgZone) r.zoneList.get(i);
			//userList = none;
			if(r.zoneUsers.get(zone.getName()) != null)
			{
				userList = (ArrayList) r.zoneUsers.get(zone.getName());
			}
			else
			{
				userList = new ArrayList();
			}
			zoneDataObject.put("name",zone.getName());
			zoneDataObject.put("link","/final/monitor/zoneDash.jsp?treeFlag="+treeFlag+"&outsideZone=true&titleText=zone&selectNode=Zone$cap$"+EgURLEncoder.encode(zone.getName(),"UTF-8")+ "&zoneFromZone="+EgURLEncoder.encode(zone.getName(),"UTF-8"));
			zoneDataObject.put("iconClass","state_footer_"+zone.getState().getName());
			
			if (userList != null && userList.size()>0)
			{
				/*for(int j = 0; j < userList.size(); j++)
				{
					String user = null;
					if(j < userList.size())
					{
						user = (String) userList.get(j);
					}
					zoneDataObject.put("userName",user);
				}*/
				zoneDataObject.put("userName",userList.toString());
			}
			else
			{
				zoneDataObject.put("userName",mappingInfo.getTextDescription("monitor.associationszone.None"));
			}
			zoneData.add(zoneDataObject);
		}
	}	
	json.put("recordData",zoneData);

	ObjectNode labelObj= mapper.createObjectNode();
	labelObj.put("monitor.associationszone.Zone",mappingInfo.getTextDescription("monitor.associationszone.Zone"));
	labelObj.put("monitor.associationszone.Users",mappingInfo.getTextDescription("monitor.associationszone.Users"));
	
	json.put("screenLabels",labelObj);
	response.getWriter().write(json.toString());
}
catch(Throwable t){
	t.printStackTrace();
}
%>