<%
/*
 *   File				:	ecSystemManufacturers.jsp
 *   Purpose			:	Shows system manufacturers
 *   Creation Date		:	16/02/2007
 *   Author				:	Krishnamurthi
 *   UI Design			:	Krishnamurthi
 *   UI Design Changes	:	Jaiwin
 */
%>

<%@ include file = "EcTracker.jsp"%>
<%@ page errorPage= "EcProbs.jsp"%>
<%@ page import = "egurkha.config.EcUtils"%>
<%@ page import = "java.util.*"%>
<%@ page import = "java.net.URLEncoder"%>
<%@ page import = "com.egurkha.pdfmaker.*"%>
<%@ page import = "com.eg.EgMappingInfo"%>
<%@ page import="com.egurkha.User" %>
<%@ page import="com.egurkha.UserRegistry" %>
<%@ page import="com.egurkha.ini.IniUI"%>
<%@ page import = "com.eg.EgURLEncoder"%>
<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld" %>
<%@ page import = "egurkha.config.EcFusionChartBean" %>
<%@ page import = "egurkha.config.ConfigDbSetting" %>
<%@ page import = "com.eg.EgConfigConstants"%>
<%@ page import = "com.eg.EgConfigTestsInfo"%>
<%@ page import = "com.eg.EgConfigInfo"%>
<%@ page import = "java.text.*"%>
<%@ page import = "com.egurkha.EgTimeZoneConverter"%>
<%@ page import = "com.egurkha.util.DateUtil"%>
<%@ page import = "com.eg.EgInstallInfo" %>

<%@ page language="java" contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" %>

<%!
	String[] criterias = {"Zone","Service","Segment","Component"};
%>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
%>

<%
	//language support
	UserRegistry registry = UserRegistry.getInstance();
	User user = registry.getUser(session.getId());
	IniUI iniUI = IniUI.getInstance();

	//user language
	String userLanguage = iniUI.getDefaultLanguage();
	if (user != null)
	{
		userLanguage = user.getLanguage();
	}
	EgMappingInfo mappingInfo = new EgMappingInfo(userLanguage);

	String configSkin = user.getConfigSkin();
	String userName = (String)session.getAttribute("sess_auserid");
	EcUtils ecUtils = new EcUtils();
	String manufacturer = request.getParameter("manufacturer");
	Vector vecManufacturers = (Vector)request.getAttribute("SystemManufacturers");
	TreeMap tmapSystemDetails = (TreeMap)request.getAttribute("SystemDetails");
	String request_from = request.getParameter("request_from");
	String id = request.getParameter("id");
	String submitOrNot = (String) request.getAttribute("isSubmit");

	EgConfigTestsInfo configTestsInfo = new EgConfigTestsInfo("manager");
	Map dashboardSetting = (Hashtable)ConfigDbSetting.getDbSettingData(user.getLoginID(),EgConfigConstants.USER_COMMON_SETTING);
	String barColor = configTestsInfo.getServerDisplayValue("MISC_ARGS","ChartColor");
	String chartDataRepresentation = configTestsInfo.getServerDisplayValue("MISC_ARGS","ChartDataRepresentation");

	String uiFile = "eg_ui.ini";
	String s_iniFile_dir = EgInstallInfo.getInstallDir()+ "/manager/config/";
	IniFile iniFile = new IniFile(s_iniFile_dir + uiFile);
	String currentDateFormat = iniFile.getValue("CURRENT_DATE_FORMAT","selectedDateFormat");
	SimpleDateFormat formatter = new SimpleDateFormat(currentDateFormat+" "+"HH:mm:ss");
	Date currentDateTime = new Date();
	String dateString = formatter.format(currentDateTime);

	/* Added by Prakash.K Starts */
	EgTimeZoneConverter timeZoneConverter = new EgTimeZoneConverter(dateString,user);
	dateString = timeZoneConverter.getDateTime();
	/* Added by Prakash.K Ends */

	String ec_criteria = (String)session.getAttribute("ec_criteria");
	String ec_criteriaPrevious = request.getParameter("ec_criteriaPrevious");

	Vector vecCriterias = new Vector();
	for (int g=0;g<criterias.length;g++)
	{
		String criteria = criterias[g];
		vecCriterias.add(criteria);
	}

	Vector vecUserOptions = (Vector)session.getAttribute("vecUserOptions");
	String ec_userOption = (String)session.getAttribute("ec_userOption");
	String ec_userOptionPrevious = request.getParameter("ec_userOptionPrevious");

	Map scheduleDetails = (Map)request.getAttribute("ScheduleDetails");
	if (scheduleDetails != null && request_from != null && request_from.equalsIgnoreCase("saveSchedule"))
	{
		vecUserOptions = (Vector) scheduleDetails.get("vecUserOptions");
		manufacturer = (String)scheduleDetails.get("manufacturer");
		ec_userOption = (String)scheduleDetails.get("ec_userOption");
		ec_userOptionPrevious = (String)scheduleDetails.get("ec_userOptionPrevious");
		submitOrNot = "false";
	}

	boolean isDisplay = true;
	if (scheduleDetails != null && request_from != null && request_from.equalsIgnoreCase("saveSchedule"))
	{
		ec_criteria = (String)scheduleDetails.get("ec_criteria");
		ec_criteriaPrevious = (String)scheduleDetails.get("ec_criteriaPrevious");
	}

	if (submitOrNot == null || "null".equals(submitOrNot))
	{
		submitOrNot = "true";
		isDisplay = true;
	}

	if (request_from != null && request_from.equalsIgnoreCase("saveSchedule"))
	{
		isDisplay = false;
	}

	boolean flag = false;
	if (vecManufacturers != null && vecManufacturers.size() > 0)
	{
		flag = vecManufacturers.contains("All");
		if (!flag)
			manufacturer = (String)vecManufacturers.get(0);
	}

	if (tmapSystemDetails != null)
	{
		session.setAttribute("SystemManufacturerDetails",tmapSystemDetails);
		session.setAttribute("manufacturer",manufacturer);
	}

	String mngrIProc = new IniFile(new EgConfigInfo("manager").getDbFile()).getValue("DB_PROPERTIES","ManagerUrl");
%>

<html>
<head>
<!-- <link rel="stylesheet" href="/final/config/styles/ec_style_green.css" /> -->
<egui:skin ui="config"/>
<script language="JavaScript1.2" type="text/javascript" src="/final/FusionCharts/scripts/FusionCharts.js"></script>
<script language="JavaScript1.2" src="../config/scripts/ec_validate.js"></script>
<script language="JavaScript1.2" src="/../final/scripts/screen_display.js"></script>
<script language="JavaScript1.2">
	function get()
	{
		var thisForm = document.forms[0];
		var mf = thisForm.manufacturer.value;
		var tempCriteria = "";
		var tempUserOption = "";
		var tempCriteriaPrevious = "";
		var tempUserOptionPrevious = "";

		if (thisForm.ec_criteria != null && thisForm.ec_criteria != undefined)
		{
			tempCriteria = thisForm.ec_criteria.value;
		}
		if (thisForm.ec_userOption != null && thisForm.ec_userOption != undefined)
		{
			tempUserOption = thisForm.ec_userOption.value;
		}

		if (tempCriteria != null && tempCriteria != undefined && tempCriteria != -1)
		{
			if (tempUserOption != null && tempUserOption !=undefined && tempUserOption == -1)
			{
				if (tempCriteria == "Zone")
				{
					alert('<egui:intnl text="configmgmt.common.Please select a Zone" />');
					return false;
				}
				else if (tempCriteria == "Service")
				{
					alert('<egui:intnl text="configmgmt.common.Please select a Service" />');
					return false;
				}
				else if (tempCriteria == "Segment")
				{
					alert('<egui:intnl text="configmgmt.common.Please select a Segment" />');
					return false;
				}
			}
		}
		if (thisForm.ec_criteriaPrevious != null && thisForm.ec_criteriaPrevious != undefined)
		{
			tempCriteriaPrevious = thisForm.ec_criteriaPrevious.value;
		}
		if (thisForm.ec_userOptionPrevious != null && thisForm.ec_userOptionPrevious != undefined)
		{
			tempUserOptionPrevious = thisForm.ec_userOptionPrevious.value;
		}

		if (mf == "-1")
		{
			alert('<egui:intnl text="configmgmt.inventory.system.Please select a system manufacturer" />');
			return;
		}
		window.location.href="../servlet/com.eg.EcConfigurationServlet?ec_rtype=SystemManufacturer&manufacturer="+mf+"&ec_criteria="+tempCriteria+"&ec_userOption="+encodeURIComponent(tempUserOption)+"&ec_criteriaPrevious="+tempCriteriaPrevious+"&ec_userOptionPrevious="+encodeURIComponent(tempUserOptionPrevious);
		document.SystemManufacturer.secsubmt.value='<egui:intnl text="configmgmt.common.Loading" />'+'...';
		document.SystemManufacturer.secsubmt.disabled=true;
	}

	function validateforSchedule()
	{
		var thisForm = document.forms[0];
		var mf = thisForm.manufacturer.value;
		var tempCriteria = "";
		var tempUserOption = "";
		var tempCriteriaPrevious = "";
		var tempUserOptionPrevious = "";

		if (thisForm.ec_criteria != null && thisForm.ec_criteria != undefined)
		{
			tempCriteria = thisForm.ec_criteria.value;
		}
		if (thisForm.ec_userOption != null && thisForm.ec_userOption != undefined)
		{
			tempUserOption = thisForm.ec_userOption.value;
		}

		if (tempCriteria != null && tempCriteria != undefined && tempCriteria != -1)
		{
			if (tempUserOption != null && tempUserOption !=undefined && tempUserOption == -1)
			{
				if (tempCriteria == "Zone")
				{
					alert('<egui:intnl text="configmgmt.common.Please select a Zone" />');
					return false;
				}
				else if (tempCriteria == "Service")
				{
					alert('<egui:intnl text="configmgmt.common.Please select a Service" />');
					return false;
				}
				else if (tempCriteria == "Segment")
				{
					alert('<egui:intnl text="configmgmt.common.Please select a Segment" />');
					return false;
				}
			}
		}

		if (mf == "-1")
		{
			alert('<egui:intnl text="configmgmt.inventory.system.Please select a system manufacturer" />');
			return false;
		}
	}

	function printData()
	{
<%
	if (tmapSystemDetails == null || tmapSystemDetails.size()==0)
	{
%>
		alert('<egui:intnl text="configmgmt.common.No data available" />');
		return;
<%
	}

		StringBuffer printQS = new StringBuffer();
		printQS.append("printType=SystemManufacturer");
		printQS.append("&printPageTitle=DISTRIBUTION_REPORT_OF_MANAGED_SYSTEMS_BY_MANUFACTURER");
		printQS.append("&Page=AuditReport");
		printQS.append("&printData=yes");
		printQS.append("&userName="+EgURLEncoder.encode(userName,"UTF-8"));
		printQS.append("&user_language="+userLanguage);
		printQS.append("&ec_criteria="+ec_criteria);
		printQS.append("&ec_userOption="+((ec_userOption != null)?EgURLEncoder.encode(ec_userOption,"UTF-8"):""));
%>
		var s_qryString = "../servlet/com.eg.EcRepoLiteC?<%=printQS.toString()%>&ec_forPDF=No";
		print(s_qryString);
	}

	function savePdf()
	{
<%
	if (tmapSystemDetails == null || tmapSystemDetails.size()==0)
	{
%>
		alert('<egui:intnl text="configmgmt.common.No data available" />');
		return;
<%
	}
	session.setAttribute("PDF_URL",mngrIProc+"/final/servlet/com.eg.EcRepoLiteC;jsessionid="+session.getId()+"?"+printQS.toString()+"&ec_forPDF=Yes");
	session.setAttribute("REPORT_NAME","InventoryReportByManufacturer");
	session.setAttribute("REPORT_LAYOUT","Portrait");
	session.setAttribute("PAGE_WIDTH_PDF","1100");
	session.setAttribute("PAGE_WIDTH_MAIL_IMAGE","1300");
	session.setAttribute("PAGE_HEIGHT_MAIL_IMAGE","768");
%>
		getPdf('<%=configSkin%>');
	}

	function mail()
	{
<%
	if (tmapSystemDetails == null || tmapSystemDetails.size()==0)
	{
%>
		alert('<egui:intnl text="configmgmt.common.No data available" />');
		return;
<%
	}
%>
		sendMail();
	}

	function getInformations()
	{
		var thisForm = document.SystemManufacturer;
		var tempCriteria = "";
		var tempUserOption = "";
		var tempCriteriaPrevious = "";
		var tempUserOptionPrevious = "";

		if (thisForm.ec_criteria != null && thisForm.ec_criteria != undefined)
		{
			tempCriteria = thisForm.ec_criteria.value;
		}
		if (thisForm.ec_userOption != null && thisForm.ec_userOption != undefined)
		{
			tempUserOption = thisForm.ec_userOption.value;
		}
		if (thisForm.ec_criteriaPrevious != null && thisForm.ec_criteriaPrevious != undefined)
		{
			tempCriteriaPrevious = thisForm.ec_criteriaPrevious.value;
		}
		if (thisForm.ec_userOptionPrevious != null && thisForm.ec_userOptionPrevious != undefined)
		{
			tempUserOptionPrevious = thisForm.ec_userOptionPrevious.value;
		}

		window.location.href="../servlet/com.eg.EcConfigurationServlet?ec_rtype=SystemManufacturer&ec_criteria="+tempCriteria+"&ec_userOption="+encodeURIComponent(tempUserOption)+"&ec_criteriaPrevious="+tempCriteriaPrevious+"&ec_userOptionPrevious="+encodeURIComponent(tempUserOptionPrevious)+"&request_from=<%=request_from%>&id=<%=id%>";
	}

	function csv()
	{
<%
		if (tmapSystemDetails == null || tmapSystemDetails.size()==0)
		{
%>
			alert('<egui:intnl text="configmgmt.common.No data available" />');
			return;
<%
		}
%>
		thisForm = document.forms[0];
		thisForm.action = '../servlet/com.eg.EcCSVController?ec_criteria=<%=ec_criteria%>&ec_userOption=<%=((ec_userOption != null)?EgURLEncoder.encode(ec_userOption,"UTF-8"):"")%>';
		thisForm.submit();
	}

	function schedule(op)
	{
		var checkFlag = validateforSchedule();
		if(checkFlag == false) return;
		var thisForm = document.SystemManufacturer;
		if (op == "schedule")
		{
<%
			if (request_from != null && request_from.equalsIgnoreCase("saveSchedule"))
			{
%>
			thisForm.action = "/final/config/EcSaveSchedule.jsp?id=<%=id%>";
<%
			}
			else
			{
%>
			thisForm.action = "/final/config/EcSaveSchedule.jsp?id=<%=id%>&request_from=SystemManufacturer";
<%
			}
%>
		}
		else if (op =="favorite")
		thisForm.action = "/final/config/EcSaveFavorite.jsp";
		else
		{
			alert('<egui:intnl text="configmgmt.common.Illegal Access" />');
			return;
		}
		thisForm.submit();
	}

	function goBackToSaveSchedule()
	{
		var thisForm = document.forms[0];
		thisForm.action = "/final/config/EcSaveSchedule.jsp?request_from=<%=request_from%>&id=<%=id%>";
		thisForm.submit();
	}

</script>

</head>

<body topmargin="0" marginheight="0" leftmargin="0" marginwidth="0" style="overflow:auto" onLoad="bigScreen();">
<form name="SystemManufacturer" method="POST" style="margin:0px">
<table align="center" cellspacing="0" cellpadding="0" border="0" width="100%" height="100%">
<input type="hidden" name="ec_rtype" value="SystemManufacturer">
<input type="hidden" name="ec_trgttype" value="Configuration_Report">
<input type="hidden" name="ec_criteriaPrevious" value="<%=ec_criteria%>">
<input type="hidden" name="ec_userOptionPrevious" value="<%=ec_userOption%>">
<input type="hidden" name="isSubmit" value="true">

	<tr>
		<td align="right" valign="middle" id="layer_headbg" height="18" width="100%" style="padding:0px;border-left-width:0px;border-right-width:0px">
			<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0">
				<tr>
					<td align="left" id="main_head_top" width="97%" nowrap height="24">
						&nbsp;<b><egui:intnl text="configmgmt.inventory.system.DISTRIBUTION OF MANAGED SYSTEMS" />&nbsp;<egui:intnl text="configmgmt.inventory.system.BY" />&nbsp;<egui:intnl text="configmgmt.inventory.system.MANUFACTURER" /></b>
					</td>
					<td>
<%
	if (request_from != null && request_from.equalsIgnoreCase("saveSchedule"))
	{
%>
						<a id='mousehand' onClick="goBackToSaveSchedule();">
							<img src="/final/config/images/back-arrow.gif" />&nbsp;<b><egui:intnl text="configmgmt.common.Back"/></b>&nbsp;&nbsp;
						</a>
<%
	}
%>
					</td>
				</tr>
			</table>
		</td>
	</tr>

	<tr>
		<td valign="top" id="bgmedium" width="100%" height="100%">
			<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" height="100%">
			<!-- new tab start here -->
				<tr>
					<td id="padding6" style="padding-bottom:0px">
						<table align="center" cellspacing="0" cellpadding="4" width="100%" border="0" id="toptable" style="table-layout:fixed">
							<col width="55"><col width="10"><col width="170">
							<col width="150"><col width="10"><col width="350">
							<tr>
								<td align="right" nowrap><b><egui:intnl text="configmgmt.common.View By" /></b></td>
								<td align="center"><b>:</b></td>
								<td valign="middle">
									<select name="ec_criteria" style="width:170px;" onChange='javascript:getInformations()'>
<%
	if (vecCriterias != null && !vecCriterias.isEmpty())
	{
		for(int i=0; i<vecCriterias.size(); i++)
		{
			String selected = "";
			String strCriteria = (String)vecCriterias.get(i);
			if(ec_criteria != null && strCriteria.equals(ec_criteria))
			{
				selected = "selected";
			}
%>
			<option value="<%=strCriteria%>" <%=selected%>>
				<egui:intnl text='<%="configmgmt.common."+strCriteria%>' />
			</option>
<%
		}
	}
	else
	{
%>
		<option value="-1">
			<egui:intnl text="configmgmt.common.Not Applicable" />
		</option>
<%
	}
%>
									</select>
								</td>
<%
	if (ec_criteria != null && !ec_criteria.equalsIgnoreCase(criterias[3]) && !ec_criteria.equals("-1"))
	{
%>
					<td align="right" nowrap>
<%
		if (ec_criteria.equalsIgnoreCase(criterias[0]))
		{
%>
			<b><egui:intnl text='<%="configmgmt.common."+criterias[0]%>' /></b>
<%
		}
		else if (ec_criteria.equalsIgnoreCase(criterias[1]))
		{
%>
			<b><egui:intnl text='<%="configmgmt.common."+criterias[1]%>' /></b>
<%
		}
		else
		{
%>
			<b><egui:intnl text='<%="configmgmt.common."+criterias[2]%>' /></b>
<%
		}
%>
								</td>
								<td align="center"><b>:</b></td>
								<td>
									<select name="ec_userOption" style="width: 250px;" onChange='javascript:getInformations()'>
<%
		if (vecUserOptions != null && !vecUserOptions.isEmpty())
		{
			for(int i=0; i<vecUserOptions.size(); i++)
			{
				String selected = "";
				String strUserOption = (String)vecUserOptions.get(i);
				if(ec_userOption != null && strUserOption.equals(ec_userOption))
				{
					selected = "selected";
				}
%>
				<option value="<%=strUserOption%>" <%=selected%>>
					<%=strUserOption%>
				</option>
<%
			}
		}
		else
		{
%>
			<option value="-1">
				<egui:intnl text="configmgmt.common.Not Applicable" />
			</option>
<%
		}
%>
									</select>
								</td>
<%
	}
	else
	{
%>
								<td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td>
<%
	}
%>
							</tr>
						</table>
					</td>
				</tr>
				<!-- new tab end here -->

				<tr>
					<td id="padding6">
						<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" id="toptable">
							<tr>
								<td>
									<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" style="table-layout:fixed" id="text_bold"><col width="250"><col width="190"><col width="10"><col width="160"><col width="250">
										<tr>
											<td colspan="5" height="5" id="blank">&nbsp; </td>
										</tr>
										<tr height="20"> 
											<td  align="center">&nbsp;</td>
											<td align="right"><egui:intnl text="configmgmt.inventory.system.System Manufacturer" /></td>
											<td align="center">:</td>
											<td>
												<select name="manufacturer">
<%//=ecUtils.fillSelectBox(vecManufacturers,"",manufacturer)%>
<%
	if (vecManufacturers != null && !vecManufacturers.isEmpty())
	{
		for(int i=0; i<vecManufacturers.size(); i++)
		{
			String selected = "";
			String strManufacturer = (String)vecManufacturers.get(i);
			if(strManufacturer != null && strManufacturer.equals(manufacturer))
			{
				selected = "selected";
			}
%>
													<option value="<%=strManufacturer%>" <%=selected%>>
<%
			if (strManufacturer.equalsIgnoreCase("All"))
			{
%>
											<egui:intnl text="configmgmt.inventory.system.All" />
<%
			}
			else
			{
%>
														<%=strManufacturer%>
<%
			}
%>
													</option>
<%
		}
	}
	else
	{
%>
													<option value="-1">
														<egui:intnl text="configmgmt.inventory.system.Not Applicable" />
													</option>
<%
	}
%>
												</select>
											</td>
											<td align="center">&nbsp;</td>
										</tr>
										<tr>
											<td colspan="5" height="5" id="blank">&nbsp;</td>
										</tr>
										<tr>
<%
	if (request_from != null && request_from.equalsIgnoreCase("saveSchedule"))
	{
%>
											<td align="center">&nbsp;</td>
											<td align="center" colspan="3" valign="middle" height="20">
											<input type="button" name="btnsubmit" value='<egui:intnl text="configmgmt.common.SAVE" />' id="darkbutton" style="width: 75px; height: 20px;" href="" onClick="schedule('schedule');">
											</td>
<%
	}
	else
	{
%>
											<td  align="center">&nbsp;</td>
											<td align="center" colspan="3" valign="middle" height="20"> 
											<input type="button" name="secsubmt" value='<egui:intnl text="configmgmt.common.SUBMIT" />' id="darkbutton" style="width: 75px; height:20px;" onClick="javascript:get()"></td>
<%
	}
%>
											<td align="right"  colspan="1" rowspan="2" style="height:24" valign="bottom">
												<table align="right" cellspacing="0" cellpadding="0" border="0" height="20"> 
													<tr>
														<td width="50" align="center" id="leftcurve" ><img src="/final/config/images/spacer.gif" width="50px" height="20px"> </td>

														<td width="2" align="center"  id="leftcurvebg"><img src="/final/config/images/spacer.gif"  width="2" > </td>

														<td align="center"  id="leftcurvebg" > <img class="mouse" src="../config/images/print.gif" border="0" title='<egui:intnl text="configmgmt.common.PRINT" />' onClick="javascript:printData()"> </td>

														<td width="13" align="center"  id="leftcurvebg"><img src="/final/config/images/spacer.gif" width="13" > </td>

														<td width="13" align="center"  id="leftcurvebg" ><img class="mouse" src= "../config/images/pdf.gif" border="0" title='<egui:intnl text="configmgmt.common.PDF" />' onClick="javascript:savePdf();"> </td>

														<td width="13" align="center"  id="leftcurvebg"><img src="/final/config/images/spacer.gif"  width="13"> </td>

														<td width="13" align="center"  id="leftcurvebg" ><img class="mouse" src="../config/images/mail.gif" border="0" title='<egui:intnl text="configmgmt.common.MAIL" />' onClick="javascript:mail()"> </td>

														<td width="13" align="center"  id="leftcurvebg"><img src="/final/config/images/spacer.gif"  width="13"> </td>

														<td width="13" align="center" id="leftcurvebg"><img class="mouse" src="../config/images/csv.gif" border="0" title='<egui:intnl text="configmgmt.common.CSV" />' onClick="javascript:csv()"> </td>

														<td width="13" align="center"  id="leftcurvebg"><img src="/final/config/images/spacer.gif"  width="13"> </td>

														<td align="center" id="leftcurvebg"><img class="mouse" src="../config/images/schedules.gif" border="0" title='<egui:intnl text="configmgmt.common.ADD TO SCHEDULES" />' onClick="javascript:schedule('schedule')"> </td>

														<td width="13" align="center"  id="leftcurvebg"> <img src="/final/config/images/spacer.gif"  width="13"> </td>

													</tr>
												</table>
											</td>
										</tr>
										<tr>
											<td colspan="4" height="5" id="blank">&nbsp;</td>
										</tr>
									</table>
								</td>
							</tr>
						</table>
					</td>
				</tr>

				<tr>
					<td id="padding6" height="100%" width="100%" valign="top" style="padding-top:0px">
						<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" height="100%" id="bottomtable">
							<tr>
								<td  height="5" id="blank">&nbsp;</td>
							</tr>
							<tr>
								<td align="center" valign="top">
								<!-- <div id="div_scroll" style="width:100%;height:475px;border:0px solid #000000"> -->
									<table border="0" align="center" width="100%" class="body_text" cellspacing="0" cellpadding="0">
										<tr>
											<td align="center" valign="top">
<%
	if (tmapSystemDetails != null && submitOrNot.equals("true") && isDisplay)
	{
		StringBuffer strBuffer1 = new StringBuffer();
		StringBuffer strBuffer2 = new StringBuffer();
		String titleName = "";
		String systemmf = "";
		String systemcount = "";
		String barColors = "";
		StringBuffer strBufferColor = new StringBuffer();
		String yAxisMaxValue = " ";
		ArrayList aListCount = new ArrayList();

		//For New Pdf Framework - Krishnamurthi
		ArrayList aListPdfData = new ArrayList();
		EgPdfData pdfData = new EgPdfData();

		EgReportAttributes reportAttributes = new EgReportAttributes();

		String pdfTitle = "";
		if (ec_criteria != null && !ec_criteria.equalsIgnoreCase(criterias[3]) && !ec_criteria.equals("-1"))
		{
			pdfTitle = mappingInfo.getTextDescription("configmgmt.inventory.view.DISTRIBUTION REPORT OF MANAGED SYSTEMS BY MANUFACTURER") + " IN" + " '" + ec_userOption + "' "  +  ec_criteria + "  " + mappingInfo.getTextDescription("configmgmt.configuration.as on") + "  " + dateString;
		}
		else
		{
			pdfTitle = mappingInfo.getTextDescription("configmgmt.inventory.view.DISTRIBUTION REPORT OF MANAGED SYSTEMS BY MANUFACTURER") + "  " + mappingInfo.getTextDescription("configmgmt.configuration.as on") + "  " + dateString;
		}
		reportAttributes.setMainTitle(pdfTitle);

		reportAttributes.setReportName("SystemsByManufacturer");
		reportAttributes.setModule("CONFIG");
		reportAttributes.setPortrait(true);

		if (manufacturer.equalsIgnoreCase("All") && flag)
		{
			int maxCount = 0;
			Iterator manufacturer_keys = tmapSystemDetails.keySet().iterator();
			while (manufacturer_keys.hasNext())
			{
				String key_manufacturer = (String)manufacturer_keys.next();
				strBuffer1.append(key_manufacturer+",");
			
				int count = 0;
				TreeMap tmapModels = (TreeMap)tmapSystemDetails.get(key_manufacturer);
				Iterator model_keys = tmapModels.keySet().iterator();
				while (model_keys.hasNext())
				{
					String key_model = (String)model_keys.next();
					ArrayList aList = (ArrayList)tmapModels.get(key_model);
					count = count + aList.size();
					if (!aListCount.contains(new Integer(count)))
					{
						aListCount.add(new Integer(count));
					}
					strBufferColor.append(barColor+",");
				}

				maxCount = Math.max(maxCount,count);
				strBuffer2.append(count+",");
			}

			systemmf = strBuffer1.substring(0,strBuffer1.length()-1);
			systemcount = strBuffer2.substring(0,strBuffer2.length()-1);
			barColors = strBufferColor.substring(0,strBufferColor.length()-1);
			boolean flagEqualsOne = true;
			for (int i=1; i<aListCount.size(); i++)
			{
				Integer count_Value = (Integer)aListCount.get(i);
				if (count_Value.intValue() > 1)
				{
					flagEqualsOne = false;
					break;
				}
			}
			if (flagEqualsOne)
			{
				yAxisMaxValue = "5";
			}
			else
			{
				yAxisMaxValue = "0";
			}

			//Fusion Bar Chart Data starts--Rekha
			HashMap mapChartAttributes = new HashMap();//map for chart attributes
			mapChartAttributes.put("bgcolor","FFFFFF");
			mapChartAttributes.put("yAxisName","Number of systems");
			mapChartAttributes.put("showToolTip","1");
			mapChartAttributes.put("showValues","1");
			mapChartAttributes.put("showBorder","0");
			mapChartAttributes.put("showShadow","0");
			mapChartAttributes.put("alpha","0");
			mapChartAttributes.put("canvasBgColor","F2F2F2");
			mapChartAttributes.put("canvasBgAlpha","60");
			mapChartAttributes.put("canvasBorderColor","000000");
			mapChartAttributes.put("canvasBorderThickness","1");
			mapChartAttributes.put("canvasBorderAlpha","30");
			mapChartAttributes.put("yAxisMaxValue",yAxisMaxValue);
			mapChartAttributes.put("maxBarHeight","40");

			HashMap mapChartData = new HashMap();//map for chart data
			mapChartData.put("barLabels",systemmf);
			mapChartData.put("barValues",systemcount);
			mapChartData.put("barColors",barColors);

			HashMap mapProperties = new HashMap();//map for misc properties
			mapProperties.put("showColors","true");
			mapProperties.put("enableLinks","false");

			EcFusionChartBean chartbean = new EcFusionChartBean();
			String xmlString = chartbean.getXMLDataForStackedBarChart(mapChartAttributes,mapChartData,mapProperties);
			//Fusion Bar Chart Data ends

			titleName =mappingInfo.getTextDescription("configmgmt.inventory.system.Distribution of Systems By Manufacturer");

			EgTableAttributes egTableAttributes = new EgTableAttributes();
			egTableAttributes.setImageData(true);

			ArrayList aListColumnNames = new ArrayList();
			ArrayList aListData = new ArrayList();

			aListColumnNames.add("C0");

			aListData.add(request.getScheme()+"://"+request.getServerName()+":"+request.getServerPort()+"/final/servlet/com.eg.EcChartController?view=GRAPH&pageName=SERVICE_PACK_DISTRIBUTION&chartType=bar&height=260&width=550&chartTitle="+EgURLEncoder.encode(titleName,"UTF-8")+"&sampleValues="+URLEncoder.encode(systemcount)+"&barLabels="+URLEncoder.encode(systemmf)+"&range="+maxCount+"&barAlignment=horizontal&rangeAxisLabelAngle=270&userName="+EgURLEncoder.encode(userName,"UTF-8"));

			EgTableModel egTableModel = new EgTableModel(aListData,aListColumnNames);

			EgTable egTable = new EgTable();
			egTable.setModel(egTableModel);
			egTable.setAttributes(egTableAttributes);

			aListPdfData.add(egTable);

			reportAttributes.setSubTitle(mappingInfo.getTextDescription("configmgmt.inventory.system.All Manufacturers"));
%>
												<table border="0" width="100%" cellspacing="0" cellpadding="0" class="body_text">
<%
			boolean chartFlag = false;
			if (chartDataRepresentation != null && chartDataRepresentation.equalsIgnoreCase("3D"))
			{
				chartFlag = true;
			}
			if (chartFlag)
			{
%>
													<tr>
														<td align="center" width="100%"><b><%=titleName%></b></td>
													</tr>
													<tr>
														<td align="center" width="100%" bgcolor="white" nowrap>
															<!-- <object classid="clsid:d27cdb6e-ae6d-11cf-96b8-444553540000" codebase="//fpdownload.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=8,0,0,0" width="90%" height="280" id="StackedBar3D">
																<param name="movie" value="/final/FusionCharts/swf/StackedBar3D.swf" />
																<param name="FlashVars" value="&dataXML=<%=xmlString%>&chartWidth=650&chartHeight=280" />
																<param name="quality" value="high" />
																<param name="wmode" value="transparent" />
																<embed src="/final/FusionCharts/swf/StackedBar3D.swf" flashVars="&dataXML=<%=xmlString%>&chartWidth=650&chartHeight=280" quality="high" width="90%" height="280" name="StackedBar3D" wmode="transparent" type="application/x-shockwave-flash" pluginspage="//www.macromedia.com/go/getflashplayer" />
															</object> -->
															<div id="chartStackedBarSystem3DContainer"  style="height:100%;"></div>
															<script type="text/javascript">
																if  ( FusionCharts( "myStackedBarSystem3DChartId" ) )
																		FusionCharts( "myStackedBarSystem3DChartId" ).dispose();
																var myChart = new FusionCharts( "/final/FusionCharts/swf/StackedBar3D.swf","myStackedBarSystem3DChartId", "650", "280","0","1");
																myChart.setXMLData("<%=xmlString%>");
																myChart.setTransparent(true);
																myChart.render("chartStackedBarSystem3DContainer");
															</script>
														</td>
													</tr>
<%
			}
			else
			{
%>
													<tr>
														<td align="center" width="100%"><b><%=titleName%></b></td>
													</tr>
													<tr>
														<td align="center" width="100%" bgcolor="white" nowrap>
															<!-- <object classid="clsid:d27cdb6e-ae6d-11cf-96b8-444553540000" codebase="//fpdownload.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=8,0,0,0" width="90%" height="280" id="StackedBar2D">
																<param name="movie" value="/final/FusionCharts/swf/StackedBar2D.swf" />
																<param name="FlashVars" value="&dataXML=<%=xmlString%>&chartWidth=650&chartHeight=280" />
																<param name="quality" value="high" />
																<param name="wmode" value="transparent" />
																<embed src="/final/FusionCharts/swf/StackedBar2D.swf" flashVars="&dataXML=<%=xmlString%>&chartWidth=650&chartHeight=280" quality="high" width="90%" height="280" name="StackedBar2D" wmode="transparent" type="application/x-shockwave-flash" pluginspage="//www.macromedia.com/go/getflashplayer" />
															</object> -->
															<div id="chartStackedBarSystem2DContainer"  style="height:100%;"></div>
															<script type="text/javascript">
																if  ( FusionCharts( "myStackedBarSystem2DChartId" ) )
																		FusionCharts( "myStackedBarSystem2DChartId" ).dispose();
																var myChart = new FusionCharts( "/final/FusionCharts/swf/StackedBar2D.swf","myStackedBarSystem2DChartId", "650", "280","0","1");
																myChart.setXMLData("<%=xmlString%>");
																myChart.setTransparent(true);
																myChart.render("chartStackedBarSystem2DContainer");
															</script>
														</td>
													</tr>
<%
			}
%>
												</table>

												<table border="0" cellspacing="0" cellpadding="0" width="100%">
													<tr>
														<td  height="5" id="blank">&nbsp;</td>
													</tr>
												</table>
<%
			manufacturer_keys = tmapSystemDetails.keySet().iterator();
			while (manufacturer_keys.hasNext())
			{
				String key_manufacturer = (String)manufacturer_keys.next();
				ArrayList aListComponents = new ArrayList();
				TreeMap tmapModels = (TreeMap)tmapSystemDetails.get(key_manufacturer);
				Iterator model_keys = tmapModels.keySet().iterator();
				while (model_keys.hasNext())
				{
					String key_model = (String)model_keys.next();
					ArrayList aList = (ArrayList)tmapModels.get(key_model);
					aListComponents.addAll(aList);
				}

				egTableAttributes = new EgTableAttributes();
				egTableAttributes.setTitle(key_manufacturer+" ("+mappingInfo.getTextDescription("configmgmt.inventory.system.Count")+" : "+aListComponents.size()+")");

				aListColumnNames = new ArrayList();
				aListData = new ArrayList();
				ArrayList userColumnNames = new ArrayList();

				for (int x=0; x<4; x++)
					aListColumnNames.add("System"+x);

				userColumnNames.add(mappingInfo.getTextDescription("configmgmt.inventory.system.Systems"));
				userColumnNames.add("");
				userColumnNames.add("");
				userColumnNames.add("");
%>
						<table width="99%" border="0" cellpadding="0" cellspacing="0" class="body_text" id="bottomtable" valign="top">
							<tr>
								<td height="20" id="bgdarkimg" >
									<b><%=key_manufacturer%>&nbsp;&nbsp;(<egui:intnl text="configmgmt.inventory.system.Count" /> : <%=aListComponents.size()%>)</b>
								</td>
							</tr>
							<tr>
								<td align="left" width="100%">
									<table border="0" width="100%" cellspacing="0" cellpadding="0" class="body_text">
<%
				for (int d=0; d<aListComponents.size(); d=d+4)
				{
%>
										<tr>
<%
					for (int e=d; e<d+4; e++)
					{
						if (e<aListComponents.size())
						{
							String system = (String)aListComponents.get(e);
							aListData.add(system);
%>
											<td id="cell_bg1" width="20%">
							<a href="/final/servlet/com.eg.EcConfigurationServlet?cmd=BoxView&systemName=<%=EgURLEncoder.encode(system,"UTF-8")%>&request_from=HomePage&ec_criteria=<%=ec_criteria%>&ec_userOption=<%=((ec_userOption != null)?EgURLEncoder.encode(ec_userOption,"UTF-8"):"")%>" target="_self" class="eg_monlink"><%=system%></a>
											</td>
<%
						}
						else
						{
							aListData.add(" ");
%>
											<td id="cell_bg1" width="20%">
												&nbsp;
											</td>
<%
						}
					}
%>
										</tr>
<%
				}

				egTableModel = new EgTableModel(aListData,aListColumnNames);
				egTableAttributes.setColumnNames(userColumnNames);

				egTable = new EgTable();
				egTable.setModel(egTableModel);
				egTable.setAttributes(egTableAttributes);

				aListPdfData.add(egTable);
%>
									</table>
								</td>
							</tr>
						</table>

						<table border="0" cellspacing="0" cellpadding="0" width="100%">
							<tr>
								<td  height="5" id="blank">&nbsp;</td>
							</tr>
						</table>
<%
			}
		}
		else
		{
			EgTableAttributes egTableAttributes = new EgTableAttributes();
			egTableAttributes.setTitle(manufacturer);

			ArrayList aListColumnNames = new ArrayList();
			ArrayList aListData = new ArrayList();
			ArrayList userColumnNames = new ArrayList();

			aListColumnNames.add("C0");
			aListColumnNames.add("C1");
			aListColumnNames.add("C2");
			aListColumnNames.add("C3");
			aListColumnNames.add("C4");

			userColumnNames.add("");
			userColumnNames.add(mappingInfo.getTextDescription("configmgmt.inventory.system.Systems"));
			userColumnNames.add("");
			userColumnNames.add("");
			userColumnNames.add("");
%>
						<table border="0" width="99%" cellspacing="0" cellpadding="0" id="bottomtable" class="body_text" valign="top">
							<tr>
								<td height="20" id="bgdarkimg">
									<b><%=manufacturer%></b>
								</td>
							</tr>
<%
			Iterator model_keys = tmapSystemDetails.keySet().iterator();
			int j=0;
			while (model_keys.hasNext())
			{
				j++;
				String key_model = (String)model_keys.next();
				ArrayList aList = (ArrayList)tmapSystemDetails.get(key_model);
%>
							<tr>
								<td align="left" width="50%" id="cell_bg">
									<b><egui:intnl text="configmgmt.inventory.system.Model" /> : <%=key_model%>&nbsp;&nbsp;(<egui:intnl text="configmgmt.inventory.system.Count" /> : <%=aList.size()%>)</b>
								</td>
							</tr>

							<tr>
								<td align="left" width="100%" valign="top">
									<table border="0" width="100%" cellspacing="0" cellpadding="0" class="body_text">
<%
				for (int d=0; d<aList.size(); d=d+4)
				{
					aListData.add(mappingInfo.getTextDescription("configmgmt.inventory.system.Model")+" : "+key_model+"  ("+mappingInfo.getTextDescription("configmgmt.inventory.system.Count")+" : "+aList.size()+")");
%>
										<tr>
<%
					for (int e=d; e<d+4; e++)
					{
						if (e<aList.size())
						{
							String system = (String)aList.get(e);
							aListData.add(system);
%>
											<td id="cell_bg1" width="20%">
							<a href="/final/servlet/com.eg.EcConfigurationServlet?cmd=BoxView&systemName=<%=EgURLEncoder.encode(system,"UTF-8")%>&request_from=HomePage&ec_criteria=<%=ec_criteria%>&ec_userOption=<%=((ec_userOption != null)?EgURLEncoder.encode(ec_userOption,"UTF-8"):"")%>" target="_self" class="eg_monlink"><%=system%></a>
											</td>
<%
						}
						else
						{
							aListData.add(" ");
%>
											<td id="cell_bg1" width="20%">
												&nbsp;
											</td>
<%
						}
					}
%>
										</tr>
<%
				}
%>
									</table>
								</td>
							</tr>

<%
				if(j < tmapSystemDetails.size())
				{
%>
							<tr>
								<td>
									<table border="0" cellspacing="0" cellpadding="0" width="100%">
										<tr>
											<td height="0">
												<img src="/final/config/images/spacer.gif" border="0" height="5">
											</td>
										</tr>
									</table>
								</td>
							</tr>
<%
				}
			}

			EgTableModel egTableModel = new EgTableModel(aListData,aListColumnNames);
			egTableAttributes.setColumnNames(userColumnNames);
			egTableAttributes.setDataGrouping(true);
			egTableAttributes.setDataGroupingField(0);

			EgTable egTable = new EgTable();
			egTable.setModel(egTableModel);
			egTable.setAttributes(egTableAttributes);

			aListPdfData.add(egTable);
			reportAttributes.setSubTitle(mappingInfo.getTextDescription("configmgmt.inventory.system.Manufacturer")+" : "+manufacturer);
%>
						</table>
<%
		}

		//For new pdf framework
		pdfData.setAttributes(reportAttributes);
		pdfData.setData(aListPdfData);
		session.setAttribute("pdfData",pdfData);
	}
%>
					</td>
				</tr>
			</table>
			<!-- </div> -->
		</td>
	<tr>
</table>
</form>
</body>
</html>



