<%@ include file = "../../EcTrackerJson.jsp" %>
<%@ page import = "net.sf.json.*"%>
<%@ page import = "egurkha.config.EcUtils"%>
<%@ page import = "java.util.*"%>
<%@ page import = "java.net.URLEncoder"%>
<%@ page import = "com.egurkha.pdfmaker.*"%>
<%@ page import = "com.eg.EgMappingInfo"%>
<%@ page import="com.egurkha.User" %>
<%@ page import="com.egurkha.UserRegistry" %>
<%@ page import="com.egurkha.ini.IniUI"%>
<%@ page import = "com.eg.EgURLEncoder"%>
<%@ page import = "egurkha.config.EcFusionChartBean" %>
<%@ page import = "egurkha.config.ConfigDbSetting" %>
<%@ page import = "com.eg.EgConfigConstants"%>
<%@ page import = "com.eg.EgConfigTestsInfo"%>
<%@ page import = "com.eg.EgConfigInfo"%>
<%@ page import = "java.text.*"%>
<%@ page import = "com.egurkha.EgTimeZoneConverter"%>
<%@ page import = "com.egurkha.util.DateUtil"%>
<%@ page import = "com.eg.EgInstallInfo" %>
<%@ page import = "egurkha.EgUIUtils" %>

<%@ page language="java" contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" %>

<%!
	String[] criterias = {"Zone","Service","Segment","Component"};

	private String prepareQueryString(Map params)
	{
		if (params == null || params.size() == 0) return "";
		String queryStr = "";
		Iterator itr = params.keySet().iterator();
		while (itr.hasNext())
		{
			String key = (String)itr.next();
			if (key.trim().length() == 0) continue;
			Object value= params.get(key);

			if (value instanceof String[])
			{
				String val[] =(String[])value;
				for(int i=0;i<val.length;i++)
				{
					if (key.equals("processorFamily") || key.equals("family") || key.equals("details"))
					{
						queryStr += key + "=" + URLEncoder.encode(EgUIUtils.encodeSecurityChar(val[i])) + "&";
					}
					else
					{
						queryStr += key + "=" + val[i] + "&";
					}
				}
			}
			else
			{
				if (value == null) value = "";
				if (key.equals("processorFamily") || key.equals("family") || key.equals("details"))
				{
					queryStr += key + "=" + URLEncoder.encode(EgUIUtils.encodeSecurityChar((String)value)) + "&";
				}
				else
				{
					queryStr += key + "=" + (String)value + "&";
				}
			}
		}
		if (queryStr.length() > 0) queryStr = queryStr.substring(0,queryStr.length()-1);
		return queryStr;
	}
%>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
%>

<%
	String queryString = prepareQueryString(request.getParameterMap());
	JSONObject rootJson = new JSONObject();
	JSONObject hiddenFields = new JSONObject();
	JSONObject chartData = new JSONObject();
	JSONArray systemInfoArray = new JSONArray();

	JSONObject tmpObject = new JSONObject();
	rootJson.put("success","true");
	
	//language support
	UserRegistry registry = UserRegistry.getInstance();
	User user = registry.getUser(session.getId());
	IniUI iniUI = IniUI.getInstance();

	//user language
	String userLanguage = iniUI.getDefaultLanguage();
	if (user != null)
	{
		userLanguage = user.getLanguage();
	}
	EgMappingInfo mappingInfo = new EgMappingInfo(userLanguage);

	String configSkin = user.getConfigSkin();
	String userName = (String)session.getAttribute("sess_auserid");
	EcUtils ecUtils = new EcUtils();
	String processorFamily = request.getParameter("processorFamily");
	Vector vecProcessorFamily = (Vector)request.getAttribute("ProcessorFamilies");
	TreeMap tmapSystemDetails = (TreeMap)request.getAttribute("SystemDetails");
	String id = request.getParameter("id");
	String request_from = request.getParameter("request_from");

	EgConfigTestsInfo configTestsInfo = new EgConfigTestsInfo("manager");
	Map dashboardSetting = (Hashtable)ConfigDbSetting.getDbSettingData(user.getLoginID(),EgConfigConstants.USER_COMMON_SETTING);
	String barColor = configTestsInfo.getServerDisplayValue("MISC_ARGS","StackedBarChartColors");

	ArrayList colorsAList = new ArrayList();
	StringTokenizer barColorTkns = new StringTokenizer(barColor,",");
	int maxChartColor = barColorTkns.countTokens();
	while(barColorTkns.hasMoreTokens())
	{
		colorsAList.add(barColorTkns.nextToken());
	}
	String chartColorTemp = (String)colorsAList.get(0);
	String pfChartColor = chartColorTemp.substring(1,chartColorTemp.length());


	String uiFile = "eg_ui.ini";
	String s_iniFile_dir = EgInstallInfo.getInstallDir()+ "/manager/config/";
	IniFile iniFile = new IniFile(s_iniFile_dir + uiFile);
	String currentDateFormat = iniFile.getValue("CURRENT_DATE_FORMAT","selectedDateFormat");

	String userDateFormat = user.getUserDateFormat();
	if (userDateFormat != null && userDateFormat.equalsIgnoreCase("Default"))
	{
		userDateFormat = currentDateFormat;
	}

	// If user date format is set, assign it to current date format.
	if (userDateFormat != null)
	{
		currentDateFormat = userDateFormat;
	}

	SimpleDateFormat formatter = new SimpleDateFormat(currentDateFormat+" "+"HH:mm:ss");
	Date currentDateTime = new Date();
	String dateString = formatter.format(currentDateTime);

	/* Added by Prakash.K Starts */
	EgTimeZoneConverter timeZoneConverter = new EgTimeZoneConverter(dateString,user);
	dateString = timeZoneConverter.getDateTime();
	/* Added by Prakash.K Ends */

	String ec_criteria = (String)session.getAttribute("ec_criteria");
	String ec_criteriaPrevious = request.getParameter("ec_criteriaPrevious");

	Vector vecCriterias = new Vector();
	for (int g=0;g<criterias.length;g++)
	{
		String criteria = criterias[g];
		vecCriterias.add(criteria);
	}

	Vector vecUserOptions = (Vector)session.getAttribute("vecUserOptions");
	String ec_userOption = (String)session.getAttribute("ec_userOption");
	String ec_userOptionPrevious = request.getParameter("ec_userOptionPrevious");

	boolean flag = false;
	if (vecProcessorFamily != null && vecProcessorFamily.size() > 0)
	{
		flag = vecProcessorFamily.contains("All");
		if (!flag)
			processorFamily = (String)vecProcessorFamily.get(0);
	}

	if (tmapSystemDetails != null)
	{
		session.setAttribute("ProcessorSystemDetails",tmapSystemDetails);
		session.setAttribute("processorFamily",processorFamily);
		session.setAttribute("pfChartColor",pfChartColor);
	}
	String submitOrNot = (String) request.getAttribute("isSubmit");
	Map scheduleDetails = (Map)request.getAttribute("ScheduleDetails");

	if (scheduleDetails != null && request_from != null && request_from.equalsIgnoreCase("saveSchedule"))
	{
		vecUserOptions = (Vector) scheduleDetails.get("vecUserOptions");
		ec_userOption = (String) scheduleDetails.get("ec_userOption");
		ec_userOptionPrevious = (String) scheduleDetails.get("ec_userOptionPrevious");
		processorFamily = (String) scheduleDetails.get("family");
		submitOrNot = "false";
	}

	processorFamily = EgUIUtils.decodeSecurityChar(processorFamily).trim();

	boolean isDisplay = true;
	if (scheduleDetails != null && request_from != null && request_from.equalsIgnoreCase("saveSchedule"))
	{
		ec_criteria = (String)scheduleDetails.get("ec_criteria");
		ec_criteriaPrevious = (String)scheduleDetails.get("ec_criteriaPrevious");
	}

	if (submitOrNot == null || "null".equals(submitOrNot))
	{
		submitOrNot = "true";
		isDisplay = true;
	}

	if (request_from != null && request_from.equalsIgnoreCase("saveSchedule"))
	{
		isDisplay = false;
	}

	String strBackRequest = request.getParameter("back_request");
	if (strBackRequest != null && strBackRequest.equalsIgnoreCase("ScheduleConfig"))
	{
		processorFamily = (String) request.getAttribute("processorFamily");
	}

	String mngrIProc = new IniFile(new EgConfigInfo("manager").getDbFile()).getValue("DB_PROPERTIES","ManagerUrl");

	
	hiddenFields.put("ec_rtype","Processor");
	hiddenFields.put("isSubmit","true");
	hiddenFields.put("ec_criteriaPrevious",ec_criteria);
	if(ec_userOption == null)
	{
		hiddenFields.put("ec_userOptionPrevious","");
	}
	else
	{
		hiddenFields.put("ec_userOptionPrevious",ec_userOption);
	}

	JSONObject backOperation = new JSONObject();
	if (request_from != null && request_from.equalsIgnoreCase("saveSchedule"))
	{
		backOperation.put("schedule",new Boolean(true));
	}
	rootJson.put("backOperation",backOperation);


	JSONObject viewByObj = new JSONObject();
	JSONArray viewByArr = new JSONArray();
	
	if (vecCriterias != null && !vecCriterias.isEmpty())
	{
		for(int i=0; i<vecCriterias.size(); i++)
		{
			String selected = "";
			String strCriteria = (String)vecCriterias.get(i);
			if(ec_criteria != null && strCriteria.equals(ec_criteria))
			{
				rootJson.put("selectedEcOpt",ec_criteria);
			}
			viewByObj.put("displayField",_mapping.getTextDescription("configmgmt.common."+strCriteria));
			viewByObj.put("valueField",strCriteria);
			viewByArr.add(viewByObj);
		}
	}
	else
	{
		rootJson.put("selectedEcOpt","-1");
		viewByObj.put("displayField",_mapping.getTextDescription("configmgmt.common.Not Applicable"));
		viewByObj.put("valueField","-1");
		viewByArr.add(viewByObj);
	}
	rootJson.put("viewByList",viewByArr);

	if (ec_criteria != null && !ec_criteria.equalsIgnoreCase(criterias[3]) && !ec_criteria.equals("-1"))
	{
		if (ec_criteria.equalsIgnoreCase(criterias[0]))
		{
			rootJson.put("specViewByTitle",_mapping.getTextDescription("configmgmt.common."+criterias[0]));
		}
		else if (ec_criteria.equalsIgnoreCase(criterias[1]))
		{
			rootJson.put("specViewByTitle",_mapping.getTextDescription("configmgmt.common."+criterias[1]));
		}
		else
		{
			rootJson.put("specViewByTitle",_mapping.getTextDescription("configmgmt.common."+criterias[2]));
		}

		JSONObject specviewByObj = new JSONObject();
		JSONArray specviewByArr = new JSONArray();

		if (vecUserOptions != null && !vecUserOptions.isEmpty())
		{
			for(int i=0; i<vecUserOptions.size(); i++)
			{
				String selected = "";
				String strUserOption = (String)vecUserOptions.get(i);
				if(ec_userOption != null && strUserOption.equals(ec_userOption))
				{
					rootJson.put("selectedUserOption",ec_userOption);
				}
				specviewByObj.put("displayField",strUserOption);
				specviewByObj.put("valueField",strUserOption);
				specviewByArr.add(specviewByObj);
			}
		}
		else
		{
			rootJson.put("selectedUserOption","-1");
			specviewByObj.put("displayField",_mapping.getTextDescription("configmgmt.inventory.system.Not Applicable"));
			specviewByObj.put("valueField","-1");
			specviewByArr.add(specviewByObj);
		}
		rootJson.put("specViewByList",specviewByArr);
	}
	else
	{
	}

	JSONObject processorObj = new JSONObject();
	JSONArray processorArr = new JSONArray();

	if (vecProcessorFamily != null && !vecProcessorFamily.isEmpty())
	{
		for(int i=0; i<vecProcessorFamily.size(); i++)
		{
			String selected = "";
			String strProcessorFamily = (String)vecProcessorFamily.get(i);
			if(strProcessorFamily != null && strProcessorFamily.equals(processorFamily))
			{
				rootJson.put("selectedProcessor",strProcessorFamily);
			}
			if (strProcessorFamily.equalsIgnoreCase("All"))
			{
				rootJson.put("selectedProcessor",strProcessorFamily);
				processorObj.put("displayField",_mapping.getTextDescription("configmgmt.inventory.system.All"));
				processorObj.put("valueField","All");
				processorArr.add(processorObj);
			}
			else
			{
				processorObj.put("displayField",strProcessorFamily);
				processorObj.put("valueField",strProcessorFamily);
				processorArr.add(processorObj);
			}
		}
	}
	else
	{
		rootJson.put("selectedProcessor","-1");
		processorObj.put("displayField",_mapping.getTextDescription("configmgmt.inventory.system.Not Applicable"));
		processorObj.put("valueField","-1");
		processorArr.add(processorObj);
	}
	rootJson.put("processorList",processorArr);

	if (request_from != null && request_from.equalsIgnoreCase("saveSchedule"))
	{
	}
	else
	{
	}

	if (tmapSystemDetails != null && submitOrNot.equals("true") && isDisplay)
	{
		rootJson.put("hasConfigDetails",new Boolean(true));
		StringBuffer strBuffer1 = new StringBuffer();
		StringBuffer strBuffer2 = new StringBuffer();
		String titleName = "";
		String family = "";
		String systemcount = "";
		String barColors = "";
		StringBuffer strBufferColor = new StringBuffer();
		String yAxisMaxValue = " ";
		ArrayList aListCount = new ArrayList();

		//For New Pdf Framework - Krishnamurthi
		ArrayList aListPdfData = new ArrayList();
		EgPdfData pdfData = new EgPdfData();
	
		EgReportAttributes reportAttributes = new EgReportAttributes();

		String pdfTitle = "";
		if (ec_criteria != null && !ec_criteria.equalsIgnoreCase(criterias[3]) && !ec_criteria.equals("-1"))
		{
			pdfTitle = mappingInfo.getTextDescription("configmgmt.inventory.view.DISTRIBUTION REPORT OF MANAGED SYSTEMS BY PROCESSOR FAMILY") + " IN" + " '" + ec_userOption + "' "  +  ec_criteria + "  " + mappingInfo.getTextDescription("configmgmt.configuration.as on") + "  " + dateString;
		}
		else
		{
			pdfTitle = mappingInfo.getTextDescription("configmgmt.inventory.view.DISTRIBUTION REPORT OF MANAGED SYSTEMS BY PROCESSOR FAMILY") + "  " + mappingInfo.getTextDescription("configmgmt.configuration.as on") + "  " + dateString;
		}
		reportAttributes.setMainTitle(pdfTitle);

		reportAttributes.setReportName("SystemsByProcessorFamily");
		reportAttributes.setModule("CONFIG");
		reportAttributes.setPortrait(true);

		if (processorFamily.equalsIgnoreCase("All") && flag)
		{
			int maxCount = 0;
			Iterator family_keys = tmapSystemDetails.keySet().iterator();
			while (family_keys.hasNext())
			{
				String key_family = (String)family_keys.next();
				strBuffer1.append(key_family+",");
			
				ArrayList aList = (ArrayList)tmapSystemDetails.get(key_family);
				int count = aList.size()/2;
				if (!aListCount.contains(new Integer(count)))
				{
					aListCount.add(new Integer(count));
				}

				strBufferColor.append(barColor + ",");
				maxCount = Math.max(maxCount,count);
				strBuffer2.append(count+",");
			}

			family = strBuffer1.substring(0,strBuffer1.length()-1);
			systemcount = strBuffer2.substring(0,strBuffer2.length()-1);
			barColors = strBufferColor.substring(0,strBufferColor.length()-1);

			boolean flagEqualsOne = true;
			for (int i=1; i<aListCount.size(); i++)
			{
				Integer count_Value = (Integer)aListCount.get(i);
				if (count_Value.intValue() > 1)
				{
					flagEqualsOne = false;
					break;
				}
			}
			if (flagEqualsOne)
			{
				yAxisMaxValue = "5";
			}
			else
			{
				yAxisMaxValue = "0";
			}

			//Fusion Bar Chart Data starts--Rekha
			HashMap mapChartAttributes = new HashMap();//map for chart attributes
			mapChartAttributes.put("bgcolor","FFFFFF");
			mapChartAttributes.put("yAxisName","Number of systems");
			mapChartAttributes.put("showToolTip","1");
			mapChartAttributes.put("showValues","1");
			mapChartAttributes.put("showBorder","0");
			mapChartAttributes.put("showShadow","0");
			mapChartAttributes.put("alpha","0");
			mapChartAttributes.put("canvasBgColor","F2F2F2");
			mapChartAttributes.put("canvasBgAlpha","60");
			mapChartAttributes.put("canvasBorderColor","000000");
			mapChartAttributes.put("canvasBorderThickness","1");
			mapChartAttributes.put("canvasBorderAlpha","30");
			mapChartAttributes.put("yAxisMaxValue",yAxisMaxValue);
			mapChartAttributes.put("maxBarHeight","40");

			HashMap mapChartData = new HashMap();//map for chart data
			String newBarLabels = "";
			String newBarVals = "";

			StringTokenizer barLabelsTkns = new StringTokenizer(family,",");
			StringTokenizer barValTkns = new StringTokenizer(systemcount,",");
			int barLabelSize = barLabelsTkns.countTokens();

			if(barLabelSize > maxChartColor)
			{
				for(int g = 0; g < maxChartColor; g++)
				{
					String name = barLabelsTkns.nextToken();
					String value = barValTkns.nextToken();
					if(g == maxChartColor - 1)
					{
						newBarLabels += name;
						newBarVals += value;
					}
					else
					{
						newBarLabels += name + ",";
						newBarVals += value + ",";
					}
				}
				mapChartData.put("barLabels",newBarLabels);
				mapChartData.put("barValues",newBarVals);
			}
			else
			{
				mapChartData.put("barLabels",family);
				mapChartData.put("barValues",systemcount);
			}
			mapChartData.put("barColors",barColors);

			HashMap mapProperties = new HashMap();//map for misc properties
			mapProperties.put("showColors","true");
			mapProperties.put("enableLinks","false");

			EcFusionChartBean chartbean = new EcFusionChartBean();
			String xmlString = chartbean.getXMLDataForStackedBarChart(mapChartAttributes,mapChartData,mapProperties);
			//Fusion Bar Chart Data ends

			titleName = mappingInfo.getTextDescription("configmgmt.inventory.system.Distribution of Systems By Processor Family");

			EgTableAttributes egTableAttributes = new EgTableAttributes();
			egTableAttributes.setImageData(true);

			ArrayList aListColumnNames = new ArrayList();
			ArrayList aListData = new ArrayList();

			aListColumnNames.add("C0");
			aListData.add(request.getScheme()+"://"+request.getServerName()+":"+request.getServerPort()+"/final/servlet/com.eg.EcChartController?view=GRAPH&pageName=SERVICE_PACK_DISTRIBUTION&chartType=bar&height=250&width=550&chartTitle="+EgURLEncoder.encode(titleName,"UTF-8")+"&sampleValues="+URLEncoder.encode(systemcount)+"&barLabels="+URLEncoder.encode(family)+"&range="+maxCount+"&barAlignment=horizontal&rangeAxisLabelAngle=270&userName="+EgURLEncoder.encode(userName,"UTF-8"));

			EgTableModel egTableModel = new EgTableModel(aListData,aListColumnNames);

			EgTable egTable = new EgTable();
			egTable.setModel(egTableModel);
			egTable.setAttributes(egTableAttributes);

			aListPdfData.add(egTable);

			reportAttributes.setSubTitle(mappingInfo.getTextDescription("configmgmt.inventory.system.All Processor Family"));

			chartData.put("xmlString",xmlString);
			chartData.put("chartTitle",titleName);
			chartData.put("xAxisLabel",chartbean.getXAxisDataLabel());
			chartData.put("yAxisLabel",(String)chartbean.getYAxisLabel());
			chartData.put("chartHeight",chartbean.getBarChartHeight());
			chartData.put("chartWidth",chartbean.getBarChartWidth());
			//chartData.put("drildown","sametab");
			
			JSONArray dataSet = new JSONArray();
			JSONObject s1=new JSONObject();
			s1.put("name","");
			s1.put("data",chartbean.getBarDataSet());
			s1.put("showInLegend", new Boolean(false));
			dataSet.add(s1);

			chartData.put("DataSet",dataSet);
			chartData.put("title",titleName);
			chartData.put("chartType","bar");
			chartData.put("inside", new Boolean(true));
			chartData.put("legend", new Boolean(false));
			
			rootJson.put("chartData",chartData);

			family_keys = tmapSystemDetails.keySet().iterator();
			while (family_keys.hasNext())
			{
				String key_family = (String)family_keys.next();
				ArrayList aList = (ArrayList)tmapSystemDetails.get(key_family);
				ArrayList aListComponents = new ArrayList();
				for (int i=0; i<aList.size();i=i+2)
					aListComponents.add(aList.get(i));

				egTableAttributes = new EgTableAttributes();
				egTableAttributes.setTitle(key_family+"  ("+mappingInfo.getTextDescription("configmgmt.inventory.system.Count")+" : "+aListComponents.size()+")");

				aListColumnNames = new ArrayList();
				aListData = new ArrayList();
				ArrayList userColumnNames = new ArrayList();

				for (int x=0; x<4; x++)
					aListColumnNames.add("System"+x);

				userColumnNames.add(mappingInfo.getTextDescription("configmgmt.inventory.system.Systems"));
				userColumnNames.add("");
				userColumnNames.add("");
				userColumnNames.add("");

				String ProcessorWithCount = key_family +"  ("+mappingInfo.getTextDescription("configmgmt.inventory.system.Count")+" : "+aListComponents.size()+")";
				tmpObject.put("ProcessorWithCount",ProcessorWithCount);

				int colCount = 0;

				for (int d=0; d<aListComponents.size(); d=d+4)
				{
					for (int e=d; e<d+4; e++)
					{
						if (colCount == 4)
						{
							colCount = 1;
						}
						else
						{
							colCount++;
						}
						if (e<aListComponents.size())
						{
							String system = (String)aListComponents.get(e);
							aListData.add(system);
							tmpObject.put("column_"+colCount,system);
						}
						else
						{
							aListData.add(" ");
							tmpObject.put("column_"+colCount,"");
						}
					}
					systemInfoArray.add(tmpObject);
				}

				egTableModel = new EgTableModel(aListData,aListColumnNames);
				egTableAttributes.setColumnNames(userColumnNames);

				egTable = new EgTable();
				egTable.setModel(egTableModel);
				egTable.setAttributes(egTableAttributes);

				aListPdfData.add(egTable);

			}
		}
		else
		{
			ArrayList aList = (ArrayList)tmapSystemDetails.get(processorFamily);
			int count = aList.size()/2;

			EgTableAttributes egTableAttributes = new EgTableAttributes();
			egTableAttributes.setTitle(processorFamily+"  ("+mappingInfo.getTextDescription("configmgmt.inventory.system.Count")+" : "+count+")");

			ArrayList aListColumnNames = new ArrayList();
			ArrayList aListData = new ArrayList();
			ArrayList userColumnNames = new ArrayList();

			aListColumnNames.add("C0");
			aListColumnNames.add("C1");
			aListColumnNames.add("C2");

			userColumnNames.add(mappingInfo.getTextDescription("configmgmt.inventory.system.Systems"));
			userColumnNames.add("");
			userColumnNames.add("");

			String ProcessorWithCount = processorFamily +"  ("+mappingInfo.getTextDescription("configmgmt.inventory.system.Count")+" : "+count+")";
			tmpObject.put("ProcessorWithCount",ProcessorWithCount);

			int countColumn = 0;
			int colCnt = 0;
			for (int i=0; i<aList.size(); i=i+2)
			{
				String sysWithSize = aList.get(i)+" ("+aList.get(i+1)+")" ;
				colCnt++;
				if(colCnt == 4)
				{
					tmpObject.put("column_"+colCnt,sysWithSize);
					systemInfoArray.add(tmpObject);
					colCnt = 0;
				}
				else
				{
					tmpObject.put("column_"+colCnt,sysWithSize);
				}

				if(countColumn == 3) countColumn = 0;

				aListData.add(aList.get(i)+" ("+aList.get(i+1)+")");

				countColumn++;
				while(countColumn < 3 && i == aList.size() - 2)
				{
					aListData.add(" ");
					countColumn++;
				}
			}
			if(colCnt == 3)
			{
				tmpObject.put("column_4","");
				systemInfoArray.add(tmpObject);
			}
			if(colCnt == 2)
			{
				tmpObject.put("column_4","");
				tmpObject.put("column_3","");
				systemInfoArray.add(tmpObject);
			}
			if(colCnt == 1)
			{
				tmpObject.put("column_4","");
				tmpObject.put("column_3","");
				tmpObject.put("column_2","");
				systemInfoArray.add(tmpObject);
			}

			EgTableModel egTableModel = new EgTableModel(aListData,aListColumnNames);
			egTableAttributes.setColumnNames(userColumnNames);

			EgTable egTable = new EgTable();
			egTable.setModel(egTableModel);
			egTable.setAttributes(egTableAttributes);

			aListPdfData.add(egTable);

			reportAttributes.setSubTitle(mappingInfo.getTextDescription("configmgmt.inventory.system.Processor Family")+" : "+processorFamily);

		}

		//For new pdf framework
		pdfData.setAttributes(reportAttributes);
		pdfData.setData(aListPdfData);
		session.setAttribute("pdfData",pdfData);
	}

	StringBuffer printQS = new StringBuffer();
	printQS.append("printType=ProcessorFamily");
	printQS.append("&printPageTitle=DISTRIBUTION_REPORT_OF_MANAGED_SYSTEMS_BY_PROCESSOR_FAMILY");
	printQS.append("&Page=AuditReport");
	printQS.append("&printData=yes");
	printQS.append("&userName="+EgURLEncoder.encode(userName,"UTF-8"));
	printQS.append("&user_language="+userLanguage);
	printQS.append("&ec_criteria="+ec_criteria);
	printQS.append("&ec_userOption="+((ec_userOption != null)?EgURLEncoder.encode(ec_userOption,"UTF-8"):""));
	String s_qryString = "../servlet/com.eg.EcRepoLiteC?"+printQS.toString()+"&ec_forPDF=No";
	rootJson.put("printQueryStr",s_qryString);

	session.setAttribute("PDF_URL",mngrIProc+"/final/servlet/com.eg.EcRepoLiteC;jsessionid="+session.getId()+"?"+printQS.toString()+"&ec_forPDF=Yes");
	session.setAttribute("REPORT_NAME","InventoryReportByProcessorFamily");
	session.setAttribute("REPORT_LAYOUT","Portrait");
	session.setAttribute("PAGE_WIDTH_PDF","1100");
	session.setAttribute("PAGE_WIDTH_MAIL_IMAGE","1300");
	session.setAttribute("PAGE_HEIGHT_MAIL_IMAGE","768");


	if(queryString !=null)
	{
		session.setAttribute("configLastAccessedURL","/final/config/EcProcessorFamilyIndex.jsp?"+queryString);
	}
	else
	{
		session.setAttribute("configLastAccessedURL","/final/config/EcProcessorFamilyIndex.jsp?ec_rtype=Processor&processorFamily=All");
	}


	rootJson.put("hiddenFields",hiddenFields);
	rootJson.put("systemInfoArray",systemInfoArray);
	out.println(rootJson.toString());

%>




