<%@ page import = "java.util.*"%>
<%@ page import = "java.text.*"%>

<%@ page import = "net.sf.json.*"%>

<%@ page import = "com.eg.*"%>

<%@ page import = "com.egurkha.*"%>
<%@ page import = "com.egurkha.util.DateUtil"%>
<%@ page import = "com.egurkha.util.StringUtils"%>
<%@ page import = "com.egurkha.ini.IniUI"%>
<%@ page import = "com.egurkha.config.TimeLineBean" %>

<%@ page import = "egurkha.*"%>
<%@ page import = "egurkha.config.*"%>


<%@ page errorPage="EcProbs.jsp"%>

<%@ page language="java" contentType="text/html;charset=UTF-8" pageEncoding="UTF-8"%>

<%!
	String[] criterias = {"Zone","Service","Segment","Component"}; 
	String[] sftwrHotFixArr = {"Software","Hotfix"};
	String[] testNames = {"SoftwareList_cf","HotFix_cf"}; 	
	String[] timelineOptions = {"Any","1 hour", "2 hours", "3 hours", "6 hours", "12 hours", "18 hours", "21 hours", "1 day", "2 days", "3 days", "4 days", "5 days", "6 days", "1 week", "2 weeks", "3 weeks", "4 weeks", "1 month", "Last week", "Last month"}; 
	String[] hours = {"00","01", "02", "03", "04", "05", "06", "07","08", "09", "10", "11", "12","13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23"};
	String[] minutes = {"00","01", "02", "03", "04", "05", "06", "07","08", "09", "10", "11", "12","13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23","24","25", "26", "27", "28", "29", "30", "31","32", "33", "34", "35", "36","37", "38", "39", "40", "41", "42", "43", "44", "45", "46", "47","48", "49","50", "51", "52", "53", "54","55", "56", "57", "58", "59"};
	String[] filterByArr = {"All installed", "All uninstalled", "Currently installed", "Currently uninstalled", "Components having", "Components not having", "available in the components", "not available in the components"}; 
	String dashboardIniFileName = EcSoftwareHotfixHandler.iniFileName; //"eg_cnfg_SftwrHotfixDashboard.ini";
		
	private JSONArray getCriteriasComboJsonObj(EgMappingInfo mappingInfo)
	{
		JSONArray viewByArr = new JSONArray();
		if (criterias != null)
		{
			for(int incr = 0; incr < criterias.length; incr++)
			{
				JSONObject viewByObj = new JSONObject();
				String curCriteria = criterias[incr];
				viewByObj.put("displayField",mappingInfo.getTextDescription("configmgmt.SoftwareHotfix."+curCriteria));
				viewByObj.put("valueField",curCriteria);
				viewByArr.add(viewByObj);
			}
		}
		return viewByArr;
	}
	
	private JSONArray getSftwrHtfxComboJsonObj(EgMappingInfo mappingInfo)
	{
		JSONArray softwareOrHotFixArr = new JSONArray();
		
		if (sftwrHotFixArr != null)
		{
			for(int incr = 0; incr < sftwrHotFixArr.length; incr++)
			{
				JSONObject softwareOrHotFixObj = new JSONObject();
				String currentStr = sftwrHotFixArr[incr];
				softwareOrHotFixObj.put("displayField",mappingInfo.getTextDescription("configmgmt.SoftwareHotfix."+currentStr));
				softwareOrHotFixObj.put("valueField",currentStr);
				softwareOrHotFixArr.add(softwareOrHotFixObj);
			}
		}
		return softwareOrHotFixArr;
	}
	
	private JSONArray getTimelineComboJsonObj(EgMappingInfo mappingInfo)
	{
		JSONArray ec_timelineArr = new JSONArray();
		for (int incr = 0; incr < timelineOptions.length; incr++)
		{
			JSONObject tmpObj = new JSONObject();
			String strOption = timelineOptions[incr];
			tmpObj.put("valueField",strOption);
			tmpObj.put("displayField",mappingInfo.getTextDescription("configmgmt.SoftwareHotfix.timeline."+strOption));
			ec_timelineArr.add(tmpObj);
		}
		return ec_timelineArr;
	}
	
	private JSONArray getHourComboJsonObj()
	{
		JSONArray ec_HoursArr = new JSONArray();
		for (int incr = 0; incr < hours.length; incr++)
		{
			JSONObject tmpObj = new JSONObject();
			String currentVal = hours[incr];
			tmpObj.put("valueField",currentVal);
			tmpObj.put("displayField",currentVal);
			ec_HoursArr.add(tmpObj);
		}
		return ec_HoursArr;
	}
	
	private JSONArray getMinsComboJsonObj()
	{
		JSONArray ec_MinsArr = new JSONArray();
		for (int incr = 0; incr < minutes.length; incr++)
		{
			JSONObject tmpObj = new JSONObject();
			String currentVal = minutes[incr];
			tmpObj.put("valueField",currentVal);
			tmpObj.put("displayField",currentVal);
			ec_MinsArr.add(tmpObj);
		}
		return ec_MinsArr;
	}
	
	private boolean validateAllowableDateRange(Calendar endDate, Calendar startDate, int allowableDays)	
	{
		boolean isAllowed = false;
		
		long MILLISECONDS_FOR_A_DAY = 1000 * 60 * 60 * 24;
		
		long givenDaysInMilliSeconds = endDate.getTimeInMillis() - startDate.getTimeInMillis();
		long allowableDaysInMilliSeconds = MILLISECONDS_FOR_A_DAY * allowableDays;
		
		if(givenDaysInMilliSeconds <= allowableDaysInMilliSeconds)
		{
			isAllowed = true;
		}

		return isAllowed;
	}
	
	private JSONObject getFilterGridJsonObj(List instldUnInstldDtls, String softwareHotfix, User user, String mgrDateFormat, EgMappingInfo mappingInfo,String testNm, Map avlblCmpntNmType, String filterBy)
	{
		JSONObject gridDataObj1 = new JSONObject();
		JSONArray subGridDataArr = new JSONArray();
		JSONArray gridFieldsNamesArr = new JSONArray();
		JSONObject gridFieldsObj = new JSONObject();
		JSONObject gridHeaderObj = new JSONObject();
		JSONObject gridDataObj = new JSONObject();
		String[] gridWthVrsnFieldsArr = new String[]{"COMPONENT_TYPE","COMPONENT_NAME","OPERATING_SYSTEM","SOFTWARE_NAME","VERSION","INSTALLED_DATE","Agent_CollectedDate"};
		String[] gridWithOutVrsnFieldsArr = new String[]{"COMPONENT_TYPE","COMPONENT_NAME","OPERATING_SYSTEM","SOFTWARE_NAME","INSTALLED_DATE","Agent_CollectedDate"};
		
		String labelNotApplicable = mappingInfo.getTextDescription("configmgmt.SoftwareHotfix.dashboard.Not applicable");
		String labelNotAvailable = mappingInfo.getTextDescription("configmgmt.SoftwareHotfix.dashboard.Unknown");
		
		if(EcSoftwareHotfixHandler.CONST_SOFTWARE.equalsIgnoreCase(softwareHotfix))
		{
			if(filterBy != null && !(EcSoftwareHotfixHandler.CONST_CurUnInslldSftwrs.equalsIgnoreCase(filterBy) && !(EcSoftwareHotfixHandler.CONST_AllUnInslldSftwrs.equalsIgnoreCase(filterBy))))
			{
				for (int incr = 0; incr < gridWthVrsnFieldsArr.length; incr++) 
				{
					JSONObject gridFieldsNameAndType = new JSONObject();
					gridFieldsNameAndType.put("name",gridWthVrsnFieldsArr[incr]);
					gridFieldsNameAndType.put("type","string");
					gridFieldsNamesArr.add(gridFieldsNameAndType);
				}
				
			}
			else
			{
				for (int incr = 0; incr < gridWithOutVrsnFieldsArr.length; incr++) 
				{
					JSONObject gridFieldsNameAndType = new JSONObject();
					gridFieldsNameAndType.put("name",gridWithOutVrsnFieldsArr[incr]);
					gridFieldsNameAndType.put("type","string");
					gridFieldsNamesArr.add(gridFieldsNameAndType);
				}
			}
		}
		else if(EcSoftwareHotfixHandler.CONST_HOTFIX.equalsIgnoreCase(softwareHotfix))
		{
			for (int incr = 0; incr < gridWithOutVrsnFieldsArr.length; incr++) 
			{
				JSONObject gridFieldsNameAndType = new JSONObject();
				gridFieldsNameAndType.put("name",gridWithOutVrsnFieldsArr[incr]);
				gridFieldsNameAndType.put("type","string");
				gridFieldsNamesArr.add(gridFieldsNameAndType);
			}
		}
		
		gridHeaderObj.put("COMPONENT_TYPE",mappingInfo.getTextDescription("configmgmt.SoftwareHotfix.dashboard.grid.Component type"));
		gridHeaderObj.put("COMPONENT_NAME",mappingInfo.getTextDescription("configmgmt.SoftwareHotfix.dashboard.grid.Component name"));
		gridHeaderObj.put("OPERATING_SYSTEM",mappingInfo.getTextDescription("configmgmt.SoftwareHotfix.dashboard.grid.Operating System"));
		gridHeaderObj.put("SOFTWARE_NAME", testNm+" "+mappingInfo.getTextDescription("configmgmt.SoftwareHotfix.dashboard.Name"));
		
		if((EcSoftwareHotfixHandler.CONST_SOFTWARE.equalsIgnoreCase(softwareHotfix)) && !(EcSoftwareHotfixHandler.CONST_CurUnInslldSftwrs.equalsIgnoreCase(filterBy)) && !(EcSoftwareHotfixHandler.CONST_AllUnInslldSftwrs.equalsIgnoreCase(filterBy)))
		{
			gridHeaderObj.put("VERSION",mappingInfo.getTextDescription("configmgmt.SoftwareHotfix.dashboard.grid.Version"));
		}
		if((EcSoftwareHotfixHandler.CONST_CurUnInslldSftwrs.equalsIgnoreCase(filterBy) || (EcSoftwareHotfixHandler.CONST_AllUnInslldSftwrs.equalsIgnoreCase(filterBy))) ||(EcSoftwareHotfixHandler.CONST_CurUnInstldHtfxs.equalsIgnoreCase(filterBy) || (EcSoftwareHotfixHandler.CONST_AllUnInstldHtfxs.equalsIgnoreCase(filterBy))))
		{
			gridHeaderObj.put("INSTALLED_DATE",mappingInfo.getTextDescription("configmgmt.SoftwareHotfix.dashboard.grid.Uninstalled date"));
		}
		else
		{
			gridHeaderObj.put("INSTALLED_DATE",mappingInfo.getTextDescription("configmgmt.SoftwareHotfix.dashboard.grid.Installed date"));
		}
		
		gridHeaderObj.put("Agent_CollectedDate",mappingInfo.getTextDescription("configmgmt.SoftwareHotfix.dashboard.grid.When reported?"));
		
		gridDataObj.put("gridFields",gridFieldsNamesArr);
		gridDataObj.put("gridHeader",gridHeaderObj);
		gridDataObj.put("colSize","5");
		DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
		if(instldUnInstldDtls != null && instldUnInstldDtls.size()>0)
		{
			for (int incr = 0; incr < instldUnInstldDtls.size(); incr++) 
			{
				List currentRow = (ArrayList)	instldUnInstldDtls.get(incr);
				if(currentRow.size() >= 4)
				{
					JSONObject subGridDataObj = new JSONObject();
					subGridDataObj.put("COMPONENT_TYPE" , mappingInfo.getComponentTypeDescription((String)avlblCmpntNmType.get((String)currentRow.get(0))));
					subGridDataObj.put("COMPONENT_NAME" , currentRow.get(0));
					String curOsName = (String) currentRow.get(1);
					if(curOsName != null && !EcSoftwareHotfixHandler.Not_Available.equalsIgnoreCase(curOsName))
					{
						subGridDataObj.put("OPERATING_SYSTEM" , curOsName);
					}
					else
					{
						subGridDataObj.put("OPERATING_SYSTEM" , labelNotAvailable);
					}
					
					subGridDataObj.put("SOFTWARE_NAME" , currentRow.get(2));
					if(currentRow.get(3) != null)
					{
						subGridDataObj.put("INSTALLED_DATE" , new SimpleDateFormat(mgrDateFormat).format((Date)currentRow.get(3)));
					}
					else if(currentRow.get(3) == null)
					{
						subGridDataObj.put("INSTALLED_DATE" , labelNotApplicable);
					}
					
					if(EcSoftwareHotfixHandler.CONST_SOFTWARE.equalsIgnoreCase(softwareHotfix) && !(EcSoftwareHotfixHandler.CONST_CurUnInslldSftwrs.equalsIgnoreCase(filterBy)) && !(EcSoftwareHotfixHandler.CONST_AllUnInslldSftwrs.equalsIgnoreCase(filterBy)))
					{
						if(currentRow.get(5) != null)
						{
							subGridDataObj.put("VERSION" , currentRow.get(5));
						}
						else
						{
							subGridDataObj.put("VERSION" ,labelNotApplicable);
						}
					}
					if(currentRow.size() == 4)
					{
						if(currentRow.get(3) != null)
						{
							subGridDataObj.put("Agent_CollectedDate" , new SimpleDateFormat(mgrDateFormat+" HH:mm:ss").format((Date)currentRow.get(3)));
						}
						else
						{
							subGridDataObj.put("Agent_CollectedDate" , labelNotApplicable);
						}
						
					}
					else
					{
						if(currentRow.get(4) != null)
						{
							subGridDataObj.put("Agent_CollectedDate" , new SimpleDateFormat(mgrDateFormat+" HH:mm:ss").format((Date)currentRow.get(4)));
						}
						else
						{
							subGridDataObj.put("Agent_CollectedDate" , labelNotApplicable);
						}
					}
					
					subGridDataArr.add(subGridDataObj);
				}
			}
		}
		gridDataObj.put("gridData",subGridDataArr);
		gridDataObj1.put("gridData",gridDataObj);
		return gridDataObj1;
	}
	
	private JSONArray getFilterBySoftwareComboJsonObj(EgMappingInfo mappingInfo)
	{
		JSONArray filterBySoftwareJsonArr = new JSONArray();
		
		if (filterByArr != null)
		{
			for(int incr = 0; incr < filterByArr.length; incr++)
			{
				JSONObject filterByObj = new JSONObject();
				String curCriteria = filterByArr[incr];
				if(incr == 6 || incr == 7 )
				{
					filterByObj.put("displayField",mappingInfo.getTextDescription("configmgmt.SoftwareHotfix.dashboard.Software")+" "+mappingInfo.getTextDescription("configmgmt.SoftwareHotfix."+curCriteria));
					filterByObj.put("valueField","Software "+curCriteria);
					filterBySoftwareJsonArr.add(filterByObj);
				}
				else
				{
					filterByObj.put("displayField",mappingInfo.getTextDescription("configmgmt.SoftwareHotfix."+curCriteria)+" "+mappingInfo.getTextDescription("configmgmt.SoftwareHotfix.dashboard.softwares"));
					filterByObj.put("valueField",curCriteria+" softwares");
					filterBySoftwareJsonArr.add(filterByObj);
				}
			}
		}
		return filterBySoftwareJsonArr;
	}
	private JSONArray getFilterByHotfixComboJsonObj(EgMappingInfo mappingInfo)
	{
		JSONArray filterByHotfixJsonArr = new JSONArray();
		
		if (filterByArr != null)
		{
			for(int incr = 0; incr < filterByArr.length; incr++)
			{
				JSONObject filterByObj = new JSONObject();
				String curCriteria = filterByArr[incr];
				if(incr == 6 || incr == 7 )
				{
					filterByObj.put("displayField",mappingInfo.getTextDescription("configmgmt.SoftwareHotfix.dashboard.Hotfix")+" "+mappingInfo.getTextDescription("configmgmt.SoftwareHotfix."+curCriteria));
					filterByObj.put("valueField","Hotfix "+curCriteria);
					filterByHotfixJsonArr.add(filterByObj);
				}
				else
				{	
					filterByObj.put("displayField",mappingInfo.getTextDescription("configmgmt.SoftwareHotfix."+curCriteria)+" "+mappingInfo.getTextDescription("configmgmt.SoftwareHotfix.dashboard.hotfixes"));
					filterByObj.put("valueField",curCriteria+" hotfixes");
					filterByHotfixJsonArr.add(filterByObj);
				}
			}
		}
		return filterByHotfixJsonArr;
	}
	
	private User getCurrentUser(HttpSession session)
	{
		UserRegistry registry = UserRegistry.getInstance();
		User user = registry.getUser(session.getId());
		return user;
	}
	
	private String getUserLanguage(User user)
	{
		IniUI iniUI = IniUI.getInstance();
		String userLanguage = iniUI.getDefaultLanguage();
		if (user != null)
		{
			userLanguage = user.getLanguage();
		}
		return userLanguage;
	}
	
	private String getCurrentDateFormat(User user)
	{
		String uiFile = "eg_ui.ini";
		String s_iniFile_dir = EgInstallInfo.getInstallDir()+ "/manager/config/";
		IniFile iniFile = new IniFile(s_iniFile_dir + uiFile);
		
		String currentDateFormat = null;
		
		String mgrDateFormat = iniFile.getValue("CURRENT_DATE_FORMAT","selectedDateFormat");
		String userDateFormat = user.getUserDateFormat();
		
		if (userDateFormat != null && userDateFormat.equalsIgnoreCase("Default"))
		{
			userDateFormat = mgrDateFormat;
		}
		
		if (userDateFormat != null)
		{
			currentDateFormat = userDateFormat;
		}
		else
		{
			currentDateFormat = mgrDateFormat;
		}
		
		return currentDateFormat;
	}
	
	private Calendar obtainDate(String dateAsStr, String dateTimeFormat, String hourAsStr, String minAsStr)
	{
		Calendar obtainedDate = null;
		
		Date dateWithoutHrMin = null;
		int hour = -1;
		int minute = -1;
		
		try
		{
			SimpleDateFormat format = new SimpleDateFormat(dateTimeFormat);
			dateWithoutHrMin = format.parse(dateAsStr);
		
			hour = Integer.parseInt(hourAsStr);
			minute = Integer.parseInt(minAsStr);
		}
		catch(Exception e)
		{
			
		}		
		if( (dateWithoutHrMin != null) && (hour != -1) && (minute != -1) )
		{
			Calendar cal = Calendar.getInstance();
			cal.setTime(dateWithoutHrMin);
			cal.add(Calendar.HOUR_OF_DAY, hour);
			cal.add(Calendar.MINUTE, minute);
			obtainedDate = cal;			
		}
		return obtainedDate;
	}
	private void populateViewByForZnSrvcSgmnt(JSONObject rootJson, String viewBy, Vector vecUserOptions, String ec_userOption, EgMappingInfo mappingInfo)
	{
		boolean isSelectedUserOptionFlg = false;
		JSONArray specviewByArr = new JSONArray();
		if (viewBy != null && !viewBy.equalsIgnoreCase(criterias[3]))
		{	
			if (viewBy.equalsIgnoreCase(criterias[0]))
			{
				rootJson.put("specViewByTitle",criterias[0]);
			}
			else if (viewBy.equalsIgnoreCase(criterias[1]))
			{
				rootJson.put("specViewByTitle",criterias[1]);
			}
			else
			{
				rootJson.put("specViewByTitle",criterias[2]);
			}

			JSONObject specviewByObj = new JSONObject();

			if (vecUserOptions != null && !vecUserOptions.isEmpty())
			{
				for(int i=0; i<vecUserOptions.size(); i++)
				{
					String selected = "";
					String strUserOption = (String)vecUserOptions.get(i);
					if(ec_userOption != null && strUserOption.equals(ec_userOption))
					{
						isSelectedUserOptionFlg = true;
						rootJson.put("selectedUserOptionText",ec_userOption);
					}
					specviewByObj.put("displayField",strUserOption);
					specviewByObj.put("valueField",strUserOption);
					specviewByArr.add(specviewByObj);
				}
			}
			else
			{
				rootJson.put("selectedUserOptionText","-1");
				specviewByObj.put("displayField",mappingInfo.getTextDescription("configmgmt.common.Not Applicable"));
				specviewByObj.put("valueField","-1");
				specviewByArr.add(specviewByObj);
			}
		}
		rootJson.put("isSelectedUserOptionFlg",isSelectedUserOptionFlg);
		rootJson.put("specViewByList",specviewByArr);
	}
	
	private JSONArray getOsNamesJsonObj(Map trgtHostOsNm, EgMappingInfo mappingInfo)
	{
		JSONArray osNamesJsonArr = new JSONArray();
		JSONObject defaultJsonObj = new JSONObject();
		defaultJsonObj.put("displayField",mappingInfo.getTextDescription("configmgmt.SoftwareHotfix.dashboard.ALL"));
		defaultJsonObj.put("valueField","ALL");
		osNamesJsonArr.add(defaultJsonObj);
		if(trgtHostOsNm != null && trgtHostOsNm.size()>0)
		{
			Set uniqueOsNames = new HashSet(trgtHostOsNm.values()); 
		
			Iterator iterator = uniqueOsNames.iterator();
			while (iterator.hasNext()) 
			{
				JSONObject osNamesJsonObj = new JSONObject();
				String currentOsName = (String)iterator.next();
				osNamesJsonObj.put("displayField",currentOsName);
				osNamesJsonObj.put("valueField",currentOsName);
				osNamesJsonArr.add(osNamesJsonObj);
			}
		}
		return osNamesJsonArr;
	}
	
	private JSONArray getAllComponentsTypesJsonObj(Map trgtHostOsNm, Map avlblCmpntNmType, String osName, EgMappingInfo mappingInfo)
	{
		JSONArray cmpntsTypesJsonArr = new JSONArray();
		JSONObject defaultJsonObj = new JSONObject();
		defaultJsonObj.put("displayField",mappingInfo.getTextDescription("configmgmt.SoftwareHotfix.dashboard.ALL"));
		defaultJsonObj.put("valueField","ALL");
		cmpntsTypesJsonArr.add(defaultJsonObj);
		
		Set cmpntsTypes = null;
    	if(!("All".equalsIgnoreCase(osName)))
    	{
    		Iterator itr1 =trgtHostOsNm.keySet().iterator();
        	cmpntsTypes = new HashSet();
        	while(itr1.hasNext())
        	{
        		String curKey1 = (String)itr1.next();
        		String curVal1 = (String)trgtHostOsNm.get(curKey1);
        		if(osName.equalsIgnoreCase(curVal1))
        		{
        			cmpntsTypes.add(avlblCmpntNmType.get(curKey1));
        		}
        	}
    	}
    	else
    	{
    		cmpntsTypes = new HashSet(avlblCmpntNmType.values());
    	}
		
		if(cmpntsTypes != null && cmpntsTypes.size() >0)
		{
			Iterator cmpntsTypesItr = cmpntsTypes.iterator();
			while(cmpntsTypesItr.hasNext())
			{
				JSONObject tempJsonObj = new JSONObject();
				String currentKey = (String)cmpntsTypesItr.next();
				tempJsonObj.put("displayField", mappingInfo.getComponentTypeDescription(currentKey));
				tempJsonObj.put("valueField",currentKey);
				cmpntsTypesJsonArr.add(tempJsonObj);
			}
		}
		return cmpntsTypesJsonArr;
	}
	
	private void getTestmsrNoForInstldDscrptr(HttpSession session, String[] testNames)
	{
		if(testNames != null)
		{
			EgThresholdInfo egThresholdInfo = new EgThresholdInfo("manager");
			for(int incr = 0 ;incr < testNames.length; incr++ )
			{
				int msrNoForInstldDscrptr = 0;
				String[] measures = egThresholdInfo.getMeasurementsForTest(testNames[incr]);
				if(measures != null && measures.length >0)
				{
					msrNoForInstldDscrptr = measures.length-1;
				}
				if(incr == 0)
				{
					session.setAttribute("instldDscrptr_MsrNo_Software", msrNoForInstldDscrptr);
				}
				else if(incr == 1 )
				{
					session.setAttribute("instldDscrptr_MsrNo_Hotfix", msrNoForInstldDscrptr);
				}
			}
		}
	}
%>

<%

	String queryString = EcUtils.prepareQueryString(request.getParameterMap());
	JSONObject rootJson = new JSONObject();
	
	User curUser = getCurrentUser(session);	
	if(curUser != null)
	{
		String labelSftwrHotfix = null;
		String labelInstldUnInstld = null;
		
		String str_reqFrom = request.getParameter("reqFrom");
		
		if(str_reqFrom == null)
		{
			str_reqFrom = "navLink";
		}

		EgMappingInfo mappingInfo = new EgMappingInfo(getUserLanguage(curUser));	
		String currentDateFormat = getCurrentDateFormat(curUser);
		IniFile dashboardIni = new IniFile(EgConfigInfo.egMgrConfigDir +dashboardIniFileName );
		
		String currentDateTimeFormat = currentDateFormat+ " hh:mm:ss";
		Vector vecUserOptions = (Vector)session.getAttribute("vecUserOptions");
		String ec_userOption = (String)session.getAttribute("ec_userOption");
		Map filterDtlsForSession = new HashMap();
		
		if(str_reqFrom != null && "viewBy".equalsIgnoreCase(str_reqFrom))
		{
			String viewBy = request.getParameter("viewBy");
			
			populateViewByForZnSrvcSgmnt(rootJson, viewBy, vecUserOptions, ec_userOption, mappingInfo);
			rootJson.put("selectedviewBy",viewBy);
			rootJson.put("viewByList",getCriteriasComboJsonObj(mappingInfo));
			rootJson.put("success","true");
		}
		else if(str_reqFrom != null && "timeline".equalsIgnoreCase(str_reqFrom))
		{	
			String str_ec_timeline = request.getParameter("ec_timeline");
			
			Calendar startDate = null;
			Calendar endDate = null;
			
			if( (str_ec_timeline != null) && (!str_ec_timeline.equalsIgnoreCase("Any")) )
			{
				Map map = request.getParameterMap();
				TimeLineBean timeLineBean = new TimeLineBean(map);
				
				startDate = obtainDate(timeLineBean.getStartDate(), "MM/dd/yyyy", timeLineBean.getStartHour(), timeLineBean.getStartMinute());
				endDate = obtainDate(timeLineBean.getEndDate(), "MM/dd/yyyy", timeLineBean.getEndHour(), timeLineBean.getEndMinute());				
			}
			else if( (str_ec_timeline != null) && (str_ec_timeline.equalsIgnoreCase("Any")) )
			{
				String startDateAsStr = request.getParameter("startDate"); // This returns in the currentDateFormat
				String startHourAsStr = request.getParameter("startHr");
				String startMinuteAsStr = request.getParameter("startMin");

				String endDateAsStr = request.getParameter("endDate"); // This returns in the currentDateFormat
				String endHourAsStr = request.getParameter("endHr");
				String endMinuteAsStr = request.getParameter("endMin");	
				
				startDate = obtainDate(startDateAsStr, currentDateFormat, startHourAsStr, startMinuteAsStr);
				endDate = obtainDate(endDateAsStr, currentDateFormat, endHourAsStr, endMinuteAsStr);				
			}

			if( (startDate != null) && (endDate != null) )
			{
				rootJson.put("selectedTimeline",str_ec_timeline);
				rootJson.put("StartDate", (new SimpleDateFormat(currentDateFormat)).format(startDate.getTime()));
				rootJson.put("EndDate",(new SimpleDateFormat(currentDateFormat)).format(endDate.getTime()));
				rootJson.put("StartHr",startDate.get(Calendar.HOUR_OF_DAY));
				rootJson.put("EndHr",endDate.get(Calendar.HOUR_OF_DAY));
				rootJson.put("StartMinute",startDate.get(Calendar.MINUTE));
				rootJson.put("EndMinute",endDate.get(Calendar.MINUTE));	
				rootJson.put("success","true");				
			}
			else
			{
				rootJson.put("success","false");
			}
		}
		else if(str_reqFrom != null && "osName".equalsIgnoreCase(str_reqFrom))
		{
			String osName = request.getParameter("osName");
			String cmpntType = request.getParameter("cmpntType"); 
			
			EcSoftwareHotfixHandler ecSoftwareHotfixHandler = new EcSoftwareHotfixHandler();
			List allAssctdMngdCmpTypCmpnts = (ArrayList)session.getAttribute("associatedComponents");
			Map avlblCmpntNmType =ecSoftwareHotfixHandler.extractCmpntNmType(allAssctdMngdCmpTypCmpnts);
			//Total components Details
			Map trgtHostOsNm = ecSoftwareHotfixHandler.getAllTrgtHostsWithOsNm(avlblCmpntNmType);
			
			rootJson.put("OsNamesList",getOsNamesJsonObj(trgtHostOsNm, mappingInfo));
			rootJson.put("ComponentTypesList",getAllComponentsTypesJsonObj(trgtHostOsNm, avlblCmpntNmType, osName, mappingInfo));
			rootJson.put("selectedComponentType",cmpntType);
			rootJson.put("selectedOsName",osName);
		}
		else if(str_reqFrom != null && (("navLink".equals(str_reqFrom)) || ("submit".equals(str_reqFrom))) )
		{
			String viewBy = request.getParameter("viewBy");
			String softwareOrHotfix = request.getParameter("softwareOrHotfix");
			String str_ec_timeline = request.getParameter("ec_timeline");
			String filterBy = request.getParameter("filterBy");
			String fltrCndtn = EgUIUtils.decodeSecurityChar(request.getParameter("filterCondition"));
			String dashboardReq = request.getParameter("dashboardReq");
			String osName = request.getParameter("osName"); 
			String cmpntType = request.getParameter("cmpntType"); 
			String info = EgUIUtils.decodeSecurityChar(request.getParameter("info"));
			String showBackButton = request.getParameter("showBackButton"); 
			String  reqFromPage  = request.getParameter("reqFromPage"); 
			
			if (viewBy == null)
			{
				viewBy = dashboardIni.getValue("DEFAULT_VALUES", "ViewBy");  
			}
			
 			if ("navLink".equals(str_reqFrom) && !("true".equalsIgnoreCase(showBackButton)))
			{
				if(viewBy != null && !"Component".equalsIgnoreCase(viewBy))
				{
					if("Zone".equalsIgnoreCase(viewBy))
					{
						String zoneName = dashboardIni.getValue("DEFAULT_VALUES", "ZoneName");
						if(zoneName != null && !"".equals(zoneName))
						{
							ec_userOption = zoneName;
						}
					}
					if("Service".equalsIgnoreCase(viewBy))
					{
						ec_userOption = dashboardIni.getValue("DEFAULT_VALUES", "ServiceName");  
					}
					if("Segment".equalsIgnoreCase(viewBy))
					{
						ec_userOption = dashboardIni.getValue("DEFAULT_VALUES", "SegmentName");  
					}
				}
			}
			if (softwareOrHotfix == null)
			{
				softwareOrHotfix = dashboardIni.getValue("DEFAULT_VALUES", "SoftwareHotfix");
			}
			
			if (str_ec_timeline == null)
			{
				str_ec_timeline = dashboardIni.getValue("DEFAULT_VALUES", "TimeLine");
			}
			
			if(filterBy == null)
			{
				filterBy = dashboardIni.getValue("DEFAULT_VALUES", "FilterBy");
			}
			if(osName == null)
			{
				osName = mappingInfo.getTextDescription("configmgmt.SoftwareHotfix.dashboard.ALL");
			}
			
			if(cmpntType == null)
			{
				cmpntType = mappingInfo.getTextDescription("configmgmt.SoftwareHotfix.dashboard.ALL");
			}
			
			if(info == null || "".equalsIgnoreCase(info) ||  "undefined".equalsIgnoreCase(info))
			{
				info = "ALL";
			}
			if(showBackButton == null || "".equalsIgnoreCase(showBackButton))
			{
				showBackButton = "false";
			}
			if(reqFromPage == null || "".equalsIgnoreCase(showBackButton))
			{
				reqFromPage = "SftwrHtfxFltrByPage";
			}
			
			Calendar startDate = null;
			Calendar endDate = null;
		
			if( (str_ec_timeline != null) && (!str_ec_timeline.equalsIgnoreCase("Any")) )
			{
				Map map = request.getParameterMap();
				TimeLineBean timeLineBean = new TimeLineBean(map);
				
				startDate = obtainDate(timeLineBean.getStartDate(), "MM/dd/yyyy", timeLineBean.getStartHour(), timeLineBean.getStartMinute());
				endDate = obtainDate(timeLineBean.getEndDate(), "MM/dd/yyyy", timeLineBean.getEndHour(), timeLineBean.getEndMinute());				
			}
			else if( (str_ec_timeline != null) && (str_ec_timeline.equalsIgnoreCase("Any")) )
			{
				String startDateAsStr = request.getParameter("startDate"); // This returns in the currentDateFormat
				String startHourAsStr = request.getParameter("startHr");
				String startMinuteAsStr = request.getParameter("startMin");

				String endDateAsStr = request.getParameter("endDate"); // This returns in the currentDateFormat
				String endHourAsStr = request.getParameter("endHr");
				String endMinuteAsStr = request.getParameter("endMin");	
				
				startDate = obtainDate(startDateAsStr, currentDateFormat, startHourAsStr, startMinuteAsStr);
				endDate = obtainDate(endDateAsStr, currentDateFormat, endHourAsStr, endMinuteAsStr);				
			}
			
			if( (startDate != null) && (endDate != null) )
			{
				boolean continueStatus = true;
				
				if( (str_ec_timeline != null) && (str_ec_timeline.equalsIgnoreCase("Any")) )
				{
					int allowableDays;
					try
					{
						allowableDays = Integer.parseInt(dashboardIni.getValue("DEFAULT_VALUES", "AllowedDateRangeInDays"));
					}
					catch(NumberFormatException nfe)
					{
						allowableDays = 30; 
					}				
					continueStatus = validateAllowableDateRange(endDate, startDate, allowableDays);
					rootJson.put("AllowableDays",allowableDays);
					
				}
				rootJson.put("AllowableDaysStatus",continueStatus);	
			
				if(continueStatus)
				{
					int msrNoForInstldDscrptr = 0;
					if(EcSoftwareHotfixHandler.CONST_SOFTWARE.equalsIgnoreCase(softwareOrHotfix))
					{
						if( session.getAttribute("instldDscrptr_MsrNo_Software") != null )
						{
							msrNoForInstldDscrptr = ((Integer)session.getAttribute("instldDscrptr_MsrNo_Software")).intValue(); 
						}
						else
						{
							getTestmsrNoForInstldDscrptr(session, testNames);
							msrNoForInstldDscrptr = ((Integer)session.getAttribute("instldDscrptr_MsrNo_Software")).intValue();
						}
					}
					else if(EcSoftwareHotfixHandler.CONST_HOTFIX.equalsIgnoreCase(softwareOrHotfix))
					{	
						if(session.getAttribute("instldDscrptr_MsrNo_Hotfix") != null)
						{
							msrNoForInstldDscrptr = ((Integer)session.getAttribute("instldDscrptr_MsrNo_Hotfix")).intValue(); 
						}
						else
						{
							getTestmsrNoForInstldDscrptr(session, testNames);
							msrNoForInstldDscrptr = ((Integer)session.getAttribute("instldDscrptr_MsrNo_Hotfix")).intValue(); 
						}
					}
					//lables Names
					if(EcSoftwareHotfixHandler.CONST_SOFTWARE.equalsIgnoreCase(softwareOrHotfix))
					{
						labelSftwrHotfix = mappingInfo.getTextDescription("configmgmt.SoftwareHotfix.dashboard.Software");
					}
					else if(EcSoftwareHotfixHandler.CONST_HOTFIX.equalsIgnoreCase(softwareOrHotfix))
					{
						labelSftwrHotfix =mappingInfo.getTextDescription("configmgmt.SoftwareHotfix.dashboard.Hotfix");	
					}
					
					if((EcSoftwareHotfixHandler.CONST_CurUnInslldSftwrs.equalsIgnoreCase(filterBy) || (EcSoftwareHotfixHandler.CONST_AllUnInslldSftwrs.equalsIgnoreCase(filterBy))) ||(EcSoftwareHotfixHandler.CONST_CurUnInstldHtfxs.equalsIgnoreCase(filterBy) || (EcSoftwareHotfixHandler.CONST_AllUnInstldHtfxs.equalsIgnoreCase(filterBy))))
					{
						labelInstldUnInstld = mappingInfo.getTextDescription("configmgmt.SoftwareHotfix.dashboard.grid.Uninstalled date");
					}
					else
					{
						labelInstldUnInstld = mappingInfo.getTextDescription("configmgmt.SoftwareHotfix.dashboard.grid.Installed date");
					}
					
					//converting into currentDateTimeFormat to pass to queries as date object
					
					EcSoftwareHotfixHandler ecSoftwareHotfixHandler = new EcSoftwareHotfixHandler();
					
					List allAssctdMngdCmpTypCmpnts = (ArrayList)session.getAttribute("associatedComponents");
					Map avlblCmpntNmType =ecSoftwareHotfixHandler.extractCmpntNmType(allAssctdMngdCmpTypCmpnts);
					
					//Total components Details
					Map trgtHostOsNm = ecSoftwareHotfixHandler.getAllTrgtHostsWithOsNm(avlblCmpntNmType);
					
					List filterByDtls = null;
					List instledUninstldDtls = null; 
					
					if(filterBy != null)
					{
						Map reqParams = new HashMap();
						reqParams.put("softwareOrHotfix", softwareOrHotfix);
						reqParams.put("fltrByOpt", filterBy);
						reqParams.put("startDate", startDate);
						reqParams.put("endDate", endDate);
						reqParams.put("filterCndtn", fltrCndtn);
						reqParams.put("msrNoForInstldDscrptr", msrNoForInstldDscrptr);
						reqParams.put("osName", osName);
						reqParams.put("cmpntType", cmpntType);
						reqParams.put("info", info);
						reqParams.put("reqFromPage", reqFromPage);
						
						instledUninstldDtls = ecSoftwareHotfixHandler.getInstldUninstldWithMsrDtls( avlblCmpntNmType, trgtHostOsNm, reqParams);
						if(instledUninstldDtls != null && instledUninstldDtls.size()>0)
						{
							filterByDtls = (ArrayList)instledUninstldDtls.get(0);
						}
					}
					
					// Adding the dashboard details into the session for print/pdf/email
					filterDtlsForSession.put("viewBy",viewBy);
					filterDtlsForSession.put("softwareOrHotfix",softwareOrHotfix);
					filterDtlsForSession.put("cmpntType",mappingInfo.getComponentTypeDescription(cmpntType));
					filterDtlsForSession.put("osName",osName);
					filterDtlsForSession.put("info",info);
					filterDtlsForSession.put("fromDate",startDate);
					filterDtlsForSession.put("toDate",endDate);
					filterDtlsForSession.put("filterByDtls",filterByDtls);
					filterDtlsForSession.put("filterByDtlsForPrint", null);
					filterDtlsForSession.put("timeline",str_ec_timeline);
					filterDtlsForSession.put("ec_userOption",ec_userOption);
					filterDtlsForSession.put("filterBy",filterBy);
					filterDtlsForSession.put("labelFltrCndtn",fltrCndtn);
					filterDtlsForSession.put("labelInstldUnInstld",labelInstldUnInstld);
					filterDtlsForSession.put("avlblCmpntNmType",avlblCmpntNmType);
					filterDtlsForSession.put("showBackButton",showBackButton);
					
					session.setAttribute("SftwrHotfixFilterByInfo", filterDtlsForSession);
					
					//PDf Url
					String mngrIProc = new IniFile(new EgConfigInfo("manager").getDbFile()).getValue("DB_PROPERTIES","ManagerUrl");			
					session.setAttribute("PDF_URL",mngrIProc+"/final/servlet/com.eg.EcConfigurationServletNew;jsessionid="+session.getId()+"?cmd=FilterBySftwrHtfx&reqfrom=printPreview&ec_forPDF=Yes");			
					session.setAttribute("REPORT_NAME",  mappingInfo.getTextDescription("configmgmt.SoftwareHotfix.dashboard.Filter By")+" "+mappingInfo.getTextDescription("configmgmt.SoftwareHotfix.dashboard."+labelSftwrHotfix)+" "+mappingInfo.getTextDescription("configmgmt.SoftwareHotfix.dashboard.Results"));
					session.setAttribute("REPORT_LAYOUT","Portrait");
					session.setAttribute("PAGE_WIDTH_PDF","1100");
					session.setAttribute("PAGE_WIDTH_MAIL_IMAGE","1300");
					session.setAttribute("PAGE_HEIGHT_MAIL_IMAGE","768");
					
					// Json format 
					rootJson.put("softwareList",getFilterGridJsonObj(filterByDtls, softwareOrHotfix, curUser, currentDateFormat, mappingInfo, labelSftwrHotfix, avlblCmpntNmType, filterBy));
					rootJson.put("OsNamesList",getOsNamesJsonObj(trgtHostOsNm,mappingInfo));
					rootJson.put("ComponentTypesList",getAllComponentsTypesJsonObj(trgtHostOsNm, avlblCmpntNmType, osName, mappingInfo));
				}
			}
			populateViewByForZnSrvcSgmnt(rootJson, viewBy, vecUserOptions, ec_userOption, mappingInfo);
			rootJson.put("selectedviewBy",viewBy);
			rootJson.put("viewByList",getCriteriasComboJsonObj(mappingInfo));
			rootJson.put("selectedSoftwareHotfix", softwareOrHotfix);
			rootJson.put("SoftwareHotfixList",getSftwrHtfxComboJsonObj(mappingInfo));
			rootJson.put("selectedComponentType",cmpntType);
			rootJson.put("selectedOsName",osName);
			rootJson.put("selectedInfo",info);
			rootJson.put("selectedFilterBy",filterBy);
			rootJson.put("FilterBySoftwareArr",getFilterBySoftwareComboJsonObj(mappingInfo));
			rootJson.put("FilterByHotfixArr",getFilterByHotfixComboJsonObj(mappingInfo));
			rootJson.put("selectedFltrCndtn",fltrCndtn);
			rootJson.put("reqFrom",str_reqFrom);
			rootJson.put("selectedUserOptionText",ec_userOption);
			rootJson.put("specViewByTitle",viewBy);
			rootJson.put("selectedTimeline",str_ec_timeline);
			rootJson.put("timelineArr",getTimelineComboJsonObj(mappingInfo));
			rootJson.put("HourArr",getHourComboJsonObj());
			rootJson.put("MinsArr",getMinsComboJsonObj());
			rootJson.put("StartDate", (new SimpleDateFormat(currentDateFormat)).format(startDate.getTime()));
			rootJson.put("EndDate",(new SimpleDateFormat(currentDateFormat)).format(endDate.getTime()));
			rootJson.put("StartHr",startDate.get(Calendar.HOUR_OF_DAY));
			rootJson.put("EndHr",endDate.get(Calendar.HOUR_OF_DAY));
			rootJson.put("StartMinute",startDate.get(Calendar.MINUTE));
			rootJson.put("EndMinute",endDate.get(Calendar.MINUTE));
			rootJson.put("dashboardReq",dashboardReq);
			rootJson.put("showBackButton",showBackButton);
			rootJson.put("reqFromPage",reqFromPage);
			
			rootJson.put("success","true");	
		}
		else if(str_reqFrom != null && "tableColumnFilter".equalsIgnoreCase(str_reqFrom))
		{
			String cmpTypClmnFltrCndtn = EgUIUtils.decodeSecurityChar(request.getParameter("COMPONENT_TYPE"));
			String cmpNmClmnFltrCndtn = EgUIUtils.decodeSecurityChar(request.getParameter("COMPONENT_NAME"));
			String osClmnFltrCndtn = EgUIUtils.decodeSecurityChar(request.getParameter("OPERATING_SYSTEM"));
			String sftrHtfxNmClmnFltrCndtn = EgUIUtils.decodeSecurityChar(request.getParameter("SOFTWARE_NAME"));
			String vrsnClmnFltrCndtn = EgUIUtils.decodeSecurityChar(request.getParameter("VERSION"));
			String instlDtClmnFltrCndtn = EgUIUtils.decodeSecurityChar(request.getParameter("INSTALLED_DATE"));
			String whnRprtdClmnFltrCndtn = EgUIUtils.decodeSecurityChar(request.getParameter("Agent_CollectedDate"));
			
			String softwareOrHotfix = request.getParameter("softwareOrHotfix");
			String filterBy = request.getParameter("filterBy");
			
			StringBuilder gvnTblClmnFltrCndtnsAsStr = new StringBuilder();
			
			Map gvnTblClmnFltrCndtns = new HashMap();
			if(cmpTypClmnFltrCndtn != null)
			{
				gvnTblClmnFltrCndtns.put("COMPONENT_TYPE", cmpTypClmnFltrCndtn);
				gvnTblClmnFltrCndtnsAsStr.append("<span class='f12-bold'>" + mappingInfo.getTextDescription("configmgmt.SoftwareHotfix.dashboard.grid.Component type") + "</span><span class='f12-normal'>" + " = " + cmpTypClmnFltrCndtn + "&nbsp;&nbsp;</span>");
			}
			if(cmpNmClmnFltrCndtn != null)
			{
				gvnTblClmnFltrCndtns.put("COMPONENT_NAME", cmpNmClmnFltrCndtn);
				gvnTblClmnFltrCndtnsAsStr.append("<span class='f12-bold'>" + mappingInfo.getTextDescription("configmgmt.SoftwareHotfix.dashboard.grid.Component name") + "</span><span class='f12-normal'>" + " = " + cmpNmClmnFltrCndtn + "&nbsp;&nbsp;</span>");
			}
			if(osClmnFltrCndtn != null)
			{
				gvnTblClmnFltrCndtns.put("OPERATING_SYSTEM", osClmnFltrCndtn);
				gvnTblClmnFltrCndtnsAsStr.append("<span class='f12-bold'>" + mappingInfo.getTextDescription("configmgmt.SoftwareHotfix.dashboard.grid.Operating system") + "</span><span class='f12-normal'>" + " = " + osClmnFltrCndtn + "&nbsp;&nbsp;</span>");
			}
			if(sftrHtfxNmClmnFltrCndtn != null)
			{
				gvnTblClmnFltrCndtns.put("SOFTWARE_NAME", sftrHtfxNmClmnFltrCndtn);
				gvnTblClmnFltrCndtnsAsStr.append("<span class='f12-bold'>" + mappingInfo.getTextDescription("configmgmt.SoftwareHotfix.dashboard.grid.Software name") + "</span><span class='f12-normal'>" + " = " + sftrHtfxNmClmnFltrCndtn + "&nbsp;&nbsp;</span>");
			}
			if(vrsnClmnFltrCndtn != null)
			{
				gvnTblClmnFltrCndtns.put("VERSION", vrsnClmnFltrCndtn);
				gvnTblClmnFltrCndtnsAsStr.append("<span class='f12-bold'>" + mappingInfo.getTextDescription("configmgmt.SoftwareHotfix.dashboard.grid.Version") + "</span><span class='f12-normal'>" + " = " + vrsnClmnFltrCndtn + "&nbsp;&nbsp;</span>");
			}
			if(instlDtClmnFltrCndtn != null)
			{
				gvnTblClmnFltrCndtns.put("INSTALLED_DATE", instlDtClmnFltrCndtn);
				
				if((EcSoftwareHotfixHandler.CONST_CurUnInslldSftwrs.equalsIgnoreCase(filterBy) || (EcSoftwareHotfixHandler.CONST_AllUnInslldSftwrs.equalsIgnoreCase(filterBy))) ||(EcSoftwareHotfixHandler.CONST_CurUnInstldHtfxs.equalsIgnoreCase(filterBy) || (EcSoftwareHotfixHandler.CONST_AllUnInstldHtfxs.equalsIgnoreCase(filterBy))))
				{
					gvnTblClmnFltrCndtnsAsStr.append("<span class='f12-bold'>" + mappingInfo.getTextDescription("configmgmt.SoftwareHotfix.dashboard.grid.Uninstalled date") + "</span><span class='f12-normal'>" + " = " + instlDtClmnFltrCndtn + "&nbsp;&nbsp;</span>");
				}
				else
				{
					gvnTblClmnFltrCndtnsAsStr.append("<span class='f12-bold'>" + mappingInfo.getTextDescription("configmgmt.SoftwareHotfix.dashboard.grid.Installed date") + "</span><span class='f12-normal'>" + " = " + instlDtClmnFltrCndtn + "&nbsp;&nbsp;</span>");
				}				
			}
			if(whnRprtdClmnFltrCndtn != null)
			{
				gvnTblClmnFltrCndtns.put("Agent_CollectedDate", whnRprtdClmnFltrCndtn);
				gvnTblClmnFltrCndtnsAsStr.append("<span class='f12-bold'>" + mappingInfo.getTextDescription("configmgmt.SoftwareHotfix.dashboard.grid.When reported?") + "</span><span class='f12-normal'>" + " = " + whnRprtdClmnFltrCndtn + "&nbsp;&nbsp;</span>");
			}
			
			//System.out.println("gvnTblClmnFltrCndtnsAsStr: " + gvnTblClmnFltrCndtnsAsStr);
			rootJson.put("success","false");	

			Map sftwrHotfixFilterByInfoSesObj = (Map)session.getAttribute("SftwrHotfixFilterByInfo");
			List rsltsToBeFiltered = (sftwrHotfixFilterByInfoSesObj != null) ? ((List)(sftwrHotfixFilterByInfoSesObj).get("filterByDtls")) : null;
			Map avlblCmpntNmType = (sftwrHotfixFilterByInfoSesObj != null) ? ((Map)sftwrHotfixFilterByInfoSesObj.get("avlblCmpntNmType")) : null;
			
			if( (rsltsToBeFiltered != null) && (avlblCmpntNmType != null) )
			{
				EcSoftwareHotfixHandler ecSoftwareHotfixHandler = new EcSoftwareHotfixHandler();
				//System.out.println("avlblCmpntNmType: " + avlblCmpntNmType);
				List fltrdRslts = ecSoftwareHotfixHandler.applyTableColumnFilters(rsltsToBeFiltered, gvnTblClmnFltrCndtns, getUserLanguage(curUser), avlblCmpntNmType, currentDateFormat);
				
				if(sftwrHotfixFilterByInfoSesObj != null)
				{
					filterDtlsForSession = sftwrHotfixFilterByInfoSesObj;
					filterDtlsForSession.put("filterByDtlsForPrint", fltrdRslts);
					filterDtlsForSession.put("gvnTblClmnFltrCndtnsAsStrForPrint", gvnTblClmnFltrCndtnsAsStr.toString());
					
					session.setAttribute("SftwrHotfixFilterByInfo", filterDtlsForSession);
					
					//lables Names
					if(EcSoftwareHotfixHandler.CONST_SOFTWARE.equalsIgnoreCase(softwareOrHotfix))
					{
						labelSftwrHotfix = mappingInfo.getTextDescription("configmgmt.SoftwareHotfix.dashboard.Software");
					}
					else if(EcSoftwareHotfixHandler.CONST_HOTFIX.equalsIgnoreCase(softwareOrHotfix))
					{
						labelSftwrHotfix =mappingInfo.getTextDescription("configmgmt.SoftwareHotfix.dashboard.Hotfix");	
					}
					
					rootJson.put("gridData",((JSONObject)(getFilterGridJsonObj(fltrdRslts, softwareOrHotfix, curUser, currentDateFormat, mappingInfo, labelSftwrHotfix, avlblCmpntNmType, filterBy)).get("gridData")).get("gridData"));
					//rootJson.put("gridFields",((JSONObject)(getFilterGridJsonObj(fltrdRslts, softwareOrHotfix, curUser, currentDateFormat, mappingInfo, labelSftwrHotfix, avlblCmpntNmType, filterBy)).get("gridData")).get("gridFields"));
					rootJson.put("selectedSoftwareHotfix", softwareOrHotfix);
					rootJson.put("selectedFilterBy",filterBy);
					rootJson.put("gvnTblClmnFltrCndtnsAsStrForPrint",gvnTblClmnFltrCndtnsAsStr.toString());
					
					if(cmpTypClmnFltrCndtn != null)
					{
						rootJson.put("COMPONENT_TYPE", cmpTypClmnFltrCndtn);
					}
					if(cmpNmClmnFltrCndtn != null)
					{
						rootJson.put("COMPONENT_NAME", cmpNmClmnFltrCndtn);
					}
					if(osClmnFltrCndtn != null)
					{
						rootJson.put("OPERATING_SYSTEM", osClmnFltrCndtn);
					}
					if(sftrHtfxNmClmnFltrCndtn != null)
					{
						rootJson.put("SOFTWARE_NAME", sftrHtfxNmClmnFltrCndtn);
					}
					if(vrsnClmnFltrCndtn != null)
					{
						rootJson.put("VERSION", vrsnClmnFltrCndtn);
					}
					if(instlDtClmnFltrCndtn != null)
					{
						rootJson.put("INSTALLED_DATE", instlDtClmnFltrCndtn);
					}
					if(whnRprtdClmnFltrCndtn != null)
					{
						rootJson.put("Agent_CollectedDate", whnRprtdClmnFltrCndtn);
					}
					
					rootJson.put("success","true");	
				}
			}
		}			
		
		if(str_reqFrom != null && (("navLink".equals(str_reqFrom)) || ("submit".equals(str_reqFrom))) )
		{
			if(queryString !=null)
			{	
				session.setAttribute("configLastAccessedURL","/final/config/EcSftwrHtfxFilterByIndex.jsp?"+queryString);
			}
			else
			{
				session.setAttribute("configLastAccessedURL","/final/config/EcSftwrHtfxFilterByIndex.jsp?cmd=FilterBySftwrHtfx");
			}
		}
		else
		{
			session.setAttribute("configLastAccessedURL","/final/config/EcSftwrHtfxFilterByIndex.jsp?cmd=FilterBySftwrHtfx");
		}
		
	}
	else
	{
		rootJson.put("success","false");
	}
	out.println(rootJson.toString());
	
%>
	
