<%
/*************************************************************************************
*	Author			:	James Thomas P.
*	Creation Date	:	27th October 2006
*	Purpose			:	UI to display/modify values in eg_services.ini file
*	Design Changes	:	Jaiwin
*	Last Modified	:	July-23-2007		N.Gokulanand	For zone map changes.
**************************************************************************************/
%>

<%@ page errorPage = "EgProbs.jsp"%>
<%@ include file = "EgTrackerA.jsp" %>
<%@ taglib prefix = "egui" uri = "../WEB-INF/eg-taglib.tld" %> 
<%@ page import = "java.text.*"%>
<%@ page import = "com.eg.IniFile"%>
<%@ page import = "com.eg.EgConfigInfo"%>
<%@ page import = "com.eg.EgCrypt" %>
<%@ page import = "com.eg.EgMemInfo"%>
<%@ page import = "egurkha.reporter.*"%>
<%@ page import = "com.eg.EgInstallInfo"%>
<%@ page import = "com.egurkha.EgConstants"%>
<%@ page import = "com.egurkha.util.StringUtils"%>
<%@ page import = "com.egurkha.ini.IniUI"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
%>
<%!
	String subject = "MISC_ARGS";
	ErUtils erUtils = new ErUtils();
%>
<jsp:useBean id="transBean" scope="page" class="egurkha.TransactionBean"/> 
<jsp:useBean id="saveTTIntegBean" scope="page" class="egurkha.TransactionBean"/> 
<jsp:useBean id="trans" scope="page" class="egurkha.TransactionBean"/> 
<jsp:useBean id="managerOutputBean" scope="page" class="egurkha.TransactionBean"/> 
<%
try
{
	String relativeThresholdHours = "";
	String process = request.getParameter("process");
	process = (process == null ?"" :process);
	String from = request.getParameter("from");
	from = (from == null ? "" : from);
	transBean.createFile("eg_services.ini");
	trans.createFile("eg_ui.ini");
	managerOutputBean.createFile("eg_outputstatus.ini");
	String allowpopup = transBean.getStrValue(subject,"ShowUnconfiguredTestsInPopup");
	
	String EnableAuditlog = transBean.getStrValue(subject,"AuditlogEnabled");
	String editHost = trans.getStrValue("TEST_CONFIG_CONTROLS","hostEditable");
	String editPort = trans.getStrValue("TEST_CONFIG_CONTROLS","portEditable");

	String capacityreportenable = transBean.getStrValue("MISC_ARGS","CapacityReportEnabled");
	String capacitytrendenable = transBean.getStrValue("MISC_ARGS","CapacityTrendEnabled");
	
	IniFile egDBIni = new IniFile(EgConfigInfo.egMgrConfigDir+EgConfigInfo.egDbConfigFile);
	
	String managerOutput = managerOutputBean.getStrValue("MANAGER_OUTPUT_STATUS","output");
	String mgrOutputOverWirte = managerOutputBean.getStrValue("MANAGER_OUTPUT_STATUS","manager_output_overwrite");
	String thresholdChkVal = egDBIni.getValue("MANAGER_SETTINGS", "ThresholdCheckPeriod");
	String thresholdChkInterval = egDBIni.getValue("MANAGER_SETTINGS", "ThresholdCheckInterval");
	

	if(!isNull(managerOutput) && (managerOutput.equalsIgnoreCase("yes") || managerOutput.equalsIgnoreCase("y") || managerOutput.equalsIgnoreCase("true") || managerOutput.equalsIgnoreCase("t")))
	{
		managerOutput="yes";
	}
	else
	{
		managerOutput="no";
	}
	if(!isNull(mgrOutputOverWirte) &&( mgrOutputOverWirte.equalsIgnoreCase("yes") || mgrOutputOverWirte.equalsIgnoreCase("y") || mgrOutputOverWirte.equalsIgnoreCase("true") || mgrOutputOverWirte.equalsIgnoreCase("t")))
	{
		mgrOutputOverWirte="yes";
	}
	else
	{
		mgrOutputOverWirte="no";
	}

	/**************************** TT INTEGRATION STARTS *************************/
	String TTIntegrationEnable = "", TTSys = "", TTOtherDispName = "", TTUrl = "", TTUsername = "", TTPassword = "", TTOutput = "", TTWrapper = "", ArchieveFile = "" , TTAddons = "", TTApiKey = "", TTAllowedAlarms = "", TTApiDetails = "", createTicket = "", modifyTicket = "", deleteTicket = "", criticalAlarms = "", majorAlarms = "", minorAlarms = "", normalAlarms = "", add_onsVisibility = "", add_onsDisplay = "", selectSysName = "";

	boolean hasAddOns = false, isDefaultManagerEngineLoaded = false, isOtherLoaded = false;

	TTIntegrationEnable = transBean.getStrValue("TT_INTEGRATION","ENABLE_TT_INTEGRATION");
	TTSys = transBean.getStrValue("TT_INTEGRATION","TT_INTEGRATION_ENABLED_SYSTEM");
	

	selectSysName = request.getParameter("selectSysName");
	if ( !StringUtils.isNull(selectSysName) )
	{
		TTSys=selectSysName;
		TTOtherDispName = transBean.getStrValue("TT_INTEGRATION_OTHERS", "TT_INTEGRATION_SYSTEM_NAME");
		if ( !StringUtils.isNull(TTIntegrationEnable) )
		{
			TTIntegrationEnable = "yes";
		}
	/*	if ( selectSysName.equalsIgnoreCase("managerengine") )
		{
			TTSys = "TT_INTEGRATION_MANAGERENGINE";
		}
		else
		{
			TTSys = "TT_INTEGRATION_OTHERS";
			TTOtherDispName = transBean.getStrValue("TT_INTEGRATION_OTHERS", "TT_INTEGRATION_SYSTEM_NAME");
		}*/
	}
	else
	{
		TTOtherDispName = transBean.getStrValue("TT_INTEGRATION_OTHERS", "TT_INTEGRATION_SYSTEM_NAME");
	}
	String defaultTTSys="TT_INTEGRATION_"+TTSys;
	if ( !StringUtils.isNull(defaultTTSys) )
	{
		if ( (defaultTTSys.toUpperCase()).endsWith("OTHERS") )
		{
			isDefaultManagerEngineLoaded = false;
			isOtherLoaded = true;
		}
		else
		{
			isDefaultManagerEngineLoaded = true;
			isOtherLoaded = false;
		}
	}
	TTOtherDispName = (TTOtherDispName.equalsIgnoreCase("none"))?"":TTOtherDispName;
	TTUrl = transBean.getStrValue(defaultTTSys,"TT_INTEGRATION_SYSTEM_URL");
	TTUsername = transBean.getStrValue(defaultTTSys,"TT_INTEGRATION_SYSTEM_USER");
	TTPassword = transBean.getStrValue(defaultTTSys,"TT_INTEGRATION_SYSTEM_PASSWORD");
	TTOutput = transBean.getStrValue(defaultTTSys,"TT_INTEGRATION_OUTPUT_FORMAT");
	TTWrapper = transBean.getStrValue(defaultTTSys,"TT_INTEGRATION_SYSTEM_WRAPPER");
	ArchieveFile = transBean.getStrValue(defaultTTSys,"TT_INTEGRATION_SYSTEM_ARCHIVE");
	TTAddons = transBean.getStrValue(defaultTTSys,"TT_INTEGRATION_SYSTEM_WRAPPER_ADD_ONS");
	TTApiKey = transBean.getStrValue(defaultTTSys,"TT_INTEGRATION_API_KEY");
	TTApiDetails = transBean.getStrValue(defaultTTSys,"TT_INTEGRATION_API_DETAILS");
	TTAllowedAlarms = transBean.getStrValue(defaultTTSys,"TT_INTEGRATION_ALLOWED_ALARMS");
	if ( !StringUtils.isNull(TTAllowedAlarms) && TTAllowedAlarms.indexOf("Critical") >= 0  )
	{
		criticalAlarms = "checked";
	}
	if ( !StringUtils.isNull(TTAllowedAlarms) && TTAllowedAlarms.indexOf("Major") >= 0  )
	{
		majorAlarms = "checked";
	}
	if ( !StringUtils.isNull(TTAllowedAlarms) && TTAllowedAlarms.indexOf("Minor") >= 0  )
	{
		minorAlarms = "checked";
	}
	if ( !StringUtils.isNull(TTAllowedAlarms) && TTAllowedAlarms.indexOf("Normal") >= 0  )
	{
		normalAlarms = "checked";
	}
	TTUrl = (TTUrl.equalsIgnoreCase("none"))?"":TTUrl;
	TTUsername = (TTUsername.equalsIgnoreCase("none"))?"":TTUsername;
	TTPassword = (TTPassword.equalsIgnoreCase("none"))?"":TTPassword;
	TTOutput = (TTOutput.equalsIgnoreCase("none"))?"":TTOutput;
	TTWrapper = (TTWrapper.equalsIgnoreCase("none"))?"":TTWrapper;
	ArchieveFile = (ArchieveFile.equalsIgnoreCase("none"))?"":ArchieveFile;
	TTAddons = (TTAddons.equalsIgnoreCase("none"))?"":TTAddons;
//TApiKey = (TTApiKey.equalsIgnoreCase("none"))?"":TTApiKey;
	TTAllowedAlarms = (TTAllowedAlarms.equalsIgnoreCase("none"))?"":TTAllowedAlarms;

	if ( !StringUtils.isNull(TTAddons) && TTAddons.length() > 0 )
	{
		hasAddOns = true;
		add_onsVisibility = "visible";
		add_onsDisplay = "block";
	}
	else
	{
		hasAddOns = false;
		add_onsVisibility = "hidden";
		add_onsDisplay = "none";
	}
	/**************************** TT_INTEGRATION ENDS *************************/

	IniFile egExternalIni = new IniFile(EgConfigInfo.egMgrConfigDir+EgConfigInfo.egExtFile);
	String strVirtualMapping = egExternalIni.getValue("MISC","AutoVirtualMapping");
%>
<html>
<head>
<title><egui:intnl text="admin.settings.Manager Settings"/></title>
<!-- <link rel="stylesheet" href="eg_styles/eg_adminstyle.css">  -->
<egui:skin ui="admin"/>
<input type='hidden' id='process' name='process' value='<%=process%>'>
<script language="JavaScript1.2" src="eg_scripts/validate.js"></script>
<script language="JavaScript">
function restartAlert(val)
{
	var message = "";
	var field;
	var field1;
	if(val == 'primary')
	{
		message = 'Are you sure you want to restart the Primary Manager ?';
		field = document.mgrfrm.clusterMgrRestart[0] ;
		field1 = document.mgrfrm.clusterMgrRestart[2] ;
	}
	else if(val == 'secondary')
	{
		message = 'Are you sure you want to restart the Secondary Manager ?';
		field = document.mgrfrm.clusterMgrRestart[1] ;
		field1 = document.mgrfrm.clusterMgrRestart[2] ;
	}
	else if(val == 'standalone')
	{
		message = 'Are you sure you want to restart the eG Manager ?';
		field = document.mgrfrm.stlnMgrRestart[0] ;
		field1 = document.mgrfrm.stlnMgrRestart[1] ;
	}
	
	if(confirm(message))
	{
		field.checked=true;
	}
	else
	{
		field1.checked=true;
	}
}
function changeManagerOutput(val)
{
	var message = "";
	var field;
	if(val == 'on')
	{
		field = document.mgrfrm.mgrOutput[0].checked;
		message = "Are you sure you want to enable the Output & Error ?";
	}
	else
	{
		field = document.mgrfrm.mgrOutput[1].checked;
		message = "Are you sure you want to disable the Output & Error ?";
	}

	if(confirm(message))
	{
		if(val == 'on')
		{
			document.mgrfrm.mgrOutput[0].checked=true;
		}
		else
		{
			document.mgrfrm.mgrOutput[1].checked=true;
		}
	}
	else
	{
		if(val == 'on')
		{
			document.mgrfrm.mgrOutput[1].checked=true;
		}
		else
		{
			document.mgrfrm.mgrOutput[0].checked=true;
		}
	}
}

function showHideTimeFiled(flag)
{
	var id = document.getElementById("hideTimeRow");
	if(flag == "true")
	{
		id.style.display = "";
	}
	else
	{
		id.style.display = "none";
	}
}

function selectValues(rth)
{
	temp = rth.substring(0,rth.indexOf('-'));
	val1 = temp.substring(0,temp.indexOf(":"));
	val2 = temp.substring(temp.indexOf(":")+1);
	temp = rth.substring(rth.indexOf('-')+1);
	val3 = temp.substring(0,temp.indexOf(":"));
	val4 = temp.substring(temp.indexOf(":")+1);

	document.mgrfrm.timefrom.options[parseInt(val1,10)].selected = true;
	document.mgrfrm.minfrom.options[parseInt(val2,10)].selected = true;
	document.mgrfrm.timeto.options[parseInt(val3,10)].selected = true;
	document.mgrfrm.minto.options[parseInt(val4,10)].selected = true;

	document.mgrfrm.$_relativeThresholdTime.value = 'Hours for which relative thresholds are computed$From : ' + document.mgrfrm.timefrom.value + ' Hrs ' + document.mgrfrm.minfrom.value + ' Mins  To : ' + document.mgrfrm.timeto.value + ' Hrs ' + document.mgrfrm.minto.value +' Mins';
}

function isAValidNumber(val)
{
	validFigures = '0123456789';
	if(val.length > 1 && val.indexOf('0')==0)
		return "false";
	if(val.length==0)
		return "false";
	for (i=0; i<val.length; i++)
	{
		if (validFigures.indexOf(val.charAt(i),0) == -1) 
		{
			return "false";
		}
	}
	return "true";
}
var noFileToUpload = false;
function validateTextBoxes(str)
{
	var strValue = str;
	var thisForm = document.mgrfrm;
	var res = "true";
	var temp="";
	if(strValue == "" || strValue == "general")
	{
		if(isAValidNumber(thisForm.TrendMgrThreads.value)=="false")
		{	
			alert('<egui:intnl text="admin.settings.Number of threads for trend computation should be a valid positive integer"/>');
			thisForm.TrendMgrThreads.focus();
			res="false";
			return;
		}
		if(isAValidNumber(thisForm.ThresholdMgrThreads.value)=="false")
		{	
			alert('<egui:intnl text="admin.settings.Number of threads for threshold computation should be a valid positive integer"/>');
			thisForm.ThresholdMgrThreads.focus();
			res="false";
			return;
		}
		if(isAValidNumber(thisForm.ThresholdRunDuration.value)=="false")
		{	
			alert('<egui:intnl text="admin.settings.How frequently thresholds are computed (mins) should be a valid positive integer"/>');
			thisForm.ThresholdRunDuration.focus();
			res="false";
			return;
		}
		if(isAValidNumber(thisForm.ThresholdAdjustPeriod.value)=="false")
		{	
			alert('<egui:intnl text="admin.settings.Data period that is used for sliding-window thresholds should be a valid positive integer"/>');
			thisForm.ThresholdAdjustPeriod.focus();
			res="false";
			return;
		}
		//Commented by Nagarajan -Dont need it now that Audit log is enabled
	/*	if(isAValidNumber(thisForm.AccessLogMaxSize.value)=="false")
		{	
			alert('<egui:intnl text="admin.settings.Max size of the access log (MB) should be a valid positive integer"/>');
			thisForm.AccessLogMaxSize.focus();
			res="false";
			return;
		}
	*/
		/*if(isAValidNumber(thisForm.SystemStateCheckPeriod.value)=="false")
		{	
			alert('<egui:intnl text="Time between system state check for SNMP trap generation (mins) should be a valid positive integer"/>');
			thisForm.SystemStateCheckPeriod.focus();
			res="false";
			return;
		}*/
		/*if(isAValidNumber(thisForm.DesktopAgentReportingDuration.value)=="false")
		{	
			alert('<egui:intnl text="Time between desktop agent reports (hrs) should be a valid positive integer"/>');
			thisForm.DesktopAgentReportingDuration.focus();
			res="false";
			return;
		}	
		if(isAValidNumber(thisForm.DesktopAgentRunningDuration.value)=="false")
		{	
			alert('<egui:intnl text="Mark desktop agents as not running after (hrs) should be a valid positive integer"/>');
			thisForm.DesktopAgentRunningDuration.focus();
			res="false";
			return;
		}*/	

		if(parseInt((fromtime+frommin),10) >= parseInt((totime+tomin),10))
		{
			alert('<egui:intnl text="admin.settings.From time should be less than To time"/>');
			return;
		}
		if(parseInt(totime)==24)
		{
			if(parseInt(tomin,10) > 0)
			{
				alert('<egui:intnl text="admin.settings.Minute selection is not allowed for 24 hrs"/>');
				return;
			}
		}
	
		var fromtime = thisForm.timefrom.value;
		var frommin = thisForm.minfrom.value;
		var totime = thisForm.timeto.value;
		var tomin = thisForm.minto.value;
	
		temp = fromtime + ":" + frommin + "-" + totime + ":" + tomin;
		thisForm.RelativeThresholdHours.value = temp;
		
	}

	if(strValue == "" || strValue == "testconfig")
	{
		res="true";
	}
	if(strValue == "" || strValue == "logsettings")
	{
		res="true";
	}
	if(strValue == "" || strValue == "discompopup")
	{
		var popup = thisForm.DiscCompsFlag[0].checked;
		if(popup)
		{
			if(thisForm.hidetime.value == "")
			{
				//res="true";
				alert('<egui:intnl text="admin.settings.please enter a value for Pop-up timeout period (mins)"/>');
				thisForm.hidetime.focus();
				res="false";
				return;


			}
			else if(isAValidNumber(thisForm.hidetime.value)=="false")
			{
				alert('<egui:intnl text="admin.settings.Pop-up timeout period (mins) should be a numeric"/>');
				thisForm.hidetime.focus();
				res="false";
				return;
			}
		}
	}
	if(strValue == "" || strValue == "ttmanagercli")
	{
		if(thisForm.Command2!=null && !checkblank(thisForm.Command2))
		{
			alert('<egui:intnl text="admin.Command"/> Cannot be blank');
			thisForm.Command2.focus();
			res="false";
			return;
		}
		if(thisForm.Command!=null && !checkblank(thisForm.Command2))
		{
			alert('<egui:intnl text="admin.Command Arguments"/> Cannot be blank');
			thisForm.Command2.focus();
			res="false";
			return;
		}
		if(thisForm.LogFileMaxSize!=null && isAValidNumber(thisForm.LogFileMaxSize.value)=="false")
		{
			alert('<egui:intnl text="admin.ui.Log File Maximum Size should be a valid positive integer"/>');
			thisForm.LogFileMaxSize.focus();
			res="false";
			return;
		}
		if(thisForm.LogFileMaxSize!=null && parseInt(thisForm.LogFileMaxSize.value)<=0)
		{
			alert('<egui:intnl text="admin.ui.Log File Maximum Size should be greater than zero"/>');
			thisForm.LogFileMaxSize.focus();
			res="false";
			return;
		}
		if(thisForm.CommandLength!=null && isAValidNumber(thisForm.CommandLength.value)=="false")
		{
			alert('<egui:intnl text="admin.ui.Command length should be a valid positive integer"/>');
			thisForm.CommandLength.focus();
			res="false";
			return;
		}
		if(thisForm.ProbDescLength!=null && isAValidNumber(thisForm.ProbDescLength.value)=="false")
		{
			alert('<egui:intnl text="admin.ui.Problem Description length should be a valid positive integer"/>');
			thisForm.ProbDescLength.focus();
			res="false";
			return;
		}
		if(thisForm.AllowedAlarms!=null && thisForm.AllowedAlarms[0].checked==false && thisForm.AllowedAlarms[1].checked==false && thisForm.AllowedAlarms[2].checked==false && thisForm.AllowedAlarms[3].checked==false)
		{
			alert('<egui:intnl text="admin.ui.Please choose allowed alarms"/>');
			res="false";
			return;
		}
		var TT_IntegrationObj = document.getElementById('TT_Integration');
		if ( TT_IntegrationObj != null && TT_IntegrationObj != undefined && TT_IntegrationObj != "undefined" && TT_IntegrationObj.style.visibility == 'visible' && TT_IntegrationObj.style.display == 'block' )
		{

			if ( thisForm.TT_sys != null && thisForm.TT_sys.value == 'Others' && thisForm.TT_Other.value == '' )
			{
				alert('<egui:intnl text="admin.ui.System name"/> cannot be blank');
				thisForm.TT_Other.focus();
				res = "false";
				return;

			}
			if ( thisForm.TT_Url != null && thisForm.TT_Url.value == '' )
			{
				alert('<egui:intnl text="admin.ui.URL"/> cannot be blank');
				thisForm.TT_Url.focus();
				res = "false";
				return;
			}
			if ( thisForm.TT_User_Name != null && thisForm.TT_User_Name.value == '' )
			{
				alert('<egui:intnl text="admin.ui.User name"/> cannot be blank');
				thisForm.TT_User_Name.focus();
				res = "false";
				return;
			}
			if ( thisForm.TT_Password != null && thisForm.TT_Password.value == '' )
			{
				alert('<egui:intnl text="admin.ui.Password"/> cannot be blank');
				thisForm.TT_Password.focus();
				res = "false";
				return;
			}
			if ( thisForm.TT_Output != null && thisForm.TT_Output.value == '' )
			{
				alert('<egui:intnl text="admin.ui.Output fields"/> cannot be blank');
				thisForm.TT_Output.focus();
				res = "false";
				return;
			}
			var ttWrapperClassNeededObj = document.getElementById('ttWrapperClassNeeded');
			if(ttWrapperClassNeededObj!=null && ttWrapperClassNeededObj!="undefined")
			{
				var selectedTTWrapperOption="no";
				if (ttWrapperClassNeededObj.checked)
				{
					selectedTTWrapperOption=ttWrapperClassNeededObj.value;
				}
				
				if(selectedTTWrapperOption.toLowerCase()=="yes")
				{
					if ( thisForm.ArchieveFile != null && thisForm.ArchieveFile.value == '' )
					{
						alert('<egui:intnl text="admin.ui.Please Upload TT Integration archieve file"/> ');
						thisForm.uploadArchieveFileBtn.focus();
						res = "false";
						return;
					}
				/*	else if ( thisForm.ArchieveFile != null && thisForm.ArchieveFile.value != '' )
					{
						var existingArchieveFile='<%=ArchieveFile%>';
						if(existingArchieveFile!=null && thisForm.ArchieveFile.value!=existingArchieveFile)
						{
							var result = confirm('<egui:intnl text="admin.ui.TT Integration Archieve file name should be same as Main Wrapper Class name"/>.<egui:intnl text="admin.settings.Do you want to continue"/>?', 'Yes', 'No');
							if ( !result )
							{
								return;
							}
						}
					}*/
			}
			}
			if ( thisForm.TT_Api_Key != null && thisForm.TT_Api_Key.value == '' )
			{
				alert('<egui:intnl text="admin.ui.API key"/> cannot be blank');
				thisForm.TT_Api_Key.focus();
				res = "false";
				return;
			}
			/*if ( thisForm.createTicTxt != null && thisForm.createTicTxt.value == '' )
			{
				alert('<egui:intnl text="admin.ui.Create Ticket"/> Cannot be blank');
				thisForm.createTicTxt.focus();
				res = "false";
				return;
			}
			else if ( thisForm.createTicTxt != null && thisForm.createTicTxt.value == '$Unconfigured' )
			{
				alert('<egui:intnl text="admin.ui.Please configure Create Ticket"/>');
				thisForm.createTicTxt.select();
				thisForm.createTicTxt.focus();
				res = "false";
				return;
			}
			if ( thisForm.modifyTicTxt != null && thisForm.modifyTicTxt.value == '' )
			{
				alert('<egui:intnl text="admin.ui.Modify Ticket"/> Cannot be blank');
				thisForm.modifyTicTxt.focus();
				res = "false";
				return;
			}
			else if ( thisForm.modifyTicTxt != null && thisForm.modifyTicTxt.value == '$Unconfigured' )
			{
				alert('<egui:intnl text="admin.ui.Please configure Modify Ticket"/>');
				thisForm.modifyTicTxt.select();
				thisForm.modifyTicTxt.focus();
				res = "false";
				return;
			}
			if ( thisForm.deleteTicTxt != null && thisForm.deleteTicTxt.value == '' )
			{
				alert('<egui:intnl text="admin.ui.Delete Ticket"/> Cannot be blank');
				thisForm.deleteTicTxt.focus();
				res = "false";
				return;
			}
			else if ( thisForm.deleteTicTxt != null && thisForm.deleteTicTxt.value == '$Unconfigured' )
			{
				alert('<egui:intnl text="admin.ui.Please configure Modify Ticket"/>');
				thisForm.deleteTicTxt.select();
				thisForm.deleteTicTxt.focus();
				res = "false";
				return;
			}*/
		}
	}
	if(strValue == "" || strValue == "commandexecution")
	{
		if(thisForm.Log_maxsize!=null && isAValidNumber(thisForm.Log_maxsize.value)=="false")
		{
			alert('<egui:intnl text="admin.ui.Log File Maximum Size should be a valid positive integer"/>');
			thisForm.Log_maxsize.focus();
			res="false";
			return;
		}
		if(thisForm.Command_length!=null && isAValidNumber(thisForm.Command_length.value)=="false")
		{
			alert('<egui:intnl text="admin.ui.Command length should be a valid positive integer"/>');
			thisForm.Command_length.focus();
			res="false";
			return;
		}
	}
	if(strValue == "" || strValue == "auditing")
	{
		res="true";
	}
	if(strValue == "" || strValue == "thresholdconfig")
	{
		if(thisForm.thresholdCheckPeriod!=null && isAValidNumber(thisForm.thresholdCheckPeriod.value)=="false")
		{
			alert('<egui:intnl text="admin.settings.Lookback period to compute automatic thresholds should be a valid positive integer"/>');
			thisForm.LogFileMaxSize.focus();
			res="false";
			return;
		}
		if(thisForm.thresholdCheckPeriod != null && parseInt(thisForm.thresholdCheckPeriod.value)<=0)
		{
			alert('<egui:intnl text="admin.settings.Lookback period to compute automatic thresholds should be greater than zero"/>');
			thisForm.thresholdCheckPeriod.focus();
			res="false";
			return;
		}
	}
	if(strValue == "" || strValue == "advancedmgrsettings")
	{
		res="true";
	}
	if(res=="true")
	{
		thisForm.update.value='<egui:intnl text="admin.common.Updating"/>...';
		thisForm.submit();
	}
}

function callAudit()
{
	var thisForm = document.mgrfrm;
	if (thisForm.EnableAuditlog[1].checked)
	{
		document.getElementById('showCLI').style.display = 'none';
	}
	else
	{
		document.getElementById('showCLI').style.display = '';
	}
}
function uploadWrapper( param )
{
	var uploadWin = null;
	
	if ( uploadWin == null || uploadWin == undefined )
	{
		uploadWin = window.open('/final/admin/uploadWrapper.jsp?uploadType='+param,'Upload','width=450,height=230,scrollbars=yes,resizable=yes');	
		uploadWin.focus();
	}
	else
	{
		uploadWin.focus();
	}
}
function checkTTWrapperClassNeeded( flag )
{
	var ttWrapperClassNeededObj = document.getElementById('ttWrapperClassNeeded');
//	var ArchieveFile = document.getElementById('ArchieveFile').value;
	var uploadDivObj = document.getElementById('uploadDiv');
	var ttMainWrapperClassDisplayDivObj = document.getElementById('ttMainWrapperClassDisplay');
	if ( flag != null && flag == 'Yes' )
	{
		if(uploadDivObj!=null && uploadDivObj!="undefined")
			uploadDivObj.style.display = 'block';

		if(ttMainWrapperClassDisplayDivObj!=null && ttMainWrapperClassDisplayDivObj!="undefined")
			ttMainWrapperClassDisplayDivObj.style.display = 'block';
	}
	else if ( flag != null && flag == 'No' )
	{
		if(uploadDivObj!=null && uploadDivObj!="undefined")
			uploadDivObj.style.display = 'none';

		if(ttMainWrapperClassDisplayDivObj!=null && ttMainWrapperClassDisplayDivObj!="undefined")
			ttMainWrapperClassDisplayDivObj.style.display = 'none';
	}
}
function removeArchieveFile( fileName )
{
	var thisForm = document.mgrfrm;
	var ArchieveFile = document.getElementById('ArchieveFile');
	var result = confirm('<egui:intnl text="admin.settings.Do you want to delete"/> '+fileName+' file ', 'Yes', 'No');
	if ( !result )
	{
		return;
	}
	var tmpXmlhttp;
	if ( window.XMLHttpRequest )
	{// code for IE7+, Firefox, Chrome, Opera, Safari
		tmpXmlhttp=new XMLHttpRequest();
	}
	else
	{// code for IE6, IE5
		tmpXmlhttp=new ActiveXObject("Microsoft.XMLHTTP");
	}
	try
	{
		if ( tmpXmlhttp != null && tmpXmlhttp != undefined )
		{
			tmpXmlhttp.open("GET","/final/admin/uploadWrapperp.jsp?action=remove&ArchieveFile=None&file="+fileName+"&cacheCur="+new Date().getTime(),false);
			tmpXmlhttp.send();
			var ttMainWrapperClassDisplay = document.getElementById('ttMainWrapperClassDisplay');
			ttMainWrapperClassDisplay.innerHTML="";
			ttMainWrapperClassDisplay.style.display="none";
			var radCtrls=thisForm.ttWrapperClassNeeded;
			if(radCtrls!=null && radCtrls!="undefined")
			{
				for(var r=0;r<radCtrls.length;r++)
				{
					var rctrl=radCtrls[r];
					if(rctrl!=null && rctrl!="undefined")
					{
						var optionVal=rctrl.value;
						if(optionVal!=null && optionVal.toLowerCase()=="no")
						{
							rctrl.checked=true;
						}
					}
				}
			}
			ArchieveFile.value="";
			mainWrapperClass.value="";
		}
	}
	catch ( e )
	{
		alert('[Exception] '+e);
	}
	
}
function checkTTIntegration( flag )
{
	var TT_IntegrationObj = document.getElementById('TT_Integration');
	if ( flag )
	{
		TT_IntegrationObj.style.visibility = 'visible';
		TT_IntegrationObj.style.display = 'block';
	}
	else
	{
		TT_IntegrationObj.style.visibility = 'hidden';
		TT_IntegrationObj.style.display = 'none';
	}
}
function callOthers()
{
	/*var TT_Other_DivObj = document.getElementById('TT_Other_Div');
	if ( mgrfrm.TT_sys != null && mgrfrm.TT_sys.value == 'Others' )
	{
		TT_Other_DivObj.style.visibility = 'visible';
		TT_Other_DivObj.style.display = 'block';
	}
	else
	{
		TT_Other_DivObj.style.visibility = 'hidden';
		TT_Other_DivObj.style.display = 'none';
	}*/
	window.location.href = '/final/admin/managerSettings.jsp?process=ttmanagercli&selectSysName='+mgrfrm.TT_sys.value;
}
function deleteTTIntegrationConfig()
{
	var result = confirm('<egui:intnl text="admin.settings.Do you want to delete this configuration"/>?','Yes','No');
	if(!result)
		return;

	var thisForm = document.mgrfrm;
	var actionHiddenObj=thisForm.action;
	actionHiddenObj.value="removeTTIntegrationConfiguration";
	//thisForm.update.value='<egui:intnl text="admin.common.Updating"/>...';
	thisForm.submit();
}
</script>
</head>
<!-- <body leftmargin="0" topmargin="20" marginwidth="0" marginheight="20" bgcolor="#FFFFFF"> -->
<%
	if(process.equals("") || process.equals("auditing"))
	{
%>
		<body style="overflow:auto" id="space6" scroll="auto" onload="javascript:callAudit()">
<%
	}
	else
	{
%>
		<body style="overflow:auto" id="space6" scroll="auto">
<%
	}
%>
<form name="mgrfrm" method="POST" action="managerSettingsp.jsp?process=<%=process%>&from=<%=from%>" style="margin:0px">
<!-- HEADER STARTS HERE -->
<table border="0" align="center" cellspacing="0" cellpadding="0" width="100%" >
	<jsp:include page="listSearch.jsp?title=MANAGER SETTINGS&leftString=Add User&subtitle=false"/>
	<tr>
		<td width="100%" id="eg_whitebg" align="center" height="100%" valign="top" >
			<table align="center" cellspacing="0" cellpadding="2" width="85%" border="0" >
<%
	if(process.equals("") || process.equals("general"))
	{
%>
				<tr>
					<td align="center">
						<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" style="table- layout:fixed" class="eg_subcontentbg"><col width="43%"><col width="15"><col width="57%">
							<tr>
								<td colspan="3">
									<table cellspacing="0" cellpadding="0" width="100%" border="0" height="22">
										<tr>
											<td id="subhead_left" width="7"> <img src="/final/admin/eg_images/spacer.gif" border="0" width="7"> </td>
											<td id="eg_subheadbg" style="border-left-width: 0px; border-right-width: 0px;" align="center" width="100%"> <strong><egui:intnl text="admin.settings.General"/></strong> </td>
											<td id="subhead_right" width="7"> <img src="/final/admin/eg_images/spacer.gif" border="0" width="7"> </td>
										</tr>
									</table>
								</td>
							</tr>
							<tr>
								<th class="form_border" nowrap >
									<egui:intnl text="admin.settings.Compute average/sum of metrics while trending"/></th>
								<td class="form_border" nowrap > &nbsp;:</td>
								<td class="form_border" nowrap >
<%
	String avgSumTrends = transBean.getStrValue(subject,"AvgSumTrends");
%>
									<table  width="30%" cellspacing="0" cellpadding="0" border="0">
										<tr>
											<td id="eg_subcontentbg" class="eg_subcontent" width="20">
												<input type="radio" class="eg_input"name="AvgSumTrends" value="Yes" <%=avgSumTrends.equalsIgnoreCase("Yes") ? "checked":""%>>
											</td>
											<td><egui:intnl text="admin.common.Yes"/></td>
											<td id="eg_subcontentbg" class="eg_subcontent" width="20">
												<input type="radio"class="eg_input" name="AvgSumTrends" value="No" <%=avgSumTrends.equalsIgnoreCase("No") ? "checked":""%>>
											</td>
											<td><egui:intnl text="admin.common.No"/></td>
										</tr>
									</table>
								</td>
							</tr>
							<input type='hidden' name='$_AvgSumTrends' value='Compute average/sum of metrics while trending$<%=avgSumTrends.equalsIgnoreCase("Yes")?"Yes":"No"%>'>
							<tr>
<%
	String trendMgrThreads = transBean.getStrValue(subject,"TrendMgrThreads");
	if (isNull(trendMgrThreads))
	{
		trendMgrThreads = EgConstants.BLANK_STRING;
	}
%>
								<th class="form_border" nowrap ><egui:intnl text="admin.settings.Number of threads for trend computation"/></th>
								<td class="form_border" nowrap > &nbsp;:</td>
								<td class="form_border" nowrap>&nbsp;&nbsp;<input type='text' name='TrendMgrThreads'  value="<%=trendMgrThreads%>" maxlength="256" style="width: 350px; "></td>
							</tr>
								<input type='hidden' name='$_TrendMgrThreads' value='Number of threads for trend computation$<%=trendMgrThreads%>'>
							<tr>
	<%
		String thresholdMgrThreads = transBean.getStrValue(subject,"ThresholdMgrThreads");
		if (isNull(thresholdMgrThreads))
		{
			thresholdMgrThreads = EgConstants.BLANK_STRING;
		}
	%>
								<th class="form_border" nowrap ><egui:intnl text="admin.settings.Number of threads for threshold computation"/></th>
								<td class="form_border" nowrap> &nbsp;:</td>
								<td class="form_border" nowrap>&nbsp;&nbsp;<input type='text' name='ThresholdMgrThreads'  value="<%=thresholdMgrThreads%>" maxlength="256" style="width: 350px;"></td>
							</tr>
								<input type='hidden' name='$_ThresholdMgrThreads' value='Number of threads for threshold computation$<%=thresholdMgrThreads%>'>
							<tr>
<%
		String thresholdRunDuration = transBean.getStrValue(subject,"ThresholdRunDuration");
		if (isNull(thresholdRunDuration))
		{
			thresholdRunDuration = EgConstants.BLANK_STRING;
		}
%>
								<th class="form_border"  nowrap ><egui:intnl text="admin.settings.How frequently thresholds are computed (mins)"/></th>
								<td class="form_border" nowrap > &nbsp;:</td>
								<td class="form_border" nowrap>&nbsp;&nbsp;<input type='text' name='ThresholdRunDuration'  value="<%=thresholdRunDuration%>" maxlength="256" style="width: 350px;"></td>
							</tr>
								<input type='hidden' name='$_ThresholdRunDuration' value='How frequently thresholds are computed (mins)$<%=thresholdRunDuration%>'>
							<tr>
<%
		String thresholdAdjustPeriod = transBean.getStrValue(subject,"ThresholdAdjustPeriod");
		if (isNull(thresholdAdjustPeriod))
		{
			thresholdAdjustPeriod = EgConstants.BLANK_STRING;
		}
%>
								<th class="form_border" nowrap ><egui:intnl text="admin.settings.Data period that is used for sliding-window thresholds"/></th>
								<td class="form_border" nowrap > &nbsp;:</td>
								<td class="form_border" nowrap>&nbsp;&nbsp;<input type='text' name='ThresholdAdjustPeriod'  value="<%=thresholdAdjustPeriod%>" maxlength="256" style="width: 350px;"></td>
							</tr>
								<input type='hidden' name='$_ThresholdAdjustPeriod' value='Data period that is used for sliding-window thresholds$<%=thresholdAdjustPeriod%>'>
							<tr>
<%
		relativeThresholdHours = transBean.getStrValue(subject,"RelativeThresholdHours");
		if (isNull(relativeThresholdHours))
		{
			relativeThresholdHours = EgConstants.BLANK_STRING;
		}
%>
								<th class="form_border" nowrap ><egui:intnl text="admin.settings.Hours for which relative thresholds are computed"/></th>
								<td class="form_border" nowrap > &nbsp;:</td>
								<td class="form_border" nowrap><input type='hidden' name="RelativeThresholdHours" value="<%=relativeThresholdHours%>">
									<table  width="100%" border="0" cellpadding="0"  cellspacing="0">
										<tr>
											<td>&nbsp;&nbsp;<egui:intnl text="admin.common.From"/></td>
											<td><select	 name="timefrom" >
<%
		NumberFormat formatter = new DecimalFormat("00");
		for(int i=0;i<=23;i++)
		{
%>
												<option value="<%=formatter.format(i)%>"><%=formatter.format(i)%></option>
<%
		}
%>
												</select>&nbsp;<egui:intnl text="admin.common.Hrs"/></td>
											<td><select name="minfrom" >
<%
		for(int i=0;i<=59;i++)
		{
%>
														<option value="<%=formatter.format(i)%>"><%=formatter.format(i)%></option>
<%
		}
%>
												</select>&nbsp;<egui:intnl text="admin.common.Mins"/></td>
											<td id="eg_blankspace" width="10">&nbsp;</td>
											<td><egui:intnl text="admin.common.To"/></td>
											<td><select	 name="timeto">
<%
		for(int i=0;i<=24;i++)
		{
%>
														<option value="<%=formatter.format(i)%>"><%=formatter.format(i)%></option>
<%
		}
%>
												</select>&nbsp;<egui:intnl text="admin.common.Hrs"/></td>
											<td><select	 name="minto" >
<%
		for(int i=0;i<=59;i++)
		{
%>
														<option value="<%=formatter.format(i)%>"><%=formatter.format(i)%></option>		
<%
		}
%>
												</select>&nbsp;<egui:intnl text="admin.common.Mins"/> 
											</td>
										</tr>
									</table>
								</td>
							</tr>
							<script language="JavaScript">
								//selectValues('<%=relativeThresholdHours%>');
							</script>
							<tr>
								<th class="form_border"  nowrap ><egui:intnl text="admin.settings.Automatically map IP address of agents to nick names"/></th>
								<td class="form_border" nowrap > &nbsp;:</td>
								<td class="form_border" nowrap>
<%
		String autoIpNameCheck = transBean.getStrValue(subject,"AutoIpNameCheck");
%>
									<table  width="30%" cellspacing="0" cellpadding="0" border="0">
										<tr>
											<td id="eg_subcontentbg" class="eg_subcontent" width="20">
												<input type="radio"class="eg_input" name="AutoIpNameCheck" value="Yes" <%=autoIpNameCheck.equalsIgnoreCase("Yes") ? "checked":""%>>
											</td>
											<td>
												<egui:intnl text="admin.common.Yes"/>
											</td>
											<td id="eg_subcontentbg" class="eg_subcontent" width="20" >
												<input type="radio" class="eg_input"name="AutoIpNameCheck" value="No" <%=autoIpNameCheck.equalsIgnoreCase("No") ? "checked":""%>>
											</td>
											<td>
												<egui:intnl text="admin.common.No"/>
											</td>
										</tr>
									</table>
								</td>
							</tr>
							<input type='hidden' name='$_AutoIpNameCheck' value='Identify agents only using nick names$<%=autoIpNameCheck.equalsIgnoreCase("Yes")?"Yes":"No"%>'>
							<tr>
								<th class="form_spacing"  nowrap ><egui:intnl text="admin.settings.Verify if agent is reporting from configured IP"/></th>
								<td class="form_spacing" nowrap > &nbsp;:</td>
								<td class="form_spacing" nowrap>
									<%  String nickIpCheck = transBean.getStrValue(subject,"NickIpCheck"); %>
									<table  width="30%" cellspacing="0" cellpadding="0" border="0">
										<tr>
											<td id="eg_subcontentbg" class="eg_subcontent" width="20">
												<input type="radio" class="eg_input"name="NickIpCheck" value="Yes" <%=nickIpCheck.equalsIgnoreCase("Yes") ? "checked":""%>>
											</td>
											<td>
												<egui:intnl text="admin.common.Yes"/>
											</td>
											<td id="eg_subcontentbg" class="eg_subcontent" width="20">
												<input type="radio" class="eg_input"name="NickIpCheck" value="No" <%=nickIpCheck.equalsIgnoreCase("No") ? "checked":""%>>
											</td>
											<td>
												<egui:intnl text="admin.common.No"/>
											</td>
										</tr>
									</table>
								</td>
							</tr>
							<input type='hidden' name='$_NickIpCheck' value='Verify if agent is reporting from configured IP$<%=nickIpCheck.equalsIgnoreCase("Yes")?"Yes":"No"%>'>
							<tr>
								<td colspan="3">
									<table cellspacing="0" cellpadding="0" width="100%" border="0">
										<tr>
											<td height="6" id="inner_bott_left" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7" height="6" border="0"></td>
											<td id="eg_subcontentbg"  width="100%" valign="top" ><img src="/final/admin/eg_images/spacer.gif" height="6" border="0"></td>
											<td height="6" align="right" id="inner_bott_right" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7px" height="6px" border="0"></td>
										</tr>
									</table>
								</td>
							</tr>
						</table>
					</td>
				</tr>
				<tr><td align="center" colspan="3" id="eg_blankspace" height="8">&nbsp;</td></tr>
<%
	}
	if(process.equals("") || process.equals("testconfig"))
	{
%>
				<tr>
					<td align="center">
						<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" style="table- layout:fixed" class="eg_subcontentbg"><col width="43%"><col width="15"><col width="57%">
							<tr>
								<td colspan="3">
									<table cellspacing="0" cellpadding="0" width="100%" border="0" height="22">
										<tr>
											<td id="subhead_left" width="7">
												<img src="/final/admin/eg_images/spacer.gif" border="0" width="7">
											</td>
											<td id="eg_subheadbg" style="border-left-width: 0px; border-right-width: 0px;" align="center" width="100%">
												<strong><egui:intnl text="admin.settings.Test Configuration"/></strong> 
											</td>
											<td id="subhead_right" width="7">
												<img src="/final/admin/eg_images/spacer.gif" border="0" width="7">
											</td>
										</tr>
									</table>
								</td>
							</tr>
							<tr>
								<th class="form_border" nowrap><egui:intnl text="admin.settings.Pop up list of unconfigured tests"/></th>
								<td class="form_border" nowrap >&nbsp;:</td>

								<td class="form_border" nowrap>
									<table  width="30%" cellspacing="0" cellpadding="0" border="0">
										<tr>
											<td id="eg_subcontentbg" class="eg_subcontent" width="20">
												<input type="radio" class="eg_input" name="allowpopup" value="true" <%=allowpopup.equalsIgnoreCase("true")?"checked":""%> >
											</td>
											<td><egui:intnl text="admin.common.Yes"/></td>
											<td id="eg_subcontentbg" class="eg_subcontent" width="20">
												<input type="radio" class="eg_input" name="allowpopup" value="false" <%=allowpopup.equalsIgnoreCase("false")?"checked":""%> >
											</td>
											<td><egui:intnl text="admin.common.No"/></td>
										</tr>
									</table>
								</td>
							</tr>
							<input type='hidden' name='$_allowpopup' value='Pop up list of unconfigured tests$<%=allowpopup.equalsIgnoreCase("true")?"true":"false"%>'>
							<tr>
								<th class="form_spacing" nowrap><egui:intnl text="admin.settings.Is host editable"/>?</th>
								<td class="form_spacing" nowrap>&nbsp;:</td>

								<td class="form_spacing" nowrap>
									<table  width="30%" cellspacing="0" cellpadding="0" border="0">
										<tr>
											<td id="eg_subcontentbg" class="eg_subcontent" width="20">
												<input type="radio" class="eg_input" name="EditHost" value="true" <%=editHost.equalsIgnoreCase("true")?"checked":""%> >
											</td>
											<td><egui:intnl text="admin.common.Yes"/></td>
											<td id="eg_subcontentbg" class="eg_subcontent" width="20">
												<input type="radio" class="eg_input" name="EditHost" value="false" <%=editHost.equalsIgnoreCase("false")?"checked":""%> >
											</td>
											<td><egui:intnl text="admin.common.No"/></td>
										</tr>
									</table>
								</td>
							</tr>
							<input type='hidden' name='$_EditHost' value='Is host editable$<%=editHost.equalsIgnoreCase("true")?"true":"false"%>'>
<!-- 							<tr>
								<th class="form_border" style="border-bottom-width:0px" nowrap><egui:intnl text="admin.settings.Is port editable"/>?</th>
								<td class="form_border" nowrap style="border-bottom-width:0px">&nbsp;:</td>

								<td class="form_border" style="border-bottom-width:0px" nowrap>
									<table  width="30%" cellspacing="0" cellpadding="0" border="0">
										<tr>
											<td id="eg_subcontentbg" class="eg_subcontent" width="20">
												<input type="radio" class="eg_input" name="EditPort" value="true" <%//=editPort.equalsIgnoreCase("true")?"checked":""%> >
											</td>
											<td><egui:intnl text="admin.common.Yes"/></td>
											<td id="eg_subcontentbg" class="eg_subcontent" width="20">
												<input type="radio" class="eg_input" name="EditPort" value="false" <%//=editPort.equalsIgnoreCase("false")?"checked":""%> >
											</td>
											<td><egui:intnl text="admin.common.No"/></td>
										</tr>
									</table>
								</td>
							</tr>
							<input type='hidden' name='$_EditPort' value='Is port editable$<%//=editPort.equalsIgnoreCase("true")?"true":"false"%>'> -->
							<tr>
								<td colspan="3">
									<table cellspacing="0" cellpadding="0" width="100%" border="0">
										<tr>
											<td height="6" id="inner_bott_left" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7" height="6" border="0"></td>
											<td id="eg_subcontentbg"  width="100%" valign="top" ><img src="/final/admin/eg_images/spacer.gif" height="6" border="0"></td>
											<td height="6" align="right" id="inner_bott_right" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7px" height="6px" border="0"></td>
										</tr>
									</table>
								</td>
							</tr>
						</table>
					</td>
				</tr>
				<tr><td align="center" colspan="3" id="eg_blankspace" height="8">&nbsp;</td></tr>
<%
	}
	if(process.equals("") || process.equals("logsettings"))
	{
%>
				<tr>
					<td align="center" colspan="3">
						<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" style="table- layout:fixed" class="eg_subcontentbg"><col width="43%"><col width="15"><col width="57%">
							<tr>
								<td colspan="3">
									<table cellspacing="0" cellpadding="0" width="100%" border="0" height="22">
										<tr>
											<td id="subhead_left" width="7">
												<img src="/final/admin/eg_images/spacer.gif" border="0" width="7">
											</td>
											<td id="eg_subheadbg" style="border-left-width: 0px; border-right-width: 0px;" align="center" width="100%">
												<strong><egui:intnl text="admin.settings.Log Settings"/></strong> 
											</td>
											<td id="subhead_right" width="7">
												<img src="/final/admin/eg_images/spacer.gif" border="0" width="7">
											</td>
										</tr>
									</table>
								</td>
							</tr>
							<tr>
								<th class="form_border"  nowrap ><egui:intnl text="admin.settings.Log eG database cleanup operations"/></th>
								<td class="form_border" nowrap > &nbsp;:</td>
								<td class="form_border" nowrap >
									<%  String logDbCleanup = transBean.getStrValue(subject,"LogDbCleanup"); %>
									<table  width="30%" cellspacing="0" cellpadding="0" border="0">
										<tr>
											<td id="eg_subcontentbg" class="eg_subcontent" width="20">
												<input type="radio"class="eg_input" name="LogDbCleanup" value="Yes" <%=logDbCleanup.equalsIgnoreCase("Yes") ? "checked":""%>>
											</td>
											<td>
												<egui:intnl text="admin.common.Yes"/>
											</td>
											<td id="eg_subcontentbg" class="eg_subcontent" width="20">
												<input type="radio"class="eg_input" name="LogDbCleanup" value="No" <%=logDbCleanup.equalsIgnoreCase("No") ? "checked":""%>>
											</td>
											<td>
												<egui:intnl text="admin.common.No"/>
											</td>
										</tr>
									</table>
								</td>
							</tr>
							<input type='hidden' name='$_LogDbCleanup' value='Log eG database cleanup operations$<%=logDbCleanup.equalsIgnoreCase("Yes")?"Yes":"No"%>'>
							<tr>
								<th class="form_border"  nowrap><egui:intnl text="admin.settings.Log the scheduling of reports"/></th>
								<td class="form_border" nowrap > &nbsp;:</td>
								<td class="form_border" nowrap>
<%
		String logScheduleReports = transBean.getStrValue(subject,"LogScheduleReports");
%>
									<table  width="30%" cellspacing="0" cellpadding="0" border="0">
										<tr>
											<td id="eg_subcontentbg" class="eg_subcontent" width="20">
												<input type="radio" class="eg_input"name="LogScheduleReports" value="Yes" <%=logScheduleReports.equalsIgnoreCase("Yes") ? "checked":""%>>
											</td>
											<td>
												<egui:intnl text="admin.common.Yes"/>
											</td>
											<td id="eg_subcontentbg" class="eg_subcontent" width="20">
												<input type="radio"class="eg_input" name="LogScheduleReports" value="No" <%=logScheduleReports.equalsIgnoreCase("No") ? "checked":""%>>
											</td>
											<td>
												<egui:intnl text="admin.common.No"/>
											</td>
										</tr>
									</table>
								</td>
							</tr>
							<input type='hidden' name='$_LogScheduleReports' value='Log the scheduling of reports$<%=logScheduleReports.equalsIgnoreCase("Yes")?"Yes":"No"%>'>

							<!-- <tr>
								<td nowrap colspan="3" height="10" id="eg_blankspace">&nbsp;</td>
							</tr> -->
							
							<!--Commented by Nagarajan -Dont need it now that Audit log is enabled-->
							
						<!-- 	<tr>
								<th class="form_border"  nowrap><egui:intnl text="admin.settings.Log user logins/logouts"/></th>
								<td class="form_border" nowrap > &nbsp;:</td>
								<td class="form_border" nowrap>
									<%  String logAccesses = transBean.getStrValue(subject,"LogAccesses"); %>
									<table  width="30%" cellspacing="0" cellpadding="0" border="0"> 
										<tr>
											<td id="eg_subcontentbg" class="eg_subcontent"  width="20">
												<input type="radio" class="eg_input"name="LogAccesses" value="Yes" <%//=logAccesses.equalsIgnoreCase("Yes") ? "checked":""%>>
											</td>
											<td>
												<egui:intnl text="admin.common.Yes"/>
											</td>
											<td id="eg_subcontentbg" class="eg_subcontent" width="20">
												<input type="radio" class="eg_input"name="LogAccesses" value="No" <%//=logAccesses.equalsIgnoreCase("No") ? "checked":""%>>
											</td>
											<td>
												<egui:intnl text="admin.common.No"/>
											</td>
										</tr>
									</table>
								</td>
							</tr>
							<input type='hidden' name='$_LogAccesses' value='Log user logins/logouts$<%//=logAccesses.equalsIgnoreCase("Yes")?"Yes":"No"%>'> -->

							<!-- <tr>
								<td nowrap colspan="3" height="10" id="eg_blankspace">&nbsp;</td>
							</tr> -->
						<!-- 	<tr>
							<%/*
								String accessLogMaxSize = transBean.getStrValue(subject,"AccessLogMaxSize");
								if (isNull(accessLogMaxSize))
								{
									accessLogMaxSize = EgConstants.BLANK_STRING;
								}
								*/
							%>
								<th class="form_border"  nowrap><egui:intnl text="admin.settings.Max size of the access log (MB)"/></th>
								<td class="form_border" nowrap > &nbsp;:</td>
								<td class="form_border" nowrap>&nbsp;&nbsp;<input type='text' name='AccessLogMaxSize'  value="<%//=accessLogMaxSize%>" maxlength="256" style="width: 350px;"></td>
							</tr>
							<input type='hidden' name='$_AccessLogMaxSize' value='Max size of the access log (MB)$<%//=accessLogMaxSize%>'>
 -->
							<!-- <tr>
								<td nowrap colspan="3" height="10" id="eg_blankspace">&nbsp;</td>
							</tr> -->
							<tr>
								<th class="form_border"  nowrap><egui:intnl text="admin.settings.Log data trending activity"/></th>
								<td class="form_border" nowrap > &nbsp;:</td>
								<td class="form_border" nowrap>
									<%  String trendLog = transBean.getStrValue(subject,"TrendLog"); %>
									<table  width="30%" cellspacing="0" cellpadding="0" border="0">
										<tr>
											<td id="eg_subcontentbg" class="eg_subcontent" width="20">
												<input type="radio" class="eg_input" name="TrendLog" value="Yes" <%=trendLog.equalsIgnoreCase("Yes") ? "checked":""%>>
											</td>
											<td>
											<egui:intnl text="admin.common.Yes"/>
											</td>
											<td id="eg_subcontentbg" class="eg_subcontent" width="20">
												<input type="radio" class="eg_input" name="TrendLog" value="No" <%=trendLog.equalsIgnoreCase("No") ? "checked":""%>>
											</td>
											<td>
												<egui:intnl text="admin.common.No"/>
											</td>
										</tr>
									</table>
								</td>
							</tr>
							<input type='hidden' name='$_TrendLog' value='Log data trending activity$<%=trendLog.equalsIgnoreCase("Yes")?"Yes":"No"%>'>
							<tr>
								<th class="form_spacing"  nowrap><egui:intnl text="admin.settings.Log threshold computation activity"/></th>
								<td class="form_spacing" nowrap > &nbsp;:</td>
								<td class="form_spacing" nowrap>
									<%  String thresholdLog = transBean.getStrValue(subject,"ThresholdLog"); %>
									<table  width="30%" cellspacing="0" cellpadding="0" border="0">
										<tr>
											<td id="eg_subcontentbg" class="eg_subcontent" width="20">
												<input type="radio"class="eg_input" name="ThresholdLog" value="Yes" <%=thresholdLog.equalsIgnoreCase("Yes") ? "checked":""%>>
											</td>
											<td>
												<egui:intnl text="admin.common.Yes"/>
											</td>
											<td id="eg_subcontentbg" class="eg_subcontent" width="20">
				                            <input type="radio" class="eg_input" name="ThresholdLog" value="No" <%=thresholdLog.equalsIgnoreCase("No") ? "checked":""%>>
											</td>
											<td>
											<egui:intnl text="admin.common.No"/>
											</td>
										</tr>
									</table>
								</td>
							</tr>
							<input type='hidden' name='$_ThresholdLog' value='Log threshold computation activity$<%=thresholdLog.equalsIgnoreCase("Yes")?"Yes":"No"%>'>
							<tr>
								<td colspan="3">
									<table cellspacing="0" cellpadding="0" width="100%" border="0">
										<tr>
											<td height="6" id="inner_bott_left" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7" height="6" border="0"></td>
											<td id="eg_subcontentbg"  width="100%" valign="top" ><img src="/final/admin/eg_images/spacer.gif" height="6" border="0"></td>
											<td height="6" align="right" id="inner_bott_right" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7px" height="6px" border="0"></td>
										</tr>
									</table>
								</td>
							</tr>
						</table>
					</td>
				</tr>
				<tr><td align="center" colspan="3" id="eg_blankspace" height="8">&nbsp;</td></tr>
<%
	}
	boolean discCompsPopupEnabled = false;
	if(process.equals("") || process.equals("discompopup"))
	{

		//trans.createFile("eg_ui.ini");
		String discoverCompsPopup = trans.getStrValue("MISC_ARGS","POPUP_DISCOVERED_COMPONENTS");
		if(discoverCompsPopup == null || discoverCompsPopup.equals(""))
		{
			discoverCompsPopup = "false";
		}

		if(discoverCompsPopup.equalsIgnoreCase("true") || discoverCompsPopup.equalsIgnoreCase("yes"))
		{
			discCompsPopupEnabled = true;
		}

		String hideTimeDiscoverCompsPopup = trans.getStrValue("MISC_ARGS","POPUP_TIMEOUT");
		if(hideTimeDiscoverCompsPopup == null || hideTimeDiscoverCompsPopup.equals(""))
		{
			hideTimeDiscoverCompsPopup = "1";
		}
%>
				<tr>
					<td align="center">
						<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" style="table- layout:fixed" class="eg_subcontentbg"><col width="43%"><col width="15"><col width="57%">
							<tr>
								<td colspan="3">
									<table cellspacing="0" cellpadding="0" width="100%" border="0" height="22">
										<tr>
											<td id="subhead_left" width="7">
												<img src="/final/admin/eg_images/spacer.gif" border="0" width="7">
											</td>
											<td id="eg_subheadbg" style="border-left-width: 0px; border-right-width: 0px;" align="center" width="100%">
												<strong><egui:intnl text="admin.settings.Discovered components pop-up"/></strong> 
											</td>
											<td id="subhead_right" width="7">
												<img src="/final/admin/eg_images/spacer.gif" border="0" width="7">
											</td>
										</tr>
									</table>
								</td>
							</tr>
							<tr>
								<th class="form_border" style="border-bottom-width:0px" nowrap><egui:intnl text="admin.settings.Show pop-up"/></th>
								<td class="form_border" nowrap style="border-bottom-width:0px">&nbsp;:</td>

								<td class="form_border" style="border-bottom-width:0px" nowrap>
									<table  width="30%" cellspacing="0" cellpadding="0" border="0">
										<tr>
											<td id="eg_subcontentbg" class="eg_subcontent" width="20">
												<input type="radio" class="eg_input" name="DiscCompsFlag" value="Yes" <%=discCompsPopupEnabled?"checked":""%> onclick='javascript:showHideTimeFiled("true")'>
											</td>
											<td><egui:intnl text="admin.common.Yes"/></td>
											<td id="eg_subcontentbg" class="eg_subcontent" width="20">
												<input type="radio" class="eg_input" name="DiscCompsFlag" value="No" <%=!discCompsPopupEnabled?"checked":""%> onclick='javascript:showHideTimeFiled("false")'>
											</td>
											<td><egui:intnl text="admin.common.No"/></td>
										</tr>
									</table>
								</td>
							</tr>
							<input type='hidden' name='$_DiscCompsFlag' value='Show pop-up$<%=discCompsPopupEnabled?"Yes":"No"%>'>

							<tr id="hideTimeRow" style="display:none">
								<th class="form_border" style="border-top-width:1px;border-bottom-width:0px" nowrap><egui:intnl text="admin.settings.Pop-up timeout period (mins)"/></th>

								<td class="form_border" style="border-top-width:1px;border-bottom-width:0px" nowrap> &nbsp;:</td>
								<td class="form_border" style="border-top-width:1px;border-bottom-width:0px" nowrap>&nbsp;&nbsp;<input type="text" name="hidetime" maxlength="3" value="<%=hideTimeDiscoverCompsPopup%>"></td>
							</tr>
							<input type='hidden' name='$_hidetime' value='Pop-up timeout period (mins)$<%=hideTimeDiscoverCompsPopup%>'>
							<tr>
								<td colspan="3">
									<table cellspacing="0" cellpadding="0" width="100%" border="0">
										<tr>
											<td height="6" id="inner_bott_left" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7" height="6" border="0"></td>
											<td id="eg_subcontentbg"  width="100%" valign="top" ><img src="/final/admin/eg_images/spacer.gif" height="6" border="0"></td>
											<td height="6" align="right" id="inner_bott_right" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7px" height="6px" border="0"></td>
										</tr>
									</table>
								</td>
							</tr>
						</table>
					</td>
				</tr>

				<tr><td align="center" colspan="3" id="eg_blankspace" height="8">&nbsp;</td></tr>
<script>
	showHideTimeFiled("<%=discCompsPopupEnabled%>");
</script>
<%
	}
%>
<script>
function showtext()
{
	var thisForm = document.mgrfrm;
	var threshInterval = thisForm.threshInterval.options[thisForm.threshInterval.selectedIndex].value;
	document.getElementById("showtext").innerHTML = '&nbsp;'+threshInterval+'(s)';
	document.forms['mgrfrm'].dummy_threshInterval.value = threshInterval+'(s)';
}
</script>
<%
	if(process.equals("") || process.equals("ttmanagercli"))
	{
%>
			<!-- added by Nehru.C for Unisys starts here -->
				<tr>
					<td align="center">
						<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" style="table- layout:fixed" class="eg_subcontentbg"><col width="43%"><col width="15"><col width="57%">
							<tr>
								<td colspan="3">
									<table cellspacing="0" cellpadding="0" width="100%" border="0" height="22">
										<tr>
											<td id="subhead_left" width="7"> <img src="/final/admin/eg_images/spacer.gif" border="0" width="7"> </td>
											<td id="eg_subheadbg" style="border-left-width: 0px; border-right-width: 0px;" align="center" width="100%"> <strong><egui:intnl text="admin.settings.TT MANAGER CLI"/></strong> </td>
											<td id="subhead_right" width="7"> <img src="/final/admin/eg_images/spacer.gif" border="0" width="7"> </td>
										</tr>
									</table>
								</td>
							</tr>
<%
		String enableExecForTT = transBean.getStrValue("EXEC_TTMANAGER","EnableExecForTT");
%>
							<tr>
								<th class="form_border" nowrap >
									<egui:intnl text="admin.settings.Enable CLI"/></th>
								<td class="form_border" nowrap > &nbsp;:</td>
								<td class="form_border" nowrap >
									<table  width="30%" cellspacing="0" cellpadding="0" border="0">
										<tr>
											<td id="eg_subcontentbg" class="eg_subcontent" width="20">
												<input type="radio" class="eg_input"name="EnableExecForTT" value="Yes" <%=enableExecForTT.equalsIgnoreCase("Yes") ? "checked":""%>>
											</td>
											<td><egui:intnl text="admin.common.Yes"/></td>
											<td id="eg_subcontentbg" class="eg_subcontent" width="20">
												<input type="radio"class="eg_input" name="EnableExecForTT" value="No" <%=enableExecForTT.equalsIgnoreCase("No") ? "checked":""%>>
											</td>
											<td><egui:intnl text="admin.common.No"/></td>
										</tr>
									</table>
								</td>
							</tr>
							<input type='hidden' name='$_EnableExecForTT' value='Enable CLI$<%=enableExecForTT.equalsIgnoreCase("Yes")?"Yes":"No"%>'>
<%
			String execOutFormat = transBean.getStrValue("EXEC_TTMANAGER","Command");
			String command = execOutFormat;
			if(!isNull(command))
				execOutFormat = execOutFormat.substring(execOutFormat.indexOf("#")+1);
			command = command.substring(0,command.indexOf("#"));
%>
							<tr>
								<th class="form_border" nowrap ><egui:intnl text="admin.settings.Command"/></th>
								<td class="form_border" nowrap > &nbsp;:</td>
								<td class="form_border" nowrap>&nbsp;&nbsp;<input type='text' name='Command2' value="<%=command%>" maxlength="256" style="width: 350px; "></td>
							</tr>
							<input type='hidden' name='$_Command2' value='Command$<%=command%>'>
							<tr>
								<th class="form_border" nowrap valign="top"><egui:intnl text="admin.settings.Command Arguments"/></th>
								<td class="form_border" nowrap valign="top"> &nbsp;:</td>
								<td class="form_border" nowrap valign="top">&nbsp;&nbsp;<textarea name='Command' rows='4' cols='30' wrap='virtual'  style="width: 350px;"><%=execOutFormat%></textarea></td>
							</tr>
							<input type='hidden' name='$_Command' value='Command Arguments$<%=execOutFormat%>'>
<%
			String allowedAlarms = transBean.getStrValue("EXEC_TTMANAGER","AllowedAlarms");
%>
							<tr>
								<th class="form_border"  nowrap><egui:intnl text="admin.ui.Allowed alarms"/></th>
								<td class="form_border" nowrap>&nbsp;:&nbsp;&nbsp;</td>
								<td class="form_border" nowrap>
									<table  width="65%" cellspacing="0" cellpadding="0">
										<tr>
											<td id="eg_subcontentbg" class="eg_subcontent" width="20"> <input type="checkbox" class="eg_input" name="AllowedAlarms" value="critical" <%=(allowedAlarms.toLowerCase().indexOf("critical")>-1) ? "checked":""%>></td>
											<td><egui:intnl text="admin.common.Critical"/></td>
											<td id="eg_subcontentbg" class="eg_subcontent" width="20"><input type="checkbox" class="eg_input" name="AllowedAlarms" value="major" <%=(allowedAlarms.toLowerCase().indexOf("major")>-1)? "checked":""%>> </td>
											<td><egui:intnl text="admin.common.Major"/> </td>
											<td id="eg_subcontentbg" class="eg_subcontent" width="20"><input type="checkbox" class="eg_input" name="AllowedAlarms" value="minor" <%=(allowedAlarms.toLowerCase().indexOf("minor")>-1)? "checked":""%>> </td>
											<td><egui:intnl text="admin.common.Minor"/> </td>
											<td id="eg_subcontentbg" class="eg_subcontent" width="20"><input type="checkbox" class="eg_input" name="AllowedAlarms" value="normal" <%=(allowedAlarms.toLowerCase().indexOf("normal")>-1) ? "checked":""%>> </td>
											<td><egui:intnl text="admin.common.Normal"/> </td>
										</tr>
										<input type='hidden' name='$_AllowedAlarms' value='Allowed alarms$<%=allowedAlarms%>'>
									</table>
								</td>
							</tr>
							<input type='hidden' name='$_AllowedAlarms' value='Allowed alarms$<%=allowedAlarms%>'>
<%
			String logFileMaxSize = transBean.getStrValue("EXEC_TTMANAGER","LogFileMaxSize");
%>
							<tr>
								<th class="form_border" nowrap><egui:intnl text="admin.settings.Log file maximum size (MB)"/></th>
								<td class="form_border" nowrap> &nbsp;:</td>
								<td class="form_border" nowrap>&nbsp;&nbsp;<input type='text' name='LogFileMaxSize'  value="<%=logFileMaxSize%>" maxlength="256" style="width: 350px; "></td>
							</tr>
							<input type='hidden' name='$_LogFileMaxSize' value='Log file maximum size (MB)$<%=logFileMaxSize%>'>
<%
			String logEntriesForStdoutAlso = transBean.getStrValue("EXEC_TTMANAGER","LogEntriesForStdoutAlso");
%>
							<tr>
								<th class="form_border" nowrap >
									<egui:intnl text="admin.settings.Log entries for stdout also"/></th>
								<td class="form_border" nowrap > &nbsp;:</td>
								<td class="form_border" nowrap >
									<table  width="30%" cellspacing="0" cellpadding="0" border="0">
										<tr>
											<td id="eg_subcontentbg" class="eg_subcontent" width="20">
												<input type="radio" class="eg_input" name="LogEntriesForStdoutAlso" value="Yes" <%=logEntriesForStdoutAlso.equalsIgnoreCase("Yes") ? "checked":""%>>
											</td>
											<td><egui:intnl text="admin.common.Yes"/></td>
											<td id="eg_subcontentbg" class="eg_subcontent" width="20">
												<input type="radio"class="eg_input" name="LogEntriesForStdoutAlso" value="No" <%=logEntriesForStdoutAlso.equalsIgnoreCase("No") ? "checked":""%>>
											</td>
											<td><egui:intnl text="admin.common.No"/></td>
										</tr>
									</table>
								</td>
							</tr>
							<input type='hidden' name='$_LogEntriesForStdoutAlso' value='Log entries for stdout also -  TT Manager CLI$<%=logEntriesForStdoutAlso.equalsIgnoreCase("Yes")?"Yes":"No"%>'>
<%
			String dateFormat = transBean.getStrValue("EXEC_TTMANAGER","DateFormat");
			String previousDateFormat = dateFormat;
			dateFormat = dateFormat.substring(0,dateFormat.indexOf("H")-1);
%>
							<tr>
								<th class="form_border" nowrap><egui:intnl text="admin.settings.Date format to be used"/></th>
								<td class="form_border" nowrap> &nbsp;:</td>
								<td class="form_border" nowrap>&nbsp;&nbsp;<select name="DateFormat" style="width:120px">
<%
		IniUI iniUI=IniUI.getInstance();
		ArrayList dateFormats = iniUI.getAvailableDateFormats();
		for(int i=0;i<dateFormats.size();i++)
		{
			String format=(String)dateFormats.get(i);
%>

									<option value="<%=format%>" <%=(format.equals(dateFormat)?"selected":"")%>><%=format%></option>
<%
		}
%>
								
								</select></td>
							</tr>
							<input type='hidden' name='$_DateFormat' value='Date format to be used$<%=previousDateFormat%>'>
<%
			String commandLength = transBean.getStrValue("EXEC_TTMANAGER","CommandLength");
			TTPassword=EgCrypt.decrypt(TTPassword);
%>
							<tr>
								<th class="form_border" nowrap ><egui:intnl text="admin.settings.Command length  (chars)"/></th>
								<td class="form_border" nowrap > &nbsp;:</td>
								<td class="form_border" nowrap>&nbsp;&nbsp;<input type='text' name='CommandLength' value="<%=commandLength%>" maxlength="256" style="width: 350px; "></td>
							</tr>
							<input type='hidden' name='$_CommandLength' value='Command length  (chars) for TT Manager CLI$<%=commandLength%>'>
<%
			String probDescLength = transBean.getStrValue("EXEC_TTMANAGER","ProbDescLength");
%>
							<tr>
								<th class="form_border" nowrap style="border-bottom-width:0px"><egui:intnl text="admin.settings.Problem description length (chars)"/></th>
								<td class="form_border" nowrap style="border-bottom-width:0px"> &nbsp;:</td>
								<td class="form_border" nowrap style="border-bottom-width:0px">&nbsp;&nbsp;<input type='text' name='ProbDescLength' value="<%=probDescLength%>" maxlength="256" style="width: 350px; "></td>
							</tr>
							<input type='hidden' name='$_ProbDescLength' value='Problem description length (chars)$<%=probDescLength%>'>
							<tr>
								<td colspan="3">
									<table cellspacing="0" cellpadding="0" width="100%" border="0">
										<tr>
											<td height="6" id="inner_bott_left" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7" height="6" border="0"></td>
											<td id="eg_subcontentbg"  width="100%" valign="top" ><img src="/final/admin/eg_images/spacer.gif" height="6" border="0"></td>
											<td height="6" align="right" id="inner_bott_right" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7px" height="6px" border="0"></td>
										</tr>
									</table>
								</td>
							</tr>
						</table>
					</td>
				</tr>
				<tr><td align="center" colspan="3" id="eg_blankspace" height="8">&nbsp;</td></tr>
<!-- TT_INTEGRATION BLOCK STARTS -->
<!-- DEVELOPED  BY ANTHONI LAWRANCE .A -->
				<tr>
					<td>
						<table cellspacing="0" cellpadding="0" width="100%" border="0">
							<tr>
								<td colspan="3">
									<table cellspacing="0" cellpadding="0" width="100%" border="0" height="22">
											<tr>
												<td id="subhead_left" width="7"> <img src="/final/admin/eg_images/spacer.gif" border="0" width="7"> </td>
												<td id="eg_subheadbg" style="border-left-width: 0px; border-right-width: 0px;" align="center" width="100%"> <strong><egui:intnl text="admin.settings.Trouble Ticket(TT) INTEGRATION"/></strong> </td>
												<td id="subhead_right" width="7"> <img src="/final/admin/eg_images/spacer.gif" border="0" width="7"> </td>
											</tr>
									</table>
								</td>
							</tr>
							<tr>
								<td colspan="3">
								<table border="0" class="eg_subcontentbg" cellpadding="0" cellspacing="0" width="100%">
								<col width="42%"><col width="3%"><col width="54%">
								<tr>
									<th class="form_border" nowrap><egui:intnl text="admin.settings.Enable TT integration"/></th>
									<td class="form_border">&nbsp;:</td>
									<td  class="form_border" width="20">
										<table border="0" cellpadding="0" cellspacing="0">
										<tr>
											<td><input type="radio" class="eg_input" name="integrationFlag" id="TTIntegrationEnable" onclick="javascript:checkTTIntegration(true);" <%=(TTIntegrationEnable != null && TTIntegrationEnable.equalsIgnoreCase("yes"))?"checked":""%> value="Yes"></td>
											<td>&nbsp;<egui:intnl text="admin.settings.Yes "/></td>
											<td width="20">
												 <img src="/final/admin/eg_images/spacer.gif" border="0" width="7"> 
											</td>
											<td><input type="radio" class="eg_input" id="TTIntegrationDisable"  name="integrationFlag" onclick="javascript:checkTTIntegration(false);" <%=(TTIntegrationEnable != null && TTIntegrationEnable.equalsIgnoreCase("no"))?"checked":""%> value="No"></td>
											<td>&nbsp;<egui:intnl text="admin.settings.No "/></td>
										</tr>
										</table>
									</td>
								</tr>
								</table>
								</td>
							</tr>
							<tr>
								<td colspan="3">
								<div id="TT_Integration" style='visibility:<%=(TTIntegrationEnable.equalsIgnoreCase("yes"))?"visible":"hidden"%>;display:<%=(TTIntegrationEnable.equalsIgnoreCase("yes"))?"block":"none"%>;border:0px solid #33cc66;width:100%'>
									<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" style="table- layout:fixed" class="eg_subcontentbg"><col width="42%"><col width="3%"><col width="54%">
										<tr>
											<th class="form_border" nowrap><egui:intnl text="admin.settings.TT integration system"/></th>
											<td class="form_border">&nbsp;:</td>
											<td class="form_border">
											<table border="0" cellpadding="0" cellspacing="0" width="98%">
												<col width="38%"><col width="1%"><col width="59%">
											<tr>
												<td>
													<select name="TT_sys" id="TT_sys" onchange="javascript:callOthers();">
<%
			String TT_Integration_Systems=transBean.getStrValue("TT_INTEGRATION","TT_INTEGRATION_SYSTEMS");
			if(TT_Integration_Systems!=null && TT_Integration_Systems.length()>0)
			{
				StringTokenizer stkTTSys=new StringTokenizer(TT_Integration_Systems,",");
				while(stkTTSys.hasMoreTokens())
				{
					String ttSys1=stkTTSys.nextToken();
					String selected="";
					if ( !StringUtils.isNull(selectSysName) )
					{
						if ( ttSys1.equals(selectSysName) )
						selected="selected";
					}
					else if ( ttSys1.equals(TTSys) )
						selected="selected";
%>
														<option value="<%=ttSys1%>" <%=selected%>>
														<egui:intnl text="<%=ttSys1%>"/></option>
<%
				}
			}
%>
													</select>
												</td>
												<td>
<%
			if((TTSys!=null && !TTSys.equalsIgnoreCase("others")) && (selectSysName == null || (selectSysName!=null && !selectSysName.equalsIgnoreCase("others"))))
		{
%>

												<a href="javascript:void(0);" onclick="javascript:deleteTTIntegrationConfig();" class="eg_monlink" >
												<img src="/final/images/<%=admin_Skin%>/icon_close.png"  border="0" alt='<egui:intnl text="admin.text.Remove configuration"/>'/></a>
<%
		}
		else
		{
%>
												<img src="/final/admin/eg_images/spacer.gif" width="7px" height="6px" border="0">
<%
		}
%>
												</td>
												<td>
													<div id="TT_Other_Div" style="visibility:<%=isDefaultManagerEngineLoaded?"hidden":"visible"%>;display:<%=isDefaultManagerEngineLoaded?"none":"block"%>;border:0px solid #3366ff;">
														<table border="0" cellspacing="0" cellpadding="0" width="100%">
															<tr>
																<td>
																	<egui:intnl text="admin.settings.Name"/>&nbsp;:&nbsp;
																</td>
																<td>
																	<input type="text" name="TT_Other" id="TT_Other" value="<%=TTOtherDispName%>" style="width:140px;">
																</td>
															</tr>
														</table>
													</div>
												</td>
											</tr>
											</table>
											</div>
											</td>
										</tr>
										<tr>
											<th class="form_border" nowrap><egui:intnl text="admin.settings.TT system URL"/></th>
											<td class="form_border">&nbsp;:</td>
											<td class="form_border" width="20">
												<input type="text" id="TT_Url" name="TT_Url" value="<%=TTUrl%>" style="width:350px;">
											</td>
										</tr>
										<tr>
											<th class="form_border" nowrap>
												<egui:intnl text="admin.settings.TT system user name"/>
											</th>
											<td class="form_border">
												&nbsp;:
											</td>
											<td class="form_border">
												<input type="text" name="TT_User_Name" id="TT_User_Name"  rows="3" cols="" style="width:350px;" value="<%=TTUsername%>">
											</td>
										</tr>
										<tr>
											<th class="form_border" nowrap>
												<egui:intnl text="admin.settings.TT system password"/>
											</th>
											<td class="form_border">
												&nbsp;:
											</td>
											<td class="form_border">
												<input type="password" name="TT_Password" id="TT_Password"  rows="3" cols="" style="width:350px;" value="<%=TTPassword%>">
											</td>
										</tr>
										<tr>
											<th class="form_border" nowrap>
												<egui:intnl text="admin.settings.TT integration output format"/>
											</th>
											<td class="form_border">
												&nbsp;:
											</td>
											<td class="form_border" >
												<textarea name="TT_Output" id="TT_Output"  rows="3" cols="" style="width:350px;"><%=TTOutput%></textarea>
											</td>
										</tr>
										<tr>
											<td valign="middel" colspan="3">
												<table cellpadding="0" cellspacing="0" border="0" width="100%">
													<col width="42%"><col width="3%"><col width="54%">
													<tr>
														<th  class="form_border" nowrap>
															<egui:intnl text="admin.settings.Do you want to upload integration Archieve"/>?
														</th>
														<td class="form_border">
															&nbsp;:
														</td>
														<td class="form_border">
															<table border="0" bordercolor="red" cellspacing="0" cellpadding="0" >
																<tr>
																	<td>
<%
		String ttWraperCheckedYes = "", ttWraperCheckedNo = "" , displayTTIntegrationArchive = "" , displayUploadButtonDiv = "";
		if(!StringUtils.isNull(TTWrapper))
		{
			ttWraperCheckedYes = "checked";
			displayTTIntegrationArchive="block";
			displayUploadButtonDiv="block";
		}
		else
		{
			ttWraperCheckedNo = "checked";
			displayTTIntegrationArchive="none";
			displayUploadButtonDiv = "none";
		}
%>
																		<input type="radio" name="ttWrapperClassNeeded" id="ttWrapperClassNeeded" value="yes" onclick="javascript:checkTTWrapperClassNeeded('Yes');" <%=ttWraperCheckedYes%>></td>
																	<td>&nbsp;<egui:intnl text="admin.settings.Yes " /></td>
																	<td><img src="/final/admin/eg_images/spacer.gif" width="7px" height="6px" border="0"></td>
																	<td><input type="radio" name="ttWrapperClassNeeded" id="ttWrapperClassNeeded" value="no" onclick="javascript:checkTTWrapperClassNeeded('No');" <%=ttWraperCheckedNo%>></td>
																	<td>
																		&nbsp;<egui:intnl text="admin.settings.No " />
																	</td>
																	<td>
																		<img src="/final/admin/eg_images/spacer.gif" width="7px" height="6px" border="0"> 
																	</td>
																	<td  valign="middle" >
																		<div id="uploadDiv" style='display:<%=displayUploadButtonDiv%>'>
																		<input type="button" value="Upload" onclick="javascript:uploadWrapper('main');" style="width:85px;" class="eg_back" id="uploadArchieveFileBtn" name="uploadArchieveFileBtn"></div>
																	</td>
																</tr>
															</table>
														</td>
													</tr>
													<tr>
														<td></td>
														<td></td>
														<td>
															<div id="ttMainWrapperClassDisplay" style='float:left;border:0px;display:<%=displayTTIntegrationArchive%>'>
																<%		if(!StringUtils.isNull(ArchieveFile))
																{
																%>
																																				<span align="right"> <b>&nbsp;&nbsp;<%=ArchieveFile%>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<a href="javascript:void(0);" onclick="javscript:removeArchieveFile('<%=ArchieveFile%>');" class="dash_link">&nbsp;<egui:intnl text="admin.settings.Remove" /></a></b></span>
																	<%
																}
																	%>

															</div>
														</td>
													</tr>
												</table>
											</td>
										</tr>
										<tr>
											<th class="form_border" nowrap>
												<egui:intnl text="admin.settings.TT system API key" />
											</th>
											<td class="form_border">
												&nbsp;:
											</td>
											<td  class="form_border" valign="middel">
												<input type="text" name="TT_Api_Key" id="TT_Api_Key" value="<%=TTApiKey%>" style="width:350px;">
											</td>
										</tr>
										<!-- <tr>
											<th class="form_border" nowrap>
												<egui:intnl text="admin.settings.API Details" />
											</th>
											<td>
												&nbsp;:
											</td>
											<td>
												<div id="ticketDiv" style="visibility:visible;display:block;border:1px solid #1100bb">
													<table border="0" cellpadding="2" cellspacing="0" bordercolor="#660033">
													<tr>
														<td width="120px">
															<egui:intnl text="admin.settings.Create Ticket" />
														</td>
														<td>
															:<img src="/final/admin/eg_images/spacer.gif" border="0" width="7">
														</td>
														<td>
															<input type="text" name="createTicTxt" id="createTicTxt" value="<%//=createTicket%>">
														</td>
													</tr>
													<tr>
														<td>
															<egui:intnl text="admin.settings.Modify Ticket" />
														</td>
														<td>
															:<img src="/final/admin/eg_images/spacer.gif" border="0" width="7">
														</td>
														<td>
															<input type="text" name="modifyTicTxt" id="modifyTicTxt" value="<%//=modifyTicket%>">
														</td>
													</tr>
													<tr>
														<td>
															<egui:intnl text="admin.settings.Delete Ticket" />
														</td>
														<td>
															:<img src="/final/admin/eg_images/spacer.gif" border="0" width="7">
														</td>
														<td>
															<input type="text" name="deleteTicTxt" id="deleteTicTxt" value="<%//=deleteTicket%>">
														</td>
													</tr>
													</table>
												</div>
											</td>
										</tr> -->
										<tr>
											<th class="form_border" nowrap>
												<egui:intnl text="admin.settings.TT system allowed alarms" />
											</th>
											<td>
												&nbsp;:
											</td>
											<td valign="middel">
												<div id="criticalAlarmsDiv" style="border:0px solid yellow;display:inline;width:20%">
													<INPUT TYPE="checkbox" NAME="criticalAlarms" ID="criticalAlarms" <%=criticalAlarms%> />
													<egui:intnl text="admin.settings.Critical" />
												</div>
												<div id="majorAlarmsDiv" style="border:0px solid red;width:20%;display:inline;">
													<INPUT TYPE="checkbox" NAME="majorAlarms" ID="majorAlarms" <%=majorAlarms%> />
													<egui:intnl text="admin.settings.Major" />
												</div>
												<div id="minorAlarmsDiv" style="border:0px solid green;width:20%;display:inline;">
													<INPUT TYPE="checkbox" NAME="minorAlarms" ID="minorAlarms" <%=minorAlarms%> />
													<egui:intnl text="admin.settings.Minor" />
												</div>
												<div id="normalAlarmsDiv" style="border:0px solid pink;width:20%;display:inline;">
													<INPUT TYPE="checkbox" NAME="normalAlarms" ID="normalAlarms" <%=normalAlarms%> />
													<egui:intnl text="admin.settings.Normal" />
												</div>
												<!-- <input type="text" name="TT_Allowed_Alarms" id="TT_Allowed_Alarms" value="<%//=TTAllowedAlarms%>" style="width:350px;"> -->
											</td>
										</tr>
									</table>
									</div>
								</td>
							</tr>
						</table>
					</td>
				</tr>
<input type="hidden" name="runBatOrSH" id="runBatOrSH" value="">
<input type="hidden" name="ArchieveFile" id="ArchieveFile" value="<%=ArchieveFile%>">
<input type="hidden" name="mainWrapperClass" id="mainWrapperClass" value="<%=TTWrapper%>">
<input type="hidden" name="action" id="action" value="">
<!-- TT_INTEGRATION BLOCK ENDS -->
<%
	}
	if(process.equals("") || process.equals("commandexecution"))
	{
%>
				<!-- added by Nehru.C for Unisys ends here -->
				<!--added by sunder for script execution in mailmanager -->
				<tr>
					<td align="center">
						<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" style="table- layout:fixed" class="eg_subcontentbg"><col width="43%"><col width="15"><col width="57%">
							<tr>
								<td colspan="3">
									<table cellspacing="0" cellpadding="0" width="100%" border="0" height="22">
										<tr>
											<td id="subhead_left" width="7"> <img src="/final/admin/eg_images/spacer.gif" border="0" width="7"> </td>
											<td id="eg_subheadbg" style="border-left-width: 0px; border-right-width: 0px;" align="center" width="100%"> <strong><egui:intnl text="admin.settings.Command Execution"/></strong> </td>
											<td id="subhead_right" width="7"> <img src="/final/admin/eg_images/spacer.gif" border="0" width="7"> </td>
										</tr>
									</table>
								</td>
							</tr>
<%
			String enableCommandExec = transBean.getStrValue("EXEC_MAILMANAGER","EnableCommandExec");
%>
							<tr>
								<th class="form_border" nowrap >
									<egui:intnl text="admin.settings.Enable Command Execution"/></th>
								<td class="form_border" nowrap > &nbsp;:</td>
								<td class="form_border" nowrap >
									<table  width="30%" cellspacing="0" cellpadding="0" border="0">
										<tr>
											<td id="eg_subcontentbg" class="eg_subcontent" width="20">
												<input type="radio" class="eg_input" name="Enable_mail" value="Yes" <%=enableCommandExec.equalsIgnoreCase("Yes") ? "checked":""%> >
											</td>
											<td><egui:intnl text="admin.common.Yes"/></td>
											<td id="eg_subcontentbg" class="eg_subcontent" width="20">
												<input type="radio"class="eg_input" name="Enable_mail" value="No" <%=enableCommandExec.equalsIgnoreCase("No") ? "checked":""%> >
											</td>
											<td><egui:intnl text="admin.common.No"/></td>
										</tr>
									</table>
								</td>
							</tr>
							<input type='hidden' name='$_Enable_mail' value='Enable Command Execution$<%=enableCommandExec%>'>
<%
	String logSize=transBean.getStrValue("EXEC_MAILMANAGER","LogFileMaxSize");
%>
							<tr>
								<th class="form_border" nowrap><egui:intnl text="admin.settings.Log file maximum size (MB)"/></th>
								<td class="form_border" nowrap> &nbsp;:</td>

								<td class="form_border" nowrap>&nbsp;&nbsp;<input type='text' name='Log_maxsize'  value="<%=logSize%>" maxlength="256" style="width: 350px; "></td>
							</tr>
							<input type='hidden' name='$_Log_maxsize' value='Log file maximum size (MB)$<%=logSize%>'>
<%
	
	String logForStdoutAlso = transBean.getStrValue("EXEC_MAILMANAGER","LogEntriesForStdoutAlso");
%>
							<tr>
								<th class="form_border" nowrap >
									<egui:intnl text="admin.settings.Log entries for stdout also"/></th>
								<td class="form_border" nowrap > &nbsp;:</td>
								<td class="form_border" nowrap >
									<table  width="30%" cellspacing="0" cellpadding="0" border="0">
										<tr>
											<td id="eg_subcontentbg" class="eg_subcontent" width="20">
												<input type="radio" class="eg_input"name="LogEntries" value="Yes" <%=logForStdoutAlso.equalsIgnoreCase("Yes") ? "checked":""%> >
											</td>
											<td><egui:intnl text="admin.common.Yes"/></td>
											<td id="eg_subcontentbg" class="eg_subcontent" width="20">
												<input type="radio"class="eg_input" name="LogEntries" value="No" <%=logForStdoutAlso.equalsIgnoreCase("No") ? "checked":""%> >
											</td>
											<td><egui:intnl text="admin.common.No"/></td>
										</tr>
									</table>
								</td>
							</tr>
							<input type='hidden' name='$_LogEntries' value='Log entries for stdout also - Command Execution$<%=logForStdoutAlso.equalsIgnoreCase("Yes")?"Yes":"No"%>'>
							<input type='hidden' name='$_DateFormat' value='Date format to be used$'>
<%
	String SeparateExec= transBean.getStrValue("EXEC_MAILMANAGER","SeparateExec");
%>
							<tr>
								<th class="form_border" nowrap >
									<egui:intnl text="admin.settings.Separate execution"/></th>
								<td class="form_border" nowrap > &nbsp;:</td>
								<td class="form_border" nowrap >
									<table  width="30%" cellspacing="0" cellpadding="0" border="0">
										<tr>
											<td id="eg_subcontentbg" class="eg_subcontent" width="20">
												<input type="radio" class="eg_input"name="Separate_exec" value="Yes" <%=SeparateExec.equalsIgnoreCase("Yes") ? "checked":""%> >
											</td>
											<td><egui:intnl text="admin.common.Yes"/></td>
											<td id="eg_subcontentbg" class="eg_subcontent" width="20">
												<input type="radio"class="eg_input" name="Separate_exec" value="No" <%=SeparateExec.equalsIgnoreCase("No") ? "checked":""%> >
											</td>
											<td><egui:intnl text="admin.common.No"/></td>
										</tr>
									</table>
								</td>
							</tr>
							<input type='hidden' name='$_Separate_exec' value='Separate Execution$<%=SeparateExec.equalsIgnoreCase("Yes")?"Yes":"No"%>'>
<%
	String cmdLength=transBean.getStrValue("EXEC_MAILMANAGER","CommandLength");
%>
							<tr>
								<th class="form_border" nowrap ><egui:intnl text="admin.settings.Command length  (chars)"/></th>
								<td class="form_border" nowrap > &nbsp;:</td>
								<td class="form_border" nowrap>&nbsp;&nbsp;<input type='text' name='Command_length' value="<%=cmdLength%>" maxlength="256" style="width: 350px; "></td>
							</tr>
							<input type='hidden' name='$_Command_length' value='Command length (chars) for Command Execution$<%=cmdLength%>'>
<%
	String allowed_format=transBean.getStrValue("EXEC_MAILMANAGER","Allowedformat");
%>
							<tr>
								<th class="form_border" nowrap style="border-bottom-width:0px"><egui:intnl text="admin.settings.Allowed script types (chars)"/></th>
								<td class="form_border" nowrap style="border-bottom-width:0px"> &nbsp;:</td>

								<td class="form_border" nowrap style="border-bottom-width:0px">&nbsp;&nbsp;<input type='text' name='allowed_format' value="<%=allowed_format%>" maxlength="256" style="width: 350px; "></td>
							</tr>
							<input type='hidden' name='$_allowed_format' value='Problem description length (chars)$<%=allowed_format%>'>
							<tr>
								<td colspan="3">
									<table cellspacing="0" cellpadding="0" width="100%" border="0">
										<tr>
											<td height="6" id="inner_bott_left" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7" height="6" border="0"></td>
											<td id="eg_subcontentbg"  width="100%" valign="top" ><img src="/final/admin/eg_images/spacer.gif" height="6" border="0"></td>
											<td height="6" align="right" id="inner_bott_right" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7px" height="6px" border="0"></td>
										</tr>
									</table>
								</td>
							</tr>
						</table>
					</td>
				</tr>
				<tr><td align="center" colspan="3" id="eg_blankspace" height="8">&nbsp;</td></tr>
				<!--sunder code ends for script Exec---->
<%
	}
	String loginType = _user.getLoginType();
	String styleClass = "form_border";
	if(!loginType.equals("Admin"))
	{
		styleClass = "form_spacing";
	}		

	if(process.equals("") || process.equals("auditing"))
	{
%>
<%
		String auditlogForCLI = transBean.getStrValue(subject,"AuditlogForCLI");
%>
				<!--<tr><td align="center" colspan="3" id="eg_blankspace" height="8">&nbsp;</td></tr>-->
				<tr>
					<td align="center">
						<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" style="table- layout:fixed" class="eg_subcontentbg"><col width="43%"><col width="15"><col width="57%">
							<tr>
								<td colspan="3">
									<table cellspacing="0" cellpadding="0" width="100%" border="0" height="22">
										<tr>
											<td id="subhead_left" width="7"> <img src="/final/admin/eg_images/spacer.gif" border="0" width="7"> </td>
											<td id="eg_subheadbg" style="border-left-width: 0px; border-right-width: 0px;" align="center" width="100%"> <strong><egui:intnl text="admin.settings.Auditing"/></strong> </td>
											<td id="subhead_right" width="7"> <img src="/final/admin/eg_images/spacer.gif" border="0" width="7"> </td>
										</tr>
									</table>
								</td>
							</tr>
							<tr>
								<th class="form_border" style="border-bottom-width:0px" nowrap>
									<egui:intnl text="admin.settings.Enable auditing"/></th>
								<td class="form_border" style="border-bottom-width:0px" nowrap> &nbsp;:</td>
								<td class="form_border" style="border-bottom-width:0px" nowrap>
									<table  width="30%" cellspacing="0" cellpadding="0" border="0">
										<tr>
											<td id="eg_subcontentbg" class="eg_subcontent" width="20">
												<input type="radio" class="eg_input" name="EnableAuditlog" value="yes" <%=EnableAuditlog.equalsIgnoreCase("yes") ? "checked":""%> onClick="javascript:callAudit()">
											</td>
											<td><egui:intnl text="admin.common.Yes"/></td>
											<td id="eg_subcontentbg" class="eg_subcontent" width="20">
												<input type="radio"class="eg_input" name="EnableAuditlog" value="no" <%=EnableAuditlog.equalsIgnoreCase("no") ? "checked":""%> onClick="javascript:callAudit()">
											</td>
											<td><egui:intnl text="admin.common.No"/></td>
										</tr>
									</table>
								</td>
							</tr>

							<tr id="showCLI">
								<th class="<%=styleClass%>" style="border-top-width:1px;border-bottom-width:0px" nowrap>
									<egui:intnl text="admin.settings.Include activities from the admin command line interface"/></th>
								<td class="<%=styleClass%>" style="border-top-width:1px;border-bottom-width:0px" nowrap>&nbsp;:</td>
								<td class="<%=styleClass%>" style="border-top-width:1px;border-bottom-width:0px" nowrap>
									<table  width="30%" cellspacing="0" cellpadding="0" border="0">
										<tr>
											<td id="eg_subcontentbg" class="eg_subcontent" width="20">
												<input type="radio" class="eg_input" name="AuditlogForCLI" value="true" <%=auditlogForCLI.equalsIgnoreCase("true") ? "checked":""%>>
											</td>
											<td><egui:intnl text="admin.common.Yes"/></td>
											<td id="eg_subcontentbg" class="eg_subcontent" width="20">
												<input type="radio"class="eg_input" name="AuditlogForCLI" value="false" <%=auditlogForCLI.equalsIgnoreCase("false") ? "checked":""%>>
											</td>
											<td><egui:intnl text="admin.common.No"/></td>
										</tr>
									</table>
								</td>
							</tr>
							<tr>
								<td colspan="3">
									<table cellspacing="0" cellpadding="0" width="100%" border="0">
										<tr>
											<td height="6" id="inner_bott_left" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7" height="6" border="0"></td>
											<td id="eg_subcontentbg"  width="100%" valign="top" ><img src="/final/admin/eg_images/spacer.gif" height="6" border="0"></td>
											<td height="6" align="right" id="inner_bott_right" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7px" height="6px" border="0"></td>
										</tr>
									</table>
								</td>
							</tr>
						</table>
					</td>
				</tr>
				<input type='hidden' name='$_AuditlogForCLI' value='Display command line interface in auditlog$<%=auditlogForCLI.equalsIgnoreCase("true")?"true":"false"%>'>
				<input type='hidden' name='$_EnableAuditlog' value='AuditlogEnabled$<%=EnableAuditlog.equalsIgnoreCase("true")?"true":"false"%>'>
				<tr><td align="center" colspan="3" id="eg_blankspace" height="8">&nbsp;</td></tr>
<%
	}
	if(process.equals("") || process.equals("thresholdconfig"))
	{
%>
				<!-- Threshold Configuration - added by Latha  -->
				
				<tr>
					<td align="center">
						<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" style="table- layout:fixed" class="eg_subcontentbg"><col width="43%"><col width="15"><col width="57%">
							<tr>
								<td colspan="3">
									<table cellspacing="0" cellpadding="0" width="100%" border="0" height="22">
										<tr>
											<td id="subhead_left" width="7"> <img src="/final/admin/eg_images/spacer.gif" border="0" width="7"> </td>
											<td id="eg_subheadbg" style="border-left-width: 0px; border-right-width: 0px;" align="center" width="100%"> <strong><egui:intnl text="admin.settings.Threshold Configuration"/></strong> </td>
											<td id="subhead_right" width="7"> <img src="/final/admin/eg_images/spacer.gif" border="0" width="7"> </td>
										</tr>
									</table>
								</td>
							</tr>
<%
		if (thresholdChkInterval == null || thresholdChkInterval.trim().equals(""))
		{
			thresholdChkInterval = "day";
		}
	
%>
							<tr id="showCLI">
								<th class="form_border" id="eg_sucontentbg" style="border-bottom-width:1px" nowrap>
									<egui:intnl text="admin.settings.Automatic threshold computation policy"/></th>
								<td class="form_border" style="border-bottom-width:1px" nowrap>&nbsp;:</td>
								<td class="form_border" nowrap>&nbsp;<select name="threshInterval" style="width:120px" onchange="showtext()">
<%
	ArrayList thIntervalUIList = new ArrayList();
	thIntervalUIList.add("day");
	thIntervalUIList.add("week");
	thIntervalUIList.add("month");
	
	String threshIntervalStr = "";
	String auditEntry = "";
	String tempShowText = "";
		for(int i=0;i<thIntervalUIList.size();i++)
		{
			String format=(String)thIntervalUIList.get(i); 
			if(format.equalsIgnoreCase("day"))
			{
				threshIntervalStr = "Daily";
			}
			else if(format.equalsIgnoreCase("week"))
			{
				threshIntervalStr = "Weekly";
			}
			else if(format.equalsIgnoreCase("month"))
			{
				threshIntervalStr = "Monthly";
			}
			String selected = "";
			if (format.equals(thresholdChkInterval))
			{
				selected = "selected";
				auditEntry = threshIntervalStr;
				tempShowText = format+"(s)";
			}

%>
									<option value="<%=format%>" <%=selected%>><%=_mapping.getTextDescription("admin.settings."+threshIntervalStr)%></option>
<%
		}
%>
								</select></td>
								<input type='hidden' name='$_threshInterval' value='Automatic threshold computation policy$<%=auditEntry%>'>
								<input type='hidden' name='dummy_threshInterval' value='<%=tempShowText%>'>
							</tr>
							<tr>
								<th class="form_spacing" style="border-top-width:1px;border-bottom-width:0px" nowrap>
									<egui:intnl text="admin.settings.Lookback period to compute automatic thresholds"/></th>
								<td class="form_spacing" style="border-top-width:1px;border-bottom-width:0px" nowrap> &nbsp;:</td>
								<td class="form_spacing" nowrap>
									<table align="left" cellspacing="0" cellpadding="0" border="0">
										<tr>
											<td>&nbsp;<input type='text' name='thresholdCheckPeriod'  value="<%=thresholdChkVal%>" maxlength="256" style="width: 120px;"></td>
											<td id="showtext" align="left" name="showtext" >&nbsp;<%=tempShowText%></td>
										</tr>
									</table>
								</td>
								<input type='hidden' name='$_thresholdCheckPeriod' value='Lookback period to compute automatic thresholds$<%=thresholdChkVal%> <%=tempShowText%>'>
								</td>
							</tr>
							<tr>
								<td colspan="3">
									<table cellspacing="0" cellpadding="0" width="100%" border="0">
										<tr>
											<td height="6" id="inner_bott_left" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7" height="6" border="0"></td>
											<td id="eg_subcontentbg"  width="100%" valign="top" ><img src="/final/admin/eg_images/spacer.gif" height="6" border="0"></td>
											<td height="6" align="right" id="inner_bott_right" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7px" height="6px" border="0"></td>
										</tr>
									</table>
								</td>
							</tr>
						</table>
					</td>
				</tr>
				<tr><td align="center" colspan="3" id="eg_blankspace" height="8">&nbsp;</td></tr>
				<tr>
<%
	}
	if(process.equals("") || process.equals("advancedmgrsettings"))
	{
		String updateManConfig =  egDBIni.getValue("MANAGER_SETTINGS", "updateManConfig");
%>
<%
		//if(loginType.equals("Admin"))
		{
%>
					<!-- Manager Output Inclusion by Prakash.K starts -->
					<td align="center">
						<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" style="table- layout:fixed" class="eg_subcontentbg"><col width="43%"><col width="15"><col width="57%">
							<tr>
								<td colspan="3">
									<table cellspacing="0" cellpadding="0" width="100%" border="0" height="22">
										<tr>
											<td id="subhead_left" width="7"> <img src="/final/admin/eg_images/spacer.gif" border="0" width="7"> </td>
											<td id="eg_subheadbg" style="border-left-width: 0px; border-right-width: 0px;" align="center" width="100%"> <strong><egui:intnl text="admin.settings.ADVANCED SETTINGS"/></strong> </td>
											<td id="subhead_right" width="7"> <img src="/final/admin/eg_images/spacer.gif" border="0" width="7"> </td>
										</tr>
									</table>
								</td>
							</tr>
<%
			if(!EgInstallInfo.isClusterSupported)
			{
%>
							<tr>
								<th class="form_border"  nowrap>
									<egui:intnl text="admin.settings.Restart the manager now"/>&nbsp;?</th>
								<td class="form_border"  nowrap> &nbsp;:</td>
								<td class="form_border" nowrap>
									<table  width="55%" cellspacing="0" cellpadding="0" border="0">
										<tr>
											<td id="eg_subcontentbg" class="eg_subcontent" width="20">
												<input type="radio" class="eg_input" id="stlnMgrRestart" value="yes" onClick="javascript:restartAlert('standalone');" name="stlnMgrRestart">
											</td>
											<td style="width:75px"><egui:intnl text="admin.common.Yes"/></td>
											<td id="eg_subcontentbg" class="eg_subcontent" width="20">
											<input type="radio" class="eg_input" id="stlnMgrRestart" checked name="stlnMgrRestart"  value="no">
											</td>
											<td><egui:intnl text="admin.common.No"/></td>
										</tr>
									</table>
								</td>
							</tr>
							<input type='hidden' name='$_stlnMgrRestart' value='Restart the manager now ?$No'>
<%
			}
			else
			{
%>
							<tr>
								<th class="form_border"  nowrap>
									<egui:intnl text="admin.settings.Restart the manager now"/>&nbsp;?</th>
								<td class="form_border"  nowrap> &nbsp;:</td>
								<td class="form_border" nowrap>
									<table  width="55%" cellspacing="0" cellpadding="0" border="0">
										<tr>
											<td id="eg_subcontentbg" class="eg_subcontent" width="20">
												<input type="radio" class="eg_input" id="clusterMgrRestart" name="clusterMgrRestart" onClick="javascript:restartAlert('primary');" value="Primary">
											</td>
											<td style="width:75px"><egui:intnl text="admin.common.Primary"/></td>
											<td id="eg_subcontentbg" class="eg_subcontent" width="20">
												<input type="radio" class="eg_input" id="clusterMgrRestart" name="clusterMgrRestart" onClick="javascript:restartAlert('secondary');" 
												value="Secondary">
											</td>
											<td style="width:75px"><egui:intnl text="admin.common.Secondary"/></td>
											<td id="eg_subcontentbg" class="eg_subcontent" width="20">
												<input type="radio" class="eg_input" id="clusterMgrRestart" checked name="clusterMgrRestart" value="None">
											</td>
											<td><egui:intnl text="admin.common.None"/></td>
										</tr>
									</table>
								</td>
							</tr>
							<input type='hidden' name='$_clusterMgrRestart' value='Restart the manager now ?$None'>
<%
			}
%>
							<tr>
								<th class="form_border"  nowrap>
									<egui:intnl text="admin.settings.Manager Output and Error"/></th>
								<td class="form_border"  nowrap> &nbsp;:</td>
								<td class="form_border" nowrap>
									<table  width="55%" cellspacing="0" cellpadding="0" border="0">
										<tr>
											<td id="eg_subcontentbg" class="eg_subcontent" width="20">
												<input type="radio" class="eg_input" id="mgrOutput" name="mgrOutput" value="yes" <%=managerOutput.equalsIgnoreCase("yes")?"checked":""%> onClick="javascript:changeManagerOutput('on');">
											</td>
											<td style="width:75px"><egui:intnl text="admin.common.On"/></td>
											<td id="eg_subcontentbg" class="eg_subcontent" width="20">
											<input type="radio"class="eg_input" id="mgrOutput" name="mgrOutput" value="no" <%=managerOutput.equalsIgnoreCase("no")?"checked":""%> onClick="javascript:changeManagerOutput('off');" >
											</td>
											<td><egui:intnl text="admin.common.Off"/></td>
										</tr>
									</table>
								</td>
							</tr>
							<input type='hidden' name='$_mgrOutput' value='Manager Output and Error$<%=managerOutput.equalsIgnoreCase("yes")?"yes":"no"%>'>
							<tr>
								<th class="form_border" nowrap>
									<egui:intnl text="admin.settings.Output and Error mode"/></th>
								<td class="form_border" nowrap> &nbsp;:</td>
								<td class="form_border" nowrap>
									<table  width="55%" cellspacing="0" cellpadding="0" border="0">
										<tr>
											<td id="eg_subcontentbg" class="eg_subcontent" width="20">
												<input type="radio" class="eg_input" id="mgrOutputOverWirte" name="mgrOutputOverWirte" value="yes" <%=mgrOutputOverWirte.equalsIgnoreCase("yes")?"checked":""%> >
											</td>
											<td style="width:75px"><egui:intnl text="admin.common.Overwrite"/></td>
											<td id="eg_subcontentbg" class="eg_subcontent" width="20">
											<input type="radio"class="eg_input" id="mgrOutputOverWirte" name="mgrOutputOverWirte" value="no" <%=mgrOutputOverWirte.equalsIgnoreCase("no")?"checked":""%>  >
											</td>
											<td><egui:intnl text="admin.common.Append"/></td>
										</tr>
									</table>
								</td>
							</tr>
							<input type='hidden' name='$_mgrOutputOverWirte' value='Output mode$<%=mgrOutputOverWirte.equalsIgnoreCase("yes")?"yes":"no"%>'>
							
							<tr>
								<th class="form_spacing"  nowrap>
									<egui:intnl text="admin.settings.Update Manual Config Files"/>&nbsp;?</th>
								<td class="form_spacing"  nowrap> &nbsp;:</td>
								<td class="form_spacing" nowrap>
									<table  width="55%" cellspacing="0" cellpadding="0" border="0">
										<tr>
											<td id="eg_subcontentbg" class="eg_subcontent" width="20">
												<input type="radio" class="eg_input" id="manConfig" name="manConfig" value="yes" <%=updateManConfig.equalsIgnoreCase("yes")?"checked":""%>>
											</td>
											<td style="width:75px"><egui:intnl text="admin.common.Yes"/></td>
											<td id="eg_subcontentbg" class="eg_subcontent" width="20">
											<input type="radio"class="eg_input" id="manConfig" name="manConfig" value="no" <%=updateManConfig.equalsIgnoreCase("no")?"checked":""%>>
											</td>
											<td><egui:intnl text="admin.common.No"/></td>
										</tr>
									</table>
								</td>
							</tr>
							<input type='hidden' name='$_manConfig' value='Update Manual Config Files$<%=updateManConfig.equalsIgnoreCase("yes")?"yes":"no"%>'>
							<tr>
								<td colspan="3">
									<table cellspacing="0" cellpadding="0" width="100%" border="0">
										<tr>
											<td height="6" id="inner_bott_left" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7" height="6" border="0"></td>
											<td id="eg_subcontentbg"  width="100%" valign="top" ><img src="/final/admin/eg_images/spacer.gif" height="6" border="0"></td>
											<td height="6" align="right" id="inner_bott_right" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7px" height="6px" border="0"></td>
										</tr>
									</table>
								</td>
							</tr>
						</table>
					</td>
				</tr>
				<tr><td align="center" colspan="3" id="eg_blankspace" height="8">&nbsp;</td></tr>
				
					<!-- Manager Output Inclusion by Prakash.K finish-->
<%
		}
	}
	if(process.equals("") || process.equals("capacityplanning"))
	{
%>
				<tr>
					<td align="center">
						<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" style="table- layout:fixed" class="eg_subcontentbg"><col width="43%"><col width="15"><col width="57%">
							<tr>
								<td colspan="3">
									<table cellspacing="0" cellpadding="0" width="100%" border="0" height="22">
										<tr>
											<td id="subhead_left" width="7">
												<img src="/final/admin/eg_images/spacer.gif" border="0" width="7">
											</td>
											<td id="eg_subheadbg" style="border-left-width: 0px; border-right-width: 0px;" align="center" width="100%">
												<strong><egui:intnl text="admin.settings.Capacity Planning"/></strong> 
											</td>
											<td id="subhead_right" width="7">
												<img src="/final/admin/eg_images/spacer.gif" border="0" width="7">
											</td>
										</tr>
									</table>
								</td>
							</tr>
							<tr>
								<th class="form_border" nowrap><egui:intnl text="admin.settings.Enable capacity computation by the manager"/></th>
								<td class="form_border" nowrap >&nbsp;:</td>

								<td class="form_border" nowrap>
									<table  width="30%" cellspacing="0" cellpadding="0" border="0">
										<tr>
											<td id="eg_subcontentbg" class="eg_subcontent" width="20">
												<input type="radio" class="eg_input" name="capacitytrend" value="true" <%=capacitytrendenable.equalsIgnoreCase("true")?"checked":""%> >
											</td>
											<td><egui:intnl text="admin.common.Yes"/></td>
											<td id="eg_subcontentbg" class="eg_subcontent" width="20">
												<input type="radio" class="eg_input" name="capacitytrend" value="false" <%=capacitytrendenable.equalsIgnoreCase("false")?"checked":""%> >
											</td>
											<td><egui:intnl text="admin.common.No"/></td>
										</tr>
									</table>
								</td>
							</tr>
							<input type='hidden' name='$_capacitytrend' value='Enable capacity computation by the manager$<%=capacitytrendenable.equalsIgnoreCase("true")?"true":"false"%>'>
							<tr>
								<th class="form_border" style="border-bottom-width:0px" nowrap><egui:intnl text="admin.settings.Enable capacity reports"/></th>
								<td class="form_border" nowrap style="border-bottom-width:0px">&nbsp;:</td>

								<td class="form_border" style="border-bottom-width:0px" nowrap>
									<table  width="30%" cellspacing="0" cellpadding="0" border="0">
										<tr>
											<td id="eg_subcontentbg" class="eg_subcontent" width="20">
												<input type="radio" class="eg_input" name="capcityreport" value="true" <%=capacityreportenable.equalsIgnoreCase("true")?"checked":""%> >
											</td>
											<td><egui:intnl text="admin.common.Yes"/></td>
											<td id="eg_subcontentbg" class="eg_subcontent" width="20">
												<input type="radio" class="eg_input" name="capcityreport" value="false" <%=capacityreportenable.equalsIgnoreCase("false")?"checked":""%> >
											</td>
											<td><egui:intnl text="admin.common.No"/></td>
										</tr>
									</table>
								</td>
							</tr>
							<input type='hidden' name='$_capcityreport' value='Enable capacity reports$<%=capacityreportenable.equalsIgnoreCase("true")?"true":"false"%>'>
							<tr>
								<td colspan="3">
									<table cellspacing="0" cellpadding="0" width="100%" border="0">
										<tr>
											<td height="6" id="inner_bott_left" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7" height="6" border="0"></td>
											<td id="eg_subcontentbg"  width="100%" valign="top" ><img src="/final/admin/eg_images/spacer.gif" height="6" border="0"></td>
											<td height="6" align="right" id="inner_bott_right" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7px" height="6px" border="0"></td>
										</tr>
									</table>
								</td>
							</tr>
						</table>
					</td>
				</tr>
				<tr><td align="center" colspan="3" id="eg_blankspace" height="8">&nbsp;</td></tr>
<%
	}
	if (process.equals("") || process.equals("virtualtopology"))
	{
%>
				<tr>
					<td align="center">
						<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" style="table- layout:fixed" class="eg_subcontentbg"><col width="43%"><col width="15"><col width="57%">
							<tr>
								<td colspan="3">
									<table cellspacing="0" cellpadding="0" width="100%" border="0" height="22">
										<tr>
											<td id="subhead_left" width="7">
												<img src="/final/admin/eg_images/spacer.gif" border="0" width="7">
											</td>
											<td id="eg_subheadbg" style="border-left-width: 0px; border-right-width: 0px;" align="center" width="100%">
												<strong><egui:intnl text="admin.settings.Virtual Topology"/></strong> 
											</td>
											<td id="subhead_right" width="7">
												<img src="/final/admin/eg_images/spacer.gif" border="0" width="7">
											</td>
										</tr>
									</table>
								</td>
							</tr>
							<tr>
								<th class="form_border" style="border-bottom-width:0px" nowrap><egui:intnl text="admin.settings.Virtual topology mapping"/></th>
								<td class="form_border" nowrap style="border-bottom-width:0px">&nbsp;:</td>
								<td class="form_border" style="border-bottom-width:0px" nowrap>
									<table  width="40%" cellspacing="0" cellpadding="0" border="0">
										<tr>
											<td id="eg_subcontentbg" class="eg_subcontent" width="20">
												<input type="radio" class="eg_input" name="virtualmapping" value="Auto" <%=strVirtualMapping.equalsIgnoreCase("true")?"checked":""%>>
											</td>
											<td><egui:intnl text="admin.common.Auto"/></td>
											<td id="eg_subcontentbg" class="eg_subcontent" width="20">
												<input type="radio" class="eg_input" name="virtualmapping" value="Manual" <%=strVirtualMapping.equalsIgnoreCase("false")?"checked":""%>>
											</td>
											<td><egui:intnl text="admin.common.Manual"/></td>
										</tr>
									</table>
								</td>
							</tr>
							<input type='hidden' name='$_virtualmapping' value='Virtual topology mapping$<%=strVirtualMapping.equalsIgnoreCase("true")?"Auto":"Manual"%>'>
							<tr>
								<td colspan="3">
									<table cellspacing="0" cellpadding="0" width="100%" border="0">
										<tr>
											<td height="6" id="inner_bott_left" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7" height="6" border="0"></td>
											<td id="eg_subcontentbg"  width="100%" valign="top" ><img src="/final/admin/eg_images/spacer.gif" height="6" border="0"></td>
											<td height="6" align="right" id="inner_bott_right" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7px" height="6px" border="0"></td>
										</tr>
									</table>
								</td>
							</tr>
						</table>
					</td>
				</tr>
				<tr><td align="center" colspan="3" id="eg_blankspace" height="8">&nbsp;</td></tr>
<%
	}
%>
				<tr>
					<td align="center" colspan="2" >
						<table align="center" cellspacing="0" cellpadding="2" width="90%" border="0">
							<tr>
								<td colspan="3" align="center" height="20" nowrap><input type="button" value='<egui:intnl text="admin.common.Update"/>' name="update" style="width: 85px;" id="eg_back" onClick="javascript:validateTextBoxes('<%=process%>')"></td>
							</tr>
						</table>
					</td>
				</tr>
				<tr>
					<td align="center" colspan="3" id="eg_blankspace" height="8">&nbsp;</td>
				</tr>
			</table>
		</td>
	</tr>
</table>
<%
	if(process.equals("") || process.equals("general"))
	{
%>
		<input type='hidden' name='$_relativeThresholdTime' value="">
		<script language="JavaScript">
			selectValues('<%=relativeThresholdHours%>');
		</script>
<%
	}
%>
<!-- CONFIGURE MESSAGE ENDS HERE -->
</form>
<%
	if(from.equals("mgrstree"))
	{
		if(request.getQueryString()!=null)
		{
			session.setAttribute("adminLastAccessedURL","/final/admin/EgSettingsTree.jsp?"+request.getQueryString()+"&treeViewSrc=/final/admin/managerSettings.jsp?process="+process+"&showtree=settingstree");
		}
		else
		{
			session.setAttribute("adminLastAccessedURL","/final/admin/EgSettingsTree.jsp&treeViewSrc=/final/admin/managerSettings.jsp?process="+process+"&showtree=settingstree");
		}
	}
	else
	{
		session.setAttribute("adminLastAccessedURL","/final/admin/managerSettings.jsp?"+request.getQueryString()+"&process="+process+"&showtree=settingstree");
	}
%>

</body>
</html>
<%
}
catch ( Exception e )
{
	System.err.println("[Exception] @ managerSettings.jsp "+e);
	e.printStackTrace();
}
%>