<%
/************************************************************************************************************
*	Name			:	deleteAgentsp.jsp ( common file for deleting both external and remote agents)
*	Purpose			:	to delete external/remote agents which do not manage any hosts
*	Version			:	4.3
*	CreationDate	:	8/27/2008
*	Author			:	James Thomas P
***********************************************************************************************************/
%>
<%@ include file = "EgTrackerA.jsp"%>
<%@ page errorPage="EgProbs.jsp"%>
<%@ page import = "com.eg.AgentConfig"%>
<%@ page import = "com.eg.EgExternalInfo"%>
<%@ page import = "com.egurkha.util.StringUtils"%>
<%@ page import = "java.util.Vector"%>
<%@ page import = "com.egurkha.admin.AuditLogThread"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<jsp:useBean id="trans" scope="page" class="egurkha.TransactionBean"/>

<%
	/* code for auditlog starts */
	AuditLogThread auditLogThread = new AuditLogThread();
	auditLogThread.setValue("Category","Admin");
	auditLogThread.setValue("User_id",_user.getLoginID());
	auditLogThread.setValue("Host_ip",_user.getUserIP(session.getId()));
	auditLogThread.setValue("Session_id",session.getId());
	auditLogThread.setValue("Module","Delete Agents");
	/* code for auditlog ends */

	//trans.createFile("eg_external.ini","save");
	trans.createSyncFile("eg_external.ini","save");
	AgentConfig agentConfig=AgentConfig.getAgentConfig();
	EgExternalInfo externalInfo = new EgExternalInfo("manager");
	Vector allInternalHosts = externalInfo.getAllAgents();

	Vector sessionVector = new Vector();
	String from = request.getParameter("from");

	if(from != null && from.equalsIgnoreCase("deleteExternalAgentsPage"))
	{
		auditLogThread.setValue("Activity","External Agents");
		String externalAgentsStr = request.getParameter("externalAgents");
		String externalAgentsArr[] = StringUtils.getTokens(externalAgentsStr,",");
		if(allInternalHosts != null && externalAgentsArr != null && externalAgentsArr.length > 0 )
		{
			for(int e=0;e<externalAgentsArr.length;e++)
			{
				String s_eagent = externalAgentsArr[e];
				if (allInternalHosts.contains(s_eagent))
				{
					Vector sess_vec = new Vector();
					sess_vec.add(_mapping.getTextDescription("admin.error.List of external agent"));
					sess_vec.add("DeleteExternalAgents.jsp");
					sess_vec.add(_mapping.getTextDescription("admin.error.Delete external agent"));
					sess_vec.add(_mapping.getTextDescription("admin.error.This external agent has been used as an internal agent to one or more hosts")+".");
					sess_vec.add(_mapping.getTextDescription("admin.error.It needs to be disassociated as the internal agent from the host(s)")+".");
					sess_vec.add(_mapping.getTextDescription("admin.error.Go to the Components Add/Modify page to perform this action before deleting this agent")+".");
					session.setAttribute("vec_Errors",sess_vec);
					String url = "EgErrors.jsp";
					/* auditlog - start */
					auditLogThread.setValue("Activity","Add/Delete");
					auditLogThread.setCurrentValue("ColumnName","External Agent Not Deleted");
					auditLogThread.setCurrentValue("Host/Nick name",externalAgentsStr);
					auditLogThread.setValue("Description","External agent has not been deleted since it is assigned as an internal agent to one or more hosts");
					auditLogThread.sendItToDB();
					/* auditlog - end */
%>
	<jsp:forward page="<%=url%>"/>
<%
				}
			}
		}
		auditLogThread.setValue("Activity","External Agents");
		if(externalAgentsStr != null && !externalAgentsStr.equalsIgnoreCase("null") && externalAgentsStr.trim().length()>0)
		{
			String externalAgents[] = StringUtils.getTokens(externalAgentsStr,",");
			for(int i=0;i<externalAgents.length;i++)
			{
				trans.deleteSpecValue(EgExternalInfo.emulationByExtAgent, externalAgents[i]);
				trans.deleteSpecValue(EgExternalInfo.extAgentsSection, externalAgents[i]);
				agentConfig.removeAgentElement(externalAgents[i]);
				auditLogThread.setCurrentValue("Agent Names",externalAgents[i]);
			}
		}
		sessionVector.addElement(_mapping.getTextDescription("admin.common.Delete External Agents"));
		sessionVector.addElement("DeleteExternalAgents.jsp");
		sessionVector.addElement(_mapping.getTextDescription("admin.common.Delete External Agents"));
		sessionVector.addElement(_mapping.getTextDescription("admin.common.External agent(s) deleted from eG system")+"...");
		auditLogThread.setValue("Description","External agents have been deleted from eG system");
	}
	else if(from != null && from.equalsIgnoreCase("deleteRemoteAgentsPage"))
	{
		String remoteAgentsStr = request.getParameter("remoteAgents");
		String remoteAgentsArr[] = StringUtils.getTokens(remoteAgentsStr,",");
		if(allInternalHosts != null && remoteAgentsArr != null && remoteAgentsArr.length > 0)
		{
			for(int r=0;r<remoteAgentsArr.length;r++)
			{
				String s_ragent = remoteAgentsArr[r];
				if (allInternalHosts.contains(s_ragent))
				{
					Vector sess_vec = new Vector();
					sess_vec.add(_mapping.getTextDescription("admin.error.List of remote agent"));
					sess_vec.add("DeleteRemoteAgents.jsp");
					sess_vec.add(_mapping.getTextDescription("admin.error.Delete remote agent"));
					sess_vec.add(_mapping.getTextDescription("admin.error.This remote agent has been used as an internal agent to one or more hosts")+".");
					sess_vec.add(_mapping.getTextDescription("admin.error.It needs to be disassociated as the internal agent from the host(s)")+".");
					sess_vec.add(_mapping.getTextDescription("admin.error.Go to the Components Add/Modify page to perform this action before deleting this agent")+".");
					session.setAttribute("vec_Errors",sess_vec);
					String url = "EgErrors.jsp";
					/* auditlog - start */
					auditLogThread.setValue("Activity","Add/Delete");
					auditLogThread.setCurrentValue("ColumnName","Remote Agent Not Deleted");
					auditLogThread.setCurrentValue("Host/Nick name",remoteAgentsStr);
					auditLogThread.setValue("Description","Remote agent has not been deleted since it is assigned as an internal agent to one or more hosts");
					auditLogThread.sendItToDB();
					/* auditlog - end */
%>
	<jsp:forward page="<%=url%>"/>
<%
				}
			}
		}

		auditLogThread.setValue("Activity","Remote Agents");
		if(remoteAgentsStr != null && !remoteAgentsStr.equalsIgnoreCase("null") && remoteAgentsStr.trim().length()>0)
		{
			String remoteAgents[] = StringUtils.getTokens(remoteAgentsStr,",");
			for(int i=0;i<remoteAgents.length;i++)
			{
				trans.deleteSpecValue(EgExternalInfo.remoteAgentsSection, remoteAgents[i]);
				agentConfig.removeAgentElement(remoteAgents[i]);
				auditLogThread.setCurrentValue("Agent Names",remoteAgents[i]);
			}
		}
		sessionVector.addElement(_mapping.getTextDescription("admin.common.Delete Remote Agents"));
		sessionVector.addElement("DeleteRemoteAgents.jsp");
		sessionVector.addElement(_mapping.getTextDescription("admin.common.Delete Remote Agents"));
		sessionVector.addElement(_mapping.getTextDescription("admin.common.Remote agent(s) deleted from eG system")+"...");
		auditLogThread.setValue("Description","Remote agents have been deleted from eG system");
	}
	trans.saveFile();
	trans.releaseInstance();
	auditLogThread.sendItToDB();
	session.putValue("vec_Results",sessionVector);
%>
	<jsp:forward page="EgResults.jsp" />