<%
/*******************************************************************************
 *	Name            :	aggConfigLayersForServerp.jsp
 *	Purpose         :	Processing page for aggConfigLayersForServerp.jsp
 *	Author          :	James Thomas P.
 *	Version         :	5.2
 *	CreationDate    :   09/02/2011
 *******************************************************************************/
%>
<%@ include file="EgTrackerA.jsp" %>
<%@ page errorPage="EgProbs.jsp"%>
<%@ page import = "egurkha.*" %>
<%@ page import = "com.eg.UpdateAndTransmitICInfo"%>
<%@ page import = "com.eg.DeleteMailFilterElements"%>
<%@ page import = "com.egurkha.admin.AuditLogThread"%>
<%@ page import = "com.egurkha.ini.IniUI"%>
<%@ page import="com.eg.EgAggregateInfo" %>
<%@ page import="com.eg.EgSpecsInfo" %>
<%@ page import = "com.egurkha.util.StringUtils"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
%>
<%
	/* code for auditlog starts */
	AuditLogThread auditLogThread = new AuditLogThread();
	auditLogThread.setValue("Category","Admin");
	auditLogThread.setValue("User_id",_user.getLoginID());
	auditLogThread.setValue("Host_ip",_user.getUserIP(session.getId()));
	auditLogThread.setValue("Session_id",session.getId());
	auditLogThread.setValue("Module","Aggregates");
	auditLogThread.setValue("Activity","Component Layer Configuration");
	/* code for auditlog ends */

	String server = request.getParameter("server");
	String layerList = request.getParameter("fassociate");
	String oldLayerList = request.getParameter("layerlist");
	LayerBean layerBean = new LayerBean(true);

	EgAggregateInfo aggregateInfo = new EgAggregateInfo("manager");
	EgSpecsInfo specsInfo = new EgSpecsInfo("manager");

	if(isListValid(layerList))
	{
		if(layerBean.checkLayersForServer(server, layerList)) //ini related
		{
			layerBean = null;
			ServerBean serverBean = new ServerBean(true);
			serverBean.removeServerFromTables(server); //ini related
			serverBean = null;

			layerBean = new LayerBean(true);
			layerBean.updateLayersForServer(server, layerList); //ini related
			layerBean.updateTestsForServer(server, layerList, oldLayerList);//inirelated

			UpdateAndTransmitICInfo updateICInfo = new UpdateAndTransmitICInfo();
			if(updateICInfo.updateLayersForServer(server, layerList))
			{
				/* code for auditlog starts */
				boolean test = false;
				ArrayList oldLayers = new ArrayList();
				ArrayList newLayers = new ArrayList();
				if(oldLayerList != null && !oldLayerList.equalsIgnoreCase("null") && oldLayerList.trim().length()>0)
				{
					StringTokenizer tokens = new StringTokenizer(oldLayerList,",");
					while(tokens.hasMoreTokens()){
						String layerTemp = tokens.nextToken();
						oldLayers.add(layerTemp);
					}
					test = true;
				}
				if(layerList != null && !layerList.equalsIgnoreCase("null") && layerList.trim().length()>0)
				{
					StringTokenizer tokens = new StringTokenizer(layerList,",");
					while(tokens.hasMoreTokens()){
						String layerTemp = tokens.nextToken();
						newLayers.add(layerTemp);
					}
					test = true;
				}
				if( !oldLayers.containsAll(newLayers)
						|| !newLayers.containsAll(oldLayers) )
				{
					ArrayList alprevTemp = new ArrayList(oldLayers);
					ArrayList alCurrentTemp = new ArrayList(newLayers);
					alprevTemp.removeAll(alCurrentTemp);
					for(int i=0; i<alprevTemp.size(); i++)
					{
						String layerTmp = (String)alprevTemp.get(i);
						auditLogThread.setCurrentValue("Disassociated layer(s)","$layer$:"+layerTmp);
					}
					alprevTemp = new ArrayList(oldLayers);//reset to old condition
					alCurrentTemp.removeAll(alprevTemp);
					for(int i=0; i<alCurrentTemp.size(); i++)
					{
						String layerTmp = (String)alCurrentTemp.get(i);
						auditLogThread.setCurrentValue("Associated layer(s)","$layer$:"+layerTmp);
					}
				}
				auditLogThread.setValue("Description","Layers have been configured for component type"+" "+"$ctype$:"+server);
				auditLogThread.sendItToDB();
				/* code for auditlog endss */

				oldLayers.removeAll(newLayers);
				if(oldLayers.size() > 0)
				{
					DeleteMailFilterElements delMailFilterElements = new DeleteMailFilterElements();
					delMailFilterElements.deleteLayersForSerevr(server,oldLayers);
				}
				String fromPage = request.getParameter("from_jsp");
				if(!StringUtils.isNull(fromPage) && fromPage.equals("aggCreateComponent"))
				{
					Vector sess_vec = new Vector();
					sess_vec.addElement(_mapping.getTextDescription("admin.aggregate.Test configuration page"));
					sess_vec.addElement("aggConfigureTestsToServer.jsp?server="+server);
					sess_vec.addElement(_mapping.getTextDescription("admin.aggregate.Layer configuration")+".");
					sess_vec.addElement(_mapping.getTextDescription("admin.aggregate.Layers have been configured successfully")+"...");
					session.setAttribute("vec_Results",sess_vec);
%>
					<jsp:forward page="EgResults.jsp"/>
<%
				}
				String tempScrollPosition_back = request.getParameter("tempScrollPosition_back");
				if (tempScrollPosition_back == null)
				{
					tempScrollPosition_back = "";
				}
				Vector sess_vec = new Vector();
				sess_vec.addElement(_mapping.getTextDescription("admin.ic.Aggregates - Component"));
				sess_vec.addElement("aggDisplayServers.jsp?scrollPosition_back="+tempScrollPosition_back);
				sess_vec.addElement(_mapping.getTextDescription("admin.ic.Aggregates - Component")+".");
				sess_vec.addElement(_mapping.getTextDescription("admin.ic.Layers have been configured successfully")+"...");
				session.setAttribute("vec_Results",sess_vec);
%>
				<jsp:forward page="EgResults.jsp" />
<%
			}
			else
			{
				Vector errors = new Vector();
				errors.addElement(_mapping.getTextDescription("admin.error.Configure layers for component"));
				errors.addElement("aggConfigLayersForServer.jsp?server=" + server);
				errors.addElement(_mapping.getTextDescription("admin.error.Possible Reason"));
				errors.addElement(_mapping.getTextDescription("admin.error.DB connection failed"));
				errors.addElement(_mapping.getTextDescription("admin.error.Please check if the DB is up and try again"));
				session.setAttribute("vec_Errors", errors);

				/* code for auditlog starts */
				auditLogThread.setValue("Description","DB connection had been failed"+". "+"Layer configuration failed for component type"+" "+"$ctype$:"+server);
				auditLogThread.sendItToDB();
				/* code for auditlog ends */
%>
				<jsp:forward page="EgErrors.jsp" />
<%
			}
		}
		else
		{
			Vector errors = new Vector();
			errors.addElement(_mapping.getTextDescription("admin.error.Configure layers for component"));
			errors.addElement("aggConfigLayersForServer.jsp?server=" + server);
			errors.addElement(_mapping.getTextDescription("admin.error.Possible Reason"));
			errors.addElement(_mapping.getTextDescription("admin.error.Layers specific to Oracle Server cannot be associated with other component types")+".");
			errors.addElement(_mapping.getTextDescription("admin.error.Please remove Oracle layers associated with this component type and try again")+".");
			session.setAttribute("vec_Errors", errors);

			/* code for auditlog starts */
			auditLogThread.setValue("Description","Layers specific to Oracle server cannot be associated with component type"+" " +"$ctype$:"+server);
			auditLogThread.sendItToDB();
			/* code for auditlog ends */
%>
			<jsp:forward page="EgErrors.jsp" />
<%
		}
	}
	else
	{
		Vector errors = new Vector();
		errors.addElement(_mapping.getTextDescription("admin.error.Configure layers for component"));
		errors.addElement("aggConfigLayersForServer.jsp?server=" + server);
		errors.addElement(_mapping.getTextDescription("admin.error.Possible Reason"));
		errors.addElement(_mapping.getTextDescription("admin.error.Operating System layer, if used, should be the lowest in hierarchy")+".");
		errors.addElement(_mapping.getTextDescription("admin.error.Please change Operating System as the lowest layer and try again")+".");
		session.setAttribute("vec_Errors", errors);

		/* code for auditlog starts */
		auditLogThread.setValue("Description","Operating System layer should be the lowest in hierarchy for component type" +" " + "$ctype$:"+server);
		auditLogThread.sendItToDB();
		/* code for auditlog ends */
%>
		<jsp:forward page="EgErrors.jsp" />
<%
	}
%>

<%!
	private boolean isListValid(String layerList)
	{
		boolean valid = true;
		String[] tokens = com.egurkha.util.StringUtils.getTokens(layerList, ",");
		for(int a=0; a<tokens.length; a++)
		{
			if (tokens[a].equals("HOST") && (a != tokens.length-1))
			{
				valid = false;
				break;
			}
		}
		return valid;
	}
%>
