<%
/***********************************************************************************************************
*	Name			:	renamep.jsp
*	Purpose			:	Process page for rename.jsp
*	Version			:	5.5
*	CreationDate	:	17-Feb-2012
*	Author			:	James Thomas P
***********************************************************************************************************/
%>

<%@ include file="../../EgTrackerAJSON.jsp" %>
<%@ page errorPage="../../EgProbs.jsp"%>
<%@ page import = "com.eg.IniFile"%>
<%@ page import = "com.eg.EgGroupInfoAdmin"%>
<%@ page import = "com.eg.EgStateZone"%>
<%@ page import = "com.eg.EgConfigInfo"%>
<%@ page import = "com.eg.EgURLDecoder"%>
<%@ page import = "com.eg.EgConfigFilesSync"%>
<%@ page import = "com.eg.EgTTFilterInfo"%>
<%@ page import = "com.egurkha.admin.Rename"%>
<%@ page import = "com.egurkha.admin.AuditLogThread"%>
<%@ page import = "com.egurkha.ini.IniUI"%>
<%@ page import = "com.egurkha.util.StringUtils"%>
<%@ page import = "com.egurkha.monitor.EgCustomDashboardModel"%>
<%@ page import = "java.util.*"%>
<%@ page import = "java.util.Map.Entry"%>
<%@ page import="net.sf.json.*"%>
<%@ page language="java" contentType="application/json; charset=UTF-8" pageEncoding="UTF-8" %>
<jsp:useBean id="ecumb" scope="page" class="com.egurkha.monitor.EgComponentUserMappingBean" />

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);

	response.setContentType("application/json;charset=UTF-8");
	JSONObject rootJson = new JSONObject();

	String rename = request.getParameter("rename");
	String old_name = EgURLDecoder.decode(request.getParameter("old_name"),"UTF-8");
	String new_name = EgURLDecoder.decode(request.getParameter("new_name"),"UTF-8");

	String message = null;
	boolean renameStatus = true;
	
	String monitorLastSession=(String)session.getAttribute("monitorLastSession");
	String newUrlLink="";
	String oldZoneName="";
	String urlLink="";

	if(monitorLastSession!=null && monitorLastSession.trim().length()>0)
	{
		if(monitorLastSession.indexOf('?') == -1)
		{
			newUrlLink=monitorLastSession;
		}
		else
		{
			newUrlLink=monitorLastSession.substring(0,monitorLastSession.indexOf('?'));
			urlLink = monitorLastSession.substring(monitorLastSession.indexOf('?')+1);
		}
		
		if(urlLink!=null && urlLink.trim().length()>0)
		{
			StringTokenizer multiTokenizer = new StringTokenizer(urlLink,"&");
			while(multiTokenizer.hasMoreTokens())
			{
				String param = multiTokenizer.nextToken();
				int ind = param.indexOf("=");
				if (ind < 0)
					continue;
				String reqparam =param.substring(0,ind);
				String value = param.substring(ind+1);
				
				if(reqparam != null && reqparam.equals("zoneName"))
				{
					String zoneValue = value;
					if(zoneValue != null && zoneValue.trim().length()>0)
					{
						oldZoneName=com.eg.EgURLDecoder.decode(zoneValue, "UTF-8");
					}
				}
			}
		}
	}
	if(StringUtils.isNull(old_name) || StringUtils.isNull(new_name) || StringUtils.isNull(rename))
	{
		renameStatus = false;
		if(StringUtils.isNull(rename))
		{
			message = _mapping.getTextDescription("admin.error.Operation is not defined")+".";
		}
		else
		{
			if(StringUtils.isNull(new_name))
			{
				message = _mapping.getTextDescription("admin.error.You can not proceed renaming with new name as empty or null")+".";
			}
			else
			{
				message = _mapping.getTextDescription("admin.error.You can not proceed renaming as current name is empty or null")+".";
			}
		}
	}
	else
	{
		rename = rename.trim();
		old_name = old_name.trim();
		new_name = new_name.trim();

		if(IniUI.isEgReservedKeyword(new_name))
		{
			renameStatus = false;
			message = "'"+new_name.toUpperCase() +"' "+_mapping.getTextDescription("admin.error.is an eG defined keyword")+". "+_mapping.getTextDescription("admin.error.Choose another name")+".";
		}
		else
		{
			boolean oldNameExist = false;
			boolean isSite = false;
			String auditlogLabel = null;
			String nameConflictLabel = null;
			String update_msmt_table = "true";
			Vector nameConflict = new Vector();//dont add anything into this vector

			AuditLogThread auditLogThread = new AuditLogThread();
			auditLogThread.setValue("Category","Admin");
			auditLogThread.setValue("User_id",_user.getLoginID());
			auditLogThread.setValue("Host_ip",_user.getUserIP(session.getId()));
			auditLogThread.setValue("Session_id",session.getId());
			auditLogThread.setValue("Activity","Rename Zone");

			String targetPageURL = null;
			
			auditLogThread.setValue("Module","Zones");
			oldNameExist = Rename.doesOldnameExist(new EgGroupInfoAdmin().getZoneNames(),old_name,new_name,nameConflict);
			nameConflictLabel="admin.error.You are trying to rename a zone with a name which is already assigned to another zone";
			auditlogLabel=old_name + " zone can not be renamed to "+new_name +" as this name is already assigned to some other zone";
			
			
			if(!nameConflict.isEmpty())
			{
				renameStatus = false;
				auditLogThread.setValue("Description",auditlogLabel);
				auditLogThread.sendItToDB();
				message = _mapping.getTextDescription(nameConflictLabel)+".";
			}
			else
			{
				if(oldNameExist)
				{
					boolean success = false;
									
					Rename renameObj = new Rename(u_rs,"Zone",old_name,new_name,update_msmt_table,isSite);
					success = renameObj.executeDefaultQueries();
					if(!success)
					{
						renameStatus = false;
						auditLogThread.setPreviousValue("Zone name",old_name);
						auditLogThread.setCurrentValue("Zone name",new_name);
						auditLogThread.setValue("Description","Database tables have not been updated with new zone name");
						auditLogThread.sendItToDB();
						message = _mapping.getTextDescription("admin.error.Problem while updating database tables") + ".";
					}
					if(renameStatus)
					{		
						//Citrix Dashboard View Update starts
						try
						{
							List users = new ArrayList();
							List removeUsers = new ArrayList();
							Hashtable userZoneMap = new Hashtable();
							Hashtable userAllMap = new Hashtable();
							userZoneMap = ecumb.getUserZones();
							userAllMap = ecumb.getUsers();
							
							if(!userAllMap.isEmpty())
							{
								Iterator itr = userAllMap.entrySet().iterator();
								while(itr.hasNext())
								{
									Entry en = (Entry)itr.next();
									String usr_name = (String)en.getKey();
									String usr_role = (String)en.getValue();
									//if(usr_role.equalsIgnoreCase("Admin"))
									if(usr_role.equalsIgnoreCase("Admin") || usr_role.equalsIgnoreCase("ServerAdmin") || usr_role.equalsIgnoreCase("SupermonitorNoConfig") || usr_role.equalsIgnoreCase("Supermonitor"))
										users.add(usr_name);
									else if(usr_role.equalsIgnoreCase("AlarmViewer"))
										removeUsers.add(usr_name);
								}
							}

							if(!userZoneMap.isEmpty())
							{
								Iterator itr = userZoneMap.entrySet().iterator();
								while(itr.hasNext())
								{
									Entry en = (Entry)itr.next();
									String usr_name = (String)en.getKey();
									LinkedList this_list = (LinkedList)en.getValue();
									if(this_list.contains(new_name))
									{
										users.add(usr_name);
									}								
								}
							}
							users.removeAll(removeUsers);
							int userSize = users.size();
							if(users != null && userSize > 0)
							{
								Hashtable deleteHash = new Hashtable();
								Hashtable addHash = new Hashtable();
								IniFile citrixIni = new com.eg.IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_citrixdashboard.ini");
								String dashBoardSet = citrixIni.getValue("Dashboard_List","Dashboard_Names");
								ArrayList dashBoardList = com.egurkha.util.StringUtils.egTokenizer(dashBoardSet,",",false,true,true);
								int dashBoardListSize = dashBoardList.size();
								String userName = "";
								String dashboardType = "";
								boolean saveFile = false;
								for(int i=0;i<userSize;i++)
								{
									userName = (String)users.get(i);
									for(int c=0;c<dashBoardListSize;c++)
									{
										dashboardType = (String)dashBoardList.get(c);
										String subject = userName+":"+dashboardType+":Mapping";
										Vector vars = citrixIni.getVariables(subject,true);
										Vector vals = citrixIni.getAllValues(subject);
										if(vars != null && vars.size()>0 && vals != null && vals.size()>0)
										{
											int valSize = vals.size();
											for(int ic=0;ic<valSize;ic++)
											{
												String varsString = vars.get(ic).toString();
												String valsString = vals.get(ic).toString();
												if(valsString.startsWith("Zone:") && valsString.indexOf(old_name+"#") > -1)
												{
													Vector var = (Vector) deleteHash.get(subject);
													if (var == null)
														var = new Vector();
														
													var.add(varsString);
													deleteHash.put(subject,var);
													
													valsString = valsString.replace(old_name,new_name);

													Vector valVar = (Vector) addHash.get(subject);
													
													if(valVar != null)
													{
														Vector _vars  = (Vector)valVar.get(0);
														Vector _vals  = (Vector)valVar.get(1);
														_vars.add(varsString);
														_vals.add(valsString);

														//addHash.put(subject,valVar);
													}
													else
													{
														Vector varss = new Vector();
														Vector valss = new Vector();
														varss.add(varsString);
														valss.add(valsString);

														valVar = new Vector();
														valVar.add(varss);
														valVar.add(valss);
														addHash.put(subject,valVar);
													}												
												}											
											}
										}						
									}
								}
								
								if(!deleteHash.isEmpty() && !addHash.isEmpty())
								{
									IniFile citrixSync = EgConfigFilesSync.getInstance(EgConfigInfo.egMgrConfigDir + "eg_citrixdashboard.ini");

									try
									{
										if (deleteHash.size() > 0)
										{
											Enumeration ee = deleteHash.keys();
											while (ee.hasMoreElements())
											{
												String key = (String) ee.nextElement();
												Vector vars = (Vector)deleteHash.get(key);
												if (vars != null && vars.size() > 0)
												{
													citrixSync.deleteValues(key, vars);									
													saveFile = true;
												}
											}
										}

										Iterator it = addHash.entrySet().iterator();
										while(it.hasNext())
										{
											Entry entry = (Entry)it.next();
											String subject = (String)entry.getKey();
											Vector varVals = (Vector)entry.getValue();
											Vector _vars  = (Vector)varVals.get(0);
											Vector _vals  = (Vector)varVals.get(1);
											citrixSync.setValues(subject, _vars, _vals,false);
											saveFile = true;
										}									
									}
									catch(Exception ex)
									{
										//ex.printStackTrace();
									}

									if(saveFile)
										citrixSync.saveFile();

									EgConfigFilesSync.releaseInstance(citrixSync);
								}							
							}
						}
						catch(Exception e)
						{
						}
						//Citrix Dashboard View Update ends

						IniFile groupsIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_group.ini");
						IniFile groupSync = EgConfigFilesSync.getInstance(EgConfigInfo.egMgrConfigDir + "eg_group.ini");
						Vector vars = groupsIni.getVariables("ZONE_ASSOCIATION",true);
						Vector vals = groupsIni.getAllValues("ZONE_ASSOCIATION");
						if(vars != null && vars.size()>0 && vals != null && vals.size()>0)
						{
							for(int i=0;i<vars.size();i++)
							{
								String old_var = vars.get(i).toString();
								if(old_var.equals(old_name))
								{
									groupSync.deleteValue("ZONE_ASSOCIATION",old_name);
									groupSync.setValue("ZONE_ASSOCIATION",new_name,(String)vals.get(i));
									break;
								}
							}
						}
						vars = groupsIni.getVariables("ZONE_LOCATION",true);
						vals = groupsIni.getAllValues("ZONE_LOCATION");
						if(vars != null && vars.size()>0 && vals != null && vals.size()>0)
						{
							for(int i=0;i<vars.size();i++)
							{
								String old_var = vars.get(i).toString();
								if(old_var.equals(old_name))
								{
									String old_val = vals.get(i).toString();
									groupSync.deleteValue("ZONE_LOCATION",old_name);
									groupSync.setValue("ZONE_LOCATION",new_name,old_val);
									break;
								}
							}
						}
						groupSync.deleteValue("LIST_OF_ZONES",old_name);
						groupSync.setValue("LIST_OF_ZONES",new_name,new_name);
						vars = groupsIni.getVariables("ZONE_DETAILS",true);
						vals = groupsIni.getAllValues("ZONE_DETAILS");
						if(vars != null && vars.size()>0 && vals != null && vars.size()>0)
						{
							for(int i=0;i<vals.size();i++)
							{
								String var = (String)vars.get(i);
								String val = (String)vals.get(i);
								if(val.equals(old_name))
								{
									groupSync.deleteValue("ZONE_DETAILS",var);
									var = var.substring(0,var.lastIndexOf("#")+1)+new_name;
									groupSync.setValue("ZONE_DETAILS",var,new_name);
								}
								else if(var.startsWith("Zone:"+old_name+":NULL#"))
								{
									groupSync.deleteValue("ZONE_DETAILS",var);
									String associated_zone = var.substring(var.lastIndexOf("#")+1);
									var = "Zone:"+new_name+":NULL#"+associated_zone;
									groupSync.setValue("ZONE_DETAILS",var,val);
								}
							}
						}
						vars = null;
						vals = null;
						// Rename zone_display_image
						String imageValue = groupSync.getValue("ZONE_DISPLAY_IMAGE",old_name);
						groupSync.deleteValue("ZONE_DISPLAY_IMAGE",old_name);
						groupSync.setValue("ZONE_DISPLAY_IMAGE",new_name,imageValue);
						groupSync.saveFile();
						registry.updateAllUserMaps();
						EgStateZone.updateZoneGroupStatus();
						EgConfigFilesSync.releaseInstance(groupSync);

						IniFile mgrMiscSync = EgConfigFilesSync.getInstance(EgConfigInfo.egMgrConfigDir + "eg_mgrmisc.ini");
						Vector zonevars = mgrMiscSync.getVariables("Auto_Created_Zone_User_Map",true);
						Vector zonevals = mgrMiscSync.getAllValues("Auto_Created_Zone_User_Map");
						if (zonevars != null && zonevars.size() > 0 && zonevals != null && zonevals.size() > 0)
						{
							int index = zonevals.indexOf(old_name);
							if (index != -1)
							{
								String userName = (String)zonevars.get(index);
								if (userName != null && userName.trim().length() > 0)
								{
									mgrMiscSync.setValue("Auto_Created_Zone_User_Map",userName,new_name);
								}
							}
						}
						mgrMiscSync.saveFile();
						EgConfigFilesSync.releaseInstance(mgrMiscSync);
						
						//TT zone rename update starts//
						IniFile egTtFilter = null;
						try
						{													
							boolean saveTTFile = false;
							String s_iniFile_dir = EgInstallInfo.getInstallDir()+ "/manager/config/";
							String egTTFilterFile = "eg_TroubleTicketFilter.ini";
							egTtFilter = EgConfigFilesSync.getInstance(s_iniFile_dir + egTTFilterFile);
							String zoneList = egTtFilter.getValue("admin","Zone");
							if(!StringUtils.isNull(zoneList))
							{
								ArrayList ttZonesList = com.egurkha.util.StringUtils.egTokenizer(zoneList,",",false,true,true);
								int ttZonesSize = ttZonesList.size();
								
								String addNewTTZoneValues = "";
								StringBuffer addNewTTZoneValuesBuff = new StringBuffer();
								for(int c=0;c<ttZonesSize;c++)
								{
									String zoneName = (String)ttZonesList.get(c);
									if(zoneName!=null && zoneName.equalsIgnoreCase(old_name))
									{
										addNewTTZoneValuesBuff.append(new_name+",");
									}
									else
									{
										addNewTTZoneValuesBuff.append(zoneName+",");
									}
								}
								addNewTTZoneValues = addNewTTZoneValuesBuff.toString();
							 
								if(addNewTTZoneValues!=null)
								{
									if(addNewTTZoneValues.lastIndexOf(",")>0)
									{
										addNewTTZoneValues = addNewTTZoneValues.substring(0,addNewTTZoneValues.lastIndexOf(","));
									}
									try
									{
										String subject = "admin";		
										egTtFilter.setValue(subject,"Zone",addNewTTZoneValues);
										saveTTFile = true;				
									}
									catch(Exception ex)
									{
										ex.printStackTrace();
									}
									if(saveTTFile)
										egTtFilter.saveFile();
								}
							}
						}
						catch(Throwable t)
						{
							t.printStackTrace();
						}
						finally
						{
							EgConfigFilesSync.releaseInstance(egTtFilter);
						}
						//TT zone rename update ends//

						try
						{
							EgCustomDashboardModel customDashboardModel=new EgCustomDashboardModel();
							customDashboardModel.UpdateMyDashboardConfiguration("Zone",old_name,new_name);

							EgTTFilterInfo obj = new EgTTFilterInfo();
							obj.updateTTMappingSettings("zone",old_name,new_name);
						}
						catch(Throwable t)
						{
							t.printStackTrace();
						}

						if(update_msmt_table != null && update_msmt_table.equals("true"))
						{
							success = renameObj.executeOtherQueries();
							if(!success)
							{
								renameStatus = false;
								auditLogThread.setPreviousValue("Zone name",old_name);
								auditLogThread.setCurrentValue("Zone name",new_name);
								auditLogThread.setValue("Description","Report and measurement tables have not been updated with new zone name");
								auditLogThread.sendItToDB();
								message = _mapping.getTextDescription("admin.error.Problem while updating report and measurement tables")+".";
							}
						}
						if(renameStatus)
						{
							auditLogThread.setPreviousValue("Zone name",old_name);
							auditLogThread.setCurrentValue("Zone name",new_name);
							auditLogThread.setValue("Description","Zone has been renamed");
							auditLogThread.sendItToDB();
							String label = "admin.common."+rename.toLowerCase()+" has been renamed successfully to";
							message = old_name + " " + _mapping.getTextDescription(label) + " " + new_name + ".";
						}
					}
				
					
				}
				else
				{
					renameStatus = false;
					String errorLabel = rename + " name";
					auditLogThread.setPreviousValue(errorLabel,old_name);
					auditLogThread.setCurrentValue(errorLabel,new_name);
					auditLogThread.setValue("Description",rename+" was not renamed as it had already been deleted");
					auditLogThread.sendItToDB();
					String label = "admin.common."+rename.toLowerCase()+" was not renamed to";
					message = old_name + " " +_mapping.getTextDescription(label) + " " + new_name +".";
				}
			}
			
			if(monitorLastSession != null && newUrlLink !=null && newUrlLink.indexOf("zoneDash.jsp")>-1)
			{
				if(old_name!=null && oldZoneName!=null && old_name.equals(oldZoneName))
				{
					session.removeAttribute("monitorLastSession");
				}
			}
		}
	}
	rootJson.put("message",message);
	rootJson.put("renamed",renameStatus);
	rootJson.put("rename",_mapping.getTextDescription("admin.common.Rename"));
	rootJson.put("success","true");
	out.println(rootJson.toString());
%>
