<%
/*****************************************************************************
*	Name 		:	Egtestinfoviewp.jsp
*	Purpose		:	This collects the set of info enabled or 
				disabled for a particular test. If any info
				is disabled newly it goes on to delete data
				pertaining to this info from all the tables
				of the eGurkha database.
				It also updates the eg_testinfo.ini file 
				which the agent would download eventually to
				update its list of measures to be uploaded.
******************************************************************************/
%>

<%@ include file="../../EgTrackerAJSON.jsp" %>
<%@ page import="com.eg.UpdateAndTransmitTrendInfo" %>
<%@ page import = "com.egurkha.admin.AuditLogThread"%>
<%@ page import="com.egurkha.util.StringUtils" %>
<%@ page import="com.egurkha.util.ListUtils" %>
<%@ page import="java.util.*" %>
<%@ page import="com.eg.EgTestInfo" %>
<%@ page import = "com.eg.EgMappingInfo"%>
<%@ page import = "net.sf.json.*" %>
<%@ page import = "com.eg.IniFile" %>
<%@ page import = "com.eg.EgInstallInfo" %>
<%@ page import = "com.eg.EgConfigFilesSync"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>

<%
	JSONObject rootJson  = new JSONObject();
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
	response.setContentType("application/json");

%>

<%!
	private static Hashtable recentEnableValues = new Hashtable();

	public ArrayList getArrayList(String strValue,String delimiter)
	{
		ArrayList aL = new ArrayList();

		if (StringUtils.isNull(strValue))
		{
			return aL;
		}
		StringTokenizer stTempTokens = new StringTokenizer(strValue,delimiter);
		while (stTempTokens.hasMoreTokens())
		{
			String str = stTempTokens.nextToken().trim();
			aL.add(str);
		}
		return aL;
	}

%>

<%
	/* code for auditlog starts */
	AuditLogThread auditLogThread = new AuditLogThread();	
	auditLogThread.setValue("Category","Admin");
	auditLogThread.setValue("User_id",_user.getLoginID());
	auditLogThread.setValue("Host_ip",_user.getUserIP(session.getId()));
	auditLogThread.setValue("Session_id",session.getId());
	auditLogThread.setValue("Module","Test Descriptors");
	boolean isAuditLogDataUpdated = false;
	boolean isDisableAction = false;
	/* code for auditlog ends */

	UpdateAndTransmitTrendInfo updateHelper = new UpdateAndTransmitTrendInfo();
	EgTestInfo testInfo = new EgTestInfo(true);
	ArrayList al_enabled = new ArrayList();
	ArrayList al_disabled = new ArrayList();
	ArrayList iniList = new ArrayList();
	ArrayList newly_enabled = new ArrayList();
	ArrayList newly_disabled = new ArrayList();
	Set tmpRecentDataList = new HashSet();
	ArrayList aListSelectedComponents = null;
	
	String from = request.getParameter("from");
	String serverType = request.getParameter("server");
	String compName = request.getParameter("comp");
	String testName = request.getParameter("testName");
	String selection = request.getParameter("duration");
	String enabledDesc = request.getParameter("enabledDescList");
	String disabledDesc = request.getParameter("disabledDescList");
	String isSearchBox = request.getParameter("isSearchBox");
	String disableAction = request.getParameter("disableaction");
	String requestFrom = request.getParameter("requestFrom");
	String selectedComponents = request.getParameter("selectedComponents");

	if(!StringUtils.isNull(disableAction) && disableAction.equals("true"))
	{
		isDisableAction = true;
	}

	if (!StringUtils.isNull(enabledDesc))
	{
		enabledDesc = egurkha.EgUIUtils.decodeSecurityChar(enabledDesc);
	}

	if (!StringUtils.isNull(disabledDesc))
	{
		disabledDesc = egurkha.EgUIUtils.decodeSecurityChar(disabledDesc);
	}

	//int ind = compName.indexOf(":");
	//String newComp = compName.substring(ind+1);

	al_disabled = StringUtils.egTokenizer(disabledDesc,",");

	if(!StringUtils.isNull(from) && from.equals("delete"))
	{
		int index = compName.indexOf(":");
		String componentName = compName.substring(index+1);

		//String compA = compName.substring(compName.indexOf(":")+1);
		iniList = testInfo.getTestInfoFor(componentName+":"+serverType,serverType);

		String removeStringFormIni = "";
		String deleteData = "";
		for(int k=0; k<iniList.size(); k++)
		{
			String str = (String) iniList.get(k);
			int in = str.indexOf("=");
			String test = str.substring(0, in);
			if(test.equals("WebLogicEjbTest"))
				continue;
			if(test.equals("WsEjbTest"))
				continue;
			String info = str.substring(in + 1);
			if(test.equals(testName))
			{
				ArrayList al_iniVal = StringUtils.egTokenizer(info,",");
				if(al_iniVal != null && al_iniVal.size() > 0)
				{
					for(int i=0;i<al_iniVal.size();i++)
					{
						String tmpIniData = (String) al_iniVal.get(i);
						if(al_disabled != null && !al_disabled.contains(tmpIniData))
						{
							removeStringFormIni += tmpIniData.trim()+",";
						}
						else
						{
							deleteData += tmpIniData.trim()+",";
						}
					}
				}
			}
		}
		auditLogThread.setValue("Activity","Deletion");
		if(deleteData.length() > 1)
		{
			deleteData = deleteData.substring(0,deleteData.length()-1);
			auditLogThread.setCurrentValue("Deleted Descriptor(s)", deleteData);
			isAuditLogDataUpdated = true;
		}

		testInfo.setTestInfo(compName, testName, removeStringFormIni); // for INI delete
		/*code for auditlog starts */
			String nullRemoved = componentName.endsWith(":NULL")?componentName.substring(0,componentName.lastIndexOf(":")):componentName;
			auditLogThread.setValue("Description","Descriptors have been deleted for the test " + _mapping.getTestDescription(testName) + " for component "+"$ctype$:"+(nullRemoved));
		/*code for auditlog ends */
		rootJson.put("success","true");
		rootJson.put("successUpdate","true");
	}
	else
	{
		String fromPage = request.getParameter("requestFrom");
		fromPage = (fromPage != null)?fromPage:"EgConfigureComponentTests.jsp";
		aListSelectedComponents = getArrayList(selectedComponents,",");
		ArrayList aListComponents = new ArrayList();
		aListComponents.add(compName);
		if (aListSelectedComponents != null && !aListSelectedComponents.isEmpty())
		{
			aListComponents.addAll(aListSelectedComponents);
		}

		al_enabled = (ArrayList) session.getAttribute("oldEnabledDescList");
		boolean isUserInitiatedComponent = false;

		auditLogThread.setValue("Activity","Enable/Disable Descriptor");
		String selectedCompName = compName;

		Vector dbCompList = new Vector();
		Vector iniCompList = new Vector();
		Vector testList = new Vector();
		Vector infoList = new Vector();
		for (int a=0;a<aListComponents.size();a++)
		{
			String strCompName =  (String) aListComponents.get(a);
			String delInfo = "";
			StringBuffer delInfoBuff = new StringBuffer();

			//String compA = compName.substring(compName.indexOf(":")+1);
			//iniList = testInfo.getTestInfoFor(compA+":"+serverType,serverType);

			isUserInitiatedComponent = strCompName.equals(selectedCompName);
			if (!isUserInitiatedComponent)
			{
				compName = strCompName;

				enabledDesc = request.getParameter("selectedEnableParams");
				disabledDesc = request.getParameter("selectedDisableParams");
				if (!StringUtils.isNull(enabledDesc))
				{
					enabledDesc = egurkha.EgUIUtils.decodeSecurityChar(enabledDesc);
				}

				if (!StringUtils.isNull(disabledDesc))
				{
					disabledDesc = egurkha.EgUIUtils.decodeSecurityChar(disabledDesc);
				}
			}

			int colonIdx = compName.indexOf(":");
			String newComp = compName.substring(colonIdx+1);

			String strNewEnabledDesc="";
			String strNewDisabledDesc = "";

			//String compA = compName.substring(colonIdx+1);
			iniList = testInfo.getTestInfoFor(newComp+":"+serverType,serverType);
			al_disabled = StringUtils.egTokenizer(disabledDesc,",");
			ArrayList tmpEnable = StringUtils.egTokenizer(enabledDesc,",");
			boolean isDisableDataExistsForSelectedTest = false;
			for(int k=0; k<iniList.size(); k++)
			{
				String str = (String) iniList.get(k);
				int in = str.indexOf("=");
				String test = str.substring(0, in);
				if(test.equals("WebLogicEjbTest"))
					continue;
				if(test.equals("WsEjbTest"))
					continue;
				if(!test.equals(testName))
				{
					continue;
				}
				if(test.equals(testName))
				{
					String info = str.substring(in + 1);
					ArrayList al_iniVal = StringUtils.egTokenizer(info,",");
					if(al_iniVal != null && al_iniVal.size() > 0)
					{
						for(int i=0;i<al_iniVal.size();i++)
						{
							String tmpDisableData = (String) al_iniVal.get(i);
							
							if(tmpEnable != null && tmpEnable.contains(tmpDisableData))
							{
								//if(!tmpRecentDataList.contains(tmpDisableData))
								{
									tmpRecentDataList.add(tmpDisableData.trim());
								}
							}
							else
							{
								//delInfo += tmpDisableData.trim()+",";
								delInfoBuff.append(tmpDisableData.trim());
								delInfoBuff.append(",");
							}
						}

						// for audit log newly enabled descriptors starts...
						if(tmpEnable != null && tmpEnable.size() > 0)
						{
							for(int t=0;t<tmpEnable.size();t++)
							{
								String strEnableData = (String) tmpEnable.get(t);
								if(al_iniVal.contains(strEnableData))
								{
									strNewEnabledDesc += strEnableData+",";
								}
							}
						}

						if(al_disabled != null && al_disabled.size() > 0)
						{
							for(int i=0;i<al_disabled.size();i++)
							{
								String strDisableData = (String) al_disabled.get(i);
								if(!al_iniVal.contains(strDisableData))
								{
									isDisableDataExistsForSelectedTest = true;
									strNewDisabledDesc += strDisableData+",";
								}
							}
						}
						// for audit log newly enabled descriptors ends...
					}

					if(al_disabled != null && al_disabled.size() > 0)
					{
						for(int j=0;j<al_disabled.size();j++)
						{
							String newDisableData = (String) al_disabled.get(j);
							if(al_iniVal == null || al_enabled == null || tmpEnable == null)
							{
								//delInfo += newDisableData+",";
								delInfoBuff.append(newDisableData);
								delInfoBuff.append(",");
							}
							//else if(!al_iniVal.contains(newDisableData) && al_enabled.contains(newDisableData) )
							else if(!al_iniVal.contains(newDisableData))
							{
								//delInfo += newDisableData.trim()+",";
								delInfoBuff.append(newDisableData.trim());
								delInfoBuff.append(",");
							}
						}
					}

					if(!StringUtils.isNull(isSearchBox) && isSearchBox.equals("true"))
					{
						if(tmpEnable != null && tmpEnable.size() > 0)
						{
							for(int e=0;e<tmpEnable.size();e++)
							{
								String newEnableData = (String) tmpEnable.get(e);
								if((al_iniVal != null && al_iniVal.contains(newEnableData)) && (al_disabled != null && !al_disabled.contains(newEnableData)))
								{
									//if(!tmpRecentDataList.contains(newEnableData))
									{
										tmpRecentDataList.add(newEnableData.trim());
									}
								}
							}
						}

						if(al_disabled != null && al_disabled.size() > 0)
						{
							for(int j=0;j<al_disabled.size();j++)
							{
								String newDisableData = (String) al_disabled.get(j);
								if(al_iniVal == null || al_enabled == null)
								{
									//delInfo += newDisableData.trim()+",";
									delInfoBuff.append(newDisableData.trim());
									delInfoBuff.append(",");
								}
								else if(tmpEnable != null && al_iniVal != null && !al_iniVal.contains(newDisableData) && !tmpEnable.contains(newDisableData))
								{
									//delInfo += newDisableData.trim()+",";
									delInfoBuff.append(newDisableData.trim());
									delInfoBuff.append(",");
								}
							}
						}
					}

					if(tmpRecentDataList != null && tmpRecentDataList.size() > 0)
					{
						List recentDataConvertList = new ArrayList(tmpRecentDataList); 
						if(recentEnableValues.containsKey(test+":"+compName))
						{
							List tempInfo = (List) recentEnableValues.get(test+":"+compName);
							tempInfo.addAll(recentDataConvertList);
							tempInfo = removeDuplicates(tempInfo);
							recentEnableValues.put(test+":"+compName, tempInfo);
							continue;
						}
						recentDataConvertList = removeDuplicates(recentDataConvertList);
						recentEnableValues.put(test+":"+compName,recentDataConvertList);
					}
				}
			}

			if(al_disabled != null && al_disabled.size() > 0)
			{
				for(int j=0;j<al_disabled.size();j++)
				{
					String newDisableData = (String) al_disabled.get(j);
					if(al_enabled == null || tmpEnable == null)
					{
						//delInfo += newDisableData+",";
						delInfoBuff.append(newDisableData);
						delInfoBuff.append(",");
					}
					else if(tmpEnable != null && !tmpEnable.contains(newDisableData))
					{
						//delInfo += newDisableData+",";
						delInfoBuff.append(newDisableData);
						delInfoBuff.append(",");
					}
					else
					{
						if(!StringUtils.isNull(isSearchBox) && isSearchBox.equals("true") && al_enabled.contains(newDisableData) )
						{
							//delInfo += newDisableData+",";
							delInfoBuff.append(newDisableData);
							delInfoBuff.append(",");
						}
					}
				}

				if (!isDisableDataExistsForSelectedTest)
				{
					strNewDisabledDesc = StringUtils.getString(al_disabled);
				}
			}
			if(strNewEnabledDesc.length() > 0)
			{
				if(strNewEnabledDesc.endsWith(","))
				{
					strNewEnabledDesc = strNewEnabledDesc.substring(0,strNewEnabledDesc.length()-1);
				}
		
				// remove duplictes
				List tempEnable = tokenizeInfo(strNewEnabledDesc);
				tempEnable = removeDuplicates(tempEnable);
				strNewEnabledDesc = StringUtils.getString(tempEnable);
				auditLogThread.setCurrentValue(String.valueOf(a+1)+"~~"+newComp,strNewEnabledDesc);
				isAuditLogDataUpdated = true;
			}
			if(strNewDisabledDesc.length() > 0)
			{
				if(strNewDisabledDesc.endsWith(","))
				{
					strNewDisabledDesc = strNewDisabledDesc.substring(0,strNewDisabledDesc.length()-1);
				}
		
				// remove duplictes
				List tempDisable = tokenizeInfo(strNewDisabledDesc);
				tempDisable = removeDuplicates(tempDisable);
				strNewDisabledDesc = StringUtils.getString(tempDisable);
				auditLogThread.setPreviousValue(String.valueOf(a+1)+"~~"+newComp,strNewDisabledDesc);
				isAuditLogDataUpdated = true;
			}

			delInfo = delInfoBuff.toString();
			if(delInfo.length() > 1)
			{
				delInfo = delInfo.substring(0,delInfo.length()-1);
			}

			if (isUserInitiatedComponent)
			{
				updateHelper.updateDescriptors(newComp, testName, delInfo); //for DB delete
				testInfo.setTestInfo(compName, testName, delInfo); // for INI delete
			}

			if (fromPage.equalsIgnoreCase("EgApplyToOtherComponents.jsp"))
			{
				if (isUserInitiatedComponent)
				{
					continue;
				}
				dbCompList.add(newComp);
				iniCompList.add(compName);
				testList.add(testName);
				infoList.add(delInfo);
			}


			/*for Maintenence INI delete*/
			if(delInfo!=null && !delInfo.equals(""))
			{			
				StringTokenizer stToken = new StringTokenizer(delInfo,",");
				String eGInstallDir = EgInstallInfo.getInstallDir();
				IniFile maintenanceWr = EgConfigFilesSync.getInstance(eGInstallDir + "/manager/config/eg_maintenance.ini");
				try
				{	
					Vector deletedEntriesForMaintenance = new Vector();
					String[] maintenanceVars1 =  maintenanceWr.getVariables("SERVERS");
					String[] QuickmaintenanceVars =  maintenanceWr.getVariables("UNPLANNED_POLICY_MAPPING");
					List maintenanceVars=new ArrayList();

					if(maintenanceVars1!=null)
					{
						maintenanceVars.addAll(Arrays.asList(maintenanceVars1));
					}
					if(QuickmaintenanceVars!=null)
					{
						maintenanceVars.addAll(Arrays.asList(QuickmaintenanceVars));
					}				
					while(stToken.hasMoreTokens())
					{
						String next = (String)stToken.nextToken();
						String keysToBeMatched = newComp+"#"+testName+":"+next;
						for (int k=0;k<maintenanceVars.size();k++)
						{
							String tmpVar =(String) maintenanceVars.get(k);
							tmpVar=tmpVar.trim();
							if (tmpVar != null && tmpVar.indexOf("#") > 0 && tmpVar.indexOf(":") > -1)
							{
								if(tmpVar!=null && tmpVar.equals(keysToBeMatched))
								{
									deletedEntriesForMaintenance.add(tmpVar);
								}
							}
						}
					}
					if(deletedEntriesForMaintenance!=null && !deletedEntriesForMaintenance.isEmpty())
					{
						maintenanceWr.deleteValues("SERVERS",deletedEntriesForMaintenance);
						maintenanceWr.deleteValues("UNPLANNED_POLICY_MAPPING",deletedEntriesForMaintenance);
					}
				}
				catch(Throwable e)
				{
					e.printStackTrace();
				}
				finally
				{
					maintenanceWr.saveFile();
					EgConfigFilesSync.releaseInstance(maintenanceWr);
				}
			}
		}
	
		if (!dbCompList.isEmpty())
		{
			EDTestDescriptor dtd= new EDTestDescriptor(dbCompList, iniCompList, testList, infoList);
		}


		if(isAuditLogDataUpdated)
		{
			auditLogThread.setValue("Description","Descriptors have been enabled/disabled from the " + _mapping.getTestDescription(testName) + " for "+_mapping.getComponentTypeDescription(serverType)+" components");
			/*code for auditlog ends */

			auditLogThread.sendItToDB();
		}
		rootJson.put("success","true");
		rootJson.put("successUpdate","true");
		rootJson.put("newenabledesc",enabledDesc);
	}


	//String url = "EgTestInfoView.jsp?server=" + serverType + "&comp=" + compName +"&testName="+ testName +"&duration=" + selection +"&requestFrom=processUpdated";
	session.setAttribute("recentEnableValues",recentEnableValues);
	out.println(rootJson.toString());
%>

<%!
	public List tokenizeInfo(String str)
	{
		List al = new ArrayList();
		StringTokenizer st = new StringTokenizer(str, ",");
		int count = st.countTokens();
		for(int i=0; i<count; i++)
		{
			al.add(st.nextToken());
		}
		return al;
	}

	public List removeDuplicates(List list)
	{
		if (list==null)
			return list;
		Set myset = new HashSet(list);
		List list1 = new LinkedList(myset);
		list = list1;
		return list1;
	}
%>





