<%@ include file="../../EgTrackerAJSON.jsp"%>
<%@ page import="java.util.StringTokenizer" %>
<%@ page import="java.util.Collections" %>
<%@ page import = "com.egurkha.util.StringUtils"%>
<%@ page import = "net.sf.json.*"%>
<%@ page language="java" contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" %>

<%
	JSONObject rootJson = new JSONObject();
	JSONObject screenLabels = new JSONObject();
	String comeFrom = request.getParameter("comeFrom");
	if (comeFrom != null && comeFrom.equalsIgnoreCase("validate"))
	{
		String iprange = request.getParameter("iprange");
		ArrayList ipList = new ArrayList(StringUtils.egTokenizer(iprange,","));
		boolean isValid = false;
		if (ipList != null && ipList.size() > 0)
		{
			for(int i=0;i<ipList.size();i++)
			{
				String allowedIP = (String)ipList.get(i);
				if (allowedIP.indexOf('-') != -1)
				{
					StringTokenizer st = new StringTokenizer(allowedIP,"-");
					String fromIP = st.nextToken();
					String toIP = st.nextToken();
					boolean isValidFromIp = false;
					boolean isValidToIp = false;
					if (fromIP.indexOf(':') != -1 && toIP.indexOf(':') != -1)
					{
						isValidFromIp = com.eg.IPV6Helper.validateIPV6(fromIP);
						isValidToIp = com.eg.IPV6Helper.validateIPV6(toIP);
					}
					else if (fromIP.indexOf(':') == -1 && toIP.indexOf(':') == -1)
					{
						isValidFromIp = com.eg.IPV6Helper.validateIPV4(fromIP);
						isValidToIp = com.eg.IPV6Helper.validateIPV4(toIP);
					}
					else
					{
						screenLabels.put("isValid","false");
						screenLabels.put("ErrorIn",i+1);
						screenLabels.put("admin.common.Error",_mapping.getTextDescription("admin.common.Both IP in the IP range should be in the same address standard"));
						break;
					}
					if (isValidFromIp && isValidToIp)
					{
						boolean isValidIPRange = false;
						ArrayList tmpList = new ArrayList();
						tmpList.add(fromIP);
						tmpList.add(toIP);
						Collections.sort(tmpList,new com.egurkha.IPComparator());
						String firstIPToken = (String)tmpList.get(0);
						if (fromIP.equals(firstIPToken))
						{
							isValidIPRange = true;
						}
						if (isValidIPRange)
						{
							screenLabels.put("isValid","true");
						}
						else
						{
							screenLabels.put("isValid","false");
							screenLabels.put("ErrorIn",i+1);
							screenLabels.put("admin.common.Error",_mapping.getTextDescription("admin.common.Second IP should be greater than the first IP in the IP range"));
							break;
						}
					}
					else
					{
						screenLabels.put("isValid","false");
						screenLabels.put("ErrorIn",i+1);
						screenLabels.put("admin.common.Error",_mapping.getTextDescription("admin.common.Invalid IP in IP range"));
						break;
					}
				}
				else if (allowedIP.indexOf('-') == -1 && allowedIP.indexOf('*') == -1)
				{
					boolean isValidIp = false;
					if (allowedIP.indexOf(':') != -1)
					{
						isValidIp = com.eg.IPV6Helper.validateIPV6(allowedIP);
					}
					else
					{
						isValidIp = com.eg.IPV6Helper.validateIPV4(allowedIP);
					}
					if (isValidIp)
					{
						screenLabels.put("isValid","true");
					}
					else
					{
						screenLabels.put("isValid","false");
						screenLabels.put("ErrorIn",i+1);
						screenLabels.put("admin.common.Error",_mapping.getTextDescription("admin.common.Invalid IP"));
						break;
					}
				}
			}
		}
	}
	else if (comeFrom != null && comeFrom.equalsIgnoreCase("update"))
	{
		String iprange = request.getParameter("iprange");
		ArrayList ipList = new ArrayList(StringUtils.egTokenizer(iprange,","));
		if (ipList != null && ipList.size() > 0)
		{
			IniFile mgrMisc = EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir() + "/manager/config/eg_mgrmisc.ini",true);
			mgrMisc.deleteSubject("ALLOWED_IP");
			for(int i=0;i<ipList.size();i++)
			{
				String ip = (String)ipList.get(i);
				mgrMisc.setValue("ALLOWED_IP",ip,ip);
			}
			mgrMisc.saveFile();
			EgConfigFilesSync.releaseInstance(mgrMisc);
			screenLabels.put("success","true");
		}
	}
	else if (comeFrom != null && comeFrom.equalsIgnoreCase("getIPPolicy"))
	{
		IniFile mgrMiscIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_mgrmisc.ini");
		String[] allowedIP = mgrMiscIni.getVariables("ALLOWED_IP");
		String configuredIp = "";
		if (allowedIP != null && allowedIP.length > 0)
		{
			for (int i=0;i<allowedIP.length ; i++)
			{
				configuredIp += allowedIP[i]+",";
			}
			if (configuredIp.endsWith(","))
			{
				configuredIp = configuredIp.substring(0,configuredIp.length()-1);
			}
			screenLabels.put("configuredIp",configuredIp);
		}
	}
	else if (comeFrom != null && comeFrom.equalsIgnoreCase("deleteAllIPPolicy"))
	{
		IniFile mgrMisc = EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir() + "/manager/config/eg_mgrmisc.ini",true);
		mgrMisc.deleteSubject("ALLOWED_IP");
		mgrMisc.saveFile();
		EgConfigFilesSync.releaseInstance(mgrMisc);
		screenLabels.put("success","true");
	}

	rootJson.put("screenLabels",screenLabels);
	out.println(rootJson.toString());
%>



