<%
/**
 *	File name		:	licenseUsageForUserJson.jsp
 *	Purpose			:	This page provides user license details
 */
%>
<%@ include file="../../EgTrackerAJSON.jsp"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%@ page import = "com.egurkha.util.StringUtils"%>
<%@ page import = "net.sf.json.JSONObject"%>
<%@ page import = "net.sf.json.JSONArray"%>
<%@ page import = "com.egurkha.ini.IniUI"%>
<%@ page import = "java.util.Calendar"%>
<%@ page import = "java.util.Date"%>
<%@ page import = "java.math.*"%>
<%@ page import = "com.egurkha.util.DateUtil"%>
<%@ page import = "java.text.SimpleDateFormat"%>
<%@ page import = "java.text.DateFormat"%>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
	response.setContentType("application/json;charset=UTF-8");
	
	JSONObject jsonBaseObj = new JSONObject();
	ArrayList elementsList = new ArrayList();
	

	String tab = request.getParameter("tab");
	String srcStr = request.getParameter("searchStr");
	String zoneAttr = request.getParameter("zoneAttr");

	EgUuidInfo uuidInfo = new EgUuidInfo();
	EgRoleInfo egRoleInfo = EgRoleInfo.getInstance(session.getId(),(String)session.getAttribute("sess_userid"));
	boolean isLimitedAdmin = !egRoleInfo.hasAllComponentAccess();
	boolean isMspModel = EgUuidInfo.isMspModel();
	String userId = _user.getLoginID();
	String user_id = (uuidInfo.isUser(userId) && uuidInfo.hasOURole(userId)) ? uuidInfo.getDirectDependentOU(userId) : userId;
	GroupCertValidator grpCertVal = new GroupCertValidator(user_id);

	CertValidator cert = new CertValidator();
	int allowedTotalCnt = cert.getAllowedTotalCount();
	int allowedBasicCnt = cert.getAllowedBasicCount();
	int allowedPremuCnt = cert.getAllowedPremiumCount();
	int allowedNwDevCnt = cert.getAllowedNetworkDevicesCount();
	int allowedMonUserCount = EgMemInfo.users;
	int allowedUserCount = 0;
	int allowedEndpointCount = 0;
	int allowedO365usersCount = 0;

	EgCertUsage certUsage = new EgCertUsage();
	EgUsersInfo usersInfo = new EgUsersInfo();
	boolean isUserCertMgr = usersInfo.isUserBasedLicense();
	boolean isCCUserCertEnabled = EgInstallInfo.isconcurrentUserLicense;
	boolean isNamedUserEnabled = EgInstallInfo.isnamedUserLicense;
	boolean isendPointUsrLic = EgInstallInfo.isEUCEndPointsLicense ;
	boolean isO365UsrLic = EgInstallInfo.isO365UsersLicense;
	//Named or CC users
	HashMap userCertInfo = new HashMap();
	ArrayList aListData = null;
//	ArrayList aListData1 = null;
	if (isUserCertMgr)
	{
		if(isCCUserCertEnabled)
		{
			allowedUserCount = (int)EgInstallInfo.allowedConcUsers;
		}
		else
		{
			allowedUserCount = (int)EgInstallInfo.allowedNamedUsers;
		}

		String count = "0";
		String AllowedCount = String.valueOf(allowedUserCount);
		String avail_count = AllowedCount;
		double avail = 0.0;

		userCertInfo = certUsage.getCertUsersDetailsForUsers();
		aListData = usersInfo.getRemoteUserCount();
//		aListData1 = usersInfo.getUserInfos(false);
		if (aListData == null || aListData.size() ==0)
		{
			aListData = usersInfo.getRemoteUserCount(true);
		}
		if(aListData != null && aListData.size()>0)
		{
			count = (String)aListData.get(0);
			AllowedCount = (String)aListData.get(1);
		}
		if (!AllowedCount.equals("-") && !AllowedCount.equals("-1"))
		{
			allowedUserCount = Integer.parseInt(AllowedCount);
		}
		else
		{
			allowedUserCount = -1;
		}
	}

	if (isendPointUsrLic)
	{
		allowedEndpointCount = (int)EgInstallInfo.allowedEndPointUsersCount;
		String endpointsAllowedCount = String.valueOf(allowedEndpointCount);
		if (!endpointsAllowedCount.equals("-") && !endpointsAllowedCount.equals("-1"))
		{
			allowedEndpointCount = Integer.parseInt(endpointsAllowedCount);
		}
		else
		{
			allowedEndpointCount = -1;
		}
	}

	if (isO365UsrLic)
	{
		allowedO365usersCount = (int)EgInstallInfo.allowedO365Users;
		String o365UsersAllowedUserCount = String.valueOf(allowedO365usersCount);
		if (!o365UsersAllowedUserCount.equals("-") && !o365UsersAllowedUserCount.equals("-1"))
		{
			allowedO365usersCount = Integer.parseInt(o365UsersAllowedUserCount);
		}
		else
		{
			allowedO365usersCount = -1;
		}
	}



	boolean hasManagerLicCount = !grpCertVal.allowLicenseCheckForUser();
	String usersTotalCnt = (hasManagerLicCount) ? String.valueOf(allowedTotalCnt) : grpCertVal.totalCntStr;
	String usersBasicCnt = (hasManagerLicCount) ? String.valueOf(allowedBasicCnt) : grpCertVal.totalBasicStr;
	String usersNwDevsCnt = (hasManagerLicCount) ? String.valueOf(allowedNwDevCnt) : grpCertVal.totalNwDevicesStr;
	String usersUserBasedCnt = (hasManagerLicCount) ? String.valueOf(allowedUserCount) : grpCertVal.totalUserCntStr;
	String endpointTotalCnt = (hasManagerLicCount) ? String.valueOf(allowedEndpointCount) : grpCertVal.totalEUCUserCntStr;
	String o365UsersTotalCnt = (hasManagerLicCount) ? String.valueOf(allowedO365usersCount) : grpCertVal.totalO365UserCntStr;
	String usersMonUsersCnt = (hasManagerLicCount) ? String.valueOf(allowedMonUserCount) : grpCertVal.totalMonUserCntStr;

	int totCnt = Integer.parseInt(usersTotalCnt);
	int basCnt = Integer.parseInt(usersBasicCnt);
	int premCnt = (totCnt > -1 && basCnt > -1) ? totCnt - basCnt : -1;
	int nwDevCnt = Integer.parseInt(usersNwDevsCnt);
	int usrBsdCnt = Integer.parseInt(usersUserBasedCnt);
	int endpointCnt = Integer.parseInt(endpointTotalCnt);
	int o365usertCnt = Integer.parseInt(o365UsersTotalCnt);
	int monUsrCnt = Integer.parseInt(usersMonUsersCnt);
	String usersPremiumCnt = usersTotalCnt.equals("-1") ? "-1" : String.valueOf(premCnt);
	EgExternalInfo extInfo = new EgExternalInfo("manager");
	EgDiscInfo discInfo = new EgDiscInfo("manager");
	
	String userLanguage = _user.getLanguage();
	IniUI iniUI = IniUI.getInstance();
	if (userLanguage == null)
		userLanguage = iniUI.getDefaultLanguage();
	EgMappingInfo mappingInfo = new EgMappingInfo(userLanguage);
	
	EgGroupInfo grInf = new EgGroupInfo();
	EgEndPointsInfo endPointNamesInfo = new EgEndPointsInfo();
	ArrayList nameList = new ArrayList();
	boolean isUserBased = false;
	if (tab != null && tab.equals("User"))
	{
		isUserBased = true;
	}

	JSONObject jsonObj = new JSONObject();
	ArrayList peakUsageData = usersInfo.getPeakUsageValuesForPreviusMonth();
	String trac_currentDateFormat = iniUI.getValue("CURRENT_DATE_FORMAT","selectedDateFormat");
	IniFile servicesIni = new IniFile(EgConfigInfo.egMgrConfigDir+"eg_services.ini");
	String vdiUsrsSplitUp = servicesIni.getValue("ZoneAndUserCertUsage","VDIUsersSplitup");
	boolean showVDIUsersSplitUp = false;
	if (vdiUsrsSplitUp != null && (vdiUsrsSplitUp.equalsIgnoreCase("yes") || vdiUsrsSplitUp.equalsIgnoreCase("true")))
	{
		showVDIUsersSplitUp = true;
	}
	String infiniteCols = servicesIni.getValue("ZoneAndUserCertUsage","InfiniteAllowedCountColumns");
	boolean showInfiniteAllowedCols = false;
	if (infiniteCols != null && (infiniteCols.equalsIgnoreCase("yes") || infiniteCols.equalsIgnoreCase("true")))
	{
		showInfiniteAllowedCols = true;
	}

	//for CSV Report Date
	String userDateFormat = _user.getUserDateFormat();
	String userDateTimeFormat = userDateFormat+" HH:mm:ss";
	Date currDate = new Date();
	SimpleDateFormat smdf = new SimpleDateFormat(userDateTimeFormat);
	String currDateStr = smdf.format(currDate); 

	//For CSV
	List csvData = new ArrayList();
	String csvRow = "";
	String repTitle = "License usage report";
	String repDate = "Report generated on"+",\""+currDateStr+"\"";
	String colHeads =  "Attribute,Allowed,Currently Used,Available,Current Usage(%)";

	csvData.add(repTitle);
	csvData.add(repDate);
	csvData.add("");
	csvData.add(colHeads);

	ArrayList eGUsers = certUsage.getAllLimitedCompAccessUsers();
	if (srcStr != null && srcStr.trim().length() > 0)
	{
		ArrayList srcTokens = StringUtils.egTokenizer (srcStr, " ", false, false, true);
		for (int e=0; e<eGUsers.size(); e++)
		{
			String egUser = (String)eGUsers.get(e);
			for (int s=0; s < srcTokens.size(); s++)
			{
				String srcToken = srcTokens.get(s).toString().toLowerCase();
				if (egUser.toLowerCase().indexOf(srcToken) != -1)
				{
					nameList.add(egUser);
				}
			}
		}
	}
	else
	{
		nameList.addAll(eGUsers);
	}
	if (user_id.equalsIgnoreCase("egenterprise"))
	{
		nameList = new ArrayList();
		nameList.add(user_id);
	}
	else
	{
		ArrayList limitedAdminUser = new ArrayList();
		limitedAdminUser.add(user_id);
		nameList.retainAll(limitedAdminUser);
	}

	int nameListSize = nameList.size();
	if (nameListSize > 0)
	{
		jsonBaseObj.put("enableSearch",true);
	}
	else
	{
		jsonBaseObj.put("enableSearch",false);
	}

	JSONArray gridArr = new JSONArray();
	String pattern = "(^[\"]?\\d+[\"]?$)|(^[\"]?\\d+(\\.\\d*)[\"]?$)";
	//Pattern r = Pattern.compile(pattern);
	//Matcher m;
	for (int u=0; u < nameListSize; u++)
	{
		String name = (String)nameList.get(u);
		certUsage.setUserName(name);
		jsonObj = new JSONObject();
		HashMap detailsMap = new HashMap();

		// Total monitors
		detailsMap = certUsage.getTotalMonitorsDetailsForUser();
		String attrName = _mapping.getTextDescription("admin.license.Total Monitors");
		String used = (String)detailsMap.get("Used");
		String usag = getUsagePercent(used,usersTotalCnt);
		int usedCnt = Integer.parseInt(used);
		String availCnt = usersTotalCnt.equals("-1") ? "-" : String.valueOf(totCnt-usedCnt);
		usersTotalCnt = usersTotalCnt.equals("-1") ? "-" : usersTotalCnt;
		jsonObj.put("detailsName",attrName);
		jsonObj.put("allowedCount",usersTotalCnt);
		jsonObj.put("currentlyUsed",used+"@#@"+name+"@#@Total Monitors");
		jsonObj.put("availCount",availCnt);
		jsonObj.put("currentUsage",usag);
		gridArr.add(jsonObj);
		csvRow = attrName+","+usersTotalCnt+","+used+","+availCnt+","+usag;
		csvData.add(csvRow);

		//Premium monitors and Basic monitors
		detailsMap = certUsage.getPremiumMonitorsDetailsForUser();
		String usedPrem = (String)detailsMap.get("Used"); 
		int usedPremium = Integer.parseInt(usedPrem);
		detailsMap = certUsage.getBasicMonitorsDetailsForUser();
		String usedBas = (String)detailsMap.get("Used"); 
		int usedBasic = Integer.parseInt(usedBas);
		if (!usersBasicCnt.equals("-1"))
		{
			int allowedBas = Integer.parseInt(usersBasicCnt);;
			if (usedBasic > allowedBas)
			{
				usedPremium += (usedBasic-allowedBas);
				usedBasic = allowedBas;
				usedPrem = String.valueOf(usedPremium);
				usedBas = String.valueOf(usedBasic);
			}
		}

		attrName = _mapping.getTextDescription("admin.license.Basic Monitors");
		int basicAvail = basCnt-usedBasic;
		if (basicAvail < 0)
		{
			basicAvail = 0;
		}
		String usagBas = getUsagePercent(usedBas,usersBasicCnt);
		availCnt = usersBasicCnt.equals("-1") ? "-" : String.valueOf(basicAvail);
		usersBasicCnt = usersBasicCnt.equals("-1") ? "-" : usersBasicCnt;
		jsonObj.put("detailsName","&nbsp;&nbsp;&nbsp;&nbsp;"+attrName);
		jsonObj.put("allowedCount",usersBasicCnt);
		jsonObj.put("currentlyUsed",usedBas+"@#@"+name+"@#@Basic Monitors");
		jsonObj.put("availCount",availCnt);
		jsonObj.put("currentUsage",usagBas);
		csvRow = attrName+","+usersBasicCnt+","+usedBas+","+availCnt+","+usagBas;
		csvData.add(csvRow);
		gridArr.add(jsonObj);

		attrName = _mapping.getTextDescription("admin.license.Premium Monitors");
		String usagPrem = getUsagePercent(usedPrem,usersPremiumCnt);
		availCnt = usersPremiumCnt.equals("-1") ? "-" : String.valueOf(premCnt-usedPremium);
		usersPremiumCnt = usersPremiumCnt.equals("-1") ? "-" : usersPremiumCnt;
		jsonObj.put("detailsName","&nbsp;&nbsp;&nbsp;&nbsp;"+attrName);
		jsonObj.put("allowedCount",usersPremiumCnt);
		jsonObj.put("currentlyUsed",usedPrem+"@#@"+name+"@#@Premium Monitors");
		jsonObj.put("availCount",availCnt);
		jsonObj.put("currentUsage",usagPrem);
		csvRow = attrName+","+usersPremiumCnt+","+usedPrem+","+availCnt+","+usagPrem;
		csvData.add(csvRow);
		gridArr.add(jsonObj);

		//Network Devices
		detailsMap = certUsage.getNetworkDevicesDetailsForUser();
		attrName = _mapping.getTextDescription("admin.license.Network Devices");
		used = (String)detailsMap.get("Used");
		usag = getUsagePercent(used,usersNwDevsCnt);
		usedCnt = Integer.parseInt(used);
		availCnt = usersNwDevsCnt.equals("-1") ? "-" : String.valueOf(nwDevCnt-usedCnt);
		usersNwDevsCnt = usersNwDevsCnt.equals("-1") ? "-" : usersNwDevsCnt;
		jsonObj.put("detailsName",attrName);
		jsonObj.put("allowedCount",usersNwDevsCnt);
		jsonObj.put("currentlyUsed",used+"@#@"+name+"@#@Network device");
		jsonObj.put("availCount",availCnt);
		jsonObj.put("currentUsage",usag);
		csvRow = attrName+","+usersNwDevsCnt+","+used+","+availCnt+","+usag;
		csvData.add(csvRow);
		gridArr.add(jsonObj);

		//UsersCert
		if (isUserCertMgr)
		{
			used = "0";
			detailsMap = certUsage.getCertUsersDetailsForUsers();
			if (isNamedUserEnabled)
			{
				attrName = _mapping.getTextDescription("admin.license.Named Users");
			}
			else if(isCCUserCertEnabled)
			{
				attrName = _mapping.getTextDescription("admin.license.Concurrent Users");
			}
		//	used = (aListData != null && aListData.size() > 0) ? (String)aListData.get(0) : "0"; //(String)detailsMap.get("Used");
			HashMap userMap = (detailsMap != null) ? (HashMap)detailsMap.get(name) : new HashMap();
			if (userMap != null)
			{
				used = (String)userMap.get("Total");				
			}
			if (used == null)
			{
				used = "0";
			}
			else
			{
				int dotCnt = used.indexOf(".");
				if (dotCnt > -1)
				{
					used = used.substring(0,dotCnt);
				}
			}
			usag = getUsagePercent(used,usersUserBasedCnt);
			usag = (usag.startsWith("0.")) ? "0" : usag;
			int idxDec = used.indexOf(".");
			if (idxDec > -1)
			{
				used = used.substring(0,idxDec);
			}
			usedCnt = Integer.parseInt(used);
			int availCountInt = usrBsdCnt-usedCnt;
			if (availCountInt < 0)
				availCountInt = 0;
			availCnt = usersUserBasedCnt.equals("-1") ? "-" : String.valueOf(availCountInt);
			usersUserBasedCnt = usersUserBasedCnt.equals("-1") ? "-" : usersUserBasedCnt;
			//m = r.matcher(usag);
			jsonObj.put("detailsName",attrName);
			jsonObj.put("allowedCount",usersUserBasedCnt);
			jsonObj.put("currentlyUsed",used);
			jsonObj.put("availCount",availCnt);
			jsonObj.put("currentUsage",usag);
			csvRow = attrName+","+usersUserBasedCnt+","+used+","+availCnt+","+usag;
			csvData.add(csvRow);

			//peakusage
			//String peakUsgMsg = "";
			//if (peakUsageData != null && peakUsageData.size() >= 2)
			//{
				//String peakUsgCnt = peakUsageData.get(0).toString();
				//String peakUsgDate = peakUsageData.get(1).toString();
				//String namedOrConcUser = isNamedUserEnabled ? "named users" : "concurrent users";
				//if (peakUsgCnt != null && peakUsgCnt.trim().length() > 0 && peakUsgDate != null && peakUsgDate.trim().length() > 0)
				//{
					//int dotIdx = peakUsgCnt.indexOf(".");
					//if (dotIdx > -1)
					//{
						//peakUsgCnt = peakUsgCnt.substring(0,dotIdx);
					//}
					//peakUsgDate = DateUtil.changeDateFormat(peakUsgDate,"yyyy-MM-dd HH:mm:ss",trac_currentDateFormat);
					//peakUsgMsg += "\"Peak usage last month was on "+peakUsgDate+". The peak value on this day was "+peakUsgCnt+" "+namedOrConcUser+".\"";
					//csvRow = peakUsgMsg;
					//csvData.add("");
					//csvData.add(csvRow);
				//}
			//}
			gridArr.add(jsonObj);
		}

		//End Point names 
		HashMap endPointNamedetailsMap = new HashMap();
		String endPointAllowedCount = "-1";
		if(isendPointUsrLic)
		{
			used = "0";
			endPointNamedetailsMap = endPointNamesInfo.getUsersDetailsForType("user");
			HashMap userMap = (endPointNamedetailsMap != null) ? (HashMap)endPointNamedetailsMap.get(name) : new HashMap();
			if (userMap != null)
			{
				used = (String)userMap.get("Total");
			}
			if (used == null)
			{
				used = "0";
			}
			else
			{
				int dotCnt = used.indexOf(".");
				if (dotCnt > -1)
				{
					used = used.substring(0,dotCnt);
				}
			}
			usag = getUsagePercent(used,endpointTotalCnt);
			endpointTotalCnt = endpointTotalCnt.equals("-1") ? "-" : endpointTotalCnt;
			usag = (usag.startsWith("0.")) ? "0" : usag;
			usedCnt = Integer.parseInt(used);
			int availendpointCount = endpointCnt-usedCnt;
			if (availendpointCount < 0)
			{
				availendpointCount = 0;
			}
			availCnt = endpointTotalCnt.equals("-1") ? "-" : String.valueOf(availendpointCount);
			jsonObj.put("detailsName","Endpoints");
			jsonObj.put("allowedCount",endpointTotalCnt);
			jsonObj.put("currentlyUsed",used);
			jsonObj.put("availCount",availCnt);
			jsonObj.put("currentUsage",usag);
			csvRow = "Endpoints"+","+endpointTotalCnt+","+used+","+availCnt+","+usag;
			csvData.add(csvRow);
			gridArr.add(jsonObj);
		}

		//O365 users
		HashMap o365UsersdetailsMap = new HashMap();
		EgMsUsersInfo o365UsersInfoObj = new EgMsUsersInfo();
		if (isO365UsrLic)
		{
			used = "0";
			o365UsersdetailsMap = o365UsersInfoObj.getUsersDetailsForType("user");
			HashMap userMap = (o365UsersdetailsMap != null) ? (HashMap)o365UsersdetailsMap.get(name) : new HashMap();
			if (userMap != null)
			{
				used = (String)userMap.get("Total");
			}
			if (used == null)
			{
				used = "0";
			}
			else
			{
				int dotCnt = used.indexOf(".");
				if (dotCnt > -1)
				{
					used = used.substring(0,dotCnt);
				}
			}
			usag = getUsagePercent(used,o365UsersTotalCnt);
			o365UsersTotalCnt = o365UsersTotalCnt.equals("-1") ? "-" : o365UsersTotalCnt;
			usag = (usag.startsWith("0.")) ? "0" : usag;
			usedCnt = Integer.parseInt(used);
			int availo365usertCnt = o365usertCnt-usedCnt;
			if (availo365usertCnt < 0)
			{
				availo365usertCnt = 0;
			}
			availCnt = o365UsersTotalCnt.equals("-1") ? "-" : String.valueOf(availo365usertCnt);
			jsonObj.put("detailsName","O365 Users");
			jsonObj.put("allowedCount",o365UsersTotalCnt);
			jsonObj.put("currentlyUsed",used);
			jsonObj.put("availCount",availCnt);
			jsonObj.put("currentUsage",usag);
			csvRow = "O365 Users"+","+o365UsersTotalCnt+","+used+","+availCnt+","+usag;
			csvData.add(csvRow);
			gridArr.add(jsonObj);
		}

		//Monitor Users
		attrName = _mapping.getTextDescription("admin.license.Monitor Users");
		ArrayList usersUnderOU = uuidInfo.getAllSubOrgsAndUsers(user_id);
		used = "0";
		if (usersUnderOU != null && usersUnderOU.size() > 0)
		{
			usersUnderOU.remove(user_id);
			used = String.valueOf(usersUnderOU.size());
		}
		usag = getUsagePercent(used,usersMonUsersCnt);
		usedCnt = Integer.parseInt(used);
		availCnt = usersMonUsersCnt.equals("-1") ? "-" : String.valueOf(monUsrCnt-usedCnt);
		usersMonUsersCnt = usersMonUsersCnt.equals("-1") ? "-" : usersMonUsersCnt;
		jsonObj.put("detailsName",attrName);
		jsonObj.put("allowedCount",usersMonUsersCnt);
		jsonObj.put("currentlyUsed",used+"@#@"+name+"@#@Monitor users");
		jsonObj.put("availCount",availCnt);
		jsonObj.put("currentUsage",usag);
		csvRow = attrName+","+usersMonUsersCnt+","+used+","+availCnt+","+usag;
		csvData.add(csvRow);
		gridArr.add(jsonObj);
		jsonBaseObj.put("gridNewDetails",gridArr);
	}

	session.setAttribute("list",csvData);
	session.setAttribute("isAuditlogCSV","true");
	out.println(jsonBaseObj);

	
%>
<%!
	public ArrayList getTypesForNick(ArrayList details, EgDiscInfo discInfo, EgExternalInfo extInfo, EgMappingInfo mappingInfo)
	{
		List tempDetails = new ArrayList();
		ArrayList basicTypes = EgInstallInfo.getBasicTypes();
		ArrayList extAgents = new ArrayList();
		String[] exts = extInfo.getAllExternalAgents();
		if (exts != null)
		{
			extAgents = new ArrayList(Arrays.asList(exts));
		}
		for (int d=0; d<details.size(); d++)
		{
			String nick = (String)details.get(d);
			List compTypes = discInfo.getServerTypesForNick(nick);
			String type = "";
			if (compTypes != null && compTypes.size() > 0)
			{
				for (int c=0; c < compTypes.size(); c++)
				{
					type = compTypes.get(c).toString();
					if (!basicTypes.contains(type))
					{
						type = mappingInfo.getComponentTypeDescription(type);
						break;
					}
					type = "";
				}
				if (type.equals(""))// Basic agents or basic consumes premium license
				{
					type = compTypes.get(0).toString();
					type = mappingInfo.getComponentTypeDescription(type);
				}

				if (extAgents.contains(nick))
				{
					type = " "+type;
				}
			}
			else
			{
				type = "External Agent";
			}

			tempDetails.add(nick+" ("+type+")");
		}
		if (tempDetails.size() > 0)
		{
			details = new ArrayList(tempDetails);
		}
		return details;
	}

	public String getUsagePercent(String used, String total)
	{
		String result = "-";
		//ErUtils erutils=new ErUtils();
		double usedCount = Double.parseDouble(used);
		double totalCount = Double.parseDouble(total);
		double percentageCalc = 0;
		if(!total.equals("-1"))
		{
			percentageCalc = (usedCount/totalCount)*100;
			result = (percentageCalc > 100) ? "-" : String.valueOf(round(percentageCalc,2)); //erutils.roundOffDigit (percentageCalc, 2); //
		}
		return result;
	}
	public double round(double value, int places) 
	{
		if (places < 0) throw new IllegalArgumentException();

		long factor = (long) Math.pow(10, places);
		value = value * factor;
		long tmp = Math.round(value);
		return (double) tmp / factor;
	}
%>


