<%
/*
 *       Name            :      EgConfigUDLayer.jsp
 *       Purpose         :		IC - Layer - Asso/Disso Tests
 *       CreationDate    :      01/10/2001
 */
%>

<%@ include file="../../EgTrackerAJSON.jsp"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%@ page import = "egurkha.LayerBean" %>
<%@ page import = "egurkha.TestBean" %>
<%@ page import = "egurkha.ServiceBean" %>
<%@ page import = "com.egurkha.ini.IniUI"%>
<%@ page import = "com.eg.*"%>
<%@ page import="net.sf.json.JSONObject"%>
<%@ page import="net.sf.json.JSONArray "%>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
	response.setContentType("application/json;charset=UTF-8");
%>

<%
	JSONObject rootJSON = new JSONObject();
	rootJSON.put("success","true");
	JSONObject hiddens = new JSONObject();
	String layer = request.getParameter("layer");
	ArrayList assoTests = new ArrayList();
	LayerBean layerBean = new LayerBean();
	TestBean testBean = new TestBean();
	EgTablesInfo tablesInfo = new EgTablesInfo("manager");
	ArrayList hostLevelTests = tablesInfo.getHostLevelTests();
	EgDiscInfo discInfo = new EgDiscInfo("manager");
	
	boolean isNonOracleLayer = false;
	ArrayList oracleLayers = layerBean.getLayersForServer("Oracle_server");
	ArrayList oracleRelatedTests = new ArrayList();
	if (oracleLayers != null && oracleLayers.size() > 0)
	{
		ArrayList hostSystemLayers = layerBean.getLayersForServer("Host_system");
		hostSystemLayers.add("WIN_SERVICE");
		if (hostSystemLayers != null && hostSystemLayers.size() > 0)
		{
			oracleLayers.removeAll(hostSystemLayers);
		}

		for (int t=0;t<oracleLayers.size();t++)
		{
			String oraLayer = (String) oracleLayers.get(t);
			ArrayList tempList = layerBean.getTestsForLayer(oraLayer);

			if (tempList != null && tempList.size() > 0)
			{
				oracleRelatedTests.addAll(tempList);
			}
		}
		if (layer != null && !oracleLayers.contains(layer))
		{
			isNonOracleLayer = true;
		}
		
	}

	ArrayList t_tests = layerBean.getTestsForLayer(layer);
	ArrayList t_allTests = testBean.getAllTests();
	ServiceBean serBean = new ServiceBean();
	String assocType = serBean.getTestLayerAssociation();
	ArrayList tests=new ArrayList();
	ArrayList allTests=new ArrayList();
	String tStr="";
	String[] compTypes = discInfo.getServerTypes();

	String userLanguage = _user.getLanguage();
	IniUI iniUI = IniUI.getInstance();
	if (userLanguage == null)
	{
		userLanguage = iniUI.getDefaultLanguage();
	}
	MappingNameSorter sorter = new MappingNameSorter(userLanguage);

	if(assocType==null || assocType.equals(""))
	{
		assocType="unique";
	}
	if(assocType.equalsIgnoreCase("unique") || assocType.equalsIgnoreCase("anyex"))
	{
		assoTests = layerBean.getAssociatedTests();
	}

	if(t_tests!=null && t_tests.size()>0)
	{
		for(int i=0;i<t_tests.size();i++)
		{
			tStr=(String)t_tests.get(i);
			if(!(tStr.endsWith("_cf")))
				tests.add(tStr);
		}
	}

	if(t_allTests!=null && t_allTests.size()>0)
	{
		for(int i=0;i<t_allTests.size();i++)
		{
			tStr=(String)t_allTests.get(i);
			if(!(tStr.endsWith("_cf")))
				allTests.add(tStr);
		}
	}

	EgSpecsInfo specsInfo = new EgSpecsInfo("manager");
	allTests = specsInfo.getLicensedTests(allTests);

	EgServicesInfo servicesInfo = new EgServicesInfo("manager");
	if (!servicesInfo.isAllowExistingTypesInIC())
	{
		if (allTests != null)
		{
			for (int i=allTests.size() -1 ; i >=0; i--)
			{
				String test = (String)allTests.get(i);
				test = test.toLowerCase().trim();
				if (!test.endsWith("_ex"))
				{
					allTests.remove(i);
				}
			}
		}
	}

	rootJSON.put("displayLayerName",_mapping.getLayerDescription(layer));
	
	String hiddenAggTests = "";
	ArrayList assoTests2 = new ArrayList();
	String testList = "";
	for(int i=0; i<tests.size() ; i++)
	{
		String test = (String) tests.get(i);
		testList += test + ",";
		if(test.endsWith("_ag") || test.endsWith("_agx"))
		{
			if(hiddenAggTests.length()==0)
				hiddenAggTests = test;
			else
				hiddenAggTests += "," + test;
			continue;
		}
		assoTests2.add(test);
	}
	if (!EgInstallInfo.isO365UsersLicense)
	{
		EgMsUsersInfo msUsers = new EgMsUsersInfo();
		ArrayList msTests = msUsers.getMSTestsForAgentGenerator();
		allTests.removeAll(msTests);
		assoTests2.removeAll(msTests);
	}
	assoTests2 = sorter.getSortedTestList(assoTests2);
	JSONArray assoTestsJSON = new JSONArray();
	JSONArray cloneAssoTestsJSON = new JSONArray();
	JSONObject obj = new JSONObject();
	for (int j=0;j<assoTests2.size();j++)
	{
		EgName name = (EgName)assoTests2.get(j);
		String tmpVal = name.getActualName();
		String tmpDis = name.getLocalName();
		obj = new JSONObject();
		obj.put("displayField",tmpDis);
		obj.put("valueField",tmpVal);
		assoTestsJSON.add(obj);
		cloneAssoTestsJSON.add(obj);
	}
	for (int a=0; a<assoTestsJSON.size(); a++)
	{
		JSONObject nameObj1 = (JSONObject)assoTestsJSON.get(a);
		String tmpVal1 = (String)nameObj1.get("valueField");
		String tmpDis1 = (String)nameObj1.get("displayField");
		for (int b=0; b<cloneAssoTestsJSON.size(); b++)
		{
			JSONObject nameObj2 = (JSONObject)cloneAssoTestsJSON.get(b);
			String tmpVal2 = (String)nameObj2.get("valueField");
			String tmpDis2 = (String)nameObj2.get("displayField");
			if (tmpVal1.equalsIgnoreCase(tmpVal2))
			{
				continue;
			}
			if (tmpDis1.equalsIgnoreCase(tmpDis2))
			{
				String compTypeStr = "";
				ArrayList compTypeArr = new ArrayList();
				for(int k =0; k<compTypes.length; k++)
				{
					String compType = compTypes[k];
					boolean flag = specsInfo.isTestRelevantForServer(compType,tmpVal2,true);
					if(flag)
					{
						compTypeArr.add(_mapping.getComponentTypeDescription(compType));
					}
				}
				Collections.sort(compTypeArr,String.CASE_INSENSITIVE_ORDER);
				for(int v=0; v<compTypeArr.size(); v++)
				{
					String compTypeVal = (String)compTypeArr.get(v);
					compTypeStr += compTypeVal+", ";
				}
				if(compTypeStr.endsWith(", "))
				{
					compTypeStr = compTypeStr.substring(0,compTypeStr.length()-2);
				}
				if(compTypeStr!= "" && compTypeStr!=null)
					tmpDis2 = tmpDis2+" ("+compTypeStr+")";

				JSONObject nameObj3 = new JSONObject();
				nameObj3.put("valueField",tmpVal2);
				nameObj3.put("displayField",tmpDis2);
				cloneAssoTestsJSON.remove(b);
				cloneAssoTestsJSON.add(b,nameObj3);
			}
		}
	}
	rootJSON.put("assoTests",cloneAssoTestsJSON);
	if(testList.length() > 0)
		testList = testList.substring(0, testList.length()-1);
	hiddens.put("testlist",testList);

	ArrayList testsList = new ArrayList();
	for(int i=0; i<allTests.size(); i++)
	{
		String test = (String) allTests.get(i);
		if(tests.indexOf(test) >= 0)
			continue;

		// Changes made for multi Layer association for tests
		if(assocType.equalsIgnoreCase("unique"))
		{
			if(assoTests.indexOf(test) >= 0)
				continue;
		}
		else if(!test.endsWith("_ex") && assocType.equalsIgnoreCase("anyex"))
		{
			if(assoTests.indexOf(test) >= 0)
				continue;
		}
		//Changes ends here
		if (EgInstallInfo.isConfigTest(test.trim()))//Removal of _cf tests
		{
			continue;
		}
		if(test.endsWith("_ag") || test.endsWith("_agx"))
		{
			continue;
		}
		testsList.add(test);
	}

	// Associating a host test to a custom layer (non host level) leads to test disappears issue in layer model UI.So removing here.
	if (layer.toLowerCase().endsWith("_ex"))
	{
		testsList.removeAll(hostLevelTests);
	}

	//Fix for bug ID: 8270. Fix : Dont allow oracle base tests to associate with non-oracle layers.
	if (isNonOracleLayer)
	{
		testsList.removeAll(oracleRelatedTests);
	}
	testsList = sorter.getSortedTestList(testsList);
	JSONArray disoTestsJSON = new JSONArray();
	JSONArray cloneDisoTestsJSON = new JSONArray();
	for (int j=0;j<testsList.size();j++)
	{
		EgName nameObj = (EgName)testsList.get(j);
		String tmpVal = nameObj.getActualName();
		String tmpDis = nameObj.getLocalName();
		obj.put("valueField",tmpVal);
		obj.put("displayField",tmpDis);
		disoTestsJSON.add(obj);
		cloneDisoTestsJSON.add(obj);
	}
	for (int a=0; a<disoTestsJSON.size(); a++)
	{
		JSONObject nameObj1 = (JSONObject)disoTestsJSON.get(a);
		String tmpVal1 = (String)nameObj1.get("valueField");
		String tmpDis1 = (String)nameObj1.get("displayField");
		for (int b=0; b<cloneDisoTestsJSON.size(); b++)
		{
			JSONObject nameObj2 = (JSONObject)cloneDisoTestsJSON.get(b);
			String tmpVal2 = (String)nameObj2.get("valueField");
			String tmpDis2 = (String)nameObj2.get("displayField");
			if (tmpVal1.equalsIgnoreCase(tmpVal2))
			{
				continue;
			}
			if (tmpDis1.equalsIgnoreCase(tmpDis2))
			{
				String compTypeStr = "";
				ArrayList compTypeArr = new ArrayList();
				for(int k =0; k<compTypes.length; k++)
				{
					String compType = compTypes[k];
					boolean flag = specsInfo.isTestRelevantForServer(compType,tmpVal2,true);
					if(flag)
					{
						compTypeArr.add(_mapping.getComponentTypeDescription(compType));
					}
				}
				Collections.sort(compTypeArr,String.CASE_INSENSITIVE_ORDER);
				for(int v=0; v<compTypeArr.size(); v++)
				{
					String compTypeVal = (String)compTypeArr.get(v);
					compTypeStr += compTypeVal+", ";
				}
				if(compTypeStr.endsWith(", "))
				{
					compTypeStr = compTypeStr.substring(0,compTypeStr.length()-2);
				}
				if(compTypeStr!= "" && compTypeStr!=null)
					tmpDis2 = tmpDis2+" ("+compTypeStr+")";
				JSONObject nameObj3 = new JSONObject();
				nameObj3.put("valueField",tmpVal2);
				nameObj3.put("displayField",tmpDis2);
				cloneDisoTestsJSON.remove(b);
				cloneDisoTestsJSON.add(b,nameObj3);
			}
		}
	}
	rootJSON.put("disoTests",cloneDisoTestsJSON);
	hiddens.put("layer",layer); // fassociate, fdissociate
	rootJSON.put("hiddens",hiddens);
	out.println(rootJSON);
%>


