<%
/***********************************************************************************************************
*	Name			:	renamep.jsp
*	Purpose			:	Process page for rename.jsp
*	Version			:	5.5
*	CreationDate	:	17-Feb-2012
*	Author			:	James Thomas P
***********************************************************************************************************/
%>

<%@ include file="../../EgTrackerAJSON.jsp" %>
<%@ page errorPage="../../EgProbs.jsp"%>
<%@ page import = "com.eg.IniFile"%>
<%@ page import = "com.eg.EgGroupInfoAdmin"%>
<%@ page import = "com.eg.EgURLDecoder"%>
<%@ page import = "com.eg.EgAutoTopologyPreview"%>
<%@ page import = "com.egurkha.admin.Rename"%>
<%@ page import = "com.egurkha.admin.AuditLogThread"%>
<%@ page import = "com.egurkha.admin.EgComponentGroup"%>
<%@ page import = "com.egurkha.ini.IniUI"%>
<%@ page import = "com.egurkha.util.StringUtils"%>
<%@ page import = "java.util.*"%>
<%@ page import="net.sf.json.*"%>
<%@ page language="java" contentType="application/json; charset=UTF-8" pageEncoding="UTF-8" %>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);

	response.setContentType("application/json;charset=UTF-8");
	JSONObject rootJson = new JSONObject();

	String rename = request.getParameter("rename");
	String old_name = EgURLDecoder.decode(request.getParameter("old_name"),"UTF-8");
	String new_name = EgURLDecoder.decode(request.getParameter("new_name"),"UTF-8");
	EgAutoTopologyPreview autoTopoPreview = new EgAutoTopologyPreview();


	String message = null;
	boolean renameStatus = true;

	if(StringUtils.isNull(old_name) || StringUtils.isNull(new_name) || StringUtils.isNull(rename))
	{
		renameStatus = false;
		if(StringUtils.isNull(rename))
		{
			message = _mapping.getTextDescription("admin.error.Operation is not defined")+".";
		}
		else
		{
			if(StringUtils.isNull(new_name))
			{
				message = _mapping.getTextDescription("admin.error.You can not proceed renaming with new name as empty or null")+".";
			}
			else
			{
				message = _mapping.getTextDescription("admin.error.You can not proceed renaming as current name is empty or null")+".";
			}
		}
	}
	else
	{
		rename = rename.trim();
		old_name = old_name.trim();
		new_name = new_name.trim();

		if(IniUI.isEgReservedKeyword(new_name))
		{
			renameStatus = false;
			message = "'"+new_name.toUpperCase() +"' "+_mapping.getTextDescription("admin.error.is an eG defined keyword")+". "+_mapping.getTextDescription("admin.error.Choose another name")+".";
		}
		else
		{
			boolean oldNameExist = false;
			boolean isSite = false;
			String auditlogLabel = null;
			String nameConflictLabel = null;
			String update_msmt_table = "true";
			Vector nameConflict = new Vector();//dont add anything into this vector

			AuditLogThread auditLogThread = new AuditLogThread();
			auditLogThread.setValue("Category","Admin");
			auditLogThread.setValue("User_id",_user.getLoginID());
			auditLogThread.setValue("Host_ip",_user.getUserIP(session.getId()));
			auditLogThread.setValue("Session_id",session.getId());
			auditLogThread.setValue("Activity","Rename Group");

			String targetPageURL = null;
			
			auditLogThread.setValue("Module","Component Groups");
			oldNameExist = Rename.doesOldnameExist(new EgGroupInfoAdmin().getGroupNames(),old_name,new_name,nameConflict);
			nameConflictLabel="admin.error.You are trying to rename a group with a name which is already assigned to some other group";
			auditlogLabel=old_name + " group can not be renamed to "+new_name +" as this name is already assigned to some other group";
			
			if(!nameConflict.isEmpty())
			{
				renameStatus = false;
				auditLogThread.setValue("Description",auditlogLabel);
				auditLogThread.sendItToDB();
				message = _mapping.getTextDescription(nameConflictLabel)+".";
			}
			else
			{
				if(oldNameExist)
				{
					boolean success = false;
					EgComponentGroup comGr = new EgComponentGroup();
					comGr.renameGroup(old_name,new_name);
					comGr.renameDiscoveredGroup(old_name,new_name);
					auditLogThread.setPreviousValue("Group name",old_name);
					auditLogThread.setCurrentValue("Group name",new_name);
					auditLogThread.setValue("Description","Group has been renamed");
					auditLogThread.sendItToDB();
					String label = "admin.common."+rename.toLowerCase()+" has been renamed successfully to";
					message = old_name + " " + _mapping.getTextDescription(label) + " " + new_name + ".";
					autoTopoPreview.autoTopology();
					
				}
				else
				{
					renameStatus = false;
					String errorLabel = rename + " name";
					auditLogThread.setPreviousValue(errorLabel,old_name);
					auditLogThread.setCurrentValue(errorLabel,new_name);
					auditLogThread.setValue("Description",rename+" was not renamed as it had already been deleted");
					auditLogThread.sendItToDB();
					String label = "admin.common."+rename.toLowerCase()+" was not renamed to";
					message = old_name + " " +_mapping.getTextDescription(label) + " " + new_name +".";
				}
			}
		}
	}
	rootJson.put("message",message);
	rootJson.put("renamed",renameStatus);
	rootJson.put("rename",_mapping.getTextDescription("admin.common.Rename"));
	rootJson.put("success","true");
	out.println(rootJson.toString());
%>