<%
/*************************************************************************************************/
/*                 Name          : EgTopologySettings.jsp                                        */
/*                 Purpose       : This page is used to specify topology options or settings     */
/*                 Version       : 5.4                                                           */
/*                 Created On    : 05-08-2011                                                    */
/*************************************************************************************************/
%>
<%@ include file="EgTrackerA.jsp" %>
<%@ page errorPage="EgProbs.jsp"%>
<%@ page import = "java.util.*"%>
<%@ page import = "com.egurkha.ini.IniUI" %>
<%@ taglib prefix ="egui" uri="../WEB-INF/eg-taglib.tld"%>
<%@ page language = "java" contentType = "text/html; charset=UTF-8" pageEncoding = "UTF-8" %>
<%
try
{
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);

	IniUI iniUI = IniUI.getInstance();
	String TOPOLOGY_OPTIONS = "TOPOLOGY_OPTIONS";
	String AUTO_TOPOLOGY_OPTIONS = "AUTO_TOPOLOGY_OPTIONS";
	String rs =	iniUI.getValue(TOPOLOGY_OPTIONS,"Row_space");
	String cs = iniUI.getValue(TOPOLOGY_OPTIONS,"Column_space");
	String showSingleTopology = iniUI.getValue(AUTO_TOPOLOGY_OPTIONS,"ShowSingleTopology");

	if(showSingleTopology==null || showSingleTopology=="") 
		showSingleTopology = "Yes";
	String checkYes="";
	String checkNo="";
	if(showSingleTopology.equalsIgnoreCase("yes") || showSingleTopology.equalsIgnoreCase("true"))
		checkNo = "checked";
	else
		checkYes = "checked";
%>

<html>
<head>
<title>Topology settings</title>
<egui:skin ui="admin"/>
<script  src="/final/jquery/jquery.js"></script>
<script type="text/javascript">

var $j = jQuery.noConflict();

function centerScreen(selector) 
{
	var newTop =   $j("#settingsDiv").height() - $j(selector).height() / 2;
	var newLeft =  ($j("#settingsDiv").width()  - $j(selector).width()) / 2;
	$j(selector).css({
		'position': 'absolute',
		'left': newLeft,
		'top': newTop / 2
	});
}

function hideDivs(divId)
{
	$j("#"+divId).hide("slow");
}

function updateFunction()
{
	var topologyForm = document.topologyForm;
	topologyForm.update.disabled=true;
	var action = "updateOptions";
	var thisFrom = document.topologyForm;
	var colValue = thisFrom.colValue.value;
	var rowValue = thisFrom.rowValue.value;
	var multiOptValue = thisFrom.multiOpt;
	var singleTopology = '';
	if(multiOptValue[0].checked)
	{
		singleTopology ='No';
	}
	else if(multiOptValue[1].checked)
	{
		singleTopology ='Yes';
	}
	var url  = '/final/servlet/com.eg.EgAutoTopologyServlet?action='+encodeURI(action)+'&rowspace='+encodeURI(rowValue)+'&colspace='+encodeURI(colValue)+'&singletopology='+(singleTopology);
	var httpObj = createRequestObject();
	var params = "";
	var tempurl = "";
	if (url.indexOf("?") > -1)
	{
		params=url.substring(url.indexOf("?")+1);
		tempurl=url.substring(0,url.indexOf("?"));
	}
	else
	{
		tempurl=url;
	}
	httpObj.open('POST',tempurl,true);
	httpObj.setRequestHeader('Content-type','application/x-www-form-urlencoded');
	httpObj.setRequestHeader('Content-length',params.length);
	httpObj.setRequestHeader('Connection','close');
	httpObj.onreadystatechange = function() {
		if (httpObj.readyState == 4 && httpObj.status == 200)
		{
			var resp = httpObj.responseText;
			//alert("<egui:intnl text='admin.topology.Topology settings successfully updated !'/>");
			showlinkDiv();
		}
		topologyForm.update.disabled=false;
	}
	httpObj.send(params);
}

function maxIndex()
{
	var index_highest = 0;
	$j('div').each(function(){
		var index_current = parseInt($j(this).css("z-index"), 10);
		if(index_current > index_highest) {
			index_highest = index_current;
		}
	});
	return index_highest.toString();
}

function showlinkDiv()
{
	var maxInd = maxIndex();
	$j("#linkDiv").css({"display":"block" , "position":"absolute" });
	$j("#linkDiv").css({"z-index":maxInd+1});
	$j("#linkDiv").show('slow');
	centerScreen('#linkDiv');
}

</script>
</head>
<body style="overflow:hidden" id="space6" scrolling="no" class="eg_lightlight">

<div id="linkDiv" name="linkDiv" style="display:none;left:50px;top:50px;width:300px;height:80px;border:0px solid #ff0000; position:absolute;">
	<table  border="0" cellspacing="0" cellpadding="0" width="100%">
		<tr>
			<td class="pop2_lefttop_curve"><img src="/final/admin/eg_images/spacer.gif" width="11" height="11"></td>
			<td class="pop2_top_bg" width="100%"><img src="/final/admin/eg_images/spacer.gif" width="2" height="11"></td>
			<td class="pop2_righttop_curve" ><img src="/final/admin/eg_images/spacer.gif" width="11" height="11"></td>
		</tr>
		<tr>
			<td class="pop2_left_bg"><img src="/final/admin/eg_images/spacer.gif" width="11" height="50px"></td>
			<td class="eg_whitebg" align="center">
				<div style="height:50px;border:1px solid black;">
					<table border="0" cellspacing="0" cellpadding="4" align="center" width="100%">
						<tr align="center">
							<td><egui:intnl text='admin.topology.Topology settings successfully updated !'/></td>
						</tr>
						<tr align="center">
							<td><input type="button" class="eg_lightbutton" name="okButton" id="okButton" value=" OK " onclick="javascript:hideDivs('linkDiv');"style="padding-left:4px;padding-right:4px"></td>
						</tr>
					</table>
				</div>
			</td>
			<td class="pop2_right_bg"><img src="/final/admin/eg_images/spacer.gif" width="11" height="50px"></td>
		</tr>
		<tr>
			<td class="pop2_leftbottom_curve"><img src="/final/admin/eg_images/spacer.gif" width="11" height="11"></td>
			<td class="pop2_bottom_bg"><img src="/final/admin/eg_images/spacer.gif" width="2" height="11"></td>
			<td class="pop2_rightbottom_curve"><img src="/final/admin/eg_images/spacer.gif" width="11" height="11"></td>
		</tr>
	</table>
</div>

<form name="topologyForm" style="margin:0px;padding:0px">
<table border="0" align="center" cellspacing="0" cellpadding="0" width="100%" class="eg_lightlight">
	<tr>
		<td width="100%"  align="center"  valign="top" >
			<table align="center" cellspacing="0" cellpadding="3" width="100%" border="0" style="table-layout:fixed"  class="eg_subcontentbg"><col width="150" style="padding-left:10px"><col width="10"><col width="230">
				<tr><td colspan="3" class="eg_blankspace" height="20px">&nbsp;</td></tr>
				<tr>
					<td nowrap  class="eg_75bold"><egui:intnl text="admin.segment.Vertical gap"/></td>
					<td nowrap >:</td>
					<td nowrap> 
						<select name="rowValue" id="rowValue" style="width:200px">
<%
	for(int k=50;k<=120;k=k+5)
	{
		String value = Integer.toString(k);
		String selected = "";
		if(value.equals(rs))
			selected = "selected";
%>
							<option value="<%=value%>" <%=selected%>> <%=value%> </option>
<%
	}
%>
						</select>
					</td>
				</tr>
				<tr><td colspan="3" class="eg_blankspace" height="2px">&nbsp;</td></tr>
				<tr>
					<td nowrap  class="eg_75bold"><egui:intnl text="admin.segment.Horizontal gap"/></td>
					<td nowrap >:</td>
					<td nowrap>
						<select name="colValue" id="colValue"  style="width:200px">
<%
	for(int k=50;k<=120;k=k+5)
	{
		String value = Integer.toString(k);
		String selected = "";
		if(value.equals(cs))
			selected = "selected";
%>
							<option value="<%=value%>" <%=selected%>> <%=value%> </option>
<%
	}
%>
						</select>
					</td>
				</tr>
				<tr><td colspan="3" class="eg_blankspace" height="2px">&nbsp;</td></tr>
				<tr>
					<td nowrap  class="eg_75bold"> <egui:intnl text="admin.segment.Show multiple topologies"/></td>
					<td  nowrap >:</td>
					<td nowrap>
						<table  width="40%" cellspacing="0" cellpadding="0" border="0">
							<tr>
								<td id="eg_subcontentbg" class="eg_subcontent" width="20"><input type="radio" name="multiOpt" id="multiOpt" value="Yes" class="eg_input" <%=checkYes%>></td>
								<td style="width:70px"> <egui:intnl text="admin.segment.Yes"/> </td>
								<td id="eg_subcontentbg" class="eg_subcontent" width="20"><input type="radio" name="multiOpt" id="multiOpt" value="No" class="eg_input" <%=checkNo%> ></td>
								<td> <egui:intnl text="admin.segment.No"/></td>
							</tr>
						</table>
					</td>
				</tr>
			</table>
		</td>
	</tr>
	<tr><td  class="eg_blankspace" height="20px">&nbsp;</td></tr>
	<tr>
		<td align="center" ><input type="button" style="width:80px;" id="eg_back" name="update" value='<egui:intnl text="admin.segment.Update"/>' onClick="javascript:updateFunction();"></td>
	</tr>
	<tr><td  class="eg_blankspace" height="20px">&nbsp;</td></tr>
</table>
</form>
</body>
</html>
<%
}
catch(Exception e)
{
	System.out.println("Exception Occured in EgTopologySettings.jsp....");
	e.printStackTrace();
}
%>
