<!DOCTYPE html>
<%@ page import="com.eg.EgConMonHelper"%>
<%@ page import ="com.egurkha.util.StringUtils"%>
<%@ page import = "com.egurkha.User"%>
<%@ page import = "com.egurkha.UserRegistry"%>
<%@ page import = "com.egurkha.ini.IniUI"%>
<%@ page import = "com.eg.IniFile"%>
<%@ page import = "com.eg.EgConfigInfo"%>

<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>

<%
	String sessionInUse = request.getParameter("sessionInUse");
	String pwd = request.getParameter("pwd");
	String authenticated = (String)session.getAttribute("authenticated");

	if (authenticated == null)
	{
		// Direct access from the browser address bar or from inside the toolkit via the tool
		if (pwd == null)
		{
			if (sessionInUse == null)
			{
				response.sendRedirect(request.getContextPath()+"/toolkitlogin?comeFrom=ViewData");
			}
			else
			{
%>
				<script>
					window.parent.location.href ="/final/toolkitlogin";
				</script>
<%
			}
		}
		else
		{
			// Direct access from the browser address bar
			if (!pwd.equals(EgConMonHelper.executePwd))
			{
				response.sendRedirect(request.getContextPath()+"/toolkitlogin?comeFrom=ViewData");
			}
			else
			{
				session.setAttribute("reqFromForTk","ViewData");
				String redirectURL = request.getContextPath()+"/toolkit";
				response.sendRedirect(redirectURL);
			}
		}
	}
	else
	{ 
		// Direct access from the browser address bar and session in use
		if (sessionInUse == null)
		{
			response.sendRedirect(request.getContextPath()+"/toolkit");
		}
	}

	String comeFrom = request.getParameter("comeFrom");
	if (!StringUtils.isNull(comeFrom) && comeFrom.equals("View"))
	{
		session.setAttribute("treeViewSrc","ViewData");
	}
	session.setAttribute("reqFromForTk","ViewData");

	UserRegistry registry = UserRegistry.getInstance();
	User user = registry.getUser(session.getId());
	IniUI iniUI = IniUI.getInstance();

	String userLanguage = iniUI.getDefaultLanguage();
	if (user != null)
	{
		userLanguage = user.getLanguage();
	}

	int record_Limit = 10000; // Max limited records for csv
	int column_Limit = 46; // Max limited columns for csv (No. of measures * 2 + 6)
	long time_Limit = 5 * 60 * 1000; // Max time limit for query execution by default 5 mins

	IniFile iniUIFile = new IniFile(EgConfigInfo.egMgrConfigDir+"eg_ui.ini");
	String csv_limitStr = iniUIFile.getValue("TOOLKIT_VIEWDATA_SETTINGS","CSV_Record_Limit");
	if (csv_limitStr != null && csv_limitStr.trim().length() > 0)
	{
		try
		{
			record_Limit = Integer.parseInt(csv_limitStr);
			if (record_Limit <= 0 || record_Limit > 10000)
			{
				record_Limit = 10000;
			}
		}
		catch(Exception e)
		{
			record_Limit = 10000;
		}
	}

	int rows = 10;
	int scrollY = 350;
	int scrollY_Empty = 272;
	String user_agent = request.getHeader("User-Agent");
	if(user_agent != null && user_agent.toLowerCase().indexOf("firefox")>-1)
	{
		rows = 8;
		scrollY = 347;
		scrollY_Empty = 268;
	}
%>

<html>
<head>
<meta http-equiv="pragma" content="no-cache" />
<style>
.iconCsv{
	background : url('/final/images/Light/eG_Icons.png') no-repeat top left;
	background-position: -0px -420px; width: 16px; height: 16px;
	cursor:pointer;
	outline:none;
}
.btn-group {
	color: block;
	padding: 5px 5px 5px 5px;
	margin-right: 10px;
	float: center;
	text-align:center;
	font-size:12px;
	cursor: pointer;
}
.alert {
  padding: 30px 60px;
  margin:30px 60px 30px 60px;
  background-color: #BFC9CA;
  display:none;
}
.closebtn {
  margin-left:15px;
  margin-right: 5px;
  margin-top: 5px;
  color: white;
  font-weight: bold;
  float: right;
  font-size: 22px;
  line-height: 20px;
  cursor: pointer;
  transition: 0.3s;
}
.closebtn:hover {
  color: black;
}
.display-label{
	margin-right:10px;
	font-size:14px;
	text-align: justify;
	text-justify: inter-word;
}
code{
	font-size:11px;
	color:gray;
}
code:hover{
	color:black;
}
</style>
<script language="javascript" src="/final/admin/eg_scripts/timeout.js"></script>
<script src="/final/scripts/utilities/EncodeDecodeParams.js"></script>
<script>
document.onscroll = function()
{
	clearTimeout(time);
	time = setTimeout(logout,timeoutTime);
}
</script>
</head>

<body style='overflow:hidden' onload='autoFocus()'>
<script language="javascript1.2">
var lastRemindQuery = "";
function autoFocus()
{
	document.testing.query.focus();
}

function clearForm()
{
	document.testing.query.value = "";
	clearElements();
	autoFocus();
}

function remindQuery()
{
	lastRemindQuery = window.sessionStorage;
	var query = document.testing.query.value;
	if(query == "" || query.length == 0)
	{
		showDisplayMsg("Error!","Please enter the query to save");
		autoFocus();
		return;
	}
	lastRemindQuery.setItem("query",query);
	$("#recallButton").css("opacity","");
	$("#recallButton").css("cursor","pointer");
}

function recallQuery()
{
	lastRemindQuery = window.sessionStorage;
	var query = lastRemindQuery.getItem("query");
	if(query != null)
	{
		document.testing.query.value = query;
		clearElements();
	}
	else
	{
		autoFocus();
	}
}

function saveCSVData()
{
	if(disabled)
	{
		return;
	}
	var downloadURL = "/final/servlet/com.eg.SaveInCSVFormat?viewDataCSV=true&reqFromTk=true&user_language="+"<%=userLanguage%>";
	var searchVal = $('.dataTables_filter input').val();
	if(searchVal != null && searchVal != '')
	{
		downloadURL += "&searchStr="+searchVal; 
	}
	window.location.href=downloadURL;
}

function showLoadImage(show)
{
	var loading_image = document.getElementById("loading_image");
	if (loading_image != null)
	{
		if(show)
		{
			loading_image.style.display = "block";
			loading_image.style.position = 'absolute';
			var queryStr = $("#query").val().toLowerCase();
			var message = "Please wait the data is being fetched...";
			if(queryStr.indexOf("create") == 0)
				message = "Please wait the table is being created...";
			else if(queryStr.indexOf("insert") == 0)
				message = "Please wait the data is being inserted...";
			else if(queryStr.indexOf("update") == 0)
				message = "Please wait the data is being updated...";
			else if(queryStr.indexOf("drop") == 0 || queryStr.indexOf("truncate") == 0 || queryStr.indexOf("delete") == 0)
				message = "Please wait the data is being deleted...";
			$("#lodingMsg").html(message);
		}
		else
		{
			loading_image.style.display = "none";
		}
	}
}

function formatCommas(x) 
{
	x = x.toString();
	var pattern = /(-?\d+)(\d{3})/;
	while (pattern.test(x))
		x = x.replace(pattern, "$1,$2");
	return x;
}

function clearElements()
{
	var tableDiv = document.getElementById('tableDiv');
	if(tableDiv.firstChild)
	{
		tableDiv.removeChild(tableDiv.firstChild);
	}
	$("#csvDiv").css("display","none");
	$("#totalRec").css("display","none");
	$("#alertMsg").css("display","none");
}

function showDisplayMsg(msgHeader,msgBody)
{
	clearElements();
	$("#alertMsg").css("display","block");
	$("#displayLabel").html("<b style='color:white;font-size:20px'>"+msgHeader+"</b> "+msgBody);
}

function executeQuery()
{
	var thisForm = document.testing;
	var query = thisForm.query.value.trim();
	if(query == "")
	{
		showDisplayMsg("Error!","Please enter the query to execute");
		autoFocus();
		return;
	}
	else
	{
		if(query.indexOf("*") == 0)
		{
			var qry = query;
			qry = qry.substring(1,qry.length);
			qry = qry.trim();
			qry = "select * from " + qry;
			thisForm.query.value = qry;
		}
		else
		{
			thisForm.query.value = query;
		}
	}
	clearElements();
	showLoadImage(true);
	$.ajax({
		type :'POST',
		url:  'processData.jsp',
		data: {"s_query" : filterEncode(thisForm.query.value),"rec_limit" : "<%=record_Limit%>", "col_limit" : "<%=column_Limit%>", "time_limit" : "<%=time_Limit%>"},
		dataType: 'json',
		timeout: '<%=time_Limit%>',
		success: function(response,status)
		{
			if(status == 'success')
			{
				showLoadImage(false);
				if(response.dataFetched)
				{
					scrollY_Height = (response.tableData.length == 0) ? '<%=scrollY_Empty%>' : '<%=scrollY%>';
					var is_Required = response.tableData.length > 0 ? true : false;
					var table = document.createElement('table');
					table.setAttribute('class','display');
					table.id = 'resultDiv';
					table.height = '100%';
					tableDiv.appendChild(table);
					$('#resultDiv').DataTable({ 
						searching: is_Required,
						bInfo: is_Required,
						bPaginate : is_Required,
						deferRender: true,
						sScrollX: '100%',
						sScrollXInner: '100%',
						scroller: true,
						scrollY: window.innerHeight-scrollY_Height+'px',
						data: response.tableData,
						columns: response.tableHeader,
						rowCallback: function (nRow, aData, iDisplayIndex) {
							var oSettings = this.fnSettings();
							$("#totalRec").html('Total Records : '+formatCommas(oSettings.aiDisplay.length));
							$("td:first", nRow).html(oSettings._iDisplayStart+iDisplayIndex +1);
							return nRow;
						},
						drawCallback: function(oSettings){
							if(oSettings.nScrollBody.scrollTop >0)
							{
								oSettings.nScrollBody.scrollTop = 0;
							}
							if(oSettings.aiDisplay.length == 0)
							{
								$("#totalRec").html('Total Records : 0');
								$("#csvDiv").css("opacity","0.3");
								$("#savecsv").css("cursor","auto");
								disabled = true;
							}
							else
							{
								$("#csvDiv").css("opacity","");
								$("#savecsv").css("cursor","pointer");
								disabled = false;
							}
						}
					});
					$('#resultDiv').closest('.dataTables_scrollBody').css('height', window.innerHeight-scrollY_Height+'px');
					$('#resultDiv').DataTable().draw();
					if(response.tableData.length >0)
					{
						$("#totalRec").css("display","block");
						$("#totalRec").html('Total Records : '+formatCommas(response.tableData.length));
						if (response.tableData.length <= '<%=record_Limit%>' && response.tableHeader.length <= '<%=column_Limit%>')
						{
							$("#csvDiv").css("display","block");
						}
					}
					else
					{
						$('#resultDiv_wrapper').css('padding','0px 0px 0px 0px');
					}
				}
				else
				{
					showDisplayMsg(response.msgHeader,response.msgBody);
				}
			}
		},
		error: function(error)
		{
			showLoadImage(false);
			showDisplayMsg("Error!","Response timed out");
		}
	 });
}
</script>

<script src="/final/jquery/jquery.js"></script>
<link rel="stylesheet" href="eg_styles/eg_adminstyle.css" />
<script src="/final/admin/eg_scripts/DataTables.js"></script>
<link rel="stylesheet" href="/final/admin/styles/DataTables.css"></style>
<form  name="testing" id="formID" method="post" action="" style="margin:5px 1px 5px 5px">
	<table border="0" cellpadding="3" cellspacing="0" align="center" width="100%">
		<tr>
			<td align ="left"  class="errortext" id="subhead" nowrap><b>Query</b></td>
		</tr>
		<tr>
			<td><textarea rows="<%=rows%>" cols="100" name="query" id="query" style="width:99.1%" spellcheck="false"></textarea></td>
		</tr>
		<tr rowspan="4">
			<td align="center">
				<button type="button" style="width:15%" name="executeButton" id="executeButton" class="btn-group">Execute<br>
					<code>Shift+Enter</code>
				</button>
				<button type="button" style="width:15%" name="clearButton" id="clearButton" class="btn-group" onclick="javascript:clearForm()">Clear<br>
					<code>Ctrl+Delete</code>
				</button>
				<button type="button" style="width:17%" name="saveButton" id="saveButton" class="btn-group" onClick="javascript:remindQuery()">Save this query<br>
					<code>Ctrl+S</code>
				</button>
				<button type="button" style="width:17%" name="recallButton" id="recallButton" class="btn-group" onClick="javascript:recallQuery()">Recall saved query<br>
					<code>Ctrl+R</code>
				</button>
			</td>
		</tr>
	</table>
</form>
<div id='totalRec' style="float:left;padding:5px 0px 5px 5px;font-family:Arial Narrow;font-size:15px;margin:1px 0px 0px 5px" nowrap></div>
<div align="right" style="float:right;padding:5px 10px 5px 0px;display:none" id="csvDiv">
	<button title="CSV" onClick="javascript:saveCSVData()" style="border:0px" id="savecsv" class="iconCsv"/>
</div>
<div id="loading_image" name="loading_image"  style="background-color:#AAB7B8;display:none;position:absolute;left:35%; top:40%;width:328px;height:80px">
	<center style="margin-top:10px;"><img src='/final/admin/eg_images/loading-bar.gif' width='143' height='30'/></center>
	<center style="font-size:11px;margin-top:5px;"><label id="lodingMsg"></label></center>
</div>
<div class="alert" id="alertMsg">
	<table width="100%">
		<tr>
			<td><div id="displayLabel" class="display-label"></div></td>
			<td><span class="closebtn" onclick="$('#alertMsg').css('display','none');javascript:autoFocus();">&times;</span></td>
		</tr>
	</table>
</div>
<div id='tableDiv' style='margin:7px 8px 5px 7px'></div>

<script>
var scrollY_Height = '<%=scrollY%>';
if(window.sessionStorage.getItem("query") == null)
{
	$("#recallButton").css("opacity","0.5");
	$("#recallButton").css("cursor","auto");
}

$(window).resize(function(){
	if($('#resultDiv').DataTable().context[0] != undefined)
	{
		$('#resultDiv').DataTable().context[0].oScroll.sY = window.innerHeight-scrollY_Height+'px';
		$('#resultDiv').closest('.dataTables_scrollBody').css('height', window.innerHeight-scrollY_Height+'px');
		$('#resultDiv').DataTable().draw();
	}
});

$("#executeButton").click(function(){
	executeQuery();
});

document.getElementById('query').addEventListener("keydown", function(e){
	if(e.which == 13 && e.shiftKey)
	{
		e.preventDefault();
		executeQuery();
	}
	else if((e.key == 'Delete' || e.key == 'Del') && e.ctrlKey)
	{
		e.preventDefault();
		clearForm();
	}
	else if(e.which == 83 && e.ctrlKey)
	{
		e.preventDefault();
		remindQuery()
	}
	else if(e.which == 82 && e.ctrlKey)
	{
		e.preventDefault();
		recallQuery();
	}
});

</script>
</body>
</html>



