<%
/**
 *	Name        :	EgIncludep.jsp
 *  Purpose     :   Configure Test Topology
 *  Version     :   0.1
 *  Created		:   3/10/2000
 *  Modified	:   
 *					22/06/2004	Arun		Weblogic tests have use a "server" parameter which is also 
 *											used by the JSP to send the server type. Change the query 
 *											parameter to typeOfServer to remove ambiguity.
 *					30/08/2001	sandhya		to stop discovery before deleting from eg_disable.ini 
 *											and to start discovery after deleting from eg_disable.ini.
 *					05-06-2001	Bala		saving IniFiles	
 *					16:05:2001	Bala		added explicit stop discovery 
 *
 *  Author		:	Sridevi.T
 */
%>

<%@ include file="EgTrackerA.jsp" %>
<%@ page errorPage="EgProbs.jsp"%>
<%@ page import="java.util.*" %>
<%@ page import="com.eg.*" %>
<%@ page import="com.eg.EgInstallInfo" %>
<%@ page import="com.egurkha.util.*" %>
<%@ page import = "com.egurkha.admin.AuditLogThread"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
%>

<jsp:useBean id="prgBean" scope="page" class="egurkha.EgTestParamBean"/>
<jsp:useBean id="sBean" scope="page" class="egurkha.ServiceBean"/>

<%
	int serverFlag = 0;
	String serverName = request.getParameter("server");
	String strCheck = request.getParameter("t_name");
	String strTok = "";
	StringTokenizer tok = null;
	int tokCount = 0;
	String componentsForInclusion = request.getParameter("ComponentsForInclusion");

	//to remove a test whose server+hostname is excluded in eg_disable.ini
	//prgBean.createFile("eg_disable.ini", "save");
	prgBean.createSyncFile("eg_disable.ini", "save");
	String subTestParam = "Default_server";
	StringTokenizer st = new StringTokenizer(componentsForInclusion,",");
	while (st.hasMoreTokens())
	{
		String finalStr = "";
		String str_host_name = st.nextToken();
		if ((str_host_name.equals("")) || (str_host_name.equals(" ")))
			continue;
		String stringTemp = subTestParam + ":" + str_host_name;
		String strVal = prgBean.getStrValue(subTestParam, stringTemp);

		/* to stop discovery before deleting from eg_disable.ini */
		sBean.stopDiscovery();

		if(strCheck.equals(strVal))
		{
			prgBean.deleteValues(subTestParam,stringTemp);
		}
		else if(strVal.indexOf(strCheck)>=0 && (!strVal.equals("")))
		{
			tok = new StringTokenizer(strVal,",");
			tokCount = tok.countTokens();
			for(int m=0; m<tokCount; m++)
			{
				strTok = (tok.nextToken()).trim();
				if(strTok.equals(strCheck)==false)
				{
					finalStr = finalStr + strTok + ",";
				}
			}
			finalStr = finalStr.substring(0,finalStr.lastIndexOf(","));
			prgBean.setValues(subTestParam,stringTemp,finalStr);
		}
	}
	//Saving The ini File
	prgBean.saveFile();
	prgBean.releaseInstance();
	/* end of code for include button click */

	/* For aggregate test frequency setting starts */
	if(EgInstallInfo.isAggSupported)
	{
		//IniFile  agentIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_agents.ini",true);
		IniFile  agentIni = EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir() + "/manager/config/eg_agents.ini");
		IniFile  specsIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_specs.ini");
		EgDiscInfo discInfo = new EgDiscInfo("manager");
		ArrayList managedComps =  discInfo.getAllManagedNames(true);
		String arr[] = discInfo.getServerTypes();

		boolean hasAggTest = false;
		boolean hasAggServerType = false;
		String aggregateTestName = null;

		String test_name = request.getParameter("t_name");
		String server_type = request.getParameter("server");
		String component_name = request.getParameter("ComponentsForInclusion");

		ArrayList watchServers = new ArrayList();
		ArrayList watchTests = new ArrayList();

		IniFile aggIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_aggregate.ini");
		String allAggServerTypes[] = aggIni.getVariables("COMPONENT_TYPE_MAPPING");

		if(!EgUtils.isNull((Object) allAggServerTypes))
		{
			for(int m=0;m<allAggServerTypes.length;m++)
			{
				String aggregatedServers = aggIni.getValue("COMPONENT_TYPE_MAPPING",allAggServerTypes[m]);
				if(aggregatedServers != null && !aggregatedServers.equals(""))
				{
					StringTokenizer stc = new StringTokenizer(aggregatedServers, ",");
					while(stc.hasMoreTokens())
					{
						String thisToken = stc.nextToken();
						if(thisToken.equals(server_type))
						{
							if(!watchServers.contains(allAggServerTypes[m]))
								watchServers.add(allAggServerTypes[m]);
							hasAggServerType = true;
						}
					}
				}
			}
		}
		String allAggTests[] = aggIni.getVariables("AGGREGATE_TEST");

		if(!EgUtils.isNull((Object) test_name) && !EgUtils.isNull((Object) allAggTests))
		{
			for(int m=0;m<allAggTests.length;m++)
			{
				if(aggIni.getValue("AGGREGATE_TEST",allAggTests[m]).equals(test_name))
				{
					watchTests.add(allAggTests[m]);
					aggregateTestName = allAggTests[m];
					hasAggTest = true;
				}
			}
		}
		if(component_name !=null && test_name != null && hasAggTest && server_type !=null && hasAggServerType)
		{
			EgSpecsInfo egSpecs = new EgSpecsInfo("manager");
			if(component_name.indexOf(":")>0)
				component_name = component_name.substring(0,component_name.indexOf(":"));
			String str = "";
			String [] specsVar = specsIni.getVariables("TEST_SPECIFICATION");
			if(!EgUtils.isNull((Object) specsVar))
			{
				for (int i=0;i<specsVar.length;i++)
				{
					if(specsVar[i].startsWith(test_name+":"+server_type))
					{
						str = specsIni.getValue("TEST_SPECIFICATION", specsVar[i]);
						break;
					}
					else if(specsVar[i].startsWith(test_name+"::"))
					{
						str = specsIni.getValue("TEST_SPECIFICATION", specsVar[i]);
					}
				}
			}
			if(!EgUtils.isNull((Object) str))
			{
				String testFreq = str.substring(str.lastIndexOf(EgConstants.COMMA)+1).trim();
				IniFile  extIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_external.ini");
				String variables[] = aggIni.getVariables("AGGREGATE_COMPONENTS");
				String aggCompName = null;
				String aggNickName = null;

				if(component_name.startsWith(","))
				{
					component_name = component_name.substring(1);
				}

				if(component_name.indexOf(",")>0)
				{
					component_name = component_name.substring(0,component_name.indexOf(","));
				}
				String egComp = server_type + ":" + component_name;
				Vector aggCompWithType = new Vector();
				if(!EgUtils.isNull((Object) variables))
				{
					for(int a=0;a<variables.length;a++)
					{
						String aggCompAndType = variables[a].substring(0,variables[a].indexOf("#"));
						String assoCompAndType = variables[a].substring(variables[a].indexOf("#")+1);
						if(assoCompAndType.startsWith(egComp))
						{
							aggCompWithType.add(aggCompAndType);
						}
					}
					if(!EgUtils.isNull((Object) aggCompWithType))
					{
						for (int b=0;b<aggCompWithType.size();b++)
						{
							String thisName = (String)aggCompWithType.get(b);
							String thisType = thisName.substring(0,thisName.indexOf(":"));
							aggCompName = thisName.substring(thisName.indexOf(":")+1);
							aggNickName = aggCompName.substring(0,aggCompName.indexOf(":"));
							String extAgentName = extIni.getValue("Test_Mapping_Section", aggNickName);
							if(!EgUtils.isNull((Object) extAgentName))
							{
								String[] extAgents = StringUtils.getTokens(extAgentName, ",");
								if(!EgUtils.isNull((Object)extAgents))
								{
									for(int i=0;i<extAgents.length;i++)
									{
										String thisAgent = (String)extAgents[i];
										if(!EgUtils.isNull((Object)thisAgent))
										{
											Iterator itr = watchTests.iterator();
											while(itr.hasNext())
											{
												String variable = "";
												String testParams = "";
												aggregateTestName = (String) itr.next();

												boolean portRel = egSpecs.isPortRelevantForTest(aggregateTestName);
												if(portRel)
												{
													if(thisType.endsWith("_ex"))
														variable = aggregateTestName+":"+thisType+":"+aggCompName;
													else
														variable = aggregateTestName+"::"+aggCompName;
													testParams = agentIni.getValue(thisAgent,variable);
												}
												else
												{
													variable = aggregateTestName+"::"+aggNickName;
													testParams = agentIni.getValue(thisAgent,variable);
												}

												if(testParams==null || testParams.trim().length()==0)
												{
													continue;
												}

												String oldFreq = testParams.substring(testParams.lastIndexOf(EgConstants.COMMA)+1).trim();

												if(Integer.parseInt(oldFreq) < Integer.parseInt(testFreq))
												{
													testParams = "-manual," + testParams.substring(testParams.indexOf(EgConstants.COMMA)+1,testParams.lastIndexOf(EgConstants.COMMA))+", "+testFreq;

												}
												agentIni.setValue(thisAgent,variable,testParams);
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
		agentIni.saveFile();
		EgConfigFilesSync.releaseInstance(agentIni);
	}
	/* For aggregate test frequency setting ends */
	/* to start discovery after deleting from eg_disable.ini */
	String step = "1";
	sBean.startDiscovery(step,true);

	String ur = "EgConfigTest.jsp?t_name="+strCheck+"&qctr=0&rctr=0&typeOfServer=" + serverName;

	/* code for auditlog starts */
	AuditLogThread auditLogThread = new AuditLogThread();
	auditLogThread.setValue("Category","Admin");
	auditLogThread.setValue("User_id",_user.getLoginID());
	auditLogThread.setValue("Host_ip",_user.getUserIP(session.getId()));
	auditLogThread.setValue("Session_id",session.getId());
	auditLogThread.setValue("Module","Tests");
	auditLogThread.setValue("Activity","Test Configuration");

	String t_test = request.getParameter("t_name");
	if(t_test.endsWith("_ex"))
		auditLogThread.setCurrentValue("01~~Test Name",t_test);
	else
		auditLogThread.setCurrentValue("01~~Test Name","$test$:"+t_test);

	String s_server = request.getParameter("server");
	if(s_server.endsWith("_ex"))
		auditLogThread.setCurrentValue("02~~Component Type",s_server);
	else
		auditLogThread.setCurrentValue("02~~Component Type","$ctype$:"+s_server);

	String hostNames = request.getParameter("ComponentsForInclusion");
	String hostNamesArray[] = null;
	if(hostNames != null && !hostNames.equals("null"))
	{
		StringTokenizer tokens = new StringTokenizer(hostNames,",");
		while(tokens.hasMoreTokens())
		{
			String token = tokens.nextToken().toString();
			int index = token.indexOf(":");
			if(index != -1)
				auditLogThread.setCurrentValue("Included Component(s)",token.substring(0,index));
			else
				auditLogThread.setCurrentValue("Included Component(s)",token);
		}
	}
	auditLogThread.setValue("Description","Component(s) have been included for test configuration");
	auditLogThread.sendItToDB();
	/* code for auditlog ends */
%>
	<jsp:forward page="<%=ur%>" />
