<%@ include file = "../../EgTrackerA.jsp" %>
<%@ page import = "java.io.*" %>
<%@ page import = "java.util.*" %>
<%@ page import = "egurkha.*" %>
<%@ page import="com.eg.EgName" %>
<%@ page import = "com.eg.IniFile" %>
<%@ page import = "com.egurkha.ini.IniUI" %>
<%@ page import = "com.egurkha.util.*" %>
<%@ page import="com.eg.MappingNameSorter" %>
<%@ page import = "com.eg.EgRoleInfo" %>
<%@ page import = "com.eg.EgInstallInfo" %>
<%@ page import = "com.egurkha.util.StringUtils" %>
<%@ page import="egurkha.TransactionBean" %>

<%@ taglib prefix="egui" uri="../../../WEB-INF/eg-taglib.tld"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);

	String s_forPdfTitle="";

	String uiFile = "eg_ui.ini";
	String iniFileDir = EgInstallInfo.getInstallDir()+ "/manager/config/";
	IniFile egUI = new IniFile(iniFileDir + uiFile);
	String currentDateFormat = egUI.getValue("CURRENT_DATE_FORMAT","selectedDateFormat");
	Date date = new Date(System.currentTimeMillis());
	String currentDateTime = DateUtil.formatDate(date,currentDateFormat+" HH:mm:ss");

	String formatFile = "eg_format.ini";
	IniFile dddcleanup = new IniFile(iniFileDir + formatFile);
	String[] enabledTests = dddcleanup.getVariables("FORMAT");
	ArrayList aListDDEnabledTests = new ArrayList();
	if (enabledTests != null)
	{
		for (int i=0;i<enabledTests.length;i++)
		{
			String temp = enabledTests[i];
			int idx = temp.indexOf(":");
			String enabledTest = temp.substring(0,idx);

			if (!aListDDEnabledTests.contains(enabledTest))
			{
				aListDDEnabledTests.add(enabledTest);
			}
		}
	}

	String testinfoFile = "eg_testinfo.ini";
	IniFile disabledd = new IniFile(iniFileDir + testinfoFile);
	String disableDDTests[] = disabledd.getVariables("Disable_DD");
	ArrayList aListDDDisabledTests = new ArrayList(Arrays.asList(disableDDTests));
	aListDDEnabledTests.removeAll(aListDDDisabledTests);

	IniFile egSpecsIni = new IniFile(EgInstallInfo.getInstallDir()+"/manager/config/eg_specs.ini");

	ArrayList aListDDD = new ArrayList();
	ArrayList aListResultantCtype = new ArrayList();
	ArrayList aListTempDDDTest = new ArrayList();

	String userLanguage = _user.getLanguage();
	IniUI iniUI = IniUI.getInstance();
	if (userLanguage == null)
	{
		userLanguage = iniUI.getDefaultLanguage();
	}
	MappingNameSorter sorter = new MappingNameSorter(userLanguage);

	String selectedCompType = (String)session.getAttribute("Component_type");
	String egTitleSearchStr = (String)session.getAttribute("egTitleSearchStr");
	String print= (String) request.getParameter("print");

	boolean isSearchResult = (egTitleSearchStr != null && !egTitleSearchStr.equals(""));
	ArrayList searchList = new ArrayList();

	EgRoleInfo ri = EgRoleInfo.getInstance(session.getId(),(String)session.getAttribute("sess_userid"));
	List listComponentTypes = Arrays.asList(ri.getServerTypes());
	
	// To list those component types only which has associated tests with it in eg_format.ini - Rekha
	for(int i=0;i<listComponentTypes.size();i++)
	{
		String strComponentType = (String)listComponentTypes.get(i);
		String strTests = egSpecsIni.getValue("TEST_MAPPING",strComponentType);
		
		if (strTests != null)
		{
			ArrayList aListTempTests = new ArrayList();
			StringTokenizer strTokens = new StringTokenizer(strTests,",");
			while (strTokens.hasMoreTokens())
			{
				String strToken = strTokens.nextToken().trim();
				if (EgInstallInfo.isConfigTest(strToken))
				{
					continue;
				}
				aListTempTests.add(strToken);
			}

			for (int j=0;j<aListTempTests.size();j++)
			{
				String strTest = (String)aListTempTests.get(j);
				if (aListDDEnabledTests != null && 
					!aListDDEnabledTests.contains(strTest)) 
				{
					continue;
				}
				if(!aListResultantCtype.contains(strComponentType))
				{
					aListResultantCtype.add(strComponentType);
				}
				if(!aListTempDDDTest.contains(strTest))
				{
					aListTempDDDTest.add(strTest);
				}
			}
		}
	}
	aListDDD = aListTempDDDTest;
	
	//To List the tests for the selected Componenet Type
	selectedCompType = (!StringUtils.isNull(selectedCompType) && selectedCompType.length()>0 ? selectedCompType:"");
	ArrayList aListShowTests = new ArrayList();
	ArrayList aListTests = new ArrayList();
	List selectedCompList = new ArrayList();
	String selectedCompTypeDispName = "";

	if (!selectedCompType.equals("") && !selectedCompType.equalsIgnoreCase("All"))
	{
		selectedCompList.add(selectedCompType);
		selectedCompList = sorter.getSortedCompTypeList(selectedCompList);

		EgName compNameObj = (EgName)selectedCompList.get(0);
		selectedCompTypeDispName = compNameObj.getLocalName();

		String strTests = egSpecsIni.getValue("TEST_MAPPING",selectedCompType);
		StringTokenizer strTokens = new StringTokenizer(strTests,",");
		while (strTokens.hasMoreTokens())
		{
			String strToken = strTokens.nextToken().trim();
			if (EgInstallInfo.isConfigTest(strToken))
			{
				continue;
			}
			aListTests.add(strToken);
		}
		for (int i=0;i<aListTests.size();i++)
		{
			String strTest = (String)aListTests.get(i);
			if (aListDDEnabledTests != null && !aListDDEnabledTests.contains(strTest)) 
			{
				continue;
			}
			aListShowTests.add(strTest);
		}
		aListDDD = aListShowTests;
	}
	else
	{
		selectedCompTypeDispName = "All";
	}
	
	s_forPdfTitle = _mapping.getTextDescription("admin.db.Generated on")+"&nbsp;"+currentDateTime;
	aListDDD.removeAll(aListDDDisabledTests);
	aListDDD = sorter.getSortedTestList(aListDDD);
	
	// Result Based on Search 
	if (isSearchResult)
	{
		StringTokenizer st = new StringTokenizer(egTitleSearchStr);
		while (st.hasMoreTokens())
		{
			String thisToken = st.nextToken().trim();
			if (thisToken.equals(""))
				continue;
			searchList.add(thisToken);
		}
		ArrayList searchList_final=new ArrayList();
		for (int i=0;i<aListDDD.size();i++)
		{
			EgName nameObj=(EgName)aListDDD.get(i);
			String dddDisplay_test = nameObj.getActualName();
			String label=_mapping.getTestDescription(dddDisplay_test);
			for (int j=0;j<searchList.size();j++)
			{
				String search_String=(String)searchList.get(j);
				if (label != null && label.toLowerCase().indexOf(search_String.toLowerCase()) != -1)
				{
					if (!searchList_final.contains(dddDisplay_test))
					{
						searchList_final.add(dddDisplay_test);
					}
				}
			}
		}
		if (searchList_final != null)
		{
			aListDDD=searchList_final;
		}
		if(aListDDD != null && aListDDD.size() > 0)
		{
			aListDDD = sorter.getSortedTestList(aListDDD);
		}
	}

	String logo=iniUI.getMonitorHomeLogo();
	if(iniUI.isHKTThemeEnabled())
	{
		logo = iniUI.getHKTReporterLogo();
	}

	String dbFile = "eg_db.ini";
	IniFile dbcleanup = new IniFile(iniFileDir + dbFile);
	String ddCleanPeriod = dbcleanup.getValue("MANAGER_SETTINGS","DetailedDiagnosisCleanPeriod");

	HashMap ddTestCleanPeriodMap = new HashMap();
	String[] testVars = dddcleanup.getVariables("DDD_CLEANUP");
	Vector allValues = dddcleanup.getAllValues("DDD_CLEANUP");
	if (testVars != null)
	{
		int testVarsLen = testVars.length;
		for (int i=0; i<testVarsLen; i++)
		{
			String testVar = testVars[i];
			String testVal = (String) allValues.get(i);
			ddTestCleanPeriodMap.put(testVar,testVal);
		}
	}
%>
<html>
<head>
<title>Data Purge Period Report</title>

<%
	if (print!=null && print.equalsIgnoreCase("printpage"))
	{
%>
<link rel="stylesheet" type="text/css" href="/final/styles/eGLightTheme.css" />
<link rel="stylesheet" type="text/css" href="/final/styles/eGLightThemeIcons.css" />
<%
	}
%>
<style>

@media print {body {-webkit-print-color-adjust: exact;}}
table,tr {page-break-inside: auto !important}

body{font-size:11px;line-height:1.5em;color:#2a292a;}
header{font-size:15px;}
.formLabel {font-size:12px;}
.formValue {font-weight:500;font-size:12px;}
b{font-weight:500;font-size:11px;}
table tr td{font-size:11px;padding:4px;}

.printTable{border: 1px solid #c3c3c3; border-collapse: collapse;}
.printTable tr td{border: 1px solid #c3c3c3;}

.printTableHeader{font-weight:500;border: 1px solid #c3c3c3;text-align:center;background-color:#cdcdcd;padding:4px;}

</style>

<script language="JavaScript">
	function printData()
	{
		window.print();
	}
</script>
</head>

<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
<body  style="padding:10px">
<form action="EgPrintPurgePeriodDetails.jsp">

<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0">
	<tr>
		<td>
<%
		{
%>
			<table cellpadding="0" cellspacing="0" border="0" width="100%" align="center">
				<tr>
					<td style="padding:5px 10px 10px 10px"><img src='<%=logo%>' border="0" /></td>
				</tr>
			</table>
<%
		}
%>
			<table width="100%" border="0" cellspacing="0" cellpadding="0" align="center"  style="border-bottom:1px solid #999;">
				<tr>
					<td style="padding:2px">
						<div style="float:left" > <header><egui:intnl text="admin.db.Detailed Diagnosis Data Purge Periods Report"/></header></div>
				
<%
	if (print!=null && print.equalsIgnoreCase("printpage"))
	{
%>
						<div style="float:right"><img class="iconPrinter mouse" src="data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==" border="0" onClick="javascript:printData()" alt='<egui:intnl text="reporter.common.PRINT"/>' title='<egui:intnl text="reporter.common.PRINT"/>'/></div>

<%
	}
%>
					</td>
				</tr>
			</table>
		</td>
	</tr>
	<tr>
		<td>
			<table width="100%" border="0" cellspacing="0" cellpadding="0" align="center" style="border-bottom:1px solid #ccc;">
				<tr>
					<td class="formValue" width="100%" align="center"><%=s_forPdfTitle%></td>
				</tr>
				<tr>
					<td class="eg_blankspace" height="6">&nbsp;</td>
				</tr>
			</table>
		</td>
	</tr>
		<tr>
		<td class="eg_blankspace" height="6">&nbsp;</td>
	</tr>
	<tr>
		<td>
			<table width="100%" border="0" cellspacing="0" cellpadding="0" align="center" style="border-bottom:1px solid #ccc;">
				<tr>
					<td class="formLabel" width="100%" align="center">&nbsp;<egui:intnl text="admin.infrastructure.Component Type"/>&nbsp;:&nbsp;<span class="formValue"><%=selectedCompTypeDispName%></span></td>
				</tr>
			</table>
		</td>
	</tr>

	<tr>
		<td class="eg_blankspace" height="12">&nbsp;</td>
	</tr>

	<tr>
		<td align="center">
			<table cellpadding="0" cellspacing="0" border="0" width="100%" class="printTable"><col width="25%"><col width="25%"><col width="25%"><col width="25%">
<%
	int finalListDDDLength = aListDDD.size();
	if (finalListDDDLength > 1)
	{
%>
				<tr>
					<td class="printTableHeader">Test</td>
					<td class="printTableHeader">Purge Period (In Days)</td>
					<td class="printTableHeader">Test</td>
					<td class="printTableHeader">Purge Period (In Days)</td>
				</tr>
<%
	}
	else if (finalListDDDLength == 1)
	{
%>
				<tr>
					<td class="printTableHeader">Tests</td>
					<td class="printTableHeader">Purge Period(In Days)</td>
				</tr>
<%
	}

	if (finalListDDDLength > 1)
	{
		for (int p=0;p<aListDDD.size();p=p+2)
		{
			EgName name = (EgName)aListDDD.get(p);
			String ddTest = name.getActualName();
			String dddDisplay = name.getLocalName();
			String ddTest2 = "-";
			String dddDisplay1 = "-";
			String testPurgeVal2 = "-";
			String testPurgeVal = (String)ddTestCleanPeriodMap.get(ddTest);
			if (testPurgeVal == null || testPurgeVal.length() == 0)
			{
				testPurgeVal = ddCleanPeriod;
			}
			if((p+1) < aListDDD.size())
			{
				EgName name1 = (EgName)aListDDD.get(p+1);
				ddTest2 = name1.getActualName();
				dddDisplay1 = name1.getLocalName();
				testPurgeVal2 = (String)ddTestCleanPeriodMap.get(ddTest2);
				if (testPurgeVal2 == null || testPurgeVal2.length() == 0)
				{
					testPurgeVal2 = ddCleanPeriod;
				}
			}
%>
				<tr>
					<td><%=dddDisplay%></td>
					<td><%=testPurgeVal%></td>
					<td><%=dddDisplay1%></td>
					<td><%=testPurgeVal2%></td>
				</tr>
<%
		}
	}
	else if (finalListDDDLength == 1)
	{
		EgName name = (EgName)aListDDD.get(0);
		String ddTest = name.getActualName();
		String dddDisplay = name.getLocalName();
		String testPurgeVal = (String)ddTestCleanPeriodMap.get(ddTest);
		if (testPurgeVal == null || testPurgeVal.length() == 0)
		{
			testPurgeVal = ddCleanPeriod;
		}
%>
				<tr>
					<td><%=dddDisplay%></td>
					<td><%=testPurgeVal%></td>
				</tr>
<%
	}
%>
			</table>
		</td>
	</tr>

	<tr>
		<td class="eg_blankspace" height="12">&nbsp;</td>
	</tr>

</table>
</form>
</body>
</html>



