<%
/*******************************************************************************
*		Name				:EgDDDPurgeJSON.jsp
*		Purpose				:To configure Detailed Diagnosis data purge periods.
*		Version				:6.0
*		Created Date		:28/06/2013
*		Modified Date		:28/06/2013
*		Author				:Abdul Khader M
*******************************************************************************/
%>

<%@ include file="../../EgTrackerAJSON.jsp" %>
<%@ page import="com.eg.EgName" %>
<%@ page import = "java.io.*" %>
<%@ page import = "java.util.*" %>
<%@ page import="com.eg.EgInstallInfo" %>
<%@ page import="com.eg.MappingNameSorter" %>
<%@ page import="com.egurkha.ini.IniUI" %>
<%@ page import="com.eg.EgMemInfo" %>
<%@ page import="com.eg.EgSpecsInfo" %>
<%@ page import = "com.eg.EgDiscInfo"%> 
<%@ page import="com.eg.EgRoleInfo" %>
<%@ page import="egurkha.TransactionBean" %>
<%@ page import="net.sf.json.*"%>
<%@ page import = "com.egurkha.util.*" %>
<%@ page import = "egurkha.EgUIUtils" %>

<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>

<%
	response.setContentType("application/json");
	JSONObject rootJson = new JSONObject();
	JSONObject compTypesJson = new JSONObject();
	JSONObject searchJson = new JSONObject();
	JSONArray gridJson = new JSONArray();
	JSONArray componentList = new JSONArray();
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
%>

<%
	String egTitleSearchStr = request.getParameter("egTitleSearchStr");
	egTitleSearchStr = EgUIUtils.decodeSecurityChar(egTitleSearchStr);
	boolean isSearchResult = (egTitleSearchStr != null && !egTitleSearchStr.equals(""));
	ArrayList searchList = new ArrayList();
	boolean searchItemFound = false;
%>
<%!
	String licenseCheck = new String("license");
%>

<%
	IniUI iniUI = IniUI.getInstance();
	String userLanguage = iniUI.getDefaultLanguage();
	if (_user != null)
	{
		userLanguage = _user.getLanguage();
	}

	String uiFile = "eg_ui.ini";
	String iniFileDir = EgInstallInfo.getInstallDir()+ "/manager/config/";
	IniFile egUI = new IniFile(iniFileDir + uiFile);
	String currentDateFormat = egUI.getValue("CURRENT_DATE_FORMAT","selectedDateFormat");
	Date date = new Date(System.currentTimeMillis());
	String currentDateTime = DateUtil.formatDate(date,currentDateFormat+" HH:mm:ss");
	String finalCurrDateTime = currentDateTime;
	if(currentDateTime.indexOf(", ") > -1)
	{
		String dateVal = currentDateTime.substring(0,currentDateTime.indexOf(", "));
		String time = currentDateTime.substring(currentDateTime.indexOf(", ")+1);
		finalCurrDateTime =  dateVal + "" +time;
	}

	List csvList = new LinkedList();
	Vector headingForCSV = new Vector();
	Vector headerForCSV1 = new Vector();

	String componentType = request.getParameter("componentType");
	String testType = request.getParameter("testType");

	componentType = (componentType != null)?componentType:"All";
	MappingNameSorter sorter = new MappingNameSorter(userLanguage);
	session.setAttribute("Component_type",componentType);
	session.setAttribute("egTitleSearchStr",egTitleSearchStr);
	String selectedCompTypeDispName = "";

	List selectedCompList = new ArrayList();
	if(!componentType.equals("") && !componentType.equalsIgnoreCase("All"))
	{
		selectedCompList.add(componentType);
		selectedCompList = sorter.getSortedCompTypeList(selectedCompList);
		EgName compNameObj = (EgName)selectedCompList.get(0);
		selectedCompTypeDispName = compNameObj.getLocalName();
	}
	else
	{
		selectedCompTypeDispName = "All";
	}
	headingForCSV.add("Detailed Diagnosis Data Purge Periods Report");
	csvList.add(headingForCSV);
	csvList.add("Generated on,"+finalCurrDateTime);

	headerForCSV1.add("Component Type,"+selectedCompTypeDispName);
	csvList.add(headerForCSV1);

	ArrayList aListDDDTest = new ArrayList();
	ArrayList aListResultantCtype = new ArrayList();
	ArrayList aListTests = new ArrayList();
	ArrayList aListTempDDDTest = new ArrayList();

	//for pdf work
	String csrfToken = request.getParameter("com.eg.CSRF_NONCE");
	String tmp=(String)request.getQueryString();
	String mngrIProc = new IniFile(new EgConfigInfo("manager").getDbFile()).getValue("DB_PROPERTIES","ManagerUrl");
	String htmlFileName =mngrIProc+"/final/admin/EgDbSettings/data/EgPrintPurgePeriodDetails.jsp;jsessionid="+session.getId()+"?"+tmp+"&print=pdfpage&com.eg.CSRF_NONCE="+csrfToken;
	session.setAttribute("PDF_URL",htmlFileName);
	session.setAttribute("REPORT_NAME","Purge_details");
	session.setAttribute("REPORT_LAYOUT","Portrait");
	session.setAttribute("PAGE_WIDTH_PDF","1100");

	String formatFile = "eg_format.ini";
	IniFile dddcleanup = new IniFile(iniFileDir + formatFile);
	String[] enabledTests = dddcleanup.getVariables("FORMAT");
	ArrayList aListDDEnabledTests = new ArrayList();
	if (enabledTests != null)
	{
		for (int i=0;i<enabledTests.length;i++)
		{
			String temp = enabledTests[i];
			int idx = temp.indexOf(":");
			String enabledTest = temp.substring(0,idx);

			if (!aListDDEnabledTests.contains(enabledTest))
			{
				aListDDEnabledTests.add(enabledTest);
			}
		}
	}

	String testinfoFile = "eg_testinfo.ini";
	IniFile disabledd = new IniFile(iniFileDir + testinfoFile);
	String disableDDTests[] = disabledd.getVariables("Disable_DD");
	ArrayList aListDDDisabledTests = new ArrayList(Arrays.asList(disableDDTests));
	aListDDEnabledTests.removeAll(aListDDDisabledTests);

	EgRoleInfo ri = EgRoleInfo.getInstance(session.getId(),(String)session.getAttribute("sess_userid"));
	List listComponentTypes = Arrays.asList(ri.getServerTypes());

	IniFile egSpecsIni = new IniFile(EgInstallInfo.getInstallDir()+"/manager/config/eg_specs.ini");
	// To list those component types only which has associated tests with it in eg_format.ini - Rekha
	for(int i=0;i<listComponentTypes.size();i++)
	{
		String strComponentType = (String)listComponentTypes.get(i);
		String strTests = egSpecsIni.getValue("TEST_MAPPING",strComponentType);
		
		if (strTests != null)
		{
			ArrayList aListTempTests = new ArrayList();
			StringTokenizer strTokens = new StringTokenizer(strTests,",");
			while (strTokens.hasMoreTokens())
			{
				String strToken = strTokens.nextToken().trim();
				if (EgInstallInfo.isConfigTest(strToken))
				{
					continue;
				}
				aListTempTests.add(strToken);
			}

			for (int j=0;j<aListTempTests.size();j++)
			{
				String strTest = (String)aListTempTests.get(j);
				if (aListDDEnabledTests != null && !aListDDEnabledTests.contains(strTest)) 
				{
					continue;
				}

				if(!aListResultantCtype.contains(strComponentType))
				{
					aListResultantCtype.add(strComponentType);
				}
				if(!aListTempDDDTest.contains(strTest))
				{
					aListTempDDDTest.add(strTest);
				}
			}
		}
	}
	
	aListDDDTest = aListTempDDDTest; // Assigns Clubbed Tests of Managed Comp Types
	listComponentTypes = sorter.getSortedCompTypeList(aListResultantCtype);
	// Ends

	// To list the tests for the selected component type - Rekha
	ArrayList aListShowTests = new ArrayList();
	if (!componentType.equals("") && !componentType.equalsIgnoreCase("All"))
	{
		String strTests = egSpecsIni.getValue("TEST_MAPPING",componentType);
		StringTokenizer strTokens = new StringTokenizer(strTests,",");
		while (strTokens.hasMoreTokens())
		{
			String strToken = strTokens.nextToken().trim();
			if (EgInstallInfo.isConfigTest(strToken))
			{
				continue;
			}
			aListTests.add(strToken);
		}
		for (int i=0;i<aListTests.size();i++)
		{
			String strTest = (String)aListTests.get(i);
			if (aListDDEnabledTests != null && 
				!aListDDEnabledTests.contains(strTest)) 
			{
				continue;
			}
			aListShowTests.add(strTest);
		}
		aListDDDTest = aListShowTests;
		rootJson.put("aListDDDTestForComp",aListDDDTest);
	}
	// Ends
		
	// Added for search button - Rekha
	if (isSearchResult)
	{
		StringTokenizer st = new StringTokenizer(egTitleSearchStr);
		while (st.hasMoreTokens())
		{
			String thisToken = st.nextToken().trim();
			if (thisToken.equals(""))
				continue;
			searchList.add(thisToken);
		}
		ArrayList searchList_final=new ArrayList();
		for (int i=0;i<aListDDDTest.size();i++)
		{
			String dddDisplay_test=(String)aListDDDTest.get(i);
			String label=_mapping.getTestDescription(dddDisplay_test);
			for (int j=0;j<searchList.size();j++)
			{
				String search_String=(String)searchList.get(j);
				if (label != null && label.toLowerCase().indexOf(search_String.toLowerCase()) != -1)
				{
					if (!searchList_final.contains(dddDisplay_test))
					{
						searchList_final.add(dddDisplay_test);
					}
				}
			}
		}
		if (searchList_final != null && searchList_final.size() > 0)
		{
			aListDDDTest=searchList_final;
			searchItemFound = true;
		}
		else
		{
			searchItemFound = false;
		}
	}
	// Ends

	aListDDDTest = sorter.getSortedTestList(aListDDDTest);

	boolean ddEnabled = false;
	synchronized(licenseCheck)
	{
		ddEnabled = EgMemInfo.ddEnabled;
	}
	rootJson.put("aListTest",aListDDDTest);
	rootJson.put("listComponentTypes",listComponentTypes);
%>
<%
	JSONObject jObj = new JSONObject();
	jObj.put("displayField","All");
	jObj.put("valueField","All");
	componentList.add(jObj);
	for (int j=0; j<listComponentTypes.size(); j++)
	{
		JSONObject jObjOne = new JSONObject();
		EgName nameObj = (EgName)listComponentTypes.get(j);
		String actualname = nameObj.getActualName();
		String localname = nameObj.getLocalName();
		jObjOne.put("displayField",localname);
		jObjOne.put("valueField",actualname);
		componentList.add(jObjOne);
	}
%>
<%
	if (aListDDDTest != null && aListDDDTest.size() != 0)
	{
		String dbFile = "eg_db.ini";
		IniFile dbcleanup = new IniFile(iniFileDir + dbFile);
		String ddCleanPeriod = dbcleanup.getValue("MANAGER_SETTINGS","DetailedDiagnosisCleanPeriod");

		HashMap ddTestCleanPeriodMap = new HashMap();
		String[] testVars = dddcleanup.getVariables("DDD_CLEANUP");
		Vector allValues = dddcleanup.getAllValues("DDD_CLEANUP");
		if (testVars != null)
		{
			int testVarsLen = testVars.length;
			for (int i=0; i<testVarsLen; i++)
			{
				String testVar = testVars[i];
				String testVal = (String) allValues.get(i);
				ddTestCleanPeriodMap.put(testVar,testVal);
			}
		}

		csvList.add("Test,Purge Period (In Days)");
		int aListDDDTestSize = aListDDDTest.size();
		for (int j=0;j<aListDDDTestSize;j++)
		{
			JSONObject jObjMeasure = new JSONObject();
			EgName name = (EgName)aListDDDTest.get(j);
			String dddValue = name.getActualName();
			String dddDisplay = name.getLocalName();
			String strVal = (String)ddTestCleanPeriodMap.get(dddValue);
			if (strVal == null || strVal.length() == 0)
			{
				strVal = ddCleanPeriod;
			}
			int newStrVal = Integer.parseInt(strVal);
			jObjMeasure.put("Test",dddDisplay);
			jObjMeasure.put("purgePeriod",newStrVal);
			gridJson.add(jObjMeasure);
			String csvData = dddDisplay+","+strVal;
			csvList.add(csvData);
		}
	}
	session.setAttribute("list",csvList);

	if (!searchItemFound && egTitleSearchStr != null && !egTitleSearchStr.equals(""))
	{
		searchJson.put("Test","No Search Data Found");
	}
	else
	{
		searchJson.put("Test","Search Data Found");
	}
%>
<%
	if (request.getQueryString() != null)
	{
		session.setAttribute("adminLastAccessedURL","/final/admin/EgDbSettings.jsp?"+request.getQueryString());
	}
	else
	{
		session.setAttribute("adminLastAccessedURL","/final/admin/EgDbSettings.jsp");
	}
	rootJson.put("searchJson",searchJson);
	rootJson.put("gridJson",gridJson);
	rootJson.put("componentList",componentList);
	rootJson.put("testType",testType);
	out.println(rootJson);
%>



