<%
/*
 *   File		:	EgConfigureDefaultTestParamsp.jsp
 *   Purpose	:	Processing page for default test configuration
 *   Author		:	S.Anand (2009)
*/
%>

<%@ include file="../../EgTrackerAJSON.jsp" %>
<%@ page import="java.util.*" %>
<%@ page import = "com.eg.EgSpecsInfo" %>
<%@ page import="java.net.URLEncoder" %>
<%@ page import="com.eg.EgUtils" %>
<%@ page import = "com.egurkha.util.*" %>
<%@ page import="com.eg.EgCrypt" %>
<%@ page import="com.eg.EgServicesInfo" %>
<%@ page import = "com.egurkha.admin.AuditLogThread"%>
<%@ page import="com.eg.EgURLEncoder"%>
<%@ page import = "com.eg.EgConfigFilesSync"%>
<%@ page import = "com.eg.IniHelper"%>
<%@ page import="com.eg.EgConfigInfo"%>
<%@ page import="net.sf.json.*"%>
<%@ page import= "egurkha.EgUIUtils"%>
<%@ page language="java" contentType="application/json; charset=UTF-8" pageEncoding="UTF-8" %>

<jsp:useBean id="prgBean" scope="page" class="egurkha.EgTestParamBean"/>
<jsp:useBean id="servicer" scope="request" class="egurkha.ServiceBean"/>

<%!

	String eventTests[] = {"UserEnviron2008Test","SecurityLogTest","ADAMEvtLogTest","FRSEvtLogTest","DSEvtLogTest","DNSEvtTest","VsEvtLogTest","SystemEvtLogTest","AppEvtLogTest","SystemEvtTest","AppEvtTest","CustEvtLogTest"};


	//param to be continued for snmpV1 and snmpV2
	String[] snmpV1V2ParamToContinue = {"username","authpass","authtype","encryptflag","encrypttype","encryptpassword"};

	EgSpecsInfo egSpecs = new EgSpecsInfo("manager");
	EgServicesInfo egserInfo = new EgServicesInfo("manager");

	public boolean isNumber(String s_number)
	{
		try 
		{
			Long.parseLong(s_number);
		} 
		catch (NumberFormatException e)
		{
			return false;
		}
		return true;
	}
	
	public ArrayList getArrayList(String strValue,String delimiter)
	{
		ArrayList aL = new ArrayList();
		StringTokenizer stTempTokens = new StringTokenizer(strValue,delimiter);
		while (stTempTokens.hasMoreTokens())
		{
			String str = stTempTokens.nextToken().trim();
			aL.add(str);
		}
		return aL;
	}

	public boolean isParameter(String encryptParam)
	{
		String decryptParam = encryptParam;
		if (!isNumber(decryptParam))
		{
			decryptParam = EgCrypt.decrypt(decryptParam);
		}		
		if (decryptParam.equals(encryptParam)) // not password
		{
			return (true);
		}
		return false;
	}

	private ArrayList getParameterList(String str,boolean needLowerCaseKey)
	{
		String delimiter = " -";
		ArrayList aListResultant = new ArrayList();
		String prevKey = "";

		str = str.substring(str.indexOf("-"));
		int spaceHyphenIdx = str.indexOf(delimiter);
		while (spaceHyphenIdx != -1)
		{
			String cutString = str.substring(0,spaceHyphenIdx);

			//This check will be carried out when the cutString contains only the key
			//for e.g.:-
			//str : -admin_password -103:98:88:90:79:76:81:-110:52 -ssl false
			//cutString : -admin_password
			if (cutString.trim().indexOf(" ") == -1)
			{
				String strPart1 = str.substring(cutString.length()+1);
				String strPart2 = strPart1.substring(0,strPart1.indexOf(delimiter));
				cutString = cutString+" "+strPart2;
				spaceHyphenIdx = cutString.length();
			}

			if (cutString.indexOf("\"") != -1)
			{
				String strAfterDoubleQuotes = str.substring(spaceHyphenIdx);
				String remainingPiece = strAfterDoubleQuotes.substring(0,strAfterDoubleQuotes.indexOf("\"")+1);
				cutString = cutString + remainingPiece;

				String key = cutString.substring(0,cutString.indexOf(" "));
				String value = cutString.substring(cutString.indexOf(" ")+1);
				if (needLowerCaseKey)
				{
					aListResultant.add(key.trim().toLowerCase());
				}
				else
				{
					aListResultant.add(key.trim());
				}
				aListResultant.add(value.trim());

				String remainingString = strAfterDoubleQuotes.substring(strAfterDoubleQuotes.indexOf("\"")+1);
				str = remainingString.trim();
				if (str.length() == 0)
				{
					spaceHyphenIdx = -1;
				}
				else
				{
					spaceHyphenIdx = str.indexOf(delimiter);
				}
			}
			else
			{
				if (cutString.startsWith("- "))
				{
					int idx = aListResultant.indexOf(prevKey);
					String strValue = (String)aListResultant.get(idx+1);
					strValue = strValue + " " + cutString;
					aListResultant.remove(idx+1);
					aListResultant.add(strValue);

					str = str.substring(cutString.length()+1);
				}
				else
				{
					String key = cutString.substring(0,cutString.indexOf(" "));
					String value = cutString.substring(cutString.indexOf(" ")+1);
					if (needLowerCaseKey)
					{
						aListResultant.add(key.trim().toLowerCase());
						prevKey = key.trim().toLowerCase();
					}
					else
					{
						aListResultant.add(key.trim());
						prevKey = key.trim();
					}
					aListResultant.add(value.trim());

					str = str.substring(spaceHyphenIdx+1);
				}
				spaceHyphenIdx = str.indexOf(delimiter);
			}
		}

		if (str.length() > 0)
		{
			if (str.startsWith("- "))
			{
				int idx = aListResultant.indexOf(prevKey);
				String strValue = (String)aListResultant.get(idx+1);
				strValue = strValue + " " + str;
				aListResultant.remove(idx+1);
				aListResultant.add(strValue);
			}
			else
			{
				String lastKey = str.substring(0,str.indexOf(" "));
				String lastValue = str.substring(str.indexOf(" ")+1);
				if (needLowerCaseKey)
				{
					aListResultant.add(lastKey.trim().toLowerCase());
				}
				else
				{
					aListResultant.add(lastKey.trim());
				}
				aListResultant.add(lastValue.trim());
			}
		}

		return aListResultant;
	}

	public ArrayList updateOtherUnconfiguredParamValues (ArrayList aListProcessedParamNamesAndValues)
	{
		// For handling -measure_mode changes in JvmMemPoolGCTest 
		boolean isLogFile = (aListProcessedParamNamesAndValues.contains("-JREHome") && 
						aListProcessedParamNamesAndValues.contains("-LogFileName"));

		boolean isMeasureModeParamExist = (isLogFile && 
								aListProcessedParamNamesAndValues.contains("-measure_mode") && 
								aListProcessedParamNamesAndValues.contains("-Jmx_Remote_Port"));

		if (isMeasureModeParamExist)
		{
			int modeIdx = aListProcessedParamNamesAndValues.indexOf("-measure_mode");
			String modeValue = (String) aListProcessedParamNamesAndValues.get(modeIdx + 1);
			if (modeValue.equalsIgnoreCase("true"))
			{
				int paramIdx = aListProcessedParamNamesAndValues.indexOf("-Jmx_Remote_Port");
				String jmx_remote_port_value = (String) aListProcessedParamNamesAndValues.get(paramIdx + 1);
				if (jmx_remote_port_value != null && jmx_remote_port_value.equalsIgnoreCase("$unconfigured"))
				{
					aListProcessedParamNamesAndValues.set(paramIdx + 1, "none");
				}
			}
			else
			{
				int param1Idx = aListProcessedParamNamesAndValues.indexOf("-JREHome");
				int param2Idx = aListProcessedParamNamesAndValues.indexOf("-LogFileName");
				String jreHome_value = (String) aListProcessedParamNamesAndValues.get(param1Idx + 1);
				String logFile_value = (String) aListProcessedParamNamesAndValues.get(param2Idx + 1);
				if (jreHome_value != null && jreHome_value.equalsIgnoreCase("$unconfigured"))
				{
					aListProcessedParamNamesAndValues.set(param1Idx + 1, "none");
				}
				if (logFile_value != null && logFile_value.equalsIgnoreCase("$unconfigured"))
				{
					aListProcessedParamNamesAndValues.set(param2Idx + 1, "none");
				}
			}
		}
		return aListProcessedParamNamesAndValues;
	}

%>

<%
	try
	{
		JSONObject rootJson = new JSONObject();
		//code for auditlog  - starts 
		boolean isAuditLogEnabled = egserInfo.isAuditlogEnabled();
		AuditLogThread auditLogThread = null;
		StringBuffer strAuditBuffer = null;
		ArrayList aListAuditCurrentSettingParams = null;
		ArrayList aListAuditPreviousSettingParams = null;
		String tempHost = null;
		ArrayList aListTempParamNamesAndValues = null;
		String oldTestPeriodValue = null;
		if (isAuditLogEnabled)
		{
			auditLogThread = new AuditLogThread();
			auditLogThread.setValue("Category","Admin");
			auditLogThread.setValue("User_id",_user.getLoginID());
			auditLogThread.setValue("Host_ip",_user.getUserIP(session.getId()));
			auditLogThread.setValue("Session_id",session.getId());
			auditLogThread.setValue("Module","Default Test Configuration");
			auditLogThread.setValue("Activity","Configure Test");

			strAuditBuffer = new StringBuffer();
			aListAuditCurrentSettingParams = new ArrayList();
			aListAuditPreviousSettingParams = new ArrayList();
			aListTempParamNamesAndValues = new ArrayList();
			tempHost = "";
		}
		//code for auditlog  - ends
		ArrayList credentials = new ArrayList();
		Arrays.sort(snmpV1V2ParamToContinue, String.CASE_INSENSITIVE_ORDER);

		String componentType = request.getParameter("componentType");
		String testName = request.getParameter("testName");
		String query = "";
		//This list will contain user updated parameter name and values
		ArrayList aListTemp = new ArrayList();

		ArrayList aListDisplayParamNamesAndValues = new ArrayList();

		//variables declared for config file sync - starts
		ArrayList aListSpecsIniEntries = new ArrayList();
		ArrayList aListServicesIniEntries = null;
		ArrayList aListPwdProfIniEntries = null;
		//variables declared for config file sync - ends

		Hashtable hashTestsAndDelimiters = new Hashtable();

		//contains tests having '#' as delimiter - starts
		String testNameDelimiter[] = egSpecs.getTestInfosWithDelimiters();
		ArrayList aListTestsWithDelimiterHash = new ArrayList();
		for (int i=0; i<testNameDelimiter.length; i++)
		{
			String delimiter = egSpecs.getTestInfoDelimiter(testNameDelimiter[i]);
			if (delimiter.equals("#"))
			{
				if (!aListTestsWithDelimiterHash.contains(testNameDelimiter[i]))
				{
					aListTestsWithDelimiterHash.add(testNameDelimiter[i]);
				}
			}
			hashTestsAndDelimiters.put(testNameDelimiter[i].trim(),delimiter);
		}
		boolean isHashDelimiter = aListTestsWithDelimiterHash.contains(testName);
		//contains tests having '#' as delimiter - ends

		Hashtable hashDelimitersAndMasks = new Hashtable();
		IniFile testsIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_tests.ini");
		String strDelimiters[] = testsIni.getVariables("TEST_INFO_DELIMITER_MASK");
		for (int m=0;m<strDelimiters.length;m++)
		{
			String strDelimiterTemp = strDelimiters[m];
			String strMaskTemp = testsIni.getValue("TEST_INFO_DELIMITER_MASK",strDelimiterTemp);
			hashDelimitersAndMasks.put(strDelimiterTemp,strMaskTemp);
		}


		// Event log tests - starts
		ArrayList aListEventTests = new ArrayList(Arrays.asList(eventTests));
		String strEvtTests[] = testsIni.getVariables("EVENTLOG_POLICIES");

		if (strEvtTests != null && strEvtTests.length > 0)
		{
			for (int e=0;e<strEvtTests.length;e++)
			{
				String strEvtTestVar = strEvtTests[e];
				if (!com.egurkha.util.StringUtils.isNull(strEvtTestVar) && strEvtTestVar.indexOf(":") != -1)
				{
					String strEvtTest = strEvtTestVar.substring(0,strEvtTestVar.indexOf(":"));
					if (!aListEventTests.contains(strEvtTest))
					{
						aListEventTests.add(strEvtTest);
					}
				}
			}
		}
		// Event log tests - ends

		String strDelimiter = "";
		String strMask = "";
		boolean b_testWithDelimiter = hashTestsAndDelimiters.containsKey(testName.trim());
		boolean b_delimiterWithMask = false;
		if (b_testWithDelimiter)
		{
			strDelimiter = (String)hashTestsAndDelimiters.get(testName);
		}

		ArrayList aListPasswordParameters = (ArrayList)session.getAttribute("aListPasswordParameters");
		boolean hasPasswordParameters = false;
		if (aListPasswordParameters != null)
		{
			hasPasswordParameters = true;
		}

		boolean isOldSnmp = false;
		Boolean isOldSnmpObj = (Boolean)session.getAttribute("isOldSnmp");
		if (isOldSnmpObj != null)
		{
			isOldSnmp = isOldSnmpObj.booleanValue();
		}

		ArrayList aListDefaultPasswordParameters = (ArrayList)session.getAttribute("aListDefaultPasswordParameters");
		boolean hasDefaultPasswordParameter = false;
		if (aListDefaultPasswordParameters != null)
		{
			hasDefaultPasswordParameter = true;
		}

		ArrayList aListParamsWithDoubleQuotes = (ArrayList)session.getAttribute("aListParamsWithDoubleQuotes");
		if (aListParamsWithDoubleQuotes == null)
		{
			aListParamsWithDoubleQuotes = new ArrayList();
		}

		// for bug id - 14020
		String strEvtLogSub = "EVENTLOG_POLICIES";
		String strEvtlogPolicies[] = testsIni.getVariables(strEvtLogSub);
		ArrayList specificTestsEventLogPolicyList = new ArrayList();
		if (strEvtlogPolicies != null)
		{
			for (int i=0;i<strEvtlogPolicies.length;i++)
			{
				String strPolicyVar = strEvtlogPolicies[i];
				if (!com.egurkha.util.StringUtils.isNull(strPolicyVar) && strPolicyVar.startsWith(testName.trim()))
				{
					specificTestsEventLogPolicyList.add(strPolicyVar);
				}
			}
		}
		// for bug id - 14020

		String strFilterType = request.getParameter("selectedFilterType");
		JSONArray encodeParamList = new JSONArray();
		if(session.getAttribute("encodeParamJsonList") != null)
		{
			encodeParamList = (JSONArray)session.getAttribute("encodeParamJsonList");
		}
		Enumeration e = request.getParameterNames();
		testName = testName.trim();
		while (e.hasMoreElements())
		{
			String strParamName = (String)e.nextElement();
			b_delimiterWithMask = hashDelimitersAndMasks.containsKey(testName+":"+strParamName+":"+strDelimiter);
			if (b_delimiterWithMask)
			{
				strMask = (String)hashDelimitersAndMasks.get(testName+":"+strParamName+":"+strDelimiter);
			}
			String strParamValue = request.getParameter(strParamName);
			if(encodeParamList != null && encodeParamList.contains(strParamName))
			{
				strParamValue = EgUIUtils.decodeSecurityChar(strParamValue);
			}

			if (strParamName.equalsIgnoreCase("log_format"))
			{
				strParamValue = EgCrypt.encrypt(strParamValue);
			}
			boolean isPasswordParameter = false;
			boolean allowToTrim = true;
			if (hasPasswordParameters)
			{
				if (aListPasswordParameters.contains("-"+strParamName))
				{
					isPasswordParameter = true;
					allowToTrim = false;
				}
			}

			if (strParamName.equalsIgnoreCase("monitor_url_post_data"))
			{
				strParamValue = EgCrypt.encrypt(strParamValue);
			}

			if (strParamValue.indexOf(" -") > -1 || aListParamsWithDoubleQuotes.contains(strParamName.toLowerCase()))
			{
				if (!strParamValue.startsWith("\"") && !strParamValue.endsWith("\""))
				{
					strParamValue = "\"" + strParamValue + "\"";
					allowToTrim = false;
				}
			}
			//a line feed ('\n') or enter key
			while(strParamValue.indexOf("\n") > -1)
			{
				int idx = strParamValue.indexOf("\n");
				String strPrefix = strParamValue.substring(0,idx);
				String strSuffix = strParamValue.substring(idx+1,strParamValue.length());
				strSuffix = strSuffix.trim();
				strParamValue = strPrefix + strSuffix;
			}

			if (strParamName.equalsIgnoreCase("management_server_text"))
			{
				strParamName = "management_server";
			}

			//special case - if the user selects multiple value for filter
			if (strParamName.equalsIgnoreCase("filter") || strParamName.equalsIgnoreCase("filter_combo"))
			{
				String[] filterValue = null;
				if  (!StringUtils.isNull(strFilterType) && strFilterType.equals("combo")) 
				{
					strParamName = "filter";
					filterValue = request.getParameterValues("filter_combo");

					ArrayList aListFilterList = new ArrayList();
					ArrayList tmpFilterList = new ArrayList(Arrays.asList(filterValue));
					if (tmpFilterList != null && tmpFilterList.size() > 0)
					{
						for (int t=0;t<tmpFilterList.size();t++)
						{
							String strFilterData = (String) tmpFilterList.get(t);
							if (!StringUtils.isNull(strFilterData) && strFilterData.indexOf(",") != -1)
							{
								ArrayList newFilterList = StringUtils.egTokenizer(strFilterData,",");
								aListFilterList.addAll(newFilterList);
							}
							else
							{
								aListFilterList.add(strFilterData);
							}
						}
					}

					// for [EVENTLOG_POLICIES] entry in eg_tests.ini bug id- 14020 starts... 
					Hashtable resultPolicy = new Hashtable();
					String strLogType = request.getParameter("logType");
					boolean isExistPolicy = false;
					if (aListFilterList != null && !aListFilterList.isEmpty())
					{
						if (!aListFilterList.contains("all"))
						{
							aListFilterList.add("all");
						}

						for (int pol=0;pol<aListFilterList.size();pol++)
						{
							String strPolicy = (String) aListFilterList.get(pol);
							String vardecal=testName.trim()+":"+strLogType.toLowerCase()+":"+strPolicy;
							if (specificTestsEventLogPolicyList != null && !specificTestsEventLogPolicyList.isEmpty())
							{
								for (int j=0;j<specificTestsEventLogPolicyList.size();j++)
								{
									String strCorrectVariable = (String) specificTestsEventLogPolicyList.get(j);
									if (!com.egurkha.util.StringUtils.isNull(strCorrectVariable))
									{
										if(strCorrectVariable.equalsIgnoreCase(vardecal))
										{
											vardecal= strCorrectVariable;
											break;
										}

										if (strCorrectVariable.endsWith(strPolicy))
										{
											String assignValue = testsIni.getValue(strEvtLogSub,strCorrectVariable);
											resultPolicy.put(vardecal,assignValue);
										}
									}
								}
							}
						}
					}

					if (resultPolicy != null && resultPolicy.size() > 0)
					{
						ArrayList resultPolicyList = new ArrayList();
						Iterator keyIt = resultPolicy.entrySet().iterator();
						while(keyIt.hasNext())
						{
							Map.Entry entry =  (Map.Entry) keyIt.next();
							resultPolicyList.add((String) entry.getKey());
						}

						IniFile egTestsIni = EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir() + "/manager/config/eg_tests.ini");
						for (int r=0;r<resultPolicyList.size();r++)
						{
							String strEvtPolVar = (String) resultPolicyList.get(r);
							String strEvtPolVal = (String) resultPolicy.get(strEvtPolVar);
							egTestsIni.setValue(strEvtLogSub,strEvtPolVar,strEvtPolVal);
						}
						egTestsIni.saveFile();
						EgConfigFilesSync.releaseInstance(egTestsIni);
					}
					// for [EVENTLOG_POLICIES] entry in eg_tests.ini bug id- 14020 ends... 
				}
				else
				{
					filterValue = request.getParameterValues("filter");
				}
				ArrayList aListFilterValue = new ArrayList(Arrays.asList(filterValue));
				strParamValue = aListFilterValue.toString();
				strParamValue = strParamValue.substring(1,strParamValue.length()-1);
				if (strParamValue.indexOf(",") > -1)
				{
					if (strParamValue.indexOf(";") == -1)
					{
						if (strParamValue.indexOf(":") > -1)
						{
							strParamValue = StringUtils.replace(strParamValue,",","|");
						}
						else
						{
							strParamValue = StringUtils.replace(strParamValue,",",";");
							//strParamValue = StringUtils.replace(strParamValue," ","");
						}
					}
					else
					{
						strParamValue = StringUtils.replace(strParamValue,",","|");
					}
				}
			}
			else if (strParamName.equalsIgnoreCase("pageTypesToBeincludedindashboard"))
			{
				String[] filterValue = request.getParameterValues(strParamName);
				
				ArrayList aListFilterValue = new ArrayList(Arrays.asList(filterValue));
				strParamValue = aListFilterValue.toString();
				strParamValue = strParamValue.substring(1,strParamValue.length()-1);
				if (strParamValue == null || strParamValue.length() <= 0) 
				{
					strParamValue = "None";
				}
				if (strParamValue.indexOf(",") > -1)
				{
					if (strParamValue.indexOf(";") == -1)
					{
						if (strParamValue.indexOf(":") > -1)
						{
							strParamValue = StringUtils.replace(strParamValue,",","|");
						}
						else
						{
							strParamValue = StringUtils.replace(strParamValue,",",";");
							strParamValue = StringUtils.replace(strParamValue," ","");
						}
					}
					else
					{
						strParamValue = StringUtils.replace(strParamValue,",","|");
					}
				}
			}
			else if (strParamName.equalsIgnoreCase("Target_DiskIO_Rate"))
			{
				String targetDiskIORate_select = request.getParameter("TargetDiskIORate_select");
				String targetDiskIORate = request.getParameter("Target_DiskIO_Rate");
				strParamValue = targetDiskIORate_select + "_" + targetDiskIORate;
			}
			else if (strParamName.equalsIgnoreCase("executiontime") && 
				request.getParameter("minutes") != null && 
				request.getParameter("hours") != null)
			{
				strParamValue = request.getParameter("hours") + ":" + request.getParameter("minutes");
			}
			else if (b_testWithDelimiter && strParamValue.indexOf(strDelimiter) != -1 && b_delimiterWithMask)
			{
				strParamValue = StringUtils.replace(strParamValue,strDelimiter,strMask);
			}
			else if(strParamName.equalsIgnoreCase("url"))
			{
				if (testName.equals("HttpTest") ||
				testName.equals("HttpPostTest") ||
				testName.equals("SMHttpTest") ||
				testName.equals("AzureWebAcsTest") ||
				testName.equals("AlibabaHttpTest") ||
				testName.equals("AWSHttpTest") ||
				testName.equals("AzrWVDAcsTest") ||
				testName.equals("vCloudHttpTest") ||
				testName.equals("DownSpeedTest"))
				{
					strParamValue = request.getParameter("hiddenURLs");
				}
			}
			aListTemp.add("-"+strParamName);
			if (allowToTrim)
			{
				strParamValue = strParamValue.trim();
			}
			aListTemp.add(strParamValue);
		}

		ArrayList aListEnabledTestForCompType = null;
		//tells whether _cf test is enabled or not
		boolean isConfigSupported = EgInstallInfo.isConfigSupported;

		//ensure whether the user is configuration management enabled
		if (_user != null && isConfigSupported)
		{
			EgUserRole userRole = _user.getUserRole();
			isConfigSupported = userRole.hasAnyConfigRole(EgUserPermission.CONFIG);
		}

		if (isConfigSupported)
		{
			aListEnabledTestForCompType = egSpecs.getEnabledTests(componentType,false);
			aListEnabledTestForCompType.addAll(egSpecs.getEnabledTests(componentType,true));
		}
		else
		{
			aListEnabledTestForCompType = egSpecs.getEnabledTests(componentType,false);
		}
		//code to get test relations from eg_testparam.ini starts here
		prgBean.createFile("eg_testparam.ini");
		String testRelationVariables[] = prgBean.getVariables("TEST_RELATIONS");
		String testRelation = prgBean.getStrValue("TEST_RELATIONS",testName);
		ArrayList aListRelationTests = new ArrayList();
		ArrayList aListConfigurableTest = new ArrayList();
		if (!testRelation.equals("") && testRelation.length() > 0)
		{
			aListRelationTests.add(testName);
			aListRelationTests.addAll(getArrayList(testRelation,","));
		}
		else if (testRelation.equals("") && testRelation.length() == 0)
		{
			aListRelationTests.add(testName);
		}

		if (aListEnabledTestForCompType != null)
		{
			for(int k=0;k<aListRelationTests.size();k++)
			{
				String strTestName = (String)aListRelationTests.get(k);
				if (aListEnabledTestForCompType.contains(strTestName))
				{
					aListConfigurableTest.add(strTestName);
				}
			}
		}

		String commonTestRelationVariables[] = prgBean.getVariables("COMMON_TEST_RELATIONS");
		ArrayList aListCommonTestRelationVariables = new ArrayList();
		for (int i=0;i<commonTestRelationVariables.length;i++)
		{
			String eachVariable = commonTestRelationVariables[i];
			ArrayList aListTempVariable = getArrayList(eachVariable,",");
			if (aListTempVariable.contains(testName))
			{
				aListCommonTestRelationVariables.addAll(aListTempVariable);
				break;
			}
		}

		String port = "";
		if (componentType.equals("Oracle_server"))
		{
			port = "$portNo:$sid";
		}
		else
		{
			port = "$portNo";
		}

		//The following line is to ensure that the stopDiscovery & startDiscovery runs inside a sync block
		IniFile infraIni = EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir() + "/manager/config/eg_infrastructure.ini");
		//stopping discovery before writing to eg_specs
		servicer.stopDiscovery();

		// eg_agents.ini update for vc changes code starts here...

		boolean configureEsxVdi = (aListTemp != null && aListTemp.contains("-virtual_center")) ? true:false;
		boolean configureAcroVdi = (aListTemp != null && aListTemp.contains("-Prism_IP")) ? true:false;
		boolean isAnyOneChanged = false;
		String ipAddress = "";
		String subVal = "";
		ArrayList updatedEsxList = new ArrayList();
		ArrayList typeList = new ArrayList();
		String componentTypeEsx = "";

		if (configureEsxVdi)
		{
			Hashtable resultTable = getVcUpdatedDetails(aListTemp);

			if (resultTable != null && !resultTable.isEmpty())
			{
				isAnyOneChanged = ((Boolean) resultTable.get("isAnyOneChanged")).booleanValue();
				ipAddress = (String) resultTable.get("ipAddress");
				subVal = (String) resultTable.get("pattern");

				typeList.add("VmEsx_i_server");
				typeList.add("VmVdi_i_server");
				componentTypeEsx = "virtualcenter";
			}
		}
		else if (configureAcroVdi)
		{
			Hashtable resultTable = getNutanixUpdatedDetails(aListTemp);

			if (resultTable != null && !resultTable.isEmpty())
			{
				isAnyOneChanged = ((Boolean) resultTable.get("isAnyOneChanged")).booleanValue();
				ipAddress = (String) resultTable.get("ipAddress");
				subVal = (String) resultTable.get("pattern");

				typeList.add("VmEsx_i_server");
				typeList.add("VmVdi_i_server");
				componentTypeEsx = "virtualcenter";
			}
		}

		//if(from.startsWith("hmc"))
		//{
			//typeList.add("hmc_server");
			//typeList.add("pSeries_server");
		//}

		if(configureAcroVdi)
		{
			componentTypeEsx = "nutanix";
			typeList.add("Nutanix_Acropolis");
			typeList.add("Nutanix_Acropolis_Vdi");
		}
		else if (configureEsxVdi)
		{
			componentTypeEsx = "virtualcenter";
			typeList.add("VmEsx_i_server");
			typeList.add("VmVdi_i_server");
		}

		if (isAnyOneChanged) //this condition checks any one of the value is changed to update eg_agents.ini...
		{
			EgRoleInfo ri = EgRoleInfo.getInstance(session.getId(),(String)session.getAttribute("sess_userid"));
			String[] manageTypes = ri.getServerTypes();
			ArrayList getmanageTypeList = new ArrayList();
			if (manageTypes != null && manageTypes.length >0)
			{
				for(int m=0; m<manageTypes.length; m++)
				{
					String strType = manageTypes[m];
					if (typeList != null && typeList.contains(strType))
					{
						if (!com.egurkha.util.StringUtils.isNull(strType) && !strType.equalsIgnoreCase("Virtual_center"))
						{
							getmanageTypeList.add(strType);
						}
					}
				}
			}
			updateAgentsValues(getmanageTypeList,ipAddress,subVal,componentTypeEsx,updatedEsxList,ri);
		}

		IniFile pwdProfIniSync = new IniFile(EgConfigInfo.egMgrConfigDir + "eg_pwdprofile.ini");
		boolean isPwdProfileUpdate = false;
		String profileName = "";
		boolean isAlreadyApplyProfile = false;
		boolean isTestDefaultConfigProfile = false;
		String pwdProfileParams = "";
		String existApplyProfile = "";
		String strUsePwdProfValue = "";
		EgPwdProfile pwdProf = new EgPwdProfile();
		JSONObject pwdParamSetList = (JSONObject) session.getAttribute("pwdParamSetList");

		List testSpecsVarList = Arrays.asList(egSpecs.getTestSpecVar());
		String strTestPeriod = "";
		for (int i=0;i<aListConfigurableTest.size();i++)
		{
			String strTestName = ((String)aListConfigurableTest.get(i)).trim();
			String patternA = strTestName + ":" + componentType + ":" + "$hostName" + ":" + port;
			String patternB = strTestName + ":" + componentType + ":" + "$hostName";
			String patternC = strTestName + "::" + "$hostName" + ":" + port;
			String patternD = strTestName + "::" + "$hostName";

			List listSpecficationVariables = Arrays.asList(egSpecs.getTestSpecVar());
			String resultantPattern = "";
			if (listSpecficationVariables.contains(patternA))
			{
				resultantPattern = patternA;
			}
			else if (listSpecficationVariables.contains(patternB))
			{
				resultantPattern = patternB;
			}
			else if (listSpecficationVariables.contains(patternC))
			{
				resultantPattern = patternC;
			}
			else if (listSpecficationVariables.contains(patternD))
			{
				resultantPattern = patternD;
			}

			if (resultantPattern.equals("")) continue;

			String defaultTestParams = egSpecs.getArgsForTest(resultantPattern);
			StringTokenizer stParamTokens = new StringTokenizer(defaultTestParams,",");
			String param1 = stParamTokens.nextToken().trim();
			String param2 = stParamTokens.nextToken();
			String testParams = stParamTokens.nextToken();
			oldTestPeriodValue = stParamTokens.nextToken().trim();
			String testPeriod = request.getParameter("testPeriod");
			testPeriod = testPeriod.trim();

			if (isOldSnmp)
			{
				ArrayList aListOldParams = getParameterList(testParams,true);
				if (!aListOldParams.contains("-snmpversion"))
				{
					int snmpComIdx=aListOldParams.indexOf("-snmpcommunity");
					aListOldParams = getParameterList(testParams,false);
					aListOldParams.add(snmpComIdx+2,"-snmpversion");
					aListOldParams.add(snmpComIdx+3,"v1");

					testParams = aListOldParams.toString();
					testParams = testParams.substring(1,testParams.length()-1);
					testParams = StringUtils.replace(testParams,",","");
				}
			}

			ArrayList aListParamNamesAndValues = getParameterList(testParams,false);
			ArrayList aListUpdatedParamNamesAndValues = new ArrayList();

			//code for auditlog  - starts
			if (isAuditLogEnabled && i==0 )
			{
				for (int j=0;j<aListParamNamesAndValues.size();j=j+2)
				{
					String str = ((String)aListParamNamesAndValues.get(j)).toUpperCase();
					if(str.indexOf("_")>0)
					{
						str = str.replace("_"," ");
					}
					aListTempParamNamesAndValues.add(str);
					str = ((String)aListParamNamesAndValues.get(j+1));
					if(str.startsWith("\""))
					{
						str = str.replace("\"","");
					}
					aListTempParamNamesAndValues.add(str);
				}
				if(aListTempParamNamesAndValues.contains("-DDFREQ"))
				{
					int index = aListTempParamNamesAndValues.indexOf("-DDFREQ")+1;
					aListTempParamNamesAndValues.add("-DD FREQUENCY");
					aListTempParamNamesAndValues.add((String)aListTempParamNamesAndValues.get(index));
				}
				if(aListTempParamNamesAndValues.contains("-ROTATINGFILE"))
				{
					int index = aListTempParamNamesAndValues.indexOf("-ROTATINGFILE")+1;
					aListTempParamNamesAndValues.add("-ROTATING FILE");
					aListTempParamNamesAndValues.add((String)aListTempParamNamesAndValues.get(index));
				}
				if(aListTempParamNamesAndValues.contains("-EXCLUDEPATTERN"))
				{
					int index = aListTempParamNamesAndValues.indexOf("-EXCLUDEPATTERN")+1;
					aListTempParamNamesAndValues.add("-EXCLUDE PATTERN");
					aListTempParamNamesAndValues.add((String)aListTempParamNamesAndValues.get(index));
				}
				if(aListTempParamNamesAndValues.contains("-METHOD EXEC CUTOFF"))
				{
					int index = aListTempParamNamesAndValues.indexOf("-METHOD EXEC CUTOFF")+1;
					aListTempParamNamesAndValues.add("-METHOD EXECUTION CUTOFF (MS)");
					aListTempParamNamesAndValues.add((String)aListTempParamNamesAndValues.get(index));
				}
				if(aListTempParamNamesAndValues.contains("-SQL EXEC CUTOFF"))
				{
					int index = aListTempParamNamesAndValues.indexOf("-SQL EXEC CUTOFF")+1;
					aListTempParamNamesAndValues.add("-SQL EXECUTION CUTOFF (MS)");
					aListTempParamNamesAndValues.add((String)aListTempParamNamesAndValues.get(index));
				}
				if(aListTempParamNamesAndValues.contains("-SHOW HTTPSTATUS"))
				{
					int index = aListTempParamNamesAndValues.indexOf("-SHOW HTTPSTATUS")+1;
					aListTempParamNamesAndValues.add("-SHOW HTTP STATUS");
					aListTempParamNamesAndValues.add((String)aListTempParamNamesAndValues.get(index));
				}
				if(aListTempParamNamesAndValues.contains("-KEY EXCLUDED PATTERNS"))
				{
					int index = aListTempParamNamesAndValues.indexOf("-KEY EXCLUDED PATTERNS")+1;
					aListTempParamNamesAndValues.add("-EXCLUDED PATTERNS");
					aListTempParamNamesAndValues.add((String)aListTempParamNamesAndValues.get(index));
				}
				if(aListTempParamNamesAndValues.contains("-JBOSS DOMAIN MODE"))
				{
					int index = aListTempParamNamesAndValues.indexOf("-JBOSS DOMAIN MODE")+1;
					aListTempParamNamesAndValues.add("-IS JBOSS RUNNING IN DOMAIN MODE?");
					aListTempParamNamesAndValues.add((String)aListTempParamNamesAndValues.get(index));
				}
				if(aListTempParamNamesAndValues.contains("-JBOSS SERVER INSTANCE"))
				{
					int index = aListTempParamNamesAndValues.indexOf("-JBOSS SERVER INSTANCE")+1;
					aListTempParamNamesAndValues.add("-JBOSS SERVER INSTANCE NAME");
					aListTempParamNamesAndValues.add((String)aListTempParamNamesAndValues.get(index));
				}

			}
			//code for auditlog  - ends

			for (int j=0;j<aListParamNamesAndValues.size();j=j+2)
			{
				String paramName = (String)aListParamNamesAndValues.get(j);
				String paramValue = (String)aListParamNamesAndValues.get(j+1);
				aListUpdatedParamNamesAndValues.add(paramName);
				boolean allowToModifyParameterValue = true;
				if (i != 0)
				{
					if (paramName.equalsIgnoreCase("-ddfreq") || paramName.equals("-exclude"))
					{
						allowToModifyParameterValue = false;
					}
				}
				if (aListTemp.contains(paramName) && allowToModifyParameterValue)
				{
					int idx = aListTemp.indexOf(paramName);
					String strValue = (String)aListTemp.get(idx+1);
					if (isHashDelimiter && strValue.indexOf(',') > -1)
					{
						strValue = StringUtils.replace(strValue,",","#");
					}
					//No else if block to replace comma with pipe because
					//down the line we have to process the parameter value where 
					//each token is separated using comma.After processing the parameter,
					//comma is replaced with pipe symbol.
					//for eg credentials,url parameter value have to be processed.
					aListUpdatedParamNamesAndValues.add(strValue);
				}
				else
				{
					aListUpdatedParamNamesAndValues.add(paramValue);
				}
			}

			// special case for pwd profile params
			if (i == 0 && aListTemp != null)
			{
				boolean hasPwdProfileParameter = checkPwdProfileParams(aListTemp,"-password_profile"); // checking string condition is startsWith 
				for (int a=0;a<aListTemp.size();a=a+2)
				{
					String strUsePwdVars = (String)aListTemp.get(a);
					String strUsePwdValue = (String)aListTemp.get(a+1);
					if (strUsePwdVars.startsWith("-password_profile"))
					{
						aListUpdatedParamNamesAndValues.add(strUsePwdVars);
						aListUpdatedParamNamesAndValues.add(strUsePwdValue);
					}
				}
			}

			ArrayList aListProcessedParamNamesAndValues = new ArrayList();
			for (int j=0; j<aListUpdatedParamNamesAndValues.size(); j=j+2)
			{
				String strParamName = (String)aListUpdatedParamNamesAndValues.get(j);
				String strParamValue = (String)aListUpdatedParamNamesAndValues.get(j+1);

				boolean encryptPasswordData = false;
				if (hasPasswordParameters && aListPasswordParameters.contains(strParamName))
				{
					encryptPasswordData = true;
				}
				else if (hasDefaultPasswordParameter && aListDefaultPasswordParameters.contains(strParamName.toLowerCase()))
				{
					encryptPasswordData = true;
				}

				if (strParamName.equalsIgnoreCase("-logType"))
				{
					strParamValue = strParamValue.toLowerCase();
				}

				if (strParamName.equals("-url"))
				{
					String strHiddenUrlDelim = ",";
					if (testName.equals("HttpTest") || 
						testName.equals("HttpPostTest") || 
						testName.equals("SMHttpTest") || 
						testName.equals("AzureWebAcsTest") || 
						testName.equals("AlibabaHttpTest") || 
						testName.equals("AWSHttpTest") || 
						testName.equals("AzrWVDAcsTest") || 
						testName.equals("vCloudHttpTest") || 
						testName.equals("DownSpeedTest"))
					{
						String strHiddenUrl = request.getParameter("hiddenURLs");
						strParamValue = strHiddenUrl;
						strHiddenUrlDelim = "|";
					}
					//handling parameter value for url
					//if (strParamValue.indexOf(",") > -1)
					if (strParamValue.indexOf(strHiddenUrlDelim) > -1)
					{
						String encodedUrl = "";
						StringTokenizer st12 = new StringTokenizer(strParamValue,strHiddenUrlDelim);
						//StringTokenizer st12 = new StringTokenizer(strParamValue,",");
						String tempUrl = "";
						while (st12.hasMoreTokens())
						{
							tempUrl = st12.nextToken();
							if (tempUrl.indexOf(" ") != -1)
							{
								tempUrl = StringUtils.replace(tempUrl," ","~egSpace~");
							}
							if (tempUrl.indexOf("?") > -1)
							{
								int urlIndex = tempUrl.indexOf("?");
								tempUrl = tempUrl.substring(0, urlIndex) + "?" + URLEncoder.encode(tempUrl.substring(urlIndex + 1));
							}
							if (encodedUrl != null && !encodedUrl.equals(""))
							{
								encodedUrl = encodedUrl + "|" + tempUrl;
							}
							else
							{
								encodedUrl = tempUrl;
							}
						}
						strParamValue = encodedUrl;
					}
					else
					{
						if (strParamValue.indexOf(" ") != -1)
						{
							strParamValue = StringUtils.replace(strParamValue," ","~egSpace~");
						}
						if(strParamValue.indexOf("?") > -1)
						{
							int vecValIndex = strParamValue.indexOf("?");
							strParamValue = strParamValue.substring(0, vecValIndex) + "?" + URLEncoder.encode(strParamValue.substring(vecValIndex + 1));
						}
					}
				}
				else if (encryptPasswordData)
				{
					//handling parameter value for password type data
					//strParamValue = EgCrypt.decrypt(strParamValue);
					if (!isNumber(strParamValue))
					{
						strParamValue = EgCrypt.decrypt(strParamValue);
					}
					String passList = "";
					if(testName.equals("CtxAuthTest") || testName.equals("WinAuthTest") || testName.equals("TermAuthTest") || testName.equals("WindowshareTest") || testName.equals("UNCCheckTest"))
					{
						if (strParamValue.indexOf("#~#") > -1)
						{
							ArrayList aListTokens = StringUtils.myTokenizer(strParamValue, "#~#");
							for(int m=0;m<aListTokens.size();m++)
							{
								String strWinShareSome = (String)aListTokens.get(m);
								String strTokenSalt = strWinShareSome;
								if (!isNumber(strTokenSalt))
								{
									strTokenSalt = EgCrypt.decrypt(strTokenSalt);
								}
								if (strTokenSalt.indexOf("@") != -1)
								{
									String strTokenGetDomain =  strTokenSalt.substring(0,strTokenSalt.indexOf("@"));
									String strTokenGetPass =  strTokenSalt.substring(strTokenSalt.indexOf("@")+1);
									if (!isNumber(strTokenGetPass))
									{
										strTokenGetPass = EgCrypt.decrypt(strTokenGetPass);
									}	
									if (strTokenGetPass.indexOf("~EG~") != -1)
									{
										strTokenGetPass = strTokenGetPass.substring(0,strTokenGetPass.indexOf("~EG~"));
									}
									strTokenSalt = strTokenGetDomain+ "@" + strTokenGetPass;
								}

								if (strTokenSalt.indexOf("~EG~") != -1)
								{
									strWinShareSome = strTokenSalt.substring(0,strTokenSalt.indexOf("~EG~"));
								}
								else
								{
									strWinShareSome = strTokenSalt;
								}

								passList += EgCrypt.encrypt(strWinShareSome)+"|";
							}
							passList = passList.substring(0, passList.length()-1);
						}
						else
						{
							if (strParamValue.indexOf("@") != -1)
							{
								String strSingleTokenGetDomain =  strParamValue.substring(0,strParamValue.indexOf("@"));
								String strSingleTokenGetPass =  strParamValue.substring(strParamValue.indexOf("@")+1);
								if (!isNumber(strSingleTokenGetPass))
								{
									strSingleTokenGetPass = EgCrypt.decrypt(strSingleTokenGetPass);
								}
								if (strSingleTokenGetPass.indexOf("~EG~") != -1)
								{
									strSingleTokenGetPass = strSingleTokenGetPass.substring(0,strSingleTokenGetPass.indexOf("~EG~"));
								}
								strParamValue = strSingleTokenGetDomain+ "@" + strSingleTokenGetPass;
							}

							String strSaltParamValue = strParamValue;
							if (!isNumber(strSaltParamValue))
							{
								strSaltParamValue = EgCrypt.decrypt(strSaltParamValue);
							}
							if (strSaltParamValue.indexOf("~EG~") != -1)
							{
								strParamValue = strSaltParamValue.substring(0,strSaltParamValue.indexOf("~EG~"));
							}
							else
							{
								strParamValue = strSaltParamValue;
							}
							passList = EgCrypt.encrypt(strParamValue);
						}
					}
					else
					{
						if (strParamValue.indexOf("#~#") > -1)
						{
							ArrayList aListTokens1 = StringUtils.myTokenizer(strParamValue, "#~#");
							for(int m=0;m<aListTokens1.size();m++)
							{
								String strToken1 = (String) aListTokens1.get(m);
								if (!isNumber(strToken1))
								{
									strToken1 = EgCrypt.decrypt(strToken1);
								}
								if (strToken1.indexOf("~EG~") != -1)
								{
									strToken1 = strToken1.substring(0,strToken1.indexOf("~EG~"));
								}

								if (strParamName.equals("Two_factor_auth_password") && strToken1.equalsIgnoreCase("none"))
								{
									strToken1 = strToken1.toLowerCase();
								}
								passList = passList + (strToken1)+"#~#";
							}
							passList = passList.substring(0, passList.length()-3);
							passList = EgCrypt.encrypt(passList);

						}
						else
						{
							String strSaltParamValue = strParamValue;
							if (!isNumber(strSaltParamValue))
							{
								strSaltParamValue = EgCrypt.decrypt(strSaltParamValue);
							}
							if (strSaltParamValue.indexOf("~EG~") != -1)
							{
								strParamValue = strSaltParamValue.substring(0,strSaltParamValue.indexOf("~EG~"));
							}
							else
							{
								strParamValue = strSaltParamValue;
							}

							if (strParamName.equals("Two_factor_auth_password") && strParamValue.equalsIgnoreCase("none"))
							{
								strParamValue = strParamValue.toLowerCase();
							}
							passList = EgCrypt.encrypt(strParamValue);
						}
					}
					strParamValue = passList;
				}
				else if(strParamName.equalsIgnoreCase("-credentials"))
				{
					//handling parameter value for credentials
					String credentialUser = "";
					String credentialPassword = "";
					int thisCount = 0;
					StringBuffer credentialResultantBuffer = new StringBuffer();
					StringTokenizer credentialTokens = new StringTokenizer(strParamValue,",");
					while (credentialTokens.hasMoreTokens())
					{
						thisCount++;
						if (thisCount > 1)
						{
							credentialResultantBuffer.append("|");
						}
						String eachUnameUpass = credentialTokens.nextToken();
						credentialUser = eachUnameUpass.substring(0,eachUnameUpass.indexOf(":"));

						String strPassChkSalt = ""; // salt for pwd
						if (egserInfo.isAesEncryptForTestConfig())
						{
							strPassChkSalt = eachUnameUpass.substring(eachUnameUpass.indexOf(":")+1,eachUnameUpass.length());
							if (!isNumber(strPassChkSalt))
							{
								strPassChkSalt = EgCrypt.decrypt(strPassChkSalt);
							}
							if (strPassChkSalt.indexOf("~EG~") != -1)
							{
								strPassChkSalt = strPassChkSalt.substring(0,strPassChkSalt.indexOf("~EG~"));
							}
							credentialPassword = EgCrypt.encrypt(strPassChkSalt);
						}
						else
						{
							strPassChkSalt = eachUnameUpass.substring(eachUnameUpass.indexOf(":")+1,eachUnameUpass.length());
							if (!isNumber(strPassChkSalt))
							{
								strPassChkSalt = EgCrypt.decrypt(strPassChkSalt);
							}	
							if (strPassChkSalt.indexOf("~EG~") != -1)
							{
								strPassChkSalt = strPassChkSalt.substring(0,strPassChkSalt.indexOf("~EG~"));
							}
							credentialPassword = EgCrypt.encrypt(strPassChkSalt, true);
						}
						credentialResultantBuffer.append(credentialUser+":"+credentialPassword);
					}
					strParamValue = credentialResultantBuffer.toString();
				}
				else if(strParamName.equalsIgnoreCase("-privateKey"))
				{
					//handling parameter value for File password
					String filePath="none";
					String filePassword = "none";
					String encryptedFilePassword= "";
					int thisCount = 0;
					StringBuffer resultantBuffer = new StringBuffer();
					StringTokenizer resultTokens = new StringTokenizer(strParamValue,",");
					while (resultTokens.hasMoreTokens())
					{
						thisCount++;
						if (thisCount > 1)
						{
							resultantBuffer.append("|");
						}
						String eachFnameFpass = resultTokens.nextToken();
						String tokens[] = EgUtils.getTokens(eachFnameFpass,"#~~#");
						if(tokens != null && tokens.length==2)
						{
							filePath = tokens[0];
							filePassword = tokens[1];
						}

						String strPassChkSaltPrivate = "";
						if (egserInfo.isAesEncryptForTestConfig())
						{
							strPassChkSaltPrivate = filePassword;
							if (!isNumber(strPassChkSaltPrivate))
							{
								strPassChkSaltPrivate = EgCrypt.decrypt(strPassChkSaltPrivate);
							}
							if (strPassChkSaltPrivate.indexOf("~EG~") != -1)
							{
								strPassChkSaltPrivate = strPassChkSaltPrivate.substring(0,strPassChkSaltPrivate.indexOf("~EG~"));
							}
							encryptedFilePassword = EgCrypt.encrypt(strPassChkSaltPrivate);
						}
						else
						{
							strPassChkSaltPrivate = filePassword;
							if (!isNumber(strPassChkSaltPrivate))
							{
								strPassChkSaltPrivate = EgCrypt.decrypt(strPassChkSaltPrivate);
							}
							if (strPassChkSaltPrivate.indexOf("~EG~") != -1)
							{
								strPassChkSaltPrivate = strPassChkSaltPrivate.substring(0,strPassChkSaltPrivate.indexOf("~EG~"));
							}

							encryptedFilePassword = EgCrypt.encrypt(strPassChkSaltPrivate, true);
						}
						resultantBuffer.append(filePath+":"+encryptedFilePassword);
					}
					strParamValue = resultantBuffer.toString();
				}
				else if (strParamName.equals("-Published_resources"))
				{
					String strHiddenPubResrc = request.getParameter("hiddenPublishedResource");
					strHiddenPubResrc = EgUIUtils.decodeSecurityChar(strHiddenPubResrc);

					if ((!StringUtils.isNull(strHiddenPubResrc) && strHiddenPubResrc.indexOf(" -") > -1) || aListParamsWithDoubleQuotes.contains(strParamName.toLowerCase().substring(1)))
					{
						strHiddenPubResrc = "\"" + strHiddenPubResrc + "\"";
					}
					strParamValue = strHiddenPubResrc;
				}


				//replacing pipe in place of comma for the tests having pipe as delimiter
				if (!isHashDelimiter && strParamValue.indexOf(",") > -1)
				{
					strParamValue = StringUtils.replace(strParamValue,",","|");
				}
				if (!isHashDelimiter && strParamValue.indexOf(";") > -1)
				{
					if(!aListEventTests.contains(testName) && !testName.equalsIgnoreCase("WinProcessTest") && !testName.equalsIgnoreCase("LSEventLogTest") && !testName.equalsIgnoreCase("LSEdgeEvtLogTest"))
					{
						strParamValue = StringUtils.replace(strParamValue,";","~#~");
					}
				}

				if (i == 0 && strParamName.startsWith("-password_profile"))
				{
					isPwdProfileUpdate = true;
					String paramsSetForThisParam = (String) pwdParamSetList.get(strParamName.substring(1));
					isAlreadyApplyProfile = pwdProf.isTestHasDefaultPwdProfile(componentType+"#^#"+paramsSetForThisParam,strTestName);

					if (testSpecsVarList != null && testSpecsVarList.size() > 0)
					{
						String pwdProfport = "";
						if (componentType.equals("Oracle_server"))
						{
							pwdProfport = "$portNo:$sid";
						}
						else
						{
							pwdProfport = "$portNo";
						}

						String testSpecPatternA = strTestName + ":" + componentType + ":" + "$hostName" + ":" + pwdProfport;
						String testSpecPatternB = strTestName + ":" + componentType + ":" + "$hostName";
						String testSpecPatternC = strTestName + "::" + "$hostName" + ":" + pwdProfport;
						String testSpecPatternD = strTestName + "::" + "$hostName";

						if (testSpecsVarList.contains(testSpecPatternA) || testSpecsVarList.contains(testSpecPatternB))
						{
							isAlreadyApplyProfile = pwdProf.isTestHasDefaultPwdProfile(componentType+"#^#"+paramsSetForThisParam,strTestName);
						}
						else if (testSpecsVarList.contains(testSpecPatternC) || testSpecsVarList.contains(testSpecPatternD))
						{
							isTestDefaultConfigProfile = true;
							isAlreadyApplyProfile = pwdProf.isTestHasDefaultPwdProfile(strTestName+"#^#"+paramsSetForThisParam);
						}
					}


					if (aListPwdProfIniEntries == null)
					{
						aListPwdProfIniEntries = new ArrayList();
					}

					strUsePwdProfValue = strParamValue;
					if (!strParamValue.equals("-1") && !strParamValue.equalsIgnoreCase("none"))
					{
						profileName = request.getParameter(strParamName.substring(1));
						if (!StringUtils.isNull(profileName) && !profileName.equals("-1"))
						{
							pwdProfileParams = request.getParameter("pwdProfileParams");
							if (isAlreadyApplyProfile)
							{
								if (isTestDefaultConfigProfile)
								{
									existApplyProfile = pwdProf.getProfNameForDefaultConfiguration(strTestName+"#^#"+paramsSetForThisParam,strTestName);

									String pwdProfSubVar = strTestName+"#^#"+profileName;

									if (!StringUtils.isNull(existApplyProfile) && !existApplyProfile.equals(profileName))
									{
										pwdProfSubVar = strTestName+"#^#"+paramsSetForThisParam+"#^#"+existApplyProfile;

										aListPwdProfIniEntries.add(new IniHelper(IniHelper.DELETE,"Default_Configuration",pwdProfSubVar,""));

									}
									pwdProfSubVar = strTestName+"#^#"+paramsSetForThisParam+"#^#"+profileName;
									aListPwdProfIniEntries.add(new IniHelper(IniHelper.SET,"Default_Configuration",pwdProfSubVar,paramsSetForThisParam));
								}
								else
								{
									existApplyProfile = pwdProf.getProfNameForDefaultConfiguration(componentType+"#^#"+paramsSetForThisParam,strTestName);

									String pwdProfSubExist = componentType+"#^#"+paramsSetForThisParam+"#^#"+profileName;

									if (!StringUtils.isNull(existApplyProfile) && !existApplyProfile.equals(profileName))
									{
										pwdProfSubExist = componentType+"#^#"+paramsSetForThisParam+"#^#"+existApplyProfile;

										aListPwdProfIniEntries.add(new IniHelper(IniHelper.DELETE,pwdProfSubExist,strTestName,""));

									}
									pwdProfSubExist = componentType+"#^#"+paramsSetForThisParam+"#^#"+profileName;
									aListPwdProfIniEntries.add(new IniHelper(IniHelper.SET,pwdProfSubExist,strTestName,paramsSetForThisParam));
								}
							}
							else
							{
								if (isTestDefaultConfigProfile)
								{
									String pwdProfSubVar = strTestName+"#^#"+paramsSetForThisParam+"#^#"+profileName;
									aListPwdProfIniEntries.add(new IniHelper(IniHelper.SET,"Default_Configuration",pwdProfSubVar,paramsSetForThisParam));
								}
								else
								{
									String pwdProfSub = componentType+"#^#"+paramsSetForThisParam+"#^#"+profileName;
									aListPwdProfIniEntries.add(new IniHelper(IniHelper.SET,pwdProfSub,strTestName,paramsSetForThisParam));
								}
							}
						}
						else
						{
							if (isTestDefaultConfigProfile)
							{
								String pwdProfSubVar = strTestName+"#^#"+paramsSetForThisParam+"#^#"+profileName;
								aListPwdProfIniEntries.add(new IniHelper(IniHelper.SET,"Default_Configuration",pwdProfSubVar,paramsSetForThisParam));
							}
							else
							{
								String pwdProfSub = componentType+"#^#"+paramsSetForThisParam+"#^#"+profileName;
								aListPwdProfIniEntries.add(new IniHelper(IniHelper.SET,pwdProfSub,strTestName,paramsSetForThisParam));
							}
						}
					}
					else
					{
						if (isAlreadyApplyProfile)
						{
							if (isTestDefaultConfigProfile)
							{
								existApplyProfile = pwdProf.getProfNameForDefaultConfiguration(componentType+"#^#"+paramsSetForThisParam,strTestName);

								if (!StringUtils.isNull(existApplyProfile))
								{
									String pwdProfSubVar = strTestName+"#^#"+paramsSetForThisParam+"#^#"+existApplyProfile;
									aListPwdProfIniEntries.add(new IniHelper(IniHelper.DELETE,"Default_Configuration",pwdProfSubVar,""));
								}

							}
							else
							{
								existApplyProfile = pwdProf.getProfNameForDefaultConfiguration(componentType+"#^#"+paramsSetForThisParam,strTestName);

								if (!StringUtils.isNull(existApplyProfile))
								{
									String pwdProfSubExist = componentType+"#^#"+paramsSetForThisParam+"#^#"+existApplyProfile;
									aListPwdProfIniEntries.add(new IniHelper(IniHelper.DELETE,pwdProfSubExist,strTestName,""));
								}
							}
						}
					}
					continue;
				}

				aListProcessedParamNamesAndValues.add(strParamName);
				aListProcessedParamNamesAndValues.add(strParamValue);
			}

			aListProcessedParamNamesAndValues = updateOtherUnconfiguredParamValues(aListProcessedParamNamesAndValues);

			String resultantTestParameterSet = aListProcessedParamNamesAndValues.toString();
			resultantTestParameterSet = resultantTestParameterSet.substring(1,resultantTestParameterSet.length()-1);
			resultantTestParameterSet =StringUtils.replace(resultantTestParameterSet,",","");

			//for testperiod - starts
			if (strTestName.equals(testName))//userInitiatedTest
			{
				strTestPeriod = testPeriod;
			}
			else
			{
				if (aListCommonTestRelationVariables.contains(strTestName))
				{
					strTestPeriod = testPeriod;
				}
				else
				{
					strTestPeriod = oldTestPeriodValue;
				}
			}
			//for testperiod - ends

			resultantTestParameterSet = param1 + "," + param2 + ", " + resultantTestParameterSet + ", " + strTestPeriod;

			//set the value in the specs
			aListSpecsIniEntries.add(new IniHelper(IniHelper.SET,EgSpecsInfo.testSpecSection,resultantPattern,resultantTestParameterSet));

			//to display the updated parameters and their values to the user-starts
			if (i == 0)
			{
				String tempValue = new String(testPeriod);
				tempValue = tempValue.trim();
				if (Integer.parseInt(tempValue) <= 60)
				{
					tempValue+=" secs";
				}
				else if (Integer.parseInt(tempValue) <= 3599)
				{
					int tpmin=Integer.parseInt(tempValue)/60;
					tempValue=""+tpmin+" mins";
				}
				else if (tempValue.equals("3600"))
				{
					tempValue="1 hr";
				}
				else
				{
					int tphr=Integer.parseInt(tempValue)/3600;
					tempValue=""+tphr+" hrs";
				}

				aListDisplayParamNamesAndValues.add(_mapping.getTextDescription("admin.test.TEST PERIOD"));
				aListDisplayParamNamesAndValues.add(tempValue);

				//for auditlog -starts
				if (isAuditLogEnabled)
				{
					//if(Integer.parseInt(oldTestPeriodValue) < Integer.parseInt(testPeriod))
					//{
						aListAuditCurrentSettingParams.add("TEST PERIOD");
						aListAuditCurrentSettingParams.add(tempValue);

						oldTestPeriodValue = oldTestPeriodValue.trim();

						if (Integer.parseInt(oldTestPeriodValue) <= 60)
						{
							oldTestPeriodValue+=" secs";
						}
						else if (Integer.parseInt(oldTestPeriodValue) <= 3599)
						{
							int tpmin=Integer.parseInt(oldTestPeriodValue)/60;
							oldTestPeriodValue=""+tpmin+" mins";
						}
						else if (oldTestPeriodValue.equals("3600"))
						{
							oldTestPeriodValue="1 hr";
						}
						else
						{
							int tphr=Integer.parseInt(oldTestPeriodValue)/3600;
							oldTestPeriodValue=""+tphr+" hrs";
						}

						aListAuditPreviousSettingParams.add("TEST PERIOD");
						aListAuditPreviousSettingParams.add(oldTestPeriodValue);
					//}
				}
				//for auditlog - ends

				ArrayList aListDisplay = (ArrayList)session.getAttribute("aListDisplay");

				if (aListProcessedParamNamesAndValues.contains("-snmpversion"))
				{
					int snmpVerIdx = aListProcessedParamNamesAndValues.indexOf("-snmpversion");
					String temp1 = (String)aListProcessedParamNamesAndValues.remove(snmpVerIdx);
					String temp2 = (String)aListProcessedParamNamesAndValues.remove(snmpVerIdx);
					int snmpComIdx = aListProcessedParamNamesAndValues.indexOf("-snmpCommunity");
					aListProcessedParamNamesAndValues.add(snmpComIdx+2,temp2);
					aListProcessedParamNamesAndValues.add(snmpComIdx+2,temp1);
				}

				boolean isEncryptFlag = isEncryptFlagFalse(aListProcessedParamNamesAndValues);

				for(int j=0;j<aListProcessedParamNamesAndValues.size();j=j+2)
				{
					String paramName = (String)aListProcessedParamNamesAndValues.get(j);
					paramName = paramName.substring(1).trim();

					if (request.getParameter(paramName) == null)
					{
						if(paramName.equalsIgnoreCase("filter"))
						{
							if(request.getParameter("filter_combo") == null)
							{
								continue;
							}
							aListDisplayParamNamesAndValues.add(_mapping.getTextDescription("admin.test."+paramName.toUpperCase()));
							aListDisplayParamNamesAndValues.add(request.getParameter("filter_combo"));
						}
						continue;
					}

					if (isEncryptFlag && (paramName.equalsIgnoreCase("encrypttype") || paramName.equalsIgnoreCase("encryptpassword")))
					{
						continue;
					}

					String paramValue = (String)aListProcessedParamNamesAndValues.get(j+1);
					paramValue = paramValue.trim();

					if (paramName.equalsIgnoreCase("agentless") || 
						paramName.equalsIgnoreCase("site") || 
						paramName.equalsIgnoreCase("aluser") || 
						paramName.equalsIgnoreCase("alpassword") || 
						paramName.equalsIgnoreCase("almode") || 
						paramName.equalsIgnoreCase("sshPort") || 
						paramName.equalsIgnoreCase("host") || 
						paramName.equalsIgnoreCase("port"))
					{
						continue;
					}

					boolean showConfirmPassWord = false;
					if (hasPasswordParameters && aListPasswordParameters.contains("-"+paramName))
					{
						aListPasswordParameters.add(paramName.replace("_"," ").toUpperCase());
						//continue;
					}
					else if (hasDefaultPasswordParameter && aListDefaultPasswordParameters.contains("-" + paramName.toLowerCase()))
					{
						continue;
					}

					if (paramName.equalsIgnoreCase("rptName") || 
						paramName.equalsIgnoreCase("mCount"))
					{
						continue;
					}

					if (paramValue.startsWith("\"") && paramValue.endsWith("\""))
					{
						paramValue = paramValue.substring(1,paramValue.length()-1);
					}

					if (paramName.equalsIgnoreCase("os"))
					{
						if (paramValue.equalsIgnoreCase("xp"))
						{
							paramValue = "Window XP";
						}
						else if (paramValue.equalsIgnoreCase("2003"))
						{
							paramValue = "Windows 2003";
						}
						else if (paramValue.equalsIgnoreCase("2008"))
						{
							paramValue = "Windows 2008";
						}
						else if (paramValue.equalsIgnoreCase("w2k"))
						{
							paramValue = "Windows 2000";
						}
						else if (paramValue.equalsIgnoreCase("nt"))
						{
							paramValue = "Windows NT";
						}
						else if (paramValue.equalsIgnoreCase("hpux") || 
							paramValue.equalsIgnoreCase("aix"))
						{
							paramValue = paramValue.toUpperCase();
						}
						else if (paramValue.equalsIgnoreCase("tru64"))
						{
							paramValue = "Tru64";
						}
						else if (paramValue.equalsIgnoreCase("linux"))
						{
							paramValue = "Linux";
						}
						else if (paramValue.equalsIgnoreCase("solaris"))
						{
							paramValue = "Solaris";
						}
						else if (paramValue.equalsIgnoreCase("other"))
						{
							paramValue = "Other";
						}
					}
					else if (paramName.equalsIgnoreCase("Target_DiskIO_Rate"))
					{
						String tempTargetDiskIORate = paramValue.substring(0,paramValue.indexOf("_"));
						String tempTargetDiskIORateValue = paramValue.substring(paramValue.indexOf("_")+1,paramValue.length());

						if (tempTargetDiskIORate.equalsIgnoreCase("eq"))
						{
							tempTargetDiskIORate = "Equals";
						}
						else if (tempTargetDiskIORate.equalsIgnoreCase("lt"))
						{
							tempTargetDiskIORate = "Less Than";
						}
						else if (tempTargetDiskIORate.equalsIgnoreCase("le"))
						{
							tempTargetDiskIORate = "Less Than or Equal To";
						}
						else if (tempTargetDiskIORate.equalsIgnoreCase("gt"))
						{
							tempTargetDiskIORate = "Greater Than";
						}
						else
						{
							tempTargetDiskIORate = "Greater Than or Equal To";
						}

						paramValue = tempTargetDiskIORate + " " + tempTargetDiskIORateValue;
					}

					if(paramName.equalsIgnoreCase("credentials"))
					{
						String temp = "";
						ArrayList aListUsers = getArrayList(paramValue,"|");
						credentials = aListUsers;
						for(int b=0;b<aListUsers.size();b++)
						{
							String str=(String)aListUsers.get(b);
							str = str.substring(0,str.indexOf(":"));
							temp = temp + str + ",";
						}
						temp = temp.substring(0,temp.length()-1);
						paramValue = temp;
					}

					if (!aListDisplay.contains(paramName+"#"+paramValue) && 
						(paramValue.equalsIgnoreCase("false") || paramValue.equalsIgnoreCase("n")))
					{
						aListDisplayParamNamesAndValues.add(_mapping.getTextDescription("admin.test."+paramName.toUpperCase()));
						aListDisplayParamNamesAndValues.add(_mapping.getTextDescription("admin.common.No"));
						
					}
					else if (!aListDisplay.contains(paramName+"#"+paramValue) && 
						(paramValue.equalsIgnoreCase("true") || paramValue.equalsIgnoreCase("y")))
					{
						aListDisplayParamNamesAndValues.add(_mapping.getTextDescription("admin.test."+paramName.toUpperCase()));
						aListDisplayParamNamesAndValues.add(_mapping.getTextDescription("admin.common.Yes"));
					}
					else
					{
						aListDisplayParamNamesAndValues.add(_mapping.getTextDescription("admin.test."+paramName.toUpperCase()));
						if(paramValue.indexOf("|")>-1)
						{
							paramValue = StringUtils.replace(paramValue,"|",",");
						}
						if (paramValue.indexOf("~#~") > -1)
						{
							paramValue = StringUtils.replace(paramValue,"~#~",";");
						}

						if(!paramName.equalsIgnoreCase("snmpcommunity") && paramValue.indexOf("#")>-1)
						{
							paramValue = StringUtils.replace(paramValue,"#",",");
						}

						if (paramName.equalsIgnoreCase("url"))
						{
							int tempUrlIdx = aListTemp.indexOf("-"+paramName);
							paramValue = (String)aListTemp.get(tempUrlIdx+1);
						}

						if (b_testWithDelimiter && strMask.length() > 0 && paramValue.indexOf(strMask) != -1)
						{
							paramValue = StringUtils.replace(paramValue,strMask,strDelimiter);
						}

						if (aListDisplay.contains(paramName+"#"+paramValue))
						{
							int paramValIdx = aListDisplay.indexOf(paramName+"#"+paramValue);
							paramValue = (String)aListDisplay.get(paramValIdx+1);
						}
						aListDisplayParamNamesAndValues.add(paramValue);
					}

					if (paramName.equalsIgnoreCase("snmpversion") && 
						(paramValue.equalsIgnoreCase("v1") || paramValue.equalsIgnoreCase("v2")))
					{
						//Displaying the needed parameters in the ui for snmpV1 and snmpV2 only.
						int snmpParamIdx = Arrays.binarySearch(snmpV1V2ParamToContinue,paramName,String.CASE_INSENSITIVE_ORDER);

						if (snmpParamIdx > -1) continue;
					}
					/*if (paramName.equalsIgnoreCase("encryptflag") &&
						paramValue.equalsIgnoreCase("false"))
					{
						break;
					}*/
				}
			}
			//to display the updated paramters and their values to the user-ends

			// password profile works starts here...
			if (isPwdProfileUpdate)
			{
				if (pwdParamSetList != null)
				{
					ArrayList allSelectedPwdParams = new ArrayList();
					Iterator pwdParamsItr = pwdParamSetList.keySet().iterator();
					while(pwdParamsItr.hasNext())
					{
						allSelectedPwdParams.add(pwdParamsItr.next());
					}

					int size = allSelectedPwdParams.size();
					for (int d=0;d<size;d++)
					{
						String strPwdProfParamName = (String) allSelectedPwdParams.get(d);
						String paramsSetForThisParam = (String) pwdParamSetList.get(strPwdProfParamName);
						if (checkParamsExist(paramsSetForThisParam,resultantTestParameterSet))
						{
							isAlreadyApplyProfile = pwdProf.isTestHasDefaultPwdProfile(componentType+"#^#"+paramsSetForThisParam,strTestName);

							if (testSpecsVarList != null && testSpecsVarList.size() > 0)
							{
								String pwdProfport = "";
								if (componentType.equals("Oracle_server"))
								{
									pwdProfport = "$portNo:$sid";
								}
								else
								{
									pwdProfport = "$portNo";
								}

								String testSpecPatternA = strTestName + ":" + componentType + ":" + "$hostName" + ":" + pwdProfport;
								String testSpecPatternB = strTestName + ":" + componentType + ":" + "$hostName";
								String testSpecPatternC = strTestName + "::" + "$hostName" + ":" + pwdProfport;
								String testSpecPatternD = strTestName + "::" + "$hostName";

								if (testSpecsVarList.contains(testSpecPatternA) || testSpecsVarList.contains(testSpecPatternB))
								{
									isAlreadyApplyProfile = pwdProf.isTestHasDefaultPwdProfile(componentType+"#^#"+paramsSetForThisParam,strTestName);
									isTestDefaultConfigProfile = false;

								}
								else if (testSpecsVarList.contains(testSpecPatternC) || testSpecsVarList.contains(testSpecPatternD))
								{
									isTestDefaultConfigProfile = true;
									isAlreadyApplyProfile = pwdProf.isTestHasDefaultPwdProfile(strTestName+"#^#"+paramsSetForThisParam);
								}
							}

							String strProfName = request.getParameter(strPwdProfParamName);
							if (!StringUtils.isNull(strProfName) && !strProfName.equals("-1") && !strProfName.equalsIgnoreCase("none"))
							{
								if (isAlreadyApplyProfile)
								{
									String pwdProfSubExist = componentType+"#^#"+paramsSetForThisParam+"#^#"+strProfName;
									if (isTestDefaultConfigProfile)
									{
										existApplyProfile = pwdProf.getProfNameForDefaultConfiguration(strTestName+"#^#"+paramsSetForThisParam);

										if (!StringUtils.isNull(existApplyProfile) && !existApplyProfile.equals(strProfName))
										{
											pwdProfSubExist = strTestName+"#^#"+paramsSetForThisParam+"#^#"+existApplyProfile;

											aListPwdProfIniEntries.add(new IniHelper(IniHelper.DELETE,"Default_Configuration",pwdProfSubExist,""));
										}
										pwdProfSubExist = strTestName+"#^#"+paramsSetForThisParam+"#^#"+strProfName;
										aListPwdProfIniEntries.add(new IniHelper(IniHelper.SET,"Default_Configuration",pwdProfSubExist,paramsSetForThisParam));
									}
									else
									{
										existApplyProfile = pwdProf.getProfNameForDefaultConfiguration(componentType+"#^#"+paramsSetForThisParam,strTestName);

										if (!StringUtils.isNull(existApplyProfile) && !existApplyProfile.equals(strProfName))
										{
											pwdProfSubExist = componentType+"#^#"+paramsSetForThisParam+"#^#"+existApplyProfile;

											aListPwdProfIniEntries.add(new IniHelper(IniHelper.DELETE,pwdProfSubExist,strTestName,""));
										}
										pwdProfSubExist = componentType+"#^#"+paramsSetForThisParam+"#^#"+strProfName;
										aListPwdProfIniEntries.add(new IniHelper(IniHelper.SET,pwdProfSubExist,strTestName,paramsSetForThisParam));
									}
								}
								else
								{
									if (isTestDefaultConfigProfile)
									{
										String pwdProfVar = strTestName+"#^#"+paramsSetForThisParam+"#^#"+strProfName;
										aListPwdProfIniEntries.add(new IniHelper(IniHelper.SET,"Default_Configuration",pwdProfVar,paramsSetForThisParam));
									}
									else
									{
										String pwdProfSub = componentType+"#^#"+paramsSetForThisParam+"#^#"+strProfName;
										aListPwdProfIniEntries.add(new IniHelper(IniHelper.SET,pwdProfSub,strTestName,paramsSetForThisParam));
									}
								}
							}
							else
							{
								// this case for already selected profile is need to be deleted, coz profile not selected  in last updation....
								if (isAlreadyApplyProfile)
								{
									if (isTestDefaultConfigProfile)
									{
										existApplyProfile = pwdProf.getProfNameForDefaultConfiguration(strTestName+"#^#"+paramsSetForThisParam);

										if (!StringUtils.isNull(existApplyProfile))
										{
											String pwdProfVarExist = strTestName+"#^#"+paramsSetForThisParam+"#^#"+existApplyProfile;
											aListPwdProfIniEntries.add(new IniHelper(IniHelper.DELETE,"Default_Configuration",pwdProfVarExist,""));
										}
									}
									else
									{
										existApplyProfile = pwdProf.getProfNameForDefaultConfiguration(componentType+"#^#"+paramsSetForThisParam,strTestName);

										if (!StringUtils.isNull(existApplyProfile))
										{
											String pwdProfSubExist = componentType+"#^#"+paramsSetForThisParam+"#^#"+existApplyProfile;
											aListPwdProfIniEntries.add(new IniHelper(IniHelper.DELETE,pwdProfSubExist,strTestName,""));
										}
									}
								}
							}
						}
					}
				}
			}
			// password profile works ends here...
		}

		// for discovery changes - starts
		if (aListTemp.contains("-virtual_center"))
		{
			int vcidx = aListTemp.indexOf("-virtual_center");
			String virtual_centerValue = (String)aListTemp.get(vcidx+1);

			if (!virtual_centerValue.equalsIgnoreCase("other") && !virtual_centerValue.equalsIgnoreCase("none"))
			{
				IniFile eg_servicesIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_services.ini");

				int esxUserIdx = aListTemp.indexOf("-Esx_user");
				String strEsxUserValue = (String)aListTemp.get(esxUserIdx+1);
				String actualEsxUname = strEsxUserValue;

				int esxPasswordIdx = aListTemp.indexOf("-Esx_password");
				String strEsxPasswordValue = (String)aListTemp.get(esxPasswordIdx+1);
				//strEsxPasswordValue = EgCrypt.decrypt(strEsxPasswordValue);
				String strTokenSalt = strEsxPasswordValue;
				if (!isNumber(strTokenSalt))
				{
					strTokenSalt = EgCrypt.decrypt(strTokenSalt);
				}
				if (strTokenSalt.indexOf("~EG~") != -1)
				{
					strEsxPasswordValue = strTokenSalt.substring(0,strTokenSalt.indexOf("~EG~"));
				}
				else
				{
					strEsxPasswordValue = strTokenSalt;
				}
				strEsxPasswordValue = EgCrypt.encrypt(strEsxPasswordValue);

				int esxSslIdx = aListTemp.indexOf("-ssl");
				String strSslValue = (String)aListTemp.get(esxSslIdx+1);

				int webPortIdx = aListTemp.indexOf("-webPort");
				String webPort = (String)aListTemp.get(webPortIdx+1);

				String isDiscovery = "No";
				//String hosted_vm_type="ServerVMs";
				String virtualCenterPattern = eg_servicesIni.getValue("VIRTUAL_CENTER",virtual_centerValue);
				StringTokenizer sst = new StringTokenizer(virtualCenterPattern,"#");
				if (sst.hasMoreTokens())
				{
					sst.nextToken();
					sst.nextToken();
					sst.nextToken();
					isDiscovery = sst.nextToken();
					/*sst.nextToken();
					if(sst.hasMoreTokens())
					{
						hosted_vm_type = sst.nextToken();
					}*/
				}

				if (strSslValue != null)
				{
					if (strSslValue.equalsIgnoreCase("true"))
					{
						if (webPort != null)
						{
							if (webPort.equalsIgnoreCase("default"))
							{
								webPort = "443";
							}
						}
						else
						{
							webPort = "443";
						}
					}
					else
					{
						if (webPort != null)
						{
							if (webPort.equalsIgnoreCase("default"))
							{
								webPort = "80";
							}
						}
						else
						{
							webPort = "80";
						}
					}
				}

				String pattern = strSslValue + "#" + strEsxUserValue + "#" + strEsxPasswordValue + "#" + isDiscovery + "#" + webPort;
				if (aListServicesIniEntries == null)
				{
					aListServicesIniEntries = new ArrayList();
				}

				if (strEsxUserValue.indexOf("#") != -1)
				{
					actualEsxUname = StringUtils.replace(actualEsxUname,"#", "~eGHash~");
					pattern = strSslValue + "#" + actualEsxUname + "#" + strEsxPasswordValue + "#" + isDiscovery + "#" + webPort;
				}
				aListServicesIniEntries.add(new IniHelper(IniHelper.SET,"VIRTUAL_CENTER",virtual_centerValue,pattern));
			}
		}
		// for discovery changes - ends

		// for nutanix changes - starts
		if (aListTemp.contains("-Prism_IP"))
		{
			int cvmipidx = aListTemp.indexOf("-Prism_IP");
			String cvm_ipValue = (String)aListTemp.get(cvmipidx+1);

			if (!cvm_ipValue.equalsIgnoreCase("other") && !cvm_ipValue.equalsIgnoreCase("none"))
			{
				IniFile eg_servicesIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_services.ini");

				int cvmUserIdx = aListTemp.indexOf("-Prism_user");
				String strCVMUserValue = (String)aListTemp.get(cvmUserIdx+1);

				int cmvPasswordIdx = aListTemp.indexOf("-Prism_password");
				String strCVMPasswordValue = (String)aListTemp.get(cmvPasswordIdx+1);
				//strCVMPasswordValue = EgCrypt.decrypt(strCVMPasswordValue);
				String strTokenSalt = strCVMPasswordValue;
				if (!isNumber(strTokenSalt))
				{
					strTokenSalt = EgCrypt.decrypt(strTokenSalt);
				}
				if (strTokenSalt.indexOf("~EG~") != -1)
				{
					strCVMPasswordValue = strTokenSalt.substring(0,strTokenSalt.indexOf("~EG~"));
				}
				else
				{
					strCVMPasswordValue = strTokenSalt;
				}
				strCVMPasswordValue = EgCrypt.encrypt(strCVMPasswordValue);

				int cvmSslIdx = aListTemp.indexOf("-ssl");
				String strSslValue = (String)aListTemp.get(cvmSslIdx+1);

				int webPortIdx = aListTemp.indexOf("-webPort");
				String webPort = (String)aListTemp.get(webPortIdx+1);

				String isDiscovery = "No";
				String nutanixPattern = eg_servicesIni.getValue("NUTANIX",cvm_ipValue);
				StringTokenizer sst = new StringTokenizer(nutanixPattern,"#");
				if (sst.hasMoreTokens())
				{
					sst.nextToken();
					sst.nextToken();
					sst.nextToken();
					isDiscovery = sst.nextToken();
				}

				String pattern = strSslValue + "#" + strCVMUserValue + "#" + strCVMPasswordValue + "#" + isDiscovery + "#" + webPort;
				if (aListServicesIniEntries == null)
				{
					aListServicesIniEntries = new ArrayList();
				}
				aListServicesIniEntries.add(new IniHelper(IniHelper.SET,"NUTANIX",cvm_ipValue,pattern));

			}
		}
		// for nutanix changes - ends

		if (aListTemp.contains("-hmc_server") && aListTemp.contains("-hmc_user"))
		{
			IniFile eg_servicesIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_services.ini");

			int hmcServerIdx = aListTemp.indexOf("-hmc_server");
			String hmcServerValue = (String)aListTemp.get(hmcServerIdx+1);

			int hmcUserIdx = aListTemp.indexOf("-hmc_user");
			String hmcUserValue = (String)aListTemp.get(hmcUserIdx+1);

			int hmcPasswordIdx = aListTemp.indexOf("-hmc_password");
			String hmcPasswordValue = (String)aListTemp.get(hmcPasswordIdx+1);
			//hmcPasswordValue = EgCrypt.decrypt(hmcPasswordValue);
			String strTokenSalt = hmcPasswordValue;
			if (!isNumber(strTokenSalt))
			{
				strTokenSalt = EgCrypt.decrypt(strTokenSalt);
			}
			if (strTokenSalt.indexOf("~EG~") != -1)
			{
				hmcPasswordValue = strTokenSalt.substring(0,strTokenSalt.indexOf("~EG~"));
			}
			else
			{
				hmcPasswordValue = strTokenSalt;
			}

			hmcPasswordValue = EgCrypt.encrypt(hmcPasswordValue);

			int sslIdx = aListTemp.indexOf("-ssl");
			String sslValue = (String)aListTemp.get(sslIdx+1);

			String isDiscovery = "No";
			String hmcPattern = eg_servicesIni.getValue("HMC",hmcServerValue);
			StringTokenizer sst = new StringTokenizer(hmcPattern,"#");
			if (sst.hasMoreTokens())
			{
				sst.nextToken();
				sst.nextToken();
				sst.nextToken();
				isDiscovery = sst.nextToken();
			}

			String pattern = sslValue + "#" + hmcUserValue + "#" + hmcPasswordValue + "#" + isDiscovery + "#" + hmcServerValue;
			if (aListServicesIniEntries == null)
			{
				aListServicesIniEntries = new ArrayList();
			}
			aListServicesIniEntries.add(new IniHelper(IniHelper.SET,"HMC",hmcServerValue,pattern));
		}

		// for RHEV discovery changes - starts
		if (aListTemp.contains("-Rhel_mgr_host"))
		{
			int rhevIdx = aListTemp.indexOf("-Rhel_mgr_host");
			String rhev_mgrValue = (String)aListTemp.get(rhevIdx+1);

			if (!rhev_mgrValue.equalsIgnoreCase("other") && !rhev_mgrValue.equalsIgnoreCase("none"))
			{
				IniFile eg_servicesIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_services.ini");

				int rhevUserIdx = aListTemp.indexOf("-Rhel_mgr_user");
				String strRhevUserValue = (String)aListTemp.get(rhevUserIdx+1);

				int rhevPasswordIdx = aListTemp.indexOf("-Rhel_mgr_password");
				String strRhevPasswordValue = (String)aListTemp.get(rhevPasswordIdx+1);
				//strRhevPasswordValue = EgCrypt.decrypt(strRhevPasswordValue);
				String strTokenSalt = strRhevPasswordValue;
				if (!isNumber(strTokenSalt))
				{
					strTokenSalt = EgCrypt.decrypt(strTokenSalt);
				}
				if (strTokenSalt.indexOf("~EG~") != -1)
				{
					strRhevPasswordValue = strTokenSalt.substring(0,strTokenSalt.indexOf("~EG~"));
				}
				else
				{
					strRhevPasswordValue = strTokenSalt;
				}
				strRhevPasswordValue = EgCrypt.encrypt(strRhevPasswordValue);

				int rhevSSLIdx = aListTemp.indexOf("-ssl");
				String strSslValue = (String)aListTemp.get(rhevSSLIdx+1);

				int mgrPortIdx = aListTemp.indexOf("-Rhel_mgr_port");
				String mgrPort = (String)aListTemp.get(mgrPortIdx+1);

				int domainIdx = aListTemp.indexOf("-Rhel_mgr_domain");
				String domain = (String)aListTemp.get(domainIdx+1);

				String isDiscovery = "No";
				String rhevMgrPattern = eg_servicesIni.getValue("RHEV",rhev_mgrValue);
				StringTokenizer sst = new StringTokenizer(rhevMgrPattern,"#");
				if (sst.hasMoreTokens())
				{
					sst.nextToken();
					sst.nextToken();
					sst.nextToken();
					isDiscovery = sst.nextToken();
				}

				if (strSslValue != null)
				{
					if (strSslValue.equalsIgnoreCase("true"))
					{
						if (mgrPort != null)
						{
							if (mgrPort.equalsIgnoreCase("default"))
							{
								mgrPort = "8443";
							}
						}
						else
						{
							mgrPort = "8443";
						}
					}
					else
					{
						if (mgrPort != null)
						{
							if (mgrPort.equalsIgnoreCase("default"))
							{
								mgrPort = "8080";
							}
						}
						else
						{
							mgrPort = "8080";
						}
					}
				}

				String pattern = strSslValue + "#" + strRhevUserValue + "#" + strRhevPasswordValue + "#" + isDiscovery + "#" + mgrPort +"#"+ domain;
				if (aListServicesIniEntries == null)
				{
					aListServicesIniEntries = new ArrayList();
				}

				aListServicesIniEntries.add(new IniHelper(IniHelper.SET,"RHEV",rhev_mgrValue,pattern));
			}
		}
		// for discovery changes - ends

		// for XMS IP Configuration - starts
		if (aListTemp.contains("-xms_ip"))
		{
			int xmsIPIdx = aListTemp.indexOf("-xms_ip");
			String xmsIPValue = (String)aListTemp.get(xmsIPIdx+1);
			if (!xmsIPValue.equalsIgnoreCase("other") && !xmsIPValue.equalsIgnoreCase("none"))
			{

				IniFile eg_servicesIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_services.ini");

				int xmsUserIdx = aListTemp.indexOf("-XtremIO_user");
				String strXMSUserValue = (String)aListTemp.get(xmsUserIdx+1);

				int xmsPasswordIdx = aListTemp.indexOf("-XtremIO_password");
				String strXMSPasswordValue = (String)aListTemp.get(xmsPasswordIdx+1);
				//strXMSPasswordValue = EgCrypt.decrypt(strXMSPasswordValue);
				String strTokenSalt = strXMSPasswordValue;
				if (!isNumber(strTokenSalt))
				{
					strTokenSalt = EgCrypt.decrypt(strTokenSalt);
				}
				if (strTokenSalt.indexOf("~EG~") != -1)
				{
					strXMSPasswordValue = strTokenSalt.substring(0,strTokenSalt.indexOf("~EG~"));
				}
				else
				{
					strXMSPasswordValue = strTokenSalt;
				}
				strXMSPasswordValue = EgCrypt.encrypt(strXMSPasswordValue);

				int xmsSSLIdx = aListTemp.indexOf("-ssl");
				String strSslValue = (String)aListTemp.get(xmsSSLIdx+1);

				if (!StringUtils.isNull(strSslValue))
				{
					if (strSslValue.equalsIgnoreCase("true"))
					{
						strSslValue = "Yes";
					}
					else
					{
						strSslValue = "No";
					}
				}

				String isDiscovery = "No";
				String xmsMgrPattern = eg_servicesIni.getValue("EMC_XtremIO_4x",xmsIPValue);
				StringTokenizer sst = new StringTokenizer(xmsMgrPattern,"#");
				if (sst.hasMoreTokens())
				{
					sst.nextToken();
					sst.nextToken();
					sst.nextToken();
					isDiscovery = sst.nextToken();
				}

				String pattern = strSslValue + "#" + strXMSUserValue + "#" + strXMSPasswordValue + "#" + isDiscovery; 
				if (aListServicesIniEntries == null)
				{
					aListServicesIniEntries = new ArrayList();
				}
				aListServicesIniEntries.add(new IniHelper(IniHelper.SET,"EMC_XtremIO_4x",xmsIPValue,pattern));
			}
		}
		// for XMS IP Configuration - ends

		//for auditlog -starts
		if (isAuditLogEnabled)
		{
			auditLogThread.setValue("Description","Default parameters of test " + "$test$:" +testName + " have been configured for server " + "$ctype$:" + componentType);

			for (int i=0;i<aListDisplayParamNamesAndValues.size();i=i+2)
			{
				String eachParam = (String)aListDisplayParamNamesAndValues.get(i);
				String eachParamValue = (String)aListDisplayParamNamesAndValues.get(i+1);

				if (aListTempParamNamesAndValues.contains("-"+eachParam))
				{
					int tempIdx = aListTempParamNamesAndValues.indexOf("-"+eachParam);
					String strValue = (String)aListTempParamNamesAndValues.get(tempIdx+1);
					if (eachParamValue.equalsIgnoreCase("Yes") && strValue.equalsIgnoreCase("true")) continue;
					if (eachParamValue.equalsIgnoreCase("No") && strValue.equalsIgnoreCase("false")) continue;

					if (!eachParamValue.equals(strValue))
					{
						aListAuditCurrentSettingParams.add(eachParam);
						eachParamValue = eachParamValue.equals("yes")?"Yes":eachParamValue.equals("no")?"No":eachParamValue;
						aListAuditCurrentSettingParams.add(eachParamValue);

						aListAuditPreviousSettingParams.add(eachParam);
						if (strValue.equalsIgnoreCase("true") || 
							strValue.equalsIgnoreCase("yes") || 
							strValue.equalsIgnoreCase("y")) 
						{
							strValue = "Yes";
						}
						else if (strValue.equalsIgnoreCase("false") || 
								strValue.equalsIgnoreCase("no") || 
								strValue.equalsIgnoreCase("n"))
						{
							strValue = "No";
						}
						else if (strValue.equalsIgnoreCase("$unconfigured") ||
							strValue.equalsIgnoreCase("$port"))
						{
							strValue = "-";
						}
						aListAuditPreviousSettingParams.add(strValue);
					}
				}
			}

			for(int i=0;i<aListAuditPreviousSettingParams.size();i=i+2)
			{
				String temp1 = (String)aListAuditPreviousSettingParams.get(i);
				String temp2 = (String)aListAuditPreviousSettingParams.get(i+1);
				if(hasPasswordParameters)
				{
					String currentParam = (String)aListAuditCurrentSettingParams.get(i);
					String currentValue = (String)aListAuditCurrentSettingParams.get(i+1);
					if(aListPasswordParameters.contains(temp1))
					{
						if(!EgCrypt.decrypt(temp2).equals(EgCrypt.decrypt(currentValue)))
						{
							auditLogThread.setPreviousValue(temp1,"*****");
							auditLogThread.setCurrentValue(currentParam,"******");
						}
						continue;
					}
					else if(aListPasswordParameters.contains(currentParam))
					{
						auditLogThread.setPreviousValue(currentParam,"-");
						auditLogThread.setCurrentValue(currentParam,"*****");
						continue;
					}
				}
				if(temp1.equals("ALARMTYPE"))
				{
					temp2 = temp2.equals("H")?"Critical":temp2.equals("M")?"Critical/Major":temp2.equals("L")?"Critical/Major/Minor":temp2;
				}
				else if(temp2.indexOf("|") != -1)
				{
					temp2 = temp2.replace("|",",");
				}
				else if(temp1.equalsIgnoreCase("MODE"))
				{
					temp2 = temp2.equalsIgnoreCase("Yes")?"SNMP":temp2.equalsIgnoreCase("No")?"JMX":temp2;
				}
				else if(temp1.equalsIgnoreCase("AUTHTYPE") ||temp1.equalsIgnoreCase("ENCRYPTTYPE"))
				{
					temp2 = temp2.toUpperCase();
				}
				else if(temp1.equalsIgnoreCase("MEASURE MODE"))
				{
					temp2 = temp2.equalsIgnoreCase("Yes")?"Log File":temp2.equalsIgnoreCase("No")?"JMX":temp2;
					String mMode = (String)aListAuditCurrentSettingParams.get(i+1);
					aListAuditCurrentSettingParams.set(i+1,mMode.equalsIgnoreCase("Yes")?"Log File":mMode.equalsIgnoreCase("No")?"JMX":mMode);
				}
				else if(temp1.equalsIgnoreCase("SHOW BY"))
				{
					temp2 = temp2.equals("RenderTime")?"Render Time(ms)":temp2.equals("Requests")?"Requests(Number)":temp2;
				}
				else if(temp1.equalsIgnoreCase("WEBPORT"))
				{
					if(aListTempParamNamesAndValues.contains("-SSL"))
					{
						int sslIdx = aListTempParamNamesAndValues.indexOf("-SSL");
						String ssl = (String)aListTempParamNamesAndValues.get(sslIdx+1);
						boolean isSSL = Boolean.parseBoolean(ssl);
						temp2 = temp2.equals("default") && isSSL?"443":temp2.equals("default") && !isSSL?"80":temp2;
					}
				}
				else if(temp1.equalsIgnoreCase("VIRTUAL CENTER"))
				{
					temp2 = temp2.equals("none")?"None":temp2;
				}
				else if(temp1.equalsIgnoreCase("INSIDE VIEW USING"))
				{
					temp2 = temp2.equals("exe")?"Remote connection to VM(windows)":temp2.equals("tcp")?"eG VM Agent(windows)":temp2;
					String view = (String)aListAuditCurrentSettingParams.get(i+1);
					aListAuditCurrentSettingParams.set(i+1,view.equals("exe")?"Remote connection to VM(windows)":view.equals("tcp")?"eG VM Agent(windows)":view);
				}
				else if(testName.equalsIgnoreCase("HttpTest"))
				{
					if(temp1.equalsIgnoreCase("URL"))
					{
						temp2 = temp2.equalsIgnoreCase("HomePage:http://$hostIp:$portNo/")?"-":temp2;
					}
					else if(temp1.equalsIgnoreCase("CREDENTIALS"))
					{
						int idxCol = temp2.indexOf(":");
						String prPwd = "";
						if(idxCol != -1)
						{
							String s1 = temp2.substring(0,idxCol);
							prPwd = temp2.substring(idxCol+1);
							if (!isNumber(prPwd))
							{
								prPwd = EgCrypt.decrypt(prPwd);
							}
							temp2 = (s1+":"+prPwd).equals("none:none")?"none":s1;
						}
						String crtls = (credentials != null && !credentials.isEmpty()) ? (String)credentials.get(0) : "";
						idxCol = crtls.indexOf(":");
						if(idxCol != -1)
						{
							String s1 = crtls.substring(0,idxCol);
							String crPwd = crtls.substring(idxCol+1);
							if (!isNumber(crPwd))
							{
								crPwd = EgCrypt.decrypt(crPwd);
							}
							if(!crPwd.equals(prPwd))
							{
								temp2 += ":*****";
								s1 += ":******";
							}
							int idx = aListAuditCurrentSettingParams.indexOf("CREDENTIALS")+1;
							aListAuditCurrentSettingParams.set(i+1,s1);
						}
					}
					else if(temp1.equalsIgnoreCase("CONTENT"))
					{
						int idxCol = temp2.indexOf(":");
						if(idxCol != -1)
						{
							String s1 = temp2.substring(0,idxCol);
							s1 = s1.equalsIgnoreCase("Inc")?"Include":s1.equalsIgnoreCase("Exc")?"Exclude":s1.equalsIgnoreCase("none")?"None":s1;
							temp2 = s1+temp2.substring(idxCol);
						}
						String content = (String)aListAuditCurrentSettingParams.get(i+1);
						idxCol = content.indexOf(":");
						if(idxCol != -1)
						{
							String s1 = content.substring(0,idxCol);
							s1 = s1.equalsIgnoreCase("Inc") ? "Include" : s1.equalsIgnoreCase("Exc") ? "Exclude" : s1.equalsIgnoreCase("none") ? "None" : s1;
							aListAuditCurrentSettingParams.set(i+1,s1+content.substring(idxCol));
						}
					}
					else if(temp1.equalsIgnoreCase("PRIVATEKEY"))
					{
						int idxCol = temp2.indexOf(":");
						String prPwd = "";
						if(idxCol != -1)
						{
							String s1 = temp2.substring(0,idxCol);
							prPwd = temp2.substring(idxCol+1);
							if (!isNumber(prPwd))
							{
								prPwd = EgCrypt.decrypt(prPwd);
							}							
							temp2 = (s1+":"+prPwd).equals("none:none")?"none":s1;
						}
						String privatekey = (String)aListAuditCurrentSettingParams.get(i+1);
						idxCol = privatekey.indexOf(":");
						if(idxCol != -1)
						{
							String s1 = privatekey.substring(0,idxCol);
							String crPwd = privatekey.substring(idxCol+1);
							if (!isNumber(crPwd))
							{
								crPwd = EgCrypt.decrypt(crPwd);
							}
							if(!crPwd.equals(prPwd))
							{
								temp2 += ":*****";
								s1 += ":******";
							}
							aListAuditCurrentSettingParams.set(i+1,s1);
						}
					}
				}
				else if(temp1.equalsIgnoreCase("JBOSS VERSION"))
				{
					temp2 = temp2.equals("6eap")?"6.x EAP":temp2.equals("7as")?"7.x AS":temp2.equals("7eap")?"7.x EAP":temp2;
				}
				else if(temp1.equalsIgnoreCase("APPS"))
				{
					temp2 = temp2.equals("all")?"All":temp2;
				}
				auditLogThread.setPreviousValue(temp1,temp2);

				temp1 = (String)aListAuditCurrentSettingParams.get(i);
				temp2 = (String)aListAuditCurrentSettingParams.get(i+1);
				auditLogThread.setCurrentValue(temp1,temp2);
			}

			auditLogThread.sendItToDB();
		}
		//for auditlog -ends

		//for eg_specs.ini - starts
		if (aListSpecsIniEntries != null)
		{
			IniFile eg_specsIniSync = EgConfigFilesSync.getInstance(EgConfigInfo.egMgrConfigDir + "eg_specs.ini");
			for (int i=0;i<aListSpecsIniEntries.size();i++)
			{
				IniHelper iniHelper= (IniHelper)aListSpecsIniEntries.get(i);
				String iniAction = iniHelper.getAction();
				String sub = iniHelper.getSubject();
				String key = iniHelper.getVariable();
				String val = iniHelper.getValue();
				if (iniAction != null)
				{
					if (iniAction.equals(IniHelper.SET))
					{
						eg_specsIniSync.setValue(sub,key,val);
					}
				}
			}
			eg_specsIniSync.saveFile();
			EgConfigFilesSync.releaseInstance(eg_specsIniSync);
		}
		//for eg_specs.ini - ends

		//for eg_services.ini - starts
		if (aListServicesIniEntries != null)
		{
			IniFile eg_servicesIniSync = EgConfigFilesSync.getInstance(EgConfigInfo.egMgrConfigDir + "eg_services.ini");
			for (int i=0;i<aListServicesIniEntries.size();i++)
			{
				IniHelper iniHelper= (IniHelper)aListServicesIniEntries.get(i);
				String iniAction = iniHelper.getAction();
				String sub = iniHelper.getSubject();
				String key = iniHelper.getVariable();
				String val = iniHelper.getValue();
				if (iniAction != null)
				{
					if (iniAction.equals(IniHelper.SET))
					{
						eg_servicesIniSync.setValue(sub,key,val);
					}
				}
			}
			eg_servicesIniSync.saveFile();
			EgConfigFilesSync.releaseInstance(eg_servicesIniSync);
		}
		//for eg_services.ini - ends

		if (aListPwdProfIniEntries != null)
		{
			IniFile writePwdProfIniSync = EgConfigFilesSync.getInstance(EgConfigInfo.egMgrConfigDir + "eg_pwdprofile.ini");
			for (int i=0;i<aListPwdProfIniEntries.size();i++)
			{
				IniHelper iniHelper= (IniHelper)aListPwdProfIniEntries.get(i);
				String iniAction = iniHelper.getAction();
				String sub = iniHelper.getSubject();
				String key = iniHelper.getVariable();
				String val = iniHelper.getValue();
				if (iniAction != null)
				{
					if (iniAction.equals(IniHelper.SET))
					{
						writePwdProfIniSync.setValue(sub,key,val);
					}
					else if (iniAction.equals(IniHelper.DELETE))
					{
						writePwdProfIniSync.deleteValue(sub,key);
					}
				}
			}
			writePwdProfIniSync.saveFile();
			EgConfigFilesSync.releaseInstance(writePwdProfIniSync);
		}

		servicer.startDiscovery("1");
		EgConfigFilesSync.releaseInstance(infraIni);
		//ends here

		//forward to result page - starts
		session.setAttribute("aListDisplayParamNamesAndValues",aListDisplayParamNamesAndValues);
		query = "EgConfigureDefaultParamResult.jsp?compType="+EgURLEncoder.encode(componentType,"UTF-8")+"&testName="+EgURLEncoder.encode(testName,"UTF-8");
		rootJson.put("success","true");
		rootJson.put("successUpdate","true");
		out.println(rootJson.toString());
	}
	catch(Exception e)
	{
		e.printStackTrace();
	}
%>


<%!
	private void updateAgentsValues(ArrayList typeList, String ipAddress, String values, String from, ArrayList exceptEsxList,EgRoleInfo ri)
	{
		IniFile mappingIni = null;
		String agFile = "eg_agents.ini";
		String iniFile_dir = EgInstallInfo.getInstallDir() + "/manager/config/";

		StringTokenizer st = new StringTokenizer(values, "#"); //ssl+"#"+UName+"#"+UPass+"#"+isDis+"#"+webPort;
		String ssl = st.nextToken();
		String UName = st.nextToken();
		String UPass = st.nextToken();
		String isDis = st.nextToken();
		String webPort = st.nextToken();

		if(from.startsWith("hmc"))
		{
			mappingIni = new IniFile(iniFile_dir + "eg_hmcmapping.ini");
		}
		else if(from.startsWith("nutanix"))
		{
			mappingIni = new IniFile(iniFile_dir + "eg_nutanixmapping.ini");
		}
		else
		{
			mappingIni = new IniFile(iniFile_dir + "eg_vcmapping.ini");
		}

		EgSpecsInfo egSpecs = new EgSpecsInfo("manager");
		ArrayList testEnabled = new ArrayList();
		ArrayList testListForAuditlog = new ArrayList();
		ArrayList compListForAuditlog = new ArrayList();
		ArrayList listOfComponents = null;

		ArrayList associateCompsList = null;
		String[] associateComps = mappingIni.getVariables(ipAddress);
		if (associateComps != null && associateComps.length > 0)
		{
			associateCompsList = new ArrayList(Arrays.asList(associateComps));
		}

		IniFile agIniFile = EgConfigFilesSync.getInstance(iniFile_dir + agFile,true);

		for(int h=0;h<typeList.size();h++)
		{
			Hashtable nickAgentMap = new Hashtable();
			String thisType = (String) typeList.get(h);
			listOfComponents = new ArrayList(Arrays.asList(ri.getAllServersOfType(thisType)));

			ArrayList associateManagedCompList = new ArrayList();
			if(listOfComponents != null && listOfComponents.size()>0)
			{
				for (int l=0;l<listOfComponents.size();l++)
				{
					String strCompName = listOfComponents.get(l).toString();
					if (exceptEsxList != null && exceptEsxList.contains(strCompName))
					{
						continue;
					}

					if(associateCompsList != null && associateCompsList.contains(strCompName))
					{
						associateManagedCompList.add(strCompName);
					}
				}

				//if (!associateManagedCompList.isEmpty())
				{
					listOfComponents = new ArrayList();
					listOfComponents.addAll(associateManagedCompList);
				}
			}

			if(listOfComponents != null && listOfComponents.size()>0)
			{
				for(int j=0;j<listOfComponents.size();j++)
				{
					String nickName = (String)listOfComponents.get(j);
					nickName = nickName.substring(nickName.indexOf(":")+1);

					List agentList = getAgents(thisType, nickName);
					if(agentList != null && agentList.size() >0)
					{
						for(int k=0;k<agentList.size();k++)
						{
							ArrayList agentNameList = new ArrayList();
							agentNameList.add(nickName);
							String thisSubject = (String) agentList.get(k);
							if(nickAgentMap.containsKey(thisSubject))
							{
								ArrayList lst = (ArrayList) nickAgentMap.get(thisSubject);
								if(!lst.contains(nickName))
									lst.add(nickName);
								nickAgentMap.put(thisSubject, lst);
							}
							else
							{
								nickAgentMap.put(thisSubject, agentNameList);
							}
						}
					}
				}
			}

			String[] strTests = egSpecs.getTestsForServer(thisType);
			if (strTests != null && strTests.length > 0)
			{
				testEnabled = new ArrayList(Arrays.asList(strTests));
			}

			ArrayList availPatterns = new ArrayList();
			Enumeration ee = nickAgentMap.keys();
			if(from.startsWith("hmc"))
			{
				while(ee.hasMoreElements())
				{
					String thisElement = (String) ee.nextElement();
					String [] variables = agIniFile.getVariables(thisElement);
					ArrayList nickList = (ArrayList) nickAgentMap.get(thisElement);
					for(int j=0;nickList != null && j<nickList.size();j++)
					{
						String thisNick = (String) nickList.get(j);
						for (int k=0;k<testEnabled.size();k++)
						{
							String thisTest = (String) testEnabled.get(k);
							String thisPattern = getResultantPattern(thisType,thisNick,thisTest,variables);
							if(thisPattern != null && !thisPattern.equals("null") && thisPattern.length() > 0)
							{
								String value = agIniFile.getValue(thisElement,thisPattern);
								int hmcIndex = value.toLowerCase().indexOf("-hmc_server");
								if (hmcIndex > -1)
								{
									String tmpStr1 = value.substring(0,hmcIndex + "-hmc_server".length()).trim();
									String tmpStr2 = value.substring(hmcIndex + "-hmc_server".length() +1).trim();
									String hmc_server = tmpStr2.substring(0,tmpStr2.indexOf(" ")).trim();
									if (hmc_server.equals(ipAddress))
									{
										int esxUserIndex = value.toLowerCase().indexOf("-hmc_user");
										if (esxUserIndex > -1)
										{
											tmpStr1 = value.substring(0,esxUserIndex + "-hmc_user".length()).trim();
											tmpStr2 = value.substring(esxUserIndex + "-hmc_user".length() +1).trim();
											tmpStr2 = tmpStr2.substring(tmpStr2.indexOf(" ")).trim();
											value = tmpStr1 + " "+UName+ " "+tmpStr2;
										}
										int esxPwdIndex = value.toLowerCase().indexOf("-hmc_password");
										if(esxPwdIndex > -1)
										{
											tmpStr1 = value.substring(0,esxPwdIndex + "-hmc_password".length()).trim();
											tmpStr2 = value.substring(esxPwdIndex + "-hmc_password".length() +1).trim();
											tmpStr2 = tmpStr2.substring(tmpStr2.indexOf(" ")).trim();
											value = tmpStr1 + " "+UPass+ " "+tmpStr2;
										}
										int sslIndex = value.toLowerCase().indexOf("-ssl");
										if (sslIndex > -1)
										{
											tmpStr1 = value.substring(0,sslIndex + "-ssl".length()).trim();
											tmpStr2 = value.substring(sslIndex + "-ssl".length() +1).trim();
											tmpStr2 = tmpStr2.substring(tmpStr2.indexOf(" ")).trim();
											value = tmpStr1 + " "+ssl.toLowerCase()+ " "+tmpStr2;
										}
										agIniFile.setValue(thisElement,thisPattern,value);
										if (!testListForAuditlog.contains(thisTest))
										{
											testListForAuditlog.add(thisTest);
										}

										if (!compListForAuditlog.contains(thisNick))
										{
											compListForAuditlog.add(thisNick);
										}
									}
								}
							}
						}
					}
				}
				agIniFile.saveFile();
			}
			else if(from.startsWith("nutanix"))
			{
				while(ee.hasMoreElements())
				{
					String thisElement = (String) ee.nextElement();
					String [] variables = agIniFile.getVariables(thisElement);
					ArrayList nickList = (ArrayList) nickAgentMap.get(thisElement);
					for(int j=0;nickList != null && j<nickList.size();j++)
					{
						String thisNick = (String) nickList.get(j);
						for (int k=0;k<testEnabled.size();k++)
						{
							String thisTest = (String) testEnabled.get(k);
							String thisPattern = getResultantPattern(thisType,thisNick,thisTest,variables);
							if(thisPattern != null && !thisPattern.equals("null") && thisPattern.length() > 0)
							{
								String value = agIniFile.getValue(thisElement,thisPattern);
								int nutanixIndex = value.toLowerCase().indexOf("-prism_ip");
								if (nutanixIndex > -1)
								{
									String tmpStr1 = value.substring(0,nutanixIndex + "-Prism_IP".length()).trim();
									String tmpStr2 = value.substring(nutanixIndex + "-Prism_IP".length() +1).trim();
									String nutanix_server = tmpStr2.substring(0,tmpStr2.indexOf(" ")).trim();
									if (nutanix_server.equals(ipAddress))
									{
										int esxUserIndex = value.toLowerCase().indexOf("-prism_user");
										if (esxUserIndex > -1)
										{
											tmpStr1 = value.substring(0,esxUserIndex + "-prism_user".length()).trim();
											tmpStr2 = value.substring(esxUserIndex + "-prism_user".length() +1).trim();
											tmpStr2 = tmpStr2.substring(tmpStr2.indexOf(" ")).trim();
											value = tmpStr1 + " "+UName+ " "+tmpStr2;
										}
										int esxPwdIndex = value.toLowerCase().indexOf("-prism_password");
										if(esxPwdIndex > -1)
										{
											tmpStr1 = value.substring(0,esxPwdIndex + "-prism_password".length()).trim();
											tmpStr2 = value.substring(esxPwdIndex + "-prism_password".length() +1).trim();
											tmpStr2 = tmpStr2.substring(tmpStr2.indexOf(" ")).trim();
											value = tmpStr1 + " "+UPass+ " "+tmpStr2;
										}
										int sslIndex = value.toLowerCase().indexOf("-ssl");
										if (sslIndex > -1)
										{
											tmpStr1 = value.substring(0,sslIndex + "-ssl".length()).trim();
											tmpStr2 = value.substring(sslIndex + "-ssl".length() +1).trim();
											tmpStr2 = tmpStr2.substring(tmpStr2.indexOf(" ")).trim();
											value = tmpStr1 + " "+ssl.toLowerCase()+ " "+tmpStr2;
										}
										agIniFile.setValue(thisElement,thisPattern,value);
										if (!testListForAuditlog.contains(thisTest))
										{
											testListForAuditlog.add(thisTest);
										}

										if (!compListForAuditlog.contains(thisNick))
										{
											compListForAuditlog.add(thisNick);
										}
									}
								}
							}
						}
					}
				}
				agIniFile.saveFile();
			}
			else
			{
				while(ee.hasMoreElements())
				{
					String thisElement = (String) ee.nextElement();
					String [] variables = agIniFile.getVariables(thisElement);
					ArrayList nickList = (ArrayList) nickAgentMap.get(thisElement);
					for(int j=0;nickList != null && j<nickList.size();j++)
					{
						String thisNick = (String) nickList.get(j);
						for (int k=0;k<testEnabled.size();k++)
						{
							String thisTest = (String) testEnabled.get(k);
							String thisPattern = getResultantPattern(thisType,thisNick,thisTest,variables);
							if(thisPattern != null && !thisPattern.equals("null") && thisPattern.length() > 0)
							{
								String value = agIniFile.getValue(thisElement,thisPattern);
								int vCenterIndex = value.toLowerCase().indexOf("-virtual_center");
								if (vCenterIndex > -1)
								{
									String tmpStr1 = value.substring(0,vCenterIndex + "-virtual_center".length()).trim();
									String tmpStr2 = value.substring(vCenterIndex + "-virtual_center".length() +1).trim();
									String virtual_center = tmpStr2.substring(0,tmpStr2.indexOf(" ")).trim();
									if (virtual_center.equals(ipAddress))
									{
										int esxUserIndex = value.toLowerCase().indexOf("-esx_user");
										if (esxUserIndex > -1)
										{
											tmpStr1 = value.substring(0,esxUserIndex + "-esx_user".length()).trim();
											tmpStr2 = value.substring(esxUserIndex + "-esx_user".length() +1).trim();
											tmpStr2 = tmpStr2.substring(tmpStr2.indexOf(" ")).trim();
											value = tmpStr1 + " "+UName+ " "+tmpStr2;
										}
										int esxPwdIndex = value.toLowerCase().indexOf("-esx_password");
										if(esxPwdIndex > -1)
										{
											tmpStr1 = value.substring(0,esxPwdIndex + "-Esx_password".length()).trim();
											tmpStr2 = value.substring(esxPwdIndex + "-Esx_password".length() +1).trim();
											tmpStr2 = tmpStr2.substring(tmpStr2.indexOf(" ")).trim();
											value = tmpStr1 + " "+UPass+ " "+tmpStr2;
										}
										int sslIndex = value.toLowerCase().indexOf("-ssl");
										if (sslIndex > -1)
										{
											tmpStr1 = value.substring(0,sslIndex + "-ssl".length()).trim();
											tmpStr2 = value.substring(sslIndex + "-ssl".length() +1).trim();
											tmpStr2 = tmpStr2.substring(tmpStr2.indexOf(" ")).trim();
											value = tmpStr1 + " "+ssl.toLowerCase()+ " "+tmpStr2;
										}
										int webPortIndex = value.toLowerCase().indexOf("-webport");
										if(webPortIndex > -1)
										{
											tmpStr1 = value.substring(0,webPortIndex + "-webport".length()).trim();
											tmpStr2 = value.substring(webPortIndex + "-webport".length() +1).trim();
											tmpStr2 = tmpStr2.substring(tmpStr2.indexOf(" ")).trim();
											value = tmpStr1 + " "+webPort+ " "+tmpStr2;
										}
										agIniFile.setValue(thisElement,thisPattern,value);
										if (!testListForAuditlog.contains(thisTest))
										{
											testListForAuditlog.add(thisTest);
										}

										if (!compListForAuditlog.contains(thisNick))
										{
											compListForAuditlog.add(thisNick);
										}
									}
								}
							}
						}
					}
				}
				agIniFile.saveFile();
			}
		}
		EgConfigFilesSync.releaseInstance(agIniFile);
	}

	//provide a set of agents(internal or remote agent,external agent(s)) for a component
	private List getAgents(String componentType,String componentName)
	{
		EgExternalInfo egExternalInfo = new EgExternalInfo("manager");
		List agentsList = new ArrayList();
		Hashtable internalAgentMap = egExternalInfo.getInternalAgentMap();
		String tempCompType = new String(componentType);
		String tempCompName = new String(componentName);
		String agentNickName = "";
		boolean isRemote = false;
		if (tempCompName.indexOf(":") > -1)
		{
			if (tempCompType.equals("Oracle_server"))
			{
				tempCompName = tempCompName.substring(0,tempCompName.indexOf(":"));
			}
			else
			{
				tempCompName = tempCompName.substring(0,tempCompName.lastIndexOf(":"));
			}
		}
		// To fetch the exact agent for the selected component - start
		isRemote = egExternalInfo.isRemoteBased(tempCompName);
		if (isRemote)
		{
			//Agentless
			agentNickName = egExternalInfo.getRemoteAgentForHost(tempCompName);
		}
		else
		{
			//Auto or Manual
			String agentName = egExternalInfo.getAgentFor(tempCompName);
			if (agentName != null) //Manual
			{
				if (internalAgentMap != null && internalAgentMap.containsKey(agentName))
				{
					agentNickName = (String)internalAgentMap.get(agentName);
				}
				else
				{
					agentNickName = agentName;
				}
			}
			else //Auto
			{
				agentNickName = tempCompName;
			}
		}
		//adding an internal agent (or) a remote agent
		agentsList.add(agentNickName);
		// To fetch the exact agent for the selected component - end

		//To fetch the external agent for the selected component type - starts
		boolean hasExternalAgent = egExternalInfo.hasExternalAgent(tempCompName);
		if (hasExternalAgent)
		{
			String extAgents[] = egExternalInfo.getExternalAgentsForHost(tempCompName);
			//adding one or more external agent(s)
			agentsList.addAll(Arrays.asList(extAgents));
		}
		//To fetch the external agent for the selected component type - ends

		return agentsList;
	}

	private String getResultantPattern(String componentType, String compName, String testName, String[] testVariables)
	{
		String tempResultantPattern = null;
		String specificPattern_A = testName + ":" + componentType + ":" + compName;
		String specificPattern_B = testName + ":" + componentType + ":" + compName.substring(0,compName.indexOf(":"));
		String defaultPattern_A = testName + "::" + compName;
		String defaultPattern_B = testName + "::" + compName.substring(0,compName.indexOf(":"));
		List listTestVariables = Arrays.asList(testVariables);
		if(listTestVariables.contains(specificPattern_A))
		{
			tempResultantPattern = specificPattern_A;
		}
		else if(listTestVariables.contains(specificPattern_B))
		{
			tempResultantPattern = specificPattern_B;
		}
		else if(listTestVariables.contains(defaultPattern_A))
		{
			tempResultantPattern = defaultPattern_A;
		}
		else if(listTestVariables.contains(defaultPattern_B))
		{
			tempResultantPattern = defaultPattern_B;
		}
		return tempResultantPattern;
	}

	private Hashtable getVcUpdatedDetails(ArrayList aListTemp)
	{
		int vcidx = aListTemp.indexOf("-virtual_center");
		String virtual_centerValue = (String)aListTemp.get(vcidx+1);
		Hashtable result = new Hashtable();
		
		if (aListTemp == null || aListTemp.isEmpty())
			return result;

		if (!virtual_centerValue.equalsIgnoreCase("other") && !virtual_centerValue.equalsIgnoreCase("none"))
		{
			IniFile eg_servicesIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_services.ini");

			boolean isAnyOneChanged = false;

			int esxUserIdx = aListTemp.indexOf("-Esx_user");
			String strEsxUserValue = (String)aListTemp.get(esxUserIdx+1);
			String curUname = strEsxUserValue;

			int esxPasswordIdx = aListTemp.indexOf("-Esx_password");
			String strEsxPasswordValue = (String)aListTemp.get(esxPasswordIdx+1);
			//strEsxPasswordValue = EgCrypt.decrypt(strEsxPasswordValue);
			String strTokenSalt = strEsxPasswordValue;
			if (!isNumber(strTokenSalt))
			{
				strTokenSalt = EgCrypt.decrypt(strTokenSalt);
			}
			if (strTokenSalt.indexOf("~EG~") != -1)
			{
				strEsxPasswordValue = strTokenSalt.substring(0,strTokenSalt.indexOf("~EG~"));
			}
			else
			{
				strEsxPasswordValue = strTokenSalt;
			}
			String curPwd = strEsxPasswordValue;
			strEsxPasswordValue = EgCrypt.encrypt(strEsxPasswordValue);

			int esxSslIdx = aListTemp.indexOf("-ssl");
			String strSslValue = (String)aListTemp.get(esxSslIdx+1);
			String checkSSL = strSslValue;

			int webPortIdx = aListTemp.indexOf("-webPort");
			String webPort = (String)aListTemp.get(webPortIdx+1);
			String curWebPort = webPort;

			String isDiscovery = "No";
			String preSSL = "";
			String preUname = "";
			String preUPass = "";
			String preWebPort = "";

			String virtualCenterPattern = eg_servicesIni.getValue("VIRTUAL_CENTER",virtual_centerValue);
			StringTokenizer sst = new StringTokenizer(virtualCenterPattern,"#");
			if (sst.hasMoreTokens())
			{
				preSSL = sst.nextToken();
				preUname = sst.nextToken();
				preUPass = sst.nextToken();
				isDiscovery = sst.nextToken();
				preWebPort = sst.nextToken();

				//preUPass = EgCrypt.decrypt(preUPass);
				if (!isNumber(preUPass))
				{
					preUPass = EgCrypt.decrypt(preUPass);
				}
				if (preUPass.indexOf("~EG~") != -1)
				{
					preUPass = preUPass.substring(0,preUPass.indexOf("~EG~"));
				}
			}

			isAnyOneChanged = (!((checkSSL.equals(preSSL)) && (curUname.equals(preUname)) && (curPwd.equals(preUPass)) && (curWebPort.equals(preWebPort))));

			String pattern = strSslValue + "#" + strEsxUserValue + "#" + strEsxPasswordValue + "#" + isDiscovery + "#" + webPort;

			result.put("isAnyOneChanged",isAnyOneChanged);
			result.put("ipAddress",virtual_centerValue);
			result.put("pattern",pattern);
		}
		return result;
	}

	private Hashtable getNutanixUpdatedDetails(ArrayList aListTemp)
	{
		int cvmipidx = aListTemp.indexOf("-Prism_IP");
		String cvm_ipValue = (String)aListTemp.get(cvmipidx+1);
		Hashtable result = new Hashtable();
		
		if (aListTemp == null || aListTemp.isEmpty())
			return result;

		if (!cvm_ipValue.equalsIgnoreCase("other") && !cvm_ipValue.equalsIgnoreCase("none"))
		{
			IniFile eg_servicesIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_services.ini");

			boolean isAnyOneChanged = false;

			int cvmUserIdx = aListTemp.indexOf("-Prism_user");
			String strCVMUserValue = (String)aListTemp.get(cvmUserIdx+1);
			String curUname = strCVMUserValue;

			int cmvPasswordIdx = aListTemp.indexOf("-Prism_password");
			String strCVMPasswordValue = (String)aListTemp.get(cmvPasswordIdx+1);
			//strCVMPasswordValue = EgCrypt.decrypt(strCVMPasswordValue);
			String strTokenSalt = strCVMPasswordValue;
			if (!isNumber(strTokenSalt))
			{
				strTokenSalt = EgCrypt.decrypt(strTokenSalt);
			}
			if (strTokenSalt.indexOf("~EG~") != -1)
			{
				strCVMPasswordValue = strTokenSalt.substring(0,strTokenSalt.indexOf("~EG~"));
			}
			else
			{
				strCVMPasswordValue = strTokenSalt;
			}
			String curPwd = strCVMPasswordValue;
			strCVMPasswordValue = EgCrypt.encrypt(strCVMPasswordValue);

			int cvmSslIdx = aListTemp.indexOf("-ssl");
			String strSslValue = (String)aListTemp.get(cvmSslIdx+1);
			String checkSSL = strSslValue;

			int webPortIdx = aListTemp.indexOf("-webPort");
			String webPort = (String)aListTemp.get(webPortIdx+1);
			String curWebPort = webPort;

			String isDiscovery = "No";
			String preSSL = "";
			String preUname = "";
			String preUPass = "";
			String preWebPort = "";

			String nutanixPattern = eg_servicesIni.getValue("NUTANIX",cvm_ipValue);
			StringTokenizer sst = new StringTokenizer(nutanixPattern,"#");
			if (sst.hasMoreTokens())
			{
				preSSL = sst.nextToken();
				preUname = sst.nextToken();
				preUPass = sst.nextToken();
				isDiscovery = sst.nextToken();
				preWebPort = sst.nextToken();

				//preUPass = EgCrypt.decrypt(preUPass);
				if (!isNumber(preUPass))
				{
					preUPass = EgCrypt.decrypt(preUPass);
				}
				if (preUPass.indexOf("~EG~") != -1)
				{
					preUPass = preUPass.substring(0,preUPass.indexOf("~EG~"));
				}
			}

			isAnyOneChanged = (!((checkSSL.equals(preSSL)) && (curUname.equals(preUname)) && (curPwd.equals(preUPass)) && (curWebPort.equals(preWebPort))));

			String pattern = strSslValue + "#" + strCVMUserValue + "#" + strCVMPasswordValue + "#" + isDiscovery + "#" + webPort;

			result.put("isAnyOneChanged",isAnyOneChanged);
			result.put("ipAddress",cvm_ipValue);
			result.put("pattern",pattern);
		}
		return result;
	}

	private boolean checkParamsExist(String pwdProfileParams, String aResultant)
	{
		//String aResultant  = strBuffer.toString();
		boolean isAnyOneNull = (com.egurkha.util.StringUtils.isNull(pwdProfileParams) || 
								com.egurkha.util.StringUtils.isNull(aResultant));

		if (isAnyOneNull)
		{
			return false;
		}

		boolean isAllParamsMatch = false;
		//-manual, -host TEST -port NULL -virtual_center None -Esx_user SSSS -Esx_password 5DC53085159943A8D9C31ADD6F2E52E7 -webPort 443 -ssl true -ignore_vms_inside_view none -ignore_winNT true -exclude_vms none -Inside_view_using tcp -domain none|none|none -admin_user EGUSER|ADMIN|XDADMIN -admin_password 740C22FD387D81FE59C3D01F10029C3B3 -Report_By_User true -Report_Powered_Os true -agentless y -mCount 34 -ddFreq 1:1 -aluser None -alpassword CCF1978907AD00AB972C9B9138C9744A -almode Other -os vmware -sshPort 22 -alencrypt None -alkeyfile None -rptName TEST2, 300

		StringTokenizer st = new StringTokenizer(pwdProfileParams,",");
		int totalPwdParams = st.countTokens();
		int paramCnt = 0;
		while(st.hasMoreTokens())
		{
			String token = (String) st.nextToken();
			if (aResultant.indexOf("-"+token) != -1)
			{
				paramCnt++;
			}
		}

		if (paramCnt == totalPwdParams)
		{
			isAllParamsMatch = true;
		}

		return isAllParamsMatch;
	}

	private boolean checkPwdProfileParams(ArrayList aListChoosenParametersInLowerCase, String chkString)
	{
		boolean isAnyOneNull = (com.egurkha.util.StringUtils.isNull(chkString) || 
								aListChoosenParametersInLowerCase == null);

		if (isAnyOneNull)
		{
			return false;
		}

		boolean isAllParamsMatch = false;
		Iterator st = aListChoosenParametersInLowerCase.iterator();
		while(st.hasNext())
		{
			String token = (String) st.next();
			if (token.startsWith(chkString))
			{
				isAllParamsMatch = true;
				break;
			}
		}
		return isAllParamsMatch;
	}

	private boolean isEncryptFlagFalse(ArrayList paramList)
	{
		if(paramList != null && paramList.contains("-encryptflag"))
		{
			int encryptIdx = paramList.indexOf("-encryptflag");
			String isEncrypt = (String)paramList.get(encryptIdx+1);
			if(isEncrypt.equalsIgnoreCase("false"))
			{
				return true;
			}
		}
		return false;
	}
%>



