<%
/*************************************************************************************************/
/*                 Name          : EgAutoTopologyGroupJson.jsp                                       */
/*                 Purpose       : This page is used to list components under a group            */
/*                 Version       : 5.7                                                           */
/*                 Created On    : 10-05-2012                                                    */
/*************************************************************************************************/
%>
<%@ include file="../../EgTrackerAJSON.jsp" %>
<%@ page import = "java.util.*"%>
<%@ page import = "com.eg.EgGroupInfo"%>
<%@ page import = "com.eg.EgDbInfo"%>
<%@ page import = "com.eg.EgInstallInfo"%>
<%@ page import = "com.eg.IniFile"%>
<%@ page import = "com.eg.EgComponentType"%>
<%@ page import = "com.eg.EgName"%>
<%@ page import = "com.eg.MappingNameSorter"%>
<%@ page import = "com.egurkha.ini.IniUI"%>
<%@ page import = "net.sf.json.*"%>
<%@ page language = "java" contentType = "text/html; charset=UTF-8" pageEncoding = "UTF-8" %>
<%
	JSONObject rootJson = new JSONObject();
	JSONObject screenLabels = new JSONObject();
	JSONObject hiddenValues = new JSONObject();
	JSONObject detailsObj = new JSONObject();
	JSONArray detailsArr = new JSONArray();
	JSONObject newCompObj = new JSONObject();
	JSONArray newCompArr = new JSONArray();
	JSONObject allCompObj = new JSONObject();
	JSONArray allCompArr = new JSONArray();

	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);

	String segment = request.getParameter("segment");
	String zone = request.getParameter("zone");
	String src = request.getParameter("src"); //componentType
	String comp = request.getParameter("comp"); //componentName
	String option = request.getParameter("option");
	String selectedComponent = request.getParameter("selectedComponent");
	String status = request.getParameter("compStatus");
	String groupName = request.getParameter("title");
	String compStatus="";
	if(status!=null && status.length()>0)
	{
		compStatus=status;
	}
	boolean newStatus=false;
	if(compStatus.equals("NEW") || compStatus.equals("UNMANAGE"))
	{
		newStatus=true;
	}
	Hashtable compTable = new Hashtable();
	Hashtable grpElementTable = (Hashtable)session.getAttribute("autoTopoGroupTable");
	boolean otherSegment=false;
	IniFile egTopoIni =  new IniFile(EgInstallInfo.getInstallDir() + 
															"/manager/config/eg_topology.ini");
	String segmentNames[] = egTopoIni.getVariables("TOPOLOGY_SEGMENTS");
	
	boolean isNewGroup = false;
	EgGroupInfo groupInfo = new EgGroupInfo();
	String[] allGroupNames=null;
	ArrayList myList = new ArrayList();
	ArrayList tempList = new ArrayList();

	ArrayList disabledList = new ArrayList();
	IniFile autoIniFile = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_autotopology.ini");
	
	if(zone!=null && !zone.equals("-1"))
	{
		TreeSet mySet =  groupInfo.getAllGroupsUnderZone(zone, true);
		if(mySet!=null && mySet.size() > 0)
		{
			myList.addAll(mySet);
			for(int m=0;m<myList.size();m++)
			{
				String fullName = (String)myList.get(m);
				fullName=fullName.substring(fullName.indexOf(":")+1,fullName.lastIndexOf(":"));
				tempList.add(fullName);
			}
			allGroupNames = new String[tempList.size()];
			for (int a = 0; a < tempList.size(); a++) 
			{
				allGroupNames[a] = tempList.get(a).toString();
			}
		}
	}
	else
	{
		allGroupNames = groupInfo.getGroupNames();
	}
	if(option!=null && option.equals("newgroup"))
		isNewGroup = true;

	ArrayList cbValueArray = new ArrayList();
	//adding new code
			if(option.equals("oldgroup"))
			{
				
				if(groupName!=null && groupName.length() > 0)
				{
					ArrayList compList = groupInfo.getAllComponentsUnderGroup(groupName);
					//System.out.println("compList size jyj "+compList.size());
					for(int q=0;q<compList.size();q++)
					{
						String comp1 = (String) compList.get(q);
						String compType = comp1.substring(0,comp1.indexOf(":"));
						String compName = comp1.substring(comp1.indexOf(":")+1);
						if(compTable.containsKey(compType))
						{
							ArrayList a = (ArrayList) compTable.get(compType);
							a.add(compName);
							compTable.put(compType,a);
						}
						else
						{
							ArrayList a = new ArrayList();
							a.add(compName);
							compTable.put(compType,a);
						}
					}
				
				}
				Set keySet = compTable.keySet();
				Iterator itr = keySet.iterator();
				while(itr.hasNext())
				{
					String key = (String)itr.next();
					String mappingCompType = _mapping.getComponentTypeDescription(key);
					ArrayList nameList = (ArrayList)compTable.get(key);
					if(nameList==null || nameList.size() == 0)
					{
						continue;
					}
					else
					{
						for(int k=0;k<nameList.size();k++)
						{
							String element = (String) nameList.get(k);
							StringTokenizer st = new StringTokenizer(element,":");
							int count = st.countTokens();
							String hostName = "";
							String portNo = "";
							String sid = "-";
							String checked="";
							checked="checked";
							boolean isOraServer = false;
							if(count == 2)
							{
								hostName = st.nextToken();
								portNo = st.nextToken();
							}
							else if(count == 3)	// Only for Oracle_Database Component
							{
								hostName = st.nextToken();
								portNo = st.nextToken();
								sid = st.nextToken();
								isOraServer = true;
							}
//							if(portNo!=null && portNo.equalsIgnoreCase("NULL"))
//								portNo = "-";
							if(portNo.equals("NULL"))
								portNo ="-";
							
							if(isOraServer)
							{
								hostName = hostName+"("+sid+")";
							}
							detailsObj.put("Hostname",hostName);
							detailsObj.put("Port",portNo);
							detailsObj.put("Componenttype",mappingCompType);
							detailsObj.put("Checked",checked);
							detailsObj.put("Cbvalue",key+":"+element);
							detailsArr.add(detailsObj);
							cbValueArray.add(key+":"+element);
						}
					}
				}
			}
			
		
	ArrayList managedCompList = new ArrayList();
	managedCompList = getManagedComponents(segment);
	//ArrayList newCompList = getNewComponents(segment);

	boolean isNewCompExists = false;
	boolean isUnManageExists = false;
	ArrayList newCompList = new ArrayList();
	ArrayList unManageList = new ArrayList();
	Hashtable myTable = getUnmanageAndNewComponents(segment);
	newCompList = (ArrayList) myTable.get("NEW");
	unManageList = (ArrayList) myTable.get("UNMANAGE");
	//if(unManageList!=null && unManageList.size() > 0)
		//isUnManageExists = true;
	
	rootJson.put("NewSelectedComponent",selectedComponent);
	for(int n=0;n<unManageList.size();n++)
	{
		String unManageComp = (String)unManageList.get(n);
		if(!newCompList.contains(unManageComp))
			newCompList.add(unManageComp);
	}
	if(newCompList!=null && newCompList.size() > 0)
		isNewCompExists = true;
	
	rootJson.put("isNewGroup",isNewGroup);
	boolean groupFound=false;
	if(isNewGroup)
	{
		groupFound = true;
		rootJson.put("groupFound",groupFound);
	}
	else
	{
		if(allGroupNames!=null && allGroupNames.length > 0)
		{
			groupFound=true;
		}
		else
		{
			groupFound=false;
		}
		rootJson.put("groupFound",groupFound);
	}
	if(groupFound)
	{

		Hashtable segmentHash = new Hashtable();
		ArrayList otherSegCompList = new ArrayList();
		
		//  to make elements checked 
		ArrayList newList=new ArrayList();
		ArrayList keyList1=new ArrayList();
		if(grpElementTable!=null && grpElementTable.size()>0)
		{
			Enumeration allKeys1 = grpElementTable.keys();
			while(allKeys1.hasMoreElements())
			{
				String groupKey1 = (String)allKeys1.nextElement();
				if(!keyList1.contains(groupKey1))
					keyList1.add(groupKey1);
			}
			for(int k=0;k<keyList1.size();k++)
			{
				String key1 = (String)keyList1.get(k);
				ArrayList groupList1 = (ArrayList)grpElementTable.get(key1);
				for(int l=0;l<groupList1.size();l++)
				{
					String gg = (String)groupList1.get(l);
					newList.add(gg);
				}
			}
		}
		//end
		for(int k=0;k<managedCompList.size();k++)
		{
			String otherSegName="";
			String disabled="";
			String checked ="";
			String element = (String) managedCompList.get(k);
			if(segmentNames!=null){
				for(int s=0;s<segmentNames.length;s++)
				{
					String allSegments = (String)segmentNames[s];
					if(!allSegments.equals(segment))
					{
						String[] aLines = egTopoIni.getLinesUnderSubject(allSegments);
						if(aLines!=null){
							for(int a=0;a<aLines.length;a++)
							{
								String line = (String)aLines[a];
								if(line.indexOf(element)>-1)
								{
									otherSegName = allSegments;
									if(segmentHash.containsKey(otherSegName))
									{
										ArrayList list = (ArrayList) segmentHash.get(otherSegName);
										list.add(element);
										segmentHash.put(otherSegName,(ArrayList)list);
									}
									else
									{
										ArrayList list = new ArrayList();
										list.add(element);
										segmentHash.put(otherSegName,(ArrayList)list);
									}
									if(!otherSegCompList.contains(element))
										otherSegCompList.add(element);
								}
							}
						}
					}
				}
			}
			StringTokenizer st = new StringTokenizer(element,":");
			int count = st.countTokens();
			String compType = "";
			String hostName = "";
			String portNo = "";
			String sid = "-";
			boolean isOraServer = false;
			if(count == 3)
			{
				compType = st.nextToken();
				hostName = st.nextToken();
				portNo = st.nextToken();
			}
			else if(count == 4)	// Only for Oracle_Database Component
			{
				compType = st.nextToken();
				hostName = st.nextToken();
				portNo = st.nextToken();
				sid = st.nextToken();
				isOraServer = true;
			}
			if(newList!=null && newList.contains(element))
			{
				checked="checked";
			}
			if(portNo.equals("NULL"))
				portNo ="-";
			
			//if(!otherSegCompList.contains(element))
			//{
				if(selectedComponent!=null && !selectedComponent.equals(""))
				{
					if(compType.equals(selectedComponent))
					{
						//checked="checked";
						if(isOraServer)
						{
							hostName = hostName+"("+sid+")";
						}
						if(!cbValueArray.contains(element))
						{
							detailsObj.put("Hostname",hostName);
							detailsObj.put("Port",portNo);
							detailsObj.put("Checked",checked);
							detailsObj.put("Cbvalue",element);
							detailsArr.add(detailsObj);
						}
						/*allCompObj.put("Hostname",hostName);
						allCompObj.put("Port",portNo);
						allCompObj.put("Checked",checked);
						allCompObj.put("Cbvalue",element);
						allCompArr.add(allCompObj);*/
					}
				}
			//}
		}
		rootJson.put("ComponentDetails",detailsArr);
		rootJson.put("AssociatedToSegment","false");
		if(segmentHash!=null && segmentHash.size()>0)
		{
			Enumeration keys = segmentHash.keys();
			while(keys.hasMoreElements())
			{
				String seg = (String)keys.nextElement();
				ArrayList componentList = (ArrayList)segmentHash.get(seg);
				for(int s=0;s<componentList.size();s++)
				{
					String compList = (String)componentList.get(s);
					if(compList.indexOf(selectedComponent)!=-1)
					{
						rootJson.put("AssociatedToSegment","true");
						rootJson.put("AssociatedToSegmentName",seg);
					}
				}
			}
		}
		//to display new components
		rootJson.put("isNewCompExists",false);
		if(!managedCompList.contains(selectedComponent) && isNewCompExists)
		{
			rootJson.put("isNewCompExists",true);
			for(int k=0;k<newCompList.size();k++)
			{
				String element = (String) newCompList.get(k);
				StringTokenizer st = new StringTokenizer(element,":");
				int count = st.countTokens();
				String compType = "";
				String hostName = "";
				String portNo = "";
				String sid = "-";
				boolean isOraServer = false;
				if(count == 3)
				{
					compType = st.nextToken();
					hostName = st.nextToken();
					portNo = st.nextToken();
				}
				else if(count == 4)	// Only for Oracle_Database Component
				{
					compType = st.nextToken();
					hostName = st.nextToken();
					portNo = st.nextToken();
					sid = st.nextToken();
					isOraServer = true;
				}
				String title=hostName+":"+portNo;
				if(compType.equals(selectedComponent))
				{
					if(isOraServer)
					{
						hostName = hostName+"("+sid+")";
					}
					newCompObj.put("Componentname",hostName+":"+portNo);
					newCompObj.put("CbNewvalue",element);
					newCompArr.add(newCompObj);

					/*allCompObj.put("Componentname",hostName+":"+portNo);
					allCompObj.put("CbNewvalue",element);
					allCompArr.add(allCompObj);*/
				}
			}
		}
		rootJson.put("NewComponentDetails",newCompArr);
	}
	out.println(rootJson.toString());
	
%>

<%!
	/*
		This method returns, list of managed components form the given segment name
	*/
	private ArrayList getManagedComponents(String segmentName)
	{
		String iniFilePath = EgInstallInfo.getInstallDir() + "/manager/config/eg_autotopology.ini";
		String disIniFilePath = EgInstallInfo.getInstallDir() + "/manager/config/eg_discover.ini";
		IniFile iniFile = new IniFile(iniFilePath);
		IniFile disIniFile = new IniFile(disIniFilePath);
		ArrayList result = new ArrayList();
		Set thisSet = new TreeSet();
		String[] varArray = iniFile.getVariables(segmentName);

		for(int k=0;k<varArray.length;k++)
		{
			String varName = varArray[k];
			String thisCompName = varName.substring(0,varName.indexOf(":"));
			String checkValue = disIniFile.getValue(thisCompName,varName);
			if(checkValue!=null && checkValue.length() > 0){
				thisSet.add(varName);
			}
			
			String valName = iniFile.getValue(segmentName,varName);
			if(valName!=null && valName.equals("null"))
				continue;
			StringTokenizer st = new StringTokenizer(valName,",");
			while(st.hasMoreTokens()){
				String tok = st.nextToken();
				String tmpcompname = tok.substring(0,tok.indexOf(":"));
				String tmpvar = tok.substring(0,tok.lastIndexOf(":"));
				String chkval = disIniFile.getValue(tmpcompname,tmpvar);
				if(chkval!=null && chkval.length() > 0){
					thisSet.add(tmpvar);
				}
			}
		}
		if(thisSet!=null && thisSet.size() > 0){
			result = new ArrayList(thisSet);
		}
		return result;
	}

	private Hashtable getUnmanageAndNewComponents(String segmentName)
	{
		String iniFilePath = EgInstallInfo.getInstallDir() + "/manager/config/eg_autotopology.ini";
		String disIniFilePath = EgInstallInfo.getInstallDir() + "/manager/config/eg_discover.ini";
		IniFile iniFile = new IniFile(iniFilePath);
		IniFile disIniFile = new IniFile(disIniFilePath);
		String newstr = "#New|";
		String unmanagestr = "#Unmanage|";
		
		Hashtable result = new Hashtable();
		ArrayList newList = new ArrayList();
		ArrayList unmanageList = new ArrayList();
		Set newSet = new TreeSet();
		Set unmanageSet = new TreeSet();

		String[] varArray = iniFile.getVariables(segmentName);

		for(int k=0;k<varArray.length;k++)
		{
			String varName = varArray[k];
			String thisCompName = varName.substring(0,varName.indexOf(":"));
			String newValue = disIniFile.getValue(thisCompName,newstr+varName);
			if(newValue!=null && newValue.length() > 0)	// Check for new component
			{
				newSet.add(varName);
			}
			else	// Check for unmanage component
			{
				String unmanageValue = disIniFile.getValue(thisCompName,unmanagestr+varName);
				if(unmanageValue!=null && unmanageValue.length() > 0)
				{
					unmanageSet.add(varName);
				}
			}

			String valName = iniFile.getValue(segmentName,varName);
			if(valName!=null && valName.equals("null"))
				continue;
			StringTokenizer st = new StringTokenizer(valName,",");
			while(st.hasMoreTokens())
			{
				String tok = st.nextToken();
				String tmpcompname = tok.substring(0,tok.indexOf(":"));
				String tmpvar = tok.substring(0,tok.lastIndexOf(":"));
				String newval = disIniFile.getValue(tmpcompname,newstr+tmpvar);
				if(newval!=null && newval.length() > 0)
				{
					newSet.add(tmpvar);
				}
				else
				{
					String unmanageValue = disIniFile.getValue(tmpcompname,unmanagestr+tmpvar);
					if(unmanageValue!=null && unmanageValue.length() > 0)
					{
						unmanageSet.add(tmpvar);
					}
				}
			}
		}

		if(newSet!=null && newSet.size() > 0)
			newList = new ArrayList(newSet);
		if(unmanageSet!=null && unmanageSet.size() > 0)
			unmanageList = new ArrayList(unmanageSet);
		result.put("NEW" , newList);
		result.put("UNMANAGE" , unmanageList);
		return result;
	}
%>