<%
/*************************************************************************************************/
/*                 Name          : EgAutoManageComponentsJson.jsp                                    */
/*                 Purpose       : This page is used to manage all (or) specific components      */
/*                                 while creating Auto Topology segm ents                        */
/*                 Version       : 5.4                                                           */
/*                 Created On    : 05-08-2011                                                    */
/*************************************************************************************************/
%>
<%@ include file="../../EgTrackerAJSON.jsp" %>
<%@ page errorPage="../../EgProbs.jsp"%>
<%@ page import = "java.util.*"%>
<%@ page import = "com.eg.EgInstallInfo" %>
<%@ page import = "com.eg.EgSpecsInfo"%>
<%@ page import = "com.eg.EgRoleInfo"%>
<%@ page import = "com.eg.EgExternalInfo"%>
<%@ page import = "com.eg.EgDiscInfo"%>
<%@ page import = "com.eg.EgCrypt" %>
<%@ page import = "com.eg.IniFile"%>
<%@ page import = "com.eg.IniHelper"%>
<%@ page import = "com.eg.EgConfigFilesSync"%>
<%@ page import = "com.eg.EgManagersIniForManager"%>
<%@ page import = "com.eg.TransmitInfosToAllSMs"%>
<%@ page import = "com.egurkha.util.StringUtils"%>
<%@ page import = "com.egurkha.ini.IniUI"%>
<%@ page import = "com.egurkha.util.*" %>
<%@ page import = "com.egurkha.admin.*" %>
<%@ page import = "net.sf.json.*"%>
<%@ page language = "java" contentType = "text/html; charset=UTF-8" pageEncoding = "UTF-8" %>
<%@ page import = "com.egurkha.admin.AuditLogThread"%>
<%
	JSONObject rootJson = new JSONObject();
	JSONObject screenLabels = new JSONObject();

	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
%>
<jsp:useBean id="servicer" scope="request" class="egurkha.ServiceBean"/>
<jsp:useBean id="user" scope="request" class="egurkha.UserBean"/>
<jsp:useBean id="manager" scope="request" class="egurkha.ConfigBean"/>
<jsp:useBean id="EgConfigTopo1" scope="page" class="egurkha.ConfigTopology"/>
<jsp:useBean id="tpbean" scope="request" class="egurkha.EgTestParamBean"/>
<jsp:useBean id="trans" scope="request" class="egurkha.TransactionBean"/>
<jsp:useBean id="trans1" scope="request" class="egurkha.TransactionBean"/>
<jsp:useBean id="ecumb" scope="page" class="com.egurkha.monitor.EgComponentUserMappingBean" />
<%!
	/*
		This method returns, list of new components form the given segment name
	*/
	private ArrayList getNewComponents(String segmentName)
	{
		String iniFilePath = EgInstallInfo.getInstallDir() + "/manager/config/eg_autotopology.ini";
		String disIniFilePath = EgInstallInfo.getInstallDir() + "/manager/config/eg_discover.ini";
		IniFile iniFile = new IniFile(iniFilePath);
		IniFile disIniFile = new IniFile(disIniFilePath);
		String newstr = "#New|";
		ArrayList result = new ArrayList();
		Set thisSet = new TreeSet();
		String[] varArray = iniFile.getVariables(segmentName);

		for(int k=0;k<varArray.length;k++)
		{
			String varName = varArray[k];
			String thisCompName = varName.substring(0,varName.indexOf(":"));
			String checkValue = disIniFile.getValue(thisCompName,newstr+varName);
			if(checkValue!=null && checkValue.length() > 0)
			{
				thisSet.add(varName);
			}

			String valName = iniFile.getValue(segmentName,varName);
			if(valName!=null && valName.equals("null"))
				continue;
			StringTokenizer st = new StringTokenizer(valName,",");
			while(st.hasMoreTokens())
			{
				String tok = st.nextToken();
				String tmpcompname = tok.substring(0,tok.indexOf(":"));
				String tmpvar = tok.substring(0,tok.lastIndexOf(":"));
				String chkval = disIniFile.getValue(tmpcompname,newstr+tmpvar);
				if(chkval!=null && chkval.length() > 0)
				{
					thisSet.add(tmpvar);
				}
			}
		}
		if(thisSet!=null && thisSet.size() > 0)
		{
			result = new ArrayList(thisSet);
		}
		return result;
	}


	/*
		This method returns, list of New & Unmanaged components form the given segment name
	*/
	private Hashtable getUnmanageAndNewComponents(String segmentName)
	{
		String iniFilePath = EgInstallInfo.getInstallDir() + "/manager/config/eg_autotopology.ini";
		String disIniFilePath = EgInstallInfo.getInstallDir() + "/manager/config/eg_discover.ini";
		IniFile iniFile = new IniFile(iniFilePath);
		IniFile disIniFile = new IniFile(disIniFilePath);
		String newstr = "#New|";
		String unmanagestr = "#Unmanage|";
		
		Hashtable result = new Hashtable();
		ArrayList newList = new ArrayList();
		ArrayList unmanageList = new ArrayList();
		Set newSet = new TreeSet();
		Set unmanageSet = new TreeSet();

		String[] varArray = iniFile.getVariables(segmentName);

		for(int k=0;k<varArray.length;k++)
		{
			String varName = varArray[k];
			String thisCompName = varName.substring(0,varName.indexOf(":"));
			String newValue = disIniFile.getValue(thisCompName,newstr+varName);
			if(newValue!=null && newValue.length() > 0)	// Check for new component
			{
				newSet.add(varName);
			}
			else	// Check for unmanage component
			{
				String unmanageValue = disIniFile.getValue(thisCompName,unmanagestr+varName);
				if(unmanageValue!=null && unmanageValue.length() > 0)
				{
					unmanageSet.add(varName);
				}
			}

			String valName = iniFile.getValue(segmentName,varName);
			if(valName!=null && valName.equals("null"))
				continue;
			StringTokenizer st = new StringTokenizer(valName,",");
			while(st.hasMoreTokens())
			{
				String tok = st.nextToken();
				String tmpcompname = tok.substring(0,tok.indexOf(":"));
				String tmpvar = tok.substring(0,tok.lastIndexOf(":"));
				String newval = disIniFile.getValue(tmpcompname,newstr+tmpvar);
				if(newval!=null && newval.length() > 0)
				{
					newSet.add(tmpvar);
				}
				else
				{
					String unmanageValue = disIniFile.getValue(tmpcompname,unmanagestr+tmpvar);
					if(unmanageValue!=null && unmanageValue.length() > 0)
					{
						unmanageSet.add(tmpvar);
					}
				}
			}
		}

		if(newSet!=null && newSet.size() > 0)
			newList = new ArrayList(newSet);
		if(unmanageSet!=null && unmanageSet.size() > 0)
			unmanageList = new ArrayList(unmanageSet);
		result.put("NEW" , newList);
		result.put("UNMANAGE" , unmanageList);
		return result;
	}
	String resultval = "";
	String tmpVal = "";

	/*
		* Discovered Group Components removed from eg_autotopology.ini.
		* Managed Group components removed from both eg_autotopology.ini and eg_groups.ini
	*/
	public void removeCompFromAutoIni(String grpName,ArrayList removeCompList,boolean isManagedComp)
	{
		String iniFileName = EgInstallInfo.getInstallDir()+"/manager/config/eg_autotopology.ini";
		IniFile autoTopoIni = EgConfigFilesSync.getInstance(iniFileName);
		String[] varArray = autoTopoIni.getVariables("Discovered_Groups");
		for(int k=0;k<varArray.length;k++)
		{
			tmpVal = "";
			String varName = varArray[k];
			varName = varName+"~DGroup:"+grpName;
			String valName = autoTopoIni.getValue("Discovered_Group_Servers",varName);
			if(valName == null && valName.equals("null"))
				continue;
			for(int l=0; l<removeCompList.size(); l++)
			{
				resultval = "";
				String remComp = (String)removeCompList.get(l);
				StringTokenizer st = new StringTokenizer(valName,",");
				while(st.hasMoreTokens())
				{
					String tok = st.nextToken();
					if(tok.indexOf(remComp)<0)
					{
						resultval += tok + ",";
					}
					else
					{
						valName = valName.replace(tok,"");
						tmpVal += tok + ",";
					}
				}
				if(resultval.endsWith(","))
					resultval = resultval.substring(0,resultval.lastIndexOf(","));
				autoTopoIni.setValue("Discovered_Group_Servers",varName,resultval);
			}
			if(tmpVal.endsWith(","))
				tmpVal = tmpVal.substring(0,tmpVal.lastIndexOf(","));
			if(!isManagedComp)
			{
				if(tmpVal != "" && !tmpVal.equals("null"))
				{
					String result = autoTopoIni.getValue("Tmp_Servers",varName);
					if(result != "" && !result.equals(""))
						tmpVal = result+","+tmpVal;
					autoTopoIni.setValue("Tmp_Servers",varName,tmpVal);
					autoTopoIni.saveFile();
				}
			}
			autoTopoIni.saveFile();
		}
		EgConfigFilesSync.releaseInstance(autoTopoIni);
	}
	public HashMap getRecentManagedGroupMapping(String discSeg, String groupName)
	{
		HashMap newGroupVarMap = new HashMap();
		String autoiniFilePath = EgInstallInfo.getInstallDir() + "/manager/config/eg_autotopology.ini";
		IniFile autotopoiniFile = new IniFile(autoiniFilePath);
		String[] varArray = autotopoiniFile.getVariables(discSeg);
		for(int k=0;k<varArray.length;k++)
		{
			String varName = varArray[k];
			String val = autotopoiniFile.getValue(discSeg, varName);
			StringTokenizer strTok = new StringTokenizer(val,",");
			while(strTok.hasMoreTokens())
			{
				String discGroupName = groupName;
				String tok = strTok.nextToken();
				if(tok.endsWith(":L"))
				{
					tok = tok.replace(":L","");
				}
				StringTokenizer stTok = new StringTokenizer(discGroupName,":");
				int tokCount = stTok.countTokens();
				if(tok.equals(discGroupName))
				{
					newGroupVarMap.put(varName,discGroupName);
				}
			}
		}
		return newGroupVarMap;
	}
	
	private String getMyGroupName(String grpKey, Hashtable ht_ExistingGrpDetails,String groupWithSiteName,int temp,IniFile groupIniFile)
	{
		String grpName=grpKey;
		if(ht_ExistingGrpDetails != null && ht_ExistingGrpDetails.containsKey(grpKey.toLowerCase())) //checking the group exist in eg_group.ini
		{
			String autoGroupComp = "AUTO_DISCOVERED_GROUPS";
			grpName = groupIniFile.getValue(autoGroupComp,groupWithSiteName);
			if(grpName !=null && grpName.length()>0)
			{
				return grpName;
			}
			else
			{
				temp =++temp ;
				grpKey = grpKey+"_"+temp;
				grpName=getMyGroupName (grpKey,ht_ExistingGrpDetails,groupWithSiteName,temp,groupIniFile);
			}
		}
		return grpName;
	}
	
	private void updateDiscoveredGroupDetails(String groupName,Hashtable ht_ExistingGrpDetails,String groupWithSiteName,String singlecomp,IniFile groupIniFile)
	{
		String autoGroupSec = "AUTO_DISCOVERED_GROUPS";
		String autoGroupComp = "AUTO_DISCOVERED_GROUP_DETAILS";
		groupIniFile.setValue(autoGroupSec,groupWithSiteName,groupName);
		String autoVariable = singlecomp+"#"+groupWithSiteName;
		groupIniFile.setValue(autoGroupComp, autoVariable, groupName);
	}
%>

<%
	String segment = request.getParameter("segment");
	String chkall = request.getParameter("chkall");
	String action = request.getParameter("action");
	String compname = request.getParameter("compname");
	String grpname = request.getParameter("grpname");
	String compStatus = request.getParameter("compStatus");
	String fromPage = request.getParameter("fromPage");
	String rename = "Group";
	EgAutoTopologyServlet autoTopoServlet = new EgAutoTopologyServlet();
	EgComponentGroup comGr = new EgComponentGroup();
	//IniFile grpIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_group.ini");
	ArrayList newServerList = new ArrayList();
	ArrayList removeCompList = new ArrayList();
	ArrayList unManageList = new ArrayList();
	boolean isManagedComp = false;
	boolean isNewCompExceedLicense = false;
	String message = null;
	boolean renameStatus = true;
	boolean callBasicErrorPage = false;
	
	/* code for auditlog starts */
	AuditLogThread auditLogThread = new AuditLogThread();	
	auditLogThread.setValue("Category","Admin");
	auditLogThread.setValue("User_id",_user.getLoginID());
	auditLogThread.setValue("Host_ip",_user.getUserIP(session.getId()));
	auditLogThread.setValue("Session_id",session.getId());
	auditLogThread.setValue("Module","Discovered Segments");
	/* code for auditlog endss */

	String loginID = _user.getLoginID();
	String remoteIP = _user.getUserIP(session.getId());
	ComponentAdd compAdd = new ComponentAdd(loginID,remoteIP,sessionID);
	EgAutoTopologyPreview autoTopoPreview = new EgAutoTopologyPreview();
	EgTopoServlet topoServlet = new EgTopoServlet();

	String saveFrom = request.getParameter("saveFrom");
	String grpiniFileName = EgInstallInfo.getInstallDir()+"/manager/config/eg_group.ini";
	IniFile grpIni = EgConfigFilesSync.getInstance(grpiniFileName,true);
	if(saveFrom==null) saveFrom="";
	String topoIniFilePath = EgInstallInfo.getInstallDir() + "/manager/config/eg_topology.ini";
	IniFile topoiniFile = new IniFile(topoIniFilePath);
	
	if(chkall!=null && chkall.equals("true"))
	{
		Hashtable myTable = getUnmanageAndNewComponents(segment);
		newServerList = (ArrayList) myTable.get("NEW");
		unManageList = (ArrayList) myTable.get("UNMANAGE");
		if(unManageList!=null && unManageList.size() > 0)
			newServerList.addAll(unManageList);
	}
	else
	{
		String test = request.getParameter("test");
		if(test!=null && test.length() > 0)
		{
			StringTokenizer st = new StringTokenizer(test,",");
			while(st.hasMoreTokens())
			{
				newServerList.add(st.nextToken());
			}
		}
	}
	
	/*
		* Showing Alert While selecting Managed component to 'manage' from details Component list.
		* If not managed component then add it to group.
	*/
	String grpWithSiteName="";
	if(action!= null && action.equalsIgnoreCase("manageGrpComp"))
	{
		ArrayList grpNewCompArr = new ArrayList();
		ArrayList grpUnManageCompArr = new ArrayList();
		//ArrayList managedServerList = autoTopoServlet.getComponentsUnderAutoTopologyGrp(grpname,segment);
		ArrayList managedServerList = new ArrayList();
		Hashtable mngGrpDetailsTable=autoTopoServlet.getComponentsUnderAutoTopologyGrp(grpname,segment);
		if(mngGrpDetailsTable != null && mngGrpDetailsTable.size() > 0)
		{
			if(mngGrpDetailsTable.containsKey("ComponentList"))
			{
				managedServerList=(ArrayList)mngGrpDetailsTable.get("ComponentList");
			}
			/*if(grpDetailsTable.containsKey("GroupWithSiteName"))
			{
				grpWithSiteName=(String)grpDetailsTable.get("GroupWithSiteName");
			}*/
		}
		Hashtable grpNewCompTable = autoTopoServlet.getUnmanageAndNewComponents(grpname,segment,"autoTopoGrp");//get newly discovered components
		TreeSet newCompList = (TreeSet)grpNewCompTable.get("NEW");
		TreeSet unmanageCompList = (TreeSet)grpNewCompTable.get("UNMANAGE");
		grpNewCompArr.addAll(newCompList);
		grpUnManageCompArr.addAll(unmanageCompList);
		managedServerList.removeAll(grpNewCompArr);
		managedServerList.removeAll(grpUnManageCompArr);
		int compstatus = 0;
		for(int k=0; k<newServerList.size(); k++)
		{
			Vector finalVec =  new Vector();
			String selComp = (String)newServerList.get(k);
			String serverType = selComp.substring(0,selComp.indexOf(":"));
			String cmpName = selComp.substring(selComp.indexOf(":")+1,selComp.length()); 
			finalVec.add(cmpName);  
			for(int y=0; y<managedServerList.size(); y++)
			{
				String managedComp = (String)managedServerList.get(y);
				if(selComp.equalsIgnoreCase(managedComp))
				{
					isManagedComp = true;
					newServerList.clear();
				}
				else
				{
					compstatus = user.checkBasicAgentCount(serverType,finalVec,1,"","","","");
					if(compstatus == 2 || compstatus == 3 || compstatus == 4 || compstatus == 5)
					{
						isNewCompExceedLicense = true;
						callBasicErrorPage = true;
						newServerList.clear();
					}
				}
			}
		}
		if(newServerList.size()>=1)
		{
			ArrayList managedCompList = new ArrayList();
			ArrayList grpCompList = new ArrayList();
			//ArrayList grpCompList = autoTopoServlet.getComponentsUnderAutoTopologyGrp(grpname);
			Hashtable grpDetailsTable=autoTopoServlet.getComponentsUnderAutoTopologyGrp(grpname,segment);
			if(grpDetailsTable != null && grpDetailsTable.size() > 0)
			{
				if(grpDetailsTable.containsKey("ComponentList"))
				{
					grpCompList=(ArrayList)grpDetailsTable.get("ComponentList");
				}
				if(grpDetailsTable.containsKey("GroupWithSiteName"))
				{
					grpWithSiteName=(String)grpDetailsTable.get("GroupWithSiteName");
				}
			}
			IniFile groupIniFile = EgConfigFilesSync.getInstance(EgConfigInfo.egMgrConfigDir + "eg_group.ini");
			String[] groupDetails = groupIniFile.getLinesUnderSubject("GROUP_DETAILS");
			Hashtable ht_ExistingGrpDetails=new Hashtable();
			ArrayList compList=null;
			if(groupDetails != null && groupDetails.length > 0)
			{
				for(int i=0;i<groupDetails.length;i++)
				{
					String grpDetStr=groupDetails[i];
					String compStr="", grpStr="";
					if(grpDetStr != null && grpDetStr.indexOf("#") >= 0)
					{
						compStr=grpDetStr.substring(0,grpDetStr.indexOf("#"));
						//compStr=compStr.toLowerCase();
					}
					if(grpDetStr != null && grpDetStr.indexOf("=") >= 0)
					{
						grpStr=grpDetStr.substring(grpDetStr.indexOf("=")+1);
						grpStr=grpStr.toLowerCase();
					}
					if(ht_ExistingGrpDetails.containsKey(grpStr))
					{
						compList=(ArrayList)ht_ExistingGrpDetails.get(grpStr);
						if (compList == null)
						{
							compList = new ArrayList();
						}
						if(!compList.contains(compStr))
							compList.add(compStr);
						ht_ExistingGrpDetails.put(grpStr,compList);
					}
					else
					{
						compList=new ArrayList();
						compList.add(compStr);
						ht_ExistingGrpDetails.put(grpStr,compList);
					}
				}
			}
			
			grpCompList.removeAll(grpNewCompArr);
			grpCompList.removeAll(grpUnManageCompArr);
			managedCompList.addAll(grpCompList);
			managedCompList.addAll(newServerList);
			String finalgroupName="";
			for(int f=0; f<managedCompList.size(); f++)
			{
				String comp = (String)managedCompList.get(f);
				if(grpname.contains(":NULL"))
				{
					grpname = grpname.replace(":NULL","");
				}
				int tempCount=0;
				finalgroupName=getMyGroupName(grpname,ht_ExistingGrpDetails,grpWithSiteName,tempCount,groupIniFile);
				updateDiscoveredGroupDetails(finalgroupName,ht_ExistingGrpDetails,grpWithSiteName,comp,groupIniFile);
				String grpStatus = compAdd.addComponentToGroup(comp,finalgroupName);
			}
			groupIniFile.saveFile();
			EgConfigFilesSync.releaseInstance(groupIniFile);
		}
		if(fromPage!= null && fromPage.equalsIgnoreCase("configSegment"))
		{
			if(compstatus == 2 || compstatus == 3 || compstatus == 4 || compstatus == 5)
			{
				isNewCompExceedLicense = true;
				callBasicErrorPage = true;
			}
			else if(!isManagedComp)
			{
				String groupNameVal = request.getParameter("groupNameVal");
				String[] topoVar = topoiniFile.getVariables("Segments_Mapping");
				for(int v=0; v<topoVar.length; v++)
				{
					String discSeg = topoVar[v];
					String configSeg = topoiniFile.getValue("Segments_Mapping",discSeg);
					StringTokenizer strTok = new StringTokenizer(configSeg,"#");
					while(strTok.hasMoreTokens())
					{
						String configSegTok = strTok.nextToken();
						if(configSegTok.equalsIgnoreCase(segment))
						{
							String groupName = "DGroup"+":"+groupNameVal;
							HashMap groupMap = getRecentManagedGroupMapping(discSeg,groupName);
							if (groupMap != null && groupMap.size() > 0)
							{
								topoServlet.writeNewComponentMapping(groupMap,configSegTok);
							}
						}
					}
				}
			}
		}
	}
	/*
		* Dissociating components from Details Menu link.
		* Managed components in the Managed Groups are removed permanently.
		* Discovered Group components are removed temporarily.
	*/
	if(action!= null && action.equalsIgnoreCase("removeGrpComp"))
	{
		boolean isManComp = false;
		String removeComp = request.getParameter("removeComp");
		if(removeComp!=null && removeComp.length() > 0)
		{
			StringTokenizer st = new StringTokenizer(removeComp,",");
			while(st.hasMoreTokens())
			{
				removeCompList.add(st.nextToken());
			}
		}
		String iniFilePath = EgInstallInfo.getInstallDir() + "/manager/config/eg_autotopology.ini";
		IniFile iniFile = new IniFile(iniFilePath);
		String grpName = compname;
		if(compStatus.equalsIgnoreCase("NEW"))
		{
			removeCompFromAutoIni(grpName,removeCompList,isManComp);
		}
		else
		{
			ArrayList managedCompList = new ArrayList();
			for(int r=0; r<removeCompList.size(); r++)
			{
				String remComp = (String)removeCompList.get(r);
				String[] grpDetailsVar = grpIni.getVariables("GROUP_DETAILS");
				if(compname.contains(":NULL"))
				{
					compname = compname.replace(":NULL","");
				}
				for(int k=0; k<grpDetailsVar.length; k++)
				{
					String grpVar = grpDetailsVar[k];
					int idx = grpVar.indexOf(remComp);
					if(idx>-1)
					{
						managedCompList.add(remComp);
						String var = remComp+"#"+compname;
						grpIni.deleteValue("GROUP_DETAILS",var);
						isManComp = true;
						removeCompFromAutoIni(grpName,managedCompList,isManComp);//permanent remove comp from autotopology.ini 
					}
				}
			}
			if(managedCompList.size() > 0)
			{
				removeCompList.removeAll(managedCompList);
			}
			removeCompFromAutoIni(grpName,removeCompList,false);//temperory remove comp from autotopology.ini 
			grpIni.saveFile();
		}
	}
	/*
		* Renaming Groups.
	*/
	if(action!= null && action.equalsIgnoreCase("renameGrpName"))
	{
		String old_name = request.getParameter("old_name");
		String new_name = request.getParameter("new_name");
		if(StringUtils.isNull(old_name) || StringUtils.isNull(new_name))
		{
			renameStatus = false;
			if(StringUtils.isNull(new_name))
			{
				message = _mapping.getTextDescription("admin.error.You can not proceed renaming with new name as empty or null")+".";
			}
			else
			{
				message = _mapping.getTextDescription("admin.error.You can not proceed renaming as current name is empty or null")+".";
			}
		}
		else
		{
			if(IniUI.isEgReservedKeyword(new_name))
			{
				renameStatus = false;
				message = "'"+new_name.toUpperCase() +"' "+_mapping.getTextDescription("admin.error.is an eG defined keyword")+". "+_mapping.getTextDescription("admin.error.Choose another name")+".";
			}
			else
			{
				boolean oldNameExist = false;
				boolean isSite = false;
				String auditlogLabel = null;
				String nameConflictLabel = null;
				String update_msmt_table = "true";
				Vector nameConflict = new Vector();//dont add anything into this vector

				//AuditLogThread auditLogThread = new AuditLogThread();
				auditLogThread.setValue("Category","Admin");
				auditLogThread.setValue("User_id",_user.getLoginID());
				auditLogThread.setValue("Host_ip",_user.getUserIP(session.getId()));
				auditLogThread.setValue("Session_id",session.getId());
				auditLogThread.setValue("Activity","Group Rename");

				String targetPageURL = null;
				
				auditLogThread.setValue("Module","AutoTopology Groups");
				String[] str = new EgGroupInfoAdmin().getGroupNames();
				for(int k=0; k<str.length; k++)
				{
				}
				oldNameExist = Rename.doesOldnameExist(new EgGroupInfoAdmin().getGroupNames(),old_name,new_name,nameConflict);
				nameConflictLabel="admin.error.You are trying to rename a group with a name which is already assigned to some other group";
				auditlogLabel=old_name + " group can not be renamed to "+new_name +" as this name is already assigned to some other group";
				if(!nameConflict.isEmpty())
				{
					renameStatus = false;
					auditLogThread.setValue("Description",auditlogLabel);
					auditLogThread.sendItToDB();
					message = _mapping.getTextDescription(nameConflictLabel)+".";
				}
				else
				{
					boolean success = false;
					if(compStatus.equalsIgnoreCase("NEW"))
					{
						comGr.renameDiscoveredGroup(old_name,new_name);
					}
					else 
					{
						comGr.renameGroup(old_name,new_name);
						comGr.renameDiscoveredGroup(old_name,new_name);
					}
					auditLogThread.setPreviousValue("Group name",old_name);
					auditLogThread.setCurrentValue("Group name",new_name);
					auditLogThread.setValue("Description","Group has been renamed");
					auditLogThread.sendItToDB();
					autoTopoPreview.autoTopology();
					String label = "admin.common."+rename.toLowerCase()+" has been renamed successfully to";
					message = old_name + " " + _mapping.getTextDescription(label) + " " + new_name + ".";
				}
			}
		}
	}

	EgConfigFilesSync.releaseInstance(grpIni);
	EgConfigTopo1.createFile("eg_services.ini");
	int compSize = Integer.parseInt(EgConfigTopo1.getValues("MISC_ARGS","MaxManagedComponentsForDisc"));
	EgRoleInfo egRoleInfo = EgRoleInfo.getInstance(session.getId(),(String)session.getAttribute("sess_userid"));
	String[] sTypes = egRoleInfo.getServerTypes();
	boolean hasLimitExceeded=false;
	int cnt=0;
	if (sTypes != null && sTypes.length > 0)
	{
		for (int st=0;st<sTypes.length;st++)
		{
			String[] strComps = egRoleInfo.getAllServersOfType(sTypes[st]);
			if (strComps.length > 0)
			{
				cnt = cnt + strComps.length;
				if (cnt > compSize)
				{
					hasLimitExceeded = true;
					break;
				}
			}
		}
	}

	Hashtable ht = new Hashtable();
	for(int k=0;k<newServerList.size();k++)
	{
		String element = (String) newServerList.get(k);
		String compType = element.substring(0,element.indexOf(":"));
		String compName = element.substring(element.indexOf(":")+1);

		Object hashValue =  ht.get(compType);
		if(hashValue!=null)
		{
			ArrayList compList = (ArrayList) hashValue;
			compList.add(compName);
			ht.put(compType,compList);
		}
		else
		{
			ArrayList compList = new ArrayList();
			compList.add(compName);
			ht.put(compType,compList);
		}
	}
	
	int status = 0;
	
	Hashtable managedTable = new Hashtable();
	Hashtable nickExistsTable = new Hashtable();
	Vector err_msg = new Vector();
	Vector sess_vec = new Vector();
	Vector updateServers = new Vector();
	String msgString = "";
	String eGInstallDir = EgInstallInfo.getInstallDir();

	IniFile serviceInfo = new IniFile(eGInstallDir + "/manager/config/eg_services.ini");
	IniFile discoverInfo = new IniFile(eGInstallDir + "/manager/config/eg_discover.ini");
	IniFile egUISave = new IniFile(eGInstallDir + "/manager/config/eg_ui.ini");
	String showUsers = egUISave.getValue("ALARM_HISTORY","Show_Users");
	
	String[] agentlessInfo = serviceInfo.getVariables("DEFAULT_AGENTLESS_SETTINGS");
	List agentlessInfoList = new ArrayList();
	if (agentlessInfo != null)
	{
		agentlessInfoList = new ArrayList(Arrays.asList(agentlessInfo));
	}

	//Basic Agent Check
	// new to put the new code for eg_external.ini
	String type1 = servicer.getAlOption();
	boolean flag11 = false;
	if(type1 == null)
		flag11 = false;
	else if(type1.equalsIgnoreCase("yes"))
		flag11 = true;
	else
		flag11 = false;

	EgSpecsInfo specsinfo1 = new EgSpecsInfo("manager");
	EgDiscInfo egDiscInfo = new EgDiscInfo("manager");
	EgExternalInfo externalInfo = new EgExternalInfo("manager");

	Hashtable nickIPMap = new Hashtable();
	Hashtable hTableAllNicksIp = new Hashtable();
	Vector v_virtservers = externalInfo.getVirtualServers();

	Set keys = ht.keySet();
	Iterator itr = keys.iterator();

	while(itr.hasNext())
	{
		String srvtype = (String)itr.next();
		ArrayList thisList = (ArrayList) ht.get(srvtype);
		if(thisList == null)
			continue;

		nickIPMap = egDiscInfo.getNickIpMap();
		hTableAllNicksIp = egDiscInfo.getAllNicksIpMap();
		ArrayList aListNickAlreadyExists = new ArrayList();
		String strAlreadyExists = "";
		List preManagedList = new ArrayList();
		updateServers.clear();

		String[] comps = discoverInfo.getVariables(srvtype);
		if (comps != null)
		{
			for (int i=0; i<comps.length; i++)
			{
				String strComp = comps[i];
				if (strComp.startsWith(srvtype+":"))
				{
					strComp = strComp.substring(strComp.indexOf(":")+1);
					strComp = strComp.substring(0,strComp.indexOf(":"));
					preManagedList.add(strComp);
				}
			}
		}
		//The following line is to ensure that the stopDiscovery & startDiscovery runs inside a sync block
		IniFile infraIni = EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir() + "/manager/config/eg_infrastructure.ini");
		servicer.stopDiscovery();
		Vector finalServers = new Vector();
		Vector finalSvrs = new Vector();
		Vector managedVector = new Vector();
		Vector v_managedserver=new Vector();
		Vector newManServers = new Vector();
		Vector oldManServers = new Vector();
		StringBuffer manage = new StringBuffer();
		boolean update = false;

		String[] allServers = egDiscInfo.getAllServersOfType(srvtype); // Already managed components
		for(int k=0;k<allServers.length;k++)
		{
			String thisServer = allServers[k];
			managedVector.add(thisServer);
			oldManServers.add(thisServer);
			String nickWithPort = thisServer.substring(thisServer.indexOf(":")+1);
			manage.append(nickWithPort+",");
		}

		for(int k=0;k<thisList.size();k++)
		{
			String nickWithPort = (String)thisList.get(k);
			String strNick = nickWithPort.substring(0,nickWithPort.indexOf(":"));
			manage.append(nickWithPort+",");
		}

		StringTokenizer managedTokens = new StringTokenizer(manage.toString(),",");
		while(managedTokens.hasMoreTokens())
		{
			String token = (String) managedTokens.nextToken();
			String strNick = token.substring(0,token.indexOf(":"));
			if(!managedVector.contains(srvtype+":"+token))
			{
				if (nickIPMap.containsKey(strNick))
				{
					String managedIP = (String)nickIPMap.get(strNick);
					String manAndUnManIp = (String)hTableAllNicksIp.get(strNick);
					if (manAndUnManIp.indexOf(":")>-1)
					{
						StringTokenizer st = new StringTokenizer(manAndUnManIp,":");
						while (st.hasMoreTokens())
						{
							String thisTok = st.nextToken();
							if (thisTok.equals(managedIP))
							{
								String removeNull = "";
								String strForResultsPage = "";
								if (token.indexOf(":NULL")>-1)
								{
									removeNull = token.substring(0,token.indexOf(":NULL"));
									strForResultsPage = removeNull;
								}
								else
								{
									removeNull = token;
									strForResultsPage = token.substring(0,token.indexOf(":"))+"$#"+token.substring(token.indexOf(":")+1);
								}
								if (strAlreadyExists.equals(""))
								{
									strAlreadyExists = strForResultsPage;
								}
								else
								{
									strAlreadyExists = strAlreadyExists+", "+strForResultsPage;
								}
								aListNickAlreadyExists.add(removeNull);
								break;
							}
						}
					}
				}
				if (aListNickAlreadyExists.size()>0)
				{
					continue;
				}
			}
		}

		StringTokenizer st = new StringTokenizer(manage.toString(),",");
		String strTok = "";
		while(st.hasMoreTokens())
		{
			strTok = st.nextToken().trim();
			if (!aListNickAlreadyExists.contains(strTok))
			{
				if(!newManServers.contains(strTok))
					newManServers.add(strTok);
				if (!v_managedserver.contains(strTok))
				{
					v_managedserver.add(strTok);
				}
			}
		}

		for(int i=0; i<newManServers.size(); i++)
		{
			strTok = (String)newManServers.get(i);
			if(!finalSvrs.contains(strTok))
				finalSvrs.add(strTok);

			strTok = strTok.substring(0,strTok.indexOf(":"));
			if(!finalServers.contains(strTok))
				finalServers.add(strTok);
		}
		if(flag11) // default is agentless
		{
			boolean flag12=false;
			if(srvtype != null) 
				flag12 = specsinfo1.isAgentlessServer(srvtype);
			//System.out.println("flag12 :"+flag12 + "  "+srvtype);
			if (flag12 && agentlessInfoList.contains(srvtype))
			{
				if (user.checkAlServers (srvtype,finalServers, finalSvrs))
				{
					//System.out.println("\t user.checkAlServers :"+srvtype);
					EgConfigTopo1.createFile("eg_external.ini");
					String defaultRemoteAgent[] = EgConfigTopo1.getVariables("Eg_Remote_Agents");
					ArrayList extEntries = new ArrayList();
					if(defaultRemoteAgent != null && defaultRemoteAgent.length > 0)
					{
						for(int kk =0;kk<finalServers.size();kk++)
						{
							String value = (String)finalServers.get(kk);
							if (preManagedList.contains(value))
							{
								continue;
							}

							String temp12 = EgConfigTopo1.getValues("Remote_Agent_Mapping_Section", value);
							if (StringUtils.isNull(temp12))
							{
								temp12 = defaultRemoteAgent[0];
							}
							//EgConfigTopo1.setValues("Remote_Agent_Mapping_Section", value, temp12);
							extEntries.add(new IniHelper("Remote_Agent_Mapping_Section", value, temp12));
							String alTokens = EgConfigTopo1.getValues("Agentless_Infos_Section", value);
							String pwd="NONE";
							String useral="None";
							String modeal="None";
							String osal = "None";
							String sshport = "22";

							//if (agentlessInfoList.contains(srvtype))// Only the server type exist under 'DEFAULT_AGENTLESS_SETTINGS'
							//{
								String strVal = serviceInfo.getValue("DEFAULT_AGENTLESS_SETTINGS",srvtype);
								strVal = (strVal!=null)?strVal:"";
								StringTokenizer stt = new StringTokenizer(strVal,",");
								if(stt.countTokens()==4)
								{
									useral = stt.nextToken();
									pwd = stt.nextToken();
									osal = stt.nextToken();
									modeal = stt.nextToken();
								}
							//}

							if(alTokens == null || alTokens.length() == 0)
							{
								pwd = EgCrypt.decrypt(pwd);
								pwd = EgCrypt.encrypt(pwd);
							}
							else
							{
								StringTokenizer st1 = new StringTokenizer(alTokens,",");
								useral = (String)st1.nextToken();
								pwd = (String)st1.nextToken();
								modeal = (String)st1.nextToken();
								osal = (String)st1.nextToken();
								if(st1.hasMoreTokens())
									sshport = (String)st1.nextToken();
								else
									sshport ="";
								pwd = EgCrypt.decrypt(pwd);
								pwd = EgCrypt.encrypt(pwd);
							}
							if(sshport != null && !sshport.equals(""))
							{
								//EgConfigTopo1.setValues("Agentless_Infos_Section", value, useral+","+pwd+","+modeal+","+osal+","+sshport);
								extEntries.add(new IniHelper("Agentless_Infos_Section", value, useral+","+pwd+","+modeal+","+osal+","+sshport));
							}
							else
							{
								//EgConfigTopo1.setValues("Agentless_Infos_Section", value, useral+","+pwd+","+modeal+","+osal);
								extEntries.add(new IniHelper("Agentless_Infos_Section", value, useral+","+pwd+","+modeal+","+osal));
							}
						}
					}

					if (extEntries.size() > 0)
					{
						IniFile discWr = EgConfigFilesSync.getInstance(eGInstallDir + "/manager/config/eg_external.ini");
						for(int e=0; e < extEntries.size(); e++)
						{
							IniHelper iniHelr = (IniHelper) extEntries.get(e);
							String sub = iniHelr.getSubject();
							String key = iniHelr.getVariable();
							String value = iniHelr.getValue();
							discWr.setValue(sub,key,value);
						}
						discWr.saveFile();
						EgConfigFilesSync.releaseInstance(discWr);
					}
					//EgConfigTopo1.saveFile();
				}
				else
				{
					status = 6;
					callBasicErrorPage = true;
				}
			}
		}

		if(callBasicErrorPage)
		{
			System.out.println("callBasicErrorPage is True ... after status 6  so breaking...."); 
			break;
		}

		if (!callBasicErrorPage)
		{
			status = user.checkBasicAgentCount(srvtype,finalSvrs,1,"","","","");
			//System.out.println("\t STATUS :"+status);
			if(status == 1)
				update = true;
			else if(status == 2 || status == 3 || status == 4 || status == 5)
				callBasicErrorPage = true;
		}

		if(update)
		{
			//Manage the component
			manager.createSyncFile("eg_discover.ini","save");
			for(int k=0;k<thisList.size();k++)
			{
				String thiscomp = (String) thisList.get(k);
				if(aListNickAlreadyExists.size() > 0)
				{
					if(aListNickAlreadyExists.contains(thiscomp))
					{
						//System.out.println("aListNickAlreadyExists .If BLOCK Going to continue..... :"+aListNickAlreadyExists);
						ArrayList tmpList = (ArrayList) nickExistsTable.get(srvtype);
						if(tmpList!=null && tmpList.size() > 0)
						{
							tmpList.add(thiscomp);
							nickExistsTable.put(srvtype,tmpList);
						}
						else
						{
							tmpList = new ArrayList();
							tmpList.add(thiscomp);
							nickExistsTable.put(srvtype,tmpList);
						}
						continue;
					}
				}
				else
				{
					// Manage the component .. add an entry in eg_discover.ini.
					manager.setManageNew(srvtype, thiscomp);
					ArrayList tmpList = (ArrayList) managedTable.get(srvtype);
					if(tmpList!=null && tmpList.size() > 0)
					{
						tmpList.add(thiscomp);
						managedTable.put(srvtype,tmpList);
					}
					else
					{
						tmpList = new ArrayList();
						tmpList.add(thiscomp);
						managedTable.put(srvtype,tmpList);
					}
				}
			}
			manager.saveFile();
			manager.releaseInstance();
			ArrayList externalEntries = new ArrayList();

			if(v_virtservers.contains(srvtype))
			{
				for (int m=0;m<v_managedserver.size(); m++)
				{
					String server = (String)v_managedserver.get(m);
					String serverName = Server.getServerNameWithoutPort(server);
					if(nickIPMap!=null )
					{
						String ip=(String)nickIPMap.get(serverName);
						if (ip!=null)
						{
							//EgConfigTopo1.setValues("Virtual_Hosts",serverType+":"+server,ip);
							externalEntries.add(new IniHelper(IniHelper.SET,"Virtual_Hosts",srvtype+":"+server,ip));
						}
					}
				}
			}

			if (externalEntries.size() > 0)
			{
				IniFile externalWrite = EgConfigFilesSync.getInstance(eGInstallDir +"/manager/config/eg_external.ini");
				for (int e=0; e < externalEntries.size(); e++)
				{
					IniHelper iniHelper = (IniHelper) externalEntries.get(e);
					String iniAction = iniHelper.getAction();
					String sub = iniHelper.getSubject();
					String key = iniHelper.getVariable();
					String value = iniHelper.getValue();
					if (iniAction != null)
					{
						if (iniAction.equals(IniHelper.SET))
						{
							externalWrite.setValue(sub,key,value);
						}
						else if (iniAction.equals(IniHelper.DELETE))
						{
							externalWrite.deleteValue(sub,key);
						}
					}
				}
				externalWrite.saveFile();
				EgConfigFilesSync.releaseInstance(externalWrite);
			}

			if (hasLimitExceeded)
			{
				servicer.startDiscovery("1");
			}
			else
			{
				servicer.startDiscovery("1",true);
			}

			String curr_date=null;
			if(showUsers!=null && (showUsers.equalsIgnoreCase("true") || showUsers.equalsIgnoreCase("yes")))
			{
				curr_date=String.valueOf(new java.util.Date());
				if(ecumb.hashLastComponentUserUpdated!=null && ecumb.hashLastComponentUserUpdated.size()>0)
				{
					ecumb.hashLastComponentUserUpdated.put("Updated",(String)curr_date);
				}
				else
				{
					ecumb.hashLastComponentUserUpdated=new Hashtable();
					ecumb.hashLastComponentUserUpdated.put("Updated",(String)curr_date);
				}
			}

			if(EgInstallInfo.isClusterSupported && showUsers!=null && (showUsers.equalsIgnoreCase("true") || showUsers.equalsIgnoreCase("yes")) && curr_date!=null)
			{
				//upload the result file to all other managers
				EgManagersIniForManager mi = EgManagersIniForManager.getInstance();
				if(mi.isPrimaryManager())
				{
					TransmitInfosToAllSMs transmitInfoToSecondaryManagers = null;
					transmitInfoToSecondaryManagers =  TransmitInfosToAllSMs.getInstance();
					Vector param = new Vector();
					param.add(curr_date);

					Vector info = new Vector();
					info.add("UserCompUpdate");
					info.add(param);

					transmitInfoToSecondaryManagers.setData(info);
				}
			}

			if (aListNickAlreadyExists.size()>0)
			{
				sess_vec.add(_mapping.getTextDescription("admin.server.The following component(s) of type")+" "+_mapping.getComponentTypeDescription(srvtype)+" "+_mapping.getTextDescription("admin.server.could not be managed")+" ;"+strAlreadyExists);
				//System.out.println("\t sess_vec:"+sess_vec);
			}
			else
			{
				sess_vec.add(_mapping.getTextDescription("admin.server.Components have been Managed successfully"));
			}
		}
		EgConfigFilesSync.releaseInstance(infraIni);
		
		if (callBasicErrorPage)
		{
			msgString = "";
			if(status==2)
			{
				msgString = "admin.error.You are exceeding the number of premium agents allowed by your license";
			}
			else if(status==3)
			{
				msgString = "admin.error.You are exceeding the total number of agents permitted by your license";
			}
			else if(status==4)
			{
				msgString = "admin.error.You are exceeding the total number of applications permitted by your license";
			}
			else if(status==5)
			{
				msgString = "admin.error.You are exceeding the total number of network devices permitted by your license";
			}
			else if(status==6)
			{
				msgString = "admin.error.You are exceeding the total number of agentless components permitted by your license";
			}
			err_msg.add(_mapping.getTextDescription(msgString)+"!");
			break;
		}
	}
	JSONObject managedObj = new JSONObject();
	JSONArray managedArr = new JSONArray();
	rootJson.put("Managed","false");
	boolean anyManaged = false;
	boolean nickProblem = false;
	if(managedTable!=null && managedTable.size() > 0)
		anyManaged = true;
	if(nickExistsTable!=null && nickExistsTable.size() > 0)
		nickProblem = true;
	if(anyManaged)
	{
		String managedComp ="";
		Set serverTypes = managedTable.keySet();
		Iterator thisItr = serverTypes.iterator();
		rootJson.put("Managed","true");
		screenLabels.put("ManagedMessage",_mapping.getTextDescription("admin.servers.The following components are managed successfully"));

		while(thisItr.hasNext())
		{
			String compType = (String) thisItr.next();
			ArrayList compList = (ArrayList) managedTable.get(compType);
			for(int k=0;k<compList.size();k++)
			{
				String compName = (String) compList.get(k);
				String hostName = compName.substring(0,compName.indexOf(":"));
				String portNo = compName.substring(compName.indexOf(":")+1);
				String compDispName = _mapping.getComponentTypeDescription(compType);

				managedObj.put("Hostname",hostName);
				managedObj.put("Port",portNo);
				managedObj.put("Comptype",compDispName);
				managedArr.add(managedObj);
				managedComp += _mapping.getComponentTypeDescription(compType)+":"+hostName+":"+portNo+",";
			}
		}

		if(saveFrom.equals("previewPage"))
		{
			if(chkall!=null && chkall.equals("true"))
			{
			}
		}
		auditLogThread.setValue("Activity","Managed components");
		if(managedComp!=null && managedComp.endsWith(","))
		{
			managedComp = managedComp.substring(0,managedComp.lastIndexOf(","));
		}
		if(managedComp.indexOf(",")>0)
		{
			auditLogThread.setValue("Description","Components have been managed");
		}
		else
		{
			auditLogThread.setValue("Description","Component has been managed");
		}
		auditLogThread.setCurrentValue("ColumnName","Managed Component(s)");
		auditLogThread.setCurrentValue("Component name",managedComp);
		auditLogThread.sendItToDB();
	}
	JSONObject notManagedObj = new JSONObject();
	JSONArray notManagedArr = new JSONArray();
	rootJson.put("NotManaged","false");
	if(nickProblem)
	{
		String nickProbCompStr ="";
		Set myKeys = nickExistsTable.keySet();
		Iterator tmpItr = myKeys.iterator();
		rootJson.put("NotManaged","true");
		screenLabels.put("NickExists",_mapping.getTextDescription("admin.server.The following components could not be managed due to nick name already exists"));

		while(tmpItr.hasNext())
		{
			String compType = (String) tmpItr.next();
			ArrayList compList = (ArrayList) nickExistsTable.get(compType);
			for(int k=0;k<compList.size();k++)
			{
				String compName = (String) compList.get(k);
				String hostName = compName.substring(0,compName.indexOf(":"));
				String portNo = compName.substring(compName.indexOf(":")+1);

				notManagedObj.put("Hostname",hostName);
				notManagedObj.put("Port",portNo);
				notManagedObj.put("Comptype",compType);
				notManagedArr.add(notManagedObj);
				nickProbCompStr += _mapping.getComponentTypeDescription(compType)+":"+","+hostName+":"+portNo+",";
			}
		}

		if(nickProbCompStr!=null && nickProbCompStr.endsWith(","))
		{
			nickProbCompStr = nickProbCompStr.substring(0,nickProbCompStr.lastIndexOf(","));
		}
		auditLogThread.setValue("Activity","Managed components");
		auditLogThread.setValue("Description",_mapping.getTextDescription("admin.server.The following components could not be managed due to nick name already exists"));
		auditLogThread.setCurrentValue("ColumnName","Managed Component(s)");
		auditLogThread.setCurrentValue("Component name",nickProbCompStr);
		auditLogThread.sendItToDB();
	}
	rootJson.put("callBasicErrorPage",callBasicErrorPage);
	if(callBasicErrorPage)
	{
		String licenseMsg = _mapping.getTextDescription("admin.error.To upgrade your license to support additional premium agents")+", "+_mapping.getTextDescription("admin.error.please contact")+" <b>license@eginnovations.com</b>";
	
		StringBuffer strBuff = new StringBuffer();
		for(int i=0;i<err_msg.size();i++)
		{
			String str_output=(String)err_msg.elementAt(i);
			strBuff.append(str_output);
			strBuff.append("<br>");
		}
		rootJson.put("ErrorMessage",strBuff.toString());
		rootJson.put("licenseMsg",licenseMsg);
		//auditlog
		auditLogThread.setValue("Activity","Managed components");
		auditLogThread.setValue("Description","Component(s) cannot be managed");
		auditLogThread.setCurrentValue("Error",strBuff.toString()+""+licenseMsg);
		auditLogThread.sendItToDB();
	}

	rootJson.put("screenLabels",screenLabels);
	rootJson.put("NotManagedComponents",notManagedArr);
	rootJson.put("isManagedComp",isManagedComp);
	rootJson.put("isNewCompExceedLicense",isNewCompExceedLicense);
	rootJson.put("ManagedComponents",managedArr);
	rootJson.put("message",message);
	rootJson.put("renamed",renameStatus);
	rootJson.put("msgString",msgString);
	out.println(rootJson.toString());
%>
