<%
/**********************************************************************************
*	Name			:	aggAddAll.jsp
*	Purpose			:	adding components for the given component types
***********************************************************************************/
%>
<%@ include file= "../../EgTrackerAJSON.jsp"%>
<%@ page language="java" contentType="application/json; charset=UTF-8" pageEncoding="UTF-8" %>
<%@ page import = "net.sf.json.*"%>
<%@ page import="com.eg.EgDiscInfo"%>
<%@ page import="com.eg.EgSpecsInfo"%>
<%@ page import="com.egurkha.ini.IniUI"%>
<%@ page import="com.eg.EgTesterInfo"%>
<%@ page import="com.eg.EgExternalInfo"%>
<%@ page import="com.egurkha.util.StringUtils"%>
<%@ page import = "com.egurkha.util.*" %>

<%@ page import="java.util.*"%>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);

	response.setContentType("application/json;charset=UTF-8");

	String user_id = _user.getLoginID();
	EgUuidInfo uuidInfo = new EgUuidInfo();
	if (uuidInfo.isUser(user_id) && uuidInfo.hasOURole(user_id))
	{
		user_id = uuidInfo.getDirectDependentOU(user_id);
	}
	EgRoleInfo egRoleInfo = EgRoleInfo.getInstance(session.getId(),user_id);//(String)session.getAttribute("sess_userid")
	EgCertUsage user = new EgCertUsage();
	ArrayList usersList = user.getAllLimitedCompAccessUsers(true);
	boolean isLimitedAdmin = (usersList.contains(_user.getLoginID()));
	boolean tmpExtAgentPopulated = false;

	String hostname = request.getParameter("hostname");
	String extAgent = request.getParameter("ext_agents");
	String compType = request.getParameter("comp_types");

	JSONObject rootJSON = new JSONObject();
	JSONArray gridValuesArray = new JSONArray();

	EgTesterInfo testerInfo = new EgTesterInfo("manager");
	EgServicesInfo serviceInfo = new EgServicesInfo("manager");

	String defalutAgentlessServerTypes[] = serviceInfo.getVariables("DEFAULT_AGENTLESS_SETTINGS");
	ArrayList defaultAgentlessServers = null; // contains the list of default agentless servers
	if (defalutAgentlessServerTypes != null)
	{
		defaultAgentlessServers = new ArrayList(Arrays.asList(defalutAgentlessServerTypes));
	}

	boolean externalAgentRunsAllAggTests = testerInfo.externalAgentRunsAllAggTests();
	rootJSON.put("externalAgentRunsAllAggTests",externalAgentRunsAllAggTests);
	if(externalAgentRunsAllAggTests)
	{
		rootJSON.put("AgentLabel",_mapping.getTextDescription("admin.common.External Agent"));
	}
	else
	{
		rootJSON.put("AgentLabel",_mapping.getTextDescription("admin.common.Remote Agent"));
	}

	ArrayList serverList = new ArrayList();

	EgDiscInfo discInfo = new EgDiscInfo("manager");
	String serverTypes = (String)session.getAttribute("selected_server_types");
	if(serverTypes != null)
	{
		serverList.addAll(Arrays.asList(StringUtils.getTokens(serverTypes,",")));
	}

	JSONArray server_types_internal_names = new JSONArray();
	String [] srvTypes = discInfo.getServerTypes();
	for(int i=0;i<srvTypes.length;i++)
	{
		String stype = srvTypes[i];
		if(stype.startsWith("Agg_"))
		{
			continue;
		}
		server_types_internal_names.add(stype);
		server_types_internal_names.add("Agg_"+stype);
	}
	rootJSON.put("server_types_internal_names",server_types_internal_names);

	EgSpecsInfo specsInfo = new EgSpecsInfo("manager");
	boolean flag=false;

	for(int i=0;i<serverList.size();i++)
	{
		String s_type = (String)serverList.get(i);
		if(s_type.startsWith("Agg_"))
		{
			flag = true;
		}
		else
		{
			flag = specsInfo.isAgentlessServer(s_type);
		}
	}

	String[] tmpExtAgents = null;
	String hostName = request.getParameter("hostname");
	IniFile externalIni = new IniFile(EgConfigInfo.egMgrConfigDir + "eg_external.ini");
	String prevExtAgent = externalIni.getValue("Test_Mapping_Section", hostName);

	if (prevExtAgent == null || prevExtAgent.equalsIgnoreCase(EgConstants.NULL_STRING))
	{
		prevExtAgent = EgConstants.BLANK_STRING;
	}
	EgExternalInfo e = new EgExternalInfo("manager");
	String[] eAgents = e.getAllExternalAgents();
	if (eAgents != null)
	{
		Arrays.sort(eAgents, String.CASE_INSENSITIVE_ORDER);
		List tmpList = new ArrayList();
		String defaultExtAgent = "";
		for (int j=0; j <eAgents.length;j++)
		{
			String tmpExtagent = eAgents[j];
			if (specsInfo.getEGServer().equals(tmpExtagent))
			{
				defaultExtAgent = tmpExtagent;
			}
			else
			{
				tmpList.add(tmpExtagent);
			}
		}
		if (!defaultExtAgent.equals(""))
		{
			tmpList.add(0,defaultExtAgent);
		}
		eAgents = (String[])tmpList.toArray(new String[0]);
	}

	if(prevExtAgent.length()==0 && eAgents.length > 0)
	{
		prevExtAgent = eAgents[0];
	}
	String selectedExtAgent = null;
	if (StringUtils.isNull(prevExtAgent))
	{
		String defExtAgent = specsInfo.getEGServer();
		if (StringUtils.isNull(defExtAgent))
		{
			selectedExtAgent = eAgents[0];
		}
		else
		{
			/*
			 * Get the default external agent as specified in eg_specs.ini
			 */
			selectedExtAgent = defExtAgent;
		}
	}
	else
	{
		selectedExtAgent = prevExtAgent;
	}

	String defaultRemoteAgent = new EgSpecsInfo("manager").getEGServer();
	String[] allSelExtAgents = StringUtils.getTokens(selectedExtAgent, EgConstants.COMMA);
	String defExtAgent = specsInfo.getEGServer();
	//rootJSON.put("defaultExternalAgents",defExtAgent);

	EgUserElementsInfo userElemInfoObj = new EgUserElementsInfo();
	EgExternalInfo extInfo = new EgExternalInfo("manager");
	String[] remoteAgents = extInfo.getAllRemoteAgents();
	if (remoteAgents != null)
	{
		Arrays.sort(remoteAgents,String.CASE_INSENSITIVE_ORDER);
		List tmpList = new ArrayList();
		String defaultRemAgent = "";
		for (int j=0; j <remoteAgents.length;j++)
		{
			String tmpRemAgent = remoteAgents[j];
			if (specsInfo.getEGServer().equals(tmpRemAgent))
			{
				defaultRemAgent = tmpRemAgent;
			}
			else
			{
				tmpList.add(tmpRemAgent);
			}
		}
		if (!defaultRemAgent.equals(""))
		{
			tmpList.add(0,defaultRemAgent);
		}
		defaultRemoteAgent = defaultRemAgent;
		remoteAgents = (String[])tmpList.toArray(new String[0]);
	}

	String servers[] = serviceInfo.getVariables("AGENTLESS_SERVERS");
	ArrayList agentlessServers = new ArrayList();
	if (servers != null)
	{
		agentlessServers.addAll(Arrays.asList(servers));
	}

	for(int i=0;i<serverList.size();i++)
	{
		String s_type = (String)serverList.get(i);
		if(agentlessServers.contains(s_type))
		{
			if(remoteAgents == null || remoteAgents.length < 1)
			{
				rootJSON.put("AlertType","Error");
				rootJSON.put("AlertTitle",_mapping.getTextDescription("admin.server.Add/Modify Component"));
				String msg = _mapping.getTextDescription("admin.server.Currently, there are no remote agents configured")+".";
				msg += _mapping.getTextDescription("admin.server.This component type can only be monitored by remote agents")+".";
				rootJSON.put("AlertMsg",msg);
				out.println(rootJSON);
				return;
			}
		}
	}

	String[] extAgents = null;
	boolean clientEmuComps = false;
	boolean isModifyServer = false;//(server != null && !server.equals("new"))?true:false;
	ArrayList emulatedList = extInfo.getEmulatedTypes();
	ArrayList usersCliEmuExtAgents = new ArrayList();
	ArrayList tempCliEmuExtAgents = new ArrayList();
	Object [] emuClient = extInfo.getClientEmulatingAgents();
	if(isLimitedAdmin)
	{
		if(emuClient != null && emuClient.length > 0)
		{
			usersCliEmuExtAgents = userElemInfoObj.getExternalAgentsForUser(user_id);
			tempCliEmuExtAgents = new ArrayList(Arrays.asList(emuClient));
			ArrayList otherCliExtAgents = nonUsersAgentList(user_id,"external");
			usersCliEmuExtAgents.retainAll(tempCliEmuExtAgents);
			if (otherCliExtAgents != null && isModifyServer)
			{
				otherCliExtAgents.retainAll(tempCliEmuExtAgents);
				usersCliEmuExtAgents.addAll(otherCliExtAgents);
			}
			tempCliEmuExtAgents.removeAll(usersCliEmuExtAgents);
			tempCliEmuExtAgents = egRoleInfo.removeDulpicates(tempCliEmuExtAgents);
			emuClient = (String[])usersCliEmuExtAgents.toArray(new String[0]);
		}
	}
	String serverType = serverList.isEmpty() ? "" : (String)serverList.get(0);
	if(emulatedList.contains(serverType))
	{
		clientEmuComps = true;
		if(emuClient != null && emuClient.length > 0)
		{
			extAgents = new String[emuClient.length];
			System.arraycopy(emuClient,0,extAgents,0,emuClient.length);
		}
		else
		{
			rootJSON.put("AlertType","Error");
			rootJSON.put("AlertTitle",_mapping.getTextDescription("admin.server.Add/Modify Component"));
			String msg = _mapping.getTextDescription("admin.server.Currently, there are no external agents with client emulation capability enabled")+".";
			msg += _mapping.getTextDescription("admin.server.This component can be managed only after an external agent with client emulation capability is added")+".";
			rootJSON.put("AlertMsg",msg);
			out.println(rootJSON);
			return;
		}
	}
	else
	{
		extAgents = extInfo.getAllExternalAgents();
		//Client Emulation enabled external agents will not execute normal external tests, so we are filtering here.
		//Object [] emuClient = extInfo.getClientEmulatingAgents();
		if(extInfo.isEmulationExclusiveExtAgents() && extAgents != null && emuClient != null)
		{
			ArrayList extAgentsList = new ArrayList(Arrays.asList(extAgents));
			ArrayList clEmuAgents = new ArrayList(Arrays.asList(emuClient));
			extAgentsList.removeAll(clEmuAgents);
			extAgents = (String[])extAgentsList.toArray(new String[0]);
		}
	}

	if(extAgents != null)
	{
		Arrays.sort(extAgents, String.CASE_INSENSITIVE_ORDER);
		List tmpList = new ArrayList();
		String defaultExtAgent = "";
		for (int j=0; j <extAgents.length;j++)
		{
			String tmpExtagent = extAgents[j];
			if (specsInfo.getEGServer().equals(tmpExtagent))
			{
				defaultExtAgent = tmpExtagent;
			}
			else
			{
				tmpList.add(tmpExtagent);
			}
		}
		if (!defaultExtAgent.equals(""))
		{
			tmpList.add(0,defaultExtAgent);
		}
		extAgents = (String[])tmpList.toArray(new String[0]);
	}
	/*
	 * Limited admin external and remote agents - STARTS
	 * by Meena.V
	 */

	if (isLimitedAdmin)
	{
		ArrayList tempRemoteAgents = userElemInfoObj.getRemoteAgentsForUser(user_id);
		ArrayList tempExternalAgents = userElemInfoObj.getExternalAgentsForUser(user_id);
		ArrayList otherExtAgents = nonUsersAgentList(user_id,"external");
		ArrayList otherRemAgents = nonUsersAgentList(user_id,"remote");
		String agentName = "";
		String usr_id = _user.getLoginID();
		boolean isDefOrgDirectUserWithShareRole = (uuidInfo.isUser(usr_id) && uuidInfo.hasOURole(usr_id) && uuidInfo.getDirectDependentOU(usr_id).equalsIgnoreCase("egenterprise"));

		if((tempRemoteAgents == null || tempRemoteAgents.size() == 0) && remoteAgents != null && remoteAgents.length > 0)
		{
			/* If the login user is direct user of default organization(egenterprise) then show the default remote agents to the user to add component.
			 * otherwise throw an alert to install or add new remote agent to the user to add component.
			 */
			if (isDefOrgDirectUserWithShareRole)
			{
				tempRemoteAgents.addAll(uuidInfo.getDefaultOrganizationAgentList("RemoteAgent"));
			}
			else if (flag)//if the comp type is agentless
			{
				tempRemoteAgents = new ArrayList();
				tempRemoteAgents.add("Not Applicable");
			}
		}
		else
		{
			tempRemoteAgents.addAll(otherRemAgents);
			tempRemoteAgents = egRoleInfo.removeDulpicates(tempRemoteAgents);
		}
		if(!clientEmuComps)
		{
			if (otherExtAgents != null && isModifyServer && tempExternalAgents != null)
			{
				tempExternalAgents.addAll(otherExtAgents);
			}
			if(tempExternalAgents != null && tempExternalAgents.size()>0)
			{
				tempExternalAgents = egRoleInfo.removeDulpicates(tempExternalAgents);

				if(usersCliEmuExtAgents != null && usersCliEmuExtAgents.size()>0)
				{
					tempExternalAgents.removeAll(usersCliEmuExtAgents);
				}
				if(tempCliEmuExtAgents != null && tempCliEmuExtAgents.size()>0)
				{
					tempExternalAgents.removeAll(tempCliEmuExtAgents);
				}
			}
			if((tempExternalAgents == null || tempExternalAgents.size() == 0) && extAgents != null && extAgents.length > 0)
			{
				/*  If the login user is direct user of default organization(egenterprise) then show the default external agent to the user to add component.
				*otherwise throw an alert to install or add new external agent to the user to add component.
				*/
				if (isDefOrgDirectUserWithShareRole)
				{
					tempExternalAgents.addAll(uuidInfo.getDefaultOrganizationAgentList("ExternalAgent"));
				}
				else
				{
					tempExternalAgents = new ArrayList();
					tempExternalAgents.add("Not Applicable");
				}
			}
		}
		else
		{
			if(usersCliEmuExtAgents != null)
			{
				tempExternalAgents = usersCliEmuExtAgents;
			}
			tempExternalAgents = egRoleInfo.removeDulpicates(tempExternalAgents);
		}
		remoteAgents = (String[])tempRemoteAgents.toArray(new String[0]);
		extAgents = (String[])tempExternalAgents.toArray(new String[0]);
	}

	if(!StringUtils.isNull(extAgent))
	{
		ArrayList alExtAgents = new ArrayList();
		StringTokenizer extAgentToken = new StringTokenizer(extAgent,",");
		while(extAgentToken.hasMoreTokens())
		{
			alExtAgents.add(extAgentToken.nextToken().trim());
		}
		for(int i=0;i<extAgents.length;i++)
		{
			if(alExtAgents.contains(extAgents[i]))
			{
				tmpExtAgents[i] = "selected";
				tmpExtAgentPopulated = true;
			}
		}
	}
	String selectedAgent =  "";
	if(!tmpExtAgentPopulated)
	{
		JSONArray extAgentsArr = new JSONArray();
		JSONArray extAgentsSelArr = new JSONArray();
		for (int a=0; a<extAgents.length; a++)
		{
			JSONObject obj = new JSONObject();
			obj.put("displayField",extAgents[a]);
			obj.put("valueField",extAgents[a].equalsIgnoreCase("Not Applicable") ? "-1" : extAgents[a]);
			extAgentsArr.add(obj);
			if (ArrayUtils.contains(allSelExtAgents, extAgents[a]))
			{
				selectedAgent = extAgents[a];
				extAgentsSelArr.add(selectedAgent);
			}
		}
		if (extAgentsSelArr.size() == 0)
		{
			ArrayList extAgentsList = new ArrayList(Arrays.asList(extAgents));
			if (extAgentsList.contains(defExtAgent))
			{
				extAgentsSelArr.add(defExtAgent);
			}
			else
			{
				extAgentsSelArr.add(extAgents[0]);
			}
		}
		rootJSON.put("externalAgents",extAgentsArr);
		if(extAgents.length == 1 && extAgents[0].equalsIgnoreCase("Not Applicable"))
		{
			rootJSON.put("defaultExternalAgents","-1");
		}
		else
		{
			rootJSON.put("defaultExternalAgents",extAgentsSelArr);
		}
	}
	else
	{
		JSONArray extAgentsArr = new JSONArray();
		JSONArray extAgentsSelArr = new JSONArray();
		for(int i=0;i<extAgents.length;i++)
		{
			JSONObject obj = new JSONObject();
			obj.put("displayField",extAgents[i]);
			obj.put("valueField",extAgents[i].equalsIgnoreCase("Not Applicable") ? "-1" : extAgents[i]);
			extAgentsArr.add(obj);
			if(tmpExtAgents[i].equals("selected"))
			{
				extAgentsSelArr.add(extAgents[i]);
			}
		}
		rootJSON.put("externalAgents",extAgentsArr);
		if(extAgents.length == 1 && extAgents[0].equalsIgnoreCase("Not Applicable"))
		{
			rootJSON.put("defaultExternalAgents","-1");
		}
		else
		{
			rootJSON.put("defaultExternalAgents",extAgentsSelArr);
		}
	}

	if(remoteAgents != null)
	{
		JSONArray rmtAgentsArr = new JSONArray();
		for (int r=0; r<remoteAgents.length; r++)
		{
			JSONObject obj = new JSONObject();
			obj.put("displayField",remoteAgents[r]);
			obj.put("valueField",remoteAgents[r].equalsIgnoreCase("Not Applicable") ? "-1" : remoteAgents[r]);
			rmtAgentsArr.add(obj);
		}
		rootJSON.put("remoteAgents",rmtAgentsArr);
		if(remoteAgents.length == 1 && remoteAgents[0].equalsIgnoreCase("Not Applicable"))
		{
			rootJSON.put("defaultRemoteAgents","-1");
		}
		else
		{
			rootJSON.put("defaultRemoteAgents",defaultRemoteAgent);
		}
	}

	String existing_agg_nicks = "";
	String component_types[] = discInfo.getComponentTypes();
	for(int i=0;i<component_types.length;i++)
	{
		String[] component = discInfo.getAllServersOfType(component_types[i]);
		if(component != null && component.length>0)
		{
			for(int j=0;j<component.length;j++)
			{
				String temp = component[j];
				existing_agg_nicks += "," + temp.substring(temp.indexOf(":")+1,temp.lastIndexOf(":")).toLowerCase();
			}
		}
	}
	if(existing_agg_nicks.length()>0)
	{
		existing_agg_nicks = existing_agg_nicks.substring(1);
		rootJSON.put("existing_agg_nicks",existing_agg_nicks);
	}
	String elementType = (String)session.getAttribute("elementType");
	String elementName = (String)session.getAttribute("elementType");
	if(!StringUtils.isNull(serverTypes))
	{
		String defaultSelAgent = "Not Applicable";
		if(externalAgentRunsAllAggTests)
		{
			if(extAgents != null && extAgents.length >= 1)
			{
				defaultSelAgent = extAgents[0];
			}
		}
		else
		{
			if(remoteAgents != null && remoteAgents.length >= 1)
			{
				defaultSelAgent = remoteAgents[0];
			}
		}
		String componentTypes[] = StringUtils.getTokens(serverTypes,",");
		for(int i=0;i<componentTypes.length;i++)
		{
			JSONObject gridValues = new JSONObject();
			String dispNickName = componentTypes[i];
			gridValues.put("componentType",_mapping.getComponentTypeDescription(dispNickName));
			dispNickName = dispNickName.substring(dispNickName.indexOf("_")+1);
			if(dispNickName.indexOf("_")>0)
			{
				if(dispNickName.indexOf("_") == dispNickName.lastIndexOf("_"))
				{
					dispNickName=dispNickName.substring(0,dispNickName.indexOf("_"));
				}
				else
				{
					dispNickName=dispNickName.substring(0,dispNickName.lastIndexOf("_"));
				}
			}
			gridValues.put("nickname",dispNickName);
			gridValues.put("agentList",defaultSelAgent);
			gridValuesArray.add(gridValues);
		}
		rootJSON.put("gridValues",gridValuesArray);

		JSONArray reservedWord = new JSONArray();
		Iterator itr = IniUI.reservedKeywords.iterator();
		while(itr.hasNext())
		{
			reservedWord.add((String)itr.next());
		}
		rootJSON.put("reservedWord",reservedWord);
		out.println(rootJSON.toString());
	}
%>

<%!
	public ArrayList nonUsersAgentList(String userID, String agentType)
	{
		ArrayList agentList = new ArrayList();
		if (userID != null && !userID.equals(""))
		{
			String sectionName = (agentType != null && agentType.equalsIgnoreCase("external")) ? "Test_Mapping_Section" : "Remote_Agent_Mapping_Section";
			String extIniFile = EgConfigInfo.egMgrConfigDir + "eg_external.ini";
			IniFile extIniObj = new IniFile(extIniFile);
			ArrayList compMapList = getUserCompsNick(userID);
			if (compMapList != null)
			{
				int compListLen = compMapList.size();
				for(int i=0; i<compListLen; i++)
				{
					String tempTestMapVal = extIniObj.getValue(sectionName,compMapList.get(i).toString());
					if(tempTestMapVal != null && tempTestMapVal.length()>0)
					{
						ArrayList tempList = StringUtils.egTokenizer(tempTestMapVal, ",", false, true, true);
						agentList.addAll(tempList);
					}
				}
			}
		}
		return agentList;
	}

	public ArrayList getUserCompsNick(String userID)
	{
		ErUserData erUser = new ErUserData(userID,false);
		ArrayList compMapNickList = new ArrayList(erUser.getAllUserComponents(1));
		ArrayList resultList = new ArrayList();
		if(compMapNickList != null)
		{
			int compListLen = compMapNickList.size();
			for (int x=0; x<compListLen; x++)
			{
				String tempCompMapVal = compMapNickList.get(x).toString();
				tempCompMapVal = tempCompMapVal.substring(0,tempCompMapVal.indexOf(":"));
				resultList.add(tempCompMapVal);
			}
		}
		return resultList;
	}
%>