<%@ include file="../../EgTrackerAJSON.jsp"%>
<%@ page import = "java.util.*"%>
<%@ page import = "java.io.*"%>
<%@ page import = "net.sf.json.*"%>

<%@ page import="com.eg.*"%>
<%@ page import="com.egurkha.util.StringUtils"%>
<%@ page import="egurkha.EgUIUtils"%>

<%@ page language = "java" contentType = "text/html; charset=UTF-8" pageEncoding = "UTF-8" %>

<%!
	private int[] instlStsColNosToDisplay = {0, 1, 2, 3, 5, 6, 7, 10, 11, 12};
	
	IniFile egServicesIniFile = new IniFile(EGAgntRmtInstlrThreadHandler.egServicesIniFilePath);
	String eGMgrModel = egServicesIniFile.getValue("MISC_ARGS","eGMgrModel");
	
	private Map getStsClrCdsFrmIni(IniFile agntPushParamsIniFile)
	{
		Map colorCodesForStatus = new HashMap();
		
		String[] statusColorCodes = agntPushParamsIniFile.getLinesUnderSubject(EGAgntRmtInstlrThreadHandler.CONST_INI_SUB_COLOR_CODES);
		
		for(int incr=0; incr<statusColorCodes.length; incr++)
		{
			String curLine = statusColorCodes[incr];
			int indexEqSgn = curLine.indexOf("=");
			int indexComma = curLine.indexOf(",");
			if( (indexEqSgn > -1) && (indexComma > -1) )
			{
				String statusCode = curLine.substring(0, indexEqSgn);
				String colorCode = curLine.substring(indexEqSgn+1, indexComma);
				String borderColorCode = curLine.substring(indexComma+1);
				
				Map colorCodes = new HashMap();
				colorCodes.put(EGAgntRmtInstlrThreadHandler.CONST_MAP_KEY_MPD_STS_CLR_CD, colorCode);
				colorCodes.put(EGAgntRmtInstlrThreadHandler.CONST_MAP_KEY_STS_BRDR_CLR_CD, borderColorCode);
				
				colorCodesForStatus.put(statusCode.toUpperCase(), colorCodes);
			}
		}
		return colorCodesForStatus;
	}

	private long getAutoRfrshPrdForInstlStsPage(IniFile agntPushParamsIniFile)
	{
		long autoRfrshPrd = EGAgntRmtInstlrThreadHandler.defaultAutoRfrshPrdForInstlStsPageInScnds;
		String autoRfrshPrdFrmIniAsStr = agntPushParamsIniFile.getValue(EGAgntRmtInstlrThreadHandler.CONST_INI_SUB_AUTO_RFRSH_PRD, EGAgntRmtInstlrThreadHandler.CONST_INI_KEY_AUTO_RFRSH_PRD);
		if( (autoRfrshPrdFrmIniAsStr != null) && (!"".equals(autoRfrshPrdFrmIniAsStr.trim())) )
		{
			try
			{
				autoRfrshPrd = Long.parseLong(autoRfrshPrdFrmIniAsStr.trim()) * 1000;
			}
			catch(NumberFormatException nfe)
			{
				// System.out.println("Agent install status details page has wrong auto refresh period in seconds in the INI file.");
			}
		}
		return autoRfrshPrd;
	}
	
	private JSONArray getDomainsJsonArray(List rgstrdDmnsInEg, EgMappingInfo _mapping)
	{
		JSONArray domainList = new JSONArray();
		
		JSONObject domainObj = new JSONObject();
		domainObj.put("displayField",_mapping.getTextDescription("admin.agentsInstallation.Select a domain"));
		domainObj.put("valueField","-1");
		domainList.add(domainObj);
		
		if(rgstrdDmnsInEg != null)
		{
			for(int incr=0; incr<rgstrdDmnsInEg.size(); incr++)
			{
				Map curRgstrdDmn = (HashMap)rgstrdDmnsInEg.get(incr);
				
				domainObj.put("displayField",(String)curRgstrdDmn.get("DisplayName") + " (" + (String)curRgstrdDmn.get("DomainName") + ")");
				domainObj.put("valueField",(String)curRgstrdDmn.get("DomainName"));
				domainList.add(domainObj);
			}				
		}
		return domainList;
	}
	
	private JSONArray getOusJsonArray(List orgUnits, LDAPHandler ldapHndlr, String s_domain_name, EgMappingInfo _mapping)
	{
		JSONArray oUList = new JSONArray();
		
		JSONObject oUObj = new JSONObject();
		oUObj.put("displayField",_mapping.getTextDescription("admin.ic.Select an organizational unit"));
		oUObj.put("valueField","-1");
		oUList.add(oUObj);
		
		String searchBase = ldapHndlr.getSearchBase(s_domain_name);
		oUObj.put("displayField", "ROOT" + " (" + searchBase + ")");
		oUObj.put("valueField", searchBase);
		oUList.add(oUObj);				
		
		if(orgUnits != null)
		{
			for(int incr=0; incr<orgUnits.size(); incr++)
			{
				Map curOrgUnit = (HashMap)orgUnits.get(incr);
				String ouName = (String)curOrgUnit.get("name");
				String dstnghdNm = (String)curOrgUnit.get("distinguishedName");
				
				oUObj.put("displayField", ouName + " (" + dstnghdNm + ")");
				oUObj.put("valueField",dstnghdNm);
				oUList.add(oUObj);
			}						
		}		
		return oUList;
	}
	
	private Map listComputersJsonArray(List computers, EgMappingInfo _mapping)
	{
		Map jsonArrays = new HashMap();
		
		JSONArray computerList = new JSONArray();
		JSONObject computerObj = new JSONObject();
		
		Set uniqueOS = new HashSet();
		if( (computers != null) && (computers.size() > 0) )
		{
			for(int incr=0; incr<computers.size(); incr++)
			{
				Map curComputer = (HashMap)computers.get(incr);
				String dnsHostName = (String)curComputer.get("dNSHostName");
				String operatingSystem = (String)curComputer.get("operatingSystem");
				String cn = (String)curComputer.get("cn");
				
				String displayField = null;
				String valueField = null;
				
				if( (dnsHostName != null) && (!"".equals(dnsHostName.trim())) )
				{
					if( (operatingSystem != null) && (!"".equals(operatingSystem.trim())) )
					{
						// displayField = dnsHostName + " (" + operatingSystem + ")";
						displayField = cn + " (" + operatingSystem + ")";
						valueField = dnsHostName;
					}
					else
					{
						// displayField = dnsHostName;
						displayField = cn;
						valueField = dnsHostName;
					}
				}
				else
				{
					if( (operatingSystem != null) && (!"".equals(operatingSystem.trim())) )
					{
						displayField = cn + " (" + operatingSystem + ")";
						valueField = cn;
					}
					else
					{
						displayField = cn;
						valueField = cn;
					}						
				}
				computerObj.put("displayField",displayField);
				computerObj.put("valueField",valueField);
				computerList.add(computerObj);
				
				if( (operatingSystem != null) && (!"".equals(operatingSystem.trim())) )
				{
					uniqueOS.add(operatingSystem);
				}
			}
		}
		else
		{
			computerObj.put("displayField",_mapping.getTextDescription("admin.agentsInstallation.options.No computers available"));
			computerObj.put("valueField","-1");
			computerList.add(computerObj);
		}
		
		JSONArray uniqueOSList = new JSONArray();
		JSONObject uniqueOSObj = new JSONObject();
		
		uniqueOSObj.put("displayField",_mapping.getTextDescription("admin.agentsInstallation.options.ALL"));
		uniqueOSObj.put("valueField","ALL");
		uniqueOSList.add(uniqueOSObj);

		uniqueOSObj.put("displayField",("[" + _mapping.getTextDescription("admin.agentsInstallation.options.Computers not having OS data") + "]"));
		uniqueOSObj.put("valueField","-1");
		uniqueOSList.add(uniqueOSObj);
		
		Iterator osItr = uniqueOS.iterator();
		while(osItr.hasNext())
		{
			String curOS = (String)osItr.next();
			uniqueOSObj.put("displayField",curOS);
			uniqueOSObj.put("valueField",curOS);
			uniqueOSList.add(uniqueOSObj);
		}

		jsonArrays.put("computersList", computerList);
		jsonArrays.put("operatingSystems", uniqueOSList);
		
		return jsonArrays;
	}
	
	private Map getAgntAvlbltyJsonArrays(Map fltrdNotInstldAgntTrgtHosts)
	{
		Map jsonArrays = new HashMap();
		
		JSONArray agntInstldTrgtHostsJsonArr = new JSONArray();
		List agntInstldTrgtHosts = (ArrayList)fltrdNotInstldAgntTrgtHosts.get("AgntInstalledTrgHosts");
		for(int incr=0; incr<agntInstldTrgtHosts.size(); incr++)
		{
			JSONObject agntInstldTrgtHostsJsonObj = new JSONObject();
			agntInstldTrgtHostsJsonObj.put("displayField", (String)agntInstldTrgtHosts.get(incr));
			agntInstldTrgtHostsJsonObj.put("valueField", (String)agntInstldTrgtHosts.get(incr));
			agntInstldTrgtHostsJsonArr.add(agntInstldTrgtHostsJsonObj);
		}
		
		JSONArray agntNotInstldTrgtHostsJsonArr = new JSONArray();
		List agntNotInstldTrgtHosts = (ArrayList)fltrdNotInstldAgntTrgtHosts.get("AgntNotInstalledTrgHosts");
		for(int incr=0; incr<agntNotInstldTrgtHosts.size(); incr++)
		{
			JSONObject agntNotInstldTrgtHostsJsonObj = new JSONObject();
			agntNotInstldTrgtHostsJsonObj.put("displayField", (String)agntNotInstldTrgtHosts.get(incr));
			agntNotInstldTrgtHostsJsonObj.put("valueField", (String)agntNotInstldTrgtHosts.get(incr));
			agntNotInstldTrgtHostsJsonArr.add(agntNotInstldTrgtHostsJsonObj);
		}
		
		jsonArrays.put("agntAlrdyInstldtTrgHsts", agntInstldTrgtHostsJsonArr);
		jsonArrays.put("agntNotInstldtTrgHsts", agntNotInstldTrgtHostsJsonArr);
	
		return jsonArrays;
	}
	
	private List getAgentInstalledTrgtHsts()
	{
		Set uniqueAllAgents = new HashSet();
		EgLicenseInfo licInfo = new EgLicenseInfo();
		uniqueAllAgents.addAll(licInfo.getPremiumAgents());
		uniqueAllAgents.addAll(licInfo.getExternalAgents());
		uniqueAllAgents.addAll(licInfo.getBasicAgents());
		uniqueAllAgents.addAll(licInfo.getPremiumAgents());
		uniqueAllAgents.addAll(licInfo.getRemoteAgents());
		
		EgServerList serverList = new EgServerList();
		ArrayList agntLstDB = serverList.getAgentListFromDB(); 
		String[] curTrgtNms = serverList.getTargetNames();

		List agntInstalledTrgtHsts = new ArrayList();
		
		List agntListwInstlSts = serverList.getAgentList((new ArrayList(uniqueAllAgents)), agntLstDB, curTrgtNms);
		
		for(int incr=1; incr<agntListwInstlSts.size(); incr=incr+4)
		{
			String temp = (String)agntListwInstlSts.get(incr);
			if( (temp != null) && (temp.startsWith("Installed-")) )
			{
				agntInstalledTrgtHsts.add(agntListwInstlSts.get(incr-1));
			}
		}
		return agntInstalledTrgtHsts;
	}

	private Map fltrNotInstldAgntTrgtHosts(List instldAgntsTrgHsts, String domain, String[] trgHstsToFilter)
	{
		Map filteredOutput = new HashMap();

		List filteredInstldAgnts = new ArrayList();
		List filteredNotInstldAgnts = new ArrayList();
		
		filteredOutput.put("AgntInstalledTrgHosts", filteredInstldAgnts);
		filteredOutput.put("AgntNotInstalledTrgHosts", filteredNotInstldAgnts);
		
		if( (instldAgntsTrgHsts != null) && (instldAgntsTrgHsts.size() > 0) )
		{
			domain = (domain==null) ? "" : domain;
			
			for(int incr=0; incr<trgHstsToFilter.length; incr++)
			{
				String curTrgtHst = trgHstsToFilter[incr];
				String curTrgtHstWithoutDmn = null;
				if(curTrgtHst.toLowerCase().endsWith("."+domain.toLowerCase()))
				{
					curTrgtHstWithoutDmn = curTrgtHst.substring(0, curTrgtHst.toLowerCase().indexOf("."+domain.toLowerCase()));
				}
				else
				{
					curTrgtHstWithoutDmn = curTrgtHst;
				}
				
				boolean isMatched = false;
				for(int incr1=0; incr1<instldAgntsTrgHsts.size(); incr1++)
				{
					String curInstldAgntsTrgHst = (String)instldAgntsTrgHsts.get(incr1);
					if( (curInstldAgntsTrgHst != null) && (curInstldAgntsTrgHst.equalsIgnoreCase(curTrgtHstWithoutDmn)) )
					{
						filteredInstldAgnts.add(curTrgtHstWithoutDmn);
						isMatched = true;
						break;
					}
				}
				if(!isMatched)
				{
					filteredNotInstldAgnts.add(curTrgtHstWithoutDmn);
				}
			}
			filteredOutput.put("AgntInstalledTrgHosts", filteredInstldAgnts);
			filteredOutput.put("AgntNotInstalledTrgHosts", filteredNotInstldAgnts);
		}
		else
		{
			filteredNotInstldAgnts.addAll(Arrays.asList(trgHstsToFilter));
			
			filteredOutput.put("AgntInstalledTrgHosts", filteredInstldAgnts);
			filteredOutput.put("AgntNotInstalledTrgHosts", filteredNotInstldAgnts);
		}
		
		return filteredOutput;
	}
	
	private Map getRemoteInstallationDetailsForUI(IniFile agntPushParamsIniFile, List remoteInstallDetails, String loggedInUserId, String givenTrgtSrchWord, boolean showInstallingSts, boolean showInstalledSts, boolean showAlrdyInstalledSts, boolean showFailedSts)
	{
		Map stsClrCdsFrmIni = getStsClrCdsFrmIni(agntPushParamsIniFile);
		
		long instlStsPageAutoRfrshPrd = getAutoRfrshPrdForInstlStsPage(agntPushParamsIniFile);
		
		Map remtInstlDtlsForDisplay = new HashMap();
		List rowForDisplay = new ArrayList();
		for(int incr=0; incr<remoteInstallDetails.size(); incr++)
		{
			String[] curRmtInstlDtl = (String[])remoteInstallDetails.get(incr);
			Map curRmtInstlDtlForDsply = new HashMap();
			for(int incr1=0; incr1<instlStsColNosToDisplay.length; incr1++)
			{
				curRmtInstlDtlForDsply.put(EGAgntRmtInstlrThreadHandler.installStsDtlsIniCols[instlStsColNosToDisplay[incr1]], curRmtInstlDtl[instlStsColNosToDisplay[incr1]]);
				if(instlStsColNosToDisplay[incr1] == 5)
				{
					if(stsClrCdsFrmIni != null)
					{
						String status = curRmtInstlDtl[instlStsColNosToDisplay[incr1]];
						if(status != null)
						{
							curRmtInstlDtlForDsply.put(EGAgntRmtInstlrThreadHandler.CONST_MAP_KEY_MPD_STS_CLR_CD, ((HashMap)stsClrCdsFrmIni.get(status)).get(EGAgntRmtInstlrThreadHandler.CONST_MAP_KEY_MPD_STS_CLR_CD));
							curRmtInstlDtlForDsply.put(EGAgntRmtInstlrThreadHandler.CONST_MAP_KEY_STS_BRDR_CLR_CD, ((HashMap)stsClrCdsFrmIni.get(status)).get(EGAgntRmtInstlrThreadHandler.CONST_MAP_KEY_STS_BRDR_CLR_CD));
						}
					}
				}
			}
			rowForDisplay.add(curRmtInstlDtlForDsply);
		}
		remtInstlDtlsForDisplay.put("details", rowForDisplay);
		remtInstlDtlsForDisplay.put("loggedInUserId", loggedInUserId);
		remtInstlDtlsForDisplay.put("givenTrgtSrchWord", givenTrgtSrchWord);
		remtInstlDtlsForDisplay.put("showInstallingSts", showInstallingSts);
		remtInstlDtlsForDisplay.put("showInstalledSts", showInstalledSts);
		remtInstlDtlsForDisplay.put("showAlrdyInstalledSts", showAlrdyInstalledSts);
		remtInstlDtlsForDisplay.put("showFailedSts", showFailedSts);
		remtInstlDtlsForDisplay.put("autoRrfrshPrdInScnds", instlStsPageAutoRfrshPrd);
	
		return remtInstlDtlsForDisplay;
	}
%>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
	response.setContentType("text/html;charset=UTF-8");

	com.egurkha.User user = com.egurkha.UserRegistry.getInstance().getUser(session.getId());

	JSONObject rootJson = new JSONObject();

	if(user != null && ("enterprise".equalsIgnoreCase(eGMgrModel)))
	{
		String command = request.getParameter("command");

		LDAPHandler ldapHndlr = new LDAPHandler();
		
		String loggedInUserId = user.getLoginID();
		
		String loggedInUserRoleNm = user.getUserRole().getRoleName();

		if(command.equalsIgnoreCase("getDomains"))
		{
			List rgstrdDmnsInEg = ldapHndlr.getRgstrdDmnsInEG();
			rootJson.put("domainList",getDomainsJsonArray(rgstrdDmnsInEg, _mapping));
 		}
		else if(command.equalsIgnoreCase("getOusForDomain"))
		{
			String s_domain_name = request.getParameter("s_domain_name");
			if(s_domain_name != null && (s_domain_name.trim().length()>0) && !s_domain_name.equals("-1")
				&& !s_domain_name.equalsIgnoreCase("null"))
			{
				List rgstrdDmnsInEg = ldapHndlr.getRgstrdDmnsInEG();
				String domainUser = null;
				String domainPwd = null;
				Boolean domainIsSecure = null;
				String domainPort = null;
				if(rgstrdDmnsInEg != null)
				{
					for(int incr=0; incr<rgstrdDmnsInEg.size(); incr++)
					{
						Map curRgstrdDmn = (HashMap)rgstrdDmnsInEg.get(incr);
						if(s_domain_name.equalsIgnoreCase((String)curRgstrdDmn.get("DomainName")))
						{
							domainUser = (String)curRgstrdDmn.get("DomainUser");
							domainPwd = (String)curRgstrdDmn.get("DomainPwd");
							domainIsSecure = ("True".equalsIgnoreCase((String)curRgstrdDmn.get("DomainIsSSL"))) ? Boolean.TRUE : Boolean.FALSE;
							break;
						}
					}				
				}

				List orgUnits = ldapHndlr.getAllOUsInDomain(s_domain_name, domainUser, EgCrypt.decrypt(domainPwd), domainIsSecure, new String[]{"name", "distinguishedName"}, new String[]{"name"});

				rootJson.put("oUList",getOusJsonArray(orgUnits, ldapHndlr, s_domain_name, _mapping));
			}
		}
		else if(command.equalsIgnoreCase("srchCmptrsForMtchngStrng"))
		{
			String s_domain_name = request.getParameter("s_domain_name");
			String s_srchString = request.getParameter("s_srchString");
			if(  (s_srchString != null) &&  (s_domain_name != null) && (s_domain_name.trim().length()>0) && (!s_domain_name.equals("-1"))
				&& (!s_domain_name.equalsIgnoreCase("null")) )
			{
				List rgstrdDmnsInEg = ldapHndlr.getRgstrdDmnsInEG();
				String domainUser = null;
				String domainPwd = null;
				Boolean domainIsSecure = null;
				String domainPort = null;
				if(rgstrdDmnsInEg != null)
				{
					for(int incr=0; incr<rgstrdDmnsInEg.size(); incr++)
					{
						Map curRgstrdDmn = (HashMap)rgstrdDmnsInEg.get(incr);
						if(s_domain_name.equalsIgnoreCase((String)curRgstrdDmn.get("DomainName")))
						{
							domainUser = (String)curRgstrdDmn.get("DomainUser");
							domainPwd = (String)curRgstrdDmn.get("DomainPwd");
							domainIsSecure = ("True".equalsIgnoreCase((String)curRgstrdDmn.get("DomainIsSSL"))) ? Boolean.TRUE : Boolean.FALSE;
							break;
						}
					}
					String[] s_srchStringArr = s_srchString.split(",");
					List computers = ldapHndlr.searchComputersInDomain(s_domain_name, domainUser, EgCrypt.decrypt(domainPwd), domainIsSecure, s_srchStringArr, new String[]{"dNSHostName", "operatingSystem", "cn"}, new String[] {"dNSHostName"}, EGAgntRmtInstlrThreadHandler.excldOprtngSystms);
					
					Map jsonArrays = listComputersJsonArray(computers, _mapping);

					rootJson.put("computersList",(JSONArray)jsonArrays.get("computersList"));
					
					rootJson.put("operatingSystems",(JSONArray)jsonArrays.get("operatingSystems"));
				}
			}
		}
		else if(command.equalsIgnoreCase("listComputersForDomainOU"))
		{
			String s_domain_name = request.getParameter("s_domain_name");
			s_domain_name=StringUtils.isNull(s_domain_name)?"-1":s_domain_name;

			String s_ou = EgUIUtils.decodeSecurityChar(request.getParameter("s_ou"));
			s_ou=StringUtils.isNull(s_ou)?"-1":s_ou;
			
			if( (!s_domain_name.equals("-1")) && (!s_ou.equals("-1")) )
			{
				List rgstrdDmnsInEg = ldapHndlr.getRgstrdDmnsInEG();
				String domainUser = null;
				String domainPwd = null;
				Boolean domainIsSecure = null;
				String domainPort = null;
				if(rgstrdDmnsInEg != null)
				{
					for(int incr=0; incr<rgstrdDmnsInEg.size(); incr++)
					{
						Map curRgstrdDmn = (HashMap)rgstrdDmnsInEg.get(incr);
						if(s_domain_name.equalsIgnoreCase((String)curRgstrdDmn.get("DomainName")))
						{
							domainUser = (String)curRgstrdDmn.get("DomainUser");
							domainPwd = (String)curRgstrdDmn.get("DomainPwd");
							domainIsSecure = ("True".equalsIgnoreCase((String)curRgstrdDmn.get("DomainIsSSL"))) ? Boolean.TRUE : Boolean.FALSE;
							break;
						}
					}				
				}

				List computers = ldapHndlr.getAllComputersInGvnSrchBase(s_domain_name, domainUser, EgCrypt.decrypt(domainPwd), domainIsSecure, s_ou, new String[]{"dNSHostName", "operatingSystem", "cn"}, new String[] {"dNSHostName"}, EGAgntRmtInstlrThreadHandler.excldOprtngSystms);

				Map jsonArrays = listComputersJsonArray(computers, _mapping);

				rootJson.put("computersList",(JSONArray)jsonArrays.get("computersList"));
				
				rootJson.put("operatingSystems",(JSONArray)jsonArrays.get("operatingSystems"));
			}
		}
		else if(command.equalsIgnoreCase("checkAgntAvlblty"))
		{
			String selectedDomain = request.getParameter("s_domainName");
			String[] selectedComputers = request.getParameterValues("s_computer_list");

			Map fltrdNotInstldAgntTrgtHosts = (HashMap)fltrNotInstldAgntTrgtHosts(getAgentInstalledTrgtHsts(), selectedDomain, selectedComputers);
			
			Map jsonArrays = getAgntAvlbltyJsonArrays(fltrdNotInstldAgntTrgtHosts);
			
			rootJson.put("agntAlrdyInstldtTrgHsts", (JSONArray)jsonArrays.get("agntAlrdyInstldtTrgHsts"));
			rootJson.put("agntNotInstldtTrgHsts", (JSONArray)jsonArrays.get("agntNotInstldtTrgHsts"));
		}
		else if(command.equalsIgnoreCase("startInstallFrmLDAP"))
		{
			String s_domain_name = request.getParameter("s_domain_name");
			s_domain_name=StringUtils.isNull(s_domain_name)?"-1":s_domain_name;

			String[] s_computer_list = request.getParameterValues("s_computer_list");
			
			if( (!s_domain_name.equals("-1")) && (!s_computer_list.equals("-1")) )
			{
				Map rawTargetHostDetails = new HashMap();
				rawTargetHostDetails.put("eGRgstrdTrgtHstDmnNm", s_domain_name);
				rawTargetHostDetails.put("computerList", s_computer_list);
				
				com.eg.EGAgntRmtInstlKickerThread eGAgntRmtInstlKickerThreadObj = new EGAgntRmtInstlKickerThread(loggedInUserId, EGAgntRmtInstlrThreadHandler.CONST_TRGGR_SRC_DMN_BSD, rawTargetHostDetails, Boolean.parseBoolean(request.getParameter("isDebug_methodEntryExit")), Boolean.parseBoolean(request.getParameter("isDebug")), Boolean.FALSE);

				eGAgntRmtInstlKickerThreadObj.start();
			}
		}
		else if(command.equalsIgnoreCase("startInstallFrmDscvry"))
		{
			String s_hstIpsNms = request.getParameter("hstIpsNms");
			
			if( (s_hstIpsNms != null) && (!"".equals(s_hstIpsNms.trim())) )
			{
				com.eg.EGAgntRmtInstlKickerThread eGAgntRmtInstlKickerThreadObj = new EGAgntRmtInstlKickerThread(loggedInUserId, EGAgntRmtInstlrThreadHandler.CONST_TRGGR_SRC_DSCVRY, s_hstIpsNms, Boolean.parseBoolean(request.getParameter("isDebug_methodEntryExit")), Boolean.parseBoolean(request.getParameter("isDebug")), Boolean.FALSE);
				eGAgntRmtInstlKickerThreadObj.start();
			}
		}		
		else if(command.equalsIgnoreCase("getAllInstallationStatus")) 
		{
			String givenTrgtSrchWord = EgUIUtils.decodeSecurityChar(request.getParameter("trgtSrchWrd"));
			boolean showInstallingSts = request.getParameter("s_Installing") != null ? Boolean.valueOf(request.getParameter("s_Installing")).booleanValue() : true;
			boolean showInstalledSts = request.getParameter("s_Installed") != null ? Boolean.valueOf(request.getParameter("s_Installed")).booleanValue() : true;			
			boolean showAlrdyInstalledSts = request.getParameter("s_AlrdyInstalled") != null ? Boolean.valueOf(request.getParameter("s_AlrdyInstalled")).booleanValue() : true;						
			boolean showFailedSts = request.getParameter("s_Failed") != null ? Boolean.valueOf(request.getParameter("s_Failed")).booleanValue() : true;						

			EGAgntRmtInstlrThreadHandler eGAgntRmtInstlrThrdHndlr = EGAgntRmtInstlrThreadHandler.getInstance();
			List remoteInstallDetails = eGAgntRmtInstlrThrdHndlr.getRemoteInstallationDetails(loggedInUserId, loggedInUserRoleNm, givenTrgtSrchWord, showInstallingSts, showInstalledSts, showAlrdyInstalledSts, showFailedSts);
			
			rootJson.put("remoteInstallDetails", getRemoteInstallationDetailsForUI(eGAgntRmtInstlrThrdHndlr.agntPushParamsIniFile, remoteInstallDetails, loggedInUserId, givenTrgtSrchWord, showInstallingSts, showInstalledSts, showAlrdyInstalledSts, showFailedSts));
		}
		else if(command.equalsIgnoreCase("getLogDetails")) 
		{
			String installationSts = request.getParameter("installationSts");
			String fileName = request.getParameter("fileName");
			
			String filePath = null;
			
			if(EGAgntRmtInstlrThreadHandler.CONST_INSTL_STS_INSTLD.equals(installationSts))
			{
				filePath = EGAgntRmtInstlrThreadHandler.successInstallFolderPath + "\\" + fileName;
			}
			else if(EGAgntRmtInstlrThreadHandler.CONST_INSTL_STS_FAILED.equals(installationSts))
			{
				filePath = EGAgntRmtInstlrThreadHandler.failedInstallFolderPath + "\\" + fileName;
			}
			else if(EGAgntRmtInstlrThreadHandler.CONST_INSTL_STS_ALRY_INSTD.equals(installationSts))
			{
				filePath = EGAgntRmtInstlrThreadHandler.alrdyInstallFolderPath + "\\" + fileName;
			}
			
			BufferedReader buffReader = null;
			FileReader fileReader = null;
			try
			{
				fileReader = new FileReader(filePath);
				buffReader = new BufferedReader(fileReader);
				StringBuilder stringBuilder = new StringBuilder();
				String line = null;
				while ((line = buffReader.readLine()) != null) 
				{
					stringBuilder.append(line);
					stringBuilder.append("<br>");
				}
				// delete the last new line separator
				stringBuilder.deleteCharAt(stringBuilder.length() - 1);

				String content = stringBuilder.toString();				
				rootJson.put("logContent", content);
			}
			catch(Exception e)
			{
				
			}
			finally
			{
				fileReader.close();
				buffReader.close();				
			}
		}
	}
	else
	{
		throw new Exception();
	}

	rootJson.put("success","true");
	out.println(rootJson.toString());
%>