<%
/*
 *	Name		:	EgAgentSummaryJson.jsp
 *	Purpose		:	To view all agents summary details
 *	Navigation	:	Home > [Click here to get the license details] > [Agent Status]
 */
%>

<%@ include file="../../EgTrackerAJSON.jsp"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>

<%@ page import="egurkha.UserBean" %>
<%@ page import="com.eg.EgUsersInfo"%>
<%@ page import="com.eg.EgLicenseInfo"%>
<%@ page import="com.eg.EgRoleInfo"%>
<%@ page import="com.eg.EgServerList"%>
<%@ page import="java.util.ArrayList"%>
<%@ page import="java.util.Map"%>


<%@ page import="org.json.simple.JSONObject"%>
<%@ page import="org.json.simple.JSONArray"%>

<%
	response.setContentType("application/json;charset=UTF-8");

	EgRoleInfo roleInfo = EgRoleInfo.getInstance(sessionID,_user.getLoginID());
	EgUsersInfo usersInfo = new EgUsersInfo();
	UserBean userBean = new UserBean();
	EgServerList serverList = new EgServerList();
	EgLicenseInfo licInfo = new EgLicenseInfo();

	JSONArray agentsSummaryGridData = new JSONArray();
	JSONObject rootJSON = new JSONObject();

	List csvData = new ArrayList();
	ArrayList aList = serverList.getAgentListFromDB();
	String currList[] = serverList.getTargetNames();
	ArrayList noLicenseAgentList = userBean.getAgentsWithNoLicense();
	boolean hasAllCompAccess = roleInfo.hasAllComponentAccess(); // For Limited admin

	ArrayList noLiceList = EgInstallInfo.getCertCheckList();
	boolean agentsWithNoLicense = (noLiceList != null && noLiceList.size() > 0);
	
	int agentSummarytotalCount = 0;
	csvData.add("Agent Summary Report");
	csvData.add("");
	csvData.add("");
	csvData.add("Agent Type"+","+"Total Agents"+","+"Running"+","+"Not Running");

	String[] agent_types = new String[]{"Basic Agents","Premium Agents","External Agents","Remote Agents"};
	ArrayList agentTypes = new ArrayList(Arrays.asList(agent_types));
	
	if(agentsWithNoLicense)
	{
		agentTypes.add("Agents with no license");
	}
	if(usersInfo.isUserBasedLicense())
	{
		agentTypes.add("Agents for user licensed types");
	}
	
	for(int i=0;i<agentTypes.size();i++)
	{
		JSONObject agentTypesObj = new JSONObject();
		ArrayList agentsList = new ArrayList();
		String agent_type = (String)agentTypes.get(i);
		if(agent_type.equalsIgnoreCase("Basic Agents"))
		{
			agentsList = hasAllCompAccess ? licInfo.getBasicAgents() : roleInfo.getBasicAgents();
		}
		else if(agent_type.equalsIgnoreCase("Premium Agents"))
		{
			agentsList = hasAllCompAccess ? userBean.getPremiumAgents() : roleInfo.getPremiumAgents();
		}
		else if(agent_type.equalsIgnoreCase("External Agents"))
		{
			agentsList = hasAllCompAccess ? licInfo.getExternalAgents() : roleInfo.getExternalAgents();
		}
		else if(agent_type.equalsIgnoreCase("Remote Agents"))
		{
			agentsList = hasAllCompAccess ? licInfo.getRemoteAgents() : roleInfo.getRemoteAgents();
		}
		else if(agent_type.equalsIgnoreCase("Agents with no license"))
		{
			if(hasAllCompAccess)
			{
				agentsList.addAll(noLicenseAgentList);
			}
			else
			{
				ArrayList tmpListCertCheckList = EgInstallInfo.getCertCheckList();
				ArrayList noLicenseComTypes  = new ArrayList();
				if (tmpListCertCheckList != null)
				{
					int size = tmpListCertCheckList.size();
					for (int t=0; t<size; t++)
					{
						String compType = (String)tmpListCertCheckList.get(t);
						compType = EgCrypt.decrypt(compType);
						noLicenseComTypes.add(compType);
					}
				}

				ArrayList allServersList = roleInfo.getAllServers();
				int allServerListSize = allServersList.size();
				for(int j = 0; j<allServerListSize; j++)
				{
					String temp = (String)allServersList.get(j);
					int cmpInd = temp.indexOf(":");
					String s_compType = temp.substring(0,cmpInd);
					if(noLicenseComTypes.contains(s_compType))
					{
						temp = temp.substring(cmpInd+1);
						String s_compNick = temp.substring(0,temp.indexOf(":"));
						agentsList.add(s_compNick);
					}
				}
				agentsList.retainAll(noLicenseAgentList);
			}
		}
		else if(agent_type.equalsIgnoreCase("Agents for user licensed types"))
		{
			agentsList = hasAllCompAccess ? userBean.getPremiumAgents(true) : roleInfo.getPremiumAgents(true);
			if (noLicenseAgentList != null && noLicenseAgentList.size() > 0)
			{
				agentsList.removeAll(noLicenseAgentList);
			}
			ArrayList basicAgentList = hasAllCompAccess ? licInfo.getBasicAgents() : roleInfo.getBasicAgents();
			if (basicAgentList != null && basicAgentList.size() > 0)
			{
				agentsList.removeAll(basicAgentList);
			}
		}
		
		Map runningAgentsMap = serverList.getAgentList(agentsList,aList,currList,"Running");
		Map notRunningAgentsMap = serverList.getAgentList(agentsList,aList,currList,"NotRunning");
		
		int runAgent = runningAgentsMap.size();
		int notRunAgent = notRunningAgentsMap.size();
		int totalAgent = runAgent + notRunAgent;
		
		if(!agent_type.equalsIgnoreCase("External Agents"))
		{
			agentSummarytotalCount += totalAgent;
		}
		csvData.add((agent_type.equalsIgnoreCase("External Agents") ? "   " + agent_type : agent_type)+","+totalAgent+","+runAgent+","+notRunAgent);
		
		agentTypesObj.put("AgentType",agent_type.equalsIgnoreCase("External Agents") ? "&nbsp;&nbsp;&nbsp" + agent_type : agent_type);
		agentTypesObj.put("TotalAgents",totalAgent);
		agentTypesObj.put("Running",runAgent);
		agentTypesObj.put("NotRunning",notRunAgent);
		agentsSummaryGridData.add(agentTypesObj);
	}
	csvData.add(2,"Total number of agents "+","+agentSummarytotalCount);
	session.setAttribute("list",csvData);

	rootJSON.put("agentsSummaryStore",agentsSummaryGridData);
	rootJSON.put("agentsSummaryCount",agentSummarytotalCount);
	out.println(rootJSON);
%>



