import React from "react"
import Mitt from "../mitt"

import StorybookSwitcher from "./storybook"

/**
 * A plugin which provides .storybookSwitcher() on eG.
 */
export default () => () => {
  const emitter =  Mitt()

  return {
    onCommand: (command: any) => {
      if (command.type !== "storybook") return
      // relay this payload on to the emitter
      emitter.emit("storybook", command.payload)
    },

    features: {
      storybookSwitcher: (storybookUi: any) => (WrappedComponent: any) => (props: any) => (
        <StorybookSwitcher storybookUi={storybookUi} emitter={emitter}>
          <WrappedComponent {...props} />
        </StorybookSwitcher>
      ),
    },
  }
}
