var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
import React, { Component } from "react";
import { View } from "react-native";
var StorybookSwitcher = /** @class */ (function (_super) {
    __extends(StorybookSwitcher, _super);
    /**
     * Creates an instance of FullScreenOverlay.
     *
     * @param {any} props
     * @param {Object} props.emitter An event emitter.
     *
     * @memberOf FullScreenOverlay
     */
    function StorybookSwitcher(props) {
        var _this = _super.call(this, props) || this;
        _this.state = {
            showStorybook: false,
        };
        // when the server sends stuff
        props.emitter.on("storybook", function (payload) {
            _this.setState({ showStorybook: payload });
        });
        return _this;
    }
    /**
     * Draw.
     */
    StorybookSwitcher.prototype.render = function () {
        var showStorybook = this.state.showStorybook;
        var _a = this.props, StorybookUi = _a.storybookUi, children = _a.children;
        return <View style={{ flex: 1 }}>{showStorybook ? <StorybookUi /> : children}</View>;
    };
    return StorybookSwitcher;
}(Component));
export default StorybookSwitcher;
