import React from "react";
import { View } from "react-native";
import Mitt from "../mitt";
import FullScreenOverlay from "./overlay";
export default (function () { return function () {
    var emitter = Mitt();
    return {
        /**
         * Fires when any eG message arrives.
         *
         * @param {object} command The eG command object.
         */
        onCommand: function (command) {
            if (command.type !== "overlay")
                return;
            // relay this payload on to the emitter
            emitter.emit("overlay", command.payload);
        },
        features: {
            overlay: function (WrappedComponent) { return function (props) { return (<View style={{ flex: 1 }}>
          <WrappedComponent {...props}/>
          <FullScreenOverlay emitter={emitter}/>
        </View>); }; },
        },
    };
}; });
