package fingertip.smssender;
/*
 * @(#)SMSSender.java 1.0 07/12/01
 *
 * FingerTip Technologies Pvt. Ltd.
 * First Floor, WoodHead Center,
 * 23 SivaGanga Road, Nungambakkam, Chennai, India.
 *
 * This software is the confidential and proprietary information of
 * FingerTip Online Pvt. Ltd.
 * ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with FingerTip Online Pvt. Ltd.
 */
import javax.comm.CommPortIdentifier;
import javax.comm.SerialPort;
import java.io.*;

import fingertip.comporthandler.ReadComm;
import fingertip.comporthandler.WriteComm;
import fingertip.comporthandler.PortHandler;

import fingertip.config.GSMEngineConfig;
import fingertip.utils.LogWriter;
import fingertip.utils.StringManager;


public class SMSSender {
	private ReadComm readPort;
	private WriteComm writePort;
	private int poll;
	private int readTimeout;
	private int cmdSendInterval;
	private int sendTimeout;
	private SerialPort port;
	public static SMSSender _sender=null;
	private static boolean _bExit=false;
	transient LogWriter lgwr;

	StringManager sm = StringManager.getManager(Constants.Package);



	/**
	 * Returns SMS Sender Instance
	 * @return SMSSender SMS Sender Instance
	 */
	public static SMSSender getInstance() throws Exception {
			if(_sender == null) {
				_sender = new SMSSender();
			}
			return _sender;
	}

	public static void setShutdown() {
		_bExit = true;
	}

	private SMSSender() throws Exception {
		lgwr = LogWriter.getInstance();
		/*
		if(! init()) {
			lgwr.log(sm.getString("SMSSender.failed"));
			System.out.println("SMSSender Intiation Failed");

			System.exit(0);
		}*/
	}

	public String replace(String manString,String search,String repVal){
 		String result;
 		int i;

		int len = search.length();
                do{
                        i=manString.indexOf(search);
                        if(i >= 0){
                                result = manString.substring(0,i);
                                result = result + repVal;
                                result = result + manString.substring(i +
                                                len);
                                manString = result;
                        }
                } while(i >= 0);
                return(manString);
        }

	/**
	 * Sends the SMS in Mode 1
	 * @return boolean Returns true if the message is sent successfully
	 * @param String strMobile Mobile Number to be sent
	 * @param String strMsg Text Message to be sent
	 * @param boolean interFlag Flag that sets the International mode while sending
	 */
	public boolean sendSMS(String strMobile,String strMsg,boolean interFlag)
				throws Exception {
		String command = GSMEngineConfig.getInstance().getProperty("Command");
		if (command != null && command.trim().length() > 0)
		{
			String port = GSMEngineConfig.getInstance().getProperty("Port");
			String cmd = "cmd.exe /c "+command;
			cmd = replace(cmd, "$mobile",strMobile);
			cmd = replace(cmd,"$message",strMsg.trim());
			cmd = replace (cmd, "$port",port);
			// echo #MSG#"+strMsg.trim()+";"+strMobile+"; > COM1");
			System.out.println("Command executed  is "+ cmd);
			BufferedReader rd;
			String line = "";
			Runtime runtime = Runtime.getRuntime();
			Process p = null;
			boolean status = true;
			try {

				p = runtime.exec(cmd);
				if (p == null)
				{
					System.err.println("Error No optput for the command ");
					return (false);
				}
				rd= new BufferedReader(new InputStreamReader
									(p.getInputStream()));
				try {
						System.out.println("Reading output stream ");
						while ((line=rd.readLine()) != null) {
							System.out.println("Line is "+ line);
						}
						rd.close();
					 } catch (Exception e) {
								e.printStackTrace();
								try { rd.close(); } catch (Exception e1) {}
					}

				rd= new BufferedReader(new InputStreamReader
									(p.getErrorStream()));
				try {
						System.err.println("Reading Error stream ");
						while ((line=rd.readLine()) != null) {
							System.err.println("Error : "+ line);
							status = false;
						}
						rd.close();
					 } catch (Exception e) {
								e.printStackTrace();
								try { rd.close(); } catch (Exception e1) {}
						}

				} catch (Exception xxx)
				{
					System.err.println("Error : "+xxx.toString());
					xxx.printStackTrace();
					status = false;
				}
				return status;
		} else {
			boolean sent = false;
			String strData;
			while( !sent) {
			//for(int i=0;i <= 10 && !sent; i++) {
				strData = "";
				if(this._bExit) break;
				strData = getResponse("AT\r\n",false);
				//System.out.println("SMSSender:  Response at SMSPoll "+strData);
				if(strData.length() <= 0 || (strData.indexOf("OK") == -1) ) {
					Thread.sleep(poll *  1000);
					continue;
				} else if(strData.toUpperCase().indexOf("+CMGS") != -1)   {
					//System.out.println("SMSSender: Data Received "+strData);
					//System.out.println("SMS Sent to Mobile "+strMobile);
					return true;
				}
				//else  {
				//	System.out.println("SMSSender: Data Received "+strData);
				//}



				Thread.sleep(cmdSendInterval * 1000);
				strData = "";
				String strMode = new StringBuffer("AT+CMGF=1\r\n")
									.append("\r\n").toString();

				//System.out.println("Mode "+strMode);
				if(this._bExit) break;
				strData = getResponse(strMode,false);
				//System.out.println("SMSSender: Data Received "+strData);

				if(strData.length() <= 0 || (strData.indexOf("OK") == -1) ) {
					Thread.sleep(poll * 1000);
					continue;
				}
				//else {
				//	System.out.println("SMSSender: Data Received "+strData);
				//}

				Thread.sleep(cmdSendInterval * 1000);
				strData = "";

				if(interFlag)
					strMode = "145";
				else
					strMode = "129";
				//strData = "AT+CMGS=\""+strMobile+"\","+strMode+"\r\n";
				strData = "AT+CMGS=\""+strMobile+"\","+strMode+"\n";

				if(this._bExit) break;
				String strRes =getResponse(strData,false);

				if(strRes.length() <= 0 || (strRes.indexOf(">") == -1) ) {
					Thread.sleep(poll *  1000);
					continue;
				}
				//else {
				//	System.out.println("SMSSender: Data Received "+strRes);
				//}
				Thread.sleep(cmdSendInterval * 1000);

				strRes = "";
				strRes = getResponse(strMsg+"\032\n",true);

				//System.out.println("SMSSender: Data Received ++++++++++++++++ "+strRes);

				if(strRes.length() <= 0 || (strRes.indexOf("OK") == -1) ) {
						return false;
						//Thread.sleep(poll *  1000);
						//continue;
				} else {
					sent = true;
					//System.out.println("SMSSender: Data Received "+strRes);
					return true;
				}

				//if(strRes.indexOf("OK") != -1)
				//	return true;
			}
			return sent;
		}

	}


	/**
	 * Sends the SMS in Mode 1
	 * @return boolean Returns true if the message is sent successfully
	 * @param String strMobile Mobile Number to be sent
	 * @param String strMsg Text Message to be sent
	 * @param boolean interFlag Flag that sets the International mode while sending


	public boolean sendSMS(String strMobile,String strMsg,boolean interFlag)
				throws Exception {
		System.out.println("Sending SMS to Mobile "+strMobile+" Message "+strMsg);
		return true;
	}*/


	private boolean init() {
		try {
			PortHandler handle = PortHandler.getInstance();
			port = handle.getSerialPort();
			if(port != null) {
				this.readPort = handle.getCommReader();
				this.writePort = handle.getCommWriter();
				this.poll = Integer.parseInt(GSMEngineConfig.getInstance().getProperty("PollInterval"));
				this.readTimeout = Integer.parseInt(GSMEngineConfig.getInstance().getProperty("ReadTimeOut"));
				this.sendTimeout = Integer.parseInt(GSMEngineConfig.getInstance().getProperty("SendTimeOut"));
				this.cmdSendInterval = Integer.parseInt(GSMEngineConfig.getInstance().getProperty("CommandSendInterval"));

				return true;
			} else {
				System.out.println("SMS COM Port Initialization Failed");
				return false;
			}
		} catch (Exception e) {
			e.printStackTrace();
		}

		return false;
	}

	private String getResponse(String strATCmd,boolean send) {

		String strData ="";

		writePort.write(strATCmd);
		int counter;

		int max=0;
		if(send)
			max = sendTimeout * 30;
		else
			max = readTimeout * 20;
		if(send || strATCmd.indexOf(">") != -1) {
			counter = 0;
			while((! readPort.isDataAvail(">"))  && counter < max ) {
				try  {
					Thread.sleep(100);
				} catch (Exception e) {

				}
				counter ++;
			}

			if(readPort.isDataAvail(">"))
					strData = readPort.getData().trim();
			 else
				strData = "";

		} else {

			counter = 0;
			while((! readPort.isDataAvail() )  && counter < max ) {
				try  {
					Thread.sleep(100);
				} catch (Exception e) {

				}
				counter ++;
			}

			if(readPort.isDataAvail())
				strData = readPort.getData().trim();
			else
				strData = "";

		}


		return strData;
	}

}