var android = require("./android");
const fs = require('fs');
var path = require('path');

module.exports = function (context) {
  android.verifyPlatformInstall(context);
  var isConfigured = android.isPlatformConfigured();
  android.removeAgentPlugin();
  android.injectAgentPlugin(context, isConfigured);
  if (isConfigured) {
  	android.injecteGInnovationsProperties(context);
  }

  const dest = path.join(context.opts.projectRoot, 'www/egmobilerum.js');
  const src = path.join(context.opts.projectRoot, 'node_modules/eginnovations-cordova-plugin/www/egmobilerum.js');

  fs.copyFile(src, dest, (err) => { 
    if (err) { 
      console.log("Error Found:", err); 
    } 
    else { 
      console.log("\nCopied file successfully to:",  dest); 
    } 
  }); 
  
};


