
#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

typedef NSString EGPluginMethodName;
typedef NSString EGPluginMethodArgumentName;
typedef NSDictionary <EGPluginMethodArgumentName *, id> EGPluginMethodArgumentsList;

extern EGPluginMethodName * const kRunMethodName;
extern EGPluginMethodName * const kStopMethodName;
extern EGPluginMethodName * const kStartMethodName;
extern EGPluginMethodName * const kIsStartedMethodName;
extern EGPluginMethodName * const kSetMetadataMethodName;
extern EGPluginMethodName * const kRemoveMetadataMethodName;
extern EGPluginMethodName * const kHTTPRequestMethodName;
extern EGPluginMethodName * const kHTTPResponseMethodName;
extern EGPluginMethodName * const kLogEventMethodName;
extern EGPluginMethodName * const kLogScreenName;


extern EGPluginMethodArgumentName * const kAPIKeyArgument;
extern EGPluginMethodArgumentName * const kEnabledMonitorsArgument;
extern EGPluginMethodArgumentName * const kMetadataArgument;

extern EGPluginMethodArgumentName * const kUIDArgument;
extern EGPluginMethodArgumentName * const kURLArgument;
extern EGPluginMethodArgumentName * const kMethodArgument;
extern EGPluginMethodArgumentName * const kBodyArgument;
extern EGPluginMethodArgumentName * const kHeadersArgument;
extern EGPluginMethodArgumentName * const kCodeArgument;
extern EGPluginMethodArgumentName * const kTookMSArgument;
extern EGPluginMethodArgumentName * const kLevelArgument;
extern EGPluginMethodArgumentName * const kTagArgument;
extern EGPluginMethodArgumentName * const kMessageArgument;


@interface EGPluginCallValidator : NSObject

- (BOOL)controlMethodSupported:(EGPluginMethodName *)methodName;
- (BOOL)eventMethodSupported:(EGPluginMethodName *)methodName;

- (BOOL)argumentsValid:(EGPluginMethodArgumentsList *)arguments
                  call:(EGPluginMethodName *)methodName
          error:(__autoreleasing NSError *_Nonnull*_Nullable)error;



@end

NS_ASSUME_NONNULL_END
