/*
 * Decompiled with CFR 0.152.
 */
package com.objectplanet.image;

import com.objectplanet.image.Encoder;
import java.awt.Image;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class IndexedEncoder
extends Encoder {
    private FastHashtable paletteMap = new FastHashtable();
    protected ByteArrayOutputStream paletteChunk = new ByteArrayOutputStream();
    protected boolean palette_set;

    IndexedEncoder(int compression) {
        super(compression);
        this.colorType = 3;
    }

    synchronized void encode(Image image, DataOutputStream out) throws IOException {
        this.paletteChunk.reset();
        this.paletteChunk.write("PLTE".getBytes());
        this.palette_set = false;
        super.encode(image, out);
    }

    protected void deflatePixels() {
        try {
            this.deflaterOut.finish();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected void writeChunks(DataOutputStream out) throws IOException {
        this.writeChunk(this.headerChunk, out);
        this.writeChunk(this.paletteChunk, out);
        this.writeChunk(this.idatChunk, out);
    }

    protected void initPalette() {
        int palette_index;
        int indexed_value = 0xFFFFFF;
        for (palette_index = 0; palette_index < 3; ++palette_index) {
            this.paletteChunk.write(-1);
            this.paletteChunk.write(-1);
            this.paletteChunk.write(-1);
            this.paletteMap.put(indexed_value, palette_index);
        }
        for (int red = 50; red <= 255; red += 41) {
            for (int green = 50; green <= 255; green += 41) {
                for (int blue = 50; blue <= 255; blue += 41) {
                    if (red == green && red == blue) continue;
                    indexed_value = red << 16 | green << 8 | blue;
                    this.paletteChunk.write((byte)red);
                    this.paletteChunk.write((byte)green);
                    this.paletteChunk.write((byte)blue);
                    this.paletteMap.put(indexed_value, palette_index);
                    ++palette_index;
                }
            }
        }
        for (int gray = 0; gray <= 252; gray += 6) {
            indexed_value = gray << 16 | gray << 8 | gray;
            this.paletteChunk.write(gray);
            this.paletteChunk.write(gray);
            this.paletteChunk.write(gray);
            this.paletteMap.put(indexed_value, palette_index);
            ++palette_index;
        }
    }

    public void setPixels(int x, int y, int w, int h, ColorModel model, int[] pixels, int off, int scansize) {
        if (model == null || pixels == null) {
            return;
        }
        if (!this.palette_set) {
            this.initPalette();
            this.palette_set = true;
        }
        if (this.pngPixels == null || this.pngPixels.length < scansize + 1) {
            this.pngPixels = new byte[scansize + 1];
        }
        int rows = pixels.length / scansize;
        int index = 0;
        for (int row = 0; row < rows; ++row) {
            this.pngPixels[0] = 0;
            for (int i = 0; i < scansize; ++i) {
                this.setPixel(model, pixels[index], i);
                ++index;
            }
            try {
                this.deflaterOut.write(this.pngPixels, 0, scansize + 1);
                continue;
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }

    protected void setPixel(ColorModel model, int pixel, int index) {
        int indexed_value;
        int r = pixel >> 16 & 0xFF;
        int g = pixel >> 8 & 0xFF;
        int b = pixel & 0xFF;
        float distance = Math.abs(r - g);
        distance = Math.max(distance, (float)Math.abs(r - b));
        if ((distance = Math.max(distance, (float)Math.abs(b - g))) < 24.0f || r < 50 && g < 50 && b < 50) {
            int gray = (int)((double)r * 0.3 + (double)g * 0.59 + (double)b * 0.11);
            gray = (int)Math.round((double)gray / 6.0) * 6;
            gray = Math.max(gray, 6);
            gray = Math.min(gray, 252);
            indexed_value = gray << 16 | gray << 8 | gray;
        } else {
            int ri = (int)Math.round((double)(r - 50) / 41.0) * 41 + 50;
            int gi = (int)Math.round((double)(g - 50) / 41.0) * 41 + 50;
            int bi = (int)Math.round((double)(b - 50) / 41.0) * 41 + 50;
            ri = Math.max(ri, 50);
            gi = Math.max(gi, 50);
            bi = Math.max(bi, 50);
            indexed_value = ri << 16 | gi << 8 | bi;
        }
        int palette_index = this.paletteMap.get(indexed_value);
        this.pngPixels[index + 1] = palette_index >= 0 ? (byte)palette_index : (byte)0;
    }

    public void setPixels(int x, int y, int w, int h, ColorModel model, byte[] pixels, int off, int scansize) {
        if (model == null || pixels == null) {
            return;
        }
        if (!this.palette_set) {
            byte[] r = new byte[256];
            byte[] g = new byte[256];
            byte[] b = new byte[256];
            ((IndexColorModel)model).getReds(r);
            ((IndexColorModel)model).getGreens(g);
            ((IndexColorModel)model).getBlues(b);
            for (int i = 0; i < 256; ++i) {
                this.paletteChunk.write(r[i]);
                this.paletteChunk.write(g[i]);
                this.paletteChunk.write(b[i]);
            }
            this.palette_set = true;
        }
        try {
            this.deflaterOut.write(0);
            this.deflaterOut.write(pixels, 0, pixels.length);
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    class FastHashtable {
        HashEntry[] table = new HashEntry[101];

        FastHashtable() {
        }

        void put(int key, int value) {
            int index = (key & Integer.MAX_VALUE) % this.table.length;
            HashEntry entry = this.table[index];
            while (entry != null) {
                if (entry.key == key) {
                    entry.value = value;
                    return;
                }
                entry = entry.next;
            }
            entry = new HashEntry();
            entry.key = key;
            entry.value = value;
            entry.next = this.table[index];
            this.table[index] = entry;
        }

        int get(int key) {
            int index = (key & Integer.MAX_VALUE) % this.table.length;
            HashEntry entry = this.table[index];
            while (entry != null) {
                if (entry.key == key) {
                    return entry.value;
                }
                entry = entry.next;
            }
            return -1;
        }

        void clear() {
            for (int i = 0; i < this.table.length; ++i) {
                this.table[i] = null;
            }
        }

        class HashEntry {
            int key;
            int value;
            HashEntry next;

            HashEntry() {
            }
        }
    }
}

