/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.awt;

import com.eteks.awt.PJAGraphics;
import com.eteks.awt.PJAGraphicsManager;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.ColorModel;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.awt.image.MemoryImageSource;
import java.util.Hashtable;
import java.util.Vector;

public class PJAImage
extends Image {
    private int width = -1;
    private int height = -1;
    private int availableInfo;
    private int[] pixels;
    private ColorModel colorModel = null;
    private Hashtable properties = new Hashtable();
    private boolean productionStarted;
    private ImageProducer initProducer;

    public PJAImage(ImageProducer imageProducer) {
        this.colorModel = PJAGraphicsManager.getDefaultGraphicsManager().getColorModel();
        this.initProducer = imageProducer;
    }

    public PJAImage(int n, int n2) {
        this.colorModel = PJAGraphicsManager.getDefaultGraphicsManager().getColorModel();
        this.width = n;
        this.height = n2;
        this.productionStarted = true;
        this.availableInfo = 39;
    }

    public Object getProperty(String string, ImageObserver imageObserver) {
        if ((this.availableInfo & 4) == 0) {
            this.prepare(imageObserver);
        }
        return this.properties.get(string);
    }

    public int getWidth(ImageObserver imageObserver) {
        if ((this.availableInfo & 1) == 0) {
            this.prepare(imageObserver);
        }
        return this.getWidth();
    }

    public int getHeight(ImageObserver imageObserver) {
        if ((this.availableInfo & 2) == 0) {
            this.prepare(imageObserver);
        }
        return this.getHeight();
    }

    public ImageProducer getSource() {
        return new NBProducer();
    }

    public Graphics getGraphics() {
        this.sync();
        if ((this.availableInfo & 0x40) != 0) {
            return null;
        }
        return new PJAGraphics(this);
    }

    public void flush() {
        if (this.initProducer != null && !(this.initProducer instanceof MemoryImageSource) && !(this.initProducer instanceof FilteredImageSource)) {
            PJAImage pJAImage = this;
            synchronized (pJAImage) {
                this.pixels = null;
                this.availableInfo |= 0x40;
            }
        }
    }

    protected int check(ImageObserver imageObserver) {
        if (imageObserver != null) {
            imageObserver.imageUpdate(this, this.availableInfo, 0, 0, this.width, this.height);
        }
        return this.availableInfo;
    }

    protected boolean prepare(ImageObserver imageObserver) {
        if (!this.productionStarted) {
            this.loadInitImage(false, imageObserver);
        } else if ((this.availableInfo & 0x40) != 0) {
            if (imageObserver != null) {
                imageObserver.imageUpdate(this, this.availableInfo, -1, -1, -1, -1);
            }
        } else {
            new NBProducer(imageObserver).startProduction(null);
        }
        return (this.availableInfo & 0x20) != 0;
    }

    protected int getWidth() {
        return this.width;
    }

    protected int getHeight() {
        return this.height;
    }

    protected int[] getPixels() {
        if (this.pixels == null && this.width >= 0 && this.height >= 0 && (this.availableInfo & 0x40) == 0) {
            this.pixels = new int[this.width * this.height];
        }
        return this.pixels;
    }

    protected int getPixelColor(int n, int n2) {
        if ((this.availableInfo & 0x40) != 0 || this.pixels == null || n < 0 || n >= this.width || n2 < 0 || n2 >= this.height) {
            return 0;
        }
        return this.pixels[n + n2 * this.getWidth()];
    }

    protected void setPixelColor(int n, int n2, int n3) {
        int[] nArray = this.getPixels();
        if (nArray != null && n >= 0 && n < this.width && n2 >= 0 && n2 < this.height) {
            nArray[n + n2 * this.width] = n3;
        }
    }

    public void sync() {
        this.loadInitImage(true, null);
    }

    private synchronized void loadInitImage(boolean bl, ImageObserver imageObserver) {
        if (!this.productionStarted) {
            new 1(imageObserver, this).start();
            this.productionStarted = true;
        }
        try {
            if ((this.availableInfo & 0x40) == 0 && (this.availableInfo & 0x20) == 0 && bl) {
                this.wait();
            }
        }
        catch (InterruptedException interruptedException) {
            this.availableInfo = 192;
        }
    }

    private static final class 1
    extends Thread {
        private final /* synthetic */ ImageObserver val$observer;
        private final /* synthetic */ PJAImage this$0;
        final ImageProducer producer;

        public void run() {
            this.producer.startProduction(this.this$0.new PJAConsumer(this.producer, this.val$observer));
        }

        /* synthetic */ 1(ImageObserver imageObserver, PJAImage pJAImage) {
            this.val$observer = imageObserver;
            this.this$0 = pJAImage;
            this.producer = pJAImage.initProducer;
        }
    }

    private class NBProducer
    implements ImageProducer {
        private Vector consumers = new Vector();
        private ImageObserver observer;

        public NBProducer() {
        }

        public NBProducer(ImageObserver imageObserver) {
            this.observer = imageObserver;
        }

        public synchronized void addConsumer(ImageConsumer imageConsumer) {
            if (imageConsumer != null && this.isConsumer(imageConsumer)) {
                return;
            }
            if ((PJAImage.this.availableInfo & 0x40) == 0) {
                if (imageConsumer != null) {
                    this.consumers.addElement(imageConsumer);
                }
                PJAImage.this.sync();
            }
            PJAImage pJAImage = PJAImage.this;
            synchronized (pJAImage) {
                if ((PJAImage.this.availableInfo & 0x40) != 0) {
                    if (imageConsumer != null) {
                        imageConsumer.imageComplete(1);
                    }
                    if (this.observer != null) {
                        this.observer.imageUpdate(PJAImage.this, PJAImage.this.availableInfo, -1, -1, -1, -1);
                    }
                } else {
                    if (imageConsumer != null) {
                        imageConsumer.setDimensions(PJAImage.this.width, PJAImage.this.height);
                        imageConsumer.setHints(26);
                        imageConsumer.setProperties(PJAImage.this.properties);
                        if (PJAImage.this.colorModel != null) {
                            imageConsumer.setColorModel(PJAImage.this.colorModel);
                        }
                        imageConsumer.setPixels(0, 0, PJAImage.this.width, PJAImage.this.height, PJAImage.this.colorModel, PJAImage.this.pixels, 0, PJAImage.this.width);
                        imageConsumer.imageComplete(3);
                    }
                    if (this.observer != null) {
                        this.observer.imageUpdate(PJAImage.this, PJAImage.this.availableInfo, 0, 0, PJAImage.this.width, PJAImage.this.height);
                    }
                }
            }
        }

        public synchronized void removeConsumer(ImageConsumer imageConsumer) {
            this.consumers.removeElement(imageConsumer);
        }

        public synchronized boolean isConsumer(ImageConsumer imageConsumer) {
            return this.consumers.contains(imageConsumer);
        }

        public void startProduction(ImageConsumer imageConsumer) {
            this.addConsumer(imageConsumer);
        }

        public void requestTopDownLeftRightResend(ImageConsumer imageConsumer) {
        }
    }

    private class PJAConsumer
    implements ImageConsumer {
        private ImageProducer producer;
        private ImageObserver observer;

        public PJAConsumer(ImageProducer imageProducer, ImageObserver imageObserver) {
            this.producer = imageProducer;
            this.observer = imageObserver;
        }

        public void setDimensions(int n, int n2) {
            PJAImage.this.width = n;
            PJAImage.this.height = n2;
            PJAImage pJAImage = PJAImage.this;
            pJAImage.availableInfo = pJAImage.availableInfo | 3;
            if (this.observer != null) {
                this.observer.imageUpdate(PJAImage.this, PJAImage.this.availableInfo, 0, 0, n, n2);
            }
        }

        public void setHints(int n) {
        }

        public void setProperties(Hashtable hashtable) {
            PJAImage.this.properties = hashtable;
            PJAImage pJAImage = PJAImage.this;
            pJAImage.availableInfo = pJAImage.availableInfo | 4;
            if (this.observer != null) {
                this.observer.imageUpdate(PJAImage.this, PJAImage.this.availableInfo, 0, 0, PJAImage.this.width, PJAImage.this.height);
            }
        }

        public void setColorModel(ColorModel colorModel) {
        }

        public void setPixels(int n, int n2, int n3, int n4, ColorModel colorModel, byte[] byArray, int n5, int n6) {
            PJAImage pJAImage = PJAImage.this;
            synchronized (pJAImage) {
                if ((PJAImage.this.availableInfo & 0x40) == 0) {
                    int[] nArray = PJAImage.this.getPixels();
                    int n7 = 0;
                    int n8 = n2 * PJAImage.this.width;
                    while (n7 < n4) {
                        int n9 = n5 + n7 * n6;
                        int n10 = 0;
                        while (n10 < n3) {
                            nArray[n8 + n + n10] = colorModel.getRGB(byArray[n9 + n10] & 0xFF);
                            ++n10;
                        }
                        ++n7;
                        n8 += PJAImage.this.width;
                    }
                    PJAImage pJAImage2 = PJAImage.this;
                    pJAImage2.availableInfo = pJAImage2.availableInfo | 8;
                }
            }
        }

        public void setPixels(int n, int n2, int n3, int n4, ColorModel colorModel, int[] nArray, int n5, int n6) {
            PJAImage pJAImage = PJAImage.this;
            synchronized (pJAImage) {
                if ((PJAImage.this.availableInfo & 0x40) == 0) {
                    int[] nArray2 = PJAImage.this.getPixels();
                    int n7 = 0;
                    int n8 = n2 * PJAImage.this.width;
                    while (n7 < n4) {
                        int n9 = n5 + n7 * n6;
                        int n10 = 0;
                        while (n10 < n3) {
                            nArray2[n8 + n + n10] = colorModel == null ? nArray[n9 + n10] : colorModel.getRGB(nArray[n9 + n10]);
                            ++n10;
                        }
                        ++n7;
                        n8 += PJAImage.this.width;
                    }
                    PJAImage pJAImage2 = PJAImage.this;
                    pJAImage2.availableInfo = pJAImage2.availableInfo | 8;
                }
            }
        }

        public void imageComplete(int n) {
            PJAImage pJAImage = PJAImage.this;
            synchronized (pJAImage) {
                if (n == 1) {
                    PJAImage.this.availableInfo = 64;
                } else if (n == 4) {
                    PJAImage.this.availableInfo = 192;
                } else {
                    PJAImage pJAImage2 = PJAImage.this;
                    pJAImage2.availableInfo = pJAImage2.availableInfo & 0xFFFFFFF7;
                    if (n == 3) {
                        PJAImage pJAImage3 = PJAImage.this;
                        pJAImage3.availableInfo = pJAImage3.availableInfo | 0x20;
                    } else if (n == 2) {
                        PJAImage pJAImage4 = PJAImage.this;
                        pJAImage4.availableInfo = pJAImage4.availableInfo | 0x20;
                    }
                }
                if (n == 1 || n == 4) {
                    PJAImage.this.pixels = null;
                }
                this.producer.removeConsumer(this);
                if (this.observer != null) {
                    if ((PJAImage.this.availableInfo & 0x40) != 0) {
                        this.observer.imageUpdate(PJAImage.this, PJAImage.this.availableInfo, -1, -1, -1, -1);
                    } else {
                        this.observer.imageUpdate(PJAImage.this, PJAImage.this.availableInfo, 0, 0, PJAImage.this.width, PJAImage.this.height);
                    }
                }
                PJAImage.this.notifyAll();
            }
        }
    }
}

