/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.awt;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.PixelGrabber;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.BitSet;

public class PJAFontData
implements Serializable {
    public static final String PJAF1_1_FILE_HEADER = "PJAF1.1";
    public static final String PJAF1_1_FONT_HEADER = "PJAFontData_1.1";
    private String name;
    private int style;
    private int size;
    private int leading;
    private int ascent;
    private int descent;
    private int maxAscent;
    private int maxDescent;
    private int maxAdvance;
    private int minChar;
    private int maxChar;
    private short[] charsWidth;
    private int[] charsOffset;
    private short[] charsOffsetAtBaseline;
    private int allCharsWidth;
    private BitSet charsBits;

    public PJAFontData(InputStream inputStream) throws IOException {
        this.read(inputStream);
    }

    public PJAFontData(Font font, int n, int n2) {
        try {
            int n3;
            this.name = font.getName();
            this.style = font.getStyle();
            this.size = font.getSize();
            FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(font);
            this.minChar = n;
            this.maxChar = n2;
            StringBuffer stringBuffer = new StringBuffer();
            int n4 = this.minChar;
            while (n4 <= this.maxChar) {
                stringBuffer.append((char)n4);
                ++n4;
            }
            Frame frame = new Frame();
            frame.addNotify();
            this.leading = fontMetrics.getLeading();
            this.ascent = fontMetrics.getAscent();
            this.descent = fontMetrics.getDescent();
            this.maxAscent = fontMetrics.getMaxAscent();
            this.maxDescent = fontMetrics.getMaxDescent();
            this.maxAdvance = fontMetrics.getMaxAdvance();
            this.charsWidth = new short[this.maxChar - this.minChar + 1];
            this.charsOffset = new int[this.charsWidth.length];
            this.allCharsWidth = 0;
            int n5 = this.ascent + this.descent;
            int n6 = 0;
            while (n6 < this.charsWidth.length) {
                this.charsWidth[n6] = (short)fontMetrics.charWidth(stringBuffer.charAt(n6));
                ++n6;
            }
            this.charsOffsetAtBaseline = new short[this.charsWidth.length];
            int n7 = this.maxAdvance * 3;
            Image image = frame.createImage(n7, n5);
            int[] nArray = new int[n7 * n5];
            Graphics graphics = image.getGraphics();
            graphics.setFont(font);
            int n8 = 0;
            while (n8 < this.charsWidth.length) {
                int n9;
                graphics.setColor(Color.white);
                graphics.fillRect(0, 0, n7, n5);
                graphics.setColor(Color.black);
                graphics.drawString(String.valueOf(stringBuffer.charAt(n8)), this.maxAdvance, this.ascent);
                PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, n7, n5, nArray, 0, n7);
                pixelGrabber.grabPixels();
                int n10 = n7;
                n3 = 0;
                int n11 = 0;
                while (n3 < n5) {
                    n9 = 0;
                    while (n9 < n7) {
                        if ((nArray[n9 + n11] & 0xFFFFFF) < 0x777777) {
                            n10 = Math.min(n10, n9);
                            break;
                        }
                        ++n9;
                    }
                    ++n3;
                    n11 += n7;
                }
                n9 = -1;
                if (n10 != n7) {
                    int n12 = 0;
                    int n13 = 0;
                    while (n12 < n5) {
                        int n14 = n7 - 1;
                        while (n14 >= 0) {
                            if ((nArray[n14 + n13] & 0xFFFFFF) < 0x777777) {
                                n9 = Math.max(n9, n14);
                                break;
                            }
                            --n14;
                        }
                        ++n12;
                        n13 += n7;
                    }
                }
                this.charsOffset[n8] = this.allCharsWidth;
                if (n10 != n7) {
                    this.charsOffsetAtBaseline[n8] = (short)(n10 - this.maxAdvance);
                    this.allCharsWidth += n9 - n10 + 1;
                }
                ++n8;
            }
            image = frame.createImage(this.allCharsWidth, n5);
            graphics = image.getGraphics();
            graphics.setColor(Color.white);
            graphics.fillRect(0, 0, this.allCharsWidth, n5);
            graphics.setColor(Color.black);
            graphics.setFont(font);
            int n15 = 0;
            while (n15 < this.charsWidth.length) {
                graphics.drawString(String.valueOf(stringBuffer.charAt(n15)), this.charsOffset[n15] - this.charsOffsetAtBaseline[n15], this.ascent);
                ++n15;
            }
            nArray = new int[this.allCharsWidth * n5];
            PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, this.allCharsWidth, n5, nArray, 0, this.allCharsWidth);
            pixelGrabber.grabPixels();
            this.charsBits = new BitSet(nArray.length);
            n3 = 0;
            while (n3 < nArray.length) {
                if ((nArray[n3] & 0xFFFFFF) < 0x777777) {
                    this.charsBits.set(n3);
                }
                ++n3;
            }
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException("Couldn't capture font " + font);
        }
    }

    public String getName() {
        return this.name;
    }

    public int getStyle() {
        return this.style;
    }

    public int getSize() {
        return this.size;
    }

    public int getLeading() {
        return this.leading;
    }

    public int getAscent() {
        return this.ascent;
    }

    public int getDescent() {
        return this.descent;
    }

    public int getMaxAscent() {
        return this.maxAscent;
    }

    public int getMaxDescent() {
        return this.maxDescent;
    }

    public int getMaxAdvance() {
        return this.maxAdvance;
    }

    public int getCharWidth(int n) {
        if (n < this.minChar || n > this.maxChar) {
            return 0;
        }
        return this.charsWidth[n - this.minChar];
    }

    public int getCharsWidth(char[] cArray, int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            n3 += this.getCharWidth(cArray[n + n4]);
            ++n4;
        }
        return n3;
    }

    private void checkCharacterRange(char c) {
        if (c < this.minChar || c > this.maxChar) {
            throw new IllegalArgumentException("Character " + c + " as no image.");
        }
    }

    protected int[] getCharPixels(char c) {
        int n = this.ascent + this.descent;
        int n2 = this.getCharPixelsWidth(c);
        int[] nArray = new int[n2 * n];
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (n4 < n) {
            int n6 = 0;
            while (n6 < n2) {
                nArray[n3++] = this.charsBits.get(n6 + this.charsOffset[c - this.minChar] + n5) ? -16777216 : -1;
                ++n6;
            }
            ++n4;
            n5 += this.allCharsWidth;
        }
        return nArray;
    }

    protected int getCharPixelsWidth(char c) {
        this.checkCharacterRange(c);
        if (c == this.maxChar) {
            return this.allCharsWidth - this.charsOffset[this.maxChar - 1];
        }
        return this.charsOffset[c - this.minChar + 1] - this.charsOffset[c - this.minChar];
    }

    protected int getCharOffsetAtBaseline(char c) {
        this.checkCharacterRange(c);
        return this.charsOffsetAtBaseline[c - this.minChar];
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        this.write(objectOutputStream);
    }

    public void write(OutputStream outputStream) throws IOException {
        DataOutputStream dataOutputStream = outputStream instanceof DataOutputStream ? (DataOutputStream)outputStream : new DataOutputStream(outputStream);
        dataOutputStream.writeUTF(PJAF1_1_FONT_HEADER);
        dataOutputStream.writeUTF(this.name);
        dataOutputStream.writeInt(this.style);
        dataOutputStream.writeInt(this.size);
        dataOutputStream.writeInt(this.leading);
        dataOutputStream.writeInt(this.ascent);
        dataOutputStream.writeInt(this.descent);
        dataOutputStream.writeInt(this.maxAscent);
        dataOutputStream.writeInt(this.maxDescent);
        dataOutputStream.writeInt(this.maxAdvance);
        dataOutputStream.writeInt(this.minChar);
        dataOutputStream.writeInt(this.maxChar);
        dataOutputStream.writeInt(this.charsWidth.length);
        int n = 0;
        while (n < this.charsWidth.length) {
            dataOutputStream.writeShort(this.charsWidth[n]);
            ++n;
        }
        dataOutputStream.writeInt(this.charsOffset.length);
        int n2 = 0;
        while (n2 < this.charsOffset.length) {
            dataOutputStream.writeInt(this.charsOffset[n2]);
            ++n2;
        }
        dataOutputStream.writeInt(this.charsOffsetAtBaseline.length);
        int n3 = 0;
        while (n3 < this.charsOffsetAtBaseline.length) {
            dataOutputStream.writeShort(this.charsOffsetAtBaseline[n3]);
            ++n3;
        }
        dataOutputStream.writeInt(this.allCharsWidth);
        int n4 = this.charsBits.size();
        dataOutputStream.writeInt(n4);
        int n5 = 0;
        while (n5 < n4) {
            long l = 0L;
            int n6 = 0;
            while (n6 < 64 && n5 < n4) {
                if (this.charsBits.get(n5)) {
                    l |= 1L << n6;
                }
                ++n6;
                ++n5;
            }
            dataOutputStream.writeLong(l);
        }
        dataOutputStream.flush();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.read(objectInputStream);
    }

    public void read(InputStream inputStream) throws IOException {
        DataInputStream dataInputStream = inputStream instanceof DataInputStream ? (DataInputStream)inputStream : new DataInputStream(inputStream);
        String string = dataInputStream.readUTF();
        if (!PJAF1_1_FONT_HEADER.equals(string)) {
            throw new IOException("Unknown PJAF data format");
        }
        try {
            this.name = dataInputStream.readUTF();
            this.style = dataInputStream.readInt();
            this.size = dataInputStream.readInt();
            this.leading = dataInputStream.readInt();
            this.ascent = dataInputStream.readInt();
            this.descent = dataInputStream.readInt();
            this.maxAscent = dataInputStream.readInt();
            this.maxDescent = dataInputStream.readInt();
            this.maxAdvance = dataInputStream.readInt();
            this.minChar = dataInputStream.readInt();
            this.maxChar = dataInputStream.readInt();
            this.charsWidth = new short[dataInputStream.readInt()];
            int n = 0;
            while (n < this.charsWidth.length) {
                this.charsWidth[n] = dataInputStream.readShort();
                ++n;
            }
            this.charsOffset = new int[dataInputStream.readInt()];
            int n2 = 0;
            while (n2 < this.charsOffset.length) {
                this.charsOffset[n2] = dataInputStream.readInt();
                ++n2;
            }
            this.charsOffsetAtBaseline = new short[dataInputStream.readInt()];
            int n3 = 0;
            while (n3 < this.charsOffsetAtBaseline.length) {
                this.charsOffsetAtBaseline[n3] = dataInputStream.readShort();
                ++n3;
            }
            this.allCharsWidth = dataInputStream.readInt();
            int n4 = dataInputStream.readInt();
            this.charsBits = new BitSet(n4);
            int n5 = 0;
            while (n5 < n4) {
                long l = dataInputStream.readLong();
                int n6 = 0;
                while (n6 < 64 && n5 < n4) {
                    if ((l >>> n6 & 1L) != 0L) {
                        this.charsBits.set(n5);
                    }
                    ++n6;
                    ++n5;
                }
            }
        }
        catch (EOFException eOFException) {
            throw new IOException("Invalid PJAF data format");
        }
    }

    public boolean equals(Object object) {
        return object instanceof PJAFontData && this.name.equals(((PJAFontData)object).name) && this.style == ((PJAFontData)object).style && this.size == ((PJAFontData)object).size;
    }

    public int hashCode() {
        return this.name.hashCode() + (this.style << 16) + this.size;
    }

    public static String styleToString(int n) {
        if ((n & 1) != 0) {
            return (n & 2) != 0 ? "bolditalic" : "bold";
        }
        return (n & 2) != 0 ? "italic" : "plain";
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "[fontName=" + this.getName() + ", style=" + PJAFontData.styleToString(this.getStyle()) + ", size=" + this.getSize() + "]";
    }
}

