/*
 * Decompiled with CFR 0.152.
 */
package com.eg;

import com.eg.EgCrypt;
import com.oracle.ovm.mgr.ws.client.OvmWsClient;
import com.oracle.ovm.mgr.ws.client.OvmWsClientFactory;
import com.oracle.ovm.mgr.ws.model.Server;
import com.oracle.ovm.mgr.ws.model.ServerPool;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class OracleVMDiscovery {
    private String dialect = "XML";
    private String OvmMgrIp = "";
    private String OvmMgrPort = "7002";
    private String OvmMgrUser = "";
    private String OvmMgrPass = "";
    private boolean isSsl = true;
    private OvmWsClient api = null;
    public boolean isServerConnected = false;
    public long startTime = 0L;

    public Hashtable getConnection(String string, String string2, String string3, String string4, String string5) {
        try {
            string3 = EgCrypt.decrypt(string3);
            this.setSSl();
            String string6 = "SOAP";
            this.api = OvmWsClientFactory.getOvmWsClient((String)string6);
            this.api.setDialect(this.dialect);
            this.api.initialize(string, string4, true);
            this.api.login(string2, string3, Locale.getDefault());
            if (this.api == null) {
                System.out.println(" [OracleVMDiscovery] OvmWsClient is " + this.api + " so return");
                return null;
            }
            List list = this.api.serverPoolGetAll();
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            if (list != null && list.size() > 0) {
                int n = list.size();
                for (int i = 0; i < n; ++i) {
                    ServerPool serverPool = (ServerPool)list.get(i);
                    if (serverPool == null) continue;
                    String string7 = serverPool.getName();
                    List list2 = serverPool.getServerIds();
                    List list3 = null;
                    if (list2 != null && list2.size() > 0) {
                        list3 = this.api.serverGetListById(list2);
                    }
                    if (list3 != null && list3.size() > 0) {
                        int n2 = list3.size();
                        for (int j = 0; j < n2; ++j) {
                            Server server = (Server)list3.get(j);
                            if (server == null) continue;
                            String string8 = server.getName();
                            Server.ServerRunState serverRunState = server.getServerRunState();
                            String string9 = serverRunState.toString();
                            String string10 = server.getIpAddress();
                            if (string9.equalsIgnoreCase("STOPPED") || string9.equalsIgnoreCase("STOPPING") || string9.equalsIgnoreCase("UNKNOWN") || string8 == null) continue;
                            hashtable.put(string8, string10);
                        }
                    }
                    System.out.println("[OracleVMDiscovery] ht_ovmData =" + hashtable);
                }
            }
            this.disConnect();
            return hashtable;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.disConnect();
            return null;
        }
    }

    public void disConnect() {
        try {
            if (this.api != null) {
                this.api.logout();
            }
            this.api = null;
        }
        catch (Exception exception) {
            System.out.println("Exception in [OVMServerConnection] while calling disConnect");
            exception.printStackTrace();
        }
    }

    public void setSSl() {
        try {
            SSLContext sSLContext = SSLContext.getInstance("TLS");
            sSLContext.init(new KeyManager[0], new TrustManager[]{new InsecureTrustManager()}, new SecureRandom());
            SSLContext.setDefault(sSLContext);
            HostnameVerifier hostnameVerifier = new HostnameVerifier(){

                @Override
                public boolean verify(String string, SSLSession sSLSession) {
                    return true;
                }
            };
            HttpsURLConnection.setDefaultHostnameVerifier(hostnameVerifier);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray == null || stringArray.length < 5) {
            System.out.println("Format should be:java OracleVmDiscovery <ovmmgrip> <ovmmgruser> <ovmmgrpass> <webport> <isSsl>");
            return;
        }
        OracleVMDiscovery oracleVMDiscovery = new OracleVMDiscovery();
        oracleVMDiscovery.getConnection(stringArray[0], stringArray[1], stringArray[2], stringArray[3], stringArray[4]);
    }

    private static class InsecureTrustManager
    implements X509TrustManager {
        private InsecureTrustManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }
    }
}

