/*
 * Decompiled with CFR 0.152.
 */
package com.eg;

import com.eg.EgConfigInfo;
import com.eg.EgInstallInfo;
import com.eg.EgServicesInfo;
import com.eg.IniFile;
import java.util.Enumeration;
import java.util.concurrent.ConcurrentHashMap;

public class EgConfigFilesSync {
    private static ConcurrentHashMap aliveFileInstances = new ConcurrentHashMap();
    private static ConcurrentHashMap aliveFileTime = new ConcurrentHashMap();
    private static ConcurrentHashMap aliveThreads = new ConcurrentHashMap();
    private static ConcurrentHashMap aliveInstanceCount = new ConcurrentHashMap();
    private static ConcurrentHashMap aliveStack = new ConcurrentHashMap();
    private static boolean getstack = EgInstallInfo.stackTraceLogEnabled;
    private static EgServicesInfo si = new EgServicesInfo("manager");
    private static String sync = new String("sync");
    private static long timeOutPeriod = 120L;
    private static long threadSleepPeriod = 75L;

    public static IniFile getInstance(String string) {
        return EgConfigFilesSync.getInstance(string, true);
    }

    private static String getStackTrace() {
        StackTraceElement[] stackTraceElementArray = new Throwable().getStackTrace();
        String string = "";
        for (int i = 0; i < stackTraceElementArray.length; ++i) {
            string = i != 0 ? string + "; " + stackTraceElementArray[i].toString() : stackTraceElementArray[i].toString();
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static IniFile getInstance(String string, boolean bl) {
        timeOutPeriod = si.getIniSyncPeriod();
        threadSleepPeriod = si.getIniSyncSleep();
        IniFile iniFile = null;
        boolean bl2 = false;
        Thread thread = Thread.currentThread();
        long l = System.currentTimeMillis();
        int n = 0;
        while (true) {
            Object object;
            long l2 = System.currentTimeMillis();
            if (getstack && l2 - l > 30000L && n == 0) {
                ++n;
                System.out.println("******* Taken > 30 secs for " + string + " Currently held by " + aliveStack.get(string));
            }
            if (getstack && l2 - l > 60000L && n == 1) {
                ++n;
                System.out.println("******* Taken > 60 secs for " + string + " Currently held by " + aliveStack.get(string));
            }
            String string2 = (String)aliveFileTime.get(string);
            if (bl2 || string2 != null) {
                bl2 = false;
                object = (Thread)aliveThreads.get(string);
                if (object != null && object == thread) {
                    iniFile = (IniFile)aliveFileInstances.get(string);
                    String string3 = (String)aliveInstanceCount.get(string);
                    int n2 = Integer.parseInt(string3);
                    aliveInstanceCount.put(string, ++n2 + "");
                    return iniFile;
                }
                object = string2;
                if (object != null) {
                    long l3 = Long.parseLong((String)object);
                    long l4 = System.currentTimeMillis();
                    if (l4 > l3 + timeOutPeriod) {
                        String string4 = sync;
                        synchronized (string4) {
                            object = (String)aliveFileTime.get(string);
                            if (object == null) {
                                aliveFileTime.put(string, System.currentTimeMillis() + "");
                                iniFile = new IniFile(string, bl);
                                aliveFileInstances.put(string, iniFile);
                                aliveThreads.put(string, thread);
                                if (getstack) {
                                    aliveStack.put(string, EgConfigFilesSync.getStackTrace());
                                }
                                aliveInstanceCount.put(string, "1");
                                return iniFile;
                            }
                            l3 = Long.parseLong((String)object);
                            l4 = System.currentTimeMillis();
                            if (l4 > l3 + timeOutPeriod) {
                                aliveFileTime.put(string, System.currentTimeMillis() + "");
                                iniFile = new IniFile(string, bl);
                                aliveFileInstances.put(string, iniFile);
                                aliveThreads.put(string, thread);
                                if (getstack) {
                                    aliveStack.put(string, EgConfigFilesSync.getStackTrace());
                                }
                                aliveInstanceCount.put(string, "1");
                                return iniFile;
                            }
                        }
                    }
                    try {
                        Thread.sleep(threadSleepPeriod);
                    }
                    catch (Exception exception) {}
                    continue;
                }
            }
            object = sync;
            synchronized (object) {
                if (!aliveFileTime.containsKey(string)) break;
                bl2 = true;
            }
        }
        {
            aliveFileTime.put(string, System.currentTimeMillis() + "");
            iniFile = new IniFile(string, bl);
            aliveFileInstances.put(string, iniFile);
            aliveThreads.put(string, thread);
            if (getstack) {
                aliveStack.put(string, EgConfigFilesSync.getStackTrace());
            }
            aliveInstanceCount.put(string, "1");
            return iniFile;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static IniFile getInstance(String string, boolean bl, boolean bl2) {
        timeOutPeriod = si.getIniSyncPeriod();
        threadSleepPeriod = si.getIniSyncSleep();
        IniFile iniFile = null;
        boolean bl3 = false;
        Thread thread = Thread.currentThread();
        long l = System.currentTimeMillis();
        int n = 0;
        while (true) {
            Object object;
            long l2 = System.currentTimeMillis();
            if (getstack && l2 - l > 30000L && n == 0) {
                ++n;
                System.out.println("******* Taken > 30 secs for " + string + " Currently held by " + aliveStack.get(string));
            }
            if (getstack && l2 - l > 60000L && n == 1) {
                ++n;
                System.out.println("******* Taken > 60 secs for " + string + " Currently held by " + aliveStack.get(string));
            }
            String string2 = (String)aliveFileTime.get(string);
            if (bl3 || string2 != null) {
                bl3 = false;
                object = (Thread)aliveThreads.get(string);
                if (object != null && object == thread) {
                    iniFile = (IniFile)aliveFileInstances.get(string);
                    String string3 = (String)aliveInstanceCount.get(string);
                    int n2 = Integer.parseInt(string3);
                    aliveInstanceCount.put(string, ++n2 + "");
                    return iniFile;
                }
                object = string2;
                if (object != null) {
                    long l3 = Long.parseLong((String)object);
                    long l4 = System.currentTimeMillis();
                    if (l4 > l3 + timeOutPeriod) {
                        String string4 = sync;
                        synchronized (string4) {
                            object = (String)aliveFileTime.get(string);
                            if (object == null) {
                                aliveFileTime.put(string, System.currentTimeMillis() + "");
                                iniFile = new IniFile(string, bl, bl2);
                                aliveFileInstances.put(string, iniFile);
                                aliveThreads.put(string, thread);
                                if (getstack) {
                                    aliveStack.put(string, EgConfigFilesSync.getStackTrace());
                                }
                                aliveInstanceCount.put(string, "1");
                                return iniFile;
                            }
                            l3 = Long.parseLong((String)object);
                            l4 = System.currentTimeMillis();
                            if (l4 > l3 + timeOutPeriod) {
                                aliveFileTime.put(string, System.currentTimeMillis() + "");
                                iniFile = new IniFile(string, bl, bl2);
                                aliveFileInstances.put(string, iniFile);
                                aliveThreads.put(string, thread);
                                if (getstack) {
                                    aliveStack.put(string, EgConfigFilesSync.getStackTrace());
                                }
                                aliveInstanceCount.put(string, "1");
                                return iniFile;
                            }
                        }
                    }
                    try {
                        Thread.sleep(threadSleepPeriod);
                    }
                    catch (Exception exception) {}
                    continue;
                }
            }
            object = sync;
            synchronized (object) {
                if (!aliveFileTime.containsKey(string)) break;
                bl3 = true;
            }
        }
        {
            aliveFileTime.put(string, System.currentTimeMillis() + "");
            iniFile = new IniFile(string, bl, bl2);
            aliveFileInstances.put(string, iniFile);
            aliveThreads.put(string, thread);
            if (getstack) {
                aliveStack.put(string, EgConfigFilesSync.getStackTrace());
            }
            aliveInstanceCount.put(string, "1");
            return iniFile;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void releaseInstance(String string) {
        String string2 = sync;
        synchronized (string2) {
            int n = 0;
            String string3 = (String)aliveInstanceCount.get(string);
            if (string3 != null) {
                n = Integer.parseInt(string3);
                aliveInstanceCount.put(string, --n + "");
            }
            if (n == 0) {
                aliveFileTime.remove(string);
                aliveFileInstances.remove(string);
                aliveInstanceCount.remove(string);
                aliveThreads.remove(string);
                if (getstack) {
                    aliveStack.remove(string);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void releaseInstance(IniFile iniFile) {
        String string = sync;
        synchronized (string) {
            int n = 0;
            Enumeration enumeration = aliveFileInstances.keys();
            while (enumeration.hasMoreElements()) {
                IniFile iniFile2;
                String string2 = (String)enumeration.nextElement();
                IniFile iniFile3 = (IniFile)aliveFileInstances.get(string2);
                if (iniFile3 != iniFile) continue;
                boolean bl = false;
                String string3 = (String)aliveInstanceCount.get(string2);
                if (string3 != null) {
                    n = Integer.parseInt(string3);
                    aliveInstanceCount.put(string2, --n + "");
                    bl = true;
                }
                if (n == 0 && (iniFile2 = (IniFile)aliveFileInstances.get(string2)) != null && iniFile != null && iniFile2 == iniFile) {
                    aliveFileTime.remove(string2);
                    aliveFileInstances.remove(string2);
                    aliveThreads.remove(string2);
                    if (getstack) {
                        aliveStack.remove(string2);
                    }
                    aliveInstanceCount.remove(string2);
                    break;
                }
                if (!bl) continue;
                break;
            }
        }
    }

    public static void main(String[] stringArray) {
        EgConfigInfo egConfigInfo = new EgConfigInfo("manager");
        String string = egConfigInfo.getDiscoveryFile();
        try {
            IniFile iniFile = EgConfigFilesSync.getInstance(string, false);
            System.out.println("Creating first Instance _____" + iniFile);
            IniFile iniFile2 = EgConfigFilesSync.getInstance(string, false);
            System.out.println("Creating 2nd Instance _____" + iniFile2);
            IniFile iniFile3 = EgConfigFilesSync.getInstance(string, false);
            System.out.println("Creating 3rd Instance _____" + iniFile3);
            IniFile iniFile4 = EgConfigFilesSync.getInstance(string, false);
            System.out.println("Creating 4th Instance _____" + iniFile4);
            IniFile iniFile5 = EgConfigFilesSync.getInstance(string, false);
            System.out.println("Creating 5th Instance _____" + iniFile5);
            EgConfigFilesSync.releaseInstance(iniFile);
            EgConfigFilesSync.releaseInstance(iniFile2);
            EgConfigFilesSync.releaseInstance(iniFile3);
            EgConfigFilesSync.releaseInstance(iniFile4);
            EgConfigFilesSync.releaseInstance(iniFile5);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

