/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.net.ftp.parser;

import java.util.Calendar;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.parser.RegexFTPFileEntryParserImpl;

public class OS400FTPEntryParser
extends RegexFTPFileEntryParserImpl {
    private static final String REGEX = "(\\S+)\\s+(\\d+)\\s+(\\d\\d)/(\\d\\d)/(\\d\\d)\\s+([0-2][0-9]):([0-5][0-9]):([0-5][0-9])\\s+(\\*\\S+)\\s+(\\S+/?)\\s*";

    public OS400FTPEntryParser() {
        super(REGEX);
    }

    public FTPFile parseFTPEntry(String entry) {
        FTPFile file = new FTPFile();
        file.setRawListing(entry);
        if (this.matches(entry)) {
            int pos;
            String usr = this.group(1);
            String filesize = this.group(2);
            String yr = this.group(3);
            String mo = this.group(4);
            String da = this.group(5);
            String hr = this.group(6);
            String min = this.group(7);
            String sec = this.group(8);
            String typeStr = this.group(9);
            String name = this.group(10);
            int type = typeStr.equalsIgnoreCase("*STMF") ? 0 : (typeStr.equalsIgnoreCase("*DIR") ? 1 : 3);
            file.setType(type);
            file.setUser(usr);
            try {
                file.setSize(Long.parseLong(filesize));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            Calendar cal = Calendar.getInstance();
            cal.set(14, 0);
            cal.set(13, 0);
            cal.set(12, 0);
            cal.set(11, 0);
            try {
                int year = Integer.parseInt(yr, 10);
                year = year < 70 ? (year += 2000) : (year += 1900);
                cal.set(1, year);
                cal.set(2, Integer.parseInt(mo, 10) - 1);
                cal.set(5, Integer.parseInt(da, 10));
                cal.set(11, Integer.parseInt(hr, 10));
                cal.set(12, Integer.parseInt(min, 10));
                cal.set(13, Integer.parseInt(sec, 10));
                file.setTimestamp(cal);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            if (name.endsWith("/")) {
                name = name.substring(0, name.length() - 1);
            }
            if ((pos = name.lastIndexOf(47)) > -1) {
                name = name.substring(pos + 1);
            }
            file.setName(name);
            return file;
        }
        return null;
    }
}

