/*
 * Decompiled with CFR 0.152.
 */
package com.objectplanet.chart;

import com.objectplanet.chart.ChartSample;
import java.io.Serializable;
import java.util.Hashtable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ChartData
implements Serializable {
    private ChartSample[][] try;
    private Hashtable if;
    private String[] new;
    private String[] int;
    private int for;
    private int a;
    private long do;

    public ChartData(int n, int n2) {
        int n3;
        this.for = Math.max(0, n);
        this.a = Math.max(0, n2);
        this.try = new ChartSample[this.for][];
        for (n3 = 0; n3 < this.try.length; ++n3) {
            this.try[n3] = new ChartSample[this.a];
        }
        this.new = new String[this.for];
        this.int = new String[this.a];
        n3 = Math.max(1, n2) * Math.max(1, n);
        this.if = new Hashtable(n3);
        this.do = System.currentTimeMillis();
    }

    public void setSamples(int n, ChartSample[] chartSampleArray) {
        if (n < 0 || n >= this.try.length) {
            throw new IllegalArgumentException("Invalid series: " + n);
        }
        if (this.try[n] == null || chartSampleArray == null) {
            this.try[n] = new ChartSample[this.a];
        }
        if (chartSampleArray != null) {
            for (int i = 0; i < this.a; ++i) {
                if (i >= chartSampleArray.length || chartSampleArray[i] == null) continue;
                chartSampleArray[i].setIndex(i);
                chartSampleArray[i].setSeries(n);
                this.try[n][i] = chartSampleArray[i];
                if (chartSampleArray[i].if == null) {
                    chartSampleArray[i].if = n + "." + i;
                }
                this.if.put(chartSampleArray[i].if, chartSampleArray[i]);
            }
        }
        this.a();
        this.do = System.currentTimeMillis();
    }

    public ChartSample[] getSamples(int n) {
        try {
            return this.try[n];
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new IllegalArgumentException("Invalid series: " + n);
        }
    }

    public void setSample(int n, int n2, ChartSample chartSample) {
        if (n < 0 || n >= this.try.length) {
            throw new IllegalArgumentException("Invalid series: " + n);
        }
        try {
            chartSample.setIndex(n2);
            chartSample.setSeries(n);
            this.try[n][n2] = chartSample;
            if (chartSample.if == null) {
                chartSample.if = n + "." + n2;
            }
            this.if.put(chartSample.if, chartSample);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new IllegalArgumentException("Invalid index: " + n2);
        }
        catch (NullPointerException nullPointerException) {
            System.out.println("Internal error: setSample(serie, index, sample) method");
        }
        this.if(n, n2);
        this.do = System.currentTimeMillis();
    }

    public ChartSample getSample(int n, int n2) {
        if (n < 0 || n >= this.try.length) {
            throw new IllegalArgumentException("Invalid series: " + n);
        }
        try {
            return this.try[n][n2];
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new IllegalArgumentException("Invalid index: " + n2);
        }
        catch (NullPointerException nullPointerException) {
            System.out.println("Internal error: getSample(serie, index");
            return null;
        }
    }

    public ChartSample getSample(Object object) {
        return (ChartSample)this.if.get(object);
    }

    public void setSampleValues(int n, double[] dArray) {
        if (n < 0 || n >= this.try.length) {
            throw new IllegalArgumentException("Invalid series: " + n);
        }
        if (this.try[n] == null || dArray == null) {
            this.try[n] = new ChartSample[this.a];
        }
        if (dArray != null) {
            for (int i = 0; i < this.a && i < this.try[n].length; ++i) {
                double d = Double.NaN;
                if (i < dArray.length) {
                    d = dArray[i];
                }
                if (this.try[n][i] == null) {
                    this.try[n][i] = new ChartSample(i);
                    this.try[n][i].setSeries(n);
                    this.try[n][i].if = n + "." + i;
                    this.if.put(this.try[n][i].if, this.try[n][i]);
                }
                this.try[n][i].setValue(d);
            }
        }
        this.a();
        this.do = System.currentTimeMillis();
    }

    public double[] getSampleValues(int n) {
        try {
            ChartSample[] chartSampleArray = this.try[n];
            double[] dArray = new double[chartSampleArray.length];
            for (int i = 0; i < chartSampleArray.length; ++i) {
                dArray[i] = chartSampleArray[i] != null && chartSampleArray[i].value != null && !chartSampleArray[i].value.isNaN() ? chartSampleArray[i].getFloatValue() : Double.NaN;
            }
            return dArray;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new IllegalArgumentException("Invalid series: " + n);
        }
        catch (Exception exception) {
            System.out.println("Internal error: ChartData.getSampleValues(serie)");
            return null;
        }
    }

    public void setSampleValue(int n, int n2, double d) {
        if (n < 0 || n >= this.try.length) {
            throw new IllegalArgumentException("Invalid series: " + n);
        }
        try {
            if (this.try[n][n2] == null) {
                this.try[n][n2] = new ChartSample(n2);
                this.try[n][n2].setSeries(n);
                this.try[n][n2].if = n + "." + n2;
                this.if.put(this.try[n][n2].if, this.try[n][n2]);
            }
            this.try[n][n2].setValue(d);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new IllegalArgumentException("Invalid index: " + n2);
        }
        catch (NullPointerException nullPointerException) {
            System.out.println("Internal error: setSampleValue(serie, index, value) method");
        }
        this.if(n, n2);
        this.do = System.currentTimeMillis();
    }

    public double getSampleValue(int n, int n2) {
        if (n < 0 || n >= this.try.length) {
            throw new IllegalArgumentException("Invalid series: " + n);
        }
        if (this.try[n] == null) {
            return Double.NaN;
        }
        if (n2 < 0 || n2 >= this.try[n].length) {
            throw new IllegalArgumentException("Invalid index: " + n2);
        }
        if (this.try[n][n2] != null) {
            return this.try[n][n2].getFloatValue();
        }
        return Double.NaN;
    }

    public int appendSample(int n, ChartSample chartSample, boolean bl) {
        int n2;
        if (n < 0 || n >= this.for) {
            throw new IllegalArgumentException("Illegal serie: " + n);
        }
        this.do = System.currentTimeMillis();
        int n3 = -1;
        for (n2 = 0; n2 < this.a; ++n2) {
            ChartSample chartSample2 = this.try[n][n2];
            if (chartSample2 != null && chartSample2.value != null) continue;
            n3 = n2;
            break;
        }
        if (n3 >= 0) {
            this.setSample(n, n3, chartSample);
            return n3;
        }
        if (bl) {
            n2 = this.a;
            this.setSampleCount(n2 + 1);
            this.setSample(n, n2, chartSample);
            return n2;
        }
        if (this.a > 0) {
            for (n2 = 0; n2 < this.try[n].length - 1; ++n2) {
                this.try[n][n2] = this.try[n][n2 + 1];
            }
            this.setSample(n, this.a - 1, chartSample);
            return this.a - 1;
        }
        return -1;
    }

    public int appendSampleValue(int n, double d, boolean bl) {
        Object object;
        int n2;
        if (n < 0 || n >= this.for) {
            throw new IllegalArgumentException("Illegal serie: " + n);
        }
        this.do = System.currentTimeMillis();
        int n3 = -1;
        for (n2 = 0; n2 < this.a; ++n2) {
            object = this.try[n][n2];
            if (object != null && ((ChartSample)object).hasValue()) continue;
            n3 = n2;
            break;
        }
        n2 = n3;
        if (n3 >= 0) {
            this.setSampleValue(n, n3, d);
        } else if (bl) {
            int n4 = this.a;
            this.setSampleCount(n4 + 1);
            this.setSampleValue(n, n4, d);
            n2 = n4;
        } else if (this.a > 0) {
            object = this.getSampleValues(n);
            for (int i = 0; i < ((Object)object).length - 1; ++i) {
                object[i] = object[i + 1];
            }
            object[((Object)object).length - 1] = d;
            this.setSampleValues(n, (double[])object);
            n2 = ((Object)object).length - 1;
        }
        return n2;
    }

    public int appendSampleLabel(String string, boolean bl) {
        int n;
        this.do = System.currentTimeMillis();
        int n2 = -1;
        int n3 = this.getSampleCount();
        if (this.int != null) {
            for (n = 0; n < n3; ++n) {
                if (this.getSampleLabel(n) != null) continue;
                n2 = n;
                break;
            }
        }
        n = n2;
        if (n2 >= 0) {
            this.setSampleLabel(n2, string);
        } else if (bl) {
            this.setSampleLabel(this.int.length, string);
            n = this.int.length;
        } else if (n3 > 0) {
            for (int i = 0; i < this.int.length - 1; ++i) {
                this.int[i] = this.int[i + 1];
            }
            this.int[this.int.length - 1] = string;
            n = this.int.length - 1;
        }
        return n;
    }

    public void setSampleLabels(String[] stringArray) {
        if (stringArray != null && stringArray.length > this.int.length) {
            this.int = new String[stringArray.length];
        }
        int n = Math.max(stringArray != null ? stringArray.length : 0, this.int.length);
        for (int i = 0; i < n; ++i) {
            if (i >= this.int.length) continue;
            this.int[i] = stringArray == null ? null : (i < stringArray.length ? stringArray[i] : null);
        }
        this.a();
        this.do = System.currentTimeMillis();
    }

    public String[] getSampleLabels() {
        if (this.int != null) {
            return this.int;
        }
        return new String[0];
    }

    public void setSampleLabel(int n, String string) {
        int n2;
        if (n < 0) {
            return;
        }
        if (this.int == null || n >= this.int.length) {
            n2 = Math.max(this.getSampleCount(), n + 1);
            String[] stringArray = new String[n2];
            if (this.int != null) {
                System.arraycopy(this.int, 0, stringArray, 0, Math.min(n2, this.int.length));
            }
            this.int = stringArray;
        }
        this.int[n] = string;
        for (n2 = 0; n2 < this.for; ++n2) {
            this.if(n2, n);
        }
        this.do = System.currentTimeMillis();
    }

    public String getSampleLabel(int n) {
        try {
            return this.int[n];
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new IllegalArgumentException("Invalid index: " + n);
        }
    }

    public void setSeriesLabels(String[] stringArray) {
        for (int i = 0; i < this.for; ++i) {
            this.new[i] = stringArray == null ? null : (i < stringArray.length ? stringArray[i] : null);
        }
        this.a();
        this.do = System.currentTimeMillis();
    }

    public String[] getSeriesLabels() {
        String[] stringArray = new String[this.for];
        System.arraycopy(this.new, 0, stringArray, 0, stringArray.length);
        return stringArray;
    }

    public void setSeriesLabel(int n, String string) {
        try {
            this.new[n] = string;
            for (int i = 0; i < this.a; ++i) {
                this.if(n, i);
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new IllegalArgumentException("Invalid series: " + n);
        }
        this.do = System.currentTimeMillis();
    }

    public String getSeriesLabel(int n) {
        try {
            return this.new[n];
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new IllegalArgumentException("Invalid series: " + n);
        }
    }

    public void setSelection(int n, int n2, boolean bl) {
        this.a(n, n2, bl, false);
    }

    void a(int n, int n2, boolean bl, boolean bl2) {
        if (bl2) {
            this.a(false);
        }
        if (n == -1 && n2 == -1) {
            for (int i = 0; i < this.for; ++i) {
                for (int j = 0; j < this.a; ++j) {
                    if (this.try[i] == null || this.try[i][j] == null) continue;
                    this.try[i][j].setSelection(bl);
                }
            }
        } else if (n == -1) {
            for (int i = 0; i < this.for; ++i) {
                if (this.try[i] == null || n2 < 0 || n2 >= this.try[i].length || this.try[i][n2] == null) continue;
                this.try[i][n2].setSelection(bl);
            }
        } else if (n2 == -1) {
            for (int i = 0; i < this.a; ++i) {
                if (n < 0 || n >= this.try.length || this.try[n] == null || this.try[n][i] == null) continue;
                this.try[n][i].setSelection(bl);
            }
        } else if (this.try != null && n >= 0 && n < this.try.length && this.try[n] != null && n2 >= 0 && n2 < this.try[n].length && this.try[n][n2] != null) {
            this.try[n][n2].setSelection(bl);
        }
        this.do = System.currentTimeMillis();
    }

    private void a(boolean bl) {
        for (int i = 0; i < this.for; ++i) {
            for (int j = 0; j < this.a; ++j) {
                try {
                    if (this.try[i] == null || this.try[i][j] == null) continue;
                    this.try[i][j].setSelection(bl);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        this.do = System.currentTimeMillis();
    }

    public boolean isSelected(int n, int n2) {
        if (n < -1 || n >= this.for) {
            throw new IllegalArgumentException("Invalid series index: " + n);
        }
        if (n2 < -1 || n2 >= this.a) {
            throw new IllegalArgumentException("Invalid sample index: " + n2);
        }
        boolean bl = true;
        if (this.try != null && n == -1 && n2 == -1) {
            for (int i = 0; i < this.for && i < this.try.length; ++i) {
                for (int j = 0; j < this.a; ++j) {
                    if (this.try[i] != null && this.try[i][j] != null && this.try[i][j].isSelected()) continue;
                    bl = false;
                }
            }
        } else if (this.try != null && n2 == -1 && n >= 0) {
            for (int i = 0; i < this.a; ++i) {
                if (n >= this.try.length || this.try[n] == null || i >= this.try[n].length || this.try[n][i] == null || this.try[n][i].isSelected()) continue;
                bl = false;
            }
        } else if (this.try != null && n == -1) {
            for (int i = 0; i < this.for && i < this.try.length; ++i) {
                if (this.try[i] == null || n2 >= this.try[i].length || this.try[i][n2] == null || this.try[i][n2].isSelected()) continue;
                bl = false;
            }
        } else if (!(this.try == null || this.try[n] != null && this.try[n][n2] != null && this.try[n][n2].isSelected())) {
            bl = false;
        }
        return bl;
    }

    public void setSeriesCount(int n) {
        this.a(n, this.a);
    }

    public int getSeriesCount() {
        return this.for;
    }

    public void setSampleCount(int n) {
        this.a(this.for, n);
    }

    public int getSampleCount() {
        return this.a;
    }

    public double getMaxValue(int n) {
        boolean bl = n >= 0 && n < this.for;
        boolean bl2 = false;
        double d = -1.7976931348623157E308;
        if (bl) {
            for (int i = 0; i < this.a; ++i) {
                ChartSample chartSample = this.try[n][i];
                if (chartSample == null || chartSample.value == null || chartSample.value.isNaN()) continue;
                d = Math.max(d, chartSample.getFloatValue());
                bl2 = true;
            }
        } else {
            for (int i = 0; i < this.for; ++i) {
                for (int j = 0; j < this.a; ++j) {
                    ChartSample chartSample = this.try[i][j];
                    if (chartSample == null || chartSample.value == null || chartSample.value.isNaN()) continue;
                    d = Math.max(d, chartSample.getFloatValue());
                    bl2 = true;
                }
            }
        }
        if (bl2) {
            return d;
        }
        return 0.0;
    }

    public double getMinValue(int n) {
        boolean bl = n >= 0 && n < this.for;
        boolean bl2 = false;
        double d = Double.MAX_VALUE;
        if (bl) {
            for (int i = 0; i < this.a; ++i) {
                ChartSample chartSample = this.try[n][i];
                if (chartSample == null || chartSample.value == null || chartSample.value.isNaN()) continue;
                d = Math.min(d, chartSample.getFloatValue());
                bl2 = true;
            }
        } else {
            for (int i = 0; i < this.for; ++i) {
                for (int j = 0; j < this.a; ++j) {
                    ChartSample chartSample = this.try[i][j];
                    if (chartSample == null || chartSample.value == null || chartSample.value.isNaN()) continue;
                    d = Math.min(d, chartSample.getFloatValue());
                    bl2 = true;
                }
            }
        }
        if (bl2) {
            return d;
        }
        return 0.0;
    }

    public boolean hasChangedSince(long l) {
        return this.do >= l;
    }

    public String toString() {
        return "ChartData " + this.for + " series, " + this.a + " samples";
    }

    private void a(int n, int n2) {
        int n3;
        if (this.for == n && this.a == n2) {
            return;
        }
        this.for = Math.max(0, n);
        this.a = Math.max(0, n2);
        ChartSample[][] chartSampleArray = new ChartSample[this.for][this.a];
        for (int i = 0; i < chartSampleArray.length; ++i) {
            if (i >= this.try.length) continue;
            ChartSample[] chartSampleArray2 = chartSampleArray[i];
            for (n3 = 0; n3 < chartSampleArray2.length; ++n3) {
                if (n3 >= this.try[i].length) continue;
                chartSampleArray[i][n3] = this.try[i][n3];
            }
        }
        this.try = chartSampleArray;
        String[] stringArray = new String[this.for];
        for (int i = 0; i < stringArray.length; ++i) {
            if (i >= this.new.length) continue;
            stringArray[i] = this.new[i];
        }
        this.new = stringArray;
        String[] stringArray2 = new String[this.a];
        for (n3 = 0; n3 < stringArray2.length; ++n3) {
            if (n3 >= this.int.length) continue;
            stringArray2[n3] = this.int[n3];
        }
        this.int = stringArray2;
        this.do = System.currentTimeMillis();
    }

    private void if(int n, int n2) {
        ChartSample chartSample;
        if (this.try != null && n < this.try.length && this.try[n] != null && n2 < this.try[n].length && (chartSample = this.try[n][n2]) != null) {
            String string = this.new[n];
            String string2 = null;
            if (n2 < this.int.length) {
                string2 = this.int[n2];
            }
            String string3 = "";
            if (string != null && string2 != null) {
                string3 = string + " " + string2;
            } else if (string != null) {
                string3 = string;
            } else if (string2 != null) {
                string3 = string2;
            }
            chartSample.setLabel(string3);
        }
    }

    private void a() {
        for (int i = 0; i < this.for; ++i) {
            ChartSample[] chartSampleArray = this.try[i];
            if (chartSampleArray == null) continue;
            for (int j = 0; j < chartSampleArray.length; ++j) {
                if (chartSampleArray[j] == null) continue;
                String string = this.new[i];
                String string2 = this.int[j];
                if (string != null && string2 != null) {
                    chartSampleArray[j].setLabel(string + " " + string2);
                    continue;
                }
                if (string != null) {
                    chartSampleArray[j].setLabel(string);
                    continue;
                }
                if (string2 == null) continue;
                chartSampleArray[j].setLabel(string2);
            }
        }
    }
}

